#ifndef ZETA_STM_KINETIC_UVC_H_
#define ZETA_STM_KINETIC_UVC_H_

#include "std_msgs/Bool.h"
#include "pinConfig.h"
#include "ros.h"
extern ros::NodeHandle nh;

// this class control 4 modules
class UVC {
    private:
        std_msgs::Bool* msg;
    
        //const variables
        const int _On                     = 1;
        const int _Off                    = 0;
        const bool _Run                   = true;
        const bool _Stop                  = false;
        
        DigitalOut uvc_p;
        DigitalOut uvc_n;
        
    public:
        UVC(PinName uvc_pin_p, PinName uvc_pin_n):
            uvc_p(uvc_pin_p,_Off),uvc_n(uvc_pin_n,_Off)
            {
                Init();
            }
        void InitUVC();
        void Init();
        void ControlUVC();
        void setMsg(std_msgs::Bool* msg);
        void control();
};

#endif
// EOF
