#include "PMS.h"

PMS::PMS(RawSerial& stream)
{
  this->_stream = &stream;
  _data = new DATA;
}

PMS::PMS(PinName tx, PinName rx) {
    this->_stream = new RawSerial(tx,rx,BAUD_RATE);
    _data = new DATA;
}

void PMS::begin(DATA& data) {
    _stream -> baud(BAUD_RATE);
    _tmr.start();
    _stream -> attach(callback(this,&PMS::RxInterrupt), Serial::RxIrq);
    _data = &data;
}

// Active mode. Default mode after power up. In this mode sensor would send serial data to the host automatically.
void PMS::activeMode()
{
  const char command[] = { 0x42, 0x4D, 0xE1, 0x00, 0x01, 0x01, 0x71 };
  for(int i = 0; i < sizeof(command); i++)
  {
    // bug: mcu stop after this transmitt
    //_stream -> putc(command[i]);
  }
  _mode = MODE_ACTIVE;
}

void PMS::passiveMode()
{
  const char command[] = { 0x42, 0x4D, 0xE1, 0x00, 0x00, 0x01, 0x70 };
  for(int i = 0; i < sizeof(command); i++)
  {
    //_stream -> putc(command[i]);
  }
  _mode = MODE_PASSIVE;
}

// Request read in Passive Mode.
void PMS::requestRead()
{
  if (_mode == MODE_PASSIVE)
  {
    const char command[] = { 0x42, 0x4D, 0xE2, 0x00, 0x00, 0x01, 0x71 };
    for(int i = 0; i < sizeof(command); i++)
    {
         _stream -> putc(command[i]);
    }
  }
}

// Non-blocking function for parse response.
bool PMS::available()
{
    Caculate();
    return _status;
}

void PMS::Caculate()
{
    _status = STATUS_WAITING;
    for(int i = 0; i < 32; i++)
    {
      uint8_t ch = buf[i];
      switch (i)
      {
      case 0:
        if (ch != 0x42)
        {
          return;
        }
        _calculatedChecksum = ch;
        break;

      case 1:
        if (ch != 0x4D)
        {

          return;
        }
        _calculatedChecksum += ch;
        break;
        
      case 2:
        _calculatedChecksum += ch;
        _frameLen = ch << 8;
        break;

      case 3:
        _frameLen |= ch;
      // Unsupported sensor, different frame length, transmission error e.t.c.
        if (_frameLen != 2 * 9 + 2 && _frameLen != 2 * 13 + 2)
        {

          return;
        }
        _calculatedChecksum += ch;
        break;

      default:
        if (i == _frameLen + 2)
        {
          _checksum = ch << 8;
        }
        else if (i == _frameLen + 2 + 1)
        {
          _checksum |= ch;
          if (_calculatedChecksum == _checksum)
          {
            _status = STATUS_OK;

          // Standard Particles, CF=1.
            _data->PM_SP_UG_1_0 = makeWord(_payload[0], _payload[1]);
            _data->PM_SP_UG_2_5 = makeWord(_payload[2], _payload[3]);
            _data->PM_SP_UG_10_0 = makeWord(_payload[4], _payload[5]);
          // Atmospheric Environment.
            _data->PM_AE_UG_1_0 = makeWord(_payload[6], _payload[7]);
            _data->PM_AE_UG_2_5 = makeWord(_payload[8], _payload[9]);
            _data->PM_AE_UG_10_0 = makeWord(_payload[10], _payload[11]);
          }
          return;
          }
          else
          {
            _calculatedChecksum += ch;
            uint8_t payloadIndex = i - 4;
        // Payload is common to all sensors (first 2x6 bytes).
            if (payloadIndex < sizeof(_payload))
            {
              _payload[payloadIndex] = ch;
            }
          }
          break;
        }
    }
}

uint16_t PMS::makeWord(uint8_t high, uint8_t low) {
    return (high << 8) | low;
}

void PMS::RxInterrupt()
{
    int cnt = 0;
    while(_stream -> readable() || cnt < 32)
    {
        //if(cnt >= DUST_BUFFER) break;
        buf[cnt++] = _stream -> getc();
    }
}