#ifndef PMS_H
#define PMS_H

#include "mbed.h"
#define DUST_BUFFER 64
class PMS
{
public:
  static const uint16_t SINGLE_RESPONSE_TIME = 1000;
  static const uint16_t TOTAL_RESPONSE_TIME = 1000 * 10;
  static const uint16_t STEADY_RESPONSE_TIME = 1000 * 30;

  static const uint16_t BAUD_RATE = 9600;

  struct DATA {
    // Standard Particles, CF=1
    uint16_t PM_SP_UG_1_0;
    uint16_t PM_SP_UG_2_5;
    uint16_t PM_SP_UG_10_0;

    // Atmospheric environment
    uint16_t PM_AE_UG_1_0;
    uint16_t PM_AE_UG_2_5;
    uint16_t PM_AE_UG_10_0;
  };

  PMS(RawSerial&);
  PMS(PinName tx, PinName rx);
  ~PMS() { 
    delete _stream;
    delete _data; 
  }
  void begin(DATA&);
  void activeMode();
  void passiveMode();
  void requestRead();
  bool available();
private:
  enum STATUS { STATUS_WAITING, STATUS_OK };
  enum MODE { MODE_ACTIVE, MODE_PASSIVE };

  uint8_t _payload[12];
  RawSerial* _stream;
  Timer _tmr;
  DATA* _data;
  volatile STATUS _status;
  MODE _mode = MODE_PASSIVE;
  volatile char buf[DUST_BUFFER];
  uint8_t _index = 0;
  uint16_t _frameLen;
  uint16_t _checksum;
  uint16_t _calculatedChecksum;

  uint16_t makeWord(uint8_t high, uint8_t low);

  void RxInterrupt();
  void Caculate();
};

#endif
