#include "mbed.h"
#include "EthernetNetIf.h"
//#include "HTTPServer.h"
#include "TextLCD.h"
#include "mbedServer.h"

EthernetNetIf *eth;
IpAddr ipaddr, netmask, gateway, nameserver;

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut power(p10);


TextLCD lcd(p24, p26, p27, p28, p29, p30); // rs, e, d0-d3 
LocalFileSystem local("local");

char word[4][16] = {"IPAddress","NetworkMask", "Gateway", "DomainName"}; 
int ipe[4][12]={{0},{0},{0},{0}};


void ipe_print(int mode){
    lcd.locate(0,1);
    lcd.printf("%1d%1d%1d.%1d%1d%1d.%1d%1d%1d.%1d%1d%1d",
    ipe[mode][0],ipe[mode][1],ipe[mode][2],
    ipe[mode][3],ipe[mode][4],ipe[mode][5],
    ipe[mode][6],ipe[mode][7],ipe[mode][8],
    ipe[mode][9],ipe[mode][10],ipe[mode][11]);
};


void ipe_input(int mode, int ip0, int ip1, int ip2, int ip3){
    int tmp[4]={ip0, ip1, ip2, ip3};
    
    ipe[mode][2] = tmp[0]%10;   tmp[0]=tmp[0]/10; // 1keta
    ipe[mode][1] = tmp[0]%10;   tmp[0]=tmp[0]/10; // 2keta
    ipe[mode][0] = tmp[0]%10;   tmp[0]=tmp[0]/10; // 3keta

    ipe[mode][5] = tmp[1]%10;   tmp[1]=tmp[1]/10; // 1keta
    ipe[mode][4] = tmp[1]%10;   tmp[1]=tmp[1]/10; // 2keta
    ipe[mode][3] = tmp[1]%10;   tmp[1]=tmp[1]/10; // 3keta

    ipe[mode][8] = tmp[2]%10;   tmp[2]=tmp[2]/10; // 1keta
    ipe[mode][7] = tmp[2]%10;   tmp[2]=tmp[2]/10; // 2keta
    ipe[mode][6] = tmp[2]%10;   tmp[2]=tmp[2]/10; // 3keta

    ipe[mode][11] = tmp[3]%10;   tmp[3]=tmp[3]/10; // 1keta
    ipe[mode][10] = tmp[3]%10;   tmp[3]=tmp[3]/10; // 2keta
    ipe[mode][9] = tmp[3]%10;   tmp[3]=tmp[3]/10; // 3keta
    
}


int config_write(char filename[32]){
    FILE *conf_fp;
    int i, j;
    int ip;
    char str[32];

    sprintf(str,"/local/%s",filename);
    conf_fp = fopen(str,"w");    
    
    if(NULL == conf_fp){
        lcd.printf("File access error");
        return -1;
    }

    for(i=0; i<4; i++){
        fprintf(conf_fp,"%s ",word[i]);

        for(j=0; j<12; j= j+3){
            ip = 100*ipe[i][j] + 10*ipe[i][j+1] + ipe[i][j+2];
            fprintf(conf_fp,"%3d,",ip);
        }
        fprintf(conf_fp,"\n");
    }
  
    fclose(conf_fp);
    return 0;    
}



int config_read(char filename[32]){
    FILE *conf_fp;
    char buf[80], name[16];
    char str[32];
    int ip0, ip1, ip2, ip3;

    sprintf(str,"/local/%s",filename);
    conf_fp = fopen(str,"r");    

    if(NULL == conf_fp){
        lcd.printf("File access error");
        wait(2);
        return -1;
    }else{;}

    while(fgets(buf,sizeof(buf),conf_fp) != NULL){
         lcd.cls(); //debug
        if(sscanf(buf, "%s %d,%d,%d,%d", name, &ip0, &ip1, &ip2, &ip3) == 0){
            lcd.printf("error...");
            return -1;
        }else{;}
        
        if(strcmp(name,word[0])==0){
            /* debug */
            lcd.printf("IP Address\n");
            lcd.printf("%d.%d.%d.%d.",ip0, ip1, ip2, ip3);
            ipaddr = IpAddr(ip0, ip1, ip2, ip3);
            ipe_input( 0, ip0, ip1, ip2, ip3);
        }else{;}

        if(strcmp(name,word[1])==0){
            /* debug */
            lcd.printf("NetworkMask\n");
            lcd.printf("%d.%d.%d.%d.",ip0, ip1, ip2, ip3);
            netmask = IpAddr(ip0, ip1, ip2, ip3);
            ipe_input( 1, ip0, ip1, ip2, ip3);
        }else{;}

        if(strcmp(name,word[2])==0){
            /* debug */
            lcd.printf("Gateway\n");
            lcd.printf("%d.%d.%d.%d.",ip0, ip1, ip2, ip3);
            gateway = IpAddr(ip0, ip1, ip2, ip3);
            ipe_input( 2, ip0, ip1, ip2, ip3);

        }else{;}

        if(strcmp(name,word[3])==0){
            /* debug */
            lcd.printf("Domain Name\n");
            lcd.printf("%d.%d.%d.%d.",ip0, ip1, ip2, ip3);
            nameserver = IpAddr(ip0, ip1, ip2, ip3);
            ipe_input( 3, ip0, ip1, ip2, ip3);
        }else{;}
    };

    fclose(conf_fp);   
    return 0;    
}


int ip_setup(){            
    lcd.cls();
    lcd.printf("Setup...\n");
    /* debug */
    lcd.cls();    lcd.locate(0,0);
    lcd.printf("ipaddr\n");
    lcd.printf("%3d,%3d,%3d,%3d", (int)ipaddr[0], (int)ipaddr[1], (int)ipaddr[2], (int)ipaddr[3]);
    wait(2);
    lcd.cls();    lcd.locate(0,0);
    lcd.printf("netmask\n");
    lcd.printf("%3d,%3d,%3d,%3d", (int)netmask[0], (int)netmask[1], (int)netmask[2], (int)netmask[3]);
    wait(2);
    lcd.cls();    lcd.locate(0,0);
    lcd.printf("gateway\n");
    lcd.printf("%3d,%3d,%3d,%3d", (int)gateway[0], (int)gateway[1], (int)gateway[2], (int)gateway[3]);
    wait(2);
    lcd.cls();    lcd.locate(0,0);
    lcd.printf("nameserver\n");
    lcd.printf("%3d,%3d,%3d,%3d", (int)nameserver[0], (int)nameserver[1], (int)nameserver[2], (int)nameserver[3]);
    wait(2);


    if (ipaddr[0] == 255) {
        // dhcp ip address
        eth = new EthernetNetIf;
    }else{
        // static ip address
        eth = new EthernetNetIf(ipaddr, netmask, gateway, nameserver);      
    }
    EthernetErr ethErr = eth->setup();

    if(ethErr){
        lcd.cls();
        lcd.printf("Error %d in setup.", ethErr);
        return -1;
    }else{;}
    return 0;

}


int edit(){
    int mode = -1;
    int i = 0, j= 0;
    int mode_buf,i_buf;

    Leftkey.rise(&LeftClick);
    Downkey.rise(&DownClick);
    Upkey.rise(&UpClick);
    Rightkey.rise(&RightClick);


    while(Set.num > 0 ){
        mode_buf = mode;
        i_buf = i;

        lcd.cls();
        lcd.locate(15,0); lcd.printf("%d",Set.num);
        mode = Set.num - 1;
        if(mode != mode_buf){
            Right.num = 0;
            Left.num = 0;       
        }else{;}
        
        i = (Right.num - Left.num)%12;
        if(i < 0){
            i = 12 +i;
        }else{;}
        if(mode != mode_buf || i != i_buf){
            Down.num =0;
            Up.num = ipe[mode][i]; 
        }else{;}

        j = (Up.num - Down.num)%10;
        if(j < 0){
            j = 10 +j;
        }else{;}
 
        if(mode == 0){
                    lcd.locate(0,0);  lcd.printf("IP Address");
                    ipe[mode][i] = j;
        }else if(mode == 1){
                    lcd.locate(0,0);  lcd.printf("Network Mask");
                    ipe[mode][i] = j;
        }else if(mode == 2){
                    lcd.locate(0,0);  lcd.printf("Gateway");
                    ipe[mode][i] = j;
        }else if(mode == 3){
                    lcd.locate(0,0);  lcd.printf("Domain Name");
                    ipe[mode][i] = j;
        }else{
            Set.num = 0;
            break;
        }
        
        ipe_print(mode);   
        wait(0.1);   
   }
    /* debug */
    lcd.locate(0,0);  lcd.printf("Edit done");
    wait(1);
    return 0;
}


int main() {
    int i=0;
    char filename[32];


    lcd.printf("Setting up...");
    Set.num = 0;
    Left.num = 0;
    Right.num = 0;
    Down.num = 0;
    Up.num = 0;
    power = 1;

    sprintf(filename,"IPCONFIG.TXT");
    if(config_read(filename) != 0){
        return -1;
    };

    if(ip_setup() != 0){
        return -1;
    }else{;}

    lcd.cls();
    lcd.printf("Setup OK");
 
    IpAddr ip = eth->getIp() ;
 
    lcd.cls();
    lcd.printf("IP Address\n");
    lcd.printf("%d.%d.%d.%d", ip[0], ip[1], ip[2], ip[3]);

    Setkey.rise(&SetClick); 

  //Listen indefinitely
    do{
        Net::poll();
        if(i>5){
            led1=!led1; //Show that we are alive
            i = 0;
        }else{
            i++;
        }

        /* Settei mode*/
        if(Set.num >= 1){
            led2 = 1;
            if(edit()!= 0){
                return -1;
            }else{;}
            
            if(config_write(filename) != 0){
                return -1;
            }else{;}
            
            break;
        }
        wait(0.1);
    }while(1);

    led2 = 0;
    lcd.cls(); lcd.locate(0,0);
    lcd.printf("Please restart.\n");

    return 0;
}