#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "TextLCD.h"

EthernetNetIf *eth;
IpAddr ipaddr, netmask, gateway, nameserver;
 
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalIn Setkey(p20);
DigitalIn Leftkey(p19);
DigitalIn Downkey(p18);
DigitalIn Upperkey(p17);
DigitalIn Rightkey(p16);

TextLCD lcd(p24, p26, p27, p28, p29, p30); // rs, e, d0-d3 
LocalFileSystem local("local");


struct keystate{
    int state; // push(0) or left(1)?
};

struct keystate port20; // setup key
struct keystate port19; // left key
struct keystate port18; // down key
struct keystate port17; // up key
struct keystate port16; // right key


void ipe_print(int ipe[4][4][3], int mode){
    lcd.locate(0,1);
    lcd.printf("%d%d%d.%d%d%d.%d%d%d.%d%d%d",
    ipe[mode][0][0],ipe[mode][0][1],ipe[mode][0][2],
    ipe[mode][1][0],ipe[mode][1][1],ipe[mode][1][2],
    ipe[mode][2][0],ipe[mode][2][1],ipe[mode][2][2],
    ipe[mode][3][0],ipe[mode][3][1],ipe[mode][3][2]);

};


void edit(){
    int ipe[4][4][3]=
    {{{0,0,0},{0,0,0},{0,0,0},{0,0,0}},
     {{0,0,0},{0,0,0},{0,0,0},{0,0,0}},
     {{0,0,0},{0,0,0},{0,0,0},{0,0,0}},
     {{0,0,0},{0,0,0},{0,0,0},{0,0,0}}};
     // ipe[mode][i][j];

    int ip[4][4]={0,0,0,0};
    int mono=0, keta=0;
    int mode = 0; // 0:IP Adress, 1:NetMask, 2: Gateway, 3:DNS
    char address[4][16]; // address[mode][Address]
    char word[4][16] = {"IP Address","NetMask", "Gateway", "Domain Name"}; 
    
    lcd.locate(0,0);
    lcd.printf("%d %s",mode,word[mode]);
    
    while(mode < 4){ /*edit Address*/
        ipe_print(ipe,mode);

   /* ----Settei Key -----*/
        if((Setkey == 0 )&& (port20.state==1)){
            lcd.locate(14,0);
            lcd.printf("S");

            port20.state = 0;
            mode = mode + 1;
            if(mode >= 4){
                lcd.locate(0,0);//        lcd.printf("%s",address[mode]);
                lcd.printf("edited\n");            
                break;
            }else{;}

            lcd.cls();
            lcd.locate(0,0);//        lcd.printf("%s",address[mode]);
            lcd.printf("%d %s",mode,word[mode]);

        }else if((Setkey == 1 )&& (port20.state == 0)){
               port20.state = 1;
        }else{;}

    /* ----Right Key -----*/
        if((Rightkey == 0 )&& (port16.state== 1)){
            port16.state = 0;
            keta = keta+1;
            if( keta >= 3){
                keta = 0;
                mono = mono+1;
                if( mono = 4 ){
                    mono = 0;
                }else{ //i == 0, 1, 2, 3
                    ;
                }
            }else{ // j == 0, 1, 2;
                ;
            }
            /* debug */
            lcd.locate(15,0);
            lcd.printf("R");
            lcd.locate(13,0);
            lcd.printf("%d%d",mono, keta);
        }else if((Rightkey == 1) && (port16.state == 0)){
               port16.state = 1;
        }else{;}
        
    /* ----Left Key -----*/
        if((Leftkey == 0) && (port19.state==1)){

            port19.state = 0;
            keta = keta - 1;
            if( keta < 0){ // j== 0, 1, 2; 
                keta = 2;
                mono = mono - 1;
                if( mono < 0 ){ // i == 0, 1, 2, 3
                    mono = 3;
                }else{
                    ;
                 }
            }else{
                ;
            }
            /* debug */
            lcd.locate(15,0);
            lcd.printf("L");
            lcd.locate(13,0);
            lcd.printf("%d%d",mono,keta);

         }else if((Leftkey == 1 )&& (port19.state == 0)){
               port19.state = 1;
         }else{;}

    /* ----Down Key -----*/
        if((Downkey == 0) && (port18.state==1)){
            port18.state = 0;
            ipe[mode][mono][keta] = ipe[mode][mono][keta]-1;
            if(ipe[mode][mono][keta] < 0){
                ipe[mode][mono][keta] = 9;
            }else{;}
            /* debug */
            lcd.locate(15,0);
            lcd.printf("D");
            lcd.locate(13,0);
            lcd.printf("%d ",ipe[mode][mono][keta]);
        }else if((Downkey == 1 )&& (port18.state == 0)){
            port18.state = 1;
        }else{;}

    /* ----Upper Key -----*/
        if((Upperkey == 0 )&& (port17.state==1)){
            port17.state = 0;
            ipe[mode][mono][keta] = ipe[mode][mono][keta]+1;
            if(ipe[mode][mono][keta] > 9){
                ipe[mode][mono][keta] = 0;
            }else{;}        
            /* debug */
            lcd.locate(15,0);
            lcd.printf("U");
            lcd.locate(13,0);
            lcd.printf("%d ",ipe[mode][mono][keta]);


        }else if((Upperkey == 1) && (port17.state == 0)){
            port17.state = 1;
        }else{;}
                
//        lcd.locate(1,0); lcd.printf("%d.%d.%d.%d", ip[0],ip[1],ip[2],ip[3]);
        


        for(mono=0; mono<4; mono++){
            ip[mode][mono] = 100*ipe[mode][mono][0] + 10*ipe[mode][mono][1] + ipe[mode][mono][2];
        }
        sprintf(address[mode],"%3d.%3d.%3d.%3d", ip[mode][0],ip[mode][1],ip[mode][2],ip[mode][3]);
//        lcd.cls();
//        lcd.locate(0,0);       lcd.printf("%s",address[mode]);
//        lcd.printf("%s\n",word[mode]);

        
        wait(0.2);
   }

    // config_write();        
    lcd.cls();
//    return 0;
}

/*
int config_write(int *IP[4], int *NM[4], int *GW[4], int  *NS[4]){
    FILE *conf_fp;
    char buf[80], name[16];
    int ip0, ip1, ip2, ip3;

    conf_fp = fopen("/local/ipconfig.txt","w");    
    if(NULL == conf_fp){
        //printf("\r\nError: The message file cannot be accessed\r\n");
        lcd.printf("File access error");
        return -1;
    }

    fclose(conf_fp);   r
    return 0;    
}
*/


int config_read(){
    FILE *conf_fp;
    char buf[80], name[16];
    int ip0, ip1, ip2, ip3;

    conf_fp = fopen("/local/ipconfig.txt","r");    
    if(NULL == conf_fp){
        //printf("\r\nError: The message file cannot be accessed\r\n");
        lcd.printf("File access error");
        return -1;
    }

    while( fgets(buf,sizeof(buf),conf_fp) != NULL){
         lcd.cls(); //debug
         //lcd.locate(0,0);lcd.printf("%s\n",buf); // debug
        if(sscanf(buf, "%s %d,%d,%d,%d", name, &ip0, &ip1, &ip2, &ip3) != 0){
            //lcd.locate(0,0);
            //lcd.printf("%s\n%3d,%3d,%3d,%3d", name, ip0, ip1, ip2, ip3);
        }else{
            lcd.printf("error...");
            return -1;
        }

        if(strcmp(name,"IPAddress")==0){
            lcd.printf("IP Address\n");
            lcd.printf("%d.%d.%d.%d",ip0, ip1, ip2, ip3);
            ipaddr = IpAddr(ip0, ip1, ip2, ip3);

        }
        if(strcmp(name,"NetworkMask")==0){
            lcd.printf("NetworkMask\n");
            lcd.printf("%d.%d.%d.%d",ip0, ip1, ip2, ip3);
            netmask = IpAddr(ip0, ip1, ip2, ip3);
        }
        if(strcmp(name,"Gateway")==0){
            lcd.printf("Gateway\n");
            lcd.printf("%d.%d.%d.%d",ip0, ip1, ip2, ip3);
            gateway = IpAddr(ip0, ip1, ip2, ip3);
        }
        if(strcmp(name,"DNS")==0){
            lcd.printf("Domain Name\n");
            lcd.printf("%d.%d.%d.%d",ip0, ip1, ip2, ip3);
            nameserver = IpAddr(ip0, ip1, ip2, ip3);
        }
        wait(3);
    };

    fclose(conf_fp);   
    return 0;    
}


int setup(){
    if (ipaddr[0] == 255) {
        // dhcp ip address
        eth = new EthernetNetIf;
    } else {
        // static ip address
        eth = new EthernetNetIf(ipaddr, netmask, gateway, nameserver);
    }
    
    EthernetErr ethErr = eth->setup();

    if(ethErr){
        lcd.cls();
        lcd.printf("Error %d in setup.", ethErr);
        return -1;
    }

    return 0;
}

int test(){
    led2 = 1;
    return 0;
}


int main() {
    int i=0;

    lcd.printf("Setting up...");
    config_read();
    if(setup() != 0){
        return -1;
    }


    lcd.cls();
    lcd.printf("Setup OK");
 
    IpAddr ip = eth->getIp() ;
 
    lcd.cls();
    lcd.printf("IP Address\n");
    lcd.printf("%d.%d.%d.%d", ip[0], ip[1], ip[2], ip[3]);
//    wait(5);
 
//  Timer tm;
//  tm.start();


  //Listen indefinitely
    while(true){
    
        Net::poll();
        //if(tm.read()>.5){


        if(i>5){
            led1=!led1; //Show that we are alive
            i=0;
        }else{
            i++;
        }
       // lcd.printf("main loop\n");
    
    
        if(Setkey == 0 && port20.state==1){
            port20.state = 0;
            test();

//            led2 = !led2;
            edit();

            lcd.cls();
            lcd.printf("IP Address\n");
            //lcd.printf("%d.%d.%d.%d", ip[0], ip[1], ip[2], ip[3]);
            //lcd.printf("main loop\n");
            lcd.printf("%3d.%3d.%3d.%3d.", ip[0], ip[1], ip[2], ip[3]);

/*           if((config_read() != 0) && (setup() !=0)){
               return -1;
             }
             IpAddr ip = eth->getIp() ;
*/
        }else if(Setkey == 1 && port20.state == 0){
            port20.state = 1;
            led2 = 0;
        }else if(Setkey == 0 && port20.state == 0){ // state == 0
//            led2 = !led2;
        }else{ //Setkey ==1 && state == 1 
//            led2 = !led2;
        }
//      tm.start();
//    }
        wait(0.1);      
    }

    lcd.cls();
    lcd.printf("bye!");
    return 0;
}