#include "mbed.h"
#include "USBMouseKeyboard.h"
#include "TextLCD.h"

USBMouseKeyboard pedal;

TextLCD lcd(p24, p26, p27, p28, p29, p30); // rs, e, d0-d3 

DigitalOut a_led(LED1);
DigitalOut b_led(LED2);

DigitalOut powerA(p13);
DigitalOut powerB(p14);

/*
InterruptIn Accel(p12);
InterruptIn Brake(p29);
*/

DigitalIn Accel(p9);
DigitalIn Brake(p18);

int accel_flag; // push?
int brake_flag; // push?

/*
void Afall(){
    accel_flag = 0;
    wait(0.1);
}
void Arise(){
    accel_flag++;
    wait(0.1);
}
void Bfall(){
    brake_flag = 0;
    wait(0.1);

}
void Brise(){
    brake_flag++;
    wait(0.1);
}
*/


int main(void) {
    int i=0;

    /* debug */
    a_led = 1;
    b_led = 1;
    lcd.printf("hello\n");
    

    /* Initialize */
    powerA = 1;
    powerB = 1;

    accel_flag = 0;
    brake_flag = 0;


    /* main Loop */
    while (1) {
        /* debug */
        a_led = accel_flag;
        b_led = brake_flag;


        /* sensing */    
        if(Accel > 0.5){
            accel_flag = 1;
        }else{
            accel_flag = 0;
        }
        if(Brake > 0.5){
            brake_flag = 1;
        }else{
            brake_flag = 0;
        }
   

        /* keyboard input */        
        if(i > 10){
            lcd.cls();
            if(accel_flag > 0){
                lcd.locate(0,0); lcd.printf("A:%d",accel_flag);
                pedal.printf("\n");
            }

            if(brake_flag > 0){
                //pedal.keyCode('', KEY_CTRL);
                lcd.locate(0,1); lcd.printf("B:%d",brake_flag);
                pedal.scroll(127); // -128 ~ 127
            }
            i = 0;
        }
    
        i++;
        wait(0.1);
    }

    return 0;
/*    Accel.fall(&Afall);
    Accel.rise(&Arise);
    Brake.fall(&Bfall);
    Brake.rise(&Brise);
*/


}
