#include "mbed.h"
#include "USBMouseKeyboard.h"

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);

Serial pc(USBTX, USBRX);
Serial ctrl(p9, p10);
USBMouseKeyboard key_mouse;

int main() {
    int pad=0;
    char str[128];
    myled2 = 0;
    myled3 = 0;
    int counter=0;

    pc.printf("HELLO");

    while(1) {
        
        if(ctrl.readable()) {
            myled3 = 1;
//            pc.putc(ctrl.getc());
//                printf("%d\r\n",ctrl.getc());
            pad = ctrl.getc();
            pc.putc(pad);

            if(pad == 85){ // 'U'
                pc.printf("u ");
                key_mouse.move (0, -5);     // mouse move
                myled2 = 1;    
            }else{;}

            if(pad == 68){ // 'D'
                pc.printf("d ");
                key_mouse.move (0, 5);    // mouse move
                myled2 = 1;
            }else{;}
            if(pad == 82){ // 'R'
                pc.printf("r ");
                key_mouse.move (5, 0);     // mouse move
                myled2 = 1;
            }else{;}
            if(pad == 76){ // 'L'
                pc.printf("l ");
                key_mouse.move (-5, 0);    // mouse move
                myled2 = 1;
            }else{;}

            if(counter < 20){
                counter ++;
                
            }else{
               counter = 0;

               if(pad == 48){ //'0' plus + minus
                    pc.printf("0 ");
                    key_mouse.putc('-');   //ESC
                    myled2 = 1;
               }
               else if(pad == 80){ //'P' plus
                    pc.printf("p ");
                    key_mouse.putc(RIGHT_ARROW);   //RIGHT_ARROW
                    myled2 = 1;
    
               }
               else if(pad == 77){ // 'M' minus
                    pc.printf("m ");
                    key_mouse.putc(LEFT_ARROW);   // keyCode: LEFT_ARROW
                    myled2 = 1;
    
               }else{;}
    
               if(pad == 67){ // 'C' A+B
                    pc.printf("c ");
//                    key_mouse._putc(KEY_LF);  // 
                   key_mouse._putc(KEY_F5);  // Enter
                    myled2 = 1;
               }else if(pad == 65){ // 'A'
                    pc.printf("a ");
                    key_mouse.click(MOUSE_LEFT);
                    myled2 = 1;
               }else if(pad == 66){ // 'B'
                    pc.printf("b ");
                    key_mouse.click(MOUSE_RIGHT);
                    myled2 = 1;
               }else{;}
    
               if(pad == 51){ // '3' 1 + 2
                   pc.printf("_ ");
//                   key_mouse._putc(KEY_F5);  // Enter
                   key_mouse.putc('-');   //ESC
                   myled2 = 1;
               }else if(pad == 49){ // '1' 
                   pc.printf("< ");
                   key_mouse._putc('W'); // white
                   myled2 = 1;
               }else if(pad == 50){ // '2'
                   pc.printf("> ");
                   key_mouse._putc('B'); // black
                   myled2 = 1;
               }else{;}

               if(pad == 72){ // 'H'
                   pc.printf("h ");
                   key_mouse.putc(KEY_HOME);
                   myled2 = 1;
               }else{;}
            }

            pad =0; // reset
        }

        myled1 = !myled1;
        if(!myled1) myled2 = 0; 
        if(!myled1) myled3 = 0;
    }
}
