#include "mbed.h" 
#include "ExtendedTimer.h"
#include "SDFileSystem.h"
////////////////////////////////////
//Declare all of the inputs and outputs
////////////////////////////////////

//These are leds for humans to read
DigitalOut ledError(LED3);//The internal sd error light
DigitalOut powerOn(p16);//the external power light
DigitalOut sdMount(p15);//the external sd error light

//These are for the sphere
AnalogIn lightSensor(p20); 
DigitalOut ledRed(p25);
DigitalOut ledBlue(p26);

//These are for the tube
DigitalOut ledRedTube(p27);
DigitalOut ledBlueTube(p28);
AnalogIn lightSensorTube(p19);

//This is our timer
Ticker countClock;

//This is our clock
ExtendedTimer timeClock;

SDFileSystem sd(p5, p6, p7, p8, "sd"); // the pinout on the mbed Cool Components workshop board

Serial pc(USBTX,USBRX);  //This communicates with the computer. We may want to eliminate this in our final code?

float checkLightSensor(int n);//Check the phototransistor in the sphere

float checkTubeLightSensor(int n); //Check the phototransistor in the tube

//Switches the on states of the LEDs in the sphere
void ledSwitch();

//This saves the data to the sd card
void save();

FILE *fp = NULL; //This holds the location of the file. It is what we call when we write to the file.
 
int main() {
    powerOn = 1;  //Turn on the power light on the module
    timeClock.start(); //Start the clock to take the time
    sdMount = false;//Set the sdMount light to default to off
    
    //This bit happens if the SD card doesn't mount
    if (sd.mount() != 0) {
        pc.printf("Failed to mount the SD card.\r\n");
        sdMount = true;
        ledError = true;
        return -1;  // ends program with error status
    }
    
    //Open the file and append it
    fp = fopen("/sd/mydir/sdtest.txt", "a");
    if(fp == NULL) {
        sdMount = true;
        ledError = true;
        error("Could not open file for write\n");
        return -1;
    }
        
    int checkTimes = 60; //This determines how many times the led checks the phototransistor to get its averages
    
    //Initialize the lights
    ledRed = true;
    ledBlue = false;
    ledRedTube = true;
    ledBlueTube = false;
    
    countClock.attach(&save, 60);
    fprintf(fp,"\r\n\r\n\r\n\r\nTimeBlueDataTaken,BlueLight,BlueLightTube,TimeRedDataTaken,RedLight,RedLightTube\n\r\n\r\n\r");
    while(true) {
        ////////////
        //Blue Lights
        ////////////
        ledSwitch(); //Switch the LEDs from off to on or vice versa
        
        //Print the data to the PC
        pc.printf("%.1f,", timeClock.read());
        pc.printf("%.4f,", checkLightSensor(checkTimes));
        pc.printf("%.4f,", checkTubeLightSensor(checkTimes));
        
        //Send the data to the sd card
        fprintf(fp,"%.1f,", timeClock.read());
        fprintf(fp,"%.4f,", checkLightSensor(checkTimes));
        fprintf(fp,"%.4f,", checkTubeLightSensor(checkTimes));
        
        wait(.5); //Wait one second
        
        ///////////
        //Red Lights
        ///////////
        ledSwitch(); //Switch all of the LEDs
        
        //Print the data to the computer
        pc.printf("%.1f,", timeClock.read());
        pc.printf("%.4f,", checkLightSensor(checkTimes));
        pc.printf("%.4f\r\n", checkTubeLightSensor(checkTimes));
        
        //Send the data to the sd card
        fprintf(fp,"%.1f,", timeClock.read());
        fprintf(fp,"%.4f,", checkLightSensor(checkTimes));
        fprintf(fp,"%.4f\r\n", checkTubeLightSensor(checkTimes));
        
        wait(9.5); 
    }
}
    
    // Average n readings of the light sensor 
float checkLightSensor(int n){
    float x;
        x = 0; 
    for (int i = 0; i<n; i++) 
        x = x + lightSensor; 
    x = x/n;
    return x;
}

    // Average n readings of the light sensor in the tube
float checkTubeLightSensor(int n){
    float x;
        x = 0; 
    for (int i = 0; i<n; i++) 
        x = x + lightSensorTube; 
    x = x/n;
    return x;
}

//Switch the values of all of the LEDs
void ledSwitch(){
    ledBlue = !ledBlue;
    ledRed = !ledRed;
    ledBlueTube = !ledBlueTube;
    ledRedTube = !ledRedTube;
}

//Save the data to the sd card
void save(){
    fclose(fp); //When the card is closed, the data actually saves
    fp = fopen("/sd/mydir/sdtest.txt", "a"); //This reopens the file, appending it
   
    //This triggers if the card cannot open
    if(fp == NULL) {
        sdMount = true;//This turns on the external mount error led
        ledError = true;//This turns on the internal mount error led
        error("Could not open file for write\n");
    }
    pc.printf("\n\rSaved\n\r");
}