#include "mbed.h"
#include "ServoMotor.h"


/* ServoMotorコンストラクタ */
ServoMotor::ServoMotor( PinName servo_pwmport_,
                        float   minDeg_,
                        float   maxDeg_,
                        float   pulse_width_,
                        float   minDPLW_,
                        float   maxDPLW_
                      ):servo_pwmport(servo_pwmport_)
{

    minDeg = minDeg_;
    maxDeg = maxDeg_;
    pulse_width = pulse_width_;
    minDPLW = minDPLW_;
    maxDPLW = maxDPLW_;

    servo_pwmport.period(pulse_width);                  //pwm周期を20msにする

    decomposition_value = maxDeg / (maxDPLW - minDPLW); //分解値の計算
}



/* モータを回転させる関数 引数:目標角度 */
void ServoMotor::rot(float target_deg_)
{
//    if(target_deg_=0.0){
//        target_deg_ = 0.01;
//    }
    
    if(target_deg_ == output_deg_b){    //もし前回の値と同じ値が続いたときは電圧の出力はしないためのフィルタ
        ;
    }else{
        if(target_deg_< minDeg)         //minDeg度より小さい値はminDegにする
            target_deg_ = minDeg;
        else if(target_deg_ > maxDeg)   //maxDeg度より大きい値はmaxDegにする
            target_deg_ = maxDeg;
    
        output_deg = target_deg_;
        servo_pwmport.pulsewidth((output_deg / decomposition_value) + minDPLW); //pwmのパルスの出力幅を計算。この計算はmaxDPLWがmaxDeg,minDPLWがminDegになるような計算式.
        
        output_deg_b = output_deg;
    }
}


void ServoMotor::weak_condition()
{
    servo_pwmport.pulsewidth(0.00005);   //脱力状態(50usで発生する)
}

