#ifndef _SERVO_MOTOR_
#define _SERVO_MOTOR_

class ServoMotor
{
public:
    ServoMotor(PinName servo_pwmport_,         //pwmピン
               float minDeg_       = 0.0,      //最小角度[deg]
               float maxDeg_       = 300.0,    //最大角度[deg]
               float pulse_width_  = 0.02,     //PWM周期[s]
               float min_DPLW_     = 0.0005,   //最小角度時立ち上げパルス幅[s]
               float max_DPLW_     = 0.0024    //最大角度時立ち上げパルス幅[s]
              );  //ServoMotorコンストラクタ

    void rot(float);                //引数 目標角度
    void weak_condition();          //脱力状態にする


private:
    PwmOut servo_pwmport;
    float output_deg;               //出力角度保管[deg]
    float output_deg_b;             //一つ前の角度保管[deg]

    float pulse_width;              //pwmの周期
    float minDPLW;                  //最小角度時の立ち上げパルス ( min Deg Pulse Launch Widthの略 )
    float maxDPLW;                  //最大角度時の立ち上げパルス ( max Deg PUlse Launch Widthの略 )
    float minDeg;                   //モータの最小動作角度
    float maxDeg;                   //モータの最大動作角度

    float decomposition_value;      //分解値
};
#endif