#include "mbed.h"
#include <ros.h>
#include <std_msgs/String.h>
#include <std_msgs/Float32MultiArray.h>
#include <std_msgs/Float32.h>
#include "ServoMotor.h"

//システム関連
Timer   timer;
float CTRL_PERIOD   = 0.02;     //制御周期[s]
float READ_TIME     = 0.0 ;     //時間読み取り

//サーボモータをPWMでうごかすための設定(futaba RS204MDはPWMで動かす時は0~288[deg]が動作範囲)
ServoMotor      SM_R( D3, 0.0, 288.0, 0.02, 0.00056, 0.00248); //右指ブラシモータ
ServoMotor      SM_L( D7, 0.0, 288.0, 0.02, 0.00248, 0.00056); //左指ブラシモータ
ServoMotor      SM_S(D10, 0.0, 288.0, 0.02, 0.00056, 0.00248); //左指部

ros::NodeHandle n;

std_msgs::String                str_msg;
std_msgs::Float32               debug_deg;
std_msgs::Float32MultiArray     lrs_now_deg;

ros::Publisher motion_judg("/micon_LRS_motion_judg", &str_msg);
ros::Publisher LRS_now_deg_pub("/micon_LRS_now_deg", &lrs_now_deg);
ros::Publisher debug_deg_pub("/debug_deg",&debug_deg);

//モータ計算関連
void synchoroBrushAndSlider(float deg_L_, float deg_S_, int num_);   //モータ微小目標角度生成関数 引数1:目標角度 引数2:分割数
void allSMZero(float deg);                                          //モータの角度を全てdeg度にする

float now_deg[3]= {0.0,0.0,0.0};   //0:S  1:L  2:R


/*--- 左指ブラシとスライダを同期して動かす関数 ---*/
bool motion_triger = 0;
void synchoroBrushAndSlider(float deg_L_, float deg_S_, float target_time_)
{
    if(motion_triger == 0) {
        motion_triger = 1;

        float target[2];        //目標角度  0:S  1:L
        float diff_deg[2];      //目標と現在位置の差分
        float min_deg[2];       //最小移動角度
        float ini_deg[2];
        int motion_num = target_time_/CTRL_PERIOD;  //移動回数
        int cnt = 0;

        target[0]=deg_S_;
        target[1]=deg_L_;
        for(int i=0; i<2; i++) {
            ini_deg[i] = now_deg[i];
            diff_deg[i] = target[i]-ini_deg[i];
            min_deg[i] = diff_deg[i]*CTRL_PERIOD/target_time_;
        }

        timer.start();
        timer.reset();
        while(1) {
            if(timer.read() >= CTRL_PERIOD) {
                cnt++;

                for(int i=0; i<2; i++) 
                    now_deg[i] = min_deg[i]* cnt + ini_deg[i];

                SM_S.rot(now_deg[0]);
                SM_L.rot(now_deg[1]);

                timer.reset();
                    
            }
            if(cnt > motion_num)
                break;
        }
        motion_triger = 0;
        timer.stop();
    }
}

/*--- 全サーボをゼロ度にする ---*/
void allSMZero(float deg_data_) {
    for(int i=0; i<3; i++)
        now_deg[i] = deg_data_;

    SM_L.rot(deg_data_);
    SM_R.rot(deg_data_);
    SM_S.rot(deg_data_);
}


/*--- 全サーボに同じ角度を与える ---*/
void init_pose_cb(const std_msgs::Float32& data_) {
    allSMZero(data_.data);

}


/*--- LRSにそれぞれの角度を与え”非同期”で動作する ---*/  //aa
void add_rotate_cb(const std_msgs::Float32MultiArray& data_) {
    if(motion_triger == 0) {
        motion_triger = 1;


        float target[3];        //目標角度
        float diff_deg[3];      //目標と現在位置の差分
        float min_deg[3];       //最小移動角度
        float ini_deg[3];
        int motion_num = data_.data[3]/CTRL_PERIOD;  //移動回数
        int cnt = 0;

        float target_time  = data_.data[3];

        for(int i=0; i<3; i++) {
            ini_deg[i] = now_deg[i];
            target[i]   = data_.data[i] ;               //0:S  1:L  2:R
            diff_deg[i] = target[i]-ini_deg[i];
            min_deg[i]  = diff_deg[i]*CTRL_PERIOD/target_time;
        }

        timer.start();
        timer.reset();
        while(1) {
            if(timer.read() >= CTRL_PERIOD) {
                cnt++;
                
                for(int i=0; i<3; i++)
                    now_deg[i] = min_deg[i] * cnt + ini_deg[i];

                SM_S.rot(now_deg[0]);
                SM_L.rot(now_deg[1]);
                SM_R.rot(now_deg[2]);
                debug_deg.data = now_deg[0];
                debug_deg_pub.publish(&debug_deg);
            
                timer.reset();
            }

            if(cnt >= motion_num)
                break;
        }
        timer.stop();
        motion_triger = 0;
    }
}

//aaaaa

void tar_rotate_cb(const std_msgs::Float32MultiArray& data_) {
    if(motion_triger == 0) {
        motion_triger = 1;


        float target[3];        //目標角度
        float diff_deg[3];      //目標と現在位置の差分
        float min_deg[3];       //最小移動角度
        float ini_deg[3];
        int motion_num = data_.data[3]/CTRL_PERIOD;  //移動回数
        int cnt = 0;

        float target_time  = data_.data[3];

        for(int i=0; i<3; i++) {
            ini_deg[i] = now_deg[i];
            target[i]   = data_.data[i] ;               //0:S  1:L  2:R
            diff_deg[i] = target[i]-ini_deg[i];
            min_deg[i]  = diff_deg[i]*CTRL_PERIOD/target_time;
        }

        timer.start();
        timer.reset();
        while(1) {
            if(timer.read() >= CTRL_PERIOD) {
                cnt++;
                
                for(int i=0; i<3; i++)
                    now_deg[i] = min_deg[i] * cnt + ini_deg[i];

                SM_S.rot(now_deg[0]);
                SM_L.rot(now_deg[1]);
                SM_R.rot(now_deg[2]);

                timer.reset();
            }

            if(cnt >= motion_num)
                break;
        }
        timer.stop();
        motion_triger = 0;
    }
}

/*--- LSを同期させて動かす ---*/
void synchro_cb(const std_msgs::Float32MultiArray& data_) {
    synchoroBrushAndSlider(data_.data[0], data_.data[1],data_.data[2]);
}


ros::Subscriber<std_msgs::Float32> init_pose_rot("/micon_init_pose_rot",&init_pose_cb);
ros::Subscriber<std_msgs::Float32MultiArray> LRS_add_rot("/micon_LRS_add_rot",add_rotate_cb);
ros::Subscriber<std_msgs::Float32MultiArray> LRS_tar_rot("/micon_LRS_tar_rot",tar_rotate_cb);
ros::Subscriber<std_msgs::Float32MultiArray> LS_synchro_rot("/micon_LS_synchro_rot",synchro_cb);


int main() {
    n.getHardware()->setBaud(115200);
    n.initNode();

    n.advertise(motion_judg);
    n.advertise(LRS_now_deg_pub);
    n.advertise(debug_deg_pub);
    n.subscribe(init_pose_rot);
    n.subscribe(LRS_add_rot);
    n.subscribe(LRS_tar_rot);
    n.subscribe(LS_synchro_rot);

    allSMZero(0.000001);

    str_msg.data = "move now";

    lrs_now_deg.data_length = 3;
    lrs_now_deg.data = (float *)malloc(sizeof(float)*8);

    while(1) {
        n.spinOnce();
        lrs_now_deg.data[0]=(now_deg[1]);
        lrs_now_deg.data[1]=(now_deg[2]);
        lrs_now_deg.data[2]=(now_deg[0]);
        //   motion_judg.publish(&str_msg);
        LRS_now_deg_pub.publish(&lrs_now_deg);
        wait_ms(10);
    }
}
