#include "mbed.h"
#include "ds1621.h"

#define DS1621_ADDR 0

Serial pc(USBTX, USBRX);
I2C i2c(p28, p27);
DS1621 ds(&i2c, DS1621_ADDR);


DigitalOut myled(LED1);

int main(){
    i2c.frequency(5000); //5khz
    pc.printf("-----------------------\n\rMain\n\r");
    int xsec=4;
    float temp = 0.0;
    ds.init(DS1621_ADDR);
    while (1) {
        temp = ds.read(DS1621_ADDR);
        pc.printf("Measurment at start + %d seconds, Temperature=%3.1f\n\r",xsec,temp);
        wait(xsec);
    }
}
