#include "mbed.h"
#include "TextLCD.h"

TextLCD lcd(PTB2, PTB3, PTB10, PTB11, PTC11, PTC10, TextLCD::LCD16x2); // rs, e, d4-d7
AnalogIn V(PTC2);
Serial PC(USBTX, USBRX);
DigitalOut LED(PTB22);

void Config_ptos(void);
void Proceso(void);
void Presentacion(void);
void Lectura(void);

float Vr = 3.3, Df = 0.991;
float Vd, Vo;

int main()
{
    Config_ptos();
    while(1) {
        Proceso();
    }
}

void Config_ptos(void)
{
    PC.format(8, Serial::None, 1);
    PC.baud(9600);
    LED = 1;
}


void Proceso(void)
{
    //if(PC.readable()) {
        if(PC.getc()=='A') {
            LED = 1;
        }

        if(PC.getc()=='B') {
            LED = 0;
        }

    //}

    //if(PC.writeable()) {
        Vo = V.read();
        Vd = Vr * Vo/ Df;

        lcd.locate(0,0);
        lcd.printf("V = %f V", Vd);

        PC.printf("V = %f V\n", Vd);
        PC.printf("\r\n");

        wait_ms(500);
        lcd.cls();
    //}
}