#ifndef TESTS_H
#define TESTS_H

#include "Claw-test.h"
#include "Winch-test.h"
#include "Gold-test.h"
#include "Monster-test.h"
/**
 * @brief Run all the tests for this program
 *
 * @returns The number of tests that failed
 */
int run_all_tests()
{
    int n_tests_failed = 0; // A log of the number of tests that have failed

    // Run the Claw_test_movement test
    printf("Testing Claw_test_movement...\n");
    bool claw_test_passed = Claw_test_movement();

    // Print out the result of this test
    if (claw_test_passed) {
        printf("...Passed!\n");
    }
    else {
        printf("...FAILED!\n");
        ++n_tests_failed; // Increment number of failures
    }
    
    
///////////////
    // Run the Winch_test_movement test
    printf("Testing Winch_test_movement...\n");
    bool winch_test_passed = Winch_test_movement();

    // Print out the result of this test
    if (winch_test_passed) {
        printf("...Passed!\n");
    }
    else {
        printf("...FAILED!\n");
        ++n_tests_failed; // Increment number of failures
    }


///////////////
    // Run the Gold_test_movement test
    printf("Testing Gold_test_movement...\n");
    bool gold_test_passed = Gold_test_movement();

    // Print out the result of this test
    if (gold_test_passed) {
        printf("...Passed!\n");
    }
    else {
        printf("...FAILED!\n");
        ++n_tests_failed; // Increment number of failures
    }



///////////////
    // Run the Monster_test_movement test
    printf("Testing Monster_test_movement...\n");
    bool monster_test_passed = Monster_test_movement();

    // Print out the result of this test
    if (monster_test_passed) {
        printf("...Passed!\n");
    }
    else {
        printf("...FAILED!\n");
        ++n_tests_failed; // Increment number of failures
    }



///////////////
    // Finish by printing a summary of the tests
    if (n_tests_failed > 0) {
        printf("%d tests FAILED!\n", n_tests_failed);
    }
    else {
        printf("All tests passed!\n");
    }

    return n_tests_failed;
}

#endif