#ifndef Winch_H
#define Winch_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Winch Class
@brief Controls the winch in the gold miner game 
@author Yufan Zhong, University of Leeds and SWJTU
@date May 2020
*/ 

class Winch
{
public:
    /** Constructor */
    Winch();
    
    /** Destructor */
    ~Winch();
    
     /** Initialise the winch
    *   @param  height - the height of the winch
    *   @param  width - the width of the winch
    */
    void init(int height,int width);
    
     /** Draw the winch on the screen
    *   @param  lcd - N5110 library
    */
    void draw(N5110 &lcd);
    
     /** Update data 
    *   @param  d - direction of the joystick
    *   @param  mag - magnitude of the joystick
    */
    void update(Direction d,float mag);
    
     /** Add highest score
    */
    void add_highest_score();
    
     /** Get highest score
    *   @return the highest score.
    */
    int get_highest_score();
    
     /** Get position of the winch
    *   @return the position of the winch.
    */
    Vector2D get_pos();
    
     /** Set position of the winch
    *   @param  p - position of the winch
    */
    void set_pos(Vector2D p);
    
     /** Get the speed of the winch
    *   @return the speed of the winch.
    */
    float get_speed();
    
private:

    int _height;
    int _width;
    int _x;
    int _y;
    int _speed_x;
    int _highest_score;

};
#endif