#ifndef WINCH_TEST_H
#define WINCH_TEST_H

/**
 * \brief Check that Winch object goes to correct position when moved
 * 
 * \returns true if all the tests passed
 */
bool Winch_test_movement()
{
    // Initialise Winch object with a winch width of 12 and height of 6
    Winch winch;
    winch.init(6,12);

    // Set the position to 42,9
    Vector2D initial_pos = {42, 9};
    winch.set_pos(initial_pos);

    // Read the position
    Vector2D read_pos_1 = winch.get_pos();
    printf("%f, %f\n", read_pos_1.x, read_pos_1.y);

    // Set the direction to E and mag to 0.2
    Direction d = E;
    float mag = 0.2;

    // Update the position
    winch.update(d,mag);

    // Read the position
    Vector2D read_pos_2 = winch.get_pos();
    printf("%f, %f\n", read_pos_2.x, read_pos_2.y);
    
    // Now check that both the positions are as expected
    bool success_flag = true;
    
    // Fail the test if the initial position is wrong
    if (read_pos_1.x != 42 || read_pos_1.y != 9) {
        success_flag = false;
    }
    
    // Fail the test if the final position is wrong
    if (read_pos_2.x != 43 || read_pos_2.y != 9) {
        success_flag = false;
    }

    return success_flag;
}
#endif