#ifndef Monster_H
#define Monster_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Monster Class
@brief Controls the monster in the gold miner game 
@author Yufan Zhong, University of Leeds and SWJTU
@date May 2020
*/ 

class Monster
{
public:
    /** Constructor */
    Monster();
    
    /** Destructor */
    ~Monster();
    
     /** Initialise the monster
    *   @param  speed - the speed of monster
    */
    void init(float speed);
    
     /** Draw the monster 
    *   @param  lcd - N5110 library
    */
    void draw(N5110 &lcd);
    
     /** Update the data
    */
    void update();
    
     /** Set the position of the monster
    *   @param the position of the monster.
    */
    void set_pos(int x);
    
     /** Get the position of the monster
    *   @return the position of the monster.
    */
    int get_pos();
    
     /** Set the speed of the monster
    *   @param  speed - the speed of monster
    */
    void set_speed(float speed);
    
     /** Get the speed of monster
    *   @return the speed of the monster
    */
    float get_speed();
    
private:

    int _x;
    int _y;
    int _speed;
};
#endif