#include "MinerEngine.h"


MinerEngine::MinerEngine()
{

}

MinerEngine::~MinerEngine()
{

}

//the bit map of the cover picture
int sprite[48][84] =   {
    //                        *10                 *20                 *30                 *40                 *50                 *60                 *70                 *80
/*1 */     {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1 },
/*2 */     {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,0,1,1,1,1 },
/*3 */     {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,1,1,1,1,1,1 },
/*4 */     {1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,0,1,1,1,1 },
/*5 */     {1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,0,0,0,0,1,1,0,1,1,0,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,0,0,1,1,1 },
/*6 */     {1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 },
/*7 */     {1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 },
/*8 */     {1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1 },
/*9 */     {1,1,1,1,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1 },
/*10 */    {1,1,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,0,0,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1 },
/*11 */    {1,1,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,0,0,1,0,1,0,1,1,1,1,1,1,1,1,1,1,1 },
/*12 */    {1,1,1,1,1,0,0,1,0,0,1,1,1,0,0,1,0,0,1,1,0,0,0,1,1,0,0,1,0,0,1,1,1,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1 },
/*13 */    {1,1,1,1,1,0,0,1,0,1,1,0,0,0,1,1,1,0,0,0,1,0,0,1,0,0,1,1,1,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,0,0,1,0,0,1,1,1,0,0,0,1,1,1,0,0,0,0,0,1,1,1,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1 },
/*14 */    {1,1,1,1,1,0,0,1,0,0,1,1,1,0,0,1,0,0,1,1,1,0,0,1,0,0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1 },
/*15 */    {1,1,1,1,0,0,0,1,0,0,0,0,0,1,0,1,0,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,1,0,0,1,1,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1 },
/*16 */    {1,1,1,1,0,0,0,1,0,0,1,1,1,0,0,1,1,0,1,1,1,1,0,1,0,0,0,1,1,0,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,1,0,0,1,1,1,0,0,1,1,0,0,0,0,0,1,1,1,1,1,1,1,1 },
/*17 */    {1,1,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1 },
/*18 */    {1,1,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,1,1,1,1,1,0,0,0,0,1,0,0,1,1,1,1,1,0,1,1,0,1,1,1,1,1,1,0,0,0,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1 },
/*19 */    {1,1,1,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,1,1,1,1,1,1,0,0,0,1,0,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,0,0,1,1,1,0,0,1,1,0,0,0,1,1,1,1,1,1 },
/*20 */    {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,0,0,0,0,0,1,1,0,1,0,1,0,0,0,0,1,1,1,1,0,1,0,0,1,1,1,1,1,1,0,0,0,1,1,0,1,1,0,1,0,0,1,1,1,1,1,1,1 },
/*21 */    {1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,1,1,0,1,1,0,0,1,1,1,1,1,1,1,0,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,0,1,0,0,0,0,0,1,1,1,1,1,1 },
/*22 */    {1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,1,0,1,0,1,1,1,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1 },
/*23 */    {1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,1,1,1,0,0,0,0,0,1,0,0,0,1,1,0,0,1,0,0,0,1,1,1,1,1,1,1,0,0,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1 },
/*24 */    {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,1,0,0,1,1,1,1,0,0,1,0,0,0,1,1,1,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1 },
/*25 */    {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,0,0,0,1,1,0,0,0,1,0,0,0,0,0,1,1,0,1,0,0,0,1,1,1,1,0,1,1,1,1,0,1,0,1,1,1,0,0,0,0,1,1,1 },
/*26 */    {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,0,0,1,0,1,1,1,0,0,1,1,1,1,0,1,0,1,1,1,1,0,0,0,1,1,1 },
/*27 */    {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,1,1 },
/*28 */    {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,1,1,0,1,1,0,1,1,1,1,1,0,1,0,1 },
/*29 */    {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,0,1,1,1,1,1,1,1,1,0,0,1,0,0,1,1,1,1,0,1,0,1 },
/*30 */    {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0 },
/*31 */    {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,0,1,1,1,1,1,1,1,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,1,1,1,1,1,1,1,1 },
/*32 */    {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,1,1,1,1,1,1,1,1,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,1,1,1,1,1 },
/*33 */    {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,0,0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1 },
/*34 */    {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1 },
/*35 */    {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,1,1,1,1,1,1,0,0,0,0,0,0,0,1,0,1,0,0,0,1,0,0,0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1 },
/*36 */    {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,0,1,1,1,0,1,0,0,1,0,0,1,1,0,0,1,0,0,0,1,0,1,1,1,1,1,1,1,1,1 },
/*37 */    {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,1,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1 },
/*38 */    {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1 },
/*39 */    {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,0,1,1,1,1,1,1,0,0,1,1,1,0,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 },
/*40 */    {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,0,0,1,1,1,1,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 },
/*41 */    {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 },
/*42 */    {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 },
/*43 */    {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 },
/*44 */    {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 },
/*45 */    {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 },
/*46 */    {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 },
/*47 */    {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 },
/*48 */    {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 },
};

//the bit map of the arrow
int arrow[8][8] = {
    {0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0},
    {0,0,0,1,0,0,0,0},
    {0,0,1,0,0,0,0,0},
    {0,1,1,1,1,1,0,0},
    {0,0,1,0,0,0,0,0},
    {0,0,0,1,0,0,0,0},
    {0,0,0,0,0,0,0,0},
};

//the state 1 of the walking man
int man_state1[10][7] = {
    {0,0,1,1,1,0,0},
    {0,0,1,0,1,0,0},
    {0,0,1,1,1,0,0},
    {1,0,0,1,0,0,0},
    {1,1,1,1,1,1,1},
    {0,0,0,1,0,0,1},
    {0,0,1,1,1,0,0},
    {0,0,1,0,1,0,0},
    {0,0,1,0,1,0,0},
    {0,0,0,0,1,0,0},
};

//the state 2 of the walking man
int man_state2[10][7] = {
    {0,0,1,1,1,0,0},
    {0,0,1,0,1,0,0},
    {0,0,1,1,1,0,0},
    {0,0,0,1,0,0,1},
    {1,1,1,1,1,1,1},
    {1,0,0,1,0,0,0},
    {0,0,1,1,1,0,0},
    {0,0,1,0,1,0,0},
    {0,0,1,0,1,0,0},
    {0,0,1,0,0,0,0},
};

     //initialise the MinerEngine
void MinerEngine::init(int winch_width,int winch_height,int gold_num,int monster_speed) 
{
    // initialise the game parameters
    _winch_width = winch_width;
    _winch_height = winch_height;
    _gold_num = gold_num;
    _monster_speed = monster_speed;
    // initialise the functions
    _winch.init(_winch_height,_winch_width);
    _monster.init(_monster_speed);
    _claw.init(_winch_width);
    _gold.init(_gold_num);
    //initilise the othor parameter
    _s = 1; //select
    _state = 0; //game state 
    _claw_speed = 1; 
    _catching = 0;// the flag if the claw is going down
    _claw_get = 0;// the flag if the claw get the gold
    _monster_collision=0;// the flag if the monster collides with claw
    _now_score = 0; //initialise the current score
    _h = 37;//the vertical position of the wlaking man
    // counting parameter for tunnel function
    _i = 0;
    _n = 0;
    _z = 1;
    _j = 0;
    for (int i=0;i<9;i++) {
        _gold_reached_num[i] = 0; //set all reached gold flag to 0
    }
}

      //initialise the highest score
void MinerEngine::init_unchanged_parameter() {
    _highest_score = 0;
}

      //switch the state of the game
void MinerEngine::state_switch(Gamepad &pad, N5110 &lcd) 
{
    while(1){
        switch(_state) {
                    case 0:
                       menu(pad,lcd); //the state of menu page
                        break;
                    case 1:
                       instruction(pad,lcd); //the state displaying the instruction
                       break;
                    case 2:
                       options(pad,lcd); //the state for the difficulties selection 
                        break;
                    case 3:
                       game_run(pad,lcd); //the state for running the game loop
                        break;
                    case 4:
                        game_over(pad,lcd); //the state for displaying the game over page
                        break;
        } 
    }
}

    //return the selection result 
int MinerEngine::get_select(Gamepad &pad) 
{     //change the value of _s to get the selection
     if ( pad.check_event(Gamepad::Y_PRESSED) == true && _s >0) {
         _s--;
        }
     else if ( pad.check_event(Gamepad::A_PRESSED) == true && _s < 2) {
         _s++;   
     }
    return _s;
}

     //display the instruction
void MinerEngine::instruction(Gamepad &pad, N5110 &lcd) {
        //button pressed to display next instruction
        while ( pad.check_event(Gamepad::START_PRESSED) == false && pad.check_event(Gamepad::JOY_PRESSED) == false) {
        lcd.clear();
        lcd.printString("Joystick is",0,0);
        lcd.printString("used to",0,1);
        lcd.printString("control the",0,2);
        lcd.printString("left & right",0,3);
        lcd.printString("of the winch",0,4);
        lcd.refresh();
        wait(1); //wait 1 second to avoid repeat press
        }
        
        while ( pad.check_event(Gamepad::START_PRESSED) == false && pad.check_event(Gamepad::JOY_PRESSED) == false) {
        lcd.clear();
        lcd.printString("Press button",0,0);
        lcd.printString(" A to put",0,1);
        lcd.printString("the claw down",0,2);
        lcd.printString("to catch &",0,3);
        lcd.printString("lift the gold",0,4);
        lcd.refresh();
        wait(1);
        }
        
        while ( pad.check_event(Gamepad::START_PRESSED) == false && pad.check_event(Gamepad::JOY_PRESSED) == false) {
        lcd.clear();
        lcd.printString("The most ",0,0);
        lcd.printString("vital thing",0,1);
        lcd.printString("is to try",0,2);
        lcd.printString("to avoid the",0,3);
        lcd.printString("moving monster",0,4);
        lcd.refresh();
        wait(1);
        }
        
        while ( pad.check_event(Gamepad::START_PRESSED) == false && pad.check_event(Gamepad::JOY_PRESSED) == false) {
        lcd.clear();
        lcd.printString("The 'c' means",0,0);
        lcd.printString("current score",0,1);
        lcd.printString("and 'h' means",0,2);
        lcd.printString("highest score",0,3);
        lcd.refresh();
        wait(1);
        }
        
        _state = 0; //back to menu state
      
}

     //display the menu page
void MinerEngine::menu(Gamepad &pad, N5110 &lcd) {
   //button pressed to confirm the choice
   while ( pad.check_event(Gamepad::START_PRESSED) == false && pad.check_event(Gamepad::JOY_PRESSED) == false) {
      lcd.clear();
      _s = get_select(pad); // get the selection
      lcd.drawRect(0,0,WIDTH,HEIGHT,FILL_TRANSPARENT);
      lcd.drawRect(1,1,WIDTH-2,HEIGHT-2,FILL_TRANSPARENT);
      lcd.printString(" Press Y or A",2,1); // print the instruction
      lcd.printString(" Intro",2,2);
      lcd.printString(" Start Game",2,3);
      lcd.printString(" Options",2,4);
        if ( _s == 1 ) { //move the arrow up and down
          lcd.drawSprite(70,24,8,8,(int *)arrow);
           }else if ( _s == 2) {
              lcd.drawSprite(70,32,8,8,(int *)arrow);
                  }else if( _s == 0) {
                      lcd.drawSprite(70,16,8,8,(int *)arrow); }
      lcd.refresh();
      wait(1); }
     if ( _s == 0) { // select the options
         _state = 1; } //instruction
     else if ( _s == 1){
         _state = 3; }//game run
     else if (_s == 2){
         _state = 2; }//select difficulties           
}

      //select difficulties
void MinerEngine::options(Gamepad &pad, N5110 &lcd) {
    //button pressed to confirm the choice
    while ( pad.check_event(Gamepad::START_PRESSED) == false && pad.check_event(Gamepad::JOY_PRESSED) == false) {
      lcd.clear();
      int _s = get_select(pad);
      lcd.drawRect(0,0,WIDTH,HEIGHT,FILL_TRANSPARENT);
      lcd.drawRect(1,1,WIDTH-2,HEIGHT-2,FILL_TRANSPARENT);
      lcd.printString(" Press Y or A",2,1); //print options
      lcd.printString(" Easy",4,2);
      lcd.printString(" Normal",4,3);
      lcd.printString(" Hard",4,4);
      if ( _s == 0) {
          lcd.drawSprite(60,15,8,8,(int *)arrow);
          _monster.set_speed(1.0); // easy set the speed to 1.0
          }else if ( _s == 1 ) {
              lcd.drawSprite(60,24,8,8,(int *)arrow);
             _monster.set_speed(1.5); // normal set the speed to 1.5
              }else if ( _s == 2) {
                  lcd.drawSprite(60,32,8,8,(int *)arrow);
                  _monster.set_speed(2.0); }// hard set the speed to 2.0
      lcd.refresh();
      wait(1); }
    _state = 0; //back to mune state
}

     //run the game loop
void MinerEngine::game_run(Gamepad &pad, N5110 &lcd) {

    tunnel(pad,lcd); //play the tunnel animation 
    int fps=12; //set 12 frame per second
    _monster_collision=0; //set collision flag to 0
    while(_monster_collision==0) { // run the game while no monster collision
        lcd.clear();
        read_input(pad); //read the gamepad input
        update(pad); //update all components
        draw(lcd); //draw all components
        lcd.refresh();
        wait(1.0f/fps);
    }
}

     //check if the gold reached the upper boundary
void MinerEngine::check_gold_collision(Gamepad &pad)
{
    for (int i=0;i<9;i++) { //check the gold with serial number from 0 to 8
        if (_gold_reached_num[i]==0) {
          Vector2D gold_pos = _gold.get_pos(i);
    
           if (gold_pos.y <= 17) {
              _claw_get=0; //set the claw free
              _now_score++; //add score
              _catching = 0; //set catching flag to 0
              _claw.add_now_score();
              _gold_reached_num[i] = 1; //set the gold to be reached
              pad.leds_on(); //turn on and off the leds
              wait(0.5);
              pad.leds_off();
            }
        }
    }
}

     //print the score on screen
void MinerEngine::print_scores(N5110 &lcd) {                                

    // get highest scores from winchs
    int highest_score = _winch.get_highest_score();
    // print to LCD 
    char buffer1[14]; //print current score
    sprintf(buffer1,"%2d",_now_score);
    lcd.printString(buffer1,1,0);  
    lcd.printString("c",WIDTH/2-18,0);
    lcd.printString("h",WIDTH/2+18,0);
    if (_now_score>_highest_score) {
         _highest_score = _now_score; //update the highest score if current score is higher
    }
    char buffer2[14]; //print highest score
    sprintf(buffer2,"%2d",_highest_score);
    lcd.printString(buffer2,WIDTH-13,0);
}

     //read input from gamepad
void MinerEngine::read_input(Gamepad &pad)
{
    _d = pad.get_direction(); //get the direction of the joystick
    _mag = pad.get_mag(); //get the magnitude of the joystick
    if (pad.check_event(Gamepad::A_PRESSED) == true){ //check if the button which makes the claw down is pressed
        _catching=1; //lower the claw
        _claw.set_velocity(_claw_speed); //set the speed of claw
    }
}
     
     //draw all components on the LCD
void MinerEngine::draw(N5110 &lcd)
{
    lcd.drawRect(0,0,WIDTH,HEIGHT,FILL_TRANSPARENT); 
    //horizontal line
    lcd.drawLine(0,13,WIDTH,13,1);
    lcd.drawLine(0,0,WIDTH,0,0);
    print_scores(lcd); //print scores
    _winch.draw(lcd); //draw the components
    _claw.draw(lcd);
    _gold.draw(lcd);
    _monster.draw(lcd);
}

     //update all position of all components
void MinerEngine::update(Gamepad &pad)
{
    if (_catching==0) {
        _winch.update(_d,_mag); //move the winch only the claw does not do down
    }
    Vector2D winch_pos = _winch.get_pos(); //make the claw follow the winch
    _claw.update(winch_pos);
    _monster.update(); 
    _gold.update();
     // check all collisions
    check_monster_collision(pad);
    check_claw_collision(pad);
    check_gold_collision(pad);
    check_gold_reload(); //check if gold reloading is needed
}

     //check the collision of monster and claw
void MinerEngine::check_monster_collision(Gamepad &pad)
{
    // read current claw position
    Vector2D claw_pos = _claw.get_pos();
    int monster_x = _monster.get_pos();
    float monster_speed = _monster.get_speed(); //if the x distance between claw and monster less than speed
      if ((monster_x-claw_pos.x)<=0            //then there is a collide
      && (monster_x-claw_pos.x)>(-2)
      && claw_pos.y>=22) {  
        _monster_collision=1; //collision happens
        // audio and LEDs feedback
        pad.tone(1500.0,0.3);
        pad.leds_on();
        wait(0.3);
        pad.leds_off();
        wait(0.2);
        pad.tone(1500.0,1.0);
        pad.leds_on();
        wait(1.0);
        pad.leds_off();
        wait(0.5);
        _state=4; //switch to game over state
      }
}

     //check the claw collision 
void MinerEngine::check_claw_collision(Gamepad &pad)
{
    Vector2D claw_pos = _claw.get_pos();// read current claw position
    for (int i=0;i<9;i++) {
    if (_gold_reached_num[i]==0) {
    Vector2D gold_pos = _gold.get_pos(i); //get the gold position
     if (claw_pos.x-gold_pos.x<5&&
        claw_pos.x-gold_pos.x>-5&&
        (claw_pos.y+3)-gold_pos.y>-2) {
        _claw_get=1; //this gold is caught by claw
        _gold.gold_caught(i);
       }
     }
   }
   if (claw_pos.y>HEIGHT-4||_claw_get==1) { 
        _claw.set_velocity(-(_claw_speed)); //inverse the claw speed if collision
         // audio feedback
         pad.tone(1000.0,0.1); }
    if (claw_pos.y<=14) { 
        _claw.set_velocity(0.0); //stop the claw when back to upper boundary
        _catching=0; //set catching flag to 0
        }
}

     //display the welcome page on LCD
void MinerEngine::welcome(Gamepad &pad, N5110 &lcd) {
        
        lcd.drawSprite(0,0,48,84,(int *)sprite); //draw the cover picture
        lcd.drawRect(4,31,25,9, FILL_WHITE); // draw the boundary
        lcd.drawRect(4,39,31,10, FILL_WHITE); 
        lcd.printString("GOLD",5,4);
        lcd.printString("MINER",5,5);
        lcd.drawLine(0,47,84,47,1); 
        lcd.refresh();
        
        while ( pad.check_event(Gamepad::START_PRESSED) == false) { 
           play_music(pad); //play the BGM while waiting for start
        }
        screen_rollup(pad,lcd); //roll up the picture
        loading(pad,lcd);  //display the loading page
}
  
     //display the game over page 
void MinerEngine::game_over(Gamepad &pad, N5110 &lcd) {
    lcd.clear();
    if ( pad.check_event(Gamepad::START_PRESSED) == false 
    && pad.check_event(Gamepad::JOY_PRESSED) == false 
    && pad.check_event(Gamepad::BACK_PRESSED) == false) 
    {
      lcd.drawRect(0,0,WIDTH,HEIGHT,FILL_TRANSPARENT); 
      lcd.drawRect(1,1,WIDTH-2,HEIGHT-2,FILL_TRANSPARENT);
      lcd.printString("!!Game Over!!",2,1);  //display the messages
      lcd.printString("[back][start]",2,3);
      lcd.printString(" menu restart",2,4);
      lcd.refresh();
      play_music(pad); }//play the BGM
      if (pad.check_event(Gamepad::START_PRESSED) == true
         ||pad.check_event(Gamepad::JOY_PRESSED) == true) {
            init(12,6,9,1); //press start to restart the game 
            _state=3; }//restart the game 
      if (pad.check_event(Gamepad::BACK_PRESSED) == true) {
            init(12,6,9,1); //press back to back to menu page
            _state=0; //back to menu state
      }
}

     //play the BGM and turn on and off the leds
void MinerEngine::play_music(Gamepad &pad) {
        pad.tone(370,0.15); 
        wait(0.35);
        pad.leds_on();
        wait(0.02);
        pad.leds_off();
        wait(0.02);
        pad.tone(554,0.15); 
        wait(0.35);
        pad.leds_on();
        wait(0.02);
        pad.leds_off();
        wait(0.02);
        pad.tone(493,0.15); 
        wait(0.35);
        pad.leds_on();
        wait(0.02);
        pad.leds_off();
        wait(0.02);
        pad.tone(554,0.15); 
        wait(0.2);
        pad.leds_on();
        wait(0.02);
        pad.leds_off();
        wait(0.02);
        pad.tone(659,0.15); 
        wait(0.35);
        pad.leds_on();
        wait(0.02);
        pad.leds_off();
        wait(0.02);
        pad.tone(554,0.15); 
        wait(0.35);
        pad.leds_on();
        wait(0.02);
        pad.leds_off();
        wait(0.02);
        pad.tone(493,0.15); 
        wait(0.35);
        pad.leds_on();
        wait(0.02);
        pad.leds_off();
        wait(0.02);
        pad.tone(554,0.15); 
        wait(0.35);
        pad.leds_on();
        wait(0.02);
        pad.leds_off();
        wait(0.02);
        pad.tone(554,0.15); 
        wait(0.2);
        pad.leds_on();
        wait(0.02);
        pad.leds_off();
        wait(0.02);   
}        

     //roll up the picture 
void MinerEngine::screen_rollup(Gamepad &pad, N5110 &lcd) {
    
        lcd.clear();
        for (int i=0;i<47;i++) {  //update all the pixel one by one 
           for(int m=0;m<47;m++) { 
              for (int n=0;n<84;n++) {
            sprite[m][n]= sprite[m+1][n];
            sprite[47][n]= 0;
              }
           }
            lcd.drawSprite(0,0,48,84,(int *)sprite); //draw the picture after each updating
            lcd.refresh();
            wait(0.1);
        }
}

      //play the loading animation 
void MinerEngine::loading(Gamepad &pad, N5110 &lcd) {
             
        lcd.printString("Loading....",12,0);
        lcd.drawRect(20,12,50,10,FILL_TRANSPARENT);
             
        for (int i=0;i<50;i++) {
            lcd.drawRect(20,12,i,10,FILL_BLACK); // update and gradually fill the progress bar
            lcd.refresh();
            wait(0.05);
        }
        lcd.printString("Complete!",20,4); //display complete message
        lcd.refresh();
        wait(0.8);
        lcd.clear();
}

      //check if gold reloading is needed
void MinerEngine::check_gold_reload() {
     int gold_left = _gold.get_left_num(); //get the left gold number
     if (gold_left<1) {
         _gold.init(9); //if the left number is less than 1 then reload the golds
         for (int i=0;i<9;i++) {
             _gold_reached_num[i] = 0; //initialise the reached flag of golds
         }
     }
}

     //play the tunnel animation
void MinerEngine::tunnel(Gamepad &pad, N5110 &lcd) {
    while(_h>24) {
        draw_tunnel(lcd); //draw the tunnel while the walking man dose not reach the destination
        _j++; //counting parameter for update the position of the walking man
        if (_j==5) {
            _j=0; //update the frame for 5 times then lift the man for 1 pixel
          if (_h>24) {
            _h--;}
          else {
            _h=24;} }// if the man get the center then stop
       draw_man(lcd); //draw the walking man 
        _i++; //update the counting parameters
        _n++;
        if (_i==10) {
            _i=0;} // the circle(loop) of 10 frame
        if (_n==8) {
            _n=0;}  //the circle(loop) of 8 frame
        lcd.refresh();
        wait(0.1); }
        tunnel_print(pad,lcd); //print the message
}

     //draw the tunnel
void MinerEngine::draw_tunnel(N5110 &lcd) {
        lcd.clear();
        lcd.drawRect(0,0,WIDTH,HEIGHT,FILL_TRANSPARENT); 
        lcd.drawRect(1,1,WIDTH-2,HEIGHT-2,FILL_TRANSPARENT);
        lcd.drawLine(41,24,18,47,1); //draw the track
        lcd.drawLine(42,24,19,47,1);
        lcd.drawLine(43,24,66,47,1);
        lcd.drawLine(42,24,65,47,1);
        lcd.drawCircle(42,24,2+_i,FILL_TRANSPARENT); //draw the wall of the tunnel(4 circles)
        lcd.drawCircle(42,24,12+_i,FILL_TRANSPARENT); 
        lcd.drawCircle(42,24,22+_i,FILL_TRANSPARENT);
        lcd.drawCircle(42,24,32+_i,FILL_TRANSPARENT);
        for(int _k=0;_k<23;_k++) {
        lcd.drawLine(42-_k,25+_k,42+_k,25+_k,0); //clear inside the track 
        }
        lcd.drawLine(38-_n,24+_n,46+_n,24+_n,1); //draw the track sleeper
        lcd.drawLine(38-_n,25+_n,46+_n,25+_n,1);
        lcd.drawLine(30-_n,32+_n,54+_n,32+_n,1);
        lcd.drawLine(30-_n,33+_n,54+_n,33+_n,1);
        lcd.drawLine(22-_n,40+_n,62+_n,40+_n,1);
        lcd.drawLine(22-_n,41+_n,62+_n,41+_n,1);
}

     //draw the walking man
void MinerEngine::draw_man(N5110 &lcd) {
            
        if(_z==1) {
          lcd.drawSprite(39,_h,10,7,(int *)man_state2); //print the state 2 man
          lcd.refresh();
          
        }         
        if(_z==-1) {
          lcd.drawSprite(39,_h,10,7,(int *)man_state1); //print the state 1 man
          
          lcd.refresh();
        }
       _z=-_z; //switch between the 2 state
}

void MinerEngine::tunnel_print(Gamepad &pad, N5110 &lcd) {
       //audio feedback
       pad.tone(500,0.2);
       wait(0.5);
       pad.tone(500,0.5);
       wait(0.5);
       lcd.printString("  WE ARE",2,1); //print the messages
       lcd.refresh();
       wait(1);
       lcd.printString("  IN THE",2,2);
       lcd.refresh();
       wait(1);
       lcd.printString("  MINE!!!",2,3);
       lcd.refresh();
       wait(1);
}