#ifndef GOLD_TEST_H
#define GOLD_TEST_H

/**
 * \brief Check that Gold object goes to correct position when moved
 * 
 * \returns true if all the tests passed
 */
bool Gold_test_movement()
{
    // Initialise Gold object with a gold number of 9
    Gold gold;
    gold.init(9);

    // Read the position of the 6th gold
    Vector2D read_pos_1 = gold.get_pos(6);
    int reached_num1 = gold.get_reached_num();
    printf("%f, %f\n", read_pos_1.x, read_pos_1.y);

    // Set the gold been caught and speed to 2
    gold.gold_caught(6);
    gold.set_speed(2);
    
    // Update the position
    gold.update();

    // Read the position
    Vector2D read_pos_2 = gold.get_pos(6);
    int reached_num2 = gold.get_reached_num();
    printf("%f, %f\n", read_pos_2.x, read_pos_2.y);
    
    // Now check that both the positions are as expected
    bool success_flag = true;
    
    // Fail the test if the final position is wrong
        if (read_pos_2.x != read_pos_1.x || read_pos_2.y != read_pos_1.y - 2
            || (read_pos_2.y<=17 && reached_num2 != reached_num1 + 1)) {
           success_flag = false;
        }
     
      if (read_pos_1.y > 17 && read_pos_2.y<=17 && reached_num2 != reached_num1 + 1) {
           success_flag = false;
        }
        
    return success_flag;
}
#endif