#ifndef CLAW_H
#define CLAW_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Winch.h"
#include "Monster.h"

/** Claw Class
@brief Controls the claw in the gold miner game 
@author Yufan Zhong, University of Leeds and SWJTU
@date May 2020
*/ 


class Claw
{

public:
    /** Constructor */
    Claw();
    
    /** Destructor */
    ~Claw();
    
    /** Initialise the claw
    *   @param  winch_width - The width of the winch
    */
    void init(int winch_width);
    
    /** Draw the claw
    *   @param  lcd - N5110 library
    */
    void draw(N5110 &lcd);
    
    /** Update the data
    *   @param  winch_pos - the position of the winch
    */
    void update(Vector2D winch_pos);
    
    /** Add the current score
    */
    void add_now_score();
    
    /** Get the current score
    *   @return the current score
    */
    int get_now_score();
    
    /** Set the velocity of claw
    *   @param  v - the velocity of the claw
    */
    void set_velocity(float v);
    
    /** Get the velocity
    *   @return the claw velocity
    */
    float get_velocity();
    
    /** Get the position of the claw
    *   @return the position of the claw.
    */
    Vector2D get_pos();
    
    /** Set position of the claw
    *   @param  p - position of the claw
    */
    void set_pos(Vector2D p);
    
    
    
private:
    int _winch_width;
    int _x0;
    int _y0;
    int _x1;
    int _y1;
    float _velocity_y;
    int _now_score;
    int _speed_x;
    
};
#endif