#include "Claw.h"

Claw::Claw()
{

}

Claw::~Claw()
{

}
// print the claw
int claw[4][7] = {
    {0,0,0,1,0,0,0},
    {0,0,1,1,1,0,0},
    {0,1,0,0,0,1,0},
    {1,0,0,0,0,0,1},
};

//initialise the claw
void Claw::init(int winch_width)
{   
    _winch_width = winch_width;
    _x0 = WIDTH/2; // the x0,y0 are the upper point
    _y0 = 14;
    _x1 = _x0;  // the x1,y1 are the lower claw point
    _y1 = _y0;
    _velocity_y = 0.0; // 0(stop);1(down);-1(up)
    _now_score = 0;
    _speed_x = 1; // horizontal speed of claw
}

//draw the claw and wire
void Claw::draw(N5110 &lcd)
{
    lcd.drawSprite(_x1-3,_y1,4,7,(int *)claw);
    lcd.drawLine(_x0,_y0,_x1,_y1,1);
}

void Claw::update(Vector2D winch_pos)
{
    _x0 = winch_pos.x+6; //follow the winch
    _x1 = _x0;
    _y1+=_velocity_y; //update the position
}

//add current score
void Claw::add_now_score()
{
    _now_score++;
}

//return current score
int Claw::get_now_score()
{
    return _now_score;
}

//set the velosity
void Claw::set_velocity(float v)
{
    _velocity_y = v;
}

//return velocity
float Claw::get_velocity()
{
    float v = _velocity_y;
    return v;
}

//get position
Vector2D Claw::get_pos()
{
    Vector2D p = {_x1,_y1};
    return p;
}

//set position
void Claw::set_pos(Vector2D p)
{
    _x1 = p.x;
    _y1 = p.y;
}
