#ifndef CLAW_TEST_H
#define CLAW_TEST_H

/**
 * \brief Check that Claw object goes to correct position when moved
 * 
 * \returns true if all the tests passed
 */
bool Claw_test_movement()
{
    // Initialise Claw object with a winch width of 12
    Claw claw;
    claw.init(12);

    // Set the position to 42,15
    Vector2D initial_pos = {42, 15};
    claw.set_pos(initial_pos);

    // Read the position
    Vector2D read_pos_1 = claw.get_pos();
    printf("%f, %f\n", read_pos_1.x, read_pos_1.y);

    // Set the velocity to 1
    float velocity = 1.0;
    claw.set_velocity(velocity);

    // Update the position
    Vector2D winch_pos = {35,9};
    claw.update(winch_pos);

    // Read the position
    Vector2D read_pos_2 = claw.get_pos();
    printf("%f, %f\n", read_pos_2.x, read_pos_2.y);
    
    // Now check that both the positions are as expected
    bool success_flag = true;
    
    // Fail the test if the initial position is wrong
    if (read_pos_1.x != 42 || read_pos_1.y != 15) {
        success_flag = false;
    }
    
    // Fail the test if the final position is wrong
    if (read_pos_2.x != 41 || read_pos_2.y != 16) {
        success_flag = false;
    }
    return success_flag;
}
#endif