/* 
ELEC2645 Embedded Systems Project 
School of Electronic & Electrical Engineering 
University of Leeds 

Name: Yufan Zhong
Username: el17yz
Student ID Number: 201199708
Date: May,2020

*/ 
 

///////// pre-processor directives ////////
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "MinerEngine.h"

#ifdef DEBUG
# include "tests.h"
#endif

#define WINCH_WIDTH 12
#define WINCH_HEIGHT 6
#define CLAW_SPEED 3
#define MONSTER_SIZE 3
#define MONSTER_SPEED 1
#define GOLD_NUM 9
/////////////// structs /////////////////
struct UserInput {
    Direction d;
    float mag;
};
/////////////// objects ///////////////
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
MinerEngine miner;

///////////// prototypes ///////////////
void init();

///////////// functions ////////////////
int main()
{
     
#ifdef DEBUG
    int number_of_failures = run_all_tests();

    if(number_of_failures > 0) return number_of_failures;
#endif

    init();     // initialise and then display welcome screen...
    miner.welcome(pad,lcd);  // waiting for the user to start
     
    // game loop - switch the state - read input, update the game state and render the display
    while (1) {
         miner.state_switch(pad,lcd);
    }
}

// initialies all classes and libraries
void init()
{
    // need to initialise LCD and Gamepad 
    lcd.init();
    pad.init();
    // initialise the game with correct winch sizes, gold number and monster speed
    miner.init(WINCH_WIDTH,WINCH_HEIGHT,GOLD_NUM,MONSTER_SPEED);
    miner.init_unchanged_parameter(); //initialise the highest score
}
