#include "Winch.h"

// nothing doing in the constructor and destructor
Winch::Winch()
{

}
Winch::~Winch()
{

}

//initialise the winch
void Winch::init(int height,int width)
{
    _height = height;
    _width = width;
    _y = 8;  //
    _x = WIDTH/2 - _width/2;  
    _speed_x = 1;  // default speed
    _highest_score = 0;  // start score from zero

}

//draw the winch
void Winch::draw(N5110 &lcd)
{
    // draw Winch in screen buffer. 
    lcd.drawRect(_x,_y,_width,_height,FILL_TRANSPARENT);
    lcd.drawLine(_x+1,_y,_x+1,_y+5,1); 
    lcd.drawLine(_x+3,_y,_x+3,_y+5,1); 
    lcd.drawLine(_x+5,_y,_x+5,_y+5,1); 
    lcd.drawLine(_x+7,_y,_x+7,_y+5,1); 
    lcd.drawLine(_x+9,_y,_x+9,_y+5,1); 
}

//update the position of the winch
void Winch::update(Direction d,float mag)
{
    _speed_x = int(mag*5.0f);  // scale is arbitrary, could be changed in future
    // update x value depending on direction of movement
    //W is left and E is right
    if (d == W) {
        _x-=_speed_x;
    } else if (d == E) {
        _x+=_speed_x;
    }
    // check the x to ensure that the Winch doesn't go off screen
    if (_x < 1) {
        _x = 1;
    }
    if (_x > WIDTH - _width - 1) {
        _x = WIDTH - _width - 1;
    }
}

//add highest score
void Winch::add_highest_score()
{
    _highest_score++;
}

//return highest score
int Winch::get_highest_score()
{
    return _highest_score;
}

//return position of winch
Vector2D Winch::get_pos() {
    Vector2D p = {_x,_y};
    return p;    
}

//set the position of the winch
void Winch::set_pos(Vector2D p) {
    _x = p.x;
    _y = p.y;
}

//return the speed of winch
float Winch::get_speed() {
    float speed_winch=_speed_x;
    return speed_winch;
}