#ifndef MONSTER_TEST_H
#define MONSTER_TEST_H

/**
 * \brief Check that Monster object goes to correct position when moved
 * 
 * \returns true if all the tests passed
 */
bool Monster_test_movement()
{
    // Initialise Monster object with a speed of 2
    Monster monster;
    monster.init(2);
    
    // test 1
    // Set the x position to 42
    monster.set_pos(42);

    // Read the position
    int read_pos_1 = monster.get_pos();
    printf("%d \n", read_pos_1);

    // Update the position
    monster.update();

    // Read the position
    int read_pos_2 = monster.get_pos();
    printf("%d \n", read_pos_2);
    
    // test2 
    // Set the x position to -2
    monster.set_pos(-2);

    // Read the position
    int read_pos_3 = monster.get_pos();
    printf("%d \n", read_pos_3);

    // Update the position
    monster.update();

    // Read the position
    int read_pos_4 = monster.get_pos();
    printf("%d \n", read_pos_4);
    
    // Now check that both the positions are as expected
    bool success_flag = true;
    
    // Fail the test if the initial position is wrong
    if (read_pos_1 != 42 || read_pos_2 != 40) {
        success_flag = false;
    }
    
    if (read_pos_3 != -2 || read_pos_4 != 84) {
        success_flag = false;
    }

    return success_flag;
}
#endif