#ifndef GOLD_H
#define GOLD_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Winch.h"
#include "Monster.h"
#include "time.h"

/** Gold Class
@brief Controls the gold in the gold miner game 
@author Yufan Zhong, University of Leeds and SWJTU
@date May 2020
*/ 

class Gold
{

public:
    /** Constructor */
    Gold();
    
    /** Destructor */
    ~Gold();
    
    /** Initialise the gold 
    *   @param  gold_num - number of the gold
    */
    void init(int gold_num);
    
    /** Draw the golds
    *   @param  lcd - N5110 library
    */
    void draw(N5110 &lcd);
    
    /** Update the data
    */
    void update();
    
    /** Mark the gold which has been caught
    *   @param  caught_i - the serial number of the captured gold
    */
    void gold_caught(int caught_i);
    
    /** Get the number of lifted gold
    *   @return the number of lifted gold.
    */
    int get_reached_num();
    
    /** Get the number of left golds
    *   @return the number of left golds.
    */
    int get_left_num();
    
    /** Get the position of the gold 
    *   @param  gold_i - the serial number of the gold
    *   @return the position of the gold
    */
    Vector2D get_pos(int gold_i);
    
    /** Set the position of the gold
    *   @param  p - the position of the gold
    */
    void set_pos(Vector2D p);
    
    /** Set the speed of the caught gold
    *   @param  speed - the speed of the gold
    */
    void set_speed(int speed);
    
private:
    int _gold_num;
    int _gold_left;
    int _gold_caught[12];
    int _gold_reached[12];
    int _x[12];
    int _y[12];
    int _gold_speed;
    
};
#endif