#include "Gold.h"

Gold::Gold()
{

}

Gold::~Gold()
{

}
// initialise the gold
void Gold::init(int gold_num)
{
     _gold_num = gold_num; //number of gold
     _gold_left = _gold_num; //left number
      //create random positions for golds
     srand(time(NULL)); 
     _gold_speed=1;
     for (int i=0;i<_gold_num;i++){
       _gold_caught[i] = 0;
       _gold_reached[i] = 0;
       _x[i] = 3+(rand()%78);
       _y[i] = 19+(rand()%27); 
     }
}

//draw the golds
void Gold::draw(N5110 &lcd)
{
    for (int i=0;i<9;i++){
        if(_gold_reached[i]==0){
          lcd.drawCircle(_x[i],_y[i],2,FILL_BLACK); // draw circles as golds
          }
    } 
    lcd.refresh();
}

//update the positions of golds
void Gold::update()
{
    for (int i=0;i<_gold_num;i++) {
        //if the gold is been caught, it will go up
        if (_gold_caught[i]==1&&_gold_reached[i]==0) {
            _y[i]-=_gold_speed;
            //if gold reached the upper boundary, reached flag will be 1
            //and left number will -1
           if (_y[i]<=17) {
              _gold_reached[i]=1;
              _gold_left--;
           }
        }
    }
}

//mark the gold has been caught
void Gold::gold_caught(int caught_i)
{
    _gold_caught[caught_i]=1;
}

// return the lifted gold number
int Gold::get_reached_num()
{
    int n=0;
    for (int i=0;i<_gold_num;i++){
        if (_gold_reached[i]==1){
             n+=1;
            }
        }
    return n;
}

//reyurn the number of left gold
int Gold::get_left_num()
{
    int left_n = _gold_left;
    return left_n;
}

//return the position of gold with serial number gold_i
Vector2D Gold::get_pos(int gold_i)
{
    Vector2D p = {_x[gold_i],_y[gold_i]};
    return p;
}

//set the position of gold with serial number gold_i
void Gold::set_pos(Vector2D p) {
    for (int i=0;i<_gold_num;i++){
        if(_gold_reached[i]==0){
          _x[i] = p.x;
          _y[i] = p.y;
        }
    }
}

//set the rising speed of gold
void Gold::set_speed(int speed) {
    _gold_speed = speed;
}