#include "mbed.h"
#include "uLCD_4DGL.h"
#include "rtos.h"

//DigitalOut myled(LED1);
DigitalIn brakeSwitch(p5);
DigitalIn blinkerSwitchL(p7);
DigitalIn blinkerSwitchR(p6);
//AnalogIn throttleIn(p15);
AnalogIn battVoltIn(p15);
AnalogIn photoresistIn(p16);
AnalogIn rpmIn(p17);

uLCD_4DGL uLCD(p9,p10,p11);
//PwmOut throttleOut(p21);
DigitalOut leftBlinker(p22);
DigitalOut rightBlinker(p23);
DigitalOut brakeLight(p24);
DigitalOut headlight(p25);
int brakeRunningLight = 0;
Ticker left;
Ticker right;
int blinked = 0;
//double speed = 0;
double batteryPercent = .5;
double throttlePercent = 0;
double battMax = .55;
//double throttleMin = 0.86;
//double throttleMax = 3.29;
double rpm = 0;
int offOnL = 0;
int offOnR = 0;
double photo = photoresistIn;

void Brake(void const *args)
{
    while(true) {
        if (!brakeRunningLight) {
            if (brakeSwitch == 1) {
                //throttleOut = 0;
                if (blinked == 0) {
                    //int i = 0;
                    for (int i = 0; i < 6; i++){
                        brakeLight = !brakeLight;
                        wait(.1);
                    }
                    blinked = 1;
                }
                //stay on
                brakeLight = 1;
                //switch off throttle
            } else {
                //brake light off
                blinked = 0;
                brakeLight = 0;
            }
        } else {
            if (brakeSwitch == 1) {
                //throttleOut = 0;
                if (blinked == 0) {
                    //int i = 0;
                    for (int i = 0; i < 6; i++){
                        leftBlinker = !leftBlinker;
                        rightBlinker = !rightBlinker;
                        wait(.1);
                    }
                    blinked = 1;
                }
                //stay on
                leftBlinker = 1;
                rightBlinker = 1;
                //switch off throttle
            } else {
                //brake light off
                blinked = 0;
                leftBlinker = 0;
                rightBlinker = 0;
            }
        }
        Thread::wait(200);
    }
}

//void Throttle(void const *args)
//{
//    while(true) {
//        if (brakeSwitch == 1) {
//            //throttleOut = 0;
//        } else {
//            //throttleOut = throttleIn;
//            //throttlePercent = (double)throttleIn / throttleMax;
//        }
//        Thread::wait(100);
//    }
//}

void lights(void const *args)
{
    while(true) {
        if (photoresistIn <= .15) {
            headlight = 1;
            brakeRunningLight = 1;
        } else if (photoresistIn >= .35){
            headlight = 0;
            brakeRunningLight = 0;
        }
        Thread::wait(200);
    }
}

void battery(void const *args)
{
    while(1) {
        batteryPercent = (double)((double)battVoltIn / battMax);    
        Thread::wait(5000);
    }
}

void RPM(void const *args)
{
    rpm = (float(rpmIn) / 2.3);
}

void blinker(void const *args) {
    if (offOnL) {
        if (leftBlinker) {
            leftBlinker = 0;
        } else {
            leftBlinker = 1;
        }
    } else {
        leftBlinker = 0;
    }
    
    if (offOnR) {
        if (rightBlinker) {
            rightBlinker = 0;
        } else {
            rightBlinker = 1;
        }
    } else {
        rightBlinker = 0;
    }
    Thread::wait(500);
}

int main() {
    uLCD.locate(0,0);
    uLCD.printf("Speed: ");
    uLCD.locate(0,3);
    uLCD.printf("Battery:");
    blinkerSwitchL.mode(PullUp);
    blinkerSwitchR.mode(PullUp);
    brakeSwitch.mode(PullDown);
    brakeLight = 1;
    Thread t1(Brake);
    Thread t2(RPM);
    Thread t3(lights);
    Thread t4(battery);
    while(1) {
        photo = photoresistIn;
        //start threads
        Thread t5(blinker);
        
        if (!blinkerSwitchL) {
            if (offOnL) {
                offOnL = 0;
            } else {
                offOnL = 1;
            }
        }
        if (!blinkerSwitchR) {
            if (offOnR) {
                offOnR = 0;
            } else {
                offOnR = 1;
            }
        }
        uLCD.locate(8,0);
        uLCD.printf("%f", photo);//rpm*100);
        uLCD.rectangle(0,8, 127, 16, WHITE);
        uLCD.filled_rectangle(1,9, 126, 15, BLACK);
        uLCD.filled_rectangle(1,9, rpm*127, 15, BLUE);
        uLCD.locate(8,3);
        uLCD.printf("%f", batteryPercent);
        uLCD.rectangle(0,33, 127, 41, WHITE);
        uLCD.filled_rectangle(1,34, 126, 40, BLACK);
        uLCD.filled_rectangle(1,34, batteryPercent*127, 40, BLUE);
        uLCD.locate(11,3);
        Thread::wait(.1);
    }
}
