#ifndef _SPI_H_
#define _SPI_H_
#define SCK_slave       1       
#define MISO_slave      6       
#define MOSI_slave      7       
#define CS_slave        8    



#define CCR_EN      0
#define CCR_TCIE    1
#define CCR_HTIE    2
#define CCR_TEIE    3
#define CCR_DIR     4
#define CCR_CIRC    5
#define CCR_PINC    6
#define CCR_MINC    7
#define CCR_PSIZE   8
#define CCR_MSIZE   10
#define CCR_PL      12
#define CCR_MEM2MEM 14   

#define clr_CS()    GPIOA->BSRR=(1u<<(CS_slave+16))
#define set_CS()    GPIOA->BSRR=(1u<<CS_slave)

#define CLEAR_SPI1_CR2_RXDMAEN_BIT()        SPI1->CR2 &= ~(0x01<<0)
#define SET_SPI1_CR2_RXDMAEN_BIT()          SPI1->CR2 |=  (0x01<<0)

#define CLEAR_SPI1_CR2_TXDMAEN_BIT()        SPI1->CR2 &= ~(0x01<<1)
#define SET_SPI1_CR2_TXDMAEN_BIT()          SPI1->CR2 |=  (0x01<<1)

#define DMA1_CH2_DISABLE()                         DMA1_Channel2->CCR &= ~(0x01<<CCR_EN) 
#define DMA1_CH3_DISABLE()                         DMA1_Channel3->CCR &= ~(0x01<<CCR_EN)

//#include <stm32f4xx.h>
#include <stm32l4xx.h> //Uncomment this to use the nano board and comment the one above

int transfer_spi_slave(unsigned short send_val);
int transfer_spi_master(unsigned short send_val);
void init_spi1(void);

#endif
