#include "SPI.h"
#include "mbed.h"

/*
    This SPI slave is written for the STM32L432 board as it has different pin layout to the
    STM32F429.
*/

int transfer_spi_slave(unsigned short send_val)
{
    int16_t rx_data = 0;
                                                                                
    SPI1->DR=send_val;                                                           //Send data
    while((SPI1->SR&0x01) != 1 && (SPI1->SR&0x02) != 1);                         //wait while BSY bit set and TXE bit sets, when BSY bit clears spi bus is no longer busy, when data is transmitted TXE bit sets
    rx_data = SPI1->DR;                                                          //Save the read data to rx_data
    
    return rx_data;
}


void init_spi_slave(void)
{

    RCC->APB2ENR|=RCC_APB2ENR_SPI1EN;
    //CONFIG GPIOS
    GPIOA->MODER&=~((3u<<(2*CS_slave)));                                         //clear GPIOA pin mode (in input mode when reset)
    
    GPIOA->MODER&=~(                                                             //clear GPIOB
            (3u<<(2*SCK_slave))
            |(3u<<(2*MISO_slave))
            |(3u<<(2*MOSI_slave))
        //  |(3u<<(2*CS_pin))
            |0x03
                );
    GPIOA->MODER|=(                                                              //reset GPIOA pins
            (2u<<(2*SCK_slave))
            |(2u<<(2*MISO_slave))
            |(2u<<(2*MOSI_slave))
        //  |(3u<<(2*CS_pin))
            |0x01
                );
    GPIOA->AFR[0]&=~(                                                            //clear alternate function selector bits
            (0x0f<<(4*SCK_slave))
            |(0x0f<<(4*MISO_slave))
            |(15u<<(4*MOSI_slave))
        //  |(0x0f<<(4*CS_pin))
                );
    GPIOA->AFR[0]|=(                                                             //reset alternate function selector bits to SPI1
            (5u<<(4*SCK_slave))
            |(5u<<(4*MISO_slave))
            |(5u<<(4*MOSI_slave))
        //  |(5u<<(4*CS_pin))
                );
                
    //set_CS();
    
    CLEAR_SPI1_CR2_RXDMAEN_BIT();
    CLEAR_SPI1_CR2_TXDMAEN_BIT();
    DMA1_CH2_DISABLE();
    DMA1_CH3_DISABLE();
    
        //CONFIG SPI MODULE
    RCC->APB2ENR|=RCC_APB2ENR_SPI1EN;
    SPI1->CR1&=~(                                                                //module disabled, clear bad rate bits
            SPI_CR1_SPE                                                          //SPE has to be disabled so that the SPI can be set to 16-bit mode
            |SPI_CR1_MSTR                                                        //Bit cleared to put the board into slave mode.
            |SPI_CR1_BR     
            |SPI_CR1_SSM
//          |SPI_CR1_CPOL                                                        //Set clock polirty to 0
//          |SPI_CR1_CPHA                                                        //Set clock phase to 0
                            );
                               
            SPI1->CR2 |=(0xF<<8);                                                //Set the data frame to 16 bits STM32L432 only.
                            
            SPI1->CR1|=(                                                         
            SPI_CR1_SSI                                                          //set internal slave select
            //|SPI_CR1_SSM                                                       //SS control set
            //|SPI_CR1_MSTR                                                      //master mode
            |(3u<<3)                                                             //baud rate bits set /16 giving 1MHz SCK frequency
            |SPI_CR1_CPOL                                                        //Set clock polirty to 1
            |SPI_CR1_CPHA                                                        //Set clock phase to 1
            |SPI_CR1_SPE                                                         //SPI module enabled
                            );
                             
}

void init_spi_ports(void) {
    //Enable GPIOA clock on which the SPI1 pins are located
    RCC->AHB2ENR|= (RCC_AHB2ENR_GPIOAEN);                                        //GPIO A clock enable       
    init_spi_slave();                                                            //Initialise SPI slave
}

void init_spi1(void)
{
    init_spi_ports();

}