#include "CustomDatatypes.h"

typedef struct {
    double w;
    double x;
    double y;
    double z;
} Quaternion;

typedef struct {
    double roll;
    double pitch;
    double yaw;
} Rotation;



//-----------------------------Functions--------------------------------------//
Quaternion toQuaternionNotation(vector AngularRate, double dt);
Quaternion getQuaternionProduct(Quaternion previousQ, Quaternion deltaQ);
Quaternion quaternionConjugate(Quaternion Q);
Quaternion updateQuaternion(Quaternion Qprevious, vector angularRate, double deltaTime);
vector quaternion2Vector(Quaternion Q);
Quaternion vector2Quaternion(vector v);
vector rotateVector(Quaternion Q, vector v);
Quaternion normaliseQuaternion(Quaternion Q);
double getQuaternionNorm(Quaternion Q);
Quaternion getQaDelta(Quaternion Q);
vector crossProduct(vector v1, vector v2);
Quaternion sumQuaternion(Quaternion Q1, Quaternion Q2);
vector sumVector(vector v1, vector v2);
Quaternion getQVproduct(Quaternion Q, vector v);
vector rotateGlobal(vector v1, Quaternion Q);
vector rotateLocal(vector v1, Quaternion Q);
vector mul(float a, vector v);
vector eulerA(Quaternion Q);
Quaternion euler2Quaternion(Quaternion Q);


Quaternion toQuaternionNotation123(vector AngularRate, double dt);
//-----------------------------Functions--------------------------------------//