#include "CustomDatatypes.h"
#include "mbed.h"


class IMU {
    
    private :
        //Variables
        vector GyroscopeOffset;
        vector AccelerometerOffset;
        char IMU_Identifier;
        double accelSSF, gyroSSF;
        Timer t;    
        vector CFAngle; 
        //Functions
        

    public :
    //Variables-----------------------------------------------------------------
        vector AcceAngle;
        vector GyroAngle;
        vector RawAccel;
        vector SSFRawAccel;
        vector RawGyro;
        vector SSFRawGyro;
        vector CFQuaternion;
        volatile char busyFlag;
    //Variables-----------------------------------------------------------------
    
    
    //Functions-----------------------------------------------------------------
        IMU(char IMU_ID, double OffsetAX, double OffsetAY, double OffsetAZ, double OffsetGX, double OffsetGY, double OffsetGZ, char SSFA, char SSFG);
        IMU_Data concatenateData(int16_t SamplesPieces[12]);
        IMU_Data SSFmultiply(IMU_Data RawData);
        IMU_Data getAngles(IMU_Data SSF_Format_Values, float dt);
        
        IMU_Data CalculateAngles(int16_t SamplesPieces[12]);
        vector CalculateCFAngles(int16_t SamplesPieces[12]);
        vector CalculateQCFAngles(int16_t SamplesPieces[12]);
        vector getAccelAngles(vector SSF_Accel);
        //void CFAngle();
    //Functions-----------------------------------------------------------------
    };