#ifndef _DMA_SPI_H_
#define _DMA_SPI_H_

#define C2S     2
#define C3S     3

#define CCR_EN      0
#define CCR_TCIE    1
#define CCR_HTIE    2
#define CCR_TEIE    3
#define CCR_DIR     4
#define CCR_CIRC    5
#define CCR_PINC    6
#define CCR_MINC    7
#define CCR_PSIZE   8
#define CCR_MSIZE   10
#define CCR_PL      12
#define CCR_MEM2MEM 14


#define SPI1_DISABLE()      SPI1->CR1 &= ~SPI_CR1_SPE                           //Clear SPE bit in SPI1 CR1 register
#define SPI1_ENABLE()       SPI1->CR1 |=  SPI_CR1_SPE

#define CLEAR_SPI1_CR1_CRC_BIT()      SPI1->CR1 &= ~SPI_CR1_CRCEN

#define CLEAR_SPI1_CR1_MSTR_BIT()    SPI1->CR1 &= ~SPI_CR1_MSTR
#define SET_SPI1_CR1_MSTR_BIT()      SPI1->CR1 |=  SPI_CR1_MSTR

#define CLEAR_SPI1_CR1_BR_BITS()      SPI1->CR1 &= ~SPI_CR1_BR
#define SET_SPI1_CR1_BR_BITS()       SPI1->CR1 |= (3u<<3)                                //Sets the frequency to 1MHz 16/16 = 1

#define CLEAR_SPI1_CR1_SSM_BIT()      SPI1->CR1 &= ~SPI_CR1_SSM
#define SET_SPI1_CR1_SSM_BIT()        SPI1->CR1 |= SPI_CR1_SSM

#define CLEAR_SPI1_CR1_SSI_BIT()      SPI1->CR1 &= ~SPI_CR1_SSI
#define SET_SPI1_CR1_SSI_BIT()        SPI1->CR1 |= SPI_CR1_SSI                          

#define CLEAR_SPI1_CR1_CPOL_BIT()    SPI1->CR1 &= ~SPI_CR1_CPOL
#define SET_SPI1_CR1_CPOL_BIT()      SPI1->CR1 |=  SPI_CR1_CPOL

#define CLEAR_SPI1_CR1_CPHA_BIT()    SPI1->CR1 &= ~SPI_CR1_CPHA
#define SET_SPI1_CR1_CPHA_BIT()      SPI1->CR1 |=  SPI_CR1_CPHA

#define CLEAR_SPI1_CR2_DS_BITS()    SPI1->CR2 &= ~(0xF<<8) 
#define SET_SPI1_CR2_DS_BITS()      SPI1->CR2 |=  (0xF<<8)                       //Sets data frame to 16-bits

#define CLEAR_SPI1_CR2_RXDMAEN_BIT()        SPI1->CR2 &= ~(0x01<<0)
#define SET_SPI1_CR2_RXDMAEN_BIT()          SPI1->CR2 |=  (0x01<<0)

#define CLEAR_SPI1_CR2_TXDMAEN_BIT()        SPI1->CR2 &= ~(0x01<<1)
#define SET_SPI1_CR2_TXDMAEN_BIT()          SPI1->CR2 |=  (0x01<<1)

#define CLEAR_SPI1_CR2_RXEIE_BIT()        SPI1->CR2 &= ~(0x01<<6)
#define SET_SPI1_CR2_RXEIE_BIT()          SPI1->CR2 |=  (0x01<<6)

#define CLEAR_SPI1_CR2_TXEIE_BIT()        SPI1->CR2 &= ~(0x01<<7)
#define SET_SPI1_CR2_TXEIE_BIT()          SPI1->CR2 |=  (0x01<<7)


#define CLEAR_DMA1_SPI1RX_CSELR_BITS()      DMA1_CSELR->CSELR &= ~(0x01<<(4*(C2S - 1)))     //deselect SPI1_Rx on DMA1 Channel 2
#define SET_DMA1_SPI1RX_CSELR_BITS()        DMA1_CSELR->CSELR |=  (0x01<<(4*(C2S - 1)))     //Select SPI1_Rx on DMA1 Channel 2

#define CLEAR_DMA1_SPI1TX_CSELR_BITS()      DMA1_CSELR->CSELR &= ~(0x01<<(4*(C3S - 1)))     //deselect SPI1_Tx on DMA1 Channel 3
#define SET_DMA1_SPI1TX_CSELR_BITS()        DMA1_CSELR->CSELR |=  (0x01<<(4*(C3S - 1)))     //Select SPI1_Tx on DMA1 Channel 3


//--------------------------------------Channel2-----------------------------------------------------

#define DMA1_CH2_DISABLE()                         DMA1_Channel2->CCR &= ~(0x01<<CCR_EN) 
#define DMA1_CH2_ENABLE()                          DMA1_Channel2->CCR |=  (0x01<<CCR_EN) 

#define CLEAR_DMA1_CH2_CCR_DIR_BIT()               DMA1_Channel2->CCR &= ~(0x01 << CCR_DIR)
#define SET_DMA1_CH2_CCR_DIR_BIT()                 DMA1_Channel2->CCR |=  (0x01 << CCR_DIR)  

#define CLEAR_DMA1_CH2_CCR_PSIZE_BITS()            DMA1_Channel2->CCR &= ~(0x01 << CCR_PSIZE) 
#define SET_DMA1_CH2_CCR_PSIZE_BITS()              DMA1_Channel2->CCR |=  (0x01 << CCR_PSIZE)   //Set peripheral size to 16-bits

#define CLEAR_DMA1_CH2_CCR_MSIZE_BITS()            DMA1_Channel2->CCR &= ~(0x01 << CCR_MSIZE) 
#define SET_DMA1_CH2_CCR_MSIZE_BITS()              DMA1_Channel2->CCR |=  (0x01 << CCR_MSIZE)   //Set peripheral size to 16-bits

#define CLEAR_DMA1_CH2_CCR_MINC_BIT()              DMA1_Channel2->CCR &= ~(0x01 << CCR_MINC)
#define SET_DMA1_CH2_CCR_MINC_BIT()                DMA1_Channel2->CCR |=  (0x01 << CCR_MINC) 

#define CLEAR_DMA1_CH2_CCR_PINC_BIT()              DMA1_Channel2->CCR &= ~(0x01 << CCR_PINC)
#define SET_DMA1_CH2_CCR_PINC_BIT()                DMA1_Channel2->CCR |=  (0x01 << CCR_PINC) 

#define CLEAR_DMA1_CH2_CCR_TCIE_BIT()              DMA1_Channel2->CCR &= ~(0x01 << CCR_TCIE)
#define SET_DMA1_CH2_CCR_TCIE_BIT()                DMA1_Channel2->CCR |=  (0x01 << CCR_TCIE)

#define CLEAR_DMA1_CH2_CCR_CIRC_BIT()              DMA1_Channel2->CCR &= ~(0x01 << CCR_CIRC)
#define SET_DMA1_CH2_CCR_CIRC_BIT()                DMA1_Channel2->CCR |=  (0x01 << CCR_CIRC)

#define CLEAR_DMA1_CH2_CCR_MEM2MEM_BIT()           DMA1_Channel2->CCR &= ~(0x01 << CCR_CIRC)
#define SET_DMA1_CH2_CCR_MEM2MEM_BIT()             DMA1_Channel2->CCR |=  (0x01 << CCR_CIRC)

#define CLEAR_DMA1_CH2_CCR_PL_BITS()               DMA1_Channel2->CCR &= ~(0x03 << CCR_PL)
#define SET_DMA1_CH2_CCR_PL_BITS()                 DMA1_Channel2->CCR |=  (0x03 << CCR_PL)         //Set to highest priority level

#define CLEAR_DMA1_CH2_CCR_TEIE_BIT()              DMA1_Channel2->CCR &= ~(0x01<< CCR_TEIE)
#define SET_DMA1_CH2_CCR_TEIE_BIT()                DMA1_Channel2->CCR |=  (0x01<< CCR_TEIE)

#define CLEAR_DMA1_CH2_CNDTR_BITS()                DMA1_Channel2->CNDTR  =  0
#define CLEAR_DMA1_CH2_CPAR_BITS()                 DMA1_Channel2->CPAR   =  0
#define CLEAR_DMA1_CH2_CMAR_BITS()                 DMA1_Channel2->CMAR   =  0

#define CLEAR_DMA1_CH2_IFCR_GFLAG()                DMA1->IFCR |= (1u << (4*(C2S - 1)))

//--------------------------------------Channel3-----------------------------------------------------

#define DMA1_CH3_DISABLE()        DMA1_Channel3->CCR &= ~(0x01<<CCR_EN) 
#define DMA1_CH3_ENABLE()         DMA1_Channel3->CCR |=  (0x01<<CCR_EN) 

#define CLEAR_DMA1_CH3_CCR_DIR_BIT()            DMA1_Channel3->CCR &= ~(0x01 << CCR_DIR)
#define SET_DMA1_CH3_CCR_DIR_BIT()              DMA1_Channel3->CCR |=  (0x01 << CCR_DIR)  

#define CLEAR_DMA1_CH3_CCR_PSIZE_BITS()            DMA1_Channel3->CCR &= ~(0x01 << CCR_PSIZE) 
#define SET_DMA1_CH3_CCR_PSIZE_BITS()              DMA1_Channel3->CCR |=  (0x01 << CCR_PSIZE)   //Set peripheral size to 16-bits

#define CLEAR_DMA1_CH3_CCR_MSIZE_BITS()            DMA1_Channel3->CCR &= ~(0x01 << CCR_MSIZE) 
#define SET_DMA1_CH3_CCR_MSIZE_BITS()              DMA1_Channel3->CCR |=  (0x01 << CCR_MSIZE)   //Set peripheral size to 16-bits

#define CLEAR_DMA1_CH3_CCR_MINC_BIT()            DMA1_Channel3->CCR &= ~(0x01 << CCR_MINC)
#define SET_DMA1_CH3_CCR_MINC_BIT()              DMA1_Channel3->CCR |=  (0x01 << CCR_MINC) 

#define CLEAR_DMA1_CH3_CCR_PINC_BIT()            DMA1_Channel3->CCR &= ~(0x01 << CCR_PINC)
#define SET_DMA1_CH3_CCR_PINC_BIT()              DMA1_Channel3->CCR |=  (0x01 << CCR_PINC) 

#define CLEAR_DMA1_CH3_CCR_TCIE_BIT()            DMA1_Channel3->CCR &= ~(0x01 << CCR_TCIE)
#define SET_DMA1_CH3_CCR_TCIE_BIT()              DMA1_Channel3->CCR |=  (0x01 << CCR_TCIE)

#define CLEAR_DMA1_CH3_CCR_CIRC_BIT()            DMA1_Channel3->CCR &= ~(0x01 << CCR_CIRC)
#define SET_DMA1_CH3_CCR_CIRC_BIT()              DMA1_Channel3->CCR |=  (0x01 << CCR_CIRC)

#define CLEAR_DMA1_CH3_CCR_MEM2MEM_BIT()            DMA1_Channel3->CCR &= ~(0x01 << CCR_CIRC)
#define SET_DMA1_CH3_CCR_MEM2MEM_BIT()              DMA1_Channel3->CCR |=  (0x01 << CCR_CIRC)

#define CLEAR_DMA1_CH3_CCR_PL_BITS()            DMA1_Channel3->CCR &= ~(0x03 << CCR_PL)
#define SET_DMA1_CH3_CCR_PL_BITS()              DMA1_Channel3->CCR |=  (0x03 << CCR_PL)         //Set to highest priority level

#define CLEAR_DMA1_CH3_CCR_TEIE_BIT()            DMA1_Channel3->CCR &= ~(0x01<< CCR_TEIE)
#define SET_DMA1_CH3_CCR_TEIE_BIT()              DMA1_Channel3->CCR |=  (0x01<< CCR_TEIE)
     
#define CLEAR_DMA1_CH3_CNDTR_BITS()         DMA1_Channel3->CNDTR  =  0
#define CLEAR_DMA1_CH3_CPAR_BITS()          DMA1_Channel3->CPAR   =  0
#define CLEAR_DMA1_CH3_CMAR_BITS()          DMA1_Channel3->CMAR   =  0

#define CLEAR_DMA1_CH3_IFCR_GFLAG()         DMA1->IFCR |= (1u << (4*(C3S - 1)))


#define SCK_slave       1       
#define MISO_slave      6       
#define MOSI_slave      7           

#define clr_CS()    GPIOA->BSRR=(1u<<(CS_slave+16))
#define set_CS()    GPIOA->BSRR=(1u<<CS_slave)


#include <stm32l4xx.h> 
void initDMA();
extern int16_t data_to_transmit[12];
extern int16_t received_data[12];
extern int16_t IMU_Data_Array[12];
extern int16_t SampleFIFO[10][12];

extern int pointerOS;
extern int pointerNS;
extern int pointerFS;

extern char newDataFlag;
volatile extern char dataRequestFlag;
volatile extern char dataLoadedFlag;

void SPI_DMA_init();
void SPI_DMA_SLAVE_init();
void SPI_DMA_SLAVE_deinit();
void deinitDMA();
void startCommunication();

#endif
