//Reloj Digital

#include "mbed.h"
#include "TextLCD.h" //Librería para control de display LCD
 
TextLCD lcd(p15, p16, p17, p18, p19, p20); /* Asignación de pines
                                             para rs, e, d4, d5. d6,d7*/

//Contadores para cada dígito
int seg1=0; //Variable para contador de unidades de segundo
int seg2=0; //Variable para contador de décimas de segundo
int min1=0; //Variable para contador de unidades de minuto
int min2=0; //Variable para contador de décimas de minuto
int hor1=0; //Variable para contador de unidades de hora
int hor2=0; //Variable para contador de décimas de hora

void reloj(){//Subrutina para generar reloj de 6 segmentos
    lcd.locate(11,1);//Posicionamiento de las unidades de segundo
    lcd.printf("%i", seg1);
    lcd.locate(10,1);//Posicionamiento de las décimas de segundo
    lcd.printf("%i",seg2);
    lcd.locate(9,1);//Posicionamiento del doble punto
    lcd.printf(":");
    lcd.locate(8,1);//Posicionamiento de las unidades de minuto
    lcd.printf("%i",min1);
    lcd.locate(7,1);//Posicionamiento de las décimas de minuto
    lcd.printf("%i",min2);
    lcd.locate(6,1);//Posicionamiento del punto doble
    lcd.printf(":");
    lcd.locate(5,1);//Posicionamiento de las unidades de minuto
    lcd.printf("%i",hor1);
    lcd.locate(4,1);//Posicionamiento de las décimas de minuto
    lcd.printf("%i",hor2);
}
 
 
int main() {
    
    lcd.cls(); //Limpia el LCD
    lcd.locate(2, 0); //Posiciona en columna 2, fila 0)
    lcd.printf("Reloj digital"); //Imprime en LCD "Reloj digital"
    
    while (1){
        
        reloj(); //Llama a subrutina
            
        seg1++; //Inician el primer contador de unidades de segundo
        wait(1); //Genera tiempo de un segundo
        if (seg1==10){
            seg2++;//Contador décimas de segundo
            seg1=0;
            if (seg2==6){
                min1++;//Contador unidades de minuto
                seg2=0;
                if (min1==10){
                    min2++;//Contador décimas de minuto
                    min1=0;
                    if(min2==6){
                        hor1++;//Contador unidades de hora
                        min2=0;
                        if(hor1==10){
                            hor2++;//Contador décimas de hora
                            hor1=0;
                            if((hor2==2)&&(hor1==4)){/*Cuando el contador llega
                                                       a 24hrs, este se reinicia*/
                                hor2=0;
                                hor1=0;
                            }
                        }
                    }
                }
            }
        }  
    }
}