#include "mbed.h"

#include "TS_DISCO_F746NG.h" 

#include "LCD_DISCO_F746NG.h"

#include <stdio.h>

#define MAX 10

LCD_DISCO_F746NG lcd;
Serial pc(USBTX, USBRX, 115200);
Serial groove(A4, A5, 9600);
TS_DISCO_F746NG boutton;
int x = 0, y = 0; //Position des objets sur l'écran LCD



uint8_t status; 
const char laby[11][11] = {  //Le labyrinthe sous forme de tableau 2d
    "**********",
    "* *      *",
    "* ****** *",
    "*        *",
    "****** ***",
    "*       **",
    "* ** *** *",
    "* ****** *",
    "*        O",
    "**********",
};



const char * voiceBuffer[] = {    //Liste des commandes (La liste du dispositif commence par contre par 1 et non 0 comme dans notre tableau)
    "Turn on the light",
    "Turn off the light",
    "Play music",
    "Pause",
    "Next",
    "Previous",
    "Up",
    "Down",
    "Turn on the TV",
    "Turn off the TV",
    "Increase temperature",
    "Decrease temperature",
    "What's the time",
    "Open the door",
    "Close the door",
    "Left",
    "Right",
    "Stop",
    "Start",
    "Mode 1",
    "Mode 2",
    "Go",
};




void TryMove(int * joueurX, int * joueurY, int vx, int vy) {  //Fonction effectuant le mouvement du joueur tout en vérifiant sa faisabilité
                                                              //(Si la case de la direction choisit est vide ou contient "*" qui correspond ‡ un mur)
    if (laby[ * joueurY + vy][ * joueurX + vx] == '*')
        return;
    ( * joueurX) += vx;
    ( * joueurY) += vy;
}



void Afficher(int joueurX, int joueurY) {  // Fonction affichant le labyrinthe et la position du joueur

    for (int i = 0; i < MAX; i++) {  //On place les blocs, les cases vides et le joueur ligne par ligne, de gauche ‡ droite
        for (int j = 0; j < MAX; j++) {
            if (j == joueurX && i == joueurY) {
                lcd.DisplayChar(x + (48 / 2) - 8, y + (27 / 2) - 8, 'P');
            }
            if (laby[i][j] == '*') {
                lcd.DrawRect(x, y, 48, 27);
            }
            if (laby[i][j] == 'O') {
                lcd.DrawCircle(x + 48 / 2, y + 27 / 2, 13);
            }

            x += 48; //Passage à la colonne de droite
        }
        y += 27; //passage à la ligne suivante
        x = 0; //retour à la premiere colonne
    }


    y = 0; //retour à la premiere ligne

}


int main() {

    int joueurX = 8, joueurY = 8, xtouch, ytouch, idx;
    char cmd;
    bool bon = false, win = false;

    TS_StateTypeDef TS_State;


    lcd.SetFont( & Font16);
    lcd.SetBackColor(LCD_COLOR_GREEN);



    while (1) {
        
        /******* ECRAN DE DEPART *******/
        
        
        lcd.Clear(LCD_COLOR_BLUE);
        lcd.DisplayStringAt(0, LINE(1), (uint8_t * )
            "Toucher pour commencer le labyrinthe", LEFT_MODE);


        while (bon == false) {
            boutton.GetState( & TS_State);
            if (TS_State.touchDetected) {
                xtouch = TS_State.touchX[idx];
                ytouch = TS_State.touchY[idx];
                if ((xtouch > 0) && (xtouch < 450) && (ytouch > 0) && (ytouch < 250)) {

                    bon = true;
                    win = false;
                    lcd.Clear(LCD_COLOR_BLUE);
                }

            }
        }



/******* DEBUT DU JEU*******/


        Afficher(joueurX, joueurY);

        while (win == false) {




            if (groove.readable()) {  //Lorsque des informations transites on lit le dispositif

                pc.printf("READABLE \n \r");
                cmd = groove.getc();
                pc.printf("Commande : %s \n \r ", voiceBuffer[cmd - 1]); 


                while (!groove.readable() && win==false) {  //Mouvement effectué continuellement tant que le joueur ne parle pas à nouveau
                    switch (cmd) {

                        case 7:
                            TryMove( & joueurX, & joueurY, 0, -1); // Mouvement BAS
                            break;
                        case 8:
                            TryMove( & joueurX, & joueurY, 0, 1); // Mouvement HAUT
                            break;
                        case 16:
                            TryMove( & joueurX, & joueurY, -1, 0); // Mouvement GAUCHE
                            break;
                        case 17:
                            TryMove( & joueurX, & joueurY, 1, 0); // Mouvement DROITE
                            break;

                    }
                    
                    
                    

                    pc.printf("Mouvement joueur : %s \n \r", voiceBuffer[cmd - 1]);
                    //wait(2);
                    lcd.Clear(LCD_COLOR_BLUE);  // A chaque mouvement on efface l'Ècran puis on redessine le labyrinthe et le joueur
                    Afficher(joueurX, joueurY);
                    wait(1);
                    
                    

                    if (joueurX == 9 && joueurY == 8) {  // En cas de victoire
                        win = true;
                        bon = false;
                        joueurX=1;
                        joueurY=1;
                        lcd.Clear(LCD_COLOR_BLUE);
                        lcd.DisplayStringAt(0, LINE(5), (uint8_t * )
                            "PARTIE GAGNER !", CENTER_MODE);
                        wait(1);
                    }
                    
                    
                    
                    wait(1);
                }
            }
        }
    }
}