#include "mbed.h"
#include "USBMouse.h"
#include "USBSerial.h"

#define MMA8451_I2C_ADDRESS (0x1d<<1)
#define REG_WHO_AM_I      0x0D
#define REG_CTRL_REG_1    0x2A
#define REG_OUT_X_MSB     0x01
#define REG_OUT_Y_MSB     0x03
#define REG_OUT_Z_MSB     0x05
#define UINT14_MAX        16383

DigitalOut  myled(LED1);
USBMouse mouse;
I2C m_i2c(PTE25,PTE24);
  
  
  uint8_t getWhoAmI();
  float getAccX();
  float getAccY();
  float getAccZ();
  void getAccAllAxis(float * res);
  void readRegs(int addr, uint8_t * data, int len);
  void writeRegs(uint8_t * data, int len);
  int16_t getAccAxis(uint8_t addr);
  
int main() {
    float x, y, z;

    while (1) {
        x = (getAccX());
        y = (getAccY());
        z = (getAccZ());
        printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n", x, y, z);
        mouse.move(x/100, y/100);
        wait(0.01);
    }
}


void acc_Init()
{
    uint8_t data[2] = {REG_CTRL_REG_1, 0x01};
    writeRegs(data, 2);
}

uint8_t getWhoAmI()
{
    uint8_t who_am_i = 0;
    readRegs(REG_WHO_AM_I, &who_am_i, 1);
    return who_am_i;
}
float getAccX() 
{
    return (float(getAccAxis(REG_OUT_X_MSB))/4096.0);
}
float getAccY() 
{
    return (float(getAccAxis(REG_OUT_Y_MSB))/4096.0);
}
float getAccZ() {
    return (float(getAccAxis(REG_OUT_Z_MSB))/4096.0);
}
void getAccAllAxis(float * res) {
    res[0] = getAccX();
    res[1] = getAccY();
    res[2] = getAccZ();
}
int16_t getAccAxis(uint8_t addr) {
    int16_t acc;
    uint8_t res[2];
    readRegs(addr, res, 2);

    acc = (res[0] << 6) | (res[1] >> 2);
    if (acc > UINT14_MAX/2)
        acc -= UINT14_MAX;

    return acc;
}

void readRegs(int addr, uint8_t * data, int len) {
    char t[1] = {addr};
    m_i2c.write(MMA8451_I2C_ADDRESS, t, 1, true);
    m_i2c.read(MMA8451_I2C_ADDRESS, (char *)data, len);
}

void writeRegs(uint8_t * data, int len) {
    m_i2c.write(MMA8451_I2C_ADDRESS, (char *)data, len);
}
