/******************************************************************************
 * @file     M451Series.h
 * @version  V3.10
 * $Revision: 179 $
 * $Date: 15/09/04 3:45p $
 * @brief    CMSIS Cortex-M4 Core Peripheral Access Layer Header File for M451 Series MCU
 *
 * @note
 * Copyright (C) 2014~2015 Nuvoton Technology Corp. All rights reserved.
*****************************************************************************/


/**
  \mainpage Introduction
  *
  *
  * This user manual describes the usage of M451 Series MCU device driver
  *
  * <b>Disclaimer</b>
  *
  * The Software is furnished "AS IS", without warranty as to performance or results, and
  * the entire risk as to performance or results is assumed by YOU. Nuvoton disclaims all
  * warranties, express, implied or otherwise, with regard to the Software, its use, or
  * operation, including without limitation any and all warranties of merchantability, fitness
  * for a particular purpose, and non-infringement of intellectual property rights.
  *
  * <b>Copyright Notice</b>
  *
  * Copyright (C) 2014~2015 Nuvoton Technology Corp. All rights reserved.
  */

/**
  * \page PG_REV Revision History
  *
  * <b>Revision 3.01.001</b>
  * \li Added Nu-LB-M451, NuEdu and USB device sample code.
  * \li Added a lacking macro SYS_IS_LVR_RST() to SYS driver.
  * \li Added a sample code DAC_PDMA_ScatterGather_PWMTrigger to use PDMA scatter gather mode and trigger DAC by PWM.
  * \li Added counter type constant definitions: PWM_UP_COUNTER, PWM_DOWN_COUNTER, and PWM_UP_DOWN_COUNTER.
  * \li Added DAC_PDMA_PWMTrigger sample code to use PDMA and trigger DAC by PWM.
  * \li Added a sample code EADC_PDMA_PWM_Trigger to trigger EADC with PWM and copy result by PDMA.
  * \li Added a new function to control systick and select systick clock source CLK_EnableSysTick() and CLK_DisableSysTick() in CLK driver.
  * \li Added 'NMIEN' and 'NMISTS' control registers to M451Series.h for NMI control.
  * \li Added PDMA_ScatterGather_PingPongBuffer sample code to create ping-pong buffer with PDMA scatter gather mode.
  * \li Added 'PE_DRVCTL' register of GPIO to M451Series.h for GPIO driving strength control.
  * \li Added a sample code PWM_PDMA_Capture to transfer PWM capture data by PDMA.
  * \li Added SCLIB_ActivateDelay API for initial SC with non-standard H/W design in SC driver
  * \li Fixed the bug of EADC_IS_INT_FLAG_OV() that accesses the incorrect register.
  * \li Fixed the bug of EADC_IS_SAMPLE_MODULE_OV() that accesses the incorrect register. 
  * \li Fixed the bug of EADC_SetExtendSampleTime() for position shift error in EADC driver.
  * \li Fixed the bug of EADC_SetTriggerDelayTime() for position shift error in EADC driver.
  * \li Fixed the bug of PWM_ENABLE_OUTPUT_INVERTER () that output inverter function cannot be disabled.
  * \li Fixed the bug of PWM_MASK_OUTPUT() in PWM driver that mask function cannot be disabled.
  * \li Fixed CAN_STATUS_LEC_Msk from 0x03 to 0x07.
  * \li Fixed the bug of CLK_SysTickDelay() that COUNTFLAG may not be cleared in CLK driver.
  * \li Fixed CTL and PINCTL regsiter synchronize issue by waiting synchronized ready flag in SC driver.
  * \li Fixed DAC_SetDelayTime() calculation error in DAC driver because the dac->TCTL only used 10 bits, not 14 bits.
  * \li Fixed EADC_CMP_ADCMPIE_DISABLE definition error. 
  * \li Fixed EADC_CMP_ADCMPIE_DISABLE definition error. 
  * \li Fixed IAR entry point from __iar_program_start to Reset_Handler
  * \li Fixed PWM_ConfigOutputChannel() return value bug in PWM driver.
  * \li Fixed the bug of PWM_ConfigSyncPhase() that cannot configure synchronized source for channel2~5.
  * \li Fixed SC_SET_STOP_BIT_LEN definition error.
  * \li Fixed SCUART baudrate return error in SCUART_Open and SCUART_SetLineConfig API of SCUART driver.
  * \li Fixed SCUART_PARITY_NONE/SCUART_PARITY_EVEN/SCUART_PARITY_ODD definition bug in SCUART driver.
  * \li Fixed u32DataWidth setting error by sc->UARTCTL in SCUART_SetLineConfig API of SCUART driver.
  * \li Fixed SMBD_Enable constant value definition error in I2C driver.
  * \li Fixed the problem that MSC device detection is aborted due to REQUEST_SENSE command not ready.
  * \li Fixed UART clock setting bug in UART_Open(), UART_SetLine_Config() and UART_SelectIrDAMode() of UART driver.
  * \li Improved compatibility of USBH driver for pen driver.
  * \li Improved EADC_ConfigSampleModule() to support rising and falling trigger at the same time.
  * \li Improved EBI_SRAM sample code to add PDMA data transfer with EBI.
  * \li Improved SC driver to support more than one SC port.
  * \li Improved USBH driver to support composite HID devices
  * \li Improved USBD driver to support more USB device sample code.
  * \li Modified I2C_STOP() from #define to inline and add waiting STO bit clear to 0 . This modified is safe for next START coming soon.
  * \li Removed CRC clock enabled in CRC_Open(). User should enable CRC clock in system initialization before any CRC operation.
  * \li Removed FMC_ReadDID() in FMC driver. This function was no longer supported.
  * \li Removed I2C_CTL_STA_STO_SI and I2C_CTL_STA_STO_SI_AA definitions to avoid STOP and START write to control bit at the same time.
  *
  * <b>Revision 3.00.005</b>
  * \li Fixed EADC_CTL_DMOF_STRAIGHT_BINARY and EADC_CTL_DMOF_TWOS_COMPLEMENT definition error in EADC driver.
  * \li Fixed EADC_FALLING_EDGE_TRIGGER definition error in EADC driver.
  * \li Fixed EADC_RISING_EDGE_TRIGGER definition error in EADC driver.
  * \li Fixed UART transmit data bug in UART_TEST_HANDLE() of UART_TxRxFunction sample code.
  * \li Fixed the data missing bug when BULK IN transfer is end by max packet size packet at last packet in USBD_VCOM sample code.
  * \li Fixed program user configuration area without erase in USBD_MassStorage_DataFlash sample code.
  * \li Fixed the bug of switching HCLK to HIRC before enabling PLL in CLK_SetCoreClock() of CLK driver.
  * \li Fixed isochronous transfer bugs of USB Host library.
  * \li Fixed Clear Modem Status Interrupt flag bug in UART_ClearIntFlag() of UART driver.
  * \li Fixed the time-out flag clear bug in I2C_ClearTimeoutFlag() of I2C driver.
  * \li Replaced PERIOD0~5 with PERIOD[6] in PWM_T, and modified PERIOD bit field constant definition in M451Series.h.
  * \li Replaced CMPDAT0~5 with CMPDAT0[6] in PWM_T, and modified CMPDAT bit field constant definition in M451Series.h.
  * \li Replaced CNT0~5 with CNT[6] in PWM_T, and modified CNT bit field constant definition in M451Series.h.
  * \li Replaced PBUF0~5 with PBUF[6] in PWM_T, and modified PBUF bit field constant definition in M451Series.h.
  * \li Replaced CMPBUF0~5 with CMPBUF[6] in PWM_T, and modified CMPBUF bit field constant definition in M451Series.h.
  * \li Replaced CURSCAT0~CURSCAT11 with CURSCAT[12] in PDMA_T of M451Series.h.
  * \li Modified CLK_WaitClockReady() time-out to about 300 ms in CLK driver.
  * \li Updated USB USBD_MassStorage_DataFlash sample code and USB Driver to pass USB-IF MSC test. (The MassStorage size must be greater than 64 KB; otherwise, Command Set test will fail in MSC test).
  * \li Replaced old HID library file (open source) with Nuvoton HID library in USB Host library. 
  * \li Added USBH_Audio_Class and USBH_UAC_HID sample code for USB Host to support UAC + HID device.
  *
  * <b>Revision 3.00.004</b>
  * \li Fixed the time-out from 5 ms to 300 ms in CLK_WaitClockReady() of CLK driver.
  * \li Fixed the bug of UART_ClearIntFlag() in UART driver to only clear one flag at one time.
  * \li Fixed the missing parameter, UART clock source LXT, for CLK_SetModuleClock() in UART driver.
  * \li Fixed the bug of clearing data and CTS wake-up flag to clear one flag at one time in UART1_IRQHandler() of UART_Wakeup sample code.
  * \li Fixed the bug of RS485_HANDLE() in the UART_RS485_Slave sample code to only clear one flag at one time.
  * \li Fixed the bug of clearing auto baud rate detect finished and time-out flag to clear one flag at one time in AutoBaudRate_RxTest() of UART_AutoBaudRate_Slave sample code.
  * \li Fixed NVIC_EnableIRQ() to NVIC_DisableIRQ() after chip wake-up in I2C_Wakeup_Slave sample code.
  * \li Fixed multi-function setting error of SC CD pin in USBD_CCID sample code.
  * \li Fixed PD.7 (Headphone output control pin) output mode configuration in WAU8822_Setup() of USBD_Audio_NAU8822 sample code.
  * \li Fixed wrong CLK_WaitClockReady parameter in I2C_GCMode_Slave sample code.
  * \li Fixed UART data transfer bug of USBD_VCOM sample code.
  * \li Updated CLK driver to avoid HIRC force enabled in CLK_SetHCLK() and CLK_SetCoreClock().
  * \li Updated USBD driver to pass USB-IF MSC test.
  * \li Updated USBD_MassStorage_DataFlash sample code to pass USB-IF MSC test.
  * \li Updated driver of VCOM for win8 certification in USBD_VCOM sample code.
  * \li Added HID Media key supporting in USBD_Audio_HID_NAU8822 sample code.
  * \li Added new sample code USBH_UAC_HID of USB Host to support UAC + HID device.
  * \li Added new sample code USBH_Audio_Class to support USB audio class device (UAC).
  *
  * <b>Revision 3.00.003</b>
  * \li Added USBD_Audio_HID_NAU8822 sample code.
  *
  * <b>Revision 3.00.002</b>
  * \li Fixed serial number code in device descriptor.
  * \li Fixed EBI_Open API did not perform u32CSActiveLevel parameters to set CS pin polar.
  * \li Fixed SMBus bus time-out and Clock Lo time-out API.
  * \li Fixed I2C0,1 IP reset of SYS_IPRST1.
  * \li Fixed include path of CMSIS.
  * \li Fixed SPI_CLR_UNIT_TRANS_INT_FLAG( ) definition.
  * \li Fixed USBD_INT_WAKEUP definition.
  * \li Modified USBD driver to support USB remote wake-up function.
  *
  * <b>Revision 3.00.001</b>
  * \li Initial Release.
*/

#ifndef __M451SERIES_H__
#define __M451SERIES_H__

#ifdef __cplusplus
extern "C" {
#endif

/******************************************************************************/
/*                Processor and Core Peripherals                              */
/******************************************************************************/
/** @addtogroup CMSIS Device CMSIS Definitions
  Configuration of the Cortex-M4 Processor and Core Peripherals
  @{
*/

/*
 * ==========================================================================
 * ---------- Interrupt Number Definition -----------------------------------
 * ==========================================================================
 */

typedef enum IRQn
{
    /******  Cortex-M4 Processor Exceptions Numbers ***************************************************/
    NonMaskableInt_IRQn           = -14,      /*!<  2 Non Maskable Interrupt                        */
    MemoryManagement_IRQn         = -12,      /*!<  4 Memory Management Interrupt                   */
    BusFault_IRQn                 = -11,      /*!<  5 Bus Fault Interrupt                           */
    UsageFault_IRQn               = -10,      /*!<  6 Usage Fault Interrupt                         */
    SVCall_IRQn                   = -5,       /*!< 11 SV Call Interrupt                             */
    DebugMonitor_IRQn             = -4,       /*!< 12 Debug Monitor Interrupt                       */
    PendSV_IRQn                   = -2,       /*!< 14 Pend SV Interrupt                             */
    SysTick_IRQn                  = -1,       /*!< 15 System Tick Interrupt                         */

    /******  M451 Specific Interrupt Numbers ********************************************************/

    BOD_IRQn                      = 0,        /*!< Brown Out detection Interrupt                    */
    IRC_IRQn                      = 1,        /*!< Internal RC Interrupt                            */
    PWRWU_IRQn                    = 2,        /*!< Power Down Wake Up Interrupt                     */
    RAMPE_IRQn                    = 3,        /*!< SRAM parity check failed Interrupt               */
    CKFAIL_IRQn                   = 4,        /*!< Clock failed Interrupt                           */
    RTC_IRQn                      = 6,        /*!< Real Time Clock Interrupt                        */
    TAMPER_IRQn                   = 7,        /*!< Tamper detection Interrupt                       */
    WDT_IRQn                      = 8,        /*!< Watchdog Timer Interrupt                         */
    WWDT_IRQn                     = 9,        /*!< Window Watchdog Timer Interrupt                  */
    EINT0_IRQn                    = 10,       /*!< External Input 0 Interrupt                       */
    EINT1_IRQn                    = 11,       /*!< External Input 1 Interrupt                       */
    EINT2_IRQn                    = 12,       /*!< External Input 2 Interrupt                       */
    EINT3_IRQn                    = 13,       /*!< External Input 3 Interrupt                       */
    EINT4_IRQn                    = 14,       /*!< External Input 4 Interrupt                       */
    EINT5_IRQn                    = 15,       /*!< External Input 5 Interrupt                       */
    GPA_IRQn                      = 16,       /*!< GPIO Port A Interrupt                            */
    GPB_IRQn                      = 17,       /*!< GPIO Port B Interrupt                            */
    GPC_IRQn                      = 18,       /*!< GPIO Port C Interrupt                            */
    GPD_IRQn                      = 19,       /*!< GPIO Port D Interrupt                            */
    GPE_IRQn                      = 20,       /*!< GPIO Port E Interrupt                            */
    GPF_IRQn                      = 21,       /*!< GPIO Port F Interrupt                            */
    SPI0_IRQn                     = 22,       /*!< SPI0 Interrupt                                   */
    SPI1_IRQn                     = 23,       /*!< SPI1 Interrupt                                   */
    BRAKE0_IRQn                   = 24,       /*!< BRAKE0 Interrupt                                 */
    PWM0P0_IRQn                   = 25,       /*!< PWM0P0 Interrupt                                 */
    PWM0P1_IRQn                   = 26,       /*!< PWM0P1 Interrupt                                 */
    PWM0P2_IRQn                   = 27,       /*!< PWM0P2 Interrupt                                 */
    BRAKE1_IRQn                   = 28,       /*!< BRAKE1 Interrupt                                 */
    PWM1P0_IRQn                   = 29,       /*!< PWM1P0 Interrupt                                 */
    PWM1P1_IRQn                   = 30,       /*!< PWM1P1 Interrupt                                 */
    PWM1P2_IRQn                   = 31,       /*!< PWM1P2 Interrupt                                 */
    TMR0_IRQn                     = 32,       /*!< Timer 0 Interrupt                                */
    TMR1_IRQn                     = 33,       /*!< Timer 1 Interrupt                                */
    TMR2_IRQn                     = 34,       /*!< Timer 2 Interrupt                                */
    TMR3_IRQn                     = 35,       /*!< Timer 3 Interrupt                                */
    UART0_IRQn                    = 36,       /*!< UART 0 Interrupt                                 */
    UART1_IRQn                    = 37,       /*!< UART 1 Interrupt                                 */
    I2C0_IRQn                     = 38,       /*!< I2C 0 Interrupt                                  */
    I2C1_IRQn                     = 39,       /*!< I2C 1 Interrupt                                  */
    PDMA_IRQn                     = 40,       /*!< Peripheral DMA Interrupt                         */
    DAC_IRQn                      = 41,       /*!< DAC Interrupt                                    */
    ADC00_IRQn                    = 42,       /*!< ADC0 Source 0 Interrupt                          */
    ADC01_IRQn                    = 43,       /*!< ADC0 Source 1 Interrupt                          */
    ACMP01_IRQn                   = 44,       /*!< Analog Comparator 0 and 1 Interrupt              */
    ADC02_IRQn                    = 46,       /*!< ADC0 Source 2 Interrupt                          */
    ADC03_IRQn                    = 47,       /*!< ADC0 Source 3 Interrupt                          */
    UART2_IRQn                    = 48,       /*!< UART2 Interrupt                                  */
    UART3_IRQn                    = 49,       /*!< UART3 Interrupt                                  */
    SPI2_IRQn                     = 51,       /*!< SPI2 Interrupt                                   */
    USBD_IRQn                     = 53,       /*!< USB device Interrupt                             */
    USBH_IRQn                     = 54,       /*!< USB host Interrupt                               */
    USBOTG_IRQn                   = 55,       /*!< USB OTG Interrupt                                */
    CAN0_IRQn                     = 56,       /*!< CAN0 Interrupt                                   */
    SC0_IRQn                      = 58,       /*!< Smart Card 0 Interrupt                           */
    TK_IRQn                       = 63        /*!< Touch Key Interrupt                              */
} IRQn_Type;


/*
 * ==========================================================================
 * ----------- Processor and Core Peripheral Section ------------------------
 * ==========================================================================
 */

/* Configuration of the Cortex-M# Processor and Core Peripherals */
#define __CM4_REV                 0x0201    /*!< Core Revision r2p1                               */
#define __NVIC_PRIO_BITS          4         /*!< Number of Bits used for Priority Levels          */
#define __Vendor_SysTickConfig    0         /*!< Set to 1 if different SysTick Config is used     */
#define __MPU_PRESENT             1         /*!< MPU present or not                               */
#define __FPU_PRESENT             1         /*!< FPU present or not                               */

/*@}*/ /* end of group CMSIS */

#include "core_cm4.h"                       /* Cortex-M4 processor and core peripherals           */
#include "system_M451Series.h"              /* M451 System include file                           */
#include <stdint.h>



/******************************************************************************/
/*                Device Specific Peripheral registers structures             */
/******************************************************************************/

/** @addtogroup REGISTER Control Register

  @{

*/


/*---------------------- Analog Comparator Controller -------------------------*/
/**
    @addtogroup ACMP Analog Comparator Controller(ACMP)
    Memory Mapped Structure for ACMP Controller
@{ */


typedef struct
{


/**
 * @var ACMP_T::CTL
 * Offset: 0x00  Analog Comparator 0 Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |ACMPEN    |Comparator Enable Bit
 * |        |          |0 = Comparator 0 Disabled.
 * |        |          |1 = Comparator 0 Enabled.
 * |[1]     |ACMPIE    |Comparator Interrupt Enable Bit
 * |        |          |0 = Comparator 0 interrupt Disabled.
 * |        |          |1 = Comparator 0 interrupt Enabled.
 * |        |          |If WKEN (ACMP_CTL0[16]) is set to 1, the wake-up interrupt function will be enabled as well.
 * |[2]     |HYSEN     |Comparator Hysteresis Enable Bit
 * |        |          |0 = Comparator 0 hysteresis Disabled.
 * |        |          |1 = Comparator 0 hysteresis Enabled.
 * |[3]     |ACMPOINV  |Comparator Output Inverse
 * |        |          |0 = Comparator 0 output inverse Disabled.
 * |        |          |1 = Comparator 0 output inverse Enabled.
 * |[5:4]   |NEGSEL    |Comparator Negative Input Selection
 * |        |          |00 = ACMP0_N pin.
 * |        |          |01 = Internal comparator reference voltage (CRV).
 * |        |          |10 = Band-gap voltage.
 * |        |          |11 = DAC output.
 * |[7:6]   |POSSEL    |Comparator Positive Input Selection
 * |        |          |00 = Input from ACMP0_P0.
 * |        |          |01 = Input from ACMP0_P1.
 * |        |          |10 = Input from ACMP0_P2.
 * |        |          |11 = Input from ACMP0_P3.
 * |[9:8]   |INTPOL    |Interrupt Condition Polarity Selection
 * |        |          |ACMPIF0 will be set to 1 when comparator output edge condition is detected.
 * |        |          |00 = Rising edge or falling edge.
 * |        |          |01 = Rising edge.
 * |        |          |10 = Falling edge.
 * |        |          |11 = Reserved.
 * |[12]    |OUTSEL    |Comparator Output Select
 * |        |          |0 = Comparator 0 output to ACMP0_O pin is unfiltered comparator output.
 * |        |          |1 = Comparator 0 output to ACMP0_O pin is from filter output.
 * |[15:13] |FILTSEL   |Comparator Output Filter Count Selection
 * |        |          |000 = Filter function is Disabled.
 * |        |          |001 = ACMP0 output is sampled 1 consecutive PCLK.
 * |        |          |010 = ACMP0 output is sampled 2 consecutive PCLKs.
 * |        |          |011 = ACMP0 output is sampled 4 consecutive PCLKs.
 * |        |          |100 = ACMP0 output is sampled 8 consecutive PCLKs.
 * |        |          |101 = ACMP0 output is sampled 16 consecutive PCLKs.
 * |        |          |110 = ACMP0 output is sampled 32 consecutive PCLKs.
 * |        |          |111 = ACMP0 output is sampled 64 consecutive PCLKs.
 * |[16]    |WKEN      |Power Down Wake-Up Enable Bit
 * |        |          |0 = Wake-up function Disabled.
 * |        |          |1 = Wake-up function Enabled.
 * ---------------------------------------------------------------------------------------------------
 * Offset: 0x04  Analog Comparator 1 Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |ACMPEN    |Comparator Enable Bit
 * |        |          |0 = Comparator 1 Disabled.
 * |        |          |1 = Comparator 1 Enabled.
 * |[1]     |ACMPIE    |Comparator Interrupt Enable Bit
 * |        |          |0 = Comparator 1 interrupt Disabled.
 * |        |          |1 = Comparator 1 interrupt Enabled.
 * |        |          |If WKEN (ACMP_CTL1[16]) is set to 1, the wake-up interrupt function will be enabled as well.
 * |[2]     |HYSEN     |Comparator Hysteresis Enable Bit
 * |        |          |0 = Comparator 1 hysteresis Disabled.
 * |        |          |1 = Comparator 1 hysteresis Enabled.
 * |[3]     |ACMPOINV  |Comparator Output Inverse Control
 * |        |          |0 = Comparator 1 output inverse Disabled.
 * |        |          |1 = Comparator 1 output inverse Enabled.
 * |[5:4]   |NEGSEL    |Comparator Negative Input Selection
 * |        |          |00 = ACMP1_N pin.
 * |        |          |01 = Internal comparator reference voltage (CRV).
 * |        |          |10 = Band-gap voltage.
 * |        |          |11 = DAC output.
 * |[7:6]   |POSSEL    |Comparator Positive Input Selection
 * |        |          |00 = Input from ACMP1_P0.
 * |        |          |01 = Input from ACMP1_P1.
 * |        |          |10 = Input from ACMP1_P2.
 * |        |          |11 = Input from ACMP1_P3.
 * |[9:8]   |INTPOL    |Interrupt Condition Polarity Selection
 * |        |          |ACMPIF1 will be set to 1 when comparator output edge condition is detected.
 * |        |          |00 = Rising edge or falling edge.
 * |        |          |01 = Rising edge.
 * |        |          |10 = Falling edge.
 * |        |          |11 = Reserved.
 * |[12]    |OUTSEL    |Comparator Output Select
 * |        |          |0 = Comparator 1 output to ACMP1_O pin is unfiltered comparator output.
 * |        |          |1 = Comparator 1 output to ACMP1_O pin is from filter output.
 * |[15:13] |FILTSEL   |Comparator Output Filter Count Selection
 * |        |          |000 = Filter function is Disabled.
 * |        |          |001 = ACMP1 output is sampled 1 consecutive PCLK.
 * |        |          |010 = ACMP1 output is sampled 2 consecutive PCLKs.
 * |        |          |011 = ACMP1 output is sampled 4 consecutive PCLKs.
 * |        |          |100 = ACMP1 output is sampled 8 consecutive PCLKs.
 * |        |          |101 = ACMP1 output is sampled 16 consecutive PCLKs.
 * |        |          |110 = ACMP1 output is sampled 32 consecutive PCLKs.
 * |        |          |111 = ACMP1 output is sampled 64 consecutive PCLKs.
 * |[16]    |WKEN      |Power Down Wakeup Enable Bit
 * |        |          |0 = Wake-up function Disabled.
 * |        |          |1 = Wake-up function Enabled.
 * @var ACMP_T::STATUS
 * Offset: 0x08  Analog Comparator Status Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |ACMPIF0   |Comparator 0 Interrupt Flag
 * |        |          |This bit is set by hardware when the edge condition defined by INTPOL (ACMP_CTL0[9:8]) is detected on comparator 0 output.
 * |        |          |This will generate an interrupt if ACMPIE (ACMP_CTL0[1]) is set to 1.
 * |        |          |Note: Write 1 to clear this bit to 0.
 * |[1]     |ACMPIF1   |Comparator 1 Interrupt Flag
 * |        |          |This bit is set by hardware when the edge condition defined by INTPOL (ACMP_CTL1[9:8]) is detected on comparator 1 output.
 * |        |          |This will cause an interrupt if ACMPIE (ACMP_CTL1[1]) is set to 1.
 * |        |          |Note: Write 1 to clear this bit to 0.
 * |[4]     |ACMPO0    |Comparator 0 Output
 * |        |          |Synchronized to the PCLK to allow reading by software.
 * |        |          |Cleared when the comparator 0 is disabled, i.e. ACMPEN (ACMP_CTL0[0]) is cleared to 0.
 * |[5]     |ACMPO1    |Comparator 1 Output
 * |        |          |Synchronized to the PCLK to allow reading by software.
 * |        |          |Cleared when the comparator 1 is disabled, i.e. ACMPEN (ACMP_CTL1[0]) is cleared to 0.
 * |[8]     |WKIF0     |Comparator 0 Power Down Wake-Up Interrupt Flag
 * |        |          |This bit will be set to 1 when ACMP0 wake-up interrupt event occurs.
 * |        |          |0 = No power down wake-up occurred.
 * |        |          |1 = Power down wake-up occurred.
 * |        |          |Note: Write 1 to clear this bit to 0.
 * |[9]     |WKIF1     |Comparator 1 Power Down Wake-Up Interrupt Flag
 * |        |          |This bit will be set to 1 when ACMP1 wake-up interrupt event occurs.
 * |        |          |0 = No power down wake-up occurred.
 * |        |          |1 = Power down wake-up occurred.
 * |        |          |Note: Write 1 to clear this bit to 0.
 * @var ACMP_T::VREF
 * Offset: 0x0C  Analog Comparator Reference Voltage Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[3:0]   |CRVCTL    |Comparator Reference Voltage Setting
 * |        |          |CRV = CRV source voltage * (1/6+CRVCTL/24).
 * |[6]     |CRVSSEL   |CRV Source Voltage Selection
 * |        |          |0 = VDDA is selected as CRV source voltage.
 * |        |          |1 = The reference voltage defined by SYS_VREFCTL register is selected as CRV source voltage.
 */

    __IO uint32_t CTL[2];        /* Offset: 0x00  Analog Comparator Control Register                                 */
    __IO uint32_t STATUS;        /* Offset: 0x08  Analog Comparator Status Register                                  */
    __IO uint32_t VREF;          /* Offset: 0x0C  Analog Comparator Reference Voltage Control Register               */

} ACMP_T;



/**
    @addtogroup ACMP_CONST ACMP Bit Field Definition
    Constant Definitions for ACMP Controller
@{ */

#define ACMP_CTL_ACMPEN_Pos              (0)                                               /*!< ACMP_T::CTL: ACMPEN Position             */
#define ACMP_CTL_ACMPEN_Msk              (0x1ul << ACMP_CTL_ACMPEN_Pos)                    /*!< ACMP_T::CTL: ACMPEN Mask                 */

#define ACMP_CTL_ACMPIE_Pos              (1)                                               /*!< ACMP_T::CTL: ACMPIE Position             */
#define ACMP_CTL_ACMPIE_Msk              (0x1ul << ACMP_CTL_ACMPIE_Pos)                    /*!< ACMP_T::CTL: ACMPIE Mask                 */

#define ACMP_CTL_HYSEN_Pos               (2)                                               /*!< ACMP_T::CTL: HYSEN Position              */
#define ACMP_CTL_HYSEN_Msk               (0x1ul << ACMP_CTL_HYSEN_Pos)                     /*!< ACMP_T::CTL: HYSEN Mask                  */

#define ACMP_CTL_ACMPOINV_Pos            (3)                                               /*!< ACMP_T::CTL: ACMPOINV Position           */
#define ACMP_CTL_ACMPOINV_Msk            (0x1ul << ACMP_CTL_ACMPOINV_Pos)                  /*!< ACMP_T::CTL: ACMPOINV Mask               */

#define ACMP_CTL_NEGSEL_Pos              (4)                                               /*!< ACMP_T::CTL: NEGSEL Position             */
#define ACMP_CTL_NEGSEL_Msk              (0x3ul << ACMP_CTL_NEGSEL_Pos)                    /*!< ACMP_T::CTL: NEGSEL Mask                 */

#define ACMP_CTL_POSSEL_Pos              (6)                                               /*!< ACMP_T::CTL: POSSEL Position             */
#define ACMP_CTL_POSSEL_Msk              (0x3ul << ACMP_CTL_POSSEL_Pos)                    /*!< ACMP_T::CTL: POSSEL Mask                 */

#define ACMP_CTL_INTPOL_Pos              (8)                                               /*!< ACMP_T::CTL: INTPOL Position             */
#define ACMP_CTL_INTPOL_Msk              (0x3ul << ACMP_CTL_INTPOL_Pos)                    /*!< ACMP_T::CTL: INTPOL Mask                 */

#define ACMP_CTL_OUTSEL_Pos              (12)                                              /*!< ACMP_T::CTL: OUTSEL Position             */
#define ACMP_CTL_OUTSEL_Msk              (0x1ul << ACMP_CTL_OUTSEL_Pos)                    /*!< ACMP_T::CTL: OUTSEL Mask                 */

#define ACMP_CTL_FILTSEL_Pos             (13)                                              /*!< ACMP_T::CTL: FILTSEL Position            */
#define ACMP_CTL_FILTSEL_Msk             (0x7ul << ACMP_CTL_FILTSEL_Pos)                   /*!< ACMP_T::CTL: FILTSEL Mask                */

#define ACMP_CTL_WKEN_Pos                (16)                                              /*!< ACMP_T::CTL: WKEN Position               */
#define ACMP_CTL_WKEN_Msk                (0x1ul << ACMP_CTL_WKEN_Pos)                      /*!< ACMP_T::CTL: WKEN Mask                   */

#define ACMP_STATUS_ACMPIF0_Pos          (0)                                               /*!< ACMP_T::STATUS: ACMPIF0 Position         */
#define ACMP_STATUS_ACMPIF0_Msk          (0x1ul << ACMP_STATUS_ACMPIF0_Pos)                /*!< ACMP_T::STATUS: ACMPIF0 Mask             */

#define ACMP_STATUS_ACMPIF1_Pos          (1)                                               /*!< ACMP_T::STATUS: ACMPIF1 Position         */
#define ACMP_STATUS_ACMPIF1_Msk          (0x1ul << ACMP_STATUS_ACMPIF1_Pos)                /*!< ACMP_T::STATUS: ACMPIF1 Mask             */

#define ACMP_STATUS_ACMPO0_Pos           (4)                                               /*!< ACMP_T::STATUS: ACMPO0 Position          */
#define ACMP_STATUS_ACMPO0_Msk           (0x1ul << ACMP_STATUS_ACMPO0_Pos)                 /*!< ACMP_T::STATUS: ACMPO0 Mask              */

#define ACMP_STATUS_ACMPO1_Pos           (5)                                               /*!< ACMP_T::STATUS: ACMPO1 Position          */
#define ACMP_STATUS_ACMPO1_Msk           (0x1ul << ACMP_STATUS_ACMPO1_Pos)                 /*!< ACMP_T::STATUS: ACMPO1 Mask              */

#define ACMP_STATUS_WKIF0_Pos            (8)                                               /*!< ACMP_T::STATUS: WKIF0 Position           */
#define ACMP_STATUS_WKIF0_Msk            (0x1ul << ACMP_STATUS_WKIF0_Pos)                  /*!< ACMP_T::STATUS: WKIF0 Mask               */

#define ACMP_STATUS_WKIF1_Pos            (9)                                               /*!< ACMP_T::STATUS: WKIF1 Position           */
#define ACMP_STATUS_WKIF1_Msk            (0x1ul << ACMP_STATUS_WKIF1_Pos)                  /*!< ACMP_T::STATUS: WKIF1 Mask               */

#define ACMP_VREF_CRVCTL_Pos             (0)                                               /*!< ACMP_T::VREF: CRVCTL Position            */
#define ACMP_VREF_CRVCTL_Msk             (0xful << ACMP_VREF_CRVCTL_Pos)                   /*!< ACMP_T::VREF: CRVCTL Mask                */

#define ACMP_VREF_CRVSSEL_Pos            (6)                                               /*!< ACMP_T::VREF: CRVSSEL Position           */
#define ACMP_VREF_CRVSSEL_Msk            (0x1ul << ACMP_VREF_CRVSSEL_Pos)                  /*!< ACMP_T::VREF: CRVSSEL Mask               */

/**@}*/ /* ACMP_CONST */
/**@}*/ /* end of ACMP register group */


/*---------------------- Enhanced Analog to Digital Converter -------------------------*/
/**
    @addtogroup Enhanced Analog to Digital Converter(EADC)
    Memory Mapped Structure for EADC Controller
@{ */


typedef struct
{


/**
 * @var EADC_T::DAT
 * Offset: 0x00-0x48  A/D Data Register n for Sample Module n, n=0~18
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |RESULT    |A/D Conversion Result
 * |        |          |This field contains 12 bits conversion result.
 * |        |          |When DMOF (EADC_CTL[9]) is set to 0, 12-bit ADC conversion result with unsigned format will be filled in RESULT[11:0] and zero will be filled in RESULT[15:12].
 * |        |          |When DMOF (EADC_CTL[9]) set to 1, 12-bit ADC conversion result with 2'complement format will be filled in RESULT[11:0] and signed bits to will be filled in RESULT[15:12].
 * |[16]    |OV        |Overrun Flag
 * |        |          |If converted data in RESULT[11:0] has not been read before new conversion result is loaded to this register, OV is set to 1.
 * |        |          |0 = Data in RESULT[11:0] is recent conversion result.
 * |        |          |1 = Data in RESULT[11:0] is overwrite.
 * |        |          |Note: It is cleared by hardware after EADC_DAT register is read.
 * |[17]    |VALID     |Valid Flag
 * |        |          |This bit is set to 1 when corresponding sample module channel analog input conversion is completed and cleared by hardware after EADC_DAT register is read.
 * |        |          |0 = Data in RESULT[11:0] bits is not valid.
 * |        |          |1 = Data in RESULT[11:0] bits is valid.
 * @var EADC_T::CURDAT
 * Offset: 0x4C  EADC PDMA Current Transfer Data Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[17:0]  |CURDAT    |ADC PDMA Current Transfer Data Register
 * |        |          |This register is a shadow register of EADC_DATn (n=0~18) for PDMA support.
 * |        |          |This is a read only register.
 * @var EADC_T::CTL
 * Offset: 0x50  A/D Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |ADCEN     |A/D Converter Enable Bit
 * |        |          |0 = Disabled.
 * |        |          |1 = Enabled.
 * |        |          |Note: Before starting A/D conversion function, this bit should be set to 1.
 * |        |          |Clear it to 0 to disable A/D converter analog circuit power consumption.
 * |[1]     |ADCRST    |ADC A/D Converter Control Circuits Reset
 * |        |          |0 = No effect.
 * |        |          |1 = Cause ADC control circuits reset to initial state, but not change the ADC registers value.
 * |        |          |Note: ADCRST bit remains 1 during ADC reset, when ADC reset end, the ADCRST bit is automatically cleared to 0.
 * |[2]     |ADCIEN0   |Specific Sample Module A/D ADINT0 Interrupt Enable Bit
 * |        |          |The A/D converter generates a conversion end ADIF0 (EADC_STATUS2[0]) upon the end of specific sample module A/D conversion.
 * |        |          |If ADCIEN0 bit is set then conversion end interrupt request ADINT0 is generated.
 * |        |          |0 = Specific sample module A/D ADINT0 interrupt function Disabled.
 * |        |          |1 = Specific sample module A/D ADINT0 interrupt function Enabled.
 * |[3]     |ADCIEN1   |Specific Sample Module A/D ADINT1 Interrupt Enable Bit
 * |        |          |The A/D converter generates a conversion end ADIF1 (EADC_STATUS2[1]) upon the end of specific sample module A/D conversion.
 * |        |          |If ADCIEN1 bit is set then conversion end interrupt request ADINT1 is generated.
 * |        |          |0 = Specific sample module A/D ADINT1 interrupt function Disabled.
 * |        |          |1 = Specific sample module A/D ADINT1 interrupt function Enabled.
 * |[4]     |ADCIEN2   |Specific Sample Module A/D ADINT2 Interrupt Enable Bit
 * |        |          |The A/D converter generates a conversion end ADIF2 (EADC_STATUS2[2]) upon the end of specific sample module A/D conversion.
 * |        |          |If ADCIEN2 bit is set then conversion end interrupt request ADINT2 is generated.
 * |        |          |0 = Specific sample module A/D ADINT2 interrupt function Disabled.
 * |        |          |1 = Specific sample module A/D ADINT2 interrupt function Enabled.
 * |[5]     |ADCIEN3   |Specific Sample Module A/D ADINT3 Interrupt Enable Bit
 * |        |          |The A/D converter generates a conversion end ADIF3 (EADC_STATUS2[3]) upon the end of specific sample module A/D conversion.
 * |        |          |If ADCIEN3 bit is set then conversion end interrupt request ADINT3 is generated.
 * |        |          |0 = Specific sample module A/D ADINT3 interrupt function Disabled.
 * |        |          |1 = Specific sample module A/D ADINT3 interrupt function Enabled.
 * |[8]     |DIFFEN    |Differential Analog Input Mode Enable Bit
 * |        |          |0 = Single-end analog input mode.
 * |        |          |1 = Differential analog input mode.
 * |[9]     |DMOF      |ADC Differential Input Mode Output Format
 * |        |          |0 = A/D conversion result will be filled in RESULT (EADC_DATn[15:0] , n= 0 ~18) with unsigned format.
 * |        |          |1 = A/D conversion result will be filled in RESULT (EADC_DATn[15:0] , n= 0 ~18) with 2'complement format.
 * |[11]    |PDMAEN    |PDMA Transfer Enable Bit
 * |        |          |When A/D conversion is completed, the converted data is loaded into EADC_DATn (n: 0 ~ 18) register, user can enable this bit to generate a PDMA data transfer request.
 * |        |          |0 = PDMA data transfer Disabled.
 * |        |          |1 = PDMA data transfer Enabled.
 * |        |          |Note: When set this bit field to 1, user must set ADCIENn (EADC_CTL[5:2], n=0~3) = 0 to disable interrupt.
 * |[18:16] |SMPTSEL   |ADC Internal Sampling Time Selection
 * |        |          |ADC internal sampling cycle = SMPTSEL + 1.
 * |        |          |000 = 1 ADC clock sampling time.
 * |        |          |001 = 2 ADC clock sampling time.
 * |        |          |010 = 3 ADC clock sampling time.
 * |        |          |011 = 4 ADC clock sampling time.
 * |        |          |100 = 5 ADC clock sampling time.
 * |        |          |101 = 6 ADC clock sampling time.
 * |        |          |110 = 7 ADC clock sampling time.
 * |        |          |111 = 8 ADC clock sampling time.
 * @var EADC_T::SWTRG
 * Offset: 0x54  A/D Sample Module Software Start Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[18:0]  |SWTRG     |A/D Sample Module
 * |        |          |0~18 Software Force To Start ADC Conversion
 * |        |          |0 = No effect.
 * |        |          |1 = Cause an ADC conversion when the priority is given to sample module.
 * |        |          |Note: After write this register to start ADC conversion, the EADC_PENDSTS register will show which sample module will conversion.
 * |        |          |If user want to disable the conversion of the sample module, user can write EADC_PENDSTS register to clear it.
 * @var EADC_T::PENDSTS
 * Offset: 0x58  A/D Start of Conversion Pending Flag Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[18:0]  |STPF      |A/D Sample Module 0~18 Start Of Conversion Pending Flag
 * |        |          |Read:
 * |        |          |0 = There is no pending conversion for sample module.
 * |        |          |1 = Sample module ADC start of conversion is pending.
 * |        |          |Write:
 * |        |          |1 = clear pending flag and cancel the conversion for sample module.
 * |        |          |Note: This bit remains 1 during pending state, when the respective ADC conversion is end, the STPFn (n=0~18) bit is automatically cleared to 0
 * @var EADC_T::OVSTS
 * Offset: 0x5C  A/D Sample Module Start of Conversion Overrun Flag Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[18:0]  |SPOVF     |A/D SAMPLE0~18 Overrun Flag
 * |        |          |0 = No sample module event overrun.
 * |        |          |1 = Indicates a new sample module event is generated while an old one event is pending.
 * |        |          |Note: This bit is cleared by writing 1 to it.
 * @var EADC_T::SCTL
 * Offset: 0x80-0x8C  A/D Sample Module n Control Register, n=0~3
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[3:0]   |CHSEL     |A/D Sample Module Channel Selection
 * |        |          |00H = EADC_CH0.
 * |        |          |01H = EADC_CH1.
 * |        |          |02H = EADC_CH2.
 * |        |          |03H = EADC_CH3.
 * |        |          |04H = EADC_CH4.
 * |        |          |05H = EADC_CH5.
 * |        |          |06H = EADC_CH6.
 * |        |          |07H = EADC_CH7.
 * |        |          |08H = EADC_CH8.
 * |        |          |09H = EADC_CH9.
 * |        |          |0AH = EADC_CH10.
 * |        |          |0BH = EADC_CH11.
 * |        |          |0CH = EADC_CH12.
 * |        |          |0DH = EADC_CH13.
 * |        |          |0EH = EADC_CH14.
 * |        |          |0FH = EADC_CH15.
 * |[4]     |EXTREN    |A/D External Trigger Rising Edge Enable Bit
 * |        |          |0 = Rising edge Disabled when A/D selects STADC as trigger source.
 * |        |          |1 = Rising edge Enabled when A/D selects STADC as trigger source.
 * |[5]     |EXTFEN    |A/D External Trigger Falling Edge Enable Bit
 * |        |          |0 = Falling edge Disabled when A/D selects STADC as trigger source.
 * |        |          |1 = Falling edge Enabled when A/D selects STADC as trigger source.
 * |[7:6]   |TRGDLYDIV |A/D Sample Module Start Of Conversion Trigger Delay Clock Divider Selection
 * |        |          |Trigger delay clock frequency:
 * |        |          |00 = ADC_CLK/1.
 * |        |          |01 = ADC_CLK/2.
 * |        |          |10 = ADC_CLK/4.
 * |        |          |11 = ADC_CLK/16.
 * |[15:8]  |TRGDLYCNT |A/D Sample Module Start Of Conversion Trigger Delay Time
 * |        |          |Trigger delay time = TRGDLYCNT x ADC_CLK x n (n=1,2,4,16 from TRGDLYDIV setting).
 * |[20:16] |TRGSEL    |A/D Sample Module Start Of Conversion Trigger Source Selection
 * |        |          |0H = Disable trigger.
 * |        |          |1H = External trigger from STADC pin input.
 * |        |          |2H = ADC ADINT0 interrupt EOC (End of conversion) pulse trigger.
 * |        |          |3H = ADC ADINT1 interrupt EOC (End of conversion) pulse trigger.
 * |        |          |4H = Timer0 overflow pulse trigger.
 * |        |          |5H = Timer1 overflow pulse trigger.
 * |        |          |6H = Timer2 overflow pulse trigger.
 * |        |          |7H = Timer3 overflow pulse trigger.
 * |        |          |8H = PWM0TG0.
 * |        |          |9H = PWM0TG1.
 * |        |          |AH = PWM0TG2.
 * |        |          |BH = PWM0TG3.
 * |        |          |CH = PWM0TG4.
 * |        |          |DH = PWM0TG5.
 * |        |          |EH = PWM1TG0.
 * |        |          |FH = PWM1TG1.
 * |        |          |10H = PWM1TG2.
 * |        |          |11H = PWM1TG3.
 * |        |          |12H = PWM1TG4.
 * |        |          |13H = PWM1TG5.
 * |        |          |other = Reserved.
 * |[22]    |INTPOS    |Interrupt Flag Position Select
 * |        |          |0 = Set ADIFn (EADC_STATUS2[n], n=0~3) at A/D end of conversion.
 * |        |          |1 = Set ADIFn (EADC_STATUS2[n], n=0~3) at A/D start of conversion.
 * |[23]    |DBMEN     |Double Buffer Mode Enable Bit
 * |        |          |0 = Sample has one sample result register. (default).
 * |        |          |1 = Sample has two sample result registers.
 * |[31:24] |EXTSMPT   |ADC Sampling Time Extend
 * |        |          |When A/D converting at high conversion rate, the sampling time of analog input voltage may not enough if input channel loading is heavy, user can extend A/D sampling time after trigger source is coming to get enough sampling time.
 * |        |          |The range of start delay time is from 0~255 ADC clock.
 * @var EADC_T::SCTL
 * Offset: 0x90-0xBC  A/D Sample Module n Control Register, n=4~15
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[3:0]   |CHSEL     |A/D Sample Module Channel Selection
 * |        |          |00H = EADC_CH0.
 * |        |          |01H = EADC_CH1.
 * |        |          |02H = EADC_CH2.
 * |        |          |03H = EADC_CH3.
 * |        |          |04H = EADC_CH4.
 * |        |          |05H = EADC_CH5.
 * |        |          |06H = EADC_CH6.
 * |        |          |07H = EADC_CH7.
 * |        |          |08H = EADC_CH8.
 * |        |          |09H = EADC_CH9.
 * |        |          |0AH = EADC_CH10.
 * |        |          |0BH = EADC_CH11.
 * |        |          |0CH = EADC_CH12.
 * |        |          |0DH = EADC_CH13.
 * |        |          |0EH = EADC_CH14.
 * |        |          |0FH = EADC_CH15.
 * |[4]     |EXTREN    |A/D External Trigger Rising Edge Enable Bit
 * |        |          |0 = Rising edge Disabled when A/D selects STADC as trigger source.
 * |        |          |1 = Rising edge Enabled when A/D selects STADC as trigger source.
 * |[5]     |EXTFEN    |A/D External Trigger Falling Edge Enable Bit
 * |        |          |0 = Falling edge Disabled when A/D selects STADC as trigger source.
 * |        |          |1 = Falling edge Enabled when A/D selects STADC as trigger source.
 * |[7:6]   |TRGDLYDIV[1:0]|A/D Sample Module Start Of Conversion Trigger Delay Clock Divider Selection
 * |        |          |Trigger delay clock frequency:
 * |        |          |00 = ADC_CLK/1.
 * |        |          |01 = ADC_CLK/2.
 * |        |          |10 = ADC_CLK/4.
 * |        |          |11 = ADC_CLK/16.
 * |[15:8]  |TRGDLYCNT[7:0]|A/D Sample Module Start Of Conversion Trigger Delay Time
 * |        |          |Trigger delay time = TRGDLYCNT x ADC_CLK x n (n=1,2,4,16 from TRGDLYDIV setting).
 * |[20:16] |TRGSEL    |A/D Sample Module Start Of Conversion Trigger Source Selection
 * |        |          |0H = Disable trigger.
 * |        |          |1H = External trigger from STADC pin input.
 * |        |          |2H = ADC ADINT0 interrupt EOC pulse trigger.
 * |        |          |3H = ADC ADINT1 interrupt EOC pulse trigger.
 * |        |          |4H = Timer0 overflow pulse trigger.
 * |        |          |5H = Timer1 overflow pulse trigger.
 * |        |          |6H = Timer2 overflow pulse trigger.
 * |        |          |7H = Timer3 overflow pulse trigger.
 * |        |          |8H = PWM0TG0.
 * |        |          |9H = PWM0TG1.
 * |        |          |AH = PWM0TG2.
 * |        |          |BH = PWM0TG3.
 * |        |          |CH = PWM0TG4.
 * |        |          |DH = PWM0TG5.
 * |        |          |EH = PWM1TG0.
 * |        |          |FH = PWM1TG1.
 * |        |          |10H = PWM1TG2.
 * |        |          |11H = PWM1TG3.
 * |        |          |12H = PWM1TG4.
 * |        |          |13H = PWM1TG5.
 * |        |          |other = Reserved.
 * |[22]    |INTPOS    |Interrupt Flag Position Select
 * |        |          |0 = Set ADIFn (EADC_STATUS2[n], n=0~3) at A/D end of conversion.
 * |        |          |1 = Set ADIFn (EADC_STATUS2[n], n=0~3) at A/D start of conversion.
 * |[31:24] |EXTSMPT   |ADC Sampling Time Extend
 * |        |          |When A/D converting at high conversion rate, the sampling time of analog input voltage may not enough if input channel loading is heavy, SW can extend A/D sampling time after trigger source is coming to get enough sampling time.
 * |        |          |The range of start delay time is from 0~255 ADC clock.
 * @var EADC_T::SCTL
 * Offset: 0xC0~0xC8  A/D Sample Module n Control Register, n=16~18
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[31:24] |EXTSMPT   |ADC Sampling Time Extend
 * |        |          |When A/D converting at high conversion rate, the sampling time of analog input voltage may not enough if input channel loading is heavy, SW can extend A/D sampling time after trigger source is coming to get enough sampling time.
 * |        |          |The range of start delay time is from 0~255 ADC clock.
 * @var EADC_T::INTSRC
 * Offset: 0xDC  ADC interrupt n Source Enable Control Register, n=0~3
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |SPLIE0    |Sample Module 0 Interrupt Enable Bit
 * |        |          |0 = Sample Module 0 interrupt Disabled.
 * |        |          |1 = Sample Module 0 interrupt Enabled.
 * |[1]     |SPLIE1    |Sample Module 1 Interrupt Enable Bit
 * |        |          |0 = Sample Module 1 interrupt Disabled.
 * |        |          |1 = Sample Module 1 interrupt Enabled.
 * |[2]     |SPLIE2    |Sample Module 2 Interrupt Enable Bit
 * |        |          |0 = Sample Module 2 interrupt Disabled.
 * |        |          |1 = Sample Module 2 interrupt Enabled.
 * |[3]     |SPLIE3    |Sample Module 3 Interrupt Enable Bit
 * |        |          |0 = Sample Module 3 interrupt Disabled.
 * |        |          |1 = Sample Module 3 interrupt Enabled.
 * |[4]     |SPLIE4    |Sample Module 4 Interrupt Enable Bit
 * |        |          |0 = Sample Module 4 interrupt Disabled.
 * |        |          |1 = Sample Module 4 interrupt Enabled.
 * |[5]     |SPLIE5    |Sample Module 5 Interrupt Enable Bit
 * |        |          |0 = Sample Module 5 interrupt Disabled.
 * |        |          |1 = Sample Module 5 interrupt Enabled.
 * |[6]     |SPLIE6    |Sample Module 6 Interrupt Enable Bit
 * |        |          |0 = Sample Module 6 interrupt Disabled.
 * |        |          |1 = Sample Module 6 interrupt Enabled.
 * |[7]     |SPLIE7    |Sample Module 7 Interrupt Enable Bit
 * |        |          |0 = Sample Module 7 interrupt Disabled.
 * |        |          |1 = Sample Module 7 interrupt Enabled.
 * |[8]     |SPLIE8    |Sample Module 8 Interrupt Enable Bit
 * |        |          |0 = Sample Module 8 interrupt Disabled.
 * |        |          |1 = Sample Module 8 interrupt Enabled.
 * |[9]     |SPLIE9    |Sample Module 9 Interrupt Enable Bit
 * |        |          |0 = Sample Module 9 interrupt Disabled.
 * |        |          |1 = Sample Module 9 interrupt Enabled.
 * |[10]    |SPLIE10   |Sample Module 10 Interrupt Enable Bit
 * |        |          |0 = Sample Module 10 interrupt Disabled.
 * |        |          |1 = Sample Module 10 interrupt Enabled.
 * |[11]    |SPLIE11   |Sample Module 11 Interrupt Enable Bit
 * |        |          |0 = Sample Module 11 interrupt Disabled.
 * |        |          |1 = Sample Module 11 interrupt Enabled.
 * |[12]    |SPLIE12   |Sample Module 12 Interrupt Enable Bit
 * |        |          |0 = Sample Module 12 interrupt Disabled.
 * |        |          |1 = Sample Module 12 interrupt Enabled.
 * |[13]    |SPLIE13   |Sample Module 13 Interrupt Enable Bit
 * |        |          |0 = Sample Module 13 interrupt Disabled.
 * |        |          |1 = Sample Module 13 interrupt Enabled.
 * |[14]    |SPLIE14   |Sample Module 14 Interrupt Enable Bit
 * |        |          |0 = Sample Module 14 interrupt Disabled.
 * |        |          |1 = Sample Module 14 interrupt Enabled.
 * |[15]    |SPLIE15   |Sample Module 15 Interrupt Enable Bit
 * |        |          |0 = Sample Module 15 interrupt Disabled.
 * |        |          |1 = Sample Module 15 interrupt Enabled.
 * |[16]    |SPLIE16   |Sample Module 16 Interrupt Enable Bit
 * |        |          |0 = Sample Module 16 interrupt Disabled.
 * |        |          |1 = Sample Module 16 interrupt Enabled.
 * |[17]    |SPLIE17   |Sample Module 17 Interrupt Enable Bit
 * |        |          |0 = Sample Module 17 interrupt Disabled.
 * |        |          |1 = Sample Module 17 interrupt Enabled.
 * |[18]    |SPLIE18   |Sample Module 18 Interrupt Enable Bit
 * |        |          |0 = Sample Module 18 interrupt Disabled.
 * |        |          |1 = Sample Module 18 interrupt Enabled.
 * @var EADC_T::CMP
 * Offset: 0xEC  A/D Result Compare Register n, n=0~3
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |ADCMPEN   |A/D Result Compare Enable Bit
 * |        |          |0 = Compare Disabled.
 * |        |          |1 = Compare Enabled.
 * |        |          |Set this bit to 1 to enable compare CMPDAT (EADC_CMPn[27:16], n=0~3) with specified sample module conversion result when converted data is loaded into EADC_DAT register.
 * |[1]     |ADCMPIE   |A/D Result Compare Interrupt Enable Bit
 * |        |          |0 = Compare function interrupt Disabled.
 * |        |          |1 = Compare function interrupt Enabled.
 * |        |          |If the compare function is enabled and the compare condition matches the setting of CMPCOND (EADC_CMPn[2], n=0~3) and CMPMCNT (EADC_CMPn[11:8], n=0~3), ADCMPFn (EADC_STATUS2[7:4], n=0~3) will be asserted, in the meanwhile, if ADCMPIE is set to 1, a compare interrupt request is generated.
 * |[2]     |CMPCOND   |Compare Condition
 * |        |          |0= Set the compare condition as that when a 12-bit A/D conversion result is less than the 12-bit CMPDAT (EADC_CMPn
 * |        |          |[27:16]), the internal match counter will increase one.
 * |        |          |1= Set the compare condition as that when a 12-bit A/D conversion result is greater or equal to the 12-bit CMPDAT (EADC_CMPn [27:16]), the internal match counter will increase one.
 * |        |          |Note: When the internal counter reaches the value to (CMPMCNT (EADC_CMPn[11:8], n=0~3) +1), the CMPF bit will be set.
 * |[7:3]   |CMPSPL    |Compare Sample Module Selection
 * |        |          |00000 = Sample Module 0 conversion result EADC_DAT0 is selected to be compared.
 * |        |          |00001 = Sample Module 1 conversion result EADC_DAT1 is selected to be compared.
 * |        |          |00010 = Sample Module 2 conversion result EADC_DAT2 is selected to be compared.
 * |        |          |00011 = Sample Module 3 conversion result EADC_DAT3 is selected to be compared.
 * |        |          |00100 = Sample Module 4 conversion result EADC_DAT4 is selected to be compared.
 * |        |          |00101 = Sample Module 5 conversion result EADC_DAT5 is selected to be compared.
 * |        |          |00110 = Sample Module 6 conversion result EADC_DAT6 is selected to be compared.
 * |        |          |00111 = Sample Module 7 conversion result EADC_DAT7 is selected to be compared.
 * |        |          |01000 = Sample Module 8 conversion result EADC_DAT8 is selected to be compared.
 * |        |          |01001 = Sample Module 9 conversion result EADC_DAT9 is selected to be compared.
 * |        |          |01010 = Sample Module 10 conversion result EADC_DAT10 is selected to be compared.
 * |        |          |01011 = Sample Module 11 conversion result EADC_DAT11 is selected to be compared.
 * |        |          |01100 = Sample Module 12 conversion result EADC_DAT12 is selected to be compared.
 * |        |          |01101 = Sample Module 13 conversion result EADC_DAT13 is selected to be compared.
 * |        |          |01110 = Sample Module 14 conversion result EADC_DAT14 is selected to be compared.
 * |        |          |01111 = Sample Module 15 conversion result EADC_DAT15 is selected to be compared.
 * |        |          |10000 = Sample Module 16 conversion result EADC_DAT16 is selected to be compared.
 * |        |          |10001 = Sample Module 17 conversion result EADC_DAT17 is selected to be compared.
 * |        |          |10010 = Sample Module 18 conversion result EADC_DAT18 is selected to be compared.
 * |[11:8]  |CMPMCNT   |Compare Match Count
 * |        |          |When the specified A/D sample module analog conversion result matches the compare condition defined by CMPCOND (EADC_CMPn[2], n=0~3), the internal match counter will increase 1.
 * |        |          |If the compare result does not meet the compare condition, the internal compare match counter will reset to 0.
 * |        |          |When the internal counter reaches the value to (CMPMCNT +1), the ADCMPFn (EADC_STATUS2[7:4], n=0~3) will be set.
 * |[15]    |CMPWEN    |Compare Window Mode Enable Bit
 * |        |          |0 = ADCMPF0 (EADC_STATUS2[4]) will be set when EADC_CMP0 compared condition matched.
 * |        |          |ADCMPF2 (EADC_STATUS2[6]) will be set when EADC_CMP2 compared condition matched.
 * |        |          |1 = ADCMPF0 (EADC_STATUS2[4]) will be set when both EADC_CMP0 and EADC_CMP1 compared condition matched.
 * |        |          |ADCMPF2 (EADC_STATUS2[6]) will be set when both EADC_CMP2 and EADC_CMP3 compared condition matched.
 * |        |          |Note: This bit is only present in EADC_CMP0 and EADC_CMP2 register.
 * |[27:16] |CMPDAT    |Comparison Data
 * |        |          |The 12 bits data is used to compare with conversion result of specified sample module.
 * |        |          |User can use it to monitor the external analog input pin voltage transition without imposing a load on software.
 * @var EADC_T::STATUS0
 * Offset: 0xF0  A/D Status Register 0
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |VALID     |EADC_DAT0~15 Data Valid Flag
 * |        |          |It is a mirror of VALID bit in sample module A/D result data register EADC_DATn. (n=0~18).
 * |[31:16] |OV        |EADC_DAT0~15 Overrun Flag
 * |        |          |It is a mirror to OV bit in sample module A/D result data register EADC_DATn. (n=0~18).
 * @var EADC_T::STATUS1
 * Offset: 0xF4  A/D Status Register 1
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[2:0]   |VALID     |EADC_DAT16~18 Data Valid Flag
 * |        |          |It is a mirror of VALID bit in sample module A/D result data register EADC_DATn. (n=0~18).
 * |[18:16] |OV        |EADC_DAT16~18 Overrun Flag
 * |        |          |It is a mirror to OV bit in sample module A/D result data register EADC_DATn. (n=0~18).
 * @var EADC_T::STATUS2
 * Offset: 0xF8  A/D Status Register 2
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |ADIF0     |A/D ADINT0 Interrupt Flag
 * |        |          |0 = No ADINT0 interrupt pulse received.
 * |        |          |1 = ADINT0 interrupt pulse has been received.
 * |        |          |Note1: This bit is cleared by writing 1 to it.
 * |        |          |Note2:This bit indicates whether an A/D conversion of specific sample module has been completed
 * |[1]     |ADIF1     |A/D ADINT1 Interrupt Flag
 * |        |          |0 = No ADINT1 interrupt pulse received.
 * |        |          |1 = ADINT1 interrupt pulse has been received.
 * |        |          |Note1: This bit is cleared by writing 1 to it.
 * |        |          |Note2:This bit indicates whether an A/D conversion of specific sample module has been completed
 * |[2]     |ADIF2     |A/D ADINT2 Interrupt Flag
 * |        |          |0 = No ADINT2 interrupt pulse received.
 * |        |          |1 = ADINT2 interrupt pulse has been received.
 * |        |          |Note1: This bit is cleared by writing 1 to it.
 * |        |          |Note2:This bit indicates whether an A/D conversion of specific sample module has been completed
 * |[3]     |ADIF3     |A/D ADINT3 Interrupt Flag
 * |        |          |0 = No ADINT3 interrupt pulse received.
 * |        |          |1 = ADINT3 interrupt pulse has been received.
 * |        |          |Note1: This bit is cleared by writing 1 to it.
 * |        |          |Note2:This bit indicates whether an A/D conversion of specific sample module has been completed
 * |[4]     |ADCMPF0   |ADC Compare 0 Flag
 * |        |          |When the specific sample module A/D conversion result meets setting condition in EADC_CMP0 then this bit is set to 1.
 * |        |          |0 = Conversion result in EADC_DAT does not meet EADC_CMP0 register setting.
 * |        |          |1 = Conversion result in EADC_DAT meets EADC_CMP0 register setting.
 * |        |          |Note: This bit is cleared by writing 1 to it.
 * |[5]     |ADCMPF1   |ADC Compare 1 Flag
 * |        |          |When the specific sample module A/D conversion result meets setting condition in EADC_CMP1 then this bit is set to 1.
 * |        |          |0 = Conversion result in EADC_DAT does not meet EADC_CMP1 register setting.
 * |        |          |1 = Conversion result in EADC_DAT meets EADC_CMP1 register setting.
 * |        |          |Note: This bit is cleared by writing 1 to it.
 * |[6]     |ADCMPF2   |ADC Compare 2 Flag
 * |        |          |When the specific sample module A/D conversion result meets setting condition in EADC_CMP2 then this bit is set to 1.
 * |        |          |0 = Conversion result in EADC_DAT does not meet EADC_CMP2 register setting.
 * |        |          |1 = Conversion result in EADC_DAT meets EADC_CMP2 register setting.
 * |        |          |Note: This bit is cleared by writing 1 to it.
 * |[7]     |ADCMPF3   |ADC Compare 3 Flag
 * |        |          |When the specific sample module A/D conversion result meets setting condition in EADC_CMP3 then this bit is set to 1.
 * |        |          |0 = Conversion result in EADC_DAT does not meet EADC_CMP3 register setting.
 * |        |          |1 = Conversion result in EADC_DAT meets EADC_CMP3 register setting.
 * |        |          |Note: This bit is cleared by writing 1 to it.
 * |[8]     |ADOVIF0   |A/D ADINT0 Interrupt Flag Overrun
 * |        |          |0 = ADINT0 interrupt flag is not overwritten to 1.
 * |        |          |1 = ADINT0 interrupt flag is overwritten to 1.
 * |        |          |Note: This bit is cleared by writing 1 to it.
 * |[9]     |ADOVIF1   |A/D ADINT1 Interrupt Flag Overrun
 * |        |          |0 = ADINT1 interrupt flag is not overwritten to 1.
 * |        |          |1 = ADINT1 interrupt flag is overwritten to 1.
 * |        |          |Note: This bit is cleared by writing 1 to it.
 * |[10]    |ADOVIF2   |A/D ADINT2 Interrupt Flag Overrun
 * |        |          |0 = ADINT2 interrupt flag is not overwritten to 1.
 * |        |          |1 = ADINT2 interrupt flag is s overwritten to 1.
 * |        |          |Note: This bit is cleared by writing 1 to it.
 * |[11]    |ADOVIF3   |A/D ADINT3 Interrupt Flag Overrun
 * |        |          |0 = ADINT3 interrupt flag is not overwritten to 1.
 * |        |          |1 = ADINT3 interrupt flag is overwritten to 1.
 * |        |          |Note: This bit is cleared by writing 1 to it.
 * |[12]    |ADCMPO0   |ADC Compare 0 Output Status
 * |        |          |The 12 bits compare0 data CMPDAT0 (EADC_CMP0[27:16]) is used to compare with conversion result of specified sample module.
 * |        |          |User can use it to monitor the external analog input pin voltage status.
 * |        |          |0 = Conversion result in EADC_DAT less than CMPDAT0 setting.
 * |        |          |1 = Conversion result in EADC_DAT great than or equal CMPDAT0
 * |        |          |setting.
 * |[13]    |ADCMPO1   |ADC Compare 1 Output Status
 * |        |          |The 12 bits compare1 data CMPDAT1 (EADC_CMP1[27:16]) is used to compare with conversion result of specified sample module.
 * |        |          |User can use it to monitor the external analog input pin voltage status.
 * |        |          |0 = Conversion result in EADC_DAT less than CMPDAT1 setting.
 * |        |          |1 = Conversion result in EADC_DAT great than or equal CMPDAT1
 * |        |          |setting.
 * |[14]    |ADCMPO2   |ADC Compare 2 Output Status
 * |        |          |The 12 bits compare2 data CMPDAT2 (EADC_CMP2[27:16]) is used to compare with conversion result of specified sample module.
 * |        |          |User can use it to monitor the external analog input pin voltage status.
 * |        |          |0 = Conversion result in EADC_DAT less than CMPDAT2 setting.
 * |        |          |1 = Conversion result in EADC_DAT great than or equal CMPDAT2
 * |        |          |setting.
 * |[15]    |ADCMPO3   |ADC Compare 3 Output Status
 * |        |          |The 12 bits compare3 data CMPDAT3 (EADC_CMP3[27:16]) is used to compare with conversion result of specified sample module.
 * |        |          |User can use it to monitor the external analog input pin voltage status.
 * |        |          |0 = Conversion result in EADC_DAT less than CMPDAT3 setting.
 * |        |          |1 = Conversion result in EADC_DAT great than or equal CMPDAT3
 * |        |          |setting.
 * |[20:16] |CHANNEL   |Current Conversion Channel
 * |        |          |This filed reflects ADC current conversion channel when BUSY=1.
 * |        |          |It is read only.
 * |        |          |00H = EADC_CH0.
 * |        |          |01H = EADC_CH1.
 * |        |          |02H = EADC_CH2.
 * |        |          |03H = EADC_CH3.
 * |        |          |04H = EADC_CH4.
 * |        |          |05H = EADC_CH5.
 * |        |          |06H = EADC_CH6.
 * |        |          |07H = EADC_CH7.
 * |        |          |08H = EADC_CH8.
 * |        |          |09H = EADC_CH9.
 * |        |          |0AH = EADC_CH10.
 * |        |          |0BH = EADC_CH11.
 * |        |          |0CH = EADC_CH12.
 * |        |          |0DH = EADC_CH13.
 * |        |          |0EH = EADC_CH14.
 * |        |          |0FH = EADC_CH15.
 * |        |          |10H = VBG.
 * |        |          |11H = VTEMP.
 * |        |          |12H = VBAT.
 * |[23]    |BUSY      |Busy/Idle
 * |        |          |0 = EADC is in idle state.
 * |        |          |1 = EADC is busy at conversion.
 * |        |          |Note: This bit is read only.
 * |[24]    |ADOVIF    |All A/D Interrupt Flag Overrun Bits Check
 * |        |          |n=0~3.
 * |        |          |0 = None of ADINT interrupt flag ADOVIFn (EADC_STATUS2[11:8]) is overwritten to 1.
 * |        |          |1 = Any one of ADINT interrupt flag ADOVIFn (EADC_STATUS2[11:8]) is overwritten to 1.
 * |        |          |Note: This bit will keep 1 when any ADOVIFn Flag is equal to 1.
 * |[25]    |STOVF     |For All A/D Sample Module Start Of Conversion Overrun Flags Check
 * |        |          |n=0~18.
 * |        |          |0 = None of sample module event overrun flag SPOVFn (EADC_OVSTS[n]) is set to 1.
 * |        |          |1 = Any one of sample module event overrun flag SPOVFn (EADC_OVSTS[n]) is set to 1.
 * |        |          |Note: This bit will keep 1 when any SPOVFn Flag is equal to 1.
 * |[26]    |AVALID    |For All Sample Module A/D Result Data Register EADC_DAT Data Valid Flag Check
 * |        |          |n=0~18.
 * |        |          |0 = None of sample module data register valid flag VALIDn (EADC_DATn[17]) is set to 1.
 * |        |          |1 = Any one of sample module data register valid flag VALIDn (EADC_DATn[17]) is set to 1.
 * |        |          |Note: This bit will keep 1 when any VALIDn Flag is equal to 1.
 * |[27]    |AOV       |For All Sample Module A/D Result Data Register Overrun Flags Check
 * |        |          |n=0~18.
 * |        |          |0 = None of sample module data register overrun flag OVn (EADC_DATn[16]) is set to 1.
 * |        |          |1 = Any one of sample module data register overrun flag OVn (EADC_DATn[16]) is set to 1.
 * |        |          |Note: This bit will keep 1 when any OVn Flag is equal to 1.
 * @var EADC_T::STATUS3
 * Offset: 0xFC  A/D Status Register 3
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[4:0]   |CURSPL    |ADC Current Sample Module
 * |        |          |This register show the current ADC is controlled by which sample module control logic modules.
 * |        |          |If the ADC is Idle, this bit filed will set to 0x1F.
 * |        |          |This is a read only register.
 * @var EADC_T::DDAT
 * Offset: 0x100-0x10C  A/D Double Data Register n for Sample Module n, n=0~3
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |RESULT    |A/D Conversion Results
 * |        |          |This field contains 12 bits conversion results.
 * |        |          |When the DMOF (EADC_CTL[9]) is set to 0, 12-bit ADC conversion result with unsigned format will be filled in RESULT [11:0] and zero will be filled in RESULT [15:12].
 * |        |          |When DMOF (EADC_CTL[9]) set to 1, 12-bit ADC conversion result with 2'complement format will be filled in RESULT [11:0] and signed bits to will be filled in RESULT [15:12].
 * |[16]    |OV        |Overrun Flag
 * |        |          |0 = Data in RESULT (EADC_DATn[15:0], n=0~3) is recent conversion result.
 * |        |          |1 = Data in RESULT (EADC_DATn[15:0], n=0~3) is overwrite.
 * |        |          |If converted data in RESULT[15:0] has not been read before new conversion result is loaded to this register, OV is set to 1.
 * |        |          |It is cleared by hardware after EADC_DDAT register is read.
 * |[17]    |VALID     |Valid Flag
 * |        |          |0 = Double data in RESULT (EADC_DDATn[15:0]) is not valid.
 * |        |          |1 = Double data in RESULT (EADC_DDATn[15:0]) is valid.
 * |        |          |This bit is set to 1 when corresponding sample module channel analog input conversion is completed and cleared by hardware after EADC_DDATn register is read.
 * |        |          |(n=0~3).
 */

    __I  uint32_t DAT[19];       /* Offset: 0x00-0x48  A/D Data Register n for Sample Module n, n=0~18               */
    __I  uint32_t CURDAT;        /* Offset: 0x4C  EADC PDMA Current Transfer Data Register                           */
    __IO uint32_t CTL;           /* Offset: 0x50  A/D Control Register                                               */
    __O  uint32_t SWTRG;         /* Offset: 0x54  A/D Sample Module Software Start Register                          */
    __IO uint32_t PENDSTS;       /* Offset: 0x58  A/D Start of Conversion Pending Flag Register                      */
    __IO uint32_t OVSTS;         /* Offset: 0x5C  A/D Sample Module Start of Conversion Overrun Flag Register        */
    __I  uint32_t RESERVE0[8];  
    __IO uint32_t SCTL[19];      /* Offset: 0x80-0xC8  A/D Sample Module n Control Register, n=0~3                   */
    __I  uint32_t RESERVE1[1];  
    __IO uint32_t INTSRC[4];     /* Offset: 0xDC  ADC interrupt n Source Enable Control Register, n=0~3              */
    __IO uint32_t CMP[4];        /* Offset: 0xEC  A/D Result Compare Register n, n=0~3                               */
    __I  uint32_t STATUS0;       /* Offset: 0xF0  A/D Status Register 0                                              */
    __I  uint32_t STATUS1;       /* Offset: 0xF4  A/D Status Register 1                                              */
    __IO uint32_t STATUS2;       /* Offset: 0xF8  A/D Status Register 2                                              */
    __I  uint32_t STATUS3;       /* Offset: 0xFC  A/D Status Register 3                                              */
    __I  uint32_t DDAT[4];       /* Offset: 0x100-0x10C  A/D Double Data Register n for Sample Module n, n=0~3       */

} EADC_T;



/**
    @addtogroup EADC_CONST EADC Bit Field Definition
    Constant Definitions for EADC Controller
@{ */
#define EADC_DAT_RESULT_Pos               (0)                                               /*!< EADC_T::DAT: RESULT Position              */
#define EADC_DAT_RESULT_Msk               (0xfffful << EADC_DAT_RESULT_Pos)                 /*!< EADC_T::DAT: RESULT Mask                  */

#define EADC_DAT_OV_Pos                   (16)                                              /*!< EADC_T::DAT: OV Position                  */
#define EADC_DAT_OV_Msk                   (0x1ul << EADC_DAT_OV_Pos)                        /*!< EADC_T::DAT: OV Mask                      */

#define EADC_DAT_VALID_Pos                (17)                                              /*!< EADC_T::DAT: VALID Position               */
#define EADC_DAT_VALID_Msk                (0x1ul << EADC_DAT_VALID_Pos)                     /*!< EADC_T::DAT: VALID Mask                   */

#define EADC_CURDAT_CURDAT_Pos            (0)                                               /*!< EADC_T::CURDAT: CURDAT Position           */
#define EADC_CURDAT_CURDAT_Msk            (0x3fffful << EADC_CURDAT_CURDAT_Pos)             /*!< EADC_T::CURDAT: CURDAT Mask               */

#define EADC_CTL_ADCEN_Pos                (0)                                               /*!< EADC_T::CTL: ADCEN Position               */
#define EADC_CTL_ADCEN_Msk                (0x1ul << EADC_CTL_ADCEN_Pos)                     /*!< EADC_T::CTL: ADCEN Mask                   */

#define EADC_CTL_ADRST_Pos                (1)                                               /*!< EADC_T::CTL: ADRST Position               */
#define EADC_CTL_ADRST_Msk                (0x1ul << EADC_CTL_ADRST_Pos)                     /*!< EADC_T::CTL: ADRST Mask                   */

#define EADC_CTL_ADCIEN0_Pos              (2)                                               /*!< EADC_T::CTL: ADCIEN0 Position             */
#define EADC_CTL_ADCIEN0_Msk              (0x1ul << EADC_CTL_ADCIEN0_Pos)                   /*!< EADC_T::CTL: ADCIEN0 Mask                 */

#define EADC_CTL_ADCIEN1_Pos              (3)                                               /*!< EADC_T::CTL: ADCIEN1 Position             */
#define EADC_CTL_ADCIEN1_Msk              (0x1ul << EADC_CTL_ADCIEN1_Pos)                   /*!< EADC_T::CTL: ADCIEN1 Mask                 */

#define EADC_CTL_ADCIEN2_Pos              (4)                                               /*!< EADC_T::CTL: ADCIEN2 Position             */
#define EADC_CTL_ADCIEN2_Msk              (0x1ul << EADC_CTL_ADCIEN2_Pos)                   /*!< EADC_T::CTL: ADCIEN2 Mask                 */

#define EADC_CTL_ADCIEN3_Pos              (5)                                               /*!< EADC_T::CTL: ADCIEN3 Position             */
#define EADC_CTL_ADCIEN3_Msk              (0x1ul << EADC_CTL_ADCIEN3_Pos)                   /*!< EADC_T::CTL: ADCIEN3 Mask                 */

#define EADC_CTL_DIFFEN_Pos               (8)                                               /*!< EADC_T::CTL: DIFFEN Position              */
#define EADC_CTL_DIFFEN_Msk               (0x1ul << EADC_CTL_DIFFEN_Pos)                    /*!< EADC_T::CTL: DIFFEN Mask                  */

#define EADC_CTL_DMOF_Pos                 (9)                                               /*!< EADC_T::CTL: DMOF Position                */
#define EADC_CTL_DMOF_Msk                 (0x1ul << EADC_CTL_DMOF_Pos)                      /*!< EADC_T::CTL: DMOF Mask                    */

#define EADC_CTL_PDMAEN_Pos               (11)                                              /*!< EADC_T::CTL: PDMAEN Position              */
#define EADC_CTL_PDMAEN_Msk               (0x1ul << EADC_CTL_PDMAEN_Pos)                    /*!< EADC_T::CTL: PDMAEN Mask                  */

#define EADC_CTL_SMPTSEL_Pos              (16)                                              /*!< EADC_T::CTL: SMPTSEL Position             */
#define EADC_CTL_SMPTSEL_Msk              (0x7ul << EADC_CTL_SMPTSEL_Pos)                   /*!< EADC_T::CTL: SMPTSEL Mask                 */

#define EADC_SWTRG_SWTRG_Pos              (0)                                               /*!< EADC_T::SWTRG: SWTRG Position             */
#define EADC_SWTRG_SWTRG_Msk              (0x7fffful << EADC_SWTRG_SWTRG_Pos)               /*!< EADC_T::SWTRG: SWTRG Mask                 */

#define EADC_PENDSTS_STPF_Pos             (0)                                               /*!< EADC_T::PENDSTS: STPF Position            */
#define EADC_PENDSTS_STPF_Msk             (0x7fffful << EADC_PENDSTS_STPF_Pos)              /*!< EADC_T::PENDSTS: STPF Mask                */

#define EADC_OVSTS_SPOVF_Pos              (0)                                               /*!< EADC_T::OVSTS: SPOVF Position             */
#define EADC_OVSTS_SPOVF_Msk              (0x7fffful << EADC_OVSTS_SPOVF_Pos)               /*!< EADC_T::OVSTS: SPOVF Mask                 */

#define EADC_SCTL_CHSEL_Pos               (0)                                               /*!< EADC_T::SCTL: CHSEL Position              */
#define EADC_SCTL_CHSEL_Msk               (0xful << EADC_SCTL_CHSEL_Pos)                    /*!< EADC_T::SCTL: CHSEL Mask                  */

#define EADC_SCTL_EXTREN_Pos              (4)                                               /*!< EADC_T::SCTL: EXTREN Position             */
#define EADC_SCTL_EXTREN_Msk              (0x1ul << EADC_SCTL_EXTREN_Pos)                   /*!< EADC_T::SCTL: EXTREN Mask                 */

#define EADC_SCTL_EXTFEN_Pos              (5)                                               /*!< EADC_T::SCTL: EXTFEN Position             */
#define EADC_SCTL_EXTFEN_Msk              (0x1ul << EADC_SCTL_EXTFEN_Pos)                   /*!< EADC_T::SCTL: EXTFEN Mask                 */

#define EADC_SCTL_TRGDLYDIV_Pos           (6)                                               /*!< EADC_T::SCTL: TRGDLYDIV Position          */
#define EADC_SCTL_TRGDLYDIV_Msk           (0x3ul << EADC_SCTL_TRGDLYDIV_Pos)                /*!< EADC_T::SCTL: TRGDLYDIV Mask              */

#define EADC_SCTL_TRGDLYCNT_Pos           (8)                                               /*!< EADC_T::SCTL: TRGDLYCNT Position          */
#define EADC_SCTL_TRGDLYCNT_Msk           (0xfful << EADC_SCTL_TRGDLYCNT_Pos)               /*!< EADC_T::SCTL: TRGDLYCNT Mask              */

#define EADC_SCTL_TRGSEL_Pos              (16)                                              /*!< EADC_T::SCTL: TRGSEL Position             */
#define EADC_SCTL_TRGSEL_Msk              (0x1ful << EADC_SCTL_TRGSEL_Pos)                  /*!< EADC_T::SCTL: TRGSEL Mask                 */

#define EADC_SCTL_INTPOS_Pos              (22)                                              /*!< EADC_T::SCTL: INTPOS Position             */
#define EADC_SCTL_INTPOS_Msk              (0x1ul << EADC_SCTL_INTPOS_Pos)                   /*!< EADC_T::SCTL: INTPOS Mask                 */

#define EADC_SCTL_DBMEN_Pos               (23)                                              /*!< EADC_T::SCTL: DBMEN Position              */
#define EADC_SCTL_DBMEN_Msk               (0x1ul << EADC_SCTL_DBMEN_Pos)                    /*!< EADC_T::SCTL: DBMEN Mask                  */

#define EADC_SCTL_EXTSMPT_Pos             (24)                                              /*!< EADC_T::SCTL: EXTSMPT Position            */
#define EADC_SCTL_EXTSMPT_Msk             (0xfful << EADC_SCTL_EXTSMPT_Pos)                 /*!< EADC_T::SCTL: EXTSMPT Mask                */

#define EADC_INTSRC_SPLIE_Pos             (0)                                               /*!< EADC_T::INTSRC: SPLIE Position            */
#define EADC_INTSRC_SPLIE_Msk             (0x7FFFFul << EADC_INTSRC_SPLIE_Pos)              /*!< EADC_T::INTSRC: SPLIE Mask                */

#define EADC_CMP_ADCMPEN_Pos              (0)                                               /*!< EADC_T::CMP: ADCMPEN Position             */
#define EADC_CMP_ADCMPEN_Msk              (0x1ul << EADC_CMP_ADCMPEN_Pos)                   /*!< EADC_T::CMP: ADCMPEN Mask                 */

#define EADC_CMP_ADCMPIE_Pos              (1)                                               /*!< EADC_T::CMP: ADCMPIE Position             */
#define EADC_CMP_ADCMPIE_Msk              (0x1ul << EADC_CMP_ADCMPIE_Pos)                   /*!< EADC_T::CMP: ADCMPIE Mask                 */

#define EADC_CMP_CMPCOND_Pos              (2)                                               /*!< EADC_T::CMP: CMPCOND Position             */
#define EADC_CMP_CMPCOND_Msk              (0x1ul << EADC_CMP_CMPCOND_Pos)                   /*!< EADC_T::CMP: CMPCOND Mask                 */

#define EADC_CMP_CMPSPL_Pos               (3)                                               /*!< EADC_T::CMP: CMPSPL Position              */
#define EADC_CMP_CMPSPL_Msk               (0x1ful << EADC_CMP_CMPSPL_Pos)                   /*!< EADC_T::CMP: CMPSPL Mask                  */

#define EADC_CMP_CMPMCNT_Pos              (8)                                               /*!< EADC_T::CMP: CMPMCNT Position             */
#define EADC_CMP_CMPMCNT_Msk              (0xful << EADC_CMP_CMPMCNT_Pos)                   /*!< EADC_T::CMP: CMPMCNT Mask                 */

#define EADC_CMP_CMPWEN_Pos               (15)                                              /*!< EADC_T::CMP: CMPWEN Position              */
#define EADC_CMP_CMPWEN_Msk               (0x1ul << EADC_CMP_CMPWEN_Pos)                    /*!< EADC_T::CMP: CMPWEN Mask                  */

#define EADC_CMP_CMPDAT_Pos               (16)                                              /*!< EADC_T::CMP: CMPDAT Position              */
#define EADC_CMP_CMPDAT_Msk               (0xffful << EADC_CMP_CMPDAT_Pos)                  /*!< EADC_T::CMP: CMPDAT Mask                  */

#define EADC_STATUS0_VALID_Pos            (0)                                               /*!< EADC_T::STATUS0: VALID Position           */
#define EADC_STATUS0_VALID_Msk            (0xfffful << EADC_STATUS0_VALID_Pos)              /*!< EADC_T::STATUS0: VALID Mask               */

#define EADC_STATUS0_OV_Pos               (16)                                              /*!< EADC_T::STATUS0: OV Position              */
#define EADC_STATUS0_OV_Msk               (0xfffful << EADC_STATUS0_OV_Pos)                 /*!< EADC_T::STATUS0: OV Mask                  */

#define EADC_STATUS1_VALID_Pos            (0)                                               /*!< EADC_T::STATUS1: VALID Position           */
#define EADC_STATUS1_VALID_Msk            (0x7ul << EADC_STATUS1_VALID_Pos)                 /*!< EADC_T::STATUS1: VALID Mask               */

#define EADC_STATUS1_OV_Pos               (16)                                              /*!< EADC_T::STATUS1: OV Position              */
#define EADC_STATUS1_OV_Msk               (0x7ul << EADC_STATUS1_OV_Pos)                    /*!< EADC_T::STATUS1: OV Mask                  */

#define EADC_STATUS2_ADIF0_Pos            (0)                                               /*!< EADC_T::STATUS2: ADIF0 Position           */
#define EADC_STATUS2_ADIF0_Msk            (0x1ul << EADC_STATUS2_ADIF0_Pos)                 /*!< EADC_T::STATUS2: ADIF0 Mask               */

#define EADC_STATUS2_ADIF1_Pos            (1)                                               /*!< EADC_T::STATUS2: ADIF1 Position           */
#define EADC_STATUS2_ADIF1_Msk            (0x1ul << EADC_STATUS2_ADIF1_Pos)                 /*!< EADC_T::STATUS2: ADIF1 Mask               */

#define EADC_STATUS2_ADIF2_Pos            (2)                                               /*!< EADC_T::STATUS2: ADIF2 Position           */
#define EADC_STATUS2_ADIF2_Msk            (0x1ul << EADC_STATUS2_ADIF2_Pos)                 /*!< EADC_T::STATUS2: ADIF2 Mask               */

#define EADC_STATUS2_ADIF3_Pos            (3)                                               /*!< EADC_T::STATUS2: ADIF3 Position           */
#define EADC_STATUS2_ADIF3_Msk            (0x1ul << EADC_STATUS2_ADIF3_Pos)                 /*!< EADC_T::STATUS2: ADIF3 Mask               */

#define EADC_STATUS2_ADCMPF0_Pos          (4)                                               /*!< EADC_T::STATUS2: ADCMPF0 Position         */
#define EADC_STATUS2_ADCMPF0_Msk          (0x1ul << EADC_STATUS2_ADCMPF0_Pos)               /*!< EADC_T::STATUS2: ADCMPF0 Mask             */

#define EADC_STATUS2_ADCMPF1_Pos          (5)                                               /*!< EADC_T::STATUS2: ADCMPF1 Position         */
#define EADC_STATUS2_ADCMPF1_Msk          (0x1ul << EADC_STATUS2_ADCMPF1_Pos)               /*!< EADC_T::STATUS2: ADCMPF1 Mask             */

#define EADC_STATUS2_ADCMPF2_Pos          (6)                                               /*!< EADC_T::STATUS2: ADCMPF2 Position         */
#define EADC_STATUS2_ADCMPF2_Msk          (0x1ul << EADC_STATUS2_ADCMPF2_Pos)               /*!< EADC_T::STATUS2: ADCMPF2 Mask             */

#define EADC_STATUS2_ADCMPF3_Pos          (7)                                               /*!< EADC_T::STATUS2: ADCMPF3 Position         */
#define EADC_STATUS2_ADCMPF3_Msk          (0x1ul << EADC_STATUS2_ADCMPF3_Pos)               /*!< EADC_T::STATUS2: ADCMPF3 Mask             */

#define EADC_STATUS2_ADOVIF0_Pos          (8)                                               /*!< EADC_T::STATUS2: ADOVIF0 Position         */
#define EADC_STATUS2_ADOVIF0_Msk          (0x1ul << EADC_STATUS2_ADOVIF0_Pos)               /*!< EADC_T::STATUS2: ADOVIF0 Mask             */

#define EADC_STATUS2_ADOVIF1_Pos          (9)                                               /*!< EADC_T::STATUS2: ADOVIF1 Position         */
#define EADC_STATUS2_ADOVIF1_Msk          (0x1ul << EADC_STATUS2_ADOVIF1_Pos)               /*!< EADC_T::STATUS2: ADOVIF1 Mask             */

#define EADC_STATUS2_ADOVIF2_Pos          (10)                                              /*!< EADC_T::STATUS2: ADOVIF2 Position         */
#define EADC_STATUS2_ADOVIF2_Msk          (0x1ul << EADC_STATUS2_ADOVIF2_Pos)               /*!< EADC_T::STATUS2: ADOVIF2 Mask             */

#define EADC_STATUS2_ADOVIF3_Pos          (11)                                              /*!< EADC_T::STATUS2: ADOVIF3 Position         */
#define EADC_STATUS2_ADOVIF3_Msk          (0x1ul << EADC_STATUS2_ADOVIF3_Pos)               /*!< EADC_T::STATUS2: ADOVIF3 Mask             */

#define EADC_STATUS2_ADCMPO0_Pos          (12)                                              /*!< EADC_T::STATUS2: ADCMPO0 Position         */
#define EADC_STATUS2_ADCMPO0_Msk          (0x1ul << EADC_STATUS2_ADCMPO0_Pos)               /*!< EADC_T::STATUS2: ADCMPO0 Mask             */

#define EADC_STATUS2_ADCMPO1_Pos          (13)                                              /*!< EADC_T::STATUS2: ADCMPO1 Position         */
#define EADC_STATUS2_ADCMPO1_Msk          (0x1ul << EADC_STATUS2_ADCMPO1_Pos)               /*!< EADC_T::STATUS2: ADCMPO1 Mask             */

#define EADC_STATUS2_ADCMPO2_Pos          (14)                                              /*!< EADC_T::STATUS2: ADCMPO2 Position         */
#define EADC_STATUS2_ADCMPO2_Msk          (0x1ul << EADC_STATUS2_ADCMPO2_Pos)               /*!< EADC_T::STATUS2: ADCMPO2 Mask             */

#define EADC_STATUS2_ADCMPO3_Pos          (15)                                              /*!< EADC_T::STATUS2: ADCMPO3 Position         */
#define EADC_STATUS2_ADCMPO3_Msk          (0x1ul << EADC_STATUS2_ADCMPO3_Pos)               /*!< EADC_T::STATUS2: ADCMPO3 Mask             */

#define EADC_STATUS2_CHANNEL_Pos          (16)                                              /*!< EADC_T::STATUS2: CHANNEL Position         */
#define EADC_STATUS2_CHANNEL_Msk          (0x1ful << EADC_STATUS2_CHANNEL_Pos)              /*!< EADC_T::STATUS2: CHANNEL Mask             */

#define EADC_STATUS2_BUSY_Pos             (23)                                              /*!< EADC_T::STATUS2: BUSY Position            */
#define EADC_STATUS2_BUSY_Msk             (0x1ul << EADC_STATUS2_BUSY_Pos)                  /*!< EADC_T::STATUS2: BUSY Mask                */

#define EADC_STATUS2_ADOVIF_Pos           (24)                                              /*!< EADC_T::STATUS2: ADOVIF Position          */
#define EADC_STATUS2_ADOVIF_Msk           (0x1ul << EADC_STATUS2_ADOVIF_Pos)                /*!< EADC_T::STATUS2: ADOVIF Mask              */

#define EADC_STATUS2_STOVF_Pos            (25)                                              /*!< EADC_T::STATUS2: STOVF Position           */
#define EADC_STATUS2_STOVF_Msk            (0x1ul << EADC_STATUS2_STOVF_Pos)                 /*!< EADC_T::STATUS2: STOVF Mask               */

#define EADC_STATUS2_AVALID_Pos           (26)                                              /*!< EADC_T::STATUS2: AVALID Position          */
#define EADC_STATUS2_AVALID_Msk           (0x1ul << EADC_STATUS2_AVALID_Pos)                /*!< EADC_T::STATUS2: AVALID Mask              */

#define EADC_STATUS2_AOV_Pos              (27)                                              /*!< EADC_T::STATUS2: AOV Position             */
#define EADC_STATUS2_AOV_Msk              (0x1ul << EADC_STATUS2_AOV_Pos)                   /*!< EADC_T::STATUS2: AOV Mask                 */

#define EADC_STATUS3_CURSPL_Pos           (0)                                               /*!< EADC_T::STATUS3: CURSPL Position          */
#define EADC_STATUS3_CURSPL_Msk           (0x1ful << EADC_STATUS3_CURSPL_Pos)               /*!< EADC_T::STATUS3: CURSPL Mask              */

#define EADC_DDAT_RESULT_Pos              (0)                                               /*!< EADC_T::DDAT: RESULT Position             */
#define EADC_DDAT_RESULT_Msk              (0xfffful << EADC_DDAT_RESULT_Pos)                /*!< EADC_T::DDAT: RESULT Mask                 */

#define EADC_DDAT_OV_Pos                  (16)                                              /*!< EADC_T::DDAT: OV Position                 */
#define EADC_DDAT_OV_Msk                  (0x1ul << EADC_DDAT_OV_Pos)                       /*!< EADC_T::DDAT: OV Mask                     */

#define EADC_DDAT_VALID_Pos               (17)                                              /*!< EADC_T::DDAT: VALID Position              */
#define EADC_DDAT_VALID_Msk               (0x1ul << EADC_DDAT_VALID_Pos)                    /*!< EADC_T::DDAT: VALID Mask                  */


/**@}*/ /* EADC_CONST */
/**@}*/ /* end of EADC register group */


/*---------------------- Controller Area Network Controller -------------------------*/
/**
    @addtogroup CAN Controller Area Network Controller(CAN)
    Memory Mapped Structure for CAN Controller
@{ */


typedef struct
{



/**
 * @var CAN_IF_T::CREQ
 * Offset: 0x20, 0x80  IFn (Register Map Note 2) Command Request Registers
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[5:0]   |MessageNumber|Message Number
 * |        |          |0x01-0x20: Valid Message Number, the Message Object in the Message
 * |        |          |RAM is selected for data transfer.
 * |        |          |0x00: Not a valid Message Number, interpreted as 0x20.
 * |        |          |0x21-0x3F: Not a valid Message Number, interpreted as 0x01-0x1F.
 * |[15]    |Busy      |Busy Flag
 * |        |          |0 = Read/write action has finished.
 * |        |          |1 = Writing to the IFn Command Request Register is in progress.
 * |        |          |This bit can only be read by the software.
 * @var CAN_IF_T::CMASK
 * Offset: 0x24, 0x84  IFn Command Mask Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |DAT_B     |Access Data Bytes [7:4]
 * |        |          |Write Operation:
 * |        |          |0 = Data Bytes [7:4] unchanged.
 * |        |          |1 = Transfer Data Bytes [7:4] to Message Object.
 * |        |          |Read Operation:
 * |        |          |0 = Data Bytes [7:4] unchanged.
 * |        |          |1 = Transfer Data Bytes [7:4] to IFn Message Buffer Register.
 * |[1]     |DAT_A     |Access Data Bytes [3:0]
 * |        |          |Write Operation:
 * |        |          |0 = Data Bytes [3:0] unchanged.
 * |        |          |1 = Transfer Data Bytes [3:0] to Message Object.
 * |        |          |Read Operation:
 * |        |          |0 = Data Bytes [3:0] unchanged.
 * |        |          |1 = Transfer Data Bytes [3:0] to IFn Message Buffer Register.
 * |[2]     |TxRqst_NewDat|Access Transmission Request Bit When Write Operation
 * |        |          |0 = TxRqst bit unchanged.
 * |        |          |1 = Set TxRqst bit.
 * |        |          |Note: If a transmission is requested by programming bit TxRqst/NewDat in the IFn Command Mask Register, bit TxRqst in the IFn Message Control Register will be ignored.
 * |        |          |Access New Data Bit when Read Operation.
 * |        |          |0 = NewDat bit remains unchanged.
 * |        |          |1 = Clear NewDat bit in the Message Object.
 * |        |          |Note: A read access to a Message Object can be combined with the reset of the control bits IntPnd and NewDat.
 * |        |          |The values of these bits transferred to the IFn Message Control Register always reflect the status before resetting these bits.
 * |[3]     |ClrIntPnd |Clear Interrupt Pending Bit
 * |        |          |Write Operation:
 * |        |          |When writing to a Message Object, this bit is ignored.
 * |        |          |Read Operation:
 * |        |          |0 = IntPnd bit (CAN_IFn_MCON[13]) remains unchanged.
 * |        |          |1 = Clear IntPnd bit in the Message Object.
 * |[4]     |Control   |Control Access Control Bits
 * |        |          |Write Operation:
 * |        |          |0 = Control Bits unchanged.
 * |        |          |1 = Transfer Control Bits to Message Object.
 * |        |          |Read Operation:
 * |        |          |0 = Control Bits unchanged.
 * |        |          |1 = Transfer Control Bits to IFn Message Buffer Register.
 * |[5]     |Arb       |Access Arbitration Bits
 * |        |          |Write Operation:
 * |        |          |0 = Arbitration bits unchanged.
 * |        |          |1 = Transfer Identifier + Dir (CAN_IFn_ARB2[13]) + Xtd (CAN_IFn_ARB2[14]) + MsgVal (CAN_IFn_APB2[15]) to Message Object.
 * |        |          |Read Operation:
 * |        |          |0 = Arbitration bits unchanged.
 * |        |          |1 = Transfer Identifier + Dir + Xtd + MsgVal to IFn Message Buffer Register.
 * |[6]     |Mask      |Access Mask Bits
 * |        |          |Write Operation:
 * |        |          |0 = Mask bits unchanged.
 * |        |          |1 = Transfer Identifier Mask + MDir + MXtd to Message Object.
 * |        |          |Read Operation:
 * |        |          |0 = Mask bits unchanged.
 * |        |          |1 = Transfer Identifier Mask + MDir + MXtd to IFn Message Buffer Register.
 * |[7]     |WR_RD     |Write / Read Mode
 * |        |          |0 = Read: Transfer data from the Message Object addressed by the Command Request Register into the selected Message Buffer Registers.
 * |        |          |1 = Write: Transfer data from the selected Message Buffer Registers to the Message Object addressed by the Command Request Register.
 * @var CAN_IF_T::MASK1
 * Offset: 0x28, 0x88  IFn Mask 1 Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |Msk[15:0] |Identifier Mask 15-0
 * |        |          |0 = The corresponding bit in the identifier of the message object cannot inhibit the match in the acceptance filtering.
 * |        |          |1 = The corresponding identifier bit is used for acceptance filtering.
 * @var CAN_IF_T::MASK2
 * Offset: 0x2C, 0x8C  IFn Mask 2 Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[12:0]  |Msk[28:16]|Identifier Mask 28-16
 * |        |          |0 = The corresponding bit in the identifier of the message object cannot inhibit the match in the acceptance filtering.
 * |        |          |1 = The corresponding identifier bit is used for acceptance filtering.
 * |[14]    |MDir      |Mask Message Direction
 * |        |          |0 = The message direction bit (Dir (CAN_IFn_ARB2[13])) has no effect on the acceptance filtering.
 * |        |          |1 = The message direction bit (Dir) is used for acceptance filtering.
 * |[15]    |MXtd      |Mask Extended Identifier
 * |        |          |0 = The extended identifier bit (IDE) has no effect on the acceptance filtering.
 * |        |          |1 = The extended identifier bit (IDE) is used for acceptance filtering.
 * |        |          |Note: When 11-bit ("standard") Identifiers are used for a Message Object, the identifiers of received Data Frames are written into bits ID28 to ID18 (CAN_IFn_ARB2[12:2]).
 * |        |          |For acceptance filtering, only these bits together with mask bits Msk28 to Msk18 (CAN_IFn_MASK2[12:2]) are considered.
 * @var CAN_IF_T::ARB1
 * Offset: 0x30, 0x90  IFn Arbitration 1 Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |ID[15:0]  |Message Identifier 15-0
 * |        |          |ID28 - ID0, 29-bit Identifier ("Extended Frame").
 * |        |          |ID28 - ID18, 11-bit Identifier ("Standard Frame")
 * @var CAN_IF_T::ARB2
 * Offset: 0x34, 0x94  IFn Arbitration 2 Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[12:0]  |ID[28:16] |Message Identifier 28-16
 * |        |          |ID28 - ID0, 29-bit Identifier ("Extended Frame").
 * |        |          |ID28 - ID18, 11-bit Identifier ("Standard Frame")
 * |[13]    |Dir       |Message Direction
 * |        |          |0 = Direction is receive.
 * |        |          |On TxRqst, a Remote Frame with the identifier of this Message Object is transmitted.
 * |        |          |On reception of a Data Frame with matching identifier, that message is stored in this Message Object.
 * |        |          |1 = Direction is transmit.
 * |        |          |On TxRqst, the respective Message Object is transmitted as a Data Frame.
 * |        |          |On reception of a Remote Frame with matching identifier, the TxRqst bit (CAN_IFn_CMASK[2]) of this Message Object is set (if RmtEn (CAN_IFn_MCON[9]) = one).
 * |[14]    |Xtd       |Extended Identifier
 * |        |          |0 = The 11-bit ("standard") Identifier will be used for this Message Object.
 * |        |          |1 = The 29-bit ("extended") Identifier will be used for this Message Object.
 * |[15]    |MsgVal    |Message Valid
 * |        |          |0 = The Message Object is ignored by the Message Handler.
 * |        |          |1 = The Message Object is configured and should be considered by the Message Handler.
 * |        |          |Note: The application software must reset the MsgVal bit of all unused Messages Objects during the initialization before it resets bit Init (CAN_CON[0]).
 * |        |          |This bit must also be reset before the identifier Id28-0 (CAN_IFn_ARB1/2), the control bits Xtd (CAN_IFn_ARB2[14]), Dir (CAN_IFn_APB2[13]), or the Data Length Code DLC3-0 (CAN_IFn_MCON[3:0]) are modified, or if the Messages Object is no longer required.
 * @var CAN_IF_T::MCON
 * Offset: 0x38, 0x98  IFn Message Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[3:0]   |DLC       |Data Length Code
 * |        |          |0-8: Data Frame has 0-8 data bytes.
 * |        |          |9-15: Data Frame has 8 data bytes
 * |        |          |Note: The Data Length Code of a Message Object must be defined the same as in all the corresponding objects with the same identifier at other nodes.
 * |        |          |When the Message Handler stores a data frame, it will write the DLC to the value given by the received message.
 * |        |          |Data 0: 1st data byte of a CAN Data Frame
 * |        |          |Data 1: 2nd data byte of a CAN Data Frame
 * |        |          |Data 2: 3rd data byte of a CAN Data Frame
 * |        |          |Data 3: 4th data byte of a CAN Data Frame
 * |        |          |Data 4: 5th data byte of a CAN Data Frame
 * |        |          |Data 5: 6th data byte of a CAN Data Frame
 * |        |          |Data 6: 7th data byte of a CAN Data Frame
 * |        |          |Data 7 : 8th data byte of a CAN Data Frame
 * |        |          |Note: The Data 0 Byte is the first data byte shifted into the shift register of the CAN Core during a reception while the Data 7 byte is the last.
 * |        |          |When the Message Handler stores a Data Frame, it will write all the eight data bytes into a Message Object.
 * |        |          |If the Data Length Code is less than 8, the remaining bytes of the Message Object will be overwritten by unspecified values.
 * |[7]     |EoB       |End Of Buffer
 * |        |          |0 = Message Object belongs to a FIFO Buffer and is not the last Message Object of that FIFO Buffer.
 * |        |          |1 = Single Message Object or last Message Object of a FIFO Buffer.
 * |        |          |Note: This bit is used to concatenate two or more Message Objects (up to 32) to build a FIFO Buffer.
 * |        |          |For single Message Objects (not belonging to a FIFO Buffer), this bit must always be set to one.
 * |[8]     |TxRqst    |Transmit Request
 * |        |          |0 = This Message Object is not waiting for transmission.
 * |        |          |1 = The transmission of this Message Object is requested and is not yet done.
 * |[9]     |RmtEn     |Remote Enable Control
 * |        |          |0 = At the reception of a Remote Frame, TxRqst (CAN_IFn_MCON[8]) is left unchanged.
 * |        |          |1 = At the reception of a Remote Frame, TxRqst is set.
 * |[10]    |RxIE      |Receive Interrupt Enable Control
 * |        |          |0 = IntPnd (CAN_IFn_MCON[13]) will be left unchanged after a successful reception of a frame.
 * |        |          |1 = IntPnd will be set after a successful reception of a frame.
 * |[11]    |TxIE      |Transmit Interrupt Enable Control
 * |        |          |0 = IntPnd (CAN_IFn_MCON[13]) will be left unchanged after the successful transmission of a frame.
 * |        |          |1 = IntPnd will be set after a successful transmission of a frame.
 * |[12]    |UMask     |Use Acceptance Mask
 * |        |          |0 = Mask ignored.
 * |        |          |1 = Use Mask (Msk28-0, MXtd, and MDir) for acceptance filtering.
 * |        |          |Note: If the UMask bit is set to one, the Message Object's mask bits have to be programmed during initialization of the Message Object before MsgVal bit (CAN_IFn_APB2[15]) is set to one.
 * |[13]    |IntPnd    |Interrupt Pending
 * |        |          |0 = This message object is not the source of an interrupt.
 * |        |          |1 = This message object is the source of an interrupt.
 * |        |          |The Interrupt Identifier in the Interrupt Register will point to this message object if there is no other interrupt source with higher priority.
 * |[14]    |MsgLst    |Message Lost (only valid for Message Objects with direction = receive).
 * |        |          |0 = No message lost since last time this bit was reset by the CPU.
 * |        |          |1 = The Message Handler stored a new message into this object when NewDat was still set, the CPU has lost a message.
 * |[15]    |NewDat    |New Data
 * |        |          |0 = No new data has been written into the data portion of this Message Object by the Message Handler since last time this flag was cleared by the application software.
 * |        |          |1 = The Message Handler or the application software has written new data into the data portion of this Message Object.
 * @var CAN_IF_T::DAT_A1
 * Offset: 0x3C, 0x9C  IFn Data A1 Register (Register Map Note 3)
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[7:0]   |Data0     |Data Byte 0
 * |        |          |1st data byte of a CAN Data Frame
 * |[15:8]  |Data1     |Data Byte 1
 * |        |          |2nd data byte of a CAN Data Frame
 * @var CAN_IF_T::DAT_A2
 * Offset: 0x40, 0xA0  IFn Data A2 Register (Register Map Note 3)
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[7:0]   |Data2     |Data Byte 2
 * |        |          |3rd data byte of CAN Data Frame
 * |[15:8]  |Data3     |Data Byte 3
 * |        |          |4th data byte of CAN Data Frame
 * @var CAN_IF_T::DAT_B1
 * Offset: 0x44, 0xA4  IFn Data B1 Register (Register Map Note 3)
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[7:0]   |Data4     |Data Byte 4
 * |        |          |5th data byte of CAN Data Frame
 * |[15:8]  |Data5     |Data Byte 5
 * |        |          |6th data byte of CAN Data Frame
 * @var CAN_IF_T::DAT_B2
 * Offset: 0x48, 0xA8  IFn Data B2 Register (Register Map Note 3)
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[7:0]   |Data6     |Data Byte 6
 * |        |          |7th data byte of CAN Data Frame.
 * |[15:8]  |Data7     |Data Byte 7
 * |        |          |8th data byte of CAN Data Frame.
 */

    __IO uint32_t CREQ;          /* Offset: 0x20, 0x80  IFn (Register Map Note 2) Command Request Registers          */
    __IO uint32_t CMASK;         /* Offset: 0x24, 0x84  IFn Command Mask Register                                    */
    __IO uint32_t MASK1;         /* Offset: 0x28, 0x88  IFn Mask 1 Register                                          */
    __IO uint32_t MASK2;         /* Offset: 0x2C, 0x8C  IFn Mask 2 Register                                          */
    __IO uint32_t ARB1;          /* Offset: 0x30, 0x90  IFn Arbitration 1 Register                                   */
    __IO uint32_t ARB2;          /* Offset: 0x34, 0x94  IFn Arbitration 2 Register                                   */
    __IO uint32_t MCON;          /* Offset: 0x38, 0x98  IFn Message Control Register                                 */
    __IO uint32_t DAT_A1;        /* Offset: 0x3C, 0x9C  IFn Data A1 Register (Register Map Note 3)                   */
    __IO uint32_t DAT_A2;        /* Offset: 0x40, 0xA0  IFn Data A2 Register (Register Map Note 3)                   */
    __IO uint32_t DAT_B1;        /* Offset: 0x44, 0xA4  IFn Data B1 Register (Register Map Note 3)                   */
    __IO uint32_t DAT_B2;        /* Offset: 0x48, 0xA8  IFn Data B2 Register (Register Map Note 3)                   */
    __I  uint32_t RESERVE0[13];

} CAN_IF_T;




typedef struct
{



/**
 * @var CAN_T::CON
 * Offset: 0x00  Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |Init      |Init Initialization
 * |        |          |0 = Normal Operation.
 * |        |          |1 = Initialization is started.
 * |[1]     |IE        |Module Interrupt Enable Control
 * |        |          |0 = Disabled.
 * |        |          |1 = Enabled.
 * |[2]     |SIE       |Status Change Interrupt Enable Control
 * |        |          |0 = Disabled - No Status Change Interrupt will be generated.
 * |        |          |1 = Enabled - An interrupt will be generated when a message transfer is successfully completed or a CAN bus error is detected.
 * |[3]     |EIE       |Error Interrupt Enable Control
 * |        |          |0 = Disabled - No Error Status Interrupt will be generated.
 * |        |          |1 = Enabled - A change in the bits BOff (CAN_STATUS[7]) or EWarn (CAN_STATUS[6]) in the Status Register will generate an interrupt.
 * |[5]     |DAR       |Automatic Re-Transmission Disable Control
 * |        |          |0 = Automatic Retransmission of disturbed messages enabled.
 * |        |          |1 = Automatic Retransmission disabled.
 * |[6]     |CCE       |Configuration Change Enable Control
 * |        |          |0 = No write access to the Bit Timing Register.
 * |        |          |1 = Write access to the Bit Timing Register (CAN_BTIME) allowed. (while Init bit (CAN_CON[0]) = 1).
 * |[7]     |Test      |Test Mode Enable Control
 * |        |          |0 = Normal Operation.
 * |        |          |1 = Test Mode.
 * @var CAN_T::STATUS
 * Offset: 0x04  Status Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[2:0]   |LEC       |Last Error Code (Type Of The Last Error To Occur On The CAN Bus)
 * |        |          |The LEC field holds a code, which indicates the type of the last error to occur on the CAN bus.
 * |        |          |This field will be cleared to '0' when a message has been transferred (reception or transmission) without error.
 * |        |          |The unused code '7' may be written by the CPU to check for updates.
 * |        |          |The following table describes the error code.
 * |[3]     |TxOK      |Transmitted A Message Successfully
 * |        |          |0 = Since this bit was reset by the CPU, no message has been successfully transmitted.
 * |        |          |This bit is never reset by the CAN Core.
 * |        |          |1 = Since this bit was last reset by the CPU, a message has been successfully (error free and acknowledged by at least one other node) transmitted.
 * |[4]     |RxOK      |Received A Message Successfully
 * |        |          |0 = No message has been successfully received since this bit was last reset by the CPU.
 * |        |          |This bit is never reset by the CAN Core.
 * |        |          |1 = A message has been successfully received since this bit was last reset by the CPU (independent of the result of acceptance filtering).
 * |[5]     |EPass     |Error Passive (Read Only)
 * |        |          |0 = The CAN Core is error active.
 * |        |          |1 = The CAN Core is in the error passive state as defined in the CAN Specification.
 * |[6]     |EWarn     |Error Warning Status (Read Only)
 * |        |          |0 = Both error counters are below the error warning limit of 96.
 * |        |          |1 = At least one of the error counters in the EML has reached the error warning limit of 96.
 * |[7]     |BOff      |Bus-Off Status (Read Only)
 * |        |          |0 = The CAN module is not in bus-off state.
 * |        |          |1 = The CAN module is in bus-off state.
 * @var CAN_T::ERR
 * Offset: 0x08  Error Counter Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[7:0]   |TEC       |Transmit Error Counter
 * |        |          |Actual state of the Transmit Error Counter. Values between 0 and 255.
 * |[14:8]  |REC       |Receive Error Counter
 * |        |          |Actual state of the Receive Error Counter. Values between 0 and 127.
 * |[15]    |RP        |Receive Error Passive
 * |        |          |0 = The Receive Error Counter is below the error passive level.
 * |        |          |1 = The Receive Error Counter has reached the error passive level as defined in the CAN Specification.
 * @var CAN_T::BTIME
 * Offset: 0x0C  Bit Timing Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[5:0]   |BRP       |Baud Rate Prescaler
 * |        |          |0x01-0x3F: The value by which the oscillator frequency is divided for generating the bit time quanta.
 * |        |          |The bit time is built up from a multiple of this quanta.
 * |        |          |Valid values for the Baud Rate Prescaler are [ 0 ... 63 ].
 * |        |          |The actual interpretation by the hardware of this value is such that one more than the value programmed here is used.
 * |[7:6]   |SJW       |(Re)Synchronization Jump Width
 * |        |          |0x0-0x3: Valid programmed values are [0 ... 3].
 * |        |          |The actual interpretation by the hardware of this value is such that one more than the value programmed here is used.
 * |[11:8]  |TSeg1     |Time Segment Before The Sample Point Minus Sync_Seg
 * |        |          |0x01-0x0F: valid values for TSeg1 are [1 ... 15].
 * |        |          |The actual interpretation by the hardware of this value is such that one more than the value programmed is used.
 * |[14:12] |TSeg2     |Time Segment After Sample Point
 * |        |          |0x0-0x7: Valid values for TSeg2 are [0 ... 7].
 * |        |          |The actual interpretation by the hardware of this value is such that one more than the value programmed here is used.
 * @var CAN_T::IIDR
 * Offset: 0x10  Interrupt Identifier Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |IntId     |Interrupt Identifier (Indicates The Source Of The Interrupt)
 * |        |          |If several interrupts are pending, the CAN Interrupt Register will point to the pending interrupt with the highest priority, disregarding their chronological order.
 * |        |          |An interrupt remains pending until the application software has cleared it.
 * |        |          |If IntId is different from 0x0000 and IE (CAN_IFn_MCON[1]) is set, the IRQ interrupt signal to the EIC is active.
 * |        |          |The interrupt remains active until IntId is back to value 0x0000 (the cause of the interrupt is reset) or until IE is reset.
 * |        |          |The Status Interrupt has the highest priority.
 * |        |          |Among the message interrupts, the Message Object' s interrupt priority decreases with increasing message number.
 * |        |          |A message interrupt is cleared by clearing the Message Object's IntPnd bit (CAN_IFn_MCON[13]).
 * |        |          |The Status Interrupt is cleared by reading the Status Register.
 * @var CAN_T::TEST
 * Offset: 0x14  Test Register (Register Map Note 1)
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[1:0]   |Res       |Reserved
 * |        |          |There are reserved bits.
 * |        |          |These bits are always read as '0' and must always be written with '0'.
 * |[2]     |Basic     |Basic Mode
 * |        |          |0 = Basic Mode disabled.
 * |        |          |1= IF1 Registers used as Tx Buffer, IF2 Registers used as Rx Buffer.
 * |[3]     |Silent    |Silent Mode
 * |        |          |0 = Normal operation.
 * |        |          |1 = The module is in Silent Mode.
 * |[4]     |LBack     |Loop Back Mode Enable Control
 * |        |          |0 = Loop Back Mode is disabled.
 * |        |          |1 = Loop Back Mode is enabled.
 * |[6:5]   |Tx10      |Tx[1:0]: Control Of CAN_TX Pin
 * |        |          |00 = Reset value, CAN_TX pin is controlled by the CAN Core.
 * |        |          |01 = Sample Point can be monitored at CAN_TX pin.
 * |        |          |10 = CAN_TX pin drives a dominant ('0') value.
 * |        |          |11 = CAN_TX pin drives a recessive ('1') value.
 * |[7]     |Rx        |Monitors The Actual Value Of CAN_RX Pin (Read Only)
 * |        |          |0 = The CAN bus is dominant (CAN_RX = '0').
 * |        |          |1 = The CAN bus is recessive (CAN_RX = '1').
 * @var CAN_T::BRPE
 * Offset: 0x18  Baud Rate Prescaler Extension Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[3:0]   |BRPE      |BRPE: Baud Rate Prescaler Extension
 * |        |          |0x00-0x0F: By programming BRPE, the Baud Rate Prescaler can be extended to values up to 1023.
 * |        |          |The actual interpretation by the hardware is that one more than the value programmed by BRPE (MSBs) and BTIME (LSBs) is used.
 * @var CAN_T::IF
 * Offset: 0x20~0xFC  CAN Interface Registers
 * ---------------------------------------------------------------------------------------------------
 * CAN interface structure. Refer to \ref CAN_IF_T for detail information.
     *
 * @var CAN_T::TXREQ1
 * Offset: 0x100  Transmission Request Register 1
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |TxRqst[16:1]|Transmission Request Bits 16-1 (Of All Message Objects)
 * |        |          |0 = This Message Object is not waiting for transmission.
 * |        |          |1 = The transmission of this Message Object is requested and is not yet done.
 * |        |          |These bits are read only.
 * @var CAN_T::TXREQ2
 * Offset: 0x104  Transmission Request Register 2
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |TxRqst[32:17]|Transmission Request Bits 32-17 (Of All Message Objects)
 * |        |          |0 = This Message Object is not waiting for transmission.
 * |        |          |1 = The transmission of this Message Object is requested and is not yet done.
 * |        |          |These bits are read only.
 * @var CAN_T::NDAT1
 * Offset: 0x120  New Data Register 1
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |NewData[16:1]|New Data Bits 16-1 (Of All Message Objects)
 * |        |          |0 = No new data has been written into the data portion of this Message Object by the Message Handler since the last time this flag was cleared by the application software.
 * |        |          |1 = The Message Handler or the application software has written new data into the data portion of this Message Object.
 * @var CAN_T::NDAT2
 * Offset: 0x124  New Data Register 2
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |NewData[32:17]|New Data Bits 32-17 (Of All Message Objects)
 * |        |          |0 = No new data has been written into the data portion of this Message Object by the Message Handler since the last time this flag was cleared by the application software.
 * |        |          |1 = The Message Handler or the application software has written new data into the data portion of this Message Object.
 * @var CAN_T::IPND1
 * Offset: 0x140  Interrupt Pending Register 1
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |IntPnd[16:1]|Interrupt Pending Bits 16-1 (Of All Message Objects)
 * |        |          |0 = This message object is not the source of an interrupt.
 * |        |          |1 = This message object is the source of an interrupt.
 * @var CAN_T::IPND2
 * Offset: 0x144  Interrupt Pending Register 2
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |IntPnd[32:17]|Interrupt Pending Bits 32-17(Of All Message Objects)
 * |        |          |0 = This message object is not the source of an interrupt.
 * |        |          |1 = This message object is the source of an interrupt.
 * @var CAN_T::MVLD1
 * Offset: 0x160  Message Valid Register 1
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |MsgVal[16:1]|Message Valid Bits 16-1 (Of All Message Objects) (Read Only)
 * |        |          |0 = This Message Object is ignored by the Message Handler.
 * |        |          |1 = This Message Object is configured and should be considered by the Message Handler.
 * |        |          |Ex.
 * |        |          |CAN_MVLD1[0] means Message object No.1 is valid or not.
 * |        |          |If CAN_MVLD1[0] is set, message object No.1 is configured.
 * @var CAN_T::MVLD2
 * Offset: 0x164  Message Valid Register 2
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |MsgVal[32:17]|Message Valid Bits 32-17 (Of All Message Objects) (Read Only)
 * |        |          |0 = This Message Object is ignored by the Message Handler.
 * |        |          |1 = This Message Object is configured and should be considered by the Message Handler.
 * |        |          |Ex.CAN_MVLD2[15] means Message object No.32 is valid or not.
 * |        |          |If CAN_MVLD2[15] is set, message object No.32 is configured.
 * @var CAN_T::WU_EN
 * Offset: 0x168  Wake-up Enable Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |WAKUP_EN  |Wake-Up Enable Control
 * |        |          |0 = The wake-up function Disabled.
 * |        |          |1 = The wake-up function Enabled.
 * |        |          |Note: User can wake-up system when there is a falling edge in the CAN_Rx pin.
 * @var CAN_T::WU_STATUS
 * Offset: 0x16C  Wake-up Status Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |WAKUP_STS |Wake-Up Status
 * |        |          |0 = No wake-up event occurred.
 * |        |          |1 = Wake-up event occurred.
 * |        |          |Note: This bit can be cleared by writing '0'.
 */

    __IO uint32_t CON;           /* Offset: 0x00  Control Register                                                   */
    __IO uint32_t STATUS;        /* Offset: 0x04  Status Register                                                    */
    __I  uint32_t ERR;           /* Offset: 0x08  Error Counter Register                                             */
    __IO uint32_t BTIME;         /* Offset: 0x0C  Bit Timing Register                                                */
    __I  uint32_t IIDR;          /* Offset: 0x10  Interrupt Identifier Register                                      */
    __IO uint32_t TEST;          /* Offset: 0x14  Test Register (Register Map Note 1)                                */
    __IO uint32_t BRPE;          /* Offset: 0x18  Baud Rate Prescaler Extension Register                             */
    __I  uint32_t RESERVE0[1];  
    __IO CAN_IF_T IF[2];         /* Offset: 0x20~0xFC  CAN Interface Registers                                       */
    __I  uint32_t RESERVE1[8];  
    __I  uint32_t TXREQ1;        /* Offset: 0x100  Transmission Request Register 1                                   */
    __I  uint32_t TXREQ2;        /* Offset: 0x104  Transmission Request Register 2                                   */
    __I  uint32_t RESERVE3[6];  
    __I  uint32_t NDAT1;         /* Offset: 0x120  New Data Register 1                                               */
    __I  uint32_t NDAT2;         /* Offset: 0x124  New Data Register 2                                               */
    __I  uint32_t RESERVE4[6];  
    __I  uint32_t IPND1;         /* Offset: 0x140  Interrupt Pending Register 1                                      */
    __I  uint32_t IPND2;         /* Offset: 0x144  Interrupt Pending Register 2                                      */
    __I  uint32_t RESERVE5[6];  
    __I  uint32_t MVLD1;         /* Offset: 0x160  Message Valid Register 1                                          */
    __I  uint32_t MVLD2;         /* Offset: 0x164  Message Valid Register 2                                          */
    __IO uint32_t WU_EN;         /* Offset: 0x168  Wake-up Enable Register                                           */
    __IO uint32_t WU_STATUS;     /* Offset: 0x16C  Wake-up Status Register                                           */

} CAN_T;



/**
    @addtogroup CAN_CONST CAN Bit Field Definition
    Constant Definitions for CAN Controller
@{ */
/* CAN CON Bit Field Definitions */
#define CAN_CON_TEST_Pos           7                                    /*!< CAN_T::CON: TEST Position */
#define CAN_CON_TEST_Msk           (0x1ul << CAN_CON_TEST_Pos)          /*!< CAN_T::CON: TEST Mask     */
                                                                                
#define CAN_CON_CCE_Pos            6                                    /*!< CAN_T::CON: CCE Position  */
#define CAN_CON_CCE_Msk            (0x1ul << CAN_CON_CCE_Pos)           /*!< CAN_T::CON: CCE Mask      */
                                                             
#define CAN_CON_DAR_Pos            5                                    /*!< CAN_T::CON: DAR Position  */
#define CAN_CON_DAR_Msk            (0x1ul << CAN_CON_DAR_Pos)           /*!< CAN_T::CON: DAR Mask      */
                                                             
#define CAN_CON_EIE_Pos            3                                    /*!< CAN_T::CON: EIE Position  */
#define CAN_CON_EIE_Msk            (0x1ul << CAN_CON_EIE_Pos)           /*!< CAN_T::CON: EIE Mask      */
                                                             
#define CAN_CON_SIE_Pos            2                                    /*!< CAN_T::CON: SIE Position  */
#define CAN_CON_SIE_Msk            (0x1ul << CAN_CON_SIE_Pos)           /*!< CAN_T::CON: SIE Mask      */
                                                             
#define CAN_CON_IE_Pos             1                                    /*!< CAN_T::CON: IE Position   */
#define CAN_CON_IE_Msk             (0x1ul << CAN_CON_IE_Pos)            /*!< CAN_T::CON: IE Mask       */
                                                             
#define CAN_CON_INIT_Pos           0                                    /*!< CAN_T::CON: INIT Position */
#define CAN_CON_INIT_Msk           (0x1ul << CAN_CON_INIT_Pos)          /*!< CAN_T::CON: INIT Mask     */

/* CAN STATUS Bit Field Definitions */
#define CAN_STATUS_BOFF_Pos        7                                    /*!< CAN_T::STATUS: BOFF Position  */
#define CAN_STATUS_BOFF_Msk        (0x1ul << CAN_STATUS_BOFF_Pos)       /*!< CAN_T::STATUS: BOFF Mask      */

#define CAN_STATUS_EWARN_Pos       6                                    /*!< CAN_T::STATUS: EWARN Position */
#define CAN_STATUS_EWARN_Msk       (0x1ul << CAN_STATUS_EWARN_Pos)      /*!< CAN_T::STATUS: EWARN Mask     */

#define CAN_STATUS_EPASS_Pos       5                                    /*!< CAN_T::STATUS: EPASS Position */
#define CAN_STATUS_EPASS_Msk       (0x1ul << CAN_STATUS_EPASS_Pos)      /*!< CAN_T::STATUS: EPASS Mask     */

#define CAN_STATUS_RXOK_Pos        4                                    /*!< CAN_T::STATUS: RXOK Position  */
#define CAN_STATUS_RXOK_Msk        (0x1ul << CAN_STATUS_RXOK_Pos)       /*!< CAN_T::STATUS: RXOK Mask      */

#define CAN_STATUS_TXOK_Pos        3                                    /*!< CAN_T::STATUS: TXOK Position  */
#define CAN_STATUS_TXOK_Msk        (0x1ul << CAN_STATUS_TXOK_Pos)       /*!< CAN_T::STATUS: TXOK Mask      */

#define CAN_STATUS_LEC_Pos         0                                    /*!< CAN_T::STATUS: LEC Position   */
#define CAN_STATUS_LEC_Msk         (0x7ul << CAN_STATUS_LEC_Pos)        /*!< CAN_T::STATUS: LEC Mask       */

/* CAN ERR Bit Field Definitions */                                             
#define CAN_ERR_RP_Pos             15                                   /*!< CAN_T::ERR: RP Position       */
#define CAN_ERR_RP_Msk             (0x1ul << CAN_ERR_RP_Pos)            /*!< CAN_T::ERR: RP Mask           */

#define CAN_ERR_REC_Pos            8                                    /*!< CAN_T::ERR: REC Position      */
#define CAN_ERR_REC_Msk            (0x7Ful << CAN_ERR_REC_Pos)          /*!< CAN_T::ERR: REC Mask          */

#define CAN_ERR_TEC_Pos            0                                    /*!< CAN_T::ERR: TEC Position      */
#define CAN_ERR_TEC_Msk            (0xFFul << CAN_ERR_TEC_Pos)          /*!< CAN_T::ERR: TEC Mask          */

/* CAN BTIME Bit Field Definitions */                                           
#define CAN_BTIME_TSEG2_Pos        12                                   /*!< CAN_T::BTIME: TSEG2 Position  */
#define CAN_BTIME_TSEG2_Msk        (0x7ul << CAN_BTIME_TSEG2_Pos)       /*!< CAN_T::BTIME: TSEG2 Mask      */

#define CAN_BTIME_TSEG1_Pos        8                                    /*!< CAN_T::BTIME: TSEG1 Position  */
#define CAN_BTIME_TSEG1_Msk        (0xFul << CAN_BTIME_TSEG1_Pos)       /*!< CAN_T::BTIME: TSEG1 Mask      */

#define CAN_BTIME_SJW_Pos          6                                    /*!< CAN_T::BTIME: SJW Position    */
#define CAN_BTIME_SJW_Msk          (0x3ul << CAN_BTIME_SJW_Pos)         /*!< CAN_T::BTIME: SJW Mask        */

#define CAN_BTIME_BRP_Pos          0                                    /*!< CAN_T::BTIME: BRP Position    */
#define CAN_BTIME_BRP_Msk          (0x3Ful << CAN_BTIME_BRP_Pos)        /*!< CAN_T::BTIME: BRP Mask        */

/* CAN IIDR Bit Field Definitions */                                            
#define CAN_IIDR_INTID_Pos         0                                    /*!< CAN_T::IIDR: INTID Position   */
#define CAN_IIDR_INTID_Msk         (0xFFFFul << CAN_IIDR_INTID_Pos)     /*!< CAN_T::IIDR: INTID Mask       */

/* CAN TEST Bit Field Definitions */                                            
#define CAN_TEST_RX_Pos            7                                    /*!< CAN_T::TEST: RX Position      */
#define CAN_TEST_RX_Msk            (0x1ul << CAN_TEST_RX_Pos)           /*!< CAN_T::TEST: RX Mask          */

#define CAN_TEST_TX_Pos            5                                    /*!< CAN_T::TEST: TX Position      */
#define CAN_TEST_TX_Msk            (0x3ul << CAN_TEST_TX_Pos)           /*!< CAN_T::TEST: TX Mask          */

#define CAN_TEST_LBACK_Pos         4                                    /*!< CAN_T::TEST: LBACK Position   */
#define CAN_TEST_LBACK_Msk         (0x1ul << CAN_TEST_LBACK_Pos)        /*!< CAN_T::TEST: LBACK Mask       */

#define CAN_TEST_SILENT_Pos        3                                    /*!< CAN_T::TEST: Silent Position  */
#define CAN_TEST_SILENT_Msk        (0x1ul << CAN_TEST_SILENT_Pos)       /*!< CAN_T::TEST: Silent Mask      */

#define CAN_TEST_BASIC_Pos         2                                    /*!< CAN_T::TEST: Basic Position   */
#define CAN_TEST_BASIC_Msk         (0x1ul << CAN_TEST_BASIC_Pos)        /*!< CAN_T::TEST: Basic Mask       */

/* CAN BPRE Bit Field Definitions */                                           
#define CAN_BRPE_BRPE_Pos          0                                    /*!< CAN_T::BRPE: BRPE Position    */
#define CAN_BRPE_BRPE_Msk          (0xFul << CAN_BRPE_BRPE_Pos)         /*!< CAN_T::BRPE: BRPE Mask        */

/* CAN IFn_CREQ Bit Field Definitions */
#define CAN_IF_CREQ_BUSY_Pos       15                                     /*!< CAN_IF_T::CREQ: BUSY Position */
#define CAN_IF_CREQ_BUSY_Msk       (0x1ul << CAN_IF_CREQ_BUSY_Pos)        /*!< CAN_IF_T::CREQ: BUSY Mask     */
                                                                                  
#define CAN_IF_CREQ_MSGNUM_Pos     0                                      /*!< CAN_IF_T::CREQ: MSGNUM Position */
#define CAN_IF_CREQ_MSGNUM_Msk     (0x3Ful << CAN_IF_CREQ_MSGNUM_Pos)     /*!< CAN_IF_T::CREQ: MSGNUM Mask     */
                                                                                  
/* CAN IFn_CMASK Bit Field Definitions */                                         
#define CAN_IF_CMASK_WRRD_Pos      7                                      /*!< CAN_IF_T::CMASK: WRRD Position */
#define CAN_IF_CMASK_WRRD_Msk      (0x1ul << CAN_IF_CMASK_WRRD_Pos)       /*!< CAN_IF_T::CMASK: WRRD Mask     */
                                                                                  
#define CAN_IF_CMASK_MASK_Pos      6                                      /*!< CAN_IF_T::CMASK: MASK Position */
#define CAN_IF_CMASK_MASK_Msk      (0x1ul << CAN_IF_CMASK_MASK_Pos)       /*!< CAN_IF_T::CMASK: MASK Mask     */
                                                                                  
#define CAN_IF_CMASK_ARB_Pos       5                                      /*!< CAN_IF_T::CMASK: ARB Position  */
#define CAN_IF_CMASK_ARB_Msk       (0x1ul << CAN_IF_CMASK_ARB_Pos)        /*!< CAN_IF_T::CMASK: ARB Mask      */

#define CAN_IF_CMASK_CONTROL_Pos   4                                     /*!< CAN_IF_T::CMASK: CONTROL Position */
#define CAN_IF_CMASK_CONTROL_Msk   (0x1ul << CAN_IF_CMASK_CONTROL_Pos)   /*!< CAN_IF_T::CMASK: CONTROL Mask */

#define CAN_IF_CMASK_CLRINTPND_Pos 3                                       /*!< CAN_IF_T::CMASK: CLRINTPND Position */
#define CAN_IF_CMASK_CLRINTPND_Msk (0x1ul << CAN_IF_CMASK_CLRINTPND_Pos)   /*!< CAN_IF_T::CMASK: CLRINTPND Mask */

#define CAN_IF_CMASK_TXRQSTNEWDAT_Pos 2                                         /*!< CAN_IF_T::CMASK: TXRQSTNEWDAT Position */
#define CAN_IF_CMASK_TXRQSTNEWDAT_Msk (0x1ul << CAN_IF_CMASK_TXRQSTNEWDAT_Pos)  /*!< CAN_IF_T::CMASK: TXRQSTNEWDAT Mask     */

#define CAN_IF_CMASK_DATAA_Pos     1                                    /*!< CAN_IF_T::CMASK: DATAA Position */
#define CAN_IF_CMASK_DATAA_Msk     (0x1ul << CAN_IF_CMASK_DATAA_Pos)    /*!< CAN_IF_T::CMASK: DATAA Mask     */

#define CAN_IF_CMASK_DATAB_Pos     0                                    /*!< CAN_IF_T::CMASK: DATAB Position */
#define CAN_IF_CMASK_DATAB_Msk     (0x1ul << CAN_IF_CMASK_DATAB_Pos)    /*!< CAN_IF_T::CMASK: DATAB Mask     */

/* CAN IFn_MASK1 Bit Field Definitions */
#define CAN_IF_MASK1_MSK_Pos       0                                    /*!< CAN_IF_T::MASK1: MSK Position   */
#define CAN_IF_MASK1_MSK_Msk       (0xFFul << CAN_IF_MASK1_MSK_Pos)     /*!< CAN_IF_T::MASK1: MSK Mask       */

/* CAN IFn_MASK2 Bit Field Definitions */                                       
#define CAN_IF_MASK2_MXTD_Pos      15                                   /*!< CAN_IF_T::MASK2: MXTD Position */
#define CAN_IF_MASK2_MXTD_Msk      (0x1ul << CAN_IF_MASK2_MXTD_Pos)     /*!< CAN_IF_T::MASK2: MXTD Mask     */

#define CAN_IF_MASK2_MDIR_Pos      14                                   /*!< CAN_IF_T::MASK2: MDIR Position */
#define CAN_IF_MASK2_MDIR_Msk      (0x1ul << CAN_IF_MASK2_MDIR_Pos)     /*!< CAN_IF_T::MASK2: MDIR Mask     */

#define CAN_IF_MASK2_MSK_Pos       0                                    /*!< CAN_IF_T::MASK2: MSK Position */
#define CAN_IF_MASK2_MSK_Msk       (0x1FFul << CAN_IF_MASK2_MSK_Pos)    /*!< CAN_IF_T::MASK2: MSK Mask     */

/* CAN IFn_ARB1 Bit Field Definitions */                                        
#define CAN_IF_ARB1_ID_Pos         0                                    /*!< CAN_IF_T::ARB1: ID Position   */
#define CAN_IF_ARB1_ID_Msk         (0xFFFFul << CAN_IF_ARB1_ID_Pos)     /*!< CAN_IF_T::ARB1: ID Mask       */

/* CAN IFn_ARB2 Bit Field Definitions */                                        
#define CAN_IF_ARB2_MSGVAL_Pos     15                                   /*!< CAN_IF_T::ARB2: MSGVAL Position */
#define CAN_IF_ARB2_MSGVAL_Msk     (0x1ul << CAN_IF_ARB2_MSGVAL_Pos)    /*!< CAN_IF_T::ARB2: MSGVAL Mask     */

#define CAN_IF_ARB2_XTD_Pos        14                                   /*!< CAN_IF_T::ARB2: XTD Position    */
#define CAN_IF_ARB2_XTD_Msk        (0x1ul << CAN_IF_ARB2_XTD_Pos)       /*!< CAN_IF_T::ARB2: XTD Mask        */

#define CAN_IF_ARB2_DIR_Pos        13                                   /*!< CAN_IF_T::ARB2: DIR Position    */
#define CAN_IF_ARB2_DIR_Msk        (0x1ul << CAN_IF_ARB2_DIR_Pos)       /*!< CAN_IF_T::ARB2: DIR Mask        */

#define CAN_IF_ARB2_ID_Pos         0                                    /*!< CAN_IF_T::ARB2: ID Position     */
#define CAN_IF_ARB2_ID_Msk         (0x1FFFul << CAN_IF_ARB2_ID_Pos)     /*!< CAN_IF_T::ARB2: ID Mask         */

/* CAN IFn_MCON Bit Field Definitions */                                        
#define CAN_IF_MCON_NEWDAT_Pos     15                                   /*!< CAN_IF_T::MCON: NEWDAT Position */
#define CAN_IF_MCON_NEWDAT_Msk     (0x1ul << CAN_IF_MCON_NEWDAT_Pos)    /*!< CAN_IF_T::MCON: NEWDAT Mask     */

#define CAN_IF_MCON_MSGLST_Pos     14                                   /*!< CAN_IF_T::MCON: MSGLST Position */
#define CAN_IF_MCON_MSGLST_Msk     (0x1ul << CAN_IF_MCON_MSGLST_Pos)    /*!< CAN_IF_T::MCON: MSGLST Mask     */

#define CAN_IF_MCON_INTPND_Pos     13                                   /*!< CAN_IF_T::MCON: INTPND Position */
#define CAN_IF_MCON_INTPND_Msk     (0x1ul << CAN_IF_MCON_INTPND_Pos)    /*!< CAN_IF_T::MCON: INTPND Mask     */

#define CAN_IF_MCON_UMASK_Pos      12                                   /*!< CAN_IF_T::MCON: UMASK Position  */
#define CAN_IF_MCON_UMASK_Msk      (0x1ul << CAN_IF_MCON_UMASK_Pos)     /*!< CAN_IF_T::MCON: UMASK Mask      */

#define CAN_IF_MCON_TXIE_Pos       11                                   /*!< CAN_IF_T::MCON: TXIE Position   */
#define CAN_IF_MCON_TXIE_Msk       (0x1ul << CAN_IF_MCON_TXIE_Pos)      /*!< CAN_IF_T::MCON: TXIE Mask       */

#define CAN_IF_MCON_RXIE_Pos       10                                   /*!< CAN_IF_T::MCON: RXIE Position   */
#define CAN_IF_MCON_RXIE_Msk       (0x1ul << CAN_IF_MCON_RXIE_Pos)      /*!< CAN_IF_T::MCON: RXIE Mask       */

#define CAN_IF_MCON_RMTEN_Pos      9                                    /*!< CAN_IF_T::MCON: RMTEN Position  */
#define CAN_IF_MCON_RMTEN_Msk      (0x1ul << CAN_IF_MCON_RMTEN_Pos)     /*!< CAN_IF_T::MCON: RMTEN Mask      */

#define CAN_IF_MCON_TXRQST_Pos     8                                    /*!< CAN_IF_T::MCON: TXRQST Position */
#define CAN_IF_MCON_TXRQST_Msk     (0x1ul << CAN_IF_MCON_TXRQST_Pos)    /*!< CAN_IF_T::MCON: TXRQST Mask     */

#define CAN_IF_MCON_EOB_Pos        7                                    /*!< CAN_IF_T::MCON: EOB Position    */
#define CAN_IF_MCON_EOB_Msk        (0x1ul << CAN_IF_MCON_EOB_Pos)       /*!< CAN_IF_T::MCON: EOB Mask        */

#define CAN_IF_MCON_DLC_Pos        0                                    /*!< CAN_IF_T::MCON: DLC Position    */
#define CAN_IF_MCON_DLC_Msk        (0xFul << CAN_IF_MCON_DLC_Pos)       /*!< CAN_IF_T::MCON: DLC Mask        */

/* CAN IFn_DATA_A1 Bit Field Definitions */                                     
#define CAN_IF_DAT_A1_DATA1_Pos    8                                    /*!< CAN_IF_T::DATAA1: DATA1 Position */
#define CAN_IF_DAT_A1_DATA1_Msk    (0xFFul << CAN_IF_DAT_A1_DATA1_Pos)  /*!< CAN_IF_T::DATAA1: DATA1 Mask     */

#define CAN_IF_DAT_A1_DATA0_Pos    0                                    /*!< CAN_IF_T::DATAA1: DATA0 Position */
#define CAN_IF_DAT_A1_DATA0_Msk    (0xFFul << CAN_IF_DAT_A1_DATA0_Pos)  /*!< CAN_IF_T::DATAA1: DATA0 Mask     */

/* CAN IFn_DATA_A2 Bit Field Definitions */                                     
#define CAN_IF_DAT_A2_DATA3_Pos    8                                    /*!< CAN_IF_T::DATAA1: DATA3 Position */
#define CAN_IF_DAT_A2_DATA3_Msk    (0xFFul << CAN_IF_DAT_A2_DATA3_Pos)  /*!< CAN_IF_T::DATAA1: DATA3 Mask     */

#define CAN_IF_DAT_A2_DATA2_Pos    0                                    /*!< CAN_IF_T::DATAA1: DATA2 Position */
#define CAN_IF_DAT_A2_DATA2_Msk    (0xFFul << CAN_IF_DAT_A2_DATA2_Pos)  /*!< CAN_IF_T::DATAA1: DATA2 Mask     */

/* CAN IFn_DATA_B1 Bit Field Definitions */                                     
#define CAN_IF_DAT_B1_DATA5_Pos    8                                    /*!< CAN_IF_T::DATAB1: DATA5 Position */
#define CAN_IF_DAT_B1_DATA5_Msk    (0xFFul << CAN_IF_DAT_B1_DATA5_Pos)  /*!< CAN_IF_T::DATAB1: DATA5 Mask */

#define CAN_IF_DAT_B1_DATA4_Pos    0                                    /*!< CAN_IF_T::DATAB1: DATA4 Position */
#define CAN_IF_DAT_B1_DATA4_Msk    (0xFFul << CAN_IF_DAT_B1_DATA4_Pos)  /*!< CAN_IF_T::DATAB1: DATA4 Mask */

/* CAN IFn_DATA_B2 Bit Field Definitions */                                     
#define CAN_IF_DAT_B2_DATA7_Pos    8                                    /*!< CAN_IF_T::DATAB2: DATA7 Position */
#define CAN_IF_DAT_B2_DATA7_Msk    (0xFFul << CAN_IF_DAT_B2_DATA7_Pos)  /*!< CAN_IF_T::DATAB2: DATA7 Mask     */

#define CAN_IF_DAT_B2_DATA6_Pos    0                                    /*!< CAN_IF_T::DATAB2: DATA6 Position */
#define CAN_IF_DAT_B2_DATA6_Msk    (0xFFul << CAN_IF_DAT_B2_DATA6_Pos)  /*!< CAN_IF_T::DATAB2: DATA6 Mask     */

/* CAN IFn_TXRQST1 Bit Field Definitions */
#define CAN_TXRQST1_TXRQST_Pos  0                                        /*!< CAN_T::TXRQST1: TXRQST Position */
#define CAN_TXRQST1_TXRQST_Msk  (0xFFFFul << CAN_TXRQST1_TXRQST_Pos)  /*!< CAN_T::TXRQST1: TXRQST Mask     */

/* CAN IFn_TXRQST2 Bit Field Definitions */                                         
#define CAN_TXRQST2_TXRQST_Pos  0                                        /*!< CAN_T::TXRQST2: TXRQST Position  */
#define CAN_TXRQST2_TXRQST_Msk  (0xFFFFul << CAN_TXRQST2_TXRQST_Pos)  /*!< CAN_T::TXRQST2: TXRQST Mask      */

/* CAN IFn_NDAT1 Bit Field Definitions */                                           
#define CAN_NDAT1_NEWDATA_Pos   0                                        /*!< CAN_T::NDAT1: NEWDATA Position */
#define CAN_NDAT1_NEWDATA_Msk   (0xFFFFul << CAN_NDAT1_NEWDATA_Pos)   /*!< CAN_T::NDAT1: NEWDATA Mask     */

/* CAN IFn_NDAT2 Bit Field Definitions */                                          
#define CAN_NDAT2_NEWDATA_Pos   0                                        /*!< CAN_T::NDAT2: NEWDATA Position */
#define CAN_NDAT2_NEWDATA_Msk   (0xFFFFul << CAN_NDAT2_NEWDATA_Pos)   /*!< CAN_T::NDAT2: NEWDATA Mask     */

/* CAN IFn_IPND1 Bit Field Definitions */                                          
#define CAN_IPND1_INTPND_Pos   0                                         /*!< CAN_T::IPND1: INTPND Position */
#define CAN_IPND1_INTPND_Msk   (0xFFFFul << CAN_IPND1_INTPND_Pos)     /*!< CAN_T::IPND1: INTPND Mask     */

/* CAN IFn_IPND2 Bit Field Definitions */                                          
#define CAN_IPND2_INTPND_Pos   0                                         /*!< CAN_T::IPND2: INTPND Position */
#define CAN_IPND2_INTPND_Msk   (0xFFFFul << CAN_IPND2_INTPND_Pos)     /*!< CAN_T::IPND2: INTPND Mask     */

/* CAN IFn_MVLD1 Bit Field Definitions */                                          
#define CAN_MVLD1_MSGVAL_Pos   0                                         /*!< CAN_T::MVLD1: MSGVAL Position */
#define CAN_MVLD1_MSGVAL_Msk   (0xFFFFul << CAN_MVLD1_MSGVAL_Pos)     /*!< CAN_T::MVLD1: MSGVAL Mask     */

/* CAN IFn_MVLD2 Bit Field Definitions */                                           
#define CAN_MVLD2_MSGVAL_Pos   0                                         /*!< CAN_T::MVLD2: MSGVAL Position */
#define CAN_MVLD2_MSGVAL_Msk   (0xFFFFul << CAN_MVLD2_MSGVAL_Pos)     /*!< CAN_T::MVLD2: MSGVAL Mask     */

/* CAN WUEN Bit Field Definitions */                                                
#define CAN_WUEN_WAKUP_EN_Pos     0                                         /*!< CAN_T::WU_EN: WAKUP_EN Position */
#define CAN_WUEN_WAKUP_EN_Msk    (0x1ul << CAN_WUEN_WAKUP_EN_Pos)           /*!< CAN_T::WU_EN: WAKUP_EN Mask     */

/* CAN WUSTATUS Bit Field Definitions */
#define CAN_WUSTATUS_WAKUP_STS_Pos     0                                      /*!< CAN_T::WU_STATUS: WAKUP_STS Position */
#define CAN_WUSTATUS_WAKUP_STS_Msk    (0x1ul << CAN_WUSTATUS_WAKUP_STS_Pos)   /*!< CAN_T::WU_STATUS: WAKUP_STS Mask     */


/**@}*/ /* CAN_CONST */
/**@}*/ /* end of CAN register group */


/*---------------------- System Clock Controller -------------------------*/
/**
    @addtogroup CLK System Clock Controller(CLK)
    Memory Mapped Structure for CLK Controller
@{ */


typedef struct
{




/**
 * @var CLK_T::PWRCTL
 * Offset: 0x00  System Power-down Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |HXTEN     |External 4~24 MHz High-Speed Crystal Enable Bit (Write Protect)
 * |        |          |The bit default value is set by flash controller user configuration register CONFIG0 [26:24].
 * |        |          |When the default clock source is from external 4~24 MHz high-speed crystal, this bit is set to 1 automatically.
 * |        |          |0 = External 4 ~ 24 MHz high speed crystal oscillator (HXT) Disabled.
 * |        |          |1 = External 4 MH~ 24 z high speed crystal oscillator (HXT) Enabled.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.
 * |[1]     |LXTEN     |External 32.768 KHz Low-Speed Crystal Enable Bit (Write Protect)
 * |        |          |0 = External 32.768 kHz low-speed crystal oscillator (LXT) Disabled.
 * |        |          |1 = External 32.768 kHz low-speed crystal oscillator (LXT) Enabled.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.
 * |[2]     |HIRCEN    |Internal 22.1184 MHz High-Speed Oscillator Enable Bit (Write Protect)
 * |        |          |0 = Internal 22.1184 MHz high-speed RC oscillator (HIRC) Disabled.
 * |        |          |1 = Internal 22.1184 MHz high-speed RC oscillator (HIRC) Enabled.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.
 * |[3]     |LIRCEN    |Internal 10 KHz Low-Speed Oscillator Enable Bit (Write Protect)
 * |        |          |0 = Internal 10 kHz low speed RC oscillator (LIRC) Disabled.
 * |        |          |1 = Internal 10 kHz low speed RC oscillator (LIRC) Enabled.
 * |[4]     |PDWKDLY   |Enable The Wake-Up Delay Counter (Write Protect)
 * |        |          |When the chip wakes up from Power-down mode, the clock control will delay certain clock cycles to wait system clock stable.
 * |        |          |The delayed clock cycle is 4096 clock cycles when chip work at external 4~24 MHz high-speed crystal, and 256 clock cycles when chip work at internal 22.1184 MHz high-speed oscillator.
 * |        |          |0 = Clock cycles delay Disabled.
 * |        |          |1 = Clock cycles delay Enabled.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.
 * |[5]     |PDWKIEN   |Power-Down Mode Wake-Up Interrupt Enable Bit (Write Protect)
 * |        |          |0 = Power-down Mode Wake-up Interrupt Disabled.
 * |        |          |1 = Power-down Mode Wake-up Interrupt Enabled.
 * |        |          |Note1: The interrupt will occur when both PDWKIF and PDWKIEN are high.
 * |        |          |Note2: This bit is write protected. Refer to the SYS_REGLCTL register.
 * |[6]     |PDWKIF    |Power-Down Mode Wake-Up Interrupt Status
 * |        |          |Set by "Power-down wake-up event", it indicates that resume from Power-down mode
 * |        |          |The flag is set if the EINT0~5, GPIO, USBH, USBD, OTG, UART0~3, WDT, CAN0, ACMP01, BOD, RTC, TMR0~3, I2C0~1 or TK wake-up occurred.
 * |        |          |Note1: Write 1 to clear the bit to 0.
 * |        |          |Note2: This bit works only if PDWKIEN (CLK_PWRCTL[5]) set to 1.
 * |[7]     |PDEN      |System Power-Down Enable (Write Protect)
 * |        |          |When this bit is set to 1, Power-down mode is enabled and chip Power-down behavior will depend on the PDWTCPU bit.
 * |        |          |(a) If the PDWTCPU is 0, then the chip enters Power-down mode immediately after the PDEN bit set.(default)
 * |        |          |(b) if the PDWTCPU is 1, then the chip keeps active till the CPU sleep mode is also active and then the chip enters Power-down mode.
 * |        |          |When chip wakes up from Power-down mode, this bit is auto cleared.
 * |        |          |Users need to set this bit again for next Power-down.
 * |        |          |In Power-down mode, external 4~24 MHz high-speed crystal and the internal 22.1184 MHz high-speed oscillator will be disabled in this mode, but the external 32.768 kHz low-speed crystal and internal 10 kHz low-speed oscillator are not controlled by Power-down mode.
 * |        |          |In Power-down mode, the PLL and system clock are disabled, and ignored the clock source selection.
 * |        |          |The clocks of peripheral are not controlled by Power-down mode, if the peripheral clock source is from external 32.768 kHz low-speed crystal or the internal 10 kHz low-speed oscillator.
 * |        |          |0 = Chip operating normally or chip in idle mode because of WFI command.
 * |        |          |1 = Chip enters Power-down mode instant or wait CPU sleep command WFI.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.
 * |[8]     |PDWTCPU   |This Bit Control The Power-Down Entry Condition (Write Protect)
 * |        |          |0 = Chip enters Power-down mode when the PDEN bit is set to 1.
 * |        |          |1 = Chip enters Power-down mode when the both PDWTCPU and PDEN bits are set to 1 and CPU run WFI instruction.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.
 * |[11:10] |HXTGAIN   |4~24 MHz High-Speed Crystal Gain Control Bit
 * |        |          |(Write Protect)
 * |        |          |This is a protected register. Please refer to open lock sequence to program it.
 * |        |          |Gain control is used to enlarge the gain of crystal to make sure crystal work normally.
 * |        |          |If gain control is enabled, crystal will consume more power than gain control off.
 * |        |          |00 = HXT frequency is lower than from 8 MHz.
 * |        |          |01 = HXT frequency is from 8 MHz to 12 MHz.
 * |        |          |10 = HXT frequency is from 12 MHz to 16 MHz.
 * |        |          |11 = HXT frequency is higher than 16 MHz.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.
 * |[12]    |HXTSELTYP |4~24 MHz High-Speed Crystal Type Select Bit (Write Protect)
 * |        |          |This is a protected register. Please refer to open lock sequence to program it.
 * |        |          |0 = Select INV type.
 * |        |          |1 = Select GM type.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.
 * @var CLK_T::AHBCLK
 * Offset: 0x04  AHB Devices Clock Enable Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[1]     |PDMACKEN  |PDMA Controller Clock Enable Bit
 * |        |          |0 = PDMA peripheral clock Disabled.
 * |        |          |1 = PDMA peripheral clock Enabled.
 * |[2]     |ISPCKEN   |Flash ISP Controller Clock Enable Bit
 * |        |          |0 = Flash ISP peripheral clock Disabled.
 * |        |          |1 = Flash ISP peripheral clock Enabled.
 * |[3]     |EBICKEN   |EBI Controller Clock Enable Bit
 * |        |          |0 = EBI peripheral clock Disabled.
 * |        |          |1 = EBI peripheral clock Enabled.
 * |[4]     |USBHCKEN  |USB HOST Controller Clock Enable Bit
 * |        |          |0 = USB HOST peripheral clock Disabled.
 * |        |          |1 = USB HOST peripheral clock Enabled.
 * |[7]     |CRCCKEN   |CRC Generator Controller Clock Enable Bit
 * |        |          |0 = CRC peripheral clock Disabled.
 * |        |          |1 = CRC peripheral clock Enabled.
 * |[15]    |FMCIDLE   |Flash Memory Controller Clock Enable Bit In IDLE Mode
 * |        |          |0 = FMC peripheral clock Disabled when chip operating at IDLE mode.
 * |        |          |1 = FMC peripheral clock Enabled when chip operating at IDLE mode.
 * @var CLK_T::APBCLK0
 * Offset: 0x08  APB Devices Clock Enable Control Register 0
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |WDTCKEN   |Watchdog Timer Clock Enable Bit (Write Protect)
 * |        |          |0 = Watchdog Timer Clock Disabled.
 * |        |          |1 = Watchdog Timer Clock Enabled.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.
 * |[1]     |RTCCKEN   |Real-Time-Clock APB Interface Clock Enable Bit
 * |        |          |This bit is used to control the RTC APB clock only.
 * |        |          |The RTC peripheral clock source is selected from RTCSEL(CLK_CLKSEL3[8]).
 * |        |          |It can be selected to external 32.768 kHz low speed crystal or internal 10 kHz low speed oscillator.
 * |        |          |0 = RTC Clock Disabled.
 * |        |          |1 = RTC Clock Enabled.
 * |[2]     |TMR0CKEN  |Timer0 Clock Enable Bit
 * |        |          |0 = Timer0 Clock Disabled.
 * |        |          |1 = Timer0 Clock Enabled.
 * |[3]     |TMR1CKEN  |Timer1 Clock Enable Bit
 * |        |          |0 = Timer1 Clock Disabled.
 * |        |          |1 = Timer1 Clock Enabled.
 * |[4]     |TMR2CKEN  |Timer2 Clock Enable Bit
 * |        |          |0 = Timer2 Clock Disabled.
 * |        |          |1 = Timer2 Clock Enabled.
 * |[5]     |TMR3CKEN  |Timer3 Clock Enable Bit
 * |        |          |0 = Timer3 Clock Disabled.
 * |        |          |1 = Timer3 Clock Enabled.
 * |[6]     |CLKOCKEN  |CLKO Clock Enable Bit
 * |        |          |0 = CLKO Clock Disabled.
 * |        |          |1 = CLKO Clock Enabled.
 * |[7]     |ACMP01CKEN|Analog Comparator 0/1 Clock Enable Bit
 * |        |          |0 = Analog Comparator 0/1 Clock Disabled.
 * |        |          |1 = Analog Comparator 0/1 Clock Enabled.
 * |[8]     |I2C0CKEN  |I2C0 Clock Enable Bit
 * |        |          |0 = I2C0 Clock Disabled.
 * |        |          |1 = I2C0 Clock Enabled.
 * |[9]     |I2C1CKEN  |I2C1 Clock Enable Bit
 * |        |          |0 = I2C1 Clock Disabled.
 * |        |          |1 = I2C1 Clock Enabled.
 * |[12]    |SPI0CKEN  |SPI0 Clock Enable Bit
 * |        |          |0 = SPI0 Clock Disabled.
 * |        |          |1 = SPI0 Clock Enabled.
 * |[13]    |SPI1CKEN  |SPI1 Clock Enable Bit
 * |        |          |0 = SPI1 Clock Disabled.
 * |        |          |1 = SPI1 Clock Enabled.
 * |[14]    |SPI2CKEN  |SPI2 Clock Enable Bit
 * |        |          |0 = SPI2 Clock Disabled.
 * |        |          |1 = SPI2 Clock Enabled.
 * |[16]    |UART0CKEN |UART0 Clock Enable Bit
 * |        |          |0 = UART0 clock Disabled.
 * |        |          |1 = UART0 clock Enabled.
 * |[17]    |UART1CKEN |UART1 Clock Enable Bit
 * |        |          |0 = UART1 clock Disabled.
 * |        |          |1 = UART1 clock Enabled.
 * |[18]    |UART2CKEN |UART2 Clock Enable Bit
 * |        |          |0 = UART2 clock Disabled.
 * |        |          |1 = UART2 clock Enabled.
 * |[19]    |UART3CKEN |UART3 Clock Enable Bit
 * |        |          |0 = UART3 clock Disabled.
 * |        |          |1 = UART3 clock Enabled.
 * |[24]    |CAN0CKEN  |CAN0 Clock Enable Bit
 * |        |          |0 = CAN0 clock Disabled.
 * |        |          |1 = CAN0 clock Enabled.
 * |[26]    |OTGCKEN   |USB OTG Clock Enable Bit
 * |        |          |0 = USB OTG clock Disabled.
 * |        |          |1 = USB OTG clock Enabled.
 * |[27]    |USBDCKEN  |USB Device Clock Enable Bit
 * |        |          |0 = USB Device clock Disabled.
 * |        |          |1 = USB Device clock Enabled.
 * |[28]    |EADCCKEN  |Enhanced Analog-Digital-Converter (EADC) Clock Enable Bit
 * |        |          |0 = EADC clock Disabled.
 * |        |          |1 = EADC clock Enabled.
 * @var CLK_T::APBCLK1
 * Offset: 0x0C  APB Devices Clock Enable Control Register 1
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |SC0CKEN   |SC0 Clock Enable Bit
 * |        |          |0 = SC0 Clock Disabled.
 * |        |          |1 = SC0 Clock Enabled.
 * |[12]    |DACCKEN   |DAC Clock Enable Bit
 * |        |          |0 = DAC Clock Disabled.
 * |        |          |1 = DAC Clock Enabled.
 * |[16]    |PWM0CKEN  |PWM0 Clock Enable Bit
 * |        |          |0 = PWM0 Clock Disabled.
 * |        |          |1 = PWM0 Clock Enabled.
 * |[17]    |PWM1CKEN  |PWM1 Clock Enable Bit
 * |        |          |0 = PWM1 Clock Disabled.
 * |        |          |1 = PWM1 Clock Enabled.
 * |[25]    |TKCKEN    |Touch Key Clock Enable Bit
 * |        |          |0 = Touch Key Clock Disabled.
 * |        |          |1 = Touch key Clock Enabled.
 * @var CLK_T::CLKSEL0
 * Offset: 0x10  Clock Source Select Control Register 0
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[2:0]   |HCLKSEL   |HCLK Clock Source Selection (Write Protect)
 * |        |          |Before clock switching, the related clock sources (both pre-select and new-select) must be turned on.
 * |        |          |The default value is reloaded from the value of CFOSC (CONFIG0[26:24]) in user configuration register of Flash controller by any reset.
 * |        |          |Therefore the default value is either 000b or 111b.
 * |        |          |000 = Clock source from external 4~24 MHz high-speed crystal clock.
 * |        |          |001 = Clock source from external 32.768 kHz low-speed crystal clock.
 * |        |          |010 = Clock source from PLL clock.
 * |        |          |011 = Clock source from internal 10 kHz low-speed oscillator clock.
 * |        |          |111= Clock source from internal 22.1184 MHz high-speed oscillator clock.
 * |        |          |Other = Reserved.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.
 * |[5:3]   |STCLKSEL  |Cortex-M4 SysTick Clock Source Selection (Write Protect)
 * |        |          |If SYST_CTRL[2]=0, SysTick uses listed clock source below.
 * |        |          |000 = Clock source from external 4~24 MHz high-speed crystal clock.
 * |        |          |001 = Clock source from external 32.768 kHz low-speed crystal clock.
 * |        |          |010 = Clock source from external 4~24 MHz high-speed crystal clock/2.
 * |        |          |011 = Clock source from HCLK/2.
 * |        |          |111 = Clock source from internal 22.1184 MHz high-speed oscillator clock/2.
 * |        |          |Note: if SysTick clock source is not from HCLK (i.e.
 * |        |          |SYST_CTRL[2] = 0), SysTick clock source must less than or equal to HCLK/2.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.
 * |[6]     |PCLK0SEL  |PCLK0 Clock Source Selection (Write Protect)
 * |        |          |0 = APB0 BUS clock source from HCLK.
 * |        |          |1 = APB0 BUS clock source from HCLK/2.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.
 * |[7]     |PCLK1SEL  |PCLK1 Clock Source Selection (Write Protect)
 * |        |          |0 = APB1 BUS clock source from HCLK.
 * |        |          |1 = APB1 BUS clock source from HCLK/2.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.
 * @var CLK_T::CLKSEL1
 * Offset: 0x14  Clock Source Select Control Register 1
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[1:0]   |WDTSEL    |Watchdog Timer Clock Source Selection (Write Protect)
 * |        |          |00 = Reserved.
 * |        |          |01 = Clock source from external 32.768 kHz low-speed crystal clock.
 * |        |          |10 = Clock source from PCLK0/2048 clock.
 * |        |          |11 = Clock source from internal 10 kHz low-speed oscillator clock.
 * |[10:8]  |TMR0SEL   |TIMER0 Clock Source Selection
 * |        |          |000 = Clock source from external 4~24 MHz high-speed crystal clock.
 * |        |          |001 = Clock source from external 32.768 kHz low-speed crystal clock.
 * |        |          |010 = Clock source from PCLK0.
 * |        |          |011 = Clock source from external clock T0 pin
 * |        |          |101 = Clock source from internal 10 kHz low-speed oscillator clock.
 * |        |          |111 = Clock source from internal 22.1184 MHz high-speed oscillator clock.
 * |        |          |Others = Reserved.
 * |[14:12] |TMR1SEL   |TIMER1 Clock Source Selection
 * |        |          |000 = Clock source from external 4~24 MHz high-speed crystal clock.
 * |        |          |001 = Clock source from external 32.768 kHz low-speed crystal clock.
 * |        |          |010 = Clock source from PCLK0.
 * |        |          |011 = Clock source from external clock T1 pin
 * |        |          |101 = Clock source from internal 10 kHz low-speed oscillator clock.
 * |        |          |111 = Clock source from internal 22.1184 MHz high-speed oscillator clock.
 * |        |          |Others = Reserved.
 * |[18:16] |TMR2SEL   |TIMER2 Clock Source Selection
 * |        |          |000 = Clock source from external 4~24 MHz high-speed crystal clock.
 * |        |          |001 = Clock source from external 32.768 kHz low-speed crystal clock.
 * |        |          |010 = Clock source from PCLK1.
 * |        |          |011 = Clock source from external clock T2 pin
 * |        |          |101 = Clock source from internal 10 kHz low-speed oscillator clock.
 * |        |          |111 = Clock source from internal 22.1184 MHz high-speed oscillator clock.
 * |        |          |Others = Reserved.
 * |[22:20] |TMR3SEL   |TIMER3 Clock Source Selection
 * |        |          |000 = Clock source from external 4~24 MHz high-speed crystal clock.
 * |        |          |001 = Clock source from external 32.768 kHz low-speed crystal clock.
 * |        |          |010 = Clock source from PCLK1.
 * |        |          |011 = Clock source from external clock T3 pin.
 * |        |          |101 = Clock source from internal 10 kHz low-speed oscillator clock.
 * |        |          |111 = Clock source from internal 22.1184 MHz high-speed oscillator clock.
 * |        |          |Others = Reserved.
 * |[25:24] |UARTSEL   |UART Clock Source Selection
 * |        |          |00 = Clock source from external 4~24 MHz high-speed crystal clock (HXT).
 * |        |          |01 = Clock source from PLL clock.
 * |        |          |10 = Clock source from 32.768 kHz external low speed crystal oscillator (LXT).
 * |        |          |11 = Clock source from internal 22.1184 MHz high-speed oscillator clock (HIRC).
 * |[29:28] |CLKOSEL   |Clock Divider Clock Source Selection
 * |        |          |00 = Clock source from external 4~24 MHz high-speed crystal clock.
 * |        |          |01 = Clock source from external 32.768 kHz low-speed crystal clock.
 * |        |          |10 = Clock source from HCLK.
 * |        |          |11 = Clock source from internal 22.1184 MHz high-speed oscillator clock.
 * |[31:30] |WWDTSEL   |Window Watchdog Timer Clock Source Selection
 * |        |          |10 = Clock source from PCLK0/2048 clock.
 * |        |          |11 = Clock source from internal 10 kHz low-speed oscillator clock.
 * |        |          |Others = Reserved.
 * @var CLK_T::CLKSEL2
 * Offset: 0x18  Clock Source Select Control Register 2
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |PWM0SEL   |PWM0 Clock Source Selection
 * |        |          |The peripheral clock source of PWM0 is defined by PWM0SEL.
 * |        |          |0 = Clock source from PLL clock.
 * |        |          |1 = Clock source from PCLK0.
 * |[1]     |PWM1SEL   |PWM1 Clock Source Selection
 * |        |          |The peripheral clock source of PWM1 is defined by PWM1SEL.
 * |        |          |0 = Clock source from PLL clock.
 * |        |          |1 = Clock source from PCLK1.
 * |[3:2]   |SPI0SEL   |SPI0 Clock Source Selection
 * |        |          |00 = Clock source from external 4~24 MHz high speed crystal oscillator clock.
 * |        |          |01 = Clock source from PLL clock.
 * |        |          |10 = Clock source from PCLK0.
 * |        |          |11 = Clock source from internal 22.1184 MHz high speed oscillator clock.
 * |[5:4]   |SPI1SEL   |SPI1 Clock Source Selection
 * |        |          |00 = Clock source from external 4~24 MHz high speed crystal oscillator clock.
 * |        |          |01 = Clock source from PLL clock.
 * |        |          |10 = Clock source from PCLK1.
 * |        |          |11 = Clock source from internal 22.1184 MHz high speed oscillator clock.
 * |[7:6]   |SPI2SEL   |SPI2 Clock Source Selection
 * |        |          |00 = Clock source from external 4~24 MHz high speed crystal oscillator clock.
 * |        |          |01 = Clock source from PLL clock.
 * |        |          |10 = Clock source from PCLK0.
 * |        |          |11 = Clock source from internal 22.1184 MHz high speed oscillator clock.
 * @var CLK_T::CLKSEL3
 * Offset: 0x1C  Clock Source Select Control Register 3
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[1:0]   |SC0SEL    |SC0 Clock Source Selection
 * |        |          |00 = Clock source from external 4~24 MHz high-speed crystal clock.
 * |        |          |01 = Clock source from PLL clock.
 * |        |          |10 = Clock source from PCLK0.
 * |        |          |11 = Clock source from internal 22.1184 MHz high-speed oscillator clock.
 * |[8]     |RTCSEL    |RTC Clock Source Selection
 * |        |          |0 = Clock source from external 32.768 kHz low-speed oscillator.
 * |        |          |1 = Clock source from internal 10 kHz low speed RC oscillator.
 * @var CLK_T::CLKDIV0
 * Offset: 0x20  Clock Divider Number Register 0
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[3:0]   |HCLKDIV   |HCLK Clock Divide Number From HCLK Clock Source
 * |        |          |HCLK clock frequency = (HCLK clock source frequency) / (HCLKDIV + 1).
 * |[7:4]   |USBDIV    |USB Clock Divide Number From PLL Clock
 * |        |          |USB clock frequency = (PLL frequency) / (USBDIV + 1).
 * |[11:8]  |UARTDIV   |UART Clock Divide Number From UART Clock Source
 * |        |          |UART clock frequency = (UART clock source frequency) / (UARTDIV + 1).
 * |[23:16] |EADCDIV   |EADC Clock Divide Number From EADC Clock Source
 * |        |          |EADC clock frequency = (EADC clock source frequency) / (EADCDIV + 1).
 * @var CLK_T::CLKDIV1
 * Offset: 0x24  Clock Divider Number Register 1
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[7:0]   |SC0DIV    |SC0 Clock Divide Number From SC0 Clock Source
 * |        |          |SC0 clock frequency = (SC0 clock source frequency ) / (SC0DIV + 1).
 * @var CLK_T::PLLCTL
 * Offset: 0x40  PLL Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[8:0]   |FBDIV     |PLL Feedback Divider Control Pins (Write Protect)
 * |        |          |Refer to the formulas below the table.
 * |[13:9]  |INDIV     |PLL Input Divider Control Pins (Write Protect)
 * |        |          |Refer to the formulas below the table.
 * |[15:14] |OUTDIV    |PLL Output Divider Control Pins (Write Protect)
 * |        |          |Refer to the formulas below the table.
 * |[16]    |PD        |Power-Down Mode (Write Protect)
 * |        |          |If set the PDEN bit to 1 in CLK_PWRCTL register, the PLL will enter Power-down mode, too.
 * |        |          |0 = PLL is in normal mode.
 * |        |          |1 = PLL is in Power-down mode (default).
 * |[17]    |BP        |PLL Bypass Control (Write Protect)
 * |        |          |0 = PLL is in normal mode (default).
 * |        |          |1 = PLL clock output is same as PLL input clock FIN.
 * |[18]    |OE        |PLL OE (FOUT Enable) Pin Control (Write Protect)
 * |        |          |0 = PLL FOUT Enabled.
 * |        |          |1 = PLL FOUT is fixed low.
 * |[19]    |PLLSRC    |PLL Source Clock Selection (Write Protect)
 * |        |          |0 = PLL source clock from external 4~24 MHz high-speed crystal (HXT).
 * |        |          |1 = PLL source clock from internal 22.1184 MHz high-speed oscillator (HIRC).
 * |[23]    |STBSEL    |PLL Stable Counter Selection (Write Protect)
 * |        |          |0 = PLL stable time is 6144 PLL source clock (suitable for source clock is equal to or less than 12MHz).
 * |        |          |1 = PLL stable time is 12288 PLL source clock (suitable for source clock is larger than 12MHz).
 * @var CLK_T::STATUS
 * Offset: 0x50  Clock Status Monitor Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |HXTSTB    |External 4~24 MHz High-Speed Crystal Clock Source Stable Flag (Read Only)
 * |        |          |0 = External 4~24 MHz high-speed crystal clock is not stable or disabled.
 * |        |          |1 = External 4~24 MHz high-speed crystal clock is stable and enabled.
 * |[1]     |LXTSTB    |External 32.768 kHz Low-Speed Crystal Clock Source Stable Flag (Read Only)
 * |        |          |0 = External 32.768 kHz low-speed crystal clock is not stable or disabled.
 * |        |          |1 = External 32.768 kHz low-speed crystal clock is stabled and enabled.
 * |[2]     |PLLSTB    |Internal PLL Clock Source Stable Flag (Read Only)
 * |        |          |0 = Internal PLL clock is not stable or disabled.
 * |        |          |1 = Internal PLL clock is stable and enabled.
 * |[3]     |LIRCSTB   |Internal 10 KHz Low-Speed Oscillator Clock Source Stable Flag (Read Only)
 * |        |          |0 = Internal 10 kHz low-speed oscillator clock is not stable or disabled.
 * |        |          |1 = Internal 10 kHz low-speed oscillator clock is stable and enabled.
 * |[4]     |HIRCSTB   |Internal 22.1184 MHz High-Speed Oscillator Clock Source Stable Flag (Read Only)
 * |        |          |0 = Internal 22.1184 MHz high-speed oscillator clock is not stable or disabled.
 * |        |          |1 = Internal 22.1184 MHz high-speed oscillator clock is stable and enabled.
 * |[7]     |CLKSFAIL  |Clock Switching Fail Flag (Read Only)
 * |        |          |This bit is updated when software switches system clock source.
 * |        |          |If switch target clock is stable, this bit will be set to 0.
 * |        |          |If switch target clock is not stable, this bit will be set to 1.
 * |        |          |0 = Clock switching success.
 * |        |          |1 = Clock switching failure.
 * |        |          |Note: Write 1 to clear the bit to 0.
 * @var CLK_T::CLKOCTL
 * Offset: 0x60  Clock Output Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[3:0]   |FREQSEL   |Clock Output Frequency Selection
 * |        |          |The formula of output frequency is
 * |        |          |Fout = Fin/2(N+1).
 * |        |          |Fin is the input clock frequency.
 * |        |          |Fout is the frequency of divider output clock.
 * |        |          |N is the 4-bit value of FREQSEL[3:0].
 * |[4]     |CLKOEN    |Clock Output Enable Bit
 * |        |          |0 =Clock Output function Disabled.
 * |        |          |1 = Clock Output function Enabled.
 * |[5]     |DIV1EN    |Clock Output Divide One Enable Bit
 * |        |          |0 = Clock Output will output clock with source frequency divided by FREQSEL.
 * |        |          |1 = Clock Output will output clock with source frequency.
 * |[6]     |CLK1HZEN  |Clock Output 1Hz Enable Bit
 * |        |          |0 = 1 Hz clock output for 32.768kHz frequency compensation Disabled.
 * |        |          |1 = 1 Hz clock output for 332.768kHz frequency compensation Enabled.
 * @var CLK_T::CLKDCTL
 * Offset: 0x70  Clock Fail Detector Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[4]     |HXTFDEN   |HXT Clock Fail Detector Enable Bit
 * |        |          |0 = HXT clock Fail detector Disabled.
 * |        |          |1 = HXT clock Fail detector Enabled.
 * |[5]     |HXTFIEN   |HXT Clock Fail Interrupt Enable Bit
 * |        |          |0 = HXT clock Fail interrupt Disabled.
 * |        |          |1 = HXT clock Fail interrupt Enabled.
 * |[12]    |LXTFDEN   |LXT Clock Fail Detector Enable Bit
 * |        |          |0 = LXT clock Fail detector Disabled.
 * |        |          |1 = LXT clock Fail detector Enabled.
 * |[13]    |LXTFIEN   |LXT Clock Fail Interrupt Enable Bit
 * |        |          |0 = LXT clock Fail interrupt Disabled.
 * |        |          |1 = LXT clock Fail interrupt Enabled.
 * |[16]    |HXTFQDEN  |HXT Clock Frequency Monitor Enable Bit
 * |        |          |0 = HXT clock frequency monitor Disabled.
 * |        |          |1 = HXT clock frequency monitor Enabled.
 * |[17]    |HXTFQIEN  |HXT Clock Frequency Monitor Interrupt Enable Bit
 * |        |          |0 = HXT clock frequency monitor fail interrupt Disabled.
 * |        |          |1 = HXT clock frequency monitor fail interrupt Enabled.
 * @var CLK_T::CLKDSTS
 * Offset: 0x74  Clock Fail Detector Status Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |HXTFIF    |HXT Clock Fail Interrupt Flag
 * |        |          |0 = HXT clock normal.
 * |        |          |1 = HXT clock stop
 * |        |          |Note: Write 1 to clear the bit to 0.
 * |[1]     |LXTFIF    |LXT Clock Fail Interrupt Flag
 * |        |          |0 = LXT clock normal.
 * |        |          |1 = LXT stop
 * |        |          |Note: Write 1 to clear the bit to 0.
 * |[8]     |HXTFQIF   |HXT Clock Frequency Monitor Interrupt Flag
 * |        |          |0 = HXT clock normal.
 * |        |          |1 = HXT clock frequency abnormal
 * |        |          |Note: Write 1 to clear the bit to 0.
 * @var CLK_T::CDUPB
 * Offset: 0x78  Clock Frequency Detector Upper Boundary Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[9:0]   |UPERBD    |HXT Clock Frequency Detector Upper Boundary
 * |        |          |The bits define the high value of frequency monitor window.
 * |        |          |When HXT frequency monitor value higher than this register, the HXT frequency detect fail interrupt flag will set to 1.
 * @var CLK_T::CDLOWB
 * Offset: 0x7C  Clock Frequency Detector Low Boundary Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[9:0]   |LOWERBD   |HXT Clock Frequency Detector Low Boundary
 * |        |          |The bits define the low value of frequency monitor window.
 * |        |          |When HXT frequency monitor value lower than this register, the HXT frequency detect fail interrupt flag will set to 1.
 */

    __IO uint32_t PWRCTL;        /* Offset: 0x00  System Power-down Control Register                                 */
    __IO uint32_t AHBCLK;        /* Offset: 0x04  AHB Devices Clock Enable Control Register                          */
    __IO uint32_t APBCLK0;       /* Offset: 0x08  APB Devices Clock Enable Control Register 0                        */
    __IO uint32_t APBCLK1;       /* Offset: 0x0C  APB Devices Clock Enable Control Register 1                        */
    __IO uint32_t CLKSEL0;       /* Offset: 0x10  Clock Source Select Control Register 0                             */
    __IO uint32_t CLKSEL1;       /* Offset: 0x14  Clock Source Select Control Register 1                             */
    __IO uint32_t CLKSEL2;       /* Offset: 0x18  Clock Source Select Control Register 2                             */
    __IO uint32_t CLKSEL3;       /* Offset: 0x1C  Clock Source Select Control Register 3                             */
    __IO uint32_t CLKDIV0;       /* Offset: 0x20  Clock Divider Number Register 0                                    */
    __IO uint32_t CLKDIV1;       /* Offset: 0x24  Clock Divider Number Register 1                                    */
    __I  uint32_t RESERVE0[6];  
    __IO uint32_t PLLCTL;        /* Offset: 0x40  PLL Control Register                                               */
    __I  uint32_t RESERVE1[3];  
    __I  uint32_t STATUS;        /* Offset: 0x50  Clock Status Monitor Register                                      */
    __I  uint32_t RESERVE2[3];  
    __IO uint32_t CLKOCTL;       /* Offset: 0x60  Clock Output Control Register                                      */
    __I  uint32_t RESERVE3[3];  
    __IO uint32_t CLKDCTL;       /* Offset: 0x70  Clock Fail Detector Control Register                               */
    __IO uint32_t CLKDSTS;       /* Offset: 0x74  Clock Fail Detector Status Register                                */
    __IO uint32_t CDUPB;         /* Offset: 0x78  Clock Frequency Detector Upper Boundary Register                   */
    __IO uint32_t CDLOWB;        /* Offset: 0x7C  Clock Frequency Detector Low Boundary Register                     */

} CLK_T;



/**
    @addtogroup CLK_CONST CLK Bit Field Definition
    Constant Definitions for CLK Controller
@{ */

#define CLK_PWRCTL_HXTEN_Pos             (0)                                               /*!< CLK_T::PWRCTL: HXTEN Position             */
#define CLK_PWRCTL_HXTEN_Msk             (0x1ul << CLK_PWRCTL_HXTEN_Pos)                   /*!< CLK_T::PWRCTL: HXTEN Mask                 */

#define CLK_PWRCTL_LXTEN_Pos             (1)                                               /*!< CLK_T::PWRCTL: LXTEN Position             */
#define CLK_PWRCTL_LXTEN_Msk             (0x1ul << CLK_PWRCTL_LXTEN_Pos)                   /*!< CLK_T::PWRCTL: LXTEN Mask                 */

#define CLK_PWRCTL_HIRCEN_Pos            (2)                                               /*!< CLK_T::PWRCTL: HIRCEN Position            */
#define CLK_PWRCTL_HIRCEN_Msk            (0x1ul << CLK_PWRCTL_HIRCEN_Pos)                  /*!< CLK_T::PWRCTL: HIRCEN Mask                */

#define CLK_PWRCTL_LIRCEN_Pos            (3)                                               /*!< CLK_T::PWRCTL: LIRCEN Position            */
#define CLK_PWRCTL_LIRCEN_Msk            (0x1ul << CLK_PWRCTL_LIRCEN_Pos)                  /*!< CLK_T::PWRCTL: LIRCEN Mask                */

#define CLK_PWRCTL_PDWKDLY_Pos           (4)                                               /*!< CLK_T::PWRCTL: PDWKDLY Position           */
#define CLK_PWRCTL_PDWKDLY_Msk           (0x1ul << CLK_PWRCTL_PDWKDLY_Pos)                 /*!< CLK_T::PWRCTL: PDWKDLY Mask               */

#define CLK_PWRCTL_PDWKIEN_Pos           (5)                                               /*!< CLK_T::PWRCTL: PDWKIEN Position           */
#define CLK_PWRCTL_PDWKIEN_Msk           (0x1ul << CLK_PWRCTL_PDWKIEN_Pos)                 /*!< CLK_T::PWRCTL: PDWKIEN Mask               */

#define CLK_PWRCTL_PDWKIF_Pos            (6)                                               /*!< CLK_T::PWRCTL: PDWKIF Position            */
#define CLK_PWRCTL_PDWKIF_Msk            (0x1ul << CLK_PWRCTL_PDWKIF_Pos)                  /*!< CLK_T::PWRCTL: PDWKIF Mask                */

#define CLK_PWRCTL_PDEN_Pos              (7)                                               /*!< CLK_T::PWRCTL: PDEN Position              */
#define CLK_PWRCTL_PDEN_Msk              (0x1ul << CLK_PWRCTL_PDEN_Pos)                    /*!< CLK_T::PWRCTL: PDEN Mask                  */

#define CLK_PWRCTL_PDWTCPU_Pos           (8)                                               /*!< CLK_T::PWRCTL: PDWTCPU Position           */
#define CLK_PWRCTL_PDWTCPU_Msk           (0x1ul << CLK_PWRCTL_PDWTCPU_Pos)                 /*!< CLK_T::PWRCTL: PDWTCPU Mask               */

#define CLK_PWRCTL_HXTGAIN_Pos           (10)                                              /*!< CLK_T::PWRCTL: HXTGAIN Position           */
#define CLK_PWRCTL_HXTGAIN_Msk           (0x3ul << CLK_PWRCTL_HXTGAIN_Pos)                 /*!< CLK_T::PWRCTL: HXTGAIN Mask               */

#define CLK_PWRCTL_HXTSELTYP_Pos         (12)                                              /*!< CLK_T::PWRCTL: HXTSELTYP Position         */
#define CLK_PWRCTL_HXTSELTYP_Msk         (0x1ul << CLK_PWRCTL_HXTSELTYP_Pos)               /*!< CLK_T::PWRCTL: HXTSELTYP Mask             */

#define CLK_AHBCLK_PDMACKEN_Pos          (1)                                               /*!< CLK_T::AHBCLK: PDMACKEN Position          */
#define CLK_AHBCLK_PDMACKEN_Msk          (0x1ul << CLK_AHBCLK_PDMACKEN_Pos)                /*!< CLK_T::AHBCLK: PDMACKEN Mask              */

#define CLK_AHBCLK_ISPCKEN_Pos           (2)                                               /*!< CLK_T::AHBCLK: ISPCKEN Position           */
#define CLK_AHBCLK_ISPCKEN_Msk           (0x1ul << CLK_AHBCLK_ISPCKEN_Pos)                 /*!< CLK_T::AHBCLK: ISPCKEN Mask               */

#define CLK_AHBCLK_EBICKEN_Pos           (3)                                               /*!< CLK_T::AHBCLK: EBICKEN Position           */
#define CLK_AHBCLK_EBICKEN_Msk           (0x1ul << CLK_AHBCLK_EBICKEN_Pos)                 /*!< CLK_T::AHBCLK: EBICKEN Mask               */

#define CLK_AHBCLK_USBHCKEN_Pos          (4)                                               /*!< CLK_T::AHBCLK: USBHCKEN Position          */
#define CLK_AHBCLK_USBHCKEN_Msk          (0x1ul << CLK_AHBCLK_USBHCKEN_Pos)                /*!< CLK_T::AHBCLK: USBHCKEN Mask              */

#define CLK_AHBCLK_CRCCKEN_Pos           (7)                                               /*!< CLK_T::AHBCLK: CRCCKEN Position           */
#define CLK_AHBCLK_CRCCKEN_Msk           (0x1ul << CLK_AHBCLK_CRCCKEN_Pos)                 /*!< CLK_T::AHBCLK: CRCCKEN Mask               */

#define CLK_AHBCLK_FMCIDLE_Pos           (15)                                              /*!< CLK_T::AHBCLK: FMCIDLE Position           */
#define CLK_AHBCLK_FMCIDLE_Msk           (0x1ul << CLK_AHBCLK_FMCIDLE_Pos)                 /*!< CLK_T::AHBCLK: FMCIDLE Mask               */

#define CLK_APBCLK0_WDTCKEN_Pos          (0)                                               /*!< CLK_T::APBCLK0: WDTCKEN Position          */
#define CLK_APBCLK0_WDTCKEN_Msk          (0x1ul << CLK_APBCLK0_WDTCKEN_Pos)                /*!< CLK_T::APBCLK0: WDTCKEN Mask              */

#define CLK_APBCLK0_RTCCKEN_Pos          (1)                                               /*!< CLK_T::APBCLK0: RTCCKEN Position          */
#define CLK_APBCLK0_RTCCKEN_Msk          (0x1ul << CLK_APBCLK0_RTCCKEN_Pos)                /*!< CLK_T::APBCLK0: RTCCKEN Mask              */

#define CLK_APBCLK0_TMR0CKEN_Pos         (2)                                               /*!< CLK_T::APBCLK0: TMR0CKEN Position         */
#define CLK_APBCLK0_TMR0CKEN_Msk         (0x1ul << CLK_APBCLK0_TMR0CKEN_Pos)               /*!< CLK_T::APBCLK0: TMR0CKEN Mask             */

#define CLK_APBCLK0_TMR1CKEN_Pos         (3)                                               /*!< CLK_T::APBCLK0: TMR1CKEN Position         */
#define CLK_APBCLK0_TMR1CKEN_Msk         (0x1ul << CLK_APBCLK0_TMR1CKEN_Pos)               /*!< CLK_T::APBCLK0: TMR1CKEN Mask             */

#define CLK_APBCLK0_TMR2CKEN_Pos         (4)                                               /*!< CLK_T::APBCLK0: TMR2CKEN Position         */
#define CLK_APBCLK0_TMR2CKEN_Msk         (0x1ul << CLK_APBCLK0_TMR2CKEN_Pos)               /*!< CLK_T::APBCLK0: TMR2CKEN Mask             */

#define CLK_APBCLK0_TMR3CKEN_Pos         (5)                                               /*!< CLK_T::APBCLK0: TMR3CKEN Position         */
#define CLK_APBCLK0_TMR3CKEN_Msk         (0x1ul << CLK_APBCLK0_TMR3CKEN_Pos)               /*!< CLK_T::APBCLK0: TMR3CKEN Mask             */

#define CLK_APBCLK0_CLKOCKEN_Pos         (6)                                               /*!< CLK_T::APBCLK0: CLKOCKEN Position         */
#define CLK_APBCLK0_CLKOCKEN_Msk         (0x1ul << CLK_APBCLK0_CLKOCKEN_Pos)               /*!< CLK_T::APBCLK0: CLKOCKEN Mask             */

#define CLK_APBCLK0_ACMP01CKEN_Pos       (7)                                               /*!< CLK_T::APBCLK0: ACMP01CKEN Position       */
#define CLK_APBCLK0_ACMP01CKEN_Msk       (0x1ul << CLK_APBCLK0_ACMP01CKEN_Pos)             /*!< CLK_T::APBCLK0: ACMP01CKEN Mask           */

#define CLK_APBCLK0_I2C0CKEN_Pos         (8)                                               /*!< CLK_T::APBCLK0: I2C0CKEN Position         */
#define CLK_APBCLK0_I2C0CKEN_Msk         (0x1ul << CLK_APBCLK0_I2C0CKEN_Pos)               /*!< CLK_T::APBCLK0: I2C0CKEN Mask             */

#define CLK_APBCLK0_I2C1CKEN_Pos         (9)                                               /*!< CLK_T::APBCLK0: I2C1CKEN Position         */
#define CLK_APBCLK0_I2C1CKEN_Msk         (0x1ul << CLK_APBCLK0_I2C1CKEN_Pos)               /*!< CLK_T::APBCLK0: I2C1CKEN Mask             */

#define CLK_APBCLK0_SPI0CKEN_Pos         (12)                                              /*!< CLK_T::APBCLK0: SPI0CKEN Position         */
#define CLK_APBCLK0_SPI0CKEN_Msk         (0x1ul << CLK_APBCLK0_SPI0CKEN_Pos)               /*!< CLK_T::APBCLK0: SPI0CKEN Mask             */

#define CLK_APBCLK0_SPI1CKEN_Pos         (13)                                              /*!< CLK_T::APBCLK0: SPI1CKEN Position         */
#define CLK_APBCLK0_SPI1CKEN_Msk         (0x1ul << CLK_APBCLK0_SPI1CKEN_Pos)               /*!< CLK_T::APBCLK0: SPI1CKEN Mask             */

#define CLK_APBCLK0_SPI2CKEN_Pos         (14)                                              /*!< CLK_T::APBCLK0: SPI2CKEN Position         */
#define CLK_APBCLK0_SPI2CKEN_Msk         (0x1ul << CLK_APBCLK0_SPI2CKEN_Pos)               /*!< CLK_T::APBCLK0: SPI2CKEN Mask             */

#define CLK_APBCLK0_UART0CKEN_Pos        (16)                                              /*!< CLK_T::APBCLK0: UART0CKEN Position        */
#define CLK_APBCLK0_UART0CKEN_Msk        (0x1ul << CLK_APBCLK0_UART0CKEN_Pos)              /*!< CLK_T::APBCLK0: UART0CKEN Mask            */

#define CLK_APBCLK0_UART1CKEN_Pos        (17)                                              /*!< CLK_T::APBCLK0: UART1CKEN Position        */
#define CLK_APBCLK0_UART1CKEN_Msk        (0x1ul << CLK_APBCLK0_UART1CKEN_Pos)              /*!< CLK_T::APBCLK0: UART1CKEN Mask            */

#define CLK_APBCLK0_UART2CKEN_Pos        (18)                                              /*!< CLK_T::APBCLK0: UART2CKEN Position        */
#define CLK_APBCLK0_UART2CKEN_Msk        (0x1ul << CLK_APBCLK0_UART2CKEN_Pos)              /*!< CLK_T::APBCLK0: UART2CKEN Mask            */

#define CLK_APBCLK0_UART3CKEN_Pos        (19)                                              /*!< CLK_T::APBCLK0: UART3CKEN Position        */
#define CLK_APBCLK0_UART3CKEN_Msk        (0x1ul << CLK_APBCLK0_UART3CKEN_Pos)              /*!< CLK_T::APBCLK0: UART3CKEN Mask            */

#define CLK_APBCLK0_CAN0CKEN_Pos         (24)                                              /*!< CLK_T::APBCLK0: CAN0CKEN Position         */
#define CLK_APBCLK0_CAN0CKEN_Msk         (0x1ul << CLK_APBCLK0_CAN0CKEN_Pos)               /*!< CLK_T::APBCLK0: CAN0CKEN Mask             */

#define CLK_APBCLK0_OTGCKEN_Pos          (26)                                              /*!< CLK_T::APBCLK0: OTGCKEN Position          */
#define CLK_APBCLK0_OTGCKEN_Msk          (0x1ul << CLK_APBCLK0_OTGCKEN_Pos)                /*!< CLK_T::APBCLK0: OTGCKEN Mask              */

#define CLK_APBCLK0_USBDCKEN_Pos         (27)                                              /*!< CLK_T::APBCLK0: USBDCKEN Position         */
#define CLK_APBCLK0_USBDCKEN_Msk         (0x1ul << CLK_APBCLK0_USBDCKEN_Pos)               /*!< CLK_T::APBCLK0: USBDCKEN Mask             */

#define CLK_APBCLK0_EADCCKEN_Pos         (28)                                              /*!< CLK_T::APBCLK0: EADCCKEN Position         */
#define CLK_APBCLK0_EADCCKEN_Msk         (0x1ul << CLK_APBCLK0_EADCCKEN_Pos)               /*!< CLK_T::APBCLK0: EADCCKEN Mask             */

#define CLK_APBCLK1_SC0CKEN_Pos          (0)                                               /*!< CLK_T::APBCLK1: SC0CKEN Position          */
#define CLK_APBCLK1_SC0CKEN_Msk          (0x1ul << CLK_APBCLK1_SC0CKEN_Pos)                /*!< CLK_T::APBCLK1: SC0CKEN Mask              */

#define CLK_APBCLK1_DACCKEN_Pos          (12)                                              /*!< CLK_T::APBCLK1: DACCKEN Position          */
#define CLK_APBCLK1_DACCKEN_Msk          (0x1ul << CLK_APBCLK1_DACCKEN_Pos)                /*!< CLK_T::APBCLK1: DACCKEN Mask              */

#define CLK_APBCLK1_PWM0CKEN_Pos         (16)                                              /*!< CLK_T::APBCLK1: PWM0CKEN Position         */
#define CLK_APBCLK1_PWM0CKEN_Msk         (0x1ul << CLK_APBCLK1_PWM0CKEN_Pos)               /*!< CLK_T::APBCLK1: PWM0CKEN Mask             */

#define CLK_APBCLK1_PWM1CKEN_Pos         (17)                                              /*!< CLK_T::APBCLK1: PWM1CKEN Position         */
#define CLK_APBCLK1_PWM1CKEN_Msk         (0x1ul << CLK_APBCLK1_PWM1CKEN_Pos)               /*!< CLK_T::APBCLK1: PWM1CKEN Mask             */

#define CLK_APBCLK1_TKCKEN_Pos           (25)                                              /*!< CLK_T::APBCLK1: TKCKEN Position           */
#define CLK_APBCLK1_TKCKEN_Msk           (0x1ul << CLK_APBCLK1_TKCKEN_Pos)                 /*!< CLK_T::APBCLK1: TKCKEN Mask               */

#define CLK_CLKSEL0_HCLKSEL_Pos          (0)                                               /*!< CLK_T::CLKSEL0: HCLKSEL Position          */
#define CLK_CLKSEL0_HCLKSEL_Msk          (0x7ul << CLK_CLKSEL0_HCLKSEL_Pos)                /*!< CLK_T::CLKSEL0: HCLKSEL Mask              */

#define CLK_CLKSEL0_STCLKSEL_Pos         (3)                                               /*!< CLK_T::CLKSEL0: STCLKSEL Position         */
#define CLK_CLKSEL0_STCLKSEL_Msk         (0x7ul << CLK_CLKSEL0_STCLKSEL_Pos)               /*!< CLK_T::CLKSEL0: STCLKSEL Mask             */

#define CLK_CLKSEL0_PCLK0SEL_Pos         (6)                                               /*!< CLK_T::CLKSEL0: PCLK0SEL Position         */
#define CLK_CLKSEL0_PCLK0SEL_Msk         (0x1ul << CLK_CLKSEL0_PCLK0SEL_Pos)               /*!< CLK_T::CLKSEL0: PCLK0SEL Mask             */

#define CLK_CLKSEL0_PCLK1SEL_Pos         (7)                                               /*!< CLK_T::CLKSEL0: PCLK1SEL Position         */
#define CLK_CLKSEL0_PCLK1SEL_Msk         (0x1ul << CLK_CLKSEL0_PCLK1SEL_Pos)               /*!< CLK_T::CLKSEL0: PCLK1SEL Mask             */

#define CLK_CLKSEL1_WDTSEL_Pos           (0)                                               /*!< CLK_T::CLKSEL1: WDTSEL Position           */
#define CLK_CLKSEL1_WDTSEL_Msk           (0x3ul << CLK_CLKSEL1_WDTSEL_Pos)                 /*!< CLK_T::CLKSEL1: WDTSEL Mask               */

#define CLK_CLKSEL1_TMR0SEL_Pos          (8)                                               /*!< CLK_T::CLKSEL1: TMR0SEL Position          */
#define CLK_CLKSEL1_TMR0SEL_Msk          (0x7ul << CLK_CLKSEL1_TMR0SEL_Pos)                /*!< CLK_T::CLKSEL1: TMR0SEL Mask              */

#define CLK_CLKSEL1_TMR1SEL_Pos          (12)                                              /*!< CLK_T::CLKSEL1: TMR1SEL Position          */
#define CLK_CLKSEL1_TMR1SEL_Msk          (0x7ul << CLK_CLKSEL1_TMR1SEL_Pos)                /*!< CLK_T::CLKSEL1: TMR1SEL Mask              */

#define CLK_CLKSEL1_TMR2SEL_Pos          (16)                                              /*!< CLK_T::CLKSEL1: TMR2SEL Position          */
#define CLK_CLKSEL1_TMR2SEL_Msk          (0x7ul << CLK_CLKSEL1_TMR2SEL_Pos)                /*!< CLK_T::CLKSEL1: TMR2SEL Mask              */

#define CLK_CLKSEL1_TMR3SEL_Pos          (20)                                              /*!< CLK_T::CLKSEL1: TMR3SEL Position          */
#define CLK_CLKSEL1_TMR3SEL_Msk          (0x7ul << CLK_CLKSEL1_TMR3SEL_Pos)                /*!< CLK_T::CLKSEL1: TMR3SEL Mask              */

#define CLK_CLKSEL1_UARTSEL_Pos          (24)                                              /*!< CLK_T::CLKSEL1: UARTSEL Position          */
#define CLK_CLKSEL1_UARTSEL_Msk          (0x3ul << CLK_CLKSEL1_UARTSEL_Pos)                /*!< CLK_T::CLKSEL1: UARTSEL Mask              */

#define CLK_CLKSEL1_CLKOSEL_Pos          (28)                                              /*!< CLK_T::CLKSEL1: CLKOSEL Position          */
#define CLK_CLKSEL1_CLKOSEL_Msk          (0x3ul << CLK_CLKSEL1_CLKOSEL_Pos)                /*!< CLK_T::CLKSEL1: CLKOSEL Mask              */

#define CLK_CLKSEL1_WWDTSEL_Pos          (30)                                              /*!< CLK_T::CLKSEL1: WWDTSEL Position          */
#define CLK_CLKSEL1_WWDTSEL_Msk          (0x3ul << CLK_CLKSEL1_WWDTSEL_Pos)                /*!< CLK_T::CLKSEL1: WWDTSEL Mask              */

#define CLK_CLKSEL2_PWM0SEL_Pos          (0)                                               /*!< CLK_T::CLKSEL2: PWM0SEL Position          */
#define CLK_CLKSEL2_PWM0SEL_Msk          (0x1ul << CLK_CLKSEL2_PWM0SEL_Pos)                /*!< CLK_T::CLKSEL2: PWM0SEL Mask              */

#define CLK_CLKSEL2_PWM1SEL_Pos          (1)                                               /*!< CLK_T::CLKSEL2: PWM1SEL Position          */
#define CLK_CLKSEL2_PWM1SEL_Msk          (0x1ul << CLK_CLKSEL2_PWM1SEL_Pos)                /*!< CLK_T::CLKSEL2: PWM1SEL Mask              */

#define CLK_CLKSEL2_SPI0SEL_Pos          (2)                                               /*!< CLK_T::CLKSEL2: SPI0SEL Position          */
#define CLK_CLKSEL2_SPI0SEL_Msk          (0x3ul << CLK_CLKSEL2_SPI0SEL_Pos)                /*!< CLK_T::CLKSEL2: SPI0SEL Mask              */

#define CLK_CLKSEL2_SPI1SEL_Pos          (4)                                               /*!< CLK_T::CLKSEL2: SPI1SEL Position          */
#define CLK_CLKSEL2_SPI1SEL_Msk          (0x3ul << CLK_CLKSEL2_SPI1SEL_Pos)                /*!< CLK_T::CLKSEL2: SPI1SEL Mask              */

#define CLK_CLKSEL2_SPI2SEL_Pos          (6)                                               /*!< CLK_T::CLKSEL2: SPI2SEL Position          */
#define CLK_CLKSEL2_SPI2SEL_Msk          (0x3ul << CLK_CLKSEL2_SPI2SEL_Pos)                /*!< CLK_T::CLKSEL2: SPI2SEL Mask              */

#define CLK_CLKSEL3_SC0SEL_Pos           (0)                                               /*!< CLK_T::CLKSEL3: SC0SEL Position           */
#define CLK_CLKSEL3_SC0SEL_Msk           (0x3ul << CLK_CLKSEL3_SC0SEL_Pos)                 /*!< CLK_T::CLKSEL3: SC0SEL Mask               */

#define CLK_CLKSEL3_RTCSEL_Pos           (8)                                               /*!< CLK_T::CLKSEL3: RTCSEL Position           */
#define CLK_CLKSEL3_RTCSEL_Msk           (0x1ul << CLK_CLKSEL3_RTCSEL_Pos)                 /*!< CLK_T::CLKSEL3: RTCSEL Mask               */

#define CLK_CLKDIV0_HCLKDIV_Pos          (0)                                               /*!< CLK_T::CLKDIV0: HCLKDIV Position          */
#define CLK_CLKDIV0_HCLKDIV_Msk          (0xful << CLK_CLKDIV0_HCLKDIV_Pos)                /*!< CLK_T::CLKDIV0: HCLKDIV Mask              */

#define CLK_CLKDIV0_USBDIV_Pos           (4)                                               /*!< CLK_T::CLKDIV0: USBDIV Position           */
#define CLK_CLKDIV0_USBDIV_Msk           (0xful << CLK_CLKDIV0_USBDIV_Pos)                 /*!< CLK_T::CLKDIV0: USBDIV Mask               */

#define CLK_CLKDIV0_UARTDIV_Pos          (8)                                               /*!< CLK_T::CLKDIV0: UARTDIV Position          */
#define CLK_CLKDIV0_UARTDIV_Msk          (0xful << CLK_CLKDIV0_UARTDIV_Pos)                /*!< CLK_T::CLKDIV0: UARTDIV Mask              */

#define CLK_CLKDIV0_EADCDIV_Pos          (16)                                              /*!< CLK_T::CLKDIV0: EADCDIV Position          */
#define CLK_CLKDIV0_EADCDIV_Msk          (0xfful << CLK_CLKDIV0_EADCDIV_Pos)               /*!< CLK_T::CLKDIV0: EADCDIV Mask              */

#define CLK_CLKDIV1_SC0DIV_Pos           (0)                                               /*!< CLK_T::CLKDIV1: SC0DIV Position           */
#define CLK_CLKDIV1_SC0DIV_Msk           (0xfful << CLK_CLKDIV1_SC0DIV_Pos)                /*!< CLK_T::CLKDIV1: SC0DIV Mask               */

#define CLK_PLLCTL_FBDIV_Pos             (0)                                               /*!< CLK_T::PLLCTL: FBDIV Position             */
#define CLK_PLLCTL_FBDIV_Msk             (0x1fful << CLK_PLLCTL_FBDIV_Pos)                 /*!< CLK_T::PLLCTL: FBDIV Mask                 */

#define CLK_PLLCTL_INDIV_Pos             (9)                                               /*!< CLK_T::PLLCTL: INDIV Position             */
#define CLK_PLLCTL_INDIV_Msk             (0x1ful << CLK_PLLCTL_INDIV_Pos)                  /*!< CLK_T::PLLCTL: INDIV Mask                 */

#define CLK_PLLCTL_OUTDIV_Pos            (14)                                              /*!< CLK_T::PLLCTL: OUTDIV Position            */
#define CLK_PLLCTL_OUTDIV_Msk            (0x3ul << CLK_PLLCTL_OUTDIV_Pos)                  /*!< CLK_T::PLLCTL: OUTDIV Mask                */

#define CLK_PLLCTL_PD_Pos                (16)                                              /*!< CLK_T::PLLCTL: PD Position                */
#define CLK_PLLCTL_PD_Msk                (0x1ul << CLK_PLLCTL_PD_Pos)                      /*!< CLK_T::PLLCTL: PD Mask                    */

#define CLK_PLLCTL_BP_Pos                (17)                                              /*!< CLK_T::PLLCTL: BP Position                */
#define CLK_PLLCTL_BP_Msk                (0x1ul << CLK_PLLCTL_BP_Pos)                      /*!< CLK_T::PLLCTL: BP Mask                    */

#define CLK_PLLCTL_OE_Pos                (18)                                              /*!< CLK_T::PLLCTL: OE Position                */
#define CLK_PLLCTL_OE_Msk                (0x1ul << CLK_PLLCTL_OE_Pos)                      /*!< CLK_T::PLLCTL: OE Mask                    */

#define CLK_PLLCTL_PLLSRC_Pos            (19)                                              /*!< CLK_T::PLLCTL: PLLSRC Position            */
#define CLK_PLLCTL_PLLSRC_Msk            (0x1ul << CLK_PLLCTL_PLLSRC_Pos)                  /*!< CLK_T::PLLCTL: PLLSRC Mask                */

#define CLK_PLLCTL_STBSEL_Pos            (23)                                              /*!< CLK_T::PLLCTL: STBSEL Position            */
#define CLK_PLLCTL_STBSEL_Msk            (0x1ul << CLK_PLLCTL_STBSEL_Pos)                  /*!< CLK_T::PLLCTL: STBSEL Mask                */

#define CLK_STATUS_HXTSTB_Pos            (0)                                               /*!< CLK_T::STATUS: HXTSTB Position            */
#define CLK_STATUS_HXTSTB_Msk            (0x1ul << CLK_STATUS_HXTSTB_Pos)                  /*!< CLK_T::STATUS: HXTSTB Mask                */

#define CLK_STATUS_LXTSTB_Pos            (1)                                               /*!< CLK_T::STATUS: LXTSTB Position            */
#define CLK_STATUS_LXTSTB_Msk            (0x1ul << CLK_STATUS_LXTSTB_Pos)                  /*!< CLK_T::STATUS: LXTSTB Mask                */

#define CLK_STATUS_PLLSTB_Pos            (2)                                               /*!< CLK_T::STATUS: PLLSTB Position            */
#define CLK_STATUS_PLLSTB_Msk            (0x1ul << CLK_STATUS_PLLSTB_Pos)                  /*!< CLK_T::STATUS: PLLSTB Mask                */

#define CLK_STATUS_LIRCSTB_Pos           (3)                                               /*!< CLK_T::STATUS: LIRCSTB Position           */
#define CLK_STATUS_LIRCSTB_Msk           (0x1ul << CLK_STATUS_LIRCSTB_Pos)                 /*!< CLK_T::STATUS: LIRCSTB Mask               */

#define CLK_STATUS_HIRCSTB_Pos           (4)                                               /*!< CLK_T::STATUS: HIRCSTB Position           */
#define CLK_STATUS_HIRCSTB_Msk           (0x1ul << CLK_STATUS_HIRCSTB_Pos)                 /*!< CLK_T::STATUS: HIRCSTB Mask               */

#define CLK_STATUS_CLKSFAIL_Pos          (7)                                               /*!< CLK_T::STATUS: CLKSFAIL Position          */
#define CLK_STATUS_CLKSFAIL_Msk          (0x1ul << CLK_STATUS_CLKSFAIL_Pos)                /*!< CLK_T::STATUS: CLKSFAIL Mask              */

#define CLK_CLKOCTL_FREQSEL_Pos          (0)                                               /*!< CLK_T::CLKOCTL: FREQSEL Position          */
#define CLK_CLKOCTL_FREQSEL_Msk          (0xful << CLK_CLKOCTL_FREQSEL_Pos)                /*!< CLK_T::CLKOCTL: FREQSEL Mask              */

#define CLK_CLKOCTL_CLKOEN_Pos           (4)                                               /*!< CLK_T::CLKOCTL: CLKOEN Position           */
#define CLK_CLKOCTL_CLKOEN_Msk           (0x1ul << CLK_CLKOCTL_CLKOEN_Pos)                 /*!< CLK_T::CLKOCTL: CLKOEN Mask               */

#define CLK_CLKOCTL_DIV1EN_Pos           (5)                                               /*!< CLK_T::CLKOCTL: DIV1EN Position           */
#define CLK_CLKOCTL_DIV1EN_Msk           (0x1ul << CLK_CLKOCTL_DIV1EN_Pos)                 /*!< CLK_T::CLKOCTL: DIV1EN Mask               */

#define CLK_CLKOCTL_CLK1HZEN_Pos         (6)                                               /*!< CLK_T::CLKOCTL: CLK1HZEN Position         */
#define CLK_CLKOCTL_CLK1HZEN_Msk         (0x1ul << CLK_CLKOCTL_CLK1HZEN_Pos)               /*!< CLK_T::CLKOCTL: CLK1HZEN Mask             */

#define CLK_CLKDCTL_HXTFDEN_Pos          (4)                                               /*!< CLK_T::CLKDCTL: HXTFDEN Position          */
#define CLK_CLKDCTL_HXTFDEN_Msk          (0x1ul << CLK_CLKDCTL_HXTFDEN_Pos)                /*!< CLK_T::CLKDCTL: HXTFDEN Mask              */

#define CLK_CLKDCTL_HXTFIEN_Pos          (5)                                               /*!< CLK_T::CLKDCTL: HXTFIEN Position          */
#define CLK_CLKDCTL_HXTFIEN_Msk          (0x1ul << CLK_CLKDCTL_HXTFIEN_Pos)                /*!< CLK_T::CLKDCTL: HXTFIEN Mask              */

#define CLK_CLKDCTL_LXTFDEN_Pos          (12)                                              /*!< CLK_T::CLKDCTL: LXTFDEN Position          */
#define CLK_CLKDCTL_LXTFDEN_Msk          (0x1ul << CLK_CLKDCTL_LXTFDEN_Pos)                /*!< CLK_T::CLKDCTL: LXTFDEN Mask              */

#define CLK_CLKDCTL_LXTFIEN_Pos          (13)                                              /*!< CLK_T::CLKDCTL: LXTFIEN Position          */
#define CLK_CLKDCTL_LXTFIEN_Msk          (0x1ul << CLK_CLKDCTL_LXTFIEN_Pos)                /*!< CLK_T::CLKDCTL: LXTFIEN Mask              */

#define CLK_CLKDCTL_HXTFQDEN_Pos         (16)                                              /*!< CLK_T::CLKDCTL: HXTFQDEN Position         */
#define CLK_CLKDCTL_HXTFQDEN_Msk         (0x1ul << CLK_CLKDCTL_HXTFQDEN_Pos)               /*!< CLK_T::CLKDCTL: HXTFQDEN Mask             */

#define CLK_CLKDCTL_HXTFQIEN_Pos         (17)                                              /*!< CLK_T::CLKDCTL: HXTFQIEN Position         */
#define CLK_CLKDCTL_HXTFQIEN_Msk         (0x1ul << CLK_CLKDCTL_HXTFQIEN_Pos)               /*!< CLK_T::CLKDCTL: HXTFQIEN Mask             */

#define CLK_CLKDSTS_HXTFIF_Pos           (0)                                               /*!< CLK_T::CLKDSTS: HXTFIF Position           */
#define CLK_CLKDSTS_HXTFIF_Msk           (0x1ul << CLK_CLKDSTS_HXTFIF_Pos)                 /*!< CLK_T::CLKDSTS: HXTFIF Mask               */

#define CLK_CLKDSTS_LXTFIF_Pos           (1)                                               /*!< CLK_T::CLKDSTS: LXTFIF Position           */
#define CLK_CLKDSTS_LXTFIF_Msk           (0x1ul << CLK_CLKDSTS_LXTFIF_Pos)                 /*!< CLK_T::CLKDSTS: LXTFIF Mask               */

#define CLK_CLKDSTS_HXTFQIF_Pos          (8)                                               /*!< CLK_T::CLKDSTS: HXTFQIF Position          */
#define CLK_CLKDSTS_HXTFQIF_Msk          (0x1ul << CLK_CLKDSTS_HXTFQIF_Pos)                /*!< CLK_T::CLKDSTS: HXTFQIF Mask              */

#define CLK_CDUPB_UPERBD_Pos             (0)                                               /*!< CLK_T::CDUPB: UPERBD Position             */
#define CLK_CDUPB_UPERBD_Msk             (0x3fful << CLK_CDUPB_UPERBD_Pos)                 /*!< CLK_T::CDUPB: UPERBD Mask                 */

#define CLK_CDLOWB_LOWERBD_Pos           (0)                                               /*!< CLK_T::CDLOWB: LOWERBD Position           */
#define CLK_CDLOWB_LOWERBD_Msk           (0x3fful << CLK_CDLOWB_LOWERBD_Pos)               /*!< CLK_T::CDLOWB: LOWERBD Mask               */


/**@}*/ /* CLK_CONST */
/**@}*/ /* end of CLK register group */



/*---------------------- Cyclic Redundancy Check Controller -------------------------*/
/**
    @addtogroup CRC Cyclic Redundancy Check Controller(CRC)
    Memory Mapped Structure for CRC Controller
@{ */


typedef struct
{




/**
 * @var CRC_T::CTL
 * Offset: 0x00  CRC Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |CRCEN     |CRC Channel Enable Bit
 * |        |          |0 = No effect.
 * |        |          |1 = CRC operation Enabled.
 * |[1]     |CRCRST    |CRC Engine Reset
 * |        |          |0 = No effect.
 * |        |          |1 = Reset the internal CRC state machine and internal buffer.
 * |        |          |The others contents of CRC_CTL register will not be cleared.
 * |        |          |Note1: This bit will be cleared automatically.
 * |        |          |Note2: Setting this bit will reload the initial seed value (CRC_SEED register).
 * |[24]    |DATREV    |Write Data Bit Order Reverse
 * |        |          |This bit is used to enable the bit order reverse function for write data value in CRC_DAT register.
 * |        |          |0 = Bit order reversed for CRC write data in Disabled.
 * |        |          |1 = Bit order reversed for CRC write data in Enabled (per byte).
 * |        |          |Note: If the write data is 0xAABBCCDD, the bit order reverse for CRC write data in is 0x55DD33BB.
 * |[25]    |CHKSREV   |Checksum Bit Order Reverse
 * |        |          |This bit is used to enable the bit order reverse function for write data value in CRC_CHECKSUM register.
 * |        |          |0 = Bit order reverse for CRC checksum Disabled.
 * |        |          |1 = Bit order reverse for CRC checksum Enabled.
 * |        |          |Note: If the checksum result is 0xDD7B0F2E, the bit order reverse for CRC checksum is 0x74F0DEBB.
 * |[26]    |DATFMT    |Write Data 1's Complement
 * |        |          |This bit is used to enable the 1's complement function for write data value in CRC_DAT register.
 * |        |          |0 = 1's complement for CRC writes data in Disabled.
 * |        |          |1 = 1's complement for CRC writes data in Enabled.
 * |[27]    |CHKSFMT   |Checksum 1's Complement
 * |        |          |This bit is used to enable the 1's complement function for checksum result in CRC_CHECKSUM register.
 * |        |          |0 = 1's complement for CRC checksum Disabled.
 * |        |          |1 = 1's complement for CRC checksum Enabled.
 * |[29:28] |DATLEN    |CPU Write Data Length
 * |        |          |This field indicates the write data length.
 * |        |          |00 = Data length is 8-bit mode.
 * |        |          |01 = Data length is 16-bit mode.
 * |        |          |1x = Data length is 32-bit mode.
 * |        |          |Note: When the write data length is 8-bit mode, the valid data in CRC_DAT register is only DATA[7:0] bits; if the write data length is 16-bit mode, the valid data in CRC_DAT register is only DATA[15:0]
 * |[31:30] |CRCMODE   |CRC Polynomial Mode
 * |        |          |This field indicates the CRC operation polynomial mode.
 * |        |          |00 = CRC-CCITT Polynomial mode.
 * |        |          |01 = CRC-8 Polynomial mode.
 * |        |          |10 = CRC-16 Polynomial mode.
 * |        |          |11 = CRC-32 Polynomial mode.
 * @var CRC_T::DAT
 * Offset: 0x04  CRC Write Data Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[31:0]  |DATA      |CRC Write Data Bits
 * |        |          |User can write data directly by CPU mode or use PDMA function to write data to this field to perform CRC operation.
 * |        |          |Note: When the write data length is 8-bit mode, the valid data in CRC_DAT register is only DATA[7:0] bits; if the write data length is 16-bit mode, the valid data in CRC_DAT register is only DATA[15:0].
 * @var CRC_T::SEED
 * Offset: 0x08  CRC Seed Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[31:0]  |SEED      |CRC Seed Value
 * |        |          |This field indicates the CRC seed value.
 * @var CRC_T::CHECKSUM
 * Offset: 0x0C  CRC Checksum Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[31:0]  |CHECKSUM  |CRC Checksum Results
 * |        |          |This field indicates the CRC checksum result.
 */

    __IO uint32_t CTL;           /* Offset: 0x00  CRC Control Register                                               */
    __IO uint32_t DAT;           /* Offset: 0x04  CRC Write Data Register                                            */
    __IO uint32_t SEED;          /* Offset: 0x08  CRC Seed Register                                                  */
    __I  uint32_t CHECKSUM;      /* Offset: 0x0C  CRC Checksum Register                                              */

} CRC_T;



/**
    @addtogroup CRC_CONST CRC Bit Field Definition
    Constant Definitions for CRC Controller
@{ */

#define CRC_CTL_CRCEN_Pos                (0)                                               /*!< CRC_T::CTL: CRCEN Position                */
#define CRC_CTL_CRCEN_Msk                (0x1ul << CRC_CTL_CRCEN_Pos)                      /*!< CRC_T::CTL: CRCEN Mask                    */

#define CRC_CTL_CRCRST_Pos               (1)                                               /*!< CRC_T::CTL: CRCRST Position               */
#define CRC_CTL_CRCRST_Msk               (0x1ul << CRC_CTL_CRCRST_Pos)                     /*!< CRC_T::CTL: CRCRST Mask                   */

#define CRC_CTL_DATREV_Pos               (24)                                              /*!< CRC_T::CTL: DATREV Position               */
#define CRC_CTL_DATREV_Msk               (0x1ul << CRC_CTL_DATREV_Pos)                     /*!< CRC_T::CTL: DATREV Mask                   */

#define CRC_CTL_CHKSREV_Pos              (25)                                              /*!< CRC_T::CTL: CHKSREV Position              */
#define CRC_CTL_CHKSREV_Msk              (0x1ul << CRC_CTL_CHKSREV_Pos)                    /*!< CRC_T::CTL: CHKSREV Mask                  */

#define CRC_CTL_DATFMT_Pos               (26)                                              /*!< CRC_T::CTL: DATFMT Position               */
#define CRC_CTL_DATFMT_Msk               (0x1ul << CRC_CTL_DATFMT_Pos)                     /*!< CRC_T::CTL: DATFMT Mask                   */

#define CRC_CTL_CHKSFMT_Pos              (27)                                              /*!< CRC_T::CTL: CHKSFMT Position              */
#define CRC_CTL_CHKSFMT_Msk              (0x1ul << CRC_CTL_CHKSFMT_Pos)                    /*!< CRC_T::CTL: CHKSFMT Mask                  */

#define CRC_CTL_DATLEN_Pos               (28)                                              /*!< CRC_T::CTL: DATLEN Position               */
#define CRC_CTL_DATLEN_Msk               (0x3ul << CRC_CTL_DATLEN_Pos)                     /*!< CRC_T::CTL: DATLEN Mask                   */

#define CRC_CTL_CRCMODE_Pos              (30)                                              /*!< CRC_T::CTL: CRCMODE Position              */
#define CRC_CTL_CRCMODE_Msk              (0x3ul << CRC_CTL_CRCMODE_Pos)                    /*!< CRC_T::CTL: CRCMODE Mask                  */

#define CRC_DAT_DATA_Pos                 (0)                                               /*!< CRC_T::DAT: DATA Position                 */
#define CRC_DAT_DATA_Msk                 (0xfffffffful << CRC_DAT_DATA_Pos)                /*!< CRC_T::DAT: DATA Mask                     */

#define CRC_SEED_SEED_Pos                (0)                                               /*!< CRC_T::SEED: SEED Position                */
#define CRC_SEED_SEED_Msk                (0xfffffffful << CRC_SEED_SEED_Pos)               /*!< CRC_T::SEED: SEED Mask                    */

#define CRC_CHECKSUM_CHECKSUM_Pos        (0)                                               /*!< CRC_T::CHECKSUM: CHECKSUM Position        */
#define CRC_CHECKSUM_CHECKSUM_Msk        (0xfffffffful << CRC_CHECKSUM_CHECKSUM_Pos)       /*!< CRC_T::CHECKSUM: CHECKSUM Mask            */

/**@}*/ /* CRC_CONST */
/**@}*/ /* end of CRC register group */


/*---------------------- Digital to Analog Converter -------------------------*/
/**
    @addtogroup DAC Digital to Analog Converter(DAC)
    Memory Mapped Structure for DAC Controller
@{ */


typedef struct
{



/**
 * @var DAC_T::CTL
 * Offset: 0x00  DAC Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |DACEN     |DAC Enable Bit
 * |        |          |0 = DAC is Disabled.
 * |        |          |1 = DAC is Enabled.
 * |[1]     |DACIEN    |DAC Interrupt Enable Bit
 * |        |          |0 = Interrupt is Disabled.
 * |        |          |1 = Interrupt is Enabled.
 * |[2]     |DMAEN     |DMA Mode Enable Bit
 * |        |          |0 = DMA mode Disabled.
 * |        |          |1 = DMA mode Enabled.
 * |[3]     |DMAURIEN  |DMA Under-Run Interrupt Enable Bit
 * |        |          |0 = DMA under run interrupt Disabled.
 * |        |          |1 = DMA under run interrupt Enabled.
 * |[4]     |TRGEN     |Trigger Mode Enable Bit
 * |        |          |0 = DAC event trigger mode Disabled.
 * |        |          |1 = DAC event trigger mode Enabled.
 * |[7:5]   |TRGSEL    |Trigger Source Selection
 * |        |          |000 = Software trigger.
 * |        |          |001 = External pin STDAC trigger.
 * |        |          |010 = Timer 0 trigger.
 * |        |          |011 = Timer 1 trigger.
 * |        |          |100 = Timer 2 trigger.
 * |        |          |101 = Timer 3 trigger.
 * |        |          |110 = PWM0 trigger.
 * |        |          |111 = PWM1 trigger.
 * |[8]     |BYPASS    |Bypass Buffer Mode
 * |        |          |0 = Output voltage buffer Enabled.
 * |        |          |1 = Output voltage buffer Disabled.
 * |[10]    |LALIGN    |DAC Data Left-Aligned Enabled Control
 * |        |          |0 = Right alignment.
 * |        |          |1 = Left alignment.
 * |[13:12] |ETRGSEL   |External Pin Trigger Selection
 * |        |          |00 = Low level trigger.
 * |        |          |01 = High level trigger.
 * |        |          |10 = Falling edge trigger.
 * |        |          |11 = Rising edge trigger.
 * @var DAC_T::SWTRG
 * Offset: 0x04  DAC Software Trigger Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |SWTRG     |Software Trigger
 * |        |          |0 = Software trigger Disabled.
 * |        |          |1 = Software trigger Enabled.
 * |        |          |User writes this bit to generate one shot pulse and it is cleared to 0 by hardware automatically; Reading this bit will always get 0.
 * @var DAC_T::DAT
 * Offset: 0x08  DAC Data Holding Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |DAC_DAT   |DAC 12-Bit Holding Data
 * |        |          |These bits are written by user software which specifies 12-bit conversion data for DAC output.
 * |        |          |The unused bits (DAC_DAT[3:0] in left-alignment mode and DAC_DAT[15:12] in right alignment mode) are ignored by DAC controller hardware.
 * |        |          |12 bit left alignment: user has to load data into DAC_DAT[15:4] bits.
 * |        |          |12 bit right alignment: user has to load data into DAC_DAT[11:0] bits.
 * @var DAC_T::DATOUT
 * Offset: 0x0C  DAC Data Output Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[11:0]  |DATOUT    |DAC 12-Bit Output Data
 * |        |          |These bits are current digital data for DAC output conversion.
 * |        |          |It is loaded from DAC_DAT register and user cannot write it directly.
 * @var DAC_T::STATUS
 * Offset: 0x10  DAC Status Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |FINISH    |DAC Conversion Complete Finish Flag
 * |        |          |0 = DAC is in conversion state.
 * |        |          |1 = DAC conversion finish.
 * |        |          |This bit set to 1 when conversion time counter counts to SETTLET.
 * |        |          |It is cleared to 0 when DAC starts a new conversion.
 * |        |          |User writes 1 to clear this bit to 0.
 * |[1]     |DMAUDR    |DMA Under Run Interrupt Flag
 * |        |          |0 = No DMA under-run error condition occurred.
 * |        |          |1 = DMA under-run error condition occurred.
 * |        |          |User writes 1 to clear this bit.
 * |[8]     |BUSY      |DAC Busy Flag (Read Only)
 * |        |          |0 = DAC is ready for next conversion.
 * |        |          |1 = DAC is busy in conversion.
 * |        |          |This is read only bit.
 * @var DAC_T::TCTL
 * Offset: 0x14  DAC Timing Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[9:0]   |SETTLET   |DAC Output Settling Time
 * |        |          |User software needs to write appropriate value to these bits to meet DAC conversion settling time base on PCLK (APB clock) speed.
 * |        |          |For example, DAC controller clock speed is 72MHz and DAC conversion setting time is 1 us, SETTLET value must be greater than 0x48.
 */

    __IO uint32_t CTL;           /* Offset: 0x00  DAC Control Register                                               */
    __IO uint32_t SWTRG;         /* Offset: 0x04  DAC Software Trigger Control Register                              */
    __IO uint32_t DAT;           /* Offset: 0x08  DAC Data Holding Register                                          */
    __I  uint32_t DATOUT;        /* Offset: 0x0C  DAC Data Output Register                                           */
    __IO uint32_t STATUS;        /* Offset: 0x10  DAC Status Register                                                */
    __IO uint32_t TCTL;          /* Offset: 0x14  DAC Timing Control Register                                        */

} DAC_T;



/**
    @addtogroup DAC_CONST DAC Bit Field Definition
    Constant Definitions for DAC Controller
@{ */

#define DAC_CTL_DACEN_Pos                (0)                                               /*!< DAC_T::CTL: DACEN Position                */
#define DAC_CTL_DACEN_Msk                (0x1ul << DAC_CTL_DACEN_Pos)                      /*!< DAC_T::CTL: DACEN Mask                    */

#define DAC_CTL_DACIEN_Pos               (1)                                               /*!< DAC_T::CTL: DACIEN Position               */
#define DAC_CTL_DACIEN_Msk               (0x1ul << DAC_CTL_DACIEN_Pos)                     /*!< DAC_T::CTL: DACIEN Mask                   */

#define DAC_CTL_DMAEN_Pos                (2)                                               /*!< DAC_T::CTL: DMAEN Position                */
#define DAC_CTL_DMAEN_Msk                (0x1ul << DAC_CTL_DMAEN_Pos)                      /*!< DAC_T::CTL: DMAEN Mask                    */

#define DAC_CTL_DMAURIEN_Pos             (3)                                               /*!< DAC_T::CTL: DMAURIEN Position             */
#define DAC_CTL_DMAURIEN_Msk             (0x1ul << DAC_CTL_DMAURIEN_Pos)                   /*!< DAC_T::CTL: DMAURIEN Mask                 */

#define DAC_CTL_TRGEN_Pos                (4)                                               /*!< DAC_T::CTL: TRGEN Position                */
#define DAC_CTL_TRGEN_Msk                (0x1ul << DAC_CTL_TRGEN_Pos)                      /*!< DAC_T::CTL: TRGEN Mask                    */

#define DAC_CTL_TRGSEL_Pos               (5)                                               /*!< DAC_T::CTL: TRGSEL Position               */
#define DAC_CTL_TRGSEL_Msk               (0x7ul << DAC_CTL_TRGSEL_Pos)                     /*!< DAC_T::CTL: TRGSEL Mask                   */

#define DAC_CTL_BYPASS_Pos               (8)                                               /*!< DAC_T::CTL: BYPASS Position               */
#define DAC_CTL_BYPASS_Msk               (0x1ul << DAC_CTL_BYPASS_Pos)                     /*!< DAC_T::CTL: BYPASS Mask                   */

#define DAC_CTL_LALIGN_Pos               (10)                                              /*!< DAC_T::CTL: LALIGN Position               */
#define DAC_CTL_LALIGN_Msk               (0x1ul << DAC_CTL_LALIGN_Pos)                     /*!< DAC_T::CTL: LALIGN Mask                   */

#define DAC_CTL_ETRGSEL_Pos              (12)                                              /*!< DAC_T::CTL: ETRGSEL Position              */
#define DAC_CTL_ETRGSEL_Msk              (0x3ul << DAC_CTL_ETRGSEL_Pos)                    /*!< DAC_T::CTL: ETRGSEL Mask                  */

#define DAC_SWTRG_SWTRG_Pos              (0)                                               /*!< DAC_T::SWTRG: SWTRG Position              */
#define DAC_SWTRG_SWTRG_Msk              (0x1ul << DAC_SWTRG_SWTRG_Pos)                    /*!< DAC_T::SWTRG: SWTRG Mask                  */

#define DAC_DAT_DAC_DAT_Pos              (0)                                               /*!< DAC_T::DAT: DAC_DAT Position              */
#define DAC_DAT_DAC_DAT_Msk              (0xfffful << DAC_DAT_DAC_DAT_Pos)                 /*!< DAC_T::DAT: DAC_DAT Mask                  */

#define DAC_DATOUT_DATOUT_Pos            (0)                                               /*!< DAC_T::DATOUT: DATOUT Position            */
#define DAC_DATOUT_DATOUT_Msk            (0xffful << DAC_DATOUT_DATOUT_Pos)                /*!< DAC_T::DATOUT: DATOUT Mask                */

#define DAC_STATUS_FINISH_Pos            (0)                                               /*!< DAC_T::STATUS: FINISH Position            */
#define DAC_STATUS_FINISH_Msk            (0x1ul << DAC_STATUS_FINISH_Pos)                  /*!< DAC_T::STATUS: FINISH Mask                */

#define DAC_STATUS_DMAUDR_Pos            (1)                                               /*!< DAC_T::STATUS: DMAUDR Position            */
#define DAC_STATUS_DMAUDR_Msk            (0x1ul << DAC_STATUS_DMAUDR_Pos)                  /*!< DAC_T::STATUS: DMAUDR Mask                */

#define DAC_STATUS_BUSY_Pos              (8)                                               /*!< DAC_T::STATUS: BUSY Position              */
#define DAC_STATUS_BUSY_Msk              (0x1ul << DAC_STATUS_BUSY_Pos)                    /*!< DAC_T::STATUS: BUSY Mask                  */

#define DAC_TCTL_SETTLET_Pos             (0)                                               /*!< DAC_T::TCTL: SETTLET Position             */
#define DAC_TCTL_SETTLET_Msk             (0x3fful << DAC_TCTL_SETTLET_Pos)                 /*!< DAC_T::TCTL: SETTLET Mask                 */

/**@}*/ /* DAC_CONST */
/**@}*/ /* end of DAC register group */


/*---------------------- External Bus Interface Controller -------------------------*/
/**
    @addtogroup EBI External Bus Interface Controller(EBI)
    Memory Mapped Structure for EBI Controller
@{ */


typedef struct
{




/**
 * @var EBI_T::CTL0
 * Offset: 0x00  External Bus Interface Bank0 Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |EN        |EBI Enable Bit
 * |        |          |This bit is the functional enable bit for EBI.
 * |        |          |0 = EBI function Disabled.
 * |        |          |1 = EBI function Enabled.
 * |[1]     |DW16      |EBI Data Width 16-Bit Select
 * |        |          |This bit defines if the EBI data width is 8-bit or 16-bit.
 * |        |          |0 = EBI data width is 8-bit.
 * |        |          |1 = EBI data width is 16-bit.
 * |[2]     |CSPOLINV  |Chip Select Pin Polar Inverse
 * |        |          |This bit defines the active level of EBI chip select pin (EBI_nCS).
 * |        |          |0 = Chip select pin (EBI_nCS) is active low.
 * |        |          |1 = Chip select pin (EBI_nCS) is active high.
 * |[10:8]  |MCLKDIV   |External Output Clock Divider
 * |        |          |The frequency of EBI output clock (MCLK) is controlled by MCLKDIV as follow:
 * |        |          |000 = HCLK/1.
 * |        |          |001 = HCLK/2.
 * |        |          |010 = HCLK/4.
 * |        |          |011 = HCLK/8.
 * |        |          |100 = HCLK/16.
 * |        |          |101 = HCLK/32.
 * |        |          |110 = Reserved.
 * |        |          |111 = Reserved.
 * |[18:16] |TALE      |Extend Time Of ALE
 * |        |          |The EBI_ALE high pulse period (tALE) to latch the address can be controlled by TALE.
 * |        |          |tALE = (TALE+1)*EBI_MCLK.
 * |        |          |Note: This field only available in EBI_CTL0 register
 * |[24]    |WBUFEN    |EBI Write Buffer Enable Bit
 * |        |          |0 = EBI write buffer Disabled.
 * |        |          |1 = EBI write buffer Enabled.
 * |        |          |Note: This bit only available in EBI_CTL0 register
 * @var EBI_T::TCTL0
 * Offset: 0x04  External Bus Interface Bank0 Timing Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[7:3]   |TACC      |EBI Data Access Time
 * |        |          |TACC define data access time (tACC).
 * |        |          |tACC = (TACC +1) * EBI_MCLK.
 * |[10:8]  |TAHD      |EBI Data Access Hold Time
 * |        |          |TAHD define data access hold time (tAHD).
 * |        |          |tAHD = (TAHD +1) * EBI_MCLK.
 * |[15:12] |W2X       |Idle Cycle After Write
 * |        |          |This field defines the number of W2X idle cycle.
 * |        |          |W2X idle cycle = (W2X * EBI_MCLK).
 * |        |          |When write action is finish, W2X idle cycle is inserted and EBI_nCS return to idle state.
 * |[22]    |RAHDOFF   |Access Hold Time Disable Control When Read
 * |        |          |0 = The Data Access Hold Time (tAHD) during EBI reading is Enabled.
 * |        |          |1 = The Data Access Hold Time (tAHD) during EBI reading is Disabled.
 * |[23]    |WAHDOFF   |Access Hold Time Disable Control When Write
 * |        |          |0 = The Data Access Hold Time (tAHD) during EBI writing is Enabled.
 * |        |          |1 = The Data Access Hold Time (tAHD) during EBI writing is Disabled.
 * |[27:24] |R2R       |Idle Cycle Between Read-To-Read
 * |        |          |This field defines the number of R2R idle cycle.
 * |        |          |R2R idle cycle = (R2R * EBI_MCLK).
 * |        |          |When read action is finish and next action is going to read, R2R idle cycle is inserted and EBI_nCS return to idle state.
 * @var EBI_T::CTL1
 * Offset: 0x10  External Bus Interface Bank1 Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |EN        |EBI Enable Bit
 * |        |          |This bit is the functional enable bit for EBI.
 * |        |          |0 = EBI function Disabled.
 * |        |          |1 = EBI function Enabled.
 * |[1]     |DW16      |EBI Data Width 16-Bit Select
 * |        |          |This bit defines if the EBI data width is 8-bit or 16-bit.
 * |        |          |0 = EBI data width is 8-bit.
 * |        |          |1 = EBI data width is 16-bit.
 * |[2]     |CSPOLINV  |Chip Select Pin Polar Inverse
 * |        |          |This bit defines the active level of EBI chip select pin (EBI_nCS).
 * |        |          |0 = Chip select pin (EBI_nCS) is active low.
 * |        |          |1 = Chip select pin (EBI_nCS) is active high.
 * |[10:8]  |MCLKDIV   |External Output Clock Divider
 * |        |          |The frequency of EBI output clock (MCLK) is controlled by MCLKDIV as follow:
 * |        |          |000 = HCLK/1.
 * |        |          |001 = HCLK/2.
 * |        |          |010 = HCLK/4.
 * |        |          |011 = HCLK/8.
 * |        |          |100 = HCLK/16.
 * |        |          |101 = HCLK/32.
 * |        |          |110 = Reserved.
 * |        |          |111 = Reserved.
 * |[18:16] |TALE      |Extend Time Of ALE
 * |        |          |The EBI_ALE high pulse period (tALE) to latch the address can be controlled by TALE.
 * |        |          |tALE = (TALE+1)*EBI_MCLK.
 * |        |          |Note: This field only available in EBI_CTL0 register
 * |[24]    |WBUFEN    |EBI Write Buffer Enable Bit
 * |        |          |0 = EBI write buffer Disabled.
 * |        |          |1 = EBI write buffer Enabled.
 * |        |          |Note: This bit only available in EBI_CTL0 register
 * @var EBI_T::TCTL1
 * Offset: 0x14  External Bus Interface Bank1 Timing Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[7:3]   |TACC      |EBI Data Access Time
 * |        |          |TACC define data access time (tACC).
 * |        |          |tACC = (TACC +1) * EBI_MCLK.
 * |[10:8]  |TAHD      |EBI Data Access Hold Time
 * |        |          |TAHD define data access hold time (tAHD).
 * |        |          |tAHD = (TAHD +1) * EBI_MCLK.
 * |[15:12] |W2X       |Idle Cycle After Write
 * |        |          |This field defines the number of W2X idle cycle.
 * |        |          |W2X idle cycle = (W2X * EBI_MCLK).
 * |        |          |When write action is finish, W2X idle cycle is inserted and EBI_nCS return to idle state.
 * |[22]    |RAHDOFF   |Access Hold Time Disable Control When Read
 * |        |          |0 = The Data Access Hold Time (tAHD) during EBI reading is Enabled.
 * |        |          |1 = The Data Access Hold Time (tAHD) during EBI reading is Disabled.
 * |[23]    |WAHDOFF   |Access Hold Time Disable Control When Write
 * |        |          |0 = The Data Access Hold Time (tAHD) during EBI writing is Enabled.
 * |        |          |1 = The Data Access Hold Time (tAHD) during EBI writing is Disabled.
 * |[27:24] |R2R       |Idle Cycle Between Read-To-Read
 * |        |          |This field defines the number of R2R idle cycle.
 * |        |          |R2R idle cycle = (R2R * EBI_MCLK).
 * |        |          |When read action is finish and next action is going to read, R2R idle cycle is inserted and EBI_nCS return to idle state.
 */

    __IO uint32_t CTL0;          /* Offset: 0x00  External Bus Interface Bank0 Control Register                      */
    __IO uint32_t TCTL0;         /* Offset: 0x04  External Bus Interface Bank0 Timing Control Register               */
    __I  uint32_t RESERVE0[2];  
    __IO uint32_t CTL1;          /* Offset: 0x10  External Bus Interface Bank1 Control Register                      */
    __IO uint32_t TCTL1;         /* Offset: 0x14  External Bus Interface Bank1 Timing Control Register               */

} EBI_T;



/**
    @addtogroup EBI_CONST EBI Bit Field Definition
    Constant Definitions for EBI Controller
@{ */

#define EBI_CTL0_EN_Pos                  (0)                                               /*!< EBI_T::CTL0: EN Position                  */
#define EBI_CTL0_EN_Msk                  (0x1ul << EBI_CTL0_EN_Pos)                        /*!< EBI_T::CTL0: EN Mask                      */

#define EBI_CTL0_DW16_Pos                (1)                                               /*!< EBI_T::CTL0: DW16 Position                */
#define EBI_CTL0_DW16_Msk                (0x1ul << EBI_CTL0_DW16_Pos)                      /*!< EBI_T::CTL0: DW16 Mask                    */

#define EBI_CTL0_CSPOLINV_Pos            (2)                                               /*!< EBI_T::CTL0: CSPOLINV Position            */
#define EBI_CTL0_CSPOLINV_Msk            (0x1ul << EBI_CTL0_CSPOLINV_Pos)                  /*!< EBI_T::CTL0: CSPOLINV Mask                */

#define EBI_CTL0_MCLKDIV_Pos             (8)                                               /*!< EBI_T::CTL0: MCLKDIV Position             */
#define EBI_CTL0_MCLKDIV_Msk             (0x7ul << EBI_CTL0_MCLKDIV_Pos)                   /*!< EBI_T::CTL0: MCLKDIV Mask                 */

#define EBI_CTL0_TALE_Pos                (16)                                              /*!< EBI_T::CTL0: TALE Position                */
#define EBI_CTL0_TALE_Msk                (0x7ul << EBI_CTL0_TALE_Pos)                      /*!< EBI_T::CTL0: TALE Mask                    */

#define EBI_CTL0_WBUFEN_Pos              (24)                                              /*!< EBI_T::CTL0: WBUFEN Position              */
#define EBI_CTL0_WBUFEN_Msk              (0x1ul << EBI_CTL0_WBUFEN_Pos)                    /*!< EBI_T::CTL0: WBUFEN Mask                  */

#define EBI_TCTL0_TACC_Pos               (3)                                               /*!< EBI_T::TCTL0: TACC Position               */
#define EBI_TCTL0_TACC_Msk               (0x1ful << EBI_TCTL0_TACC_Pos)                    /*!< EBI_T::TCTL0: TACC Mask                   */

#define EBI_TCTL0_TAHD_Pos               (8)                                               /*!< EBI_T::TCTL0: TAHD Position               */
#define EBI_TCTL0_TAHD_Msk               (0x7ul << EBI_TCTL0_TAHD_Pos)                     /*!< EBI_T::TCTL0: TAHD Mask                   */

#define EBI_TCTL0_W2X_Pos                (12)                                              /*!< EBI_T::TCTL0: W2X Position                */
#define EBI_TCTL0_W2X_Msk                (0xful << EBI_TCTL0_W2X_Pos)                      /*!< EBI_T::TCTL0: W2X Mask                    */

#define EBI_TCTL0_RAHDOFF_Pos            (22)                                              /*!< EBI_T::TCTL0: RAHDOFF Position            */
#define EBI_TCTL0_RAHDOFF_Msk            (0x1ul << EBI_TCTL0_RAHDOFF_Pos)                  /*!< EBI_T::TCTL0: RAHDOFF Mask                */

#define EBI_TCTL0_WAHDOFF_Pos            (23)                                              /*!< EBI_T::TCTL0: WAHDOFF Position            */
#define EBI_TCTL0_WAHDOFF_Msk            (0x1ul << EBI_TCTL0_WAHDOFF_Pos)                  /*!< EBI_T::TCTL0: WAHDOFF Mask                */

#define EBI_TCTL0_R2R_Pos                (24)                                              /*!< EBI_T::TCTL0: R2R Position                */
#define EBI_TCTL0_R2R_Msk                (0xful << EBI_TCTL0_R2R_Pos)                      /*!< EBI_T::TCTL0: R2R Mask                    */

#define EBI_CTL1_EN_Pos                  (0)                                               /*!< EBI_T::CTL1: EN Position                  */
#define EBI_CTL1_EN_Msk                  (0x1ul << EBI_CTL1_EN_Pos)                        /*!< EBI_T::CTL1: EN Mask                      */

#define EBI_CTL1_DW16_Pos                (1)                                               /*!< EBI_T::CTL1: DW16 Position                */
#define EBI_CTL1_DW16_Msk                (0x1ul << EBI_CTL1_DW16_Pos)                      /*!< EBI_T::CTL1: DW16 Mask                    */

#define EBI_CTL1_CSPOLINV_Pos            (2)                                               /*!< EBI_T::CTL1: CSPOLINV Position            */
#define EBI_CTL1_CSPOLINV_Msk            (0x1ul << EBI_CTL1_CSPOLINV_Pos)                  /*!< EBI_T::CTL1: CSPOLINV Mask                */

#define EBI_CTL1_MCLKDIV_Pos             (8)                                               /*!< EBI_T::CTL1: MCLKDIV Position             */
#define EBI_CTL1_MCLKDIV_Msk             (0x7ul << EBI_CTL1_MCLKDIV_Pos)                   /*!< EBI_T::CTL1: MCLKDIV Mask                 */

#define EBI_CTL1_TALE_Pos                (16)                                              /*!< EBI_T::CTL1: TALE Position                */
#define EBI_CTL1_TALE_Msk                (0x7ul << EBI_CTL1_TALE_Pos)                      /*!< EBI_T::CTL1: TALE Mask                    */

#define EBI_CTL1_WBUFEN_Pos              (24)                                              /*!< EBI_T::CTL1: WBUFEN Position              */
#define EBI_CTL1_WBUFEN_Msk              (0x1ul << EBI_CTL1_WBUFEN_Pos)                    /*!< EBI_T::CTL1: WBUFEN Mask                  */

#define EBI_TCTL1_TACC_Pos               (3)                                               /*!< EBI_T::TCTL1: TACC Position               */
#define EBI_TCTL1_TACC_Msk               (0x1ful << EBI_TCTL1_TACC_Pos)                    /*!< EBI_T::TCTL1: TACC Mask                   */

#define EBI_TCTL1_TAHD_Pos               (8)                                               /*!< EBI_T::TCTL1: TAHD Position               */
#define EBI_TCTL1_TAHD_Msk               (0x7ul << EBI_TCTL1_TAHD_Pos)                     /*!< EBI_T::TCTL1: TAHD Mask                   */

#define EBI_TCTL1_W2X_Pos                (12)                                              /*!< EBI_T::TCTL1: W2X Position                */
#define EBI_TCTL1_W2X_Msk                (0xful << EBI_TCTL1_W2X_Pos)                      /*!< EBI_T::TCTL1: W2X Mask                    */

#define EBI_TCTL1_RAHDOFF_Pos            (22)                                              /*!< EBI_T::TCTL1: RAHDOFF Position            */
#define EBI_TCTL1_RAHDOFF_Msk            (0x1ul << EBI_TCTL1_RAHDOFF_Pos)                  /*!< EBI_T::TCTL1: RAHDOFF Mask                */

#define EBI_TCTL1_WAHDOFF_Pos            (23)                                              /*!< EBI_T::TCTL1: WAHDOFF Position            */
#define EBI_TCTL1_WAHDOFF_Msk            (0x1ul << EBI_TCTL1_WAHDOFF_Pos)                  /*!< EBI_T::TCTL1: WAHDOFF Mask                */

#define EBI_TCTL1_R2R_Pos                (24)                                              /*!< EBI_T::TCTL1: R2R Position                */
#define EBI_TCTL1_R2R_Msk                (0xful << EBI_TCTL1_R2R_Pos)                      /*!< EBI_T::TCTL1: R2R Mask                    */

/**@}*/ /* EBI_CONST */
/**@}*/ /* end of EBI register group */


/*---------------------- Flash Memory Controller -------------------------*/
/**
    @addtogroup FMC Flash Memory Controller(FMC)
    Memory Mapped Structure for FMC Controller
@{ */


typedef struct
{




/**
 * @var FMC_T::ISPCTL
 * Offset: 0x00  ISP Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |ISPEN     |ISP Enable Bit (Write Protect)
 * |        |          |ISP function enable bit. Set this bit to enable ISP function.
 * |        |          |0 = ISP function Disabled.
 * |        |          |1 = ISP function Enabled.
 * |[1]     |BS        |Boot Select (Write Protect)
 * |        |          |When MBS in CONFIG0 is 1, set/clear this bit to select next booting from LDROM/APROM, respectively.
 * |        |          |This bit also functions as chip booting status flag, which can be used to check where chip booted from.
 * |        |          |This bit is initiated with the inverted value of CBS[1] (CONFIG0[7]) after any reset is happened except CPU reset (CPU is 1) or system reset (SYS) is happened.
 * |        |          |0 = Booting from APROM when MBS (CONFIG0[5]) is 1.
 * |        |          |1 = Booting from LDROM when MBS (CONFIG0[5]) is 1.
 * |[3]     |APUEN     |APROM Update Enable Bit (Write Protect)
 * |        |          |0 = APROM cannot be updated when the chip runs in APROM.
 * |        |          |1 = APROM can be updated when the chip runs in APROM.
 * |[4]     |CFGUEN    |CONFIG Update Enable Bit (Write Protect)
 * |        |          |0 = CONFIG cannot be updated.
 * |        |          |1 = CONFIG can be updated.
 * |[5]     |LDUEN     |LDROM Update Enable Bit (Write Protect)
 * |        |          |LDROM update enable bit.
 * |        |          |0 = LDROM cannot be updated.
 * |        |          |1 = LDROM can be updated.
 * |[6]     |ISPFF     |ISP Fail Flag (Write Protect)
 * |        |          |This bit is set by hardware when a triggered ISP meets any of the following conditions:
 * |        |          |This bit needs to be cleared by writing 1 to it.
 * |        |          |(1) APROM writes to itself if APUEN is set to 0.
 * |        |          |(2) LDROM writes to itself if LDUEN is set to 0.
 * |        |          |(3) CONFIG is erased/programmed if CFGUEN is set to 0.
 * |        |          |(4) SPROM is erased/programmed if SPUEN is set to 0
 * |        |          |(5) SPROM is programmed at SPROM secured mode.
 * |        |          |(6) Page Erase command at LOCK mode with ICE connection
 * |        |          |(7) Erase or Program command at brown-out detected
 * |        |          |(8) Destination address is illegal, such as over an available range.
 * |        |          |(9) Invalid ISP commands
 * |[16]    |BL        |Boot Loader Booting (Write Protect)
 * |        |          |This bit is initiated with the inverted value of MBS (CONFIG0[5]).
 * |        |          |Any reset, except CPU reset (CPU is 1) or system reset (SYS), BL will be reloaded.
 * |        |          |This bit is used to check chip boot from Boot Loader or not.
 * |        |          |User should keep original value of this bit when updating FMC_ISPCTL register.
 * |        |          |0 = Booting from APROM or LDROM.
 * |        |          |1 = Booting from Boot Loader.
 * @var FMC_T::ISPADDR
 * Offset: 0x04  ISP Address Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[31:0]  |ISPADDR   |ISP Address
 * |        |          |The NuMicro M451 series is equipped with embedded flash.
 * |        |          |ISPADDR[1:0] must be kept 00 for ISP 32-bit operation.
 * |        |          |ISPADDR[2:0] must be kept 000 for ISP 64-bit operation.
 * |        |          |For Checksum Calculation command, this field is the flash starting address for checksum calculation, 2 Kbytes alignment is necessary for checksum calculation.
 * @var FMC_T::ISPDAT
 * Offset: 0x08  ISP Data Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[31:0]  |ISPDAT    |ISP Data
 * |        |          |Write data to this register before ISP program operation.
 * |        |          |Read data from this register after ISP read operation.
 * |        |          |For Run Checksum Calculation command, ISPDAT is the memory size (byte) and 2 Kbytes alignment.
 * |        |          |For ISP Read Checksum command, ISPDAT is the checksum result.
 * |        |          |If ISPDAT = 0x0000_0000, it means that (1) the checksum calculation is in progress, (2) the memory range for checksum calculation is incorrect, or (3) all of data are 0.
 * @var FMC_T::ISPCMD
 * Offset: 0x0C  ISP CMD Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[6:0]   |CMD       |ISP CMD
 * |        |          |ISP command table is shown below:
 * |        |          |0x00= FLASH Read.
 * |        |          |0x04= Read Unique ID.
 * |        |          |0x0B= Read Company ID.
 * |        |          |0x0C= Read Device ID.
 * |        |          |0x0D= Read Checksum.
 * |        |          |0x21= FLASH 32-bit Program.
 * |        |          |0x22= FLASH Page Erase.
 * |        |          |0x27= FLASH Multi-Word Program.
 * |        |          |0x2D= Run Checksum Calculation.
 * |        |          |0x2E= Vector Remap.
 * |        |          |0x61= FLASH 64-bit Program.
 * |        |          |The other commands are invalid.
 * @var FMC_T::ISPTRG
 * Offset: 0x10  ISP Trigger Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |ISPGO     |ISP Start Trigger (Write Protect)
 * |        |          |Write 1 to start ISP operation and this bit will be cleared to 0 by hardware automatically when ISP operation is finished.
 * |        |          |0 = ISP operation is finished.
 * |        |          |1 = ISP is progressed.
 * @var FMC_T::DFBA
 * Offset: 0x14  Data Flash Base Address
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[31:0]  |DFBA      |Data Flash Base Address
 * |        |          |This register indicates Data Flash start address. It is a read only register.
 * |        |          |The Data Flash is shared with APROM. the content of this register is loaded from CONFIG1
 * |        |          |This register is valid when DFEN (CONFIG0[0]) =0 .
 * @var FMC_T::FTCTL
 * Offset: 0x18  Flash Access Time Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[6:4]   |FOM       |Frequency Optimization Mode (Write Protect)
 * |        |          |The NuMicro M451 series support adjustable flash access timing to optimize the flash access cycles in different working frequency.
 * |        |          |001 = Frequency <= 12MHz.
 * |        |          |010 = Frequency <= 36MHz.
 * |        |          |100 = Frequency <= 60MHz.
 * |        |          |Others = Frequency <= 72MHz.
 * @var FMC_T::ISPSTS
 * Offset: 0x40  ISP Status Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |ISPBUSY   |ISP Busy Flag (Read Only)
 * |        |          |Write 1 to start ISP operation and this bit will be cleared to 0 by hardware automatically when ISP operation is finished.
 * |        |          |This bit is the mirror of ISPGO(FMC_ISPTRG[0]).
 * |        |          |0 = ISP operation is finished.
 * |        |          |1 = ISP is progressed.
 * |[2:1]   |CBS       |Boot Selection Of CONFIG (Read Only)
 * |        |          |This bit is initiated with the CBS (CONFIG0[7:6]) after any reset is happened except CPU reset (CPU is 1) or system reset (SYS) is happened.
 * |        |          |The following function is valid when MBS (FMC_ISPSTS[3])= 1.
 * |        |          |00 = LDROM with IAP mode.
 * |        |          |01 = LDROM without IAP mode.
 * |        |          |10 = APROM with IAP mode.
 * |        |          |11 = APROM without IAP mode.
 * |[3]     |MBS       |Boot From Boot Loader Selection Flag (Read Only)
 * |        |          |This bit is initiated with the MBS (CONFIG0[5]) after any reset is happened except CPU reset (CPU is 1) or system reset (SYS) is happened
 * |        |          |0 = Booting from Boot Loader.
 * |        |          |1 = Booting
 * |        |          |from LDROM/APROM.(see CBS bit setting)
 * |[5]     |PGFF      |Flash Program With Fast Verification Flag (Read Only)
 * |        |          |This bit is set if data is mismatched at ISP programming verification.
 * |        |          |This bit is clear by performing ISP flash erase or ISP read CID operation.
 * |        |          |0 = Flash Program is success.
 * |        |          |1 = Flash Program is fail. Program data is different with data in the flash memory
 * |[6]     |ISPFF     |ISP Fail Flag (Write Protect)
 * |        |          |This bit is the mirror of ISPFF (FMC_ISPCTL[6]), it needs to be cleared by writing 1 to FMC_ISPCTL[6] or FMC_ISPSTS[6].
 * |        |          |This bit is set by hardware when a triggered ISP meets any of the following conditions:
 * |        |          |(1) APROM writes to itself if APUEN is set to 0.
 * |        |          |(2) LDROM writes to itself if LDUEN is set to 0.
 * |        |          |(3) CONFIG is erased/programmed if CFGUEN is set to 0.
 * |        |          |(4) SPROM is erased/programmed if SPUEN is set to 0
 * |        |          |(5) SPROM is programmed at SPROM secured mode.
 * |        |          |(6) Page Erase command at LOCK mode with ICE connection
 * |        |          |(7) Erase or Program command at brown-out detected
 * |        |          |(8) Destination address is illegal, such as over an available range.
 * |        |          |(9) Invalid ISP commands
 * |[23:9]  |VECMAP    |Vector Page Mapping Address (Read Only)
 * |        |          |All access to 0x0000_0000~0x0000_01FF is remapped to the flash memory address {VECMAP[14:0], 9'h000} ~ {VECMAP[14:0], 9'h1FF}
 * @var FMC_T::MPDAT0
 * Offset: 0x80  ISP Data0 Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[31:0]  |ISPDAT0   |ISP Data 0
 * |        |          |This register is the first 32-bit data for 32-bit/64-bit/multi-word programming, and it is also the mirror of FMC_ISPDAT, both registers keep the same data
 * @var FMC_T::MPDAT1
 * Offset: 0x84  ISP Data1 Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[31:0]  |ISPDAT1   |ISP Data 1
 * |        |          |This register is the second 32-bit data for 64-bit/multi-word programming.
 * @var FMC_T::MPDAT2
 * Offset: 0x88  ISP Data2 Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[31:0]  |ISPDAT2   |ISP Data 2
 * |        |          |This register is the third 32-bit data for multi-word programming.
 * @var FMC_T::MPDAT3
 * Offset: 0x8C  ISP Data3 Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[31:0]  |ISPDAT3   |ISP Data 3
 * |        |          |This register is the fourth 32-bit data for multi-word programming.
 * @var FMC_T::MPSTS
 * Offset: 0xC0  ISP Multi-Program Status Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |MPBUSY    |ISP Multi-Word Program Busy Flag (Read Only)
 * |        |          |Write 1 to start ISP Multi-Word program operation and this bit will be cleared to 0 by hardware automatically when ISP Multi-Word program operation is finished.
 * |        |          |This bit is the mirror of ISPGO(FMC_ISPTRG[0]).
 * |        |          |0 = ISP Multi-Word program operation is finished.
 * |        |          |1 = ISP Multi-Word program operation
 * |        |          |is progressed.
 * |[1]     |PPGO      |ISP Multi-Program Status (Read Only)
 * |        |          |0 = ISP multi-word program operation is not active.
 * |        |          |1 = ISP multi-word program operation is in progress.
 * |[2]     |ISPFF     |ISP Fail Flag (Read Only)
 * |        |          |This bit is the mirror of ISPFF (FMC_ISPCTL[6]), it needs to be cleared by writing 1 to FMC_ISPCTL[6] or FMC_ISPSTS[6].
 * |        |          |This bit is set by hardware when a triggered ISP meets any of the following conditions:
 * |        |          |(1) APROM writes to itself if APUEN is set to 0.
 * |        |          |(2) LDROM writes to itself if LDUEN is set to 0.
 * |        |          |(3) CONFIG is erased/programmed if CFGUEN is set to 0.
 * |        |          |(4) SPROM is erased/programmed if SPUEN is set to 0
 * |        |          |(5) SPROM is programmed at SPROM secured mode.
 * |        |          |(6) Page Erase command at LOCK mode with ICE connection
 * |        |          |(7) Erase or Program command at brown-out detected
 * |        |          |(8) Destination address is illegal, such as over an available range.
 * |        |          |(9) Invalid ISP commands
 * |[4]     |D0        |ISP DATA 0 Flag (Read Only)
 * |        |          |This bit is set when FMC_MPDAT0 is written and auto-clear to 0 when the FMC_MPDAT0 data is programmed to flash complete.
 * |        |          |0 = FMC_MPDAT0 register is empty, or program to flash complete.
 * |        |          |1 = FMC_MPDAT0 register has been written, and not program to flash complete.
 * |[5]     |D1        |ISP DATA 1 Flag (Read Only)
 * |        |          |This bit is set when FMC_MPDAT1 is written and auto-clear to 0 when the FMC_MPDAT1 data is programmed to flash complete.
 * |        |          |0 = FMC_MPDAT1 register is empty, or program to flash complete.
 * |        |          |1 = FMC_MPDAT1 register has been written, and not program to flash complete.
 * |[6]     |D2        |ISP DATA 2 Flag (Read Only)
 * |        |          |This bit is set when FMC_MPDAT2 is written and auto-clear to 0 when the FMC_MPDAT2 data is programmed to flash complete.
 * |        |          |0 = FMC_MPDAT2 register is empty, or program to flash complete.
 * |        |          |1 = FMC_MPDAT2 register has been written, and not program to flash complete.
 * |[7]     |D3        |ISP DATA 3 Flag (Read Only)
 * |        |          |This bit is set when FMC_MPDAT3 is written and auto-clear to 0 when the FMC_MPDAT3 data is programmed to flash complete.
 * |        |          |0 = FMC_MPDAT3 register is empty, or program to flash complete.
 * |        |          |1 = FMC_MPDAT3 register has been written, and not program to flash complete.
 * @var FMC_T::MPADDR
 * Offset: 0xC4  ISP Multi-Program Address Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[31:0]  |MPADDR    |ISP Multi-Word Program Address
 * |        |          |MPADDR is the address of ISP multi-word program operation when ISPGO flag is 1.
 * |        |          |MPADDR will keep the final ISP address when ISP multi-word program is complete.
    */

    __IO uint32_t ISPCTL;        /* Offset: 0x00  ISP Control Register                                               */
    __IO uint32_t ISPADDR;       /* Offset: 0x04  ISP Address Register                                               */
    __IO uint32_t ISPDAT;        /* Offset: 0x08  ISP Data Register                                                  */
    __IO uint32_t ISPCMD;        /* Offset: 0x0C  ISP CMD Register                                                   */
    __IO uint32_t ISPTRG;        /* Offset: 0x10  ISP Trigger Control Register                                       */
    __I  uint32_t DFBA;          /* Offset: 0x14  Data Flash Base Address                                            */
    __IO uint32_t FTCTL;         /* Offset: 0x18  Flash Access Time Control Register                                 */
    __I  uint32_t RESERVE0[9];  
    __I  uint32_t ISPSTS;        /* Offset: 0x40  ISP Status Register                                                */
    __I  uint32_t RESERVE1[15]; 
    __IO uint32_t MPDAT0;        /* Offset: 0x80  ISP Data0 Register                                                 */
    __IO uint32_t MPDAT1;        /* Offset: 0x84  ISP Data1 Register                                                 */
    __IO uint32_t MPDAT2;        /* Offset: 0x88  ISP Data2 Register                                                 */
    __IO uint32_t MPDAT3;        /* Offset: 0x8C  ISP Data3 Register                                                 */
    __I  uint32_t RESERVE2[12]; 
    __I  uint32_t MPSTS;         /* Offset: 0xC0  ISP Multi-Program Status Register                                  */
    __I  uint32_t MPADDR;        /* Offset: 0xC4  ISP Multi-Program Address Register                                 */

} FMC_T;




/**
    @addtogroup FMC_CONST FMC Bit Field Definition
    Constant Definitions for FMC Controller
@{ */

#define FMC_ISPCTL_ISPEN_Pos             (0)                                               /*!< FMC_T::ISPCTL: ISPEN Position             */
#define FMC_ISPCTL_ISPEN_Msk             (0x1ul << FMC_ISPCTL_ISPEN_Pos)                   /*!< FMC_T::ISPCTL: ISPEN Mask                 */

#define FMC_ISPCTL_BS_Pos                (1)                                               /*!< FMC_T::ISPCTL: BS Position                */
#define FMC_ISPCTL_BS_Msk                (0x1ul << FMC_ISPCTL_BS_Pos)                      /*!< FMC_T::ISPCTL: BS Mask                    */

#define FMC_ISPCTL_APUEN_Pos             (3)                                               /*!< FMC_T::ISPCTL: APUEN Position             */
#define FMC_ISPCTL_APUEN_Msk             (0x1ul << FMC_ISPCTL_APUEN_Pos)                   /*!< FMC_T::ISPCTL: APUEN Mask                 */

#define FMC_ISPCTL_CFGUEN_Pos            (4)                                               /*!< FMC_T::ISPCTL: CFGUEN Position            */
#define FMC_ISPCTL_CFGUEN_Msk            (0x1ul << FMC_ISPCTL_CFGUEN_Pos)                  /*!< FMC_T::ISPCTL: CFGUEN Mask                */

#define FMC_ISPCTL_LDUEN_Pos             (5)                                               /*!< FMC_T::ISPCTL: LDUEN Position             */
#define FMC_ISPCTL_LDUEN_Msk             (0x1ul << FMC_ISPCTL_LDUEN_Pos)                   /*!< FMC_T::ISPCTL: LDUEN Mask                 */

#define FMC_ISPCTL_ISPFF_Pos             (6)                                               /*!< FMC_T::ISPCTL: ISPFF Position             */
#define FMC_ISPCTL_ISPFF_Msk             (0x1ul << FMC_ISPCTL_ISPFF_Pos)                   /*!< FMC_T::ISPCTL: ISPFF Mask                 */

#define FMC_ISPCTL_BL_Pos                (16)                                              /*!< FMC_T::ISPCTL: BL Position                */
#define FMC_ISPCTL_BL_Msk                (0x1ul << FMC_ISPCTL_BL_Pos)                      /*!< FMC_T::ISPCTL: BL Mask                    */

#define FMC_ISPADDR_ISPADDR_Pos          (0)                                               /*!< FMC_T::ISPADDR: ISPADDR Position          */
#define FMC_ISPADDR_ISPADDR_Msk          (0xfffffffful << FMC_ISPADDR_ISPADDR_Pos)         /*!< FMC_T::ISPADDR: ISPADDR Mask              */

#define FMC_ISPDAT_ISPDAT_Pos            (0)                                               /*!< FMC_T::ISPDAT: ISPDAT Position            */
#define FMC_ISPDAT_ISPDAT_Msk            (0xfffffffful << FMC_ISPDAT_ISPDAT_Pos)           /*!< FMC_T::ISPDAT: ISPDAT Mask                */

#define FMC_ISPCMD_CMD_Pos               (0)                                               /*!< FMC_T::ISPCMD: CMD Position               */
#define FMC_ISPCMD_CMD_Msk               (0x7ful << FMC_ISPCMD_CMD_Pos)                    /*!< FMC_T::ISPCMD: CMD Mask                   */

#define FMC_ISPTRG_ISPGO_Pos             (0)                                               /*!< FMC_T::ISPTRG: ISPGO Position             */
#define FMC_ISPTRG_ISPGO_Msk             (0x1ul << FMC_ISPTRG_ISPGO_Pos)                   /*!< FMC_T::ISPTRG: ISPGO Mask                 */

#define FMC_DFBA_DFBA_Pos                (0)                                               /*!< FMC_T::DFBA: DFBA Position                */
#define FMC_DFBA_DFBA_Msk                (0xfffffffful << FMC_DFBA_DFBA_Pos)               /*!< FMC_T::DFBA: DFBA Mask                    */

#define FMC_FTCTL_FOM_Pos                (4)                                               /*!< FMC_T::FTCTL: FOM Position                */
#define FMC_FTCTL_FOM_Msk                (0x7ul << FMC_FTCTL_FOM_Pos)                      /*!< FMC_T::FTCTL: FOM Mask                    */

#define FMC_ISPSTS_ISPBUSY_Pos           (0)                                               /*!< FMC_T::ISPSTS: ISPBUSY Position           */
#define FMC_ISPSTS_ISPBUSY_Msk           (0x1ul << FMC_ISPSTS_ISPBUSY_Pos)                 /*!< FMC_T::ISPSTS: ISPBUSY Mask               */

#define FMC_ISPSTS_CBS_Pos               (1)                                               /*!< FMC_T::ISPSTS: CBS Position               */
#define FMC_ISPSTS_CBS_Msk               (0x3ul << FMC_ISPSTS_CBS_Pos)                     /*!< FMC_T::ISPSTS: CBS Mask                   */

#define FMC_ISPSTS_MBS_Pos               (3)                                               /*!< FMC_T::ISPSTS: MBS Position               */
#define FMC_ISPSTS_MBS_Msk               (0x1ul << FMC_ISPSTS_MBS_Pos)                     /*!< FMC_T::ISPSTS: MBS Mask                   */

#define FMC_ISPSTS_PGFF_Pos              (5)                                               /*!< FMC_T::ISPSTS: PGFF Position              */
#define FMC_ISPSTS_PGFF_Msk              (0x1ul << FMC_ISPSTS_PGFF_Pos)                    /*!< FMC_T::ISPSTS: PGFF Mask                  */

#define FMC_ISPSTS_ISPFF_Pos             (6)                                               /*!< FMC_T::ISPSTS: ISPFF Position             */
#define FMC_ISPSTS_ISPFF_Msk             (0x1ul << FMC_ISPSTS_ISPFF_Pos)                   /*!< FMC_T::ISPSTS: ISPFF Mask                 */

#define FMC_ISPSTS_VECMAP_Pos            (9)                                               /*!< FMC_T::ISPSTS: VECMAP Position            */
#define FMC_ISPSTS_VECMAP_Msk            (0x7ffful << FMC_ISPSTS_VECMAP_Pos)               /*!< FMC_T::ISPSTS: VECMAP Mask                */

#define FMC_MPDAT0_ISPDAT0_Pos           (0)                                               /*!< FMC_T::MPDAT0: ISPDAT0 Position           */
#define FMC_MPDAT0_ISPDAT0_Msk           (0xfffffffful << FMC_MPDAT0_ISPDAT0_Pos)          /*!< FMC_T::MPDAT0: ISPDAT0 Mask               */

#define FMC_MPDAT1_ISPDAT1_Pos           (0)                                               /*!< FMC_T::MPDAT1: ISPDAT1 Position           */
#define FMC_MPDAT1_ISPDAT1_Msk           (0xfffffffful << FMC_MPDAT1_ISPDAT1_Pos)          /*!< FMC_T::MPDAT1: ISPDAT1 Mask               */

#define FMC_MPDAT2_ISPDAT2_Pos           (0)                                               /*!< FMC_T::MPDAT2: ISPDAT2 Position           */
#define FMC_MPDAT2_ISPDAT2_Msk           (0xfffffffful << FMC_MPDAT2_ISPDAT2_Pos)          /*!< FMC_T::MPDAT2: ISPDAT2 Mask               */

#define FMC_MPDAT3_ISPDAT3_Pos           (0)                                               /*!< FMC_T::MPDAT3: ISPDAT3 Position           */
#define FMC_MPDAT3_ISPDAT3_Msk           (0xfffffffful << FMC_MPDAT3_ISPDAT3_Pos)          /*!< FMC_T::MPDAT3: ISPDAT3 Mask               */

#define FMC_MPSTS_MPBUSY_Pos             (0)                                               /*!< FMC_T::MPSTS: MPBUSY Position             */
#define FMC_MPSTS_MPBUSY_Msk             (0x1ul << FMC_MPSTS_MPBUSY_Pos)                   /*!< FMC_T::MPSTS: MPBUSY Mask                 */

#define FMC_MPSTS_PPGO_Pos               (1)                                               /*!< FMC_T::MPSTS: PPGO Position               */
#define FMC_MPSTS_PPGO_Msk               (0x1ul << FMC_MPSTS_PPGO_Pos)                     /*!< FMC_T::MPSTS: PPGO Mask                   */

#define FMC_MPSTS_ISPFF_Pos              (2)                                               /*!< FMC_T::MPSTS: ISPFF Position              */
#define FMC_MPSTS_ISPFF_Msk              (0x1ul << FMC_MPSTS_ISPFF_Pos)                    /*!< FMC_T::MPSTS: ISPFF Mask                  */

#define FMC_MPSTS_D0_Pos                 (4)                                               /*!< FMC_T::MPSTS: D0 Position                 */
#define FMC_MPSTS_D0_Msk                 (0x1ul << FMC_MPSTS_D0_Pos)                       /*!< FMC_T::MPSTS: D0 Mask                     */

#define FMC_MPSTS_D1_Pos                 (5)                                               /*!< FMC_T::MPSTS: D1 Position                 */
#define FMC_MPSTS_D1_Msk                 (0x1ul << FMC_MPSTS_D1_Pos)                       /*!< FMC_T::MPSTS: D1 Mask                     */

#define FMC_MPSTS_D2_Pos                 (6)                                               /*!< FMC_T::MPSTS: D2 Position                 */
#define FMC_MPSTS_D2_Msk                 (0x1ul << FMC_MPSTS_D2_Pos)                       /*!< FMC_T::MPSTS: D2 Mask                     */

#define FMC_MPSTS_D3_Pos                 (7)                                               /*!< FMC_T::MPSTS: D3 Position                 */
#define FMC_MPSTS_D3_Msk                 (0x1ul << FMC_MPSTS_D3_Pos)                       /*!< FMC_T::MPSTS: D3 Mask                     */

#define FMC_MPADDR_MPADDR_Pos            (0)                                               /*!< FMC_T::MPADDR: MPADDR Position            */
#define FMC_MPADDR_MPADDR_Msk            (0xfffffffful << FMC_MPADDR_MPADDR_Pos)           /*!< FMC_T::MPADDR: MPADDR Mask                */

/**@}*/ /* FMC_CONST */
/**@}*/ /* end of FMC register group */


/*---------------------- General Purpose Input/Output Controller -------------------------*/
/**
    @addtogroup GPIO General Purpose Input/Output Controller(GPIO)
    Memory Mapped Structure for GPIO Controller
@{ */


typedef struct
{



/**
 * @var GPIO_T::MODE
 * Offset: 0x00/0x40/0x80/0xC0/0x100/0x140  Port A-F I/O Mode Control
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[2n+1:2n]|MODEn    |Port A-F I/O Pin[n] Mode Control
 * |        |          |Determine each I/O mode of Px.n pins.
 * |        |          |00 = Px.n is in Input mode.
 * |        |          |01 = Px.n is in Push-pull Output mode.
 * |        |          |10 = Px.n is in Open-drain Output mode.
 * |        |          |11 = Px.n is in Quasi-bidirectional mode.
 * |        |          |Note1: The initial value of this field is defined by CIOINI (CONFIG0 [10]).
 * |        |          |If CIOINI is set to 0, the default value is 0xFFFF_FFFF and all pins will be quasi-bidirectional mode after chip powered on.
 * |        |          |If CIOINI is set to 1, the default value is 0x0000_0000 and all pins will be
 * |        |          |input mode after chip powered on.
 * |        |          |Note2:
 * |        |          |n=0~15 for port A/B/C/D.
 * |        |          |n=0~14 for port E.
 * |        |          |n=0~7 for port F.
 * @var GPIO_T::DINOFF
 * Offset: 0x04/0x44/0x84/0xC4/0x104/0x144  Port A-F Digital Input Path Disable Control
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[n+16]  |DINOFFn   |Port A-F Pin[n] Digital Input Path Disable Control
 * |        |          |Each of these bits is used to control if the digital input path of corresponding Px.n pin is disabled.
 * |        |          |If input is analog signal, users can disable Px.n digital input path to avoid input current leakage.
 * |        |          |0 = Px.n digital input path Enabled.
 * |        |          |1 = Px.n digital input path Disabled (digital input tied to low).
 * |        |          |Note:
 * |        |          |n=0~15 for port A/B/C/D.
 * |        |          |n=0~14 for port E.
 * |        |          |n=0~7 for port F.
 * @var GPIO_T::DOUT
 * Offset: 0x08/0x48/0x88/0xC8/0x108/0x148  Port A-F Data Output Value
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[n]     |DOUTn     |Port A-F Pin[n] Output Value
 * |        |          |Each of these bits controls the status of a Px.n pin when the Px.n is configured as Push-pull output, Open-drain output or Quasi-bidirectional mode.
 * |        |          |0 = Px.n will drive Low if the Px.n pin is configured as Push-pull output, Open-drain output or Quasi-bidirectional mode.
 * |        |          |1 = Px.n will drive High if the Px.n pin is configured as Push-pull output or Quasi-bidirectional mode.
 * |        |          |Note:
 * |        |          |n=0~15 for port A/B/C/D.
 * |        |          |n=0~14 for port E.
 * |        |          |n=0~7 for port F.
 * @var GPIO_T::DATMSK
 * Offset: 0x0C/0x4C/0x8C/0xCC/0x10C/0x14C  Port A-F Data Output Write Mask
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[n]     |DMASKn    |Port A-F Pin[n] Data Output Write Mask
 * |        |          |These bits are used to protect the corresponding DOUT (Px_DOUT[n]) bit.
 * |        |          |When the DATMSK (Px_DATMSK[n]) bit is set to 1, the corresponding DOUT (Px_DOUT[n]) bit is protected.
 * |        |          |If the write signal is masked, writing data to the protect bit is ignored.
 * |        |          |0 = Corresponding DOUT (Px_DOUT[n]) bit can be updated.
 * |        |          |1 = Corresponding DOUT (Px_DOUT[n]) bit protected.
 * |        |          |Note1: This function only protects the corresponding DOUT (Px_DOUT[n]) bit, and will not protect the corresponding PDIO (Pxn_PDIO[0]) bit.
 * |        |          |Note2:
 * |        |          |n=0~15 for port A/B/C/D.
 * |        |          |n=0~14 for port E.
 * |        |          |n=0~7 for port F.
 * @var GPIO_T::PIN
 * Offset: 0x10/0x50/0x90/0xD0/0x110/0x150  Port A-F Pin Value
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[n]     |PINn      |Port A-F Pin[n] Pin Value
 * |        |          |Each bit of the register reflects the actual status of the respective Px.n pin.
 * |        |          |If the bit is 1, it indicates the corresponding pin status is high; else the pin status is low.
 * |        |          |Note:
 * |        |          |n=0~15 for port A/B/C/D.
 * |        |          |n=0~14 for port E.
 * |        |          |n=0~7 for port F.
 * @var GPIO_T::DBEN
 * Offset: 0x14/0x54/0x94/0xD4/0x114/0x154  Port A-F De-Bounce Enable Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[n]     |DBENn     |Port A-F Pin[n] Input Signal De-Bounce Enable Bit
 * |        |          |The DBEN[n] bit is used to enable the de-bounce function for each corresponding bit.
 * |        |          |If the input signal pulse width cannot be sampled by continuous two de-bounce sample cycle, the input signal transition is seen as the signal bounce and will not trigger the interrupt.
 * |        |          |The de-bounce clock source is controlled by DBCLKSRC (GPIO_DBCTL [4]), one de-bounce sample cycle period is controlled by DBCLKSEL (GPIO_DBCTL [3:0]).
 * |        |          |0 = Px.n de-bounce function Disabled.
 * |        |          |1 = Px.n de-bounce function Enabled.
 * |        |          |The de-bounce function is valid only for edge triggered interrupt.
 * |        |          |If the interrupt mode is level triggered, the de-bounce enable bit is ignored.
 * |        |          |Note:
 * |        |          |n=0~15 for port A/B/C/D.
 * |        |          |n=0~14 for port E.
 * |        |          |n=0~7 for port F.
 * @var GPIO_T::INTTYPE
 * Offset: 0x18/0x58/0x98/0xD8/0x118/0x158  Port A-F Interrupt Trigger Type Control
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[n]     |TYPEn     |Port A-F Pin[n] Edge Or Level Detection Interrupt Trigger Type Control
 * |        |          |TYPE (Px_INTTYPE[n]) bit is used to control the triggered interrupt is by level trigger or by edge trigger.
 * |        |          |If the interrupt is by edge trigger, the trigger source can be controlled by de-bounce.
 * |        |          |If the interrupt is by level trigger, the input source is sampled by one HCLK clock and generates the interrupt.
 * |        |          |0 = Edge trigger interrupt.
 * |        |          |1 = Level trigger interrupt.
 * |        |          |If the pin is set as the level trigger interrupt, only one level can be set on the registers RHIEN (Px_INTEN[n+16])/FLIEN (Px_INTEN[n]).
 * |        |          |If both levels to trigger interrupt are set, the setting is ignored and no interrupt will occur.
 * |        |          |The de-bounce function is valid only for edge triggered interrupt.
 * |        |          |If the interrupt mode is level triggered, the de-bounce enable bit is ignored.
 * |        |          |Note:
 * |        |          |n=0~15 for port A/B/C/D.
 * |        |          |n=0~14 for port E.
 * |        |          |n=0~7 for port F.
 * @var GPIO_T::INTEN
 * Offset: 0x1C/0x5C/0x9C/0xDC/0x11C/0x15C  Port A-F Interrupt Enable Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[n]     |FLIENn    |Port A-F Pin[n] Falling Edge or Low Level Interrupt Trigger Type Enable Bit
 * |        |          |The FLIEN (Px_INTEN[n]) bit is used to enable the interrupt for each of the corresponding input Px.n pin.
 * |        |          |Set bit to 1 also enable the pin wake-up function.
 * |        |          |When setting the FLIEN (Px_INTEN[n]) bit to 1 :
 * |        |          |If the interrupt is level trigger (TYPE (Px_INTTYPE[n]) bit is set to 1), the input Px.n pin will generate the interrupt while this pin state is at low level.
 * |        |          |If the interrupt is edge trigger(TYPE (Px_INTTYPE[n]) bit is set to 0), the input Px.n pin will generate the interrupt while this pin state changed from high to low.
 * |        |          |0 = Px.n level low or high to low interrupt Disabled.
 * |        |          |1 = Px.n level low or high to low interrupt Enabled.
 * |        |          |Note:
 * |        |          |n=0~15 for port A/B/C/D.
 * |        |          |n=0~14 for port E.
 * |        |          |n=0~7 for port F.
 * @var GPIO_T::INTSRC
 * Offset: 0x20/0x60/0xA0/0xE0/0x120/0x160  Port A-F Interrupt Source Flag
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[n]     |INTSRCn   |Port A-F Pin[n] Interrupt Source Flag
 * |        |          |Write Operation :
 * |        |          |0 = No action.
 * |        |          |1 = Clear the corresponding pending interrupt.
 * |        |          |Read Operation :
 * |        |          |0 = No interrupt at Px.n.
 * |        |          |1 = Px.n generates an interrupt.
 * |        |          |Note:
 * |        |          |n=0~15 for port A/B/C/D.
 * |        |          |n=0~14 for port E.
 * |        |          |n=0~7 for port F.
 * @var GPIO_T::SMTEN
 * Offset: 0x24/0x64/0xA4/0xE4/0x124/0x164  Port A-F Input Schmitt Trigger Enable Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[n]     |SMTENn    |Port A-F Pin[n] Input Schmitt Trigger Enable Bit
 * |        |          |0 = Px.n input Schmitt trigger function Disabled.
 * |        |          |1 = Px.n input Schmitt trigger function Enabled.
 * |        |          |Note:
 * |        |          |n=0~15 for port A/B/C/D.
 * |        |          |n=0~14 for port E.
 * |        |          |n=0~7 for port F.
 * @var GPIO_T::SLEWCTL
 * Offset: 0x28/0x68/0xA8/0xE8/0x128/0x168  Port A-F High Slew Rate Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[n]     |HSRENn    |Port A-F Pin[n] High Slew Rate Control
 * |        |          |0 = Px.n output with basic slew rate.
 * |        |          |1 = Px.n output with higher slew rate.
 * |        |          |Note:
 * |        |          |n=0~15 for port A/B/C/D.
 * |        |          |n=0~14 for port E.
 * |        |          |n=0~7 for port F.
 * @var GPIO_T::DRVCTL
 * Offset: 0x2C  Port E High Drive Strength Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[n]     |HDRVENn   |Port E Pin[n] Driving Strength Control
 * |        |          |0 = Px.n output with basic driving strength.
 * |        |          |1 = Px.n output with high driving strength.
 * |        |          |Note:
 * |        |          |n=8,9..13 for port E.
 */

    __IO uint32_t MODE;          /* Offset: 0x00/0x40/0x80/0xC0/0x100/0x140  Port A-F I/O Mode Control                       */
    __IO uint32_t DINOFF;        /* Offset: 0x04/0x44/0x84/0xC4/0x104/0x144  Port A-F Digital Input Path Disable Control     */
    __IO uint32_t DOUT;          /* Offset: 0x08/0x48/0x88/0xC8/0x108/0x148  Port A-F Data Output Value                      */
    __IO uint32_t DATMSK;        /* Offset: 0x0C/0x4C/0x8C/0xCC/0x10C/0x14C  Port A-F Data Output Write Mask                 */
    __I  uint32_t PIN;           /* Offset: 0x10/0x50/0x90/0xD0/0x110/0x150  Port A-F Pin Value                              */
    __IO uint32_t DBEN;          /* Offset: 0x14/0x54/0x94/0xD4/0x114/0x154  Port A-F De-Bounce Enable Control Register      */
    __IO uint32_t INTTYPE;       /* Offset: 0x18/0x58/0x98/0xD8/0x118/0x158  Port A-F Interrupt Trigger Type Control         */
    __IO uint32_t INTEN;         /* Offset: 0x1C/0x5C/0x9C/0xDC/0x11C/0x15C  Port A-F Interrupt Enable Control Register      */
    __IO uint32_t INTSRC;        /* Offset: 0x20/0x60/0xA0/0xE0/0x120/0x160  Port A-F Interrupt Source Flag                  */
    __IO uint32_t SMTEN;         /* Offset: 0x24/0x64/0xA4/0xE4/0x124/0x164  Port A-F Input Schmitt Trigger Enable Register  */
    __IO uint32_t SLEWCTL;       /* Offset: 0x28/0x68/0xA8/0xE8/0x128/0x168  Port A-F High Slew Rate Control Register        */
    __IO uint32_t DRVCTL;        /* Offset: 0x12C  Port E High Drive Strength Control Register                               */

} GPIO_T;




typedef struct
{



/**
 * @var GPIO_DBCTL_T::DBCTL
 * Offset: 0x440  Interrupt De-bounce Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[3:0]   |DBCLKSEL  |De-Bounce Sampling Cycle Selection
 * |        |          |0000 = Sample interrupt input once per 1 clocks.
 * |        |          |0001 = Sample interrupt input once per 2 clocks.
 * |        |          |0010 = Sample interrupt input once per 4 clocks.
 * |        |          |0011 = Sample interrupt input once per 8 clocks.
 * |        |          |0100 = Sample interrupt input once per 16 clocks.
 * |        |          |0101 = Sample interrupt input once per 32 clocks.
 * |        |          |0110 = Sample interrupt input once per 64 clocks.
 * |        |          |0111 = Sample interrupt input once per 128 clocks.
 * |        |          |1000 = Sample interrupt input once per 256 clocks.
 * |        |          |1001 = Sample interrupt input once per 2*256 clocks.
 * |        |          |1010 = Sample interrupt input once per 4*256 clocks.
 * |        |          |1011 = Sample interrupt input once per 8*256 clocks.
 * |        |          |1100 = Sample interrupt input once per 16*256 clocks.
 * |        |          |1101 = Sample interrupt input once per 32*256 clocks.
 * |        |          |1110 = Sample interrupt input once per 64*256 clocks.
 * |        |          |1111 = Sample interrupt input once per 128*256 clocks.
 * |[4]     |DBCLKSRC  |De-Bounce Counter Clock Source Selection
 * |        |          |0 = De-bounce counter clock source is the HCLK.
 * |        |          |1 = De-bounce counter clock source is the internal 10 kHz internal low speed oscillator.
 * |[5]     |ICLKON    |Interrupt Clock On Mode
 * |        |          |0 = Edge detection circuit is active only if I/O pin corresponding RHIEN (Px_INTEN[n+16])/FLIEN (Px_INTEN[n]) bit is set to 1.
 * |        |          |1 = All I/O pins edge detection circuit is always active after reset.
 * |        |          |Note: It is recommended to disable this bit to save system power if no special application concern.
 */

    __IO uint32_t DBCTL;         /* Offset: 0x440  Interrupt De-bounce Control Register                              */

} GPIO_DBCTL_T;




/**
    @addtogroup GPIO_CONST GPIO Bit Field Definition
    Constant Definitions for GPIO Controller
@{ */

#define GPIO_MODE_MODE0_Pos              (0)                                               /*!< GPIO_T::MODE: MODE0 Position              */
#define GPIO_MODE_MODE0_Msk              (0x3ul << GPIO_MODE_MODE0_Pos)                    /*!< GPIO_T::MODE: MODE0 Mask                  */

#define GPIO_MODE_MODE1_Pos              (2)                                               /*!< GPIO_T::MODE: MODE1 Position              */
#define GPIO_MODE_MODE1_Msk              (0x3ul << GPIO_MODE_MODE1_Pos)                    /*!< GPIO_T::MODE: MODE1 Mask                  */

#define GPIO_MODE_MODE2_Pos              (4)                                               /*!< GPIO_T::MODE: MODE2 Position              */
#define GPIO_MODE_MODE2_Msk              (0x3ul << GPIO_MODE_MODE2_Pos)                    /*!< GPIO_T::MODE: MODE2 Mask                  */

#define GPIO_MODE_MODE3_Pos              (6)                                               /*!< GPIO_T::MODE: MODE3 Position              */
#define GPIO_MODE_MODE3_Msk              (0x3ul << GPIO_MODE_MODE3_Pos)                    /*!< GPIO_T::MODE: MODE3 Mask                  */

#define GPIO_MODE_MODE4_Pos              (8)                                               /*!< GPIO_T::MODE: MODE4 Position              */
#define GPIO_MODE_MODE4_Msk              (0x3ul << GPIO_MODE_MODE4_Pos)                    /*!< GPIO_T::MODE: MODE4 Mask                  */

#define GPIO_MODE_MODE5_Pos              (10)                                              /*!< GPIO_T::MODE: MODE5 Position              */
#define GPIO_MODE_MODE5_Msk              (0x3ul << GPIO_MODE_MODE5_Pos)                    /*!< GPIO_T::MODE: MODE5 Mask                  */

#define GPIO_MODE_MODE6_Pos              (12)                                              /*!< GPIO_T::MODE: MODE6 Position              */
#define GPIO_MODE_MODE6_Msk              (0x3ul << GPIO_MODE_MODE6_Pos)                    /*!< GPIO_T::MODE: MODE6 Mask                  */

#define GPIO_MODE_MODE7_Pos              (14)                                              /*!< GPIO_T::MODE: MODE7 Position              */
#define GPIO_MODE_MODE7_Msk              (0x3ul << GPIO_MODE_MODE7_Pos)                    /*!< GPIO_T::MODE: MODE7 Mask                  */

#define GPIO_MODE_MODE8_Pos              (16)                                              /*!< GPIO_T::MODE: MODE8 Position              */
#define GPIO_MODE_MODE8_Msk              (0x3ul << GPIO_MODE_MODE8_Pos)                    /*!< GPIO_T::MODE: MODE8 Mask                  */

#define GPIO_MODE_MODE9_Pos              (18)                                              /*!< GPIO_T::MODE: MODE9 Position              */
#define GPIO_MODE_MODE9_Msk              (0x3ul << GPIO_MODE_MODE9_Pos)                    /*!< GPIO_T::MODE: MODE9 Mask                  */

#define GPIO_MODE_MODE10_Pos             (20)                                              /*!< GPIO_T::MODE: MODE10 Position             */
#define GPIO_MODE_MODE10_Msk             (0x3ul << GPIO_MODE_MODE10_Pos)                   /*!< GPIO_T::MODE: MODE10 Mask                 */

#define GPIO_MODE_MODE11_Pos             (22)                                              /*!< GPIO_T::MODE: MODE11 Position             */
#define GPIO_MODE_MODE11_Msk             (0x3ul << GPIO_MODE_MODE11_Pos)                   /*!< GPIO_T::MODE: MODE11 Mask                 */

#define GPIO_MODE_MODE12_Pos             (24)                                              /*!< GPIO_T::MODE: MODE12 Position             */
#define GPIO_MODE_MODE12_Msk             (0x3ul << GPIO_MODE_MODE12_Pos)                   /*!< GPIO_T::MODE: MODE12 Mask                 */

#define GPIO_MODE_MODE13_Pos             (26)                                              /*!< GPIO_T::MODE: MODE13 Position             */
#define GPIO_MODE_MODE13_Msk             (0x3ul << GPIO_MODE_MODE13_Pos)                   /*!< GPIO_T::MODE: MODE13 Mask                 */

#define GPIO_MODE_MODE14_Pos             (28)                                              /*!< GPIO_T::MODE: MODE14 Position             */
#define GPIO_MODE_MODE14_Msk             (0x3ul << GPIO_MODE_MODE14_Pos)                   /*!< GPIO_T::MODE: MODE14 Mask                 */

#define GPIO_MODE_MODE15_Pos             (30)                                              /*!< GPIO_T::MODE: MODE15 Position             */
#define GPIO_MODE_MODE15_Msk             (0x3ul << GPIO_MODE_MODE15_Pos)                   /*!< GPIO_T::MODE: MODE15 Mask                 */

#define GPIO_DINOFF_DINOFF0_Pos          (16)                                              /*!< GPIO_T::DINOFF: DINOFF0 Position          */
#define GPIO_DINOFF_DINOFF0_Msk          (0x1ul << GPIO_DINOFF_DINOFF0_Pos)                /*!< GPIO_T::DINOFF: DINOFF0 Mask              */

#define GPIO_DINOFF_DINOFF1_Pos          (17)                                              /*!< GPIO_T::DINOFF: DINOFF1 Position          */
#define GPIO_DINOFF_DINOFF1_Msk          (0x1ul << GPIO_DINOFF_DINOFF1_Pos)                /*!< GPIO_T::DINOFF: DINOFF1 Mask              */

#define GPIO_DINOFF_DINOFF2_Pos          (18)                                              /*!< GPIO_T::DINOFF: DINOFF2 Position          */
#define GPIO_DINOFF_DINOFF2_Msk          (0x1ul << GPIO_DINOFF_DINOFF2_Pos)                /*!< GPIO_T::DINOFF: DINOFF2 Mask              */

#define GPIO_DINOFF_DINOFF3_Pos          (19)                                              /*!< GPIO_T::DINOFF: DINOFF3 Position          */
#define GPIO_DINOFF_DINOFF3_Msk          (0x1ul << GPIO_DINOFF_DINOFF3_Pos)                /*!< GPIO_T::DINOFF: DINOFF3 Mask              */

#define GPIO_DINOFF_DINOFF4_Pos          (20)                                              /*!< GPIO_T::DINOFF: DINOFF4 Position          */
#define GPIO_DINOFF_DINOFF4_Msk          (0x1ul << GPIO_DINOFF_DINOFF4_Pos)                /*!< GPIO_T::DINOFF: DINOFF4 Mask              */

#define GPIO_DINOFF_DINOFF5_Pos          (21)                                              /*!< GPIO_T::DINOFF: DINOFF5 Position          */
#define GPIO_DINOFF_DINOFF5_Msk          (0x1ul << GPIO_DINOFF_DINOFF5_Pos)                /*!< GPIO_T::DINOFF: DINOFF5 Mask              */

#define GPIO_DINOFF_DINOFF6_Pos          (22)                                              /*!< GPIO_T::DINOFF: DINOFF6 Position          */
#define GPIO_DINOFF_DINOFF6_Msk          (0x1ul << GPIO_DINOFF_DINOFF6_Pos)                /*!< GPIO_T::DINOFF: DINOFF6 Mask              */

#define GPIO_DINOFF_DINOFF7_Pos          (23)                                              /*!< GPIO_T::DINOFF: DINOFF7 Position          */
#define GPIO_DINOFF_DINOFF7_Msk          (0x1ul << GPIO_DINOFF_DINOFF7_Pos)                /*!< GPIO_T::DINOFF: DINOFF7 Mask              */

#define GPIO_DINOFF_DINOFF8_Pos          (24)                                              /*!< GPIO_T::DINOFF: DINOFF8 Position          */
#define GPIO_DINOFF_DINOFF8_Msk          (0x1ul << GPIO_DINOFF_DINOFF8_Pos)                /*!< GPIO_T::DINOFF: DINOFF8 Mask              */

#define GPIO_DINOFF_DINOFF9_Pos          (25)                                              /*!< GPIO_T::DINOFF: DINOFF9 Position          */
#define GPIO_DINOFF_DINOFF9_Msk          (0x1ul << GPIO_DINOFF_DINOFF9_Pos)                /*!< GPIO_T::DINOFF: DINOFF9 Mask              */

#define GPIO_DINOFF_DINOFF10_Pos         (26)                                              /*!< GPIO_T::DINOFF: DINOFF10 Position         */
#define GPIO_DINOFF_DINOFF10_Msk         (0x1ul << GPIO_DINOFF_DINOFF10_Pos)               /*!< GPIO_T::DINOFF: DINOFF10 Mask             */

#define GPIO_DINOFF_DINOFF11_Pos         (27)                                              /*!< GPIO_T::DINOFF: DINOFF11 Position         */
#define GPIO_DINOFF_DINOFF11_Msk         (0x1ul << GPIO_DINOFF_DINOFF11_Pos)               /*!< GPIO_T::DINOFF: DINOFF11 Mask             */

#define GPIO_DINOFF_DINOFF12_Pos         (28)                                              /*!< GPIO_T::DINOFF: DINOFF12 Position         */
#define GPIO_DINOFF_DINOFF12_Msk         (0x1ul << GPIO_DINOFF_DINOFF12_Pos)               /*!< GPIO_T::DINOFF: DINOFF12 Mask             */

#define GPIO_DINOFF_DINOFF13_Pos         (29)                                              /*!< GPIO_T::DINOFF: DINOFF13 Position         */
#define GPIO_DINOFF_DINOFF13_Msk         (0x1ul << GPIO_DINOFF_DINOFF13_Pos)               /*!< GPIO_T::DINOFF: DINOFF13 Mask             */

#define GPIO_DINOFF_DINOFF14_Pos         (30)                                              /*!< GPIO_T::DINOFF: DINOFF14 Position         */
#define GPIO_DINOFF_DINOFF14_Msk         (0x1ul << GPIO_DINOFF_DINOFF14_Pos)               /*!< GPIO_T::DINOFF: DINOFF14 Mask             */

#define GPIO_DINOFF_DINOFF15_Pos         (31)                                              /*!< GPIO_T::DINOFF: DINOFF15 Position         */
#define GPIO_DINOFF_DINOFF15_Msk         (0x1ul << GPIO_DINOFF_DINOFF15_Pos)               /*!< GPIO_T::DINOFF: DINOFF15 Mask             */

#define GPIO_DOUT_DOUT0_Pos              (0)                                               /*!< GPIO_T::DOUT: DOUT0 Position              */
#define GPIO_DOUT_DOUT0_Msk              (0x1ul << GPIO_DOUT_DOUT0_Pos)                    /*!< GPIO_T::DOUT: DOUT0 Mask                  */

#define GPIO_DOUT_DOUT1_Pos              (1)                                               /*!< GPIO_T::DOUT: DOUT1 Position              */
#define GPIO_DOUT_DOUT1_Msk              (0x1ul << GPIO_DOUT_DOUT1_Pos)                    /*!< GPIO_T::DOUT: DOUT1 Mask                  */

#define GPIO_DOUT_DOUT2_Pos              (2)                                               /*!< GPIO_T::DOUT: DOUT2 Position              */
#define GPIO_DOUT_DOUT2_Msk              (0x1ul << GPIO_DOUT_DOUT2_Pos)                    /*!< GPIO_T::DOUT: DOUT2 Mask                  */

#define GPIO_DOUT_DOUT3_Pos              (3)                                               /*!< GPIO_T::DOUT: DOUT3 Position              */
#define GPIO_DOUT_DOUT3_Msk              (0x1ul << GPIO_DOUT_DOUT3_Pos)                    /*!< GPIO_T::DOUT: DOUT3 Mask                  */

#define GPIO_DOUT_DOUT4_Pos              (4)                                               /*!< GPIO_T::DOUT: DOUT4 Position              */
#define GPIO_DOUT_DOUT4_Msk              (0x1ul << GPIO_DOUT_DOUT4_Pos)                    /*!< GPIO_T::DOUT: DOUT4 Mask                  */

#define GPIO_DOUT_DOUT5_Pos              (5)                                               /*!< GPIO_T::DOUT: DOUT5 Position              */
#define GPIO_DOUT_DOUT5_Msk              (0x1ul << GPIO_DOUT_DOUT5_Pos)                    /*!< GPIO_T::DOUT: DOUT5 Mask                  */

#define GPIO_DOUT_DOUT6_Pos              (6)                                               /*!< GPIO_T::DOUT: DOUT6 Position              */
#define GPIO_DOUT_DOUT6_Msk              (0x1ul << GPIO_DOUT_DOUT6_Pos)                    /*!< GPIO_T::DOUT: DOUT6 Mask                  */

#define GPIO_DOUT_DOUT7_Pos              (7)                                               /*!< GPIO_T::DOUT: DOUT7 Position              */
#define GPIO_DOUT_DOUT7_Msk              (0x1ul << GPIO_DOUT_DOUT7_Pos)                    /*!< GPIO_T::DOUT: DOUT7 Mask                  */

#define GPIO_DOUT_DOUT8_Pos              (8)                                               /*!< GPIO_T::DOUT: DOUT8 Position              */
#define GPIO_DOUT_DOUT8_Msk              (0x1ul << GPIO_DOUT_DOUT8_Pos)                    /*!< GPIO_T::DOUT: DOUT8 Mask                  */

#define GPIO_DOUT_DOUT9_Pos              (9)                                               /*!< GPIO_T::DOUT: DOUT9 Position              */
#define GPIO_DOUT_DOUT9_Msk              (0x1ul << GPIO_DOUT_DOUT9_Pos)                    /*!< GPIO_T::DOUT: DOUT9 Mask                  */

#define GPIO_DOUT_DOUT10_Pos             (10)                                              /*!< GPIO_T::DOUT: DOUT10 Position             */
#define GPIO_DOUT_DOUT10_Msk             (0x1ul << GPIO_DOUT_DOUT10_Pos)                   /*!< GPIO_T::DOUT: DOUT10 Mask                 */

#define GPIO_DOUT_DOUT11_Pos             (11)                                              /*!< GPIO_T::DOUT: DOUT11 Position             */
#define GPIO_DOUT_DOUT11_Msk             (0x1ul << GPIO_DOUT_DOUT11_Pos)                   /*!< GPIO_T::DOUT: DOUT11 Mask                 */

#define GPIO_DOUT_DOUT12_Pos             (12)                                              /*!< GPIO_T::DOUT: DOUT12 Position             */
#define GPIO_DOUT_DOUT12_Msk             (0x1ul << GPIO_DOUT_DOUT12_Pos)                   /*!< GPIO_T::DOUT: DOUT12 Mask                 */

#define GPIO_DOUT_DOUT13_Pos             (13)                                              /*!< GPIO_T::DOUT: DOUT13 Position             */
#define GPIO_DOUT_DOUT13_Msk             (0x1ul << GPIO_DOUT_DOUT13_Pos)                   /*!< GPIO_T::DOUT: DOUT13 Mask                 */

#define GPIO_DOUT_DOUT14_Pos             (14)                                              /*!< GPIO_T::DOUT: DOUT14 Position             */
#define GPIO_DOUT_DOUT14_Msk             (0x1ul << GPIO_DOUT_DOUT14_Pos)                   /*!< GPIO_T::DOUT: DOUT14 Mask                 */

#define GPIO_DOUT_DOUT15_Pos             (15)                                              /*!< GPIO_T::DOUT: DOUT15 Position             */
#define GPIO_DOUT_DOUT15_Msk             (0x1ul << GPIO_DOUT_DOUT15_Pos)                   /*!< GPIO_T::DOUT: DOUT15 Mask                 */

#define GPIO_DATMSK_DMASK0_Pos           (0)                                               /*!< GPIO_T::DATMSK: DMASK0 Position           */
#define GPIO_DATMSK_DMASK0_Msk           (0x1ul << GPIO_DATMSK_DMASK0_Pos)                 /*!< GPIO_T::DATMSK: DMASK0 Mask               */

#define GPIO_DATMSK_DMASK1_Pos           (1)                                               /*!< GPIO_T::DATMSK: DMASK1 Position           */
#define GPIO_DATMSK_DMASK1_Msk           (0x1ul << GPIO_DATMSK_DMASK1_Pos)                 /*!< GPIO_T::DATMSK: DMASK1 Mask               */

#define GPIO_DATMSK_DMASK2_Pos           (2)                                               /*!< GPIO_T::DATMSK: DMASK2 Position           */
#define GPIO_DATMSK_DMASK2_Msk           (0x1ul << GPIO_DATMSK_DMASK2_Pos)                 /*!< GPIO_T::DATMSK: DMASK2 Mask               */

#define GPIO_DATMSK_DMASK3_Pos           (3)                                               /*!< GPIO_T::DATMSK: DMASK3 Position           */
#define GPIO_DATMSK_DMASK3_Msk           (0x1ul << GPIO_DATMSK_DMASK3_Pos)                 /*!< GPIO_T::DATMSK: DMASK3 Mask               */

#define GPIO_DATMSK_DMASK4_Pos           (4)                                               /*!< GPIO_T::DATMSK: DMASK4 Position           */
#define GPIO_DATMSK_DMASK4_Msk           (0x1ul << GPIO_DATMSK_DMASK4_Pos)                 /*!< GPIO_T::DATMSK: DMASK4 Mask               */

#define GPIO_DATMSK_DMASK5_Pos           (5)                                               /*!< GPIO_T::DATMSK: DMASK5 Position           */
#define GPIO_DATMSK_DMASK5_Msk           (0x1ul << GPIO_DATMSK_DMASK5_Pos)                 /*!< GPIO_T::DATMSK: DMASK5 Mask               */

#define GPIO_DATMSK_DMASK6_Pos           (6)                                               /*!< GPIO_T::DATMSK: DMASK6 Position           */
#define GPIO_DATMSK_DMASK6_Msk           (0x1ul << GPIO_DATMSK_DMASK6_Pos)                 /*!< GPIO_T::DATMSK: DMASK6 Mask               */

#define GPIO_DATMSK_DMASK7_Pos           (7)                                               /*!< GPIO_T::DATMSK: DMASK7 Position           */
#define GPIO_DATMSK_DMASK7_Msk           (0x1ul << GPIO_DATMSK_DMASK7_Pos)                 /*!< GPIO_T::DATMSK: DMASK7 Mask               */

#define GPIO_DATMSK_DMASK8_Pos           (8)                                               /*!< GPIO_T::DATMSK: DMASK8 Position           */
#define GPIO_DATMSK_DMASK8_Msk           (0x1ul << GPIO_DATMSK_DMASK8_Pos)                 /*!< GPIO_T::DATMSK: DMASK8 Mask               */

#define GPIO_DATMSK_DMASK9_Pos           (9)                                               /*!< GPIO_T::DATMSK: DMASK9 Position           */
#define GPIO_DATMSK_DMASK9_Msk           (0x1ul << GPIO_DATMSK_DMASK9_Pos)                 /*!< GPIO_T::DATMSK: DMASK9 Mask               */

#define GPIO_DATMSK_DMASK10_Pos          (10)                                              /*!< GPIO_T::DATMSK: DMASK10 Position          */
#define GPIO_DATMSK_DMASK10_Msk          (0x1ul << GPIO_DATMSK_DMASK10_Pos)                /*!< GPIO_T::DATMSK: DMASK10 Mask              */

#define GPIO_DATMSK_DMASK11_Pos          (11)                                              /*!< GPIO_T::DATMSK: DMASK11 Position          */
#define GPIO_DATMSK_DMASK11_Msk          (0x1ul << GPIO_DATMSK_DMASK11_Pos)                /*!< GPIO_T::DATMSK: DMASK11 Mask              */

#define GPIO_DATMSK_DMASK12_Pos          (12)                                              /*!< GPIO_T::DATMSK: DMASK12 Position          */
#define GPIO_DATMSK_DMASK12_Msk          (0x1ul << GPIO_DATMSK_DMASK12_Pos)                /*!< GPIO_T::DATMSK: DMASK12 Mask              */

#define GPIO_DATMSK_DMASK13_Pos          (13)                                              /*!< GPIO_T::DATMSK: DMASK13 Position          */
#define GPIO_DATMSK_DMASK13_Msk          (0x1ul << GPIO_DATMSK_DMASK13_Pos)                /*!< GPIO_T::DATMSK: DMASK13 Mask              */

#define GPIO_DATMSK_DMASK14_Pos          (14)                                              /*!< GPIO_T::DATMSK: DMASK14 Position          */
#define GPIO_DATMSK_DMASK14_Msk          (0x1ul << GPIO_DATMSK_DMASK14_Pos)                /*!< GPIO_T::DATMSK: DMASK14 Mask              */

#define GPIO_DATMSK_DMASK15_Pos          (15)                                              /*!< GPIO_T::DATMSK: DMASK15 Position          */
#define GPIO_DATMSK_DMASK15_Msk          (0x1ul << GPIO_DATMSK_DMASK15_Pos)                /*!< GPIO_T::DATMSK: DMASK15 Mask              */

#define GPIO_PIN_PIN0_Pos                (0)                                               /*!< GPIO_T::PIN: PIN0 Position                */
#define GPIO_PIN_PIN0_Msk                (0x1ul << GPIO_PIN_PIN0_Pos)                      /*!< GPIO_T::PIN: PIN0 Mask                    */

#define GPIO_PIN_PIN1_Pos                (1)                                               /*!< GPIO_T::PIN: PIN1 Position                */
#define GPIO_PIN_PIN1_Msk                (0x1ul << GPIO_PIN_PIN1_Pos)                      /*!< GPIO_T::PIN: PIN1 Mask                    */

#define GPIO_PIN_PIN2_Pos                (2)                                               /*!< GPIO_T::PIN: PIN2 Position                */
#define GPIO_PIN_PIN2_Msk                (0x1ul << GPIO_PIN_PIN2_Pos)                      /*!< GPIO_T::PIN: PIN2 Mask                    */

#define GPIO_PIN_PIN3_Pos                (3)                                               /*!< GPIO_T::PIN: PIN3 Position                */
#define GPIO_PIN_PIN3_Msk                (0x1ul << GPIO_PIN_PIN3_Pos)                      /*!< GPIO_T::PIN: PIN3 Mask                    */

#define GPIO_PIN_PIN4_Pos                (4)                                               /*!< GPIO_T::PIN: PIN4 Position                */
#define GPIO_PIN_PIN4_Msk                (0x1ul << GPIO_PIN_PIN4_Pos)                      /*!< GPIO_T::PIN: PIN4 Mask                    */

#define GPIO_PIN_PIN5_Pos                (5)                                               /*!< GPIO_T::PIN: PIN5 Position                */
#define GPIO_PIN_PIN5_Msk                (0x1ul << GPIO_PIN_PIN5_Pos)                      /*!< GPIO_T::PIN: PIN5 Mask                    */

#define GPIO_PIN_PIN6_Pos                (6)                                               /*!< GPIO_T::PIN: PIN6 Position                */
#define GPIO_PIN_PIN6_Msk                (0x1ul << GPIO_PIN_PIN6_Pos)                      /*!< GPIO_T::PIN: PIN6 Mask                    */

#define GPIO_PIN_PIN7_Pos                (7)                                               /*!< GPIO_T::PIN: PIN7 Position                */
#define GPIO_PIN_PIN7_Msk                (0x1ul << GPIO_PIN_PIN7_Pos)                      /*!< GPIO_T::PIN: PIN7 Mask                    */

#define GPIO_PIN_PIN8_Pos                (8)                                               /*!< GPIO_T::PIN: PIN8 Position                */
#define GPIO_PIN_PIN8_Msk                (0x1ul << GPIO_PIN_PIN8_Pos)                      /*!< GPIO_T::PIN: PIN8 Mask                    */

#define GPIO_PIN_PIN9_Pos                (9)                                               /*!< GPIO_T::PIN: PIN9 Position                */
#define GPIO_PIN_PIN9_Msk                (0x1ul << GPIO_PIN_PIN9_Pos)                      /*!< GPIO_T::PIN: PIN9 Mask                    */

#define GPIO_PIN_PIN10_Pos               (10)                                              /*!< GPIO_T::PIN: PIN10 Position               */
#define GPIO_PIN_PIN10_Msk               (0x1ul << GPIO_PIN_PIN10_Pos)                     /*!< GPIO_T::PIN: PIN10 Mask                   */

#define GPIO_PIN_PIN11_Pos               (11)                                              /*!< GPIO_T::PIN: PIN11 Position               */
#define GPIO_PIN_PIN11_Msk               (0x1ul << GPIO_PIN_PIN11_Pos)                     /*!< GPIO_T::PIN: PIN11 Mask                   */

#define GPIO_PIN_PIN12_Pos               (12)                                              /*!< GPIO_T::PIN: PIN12 Position               */
#define GPIO_PIN_PIN12_Msk               (0x1ul << GPIO_PIN_PIN12_Pos)                     /*!< GPIO_T::PIN: PIN12 Mask                   */

#define GPIO_PIN_PIN13_Pos               (13)                                              /*!< GPIO_T::PIN: PIN13 Position               */
#define GPIO_PIN_PIN13_Msk               (0x1ul << GPIO_PIN_PIN13_Pos)                     /*!< GPIO_T::PIN: PIN13 Mask                   */

#define GPIO_PIN_PIN14_Pos               (14)                                              /*!< GPIO_T::PIN: PIN14 Position               */
#define GPIO_PIN_PIN14_Msk               (0x1ul << GPIO_PIN_PIN14_Pos)                     /*!< GPIO_T::PIN: PIN14 Mask                   */

#define GPIO_PIN_PIN15_Pos               (15)                                              /*!< GPIO_T::PIN: PIN15 Position               */
#define GPIO_PIN_PIN15_Msk               (0x1ul << GPIO_PIN_PIN15_Pos)                     /*!< GPIO_T::PIN: PIN15 Mask                   */

#define GPIO_DBEN_DBEN0_Pos              (0)                                               /*!< GPIO_T::DBEN: DBEN0 Position              */
#define GPIO_DBEN_DBEN0_Msk              (0x1ul << GPIO_DBEN_DBEN0_Pos)                    /*!< GPIO_T::DBEN: DBEN0 Mask                  */

#define GPIO_DBEN_DBEN1_Pos              (1)                                               /*!< GPIO_T::DBEN: DBEN1 Position              */
#define GPIO_DBEN_DBEN1_Msk              (0x1ul << GPIO_DBEN_DBEN1_Pos)                    /*!< GPIO_T::DBEN: DBEN1 Mask                  */

#define GPIO_DBEN_DBEN2_Pos              (2)                                               /*!< GPIO_T::DBEN: DBEN2 Position              */
#define GPIO_DBEN_DBEN2_Msk              (0x1ul << GPIO_DBEN_DBEN2_Pos)                    /*!< GPIO_T::DBEN: DBEN2 Mask                  */

#define GPIO_DBEN_DBEN3_Pos              (3)                                               /*!< GPIO_T::DBEN: DBEN3 Position              */
#define GPIO_DBEN_DBEN3_Msk              (0x1ul << GPIO_DBEN_DBEN3_Pos)                    /*!< GPIO_T::DBEN: DBEN3 Mask                  */

#define GPIO_DBEN_DBEN4_Pos              (4)                                               /*!< GPIO_T::DBEN: DBEN4 Position              */
#define GPIO_DBEN_DBEN4_Msk              (0x1ul << GPIO_DBEN_DBEN4_Pos)                    /*!< GPIO_T::DBEN: DBEN4 Mask                  */

#define GPIO_DBEN_DBEN5_Pos              (5)                                               /*!< GPIO_T::DBEN: DBEN5 Position              */
#define GPIO_DBEN_DBEN5_Msk              (0x1ul << GPIO_DBEN_DBEN5_Pos)                    /*!< GPIO_T::DBEN: DBEN5 Mask                  */

#define GPIO_DBEN_DBEN6_Pos              (6)                                               /*!< GPIO_T::DBEN: DBEN6 Position              */
#define GPIO_DBEN_DBEN6_Msk              (0x1ul << GPIO_DBEN_DBEN6_Pos)                    /*!< GPIO_T::DBEN: DBEN6 Mask                  */

#define GPIO_DBEN_DBEN7_Pos              (7)                                               /*!< GPIO_T::DBEN: DBEN7 Position              */
#define GPIO_DBEN_DBEN7_Msk              (0x1ul << GPIO_DBEN_DBEN7_Pos)                    /*!< GPIO_T::DBEN: DBEN7 Mask                  */

#define GPIO_DBEN_DBEN8_Pos              (8)                                               /*!< GPIO_T::DBEN: DBEN8 Position              */
#define GPIO_DBEN_DBEN8_Msk              (0x1ul << GPIO_DBEN_DBEN8_Pos)                    /*!< GPIO_T::DBEN: DBEN8 Mask                  */

#define GPIO_DBEN_DBEN9_Pos              (9)                                               /*!< GPIO_T::DBEN: DBEN9 Position              */
#define GPIO_DBEN_DBEN9_Msk              (0x1ul << GPIO_DBEN_DBEN9_Pos)                    /*!< GPIO_T::DBEN: DBEN9 Mask                  */

#define GPIO_DBEN_DBEN10_Pos             (10)                                              /*!< GPIO_T::DBEN: DBEN10 Position             */
#define GPIO_DBEN_DBEN10_Msk             (0x1ul << GPIO_DBEN_DBEN10_Pos)                   /*!< GPIO_T::DBEN: DBEN10 Mask                 */

#define GPIO_DBEN_DBEN11_Pos             (11)                                              /*!< GPIO_T::DBEN: DBEN11 Position             */
#define GPIO_DBEN_DBEN11_Msk             (0x1ul << GPIO_DBEN_DBEN11_Pos)                   /*!< GPIO_T::DBEN: DBEN11 Mask                 */

#define GPIO_DBEN_DBEN12_Pos             (12)                                              /*!< GPIO_T::DBEN: DBEN12 Position             */
#define GPIO_DBEN_DBEN12_Msk             (0x1ul << GPIO_DBEN_DBEN12_Pos)                   /*!< GPIO_T::DBEN: DBEN12 Mask                 */

#define GPIO_DBEN_DBEN13_Pos             (13)                                              /*!< GPIO_T::DBEN: DBEN13 Position             */
#define GPIO_DBEN_DBEN13_Msk             (0x1ul << GPIO_DBEN_DBEN13_Pos)                   /*!< GPIO_T::DBEN: DBEN13 Mask                 */

#define GPIO_DBEN_DBEN14_Pos             (14)                                              /*!< GPIO_T::DBEN: DBEN14 Position             */
#define GPIO_DBEN_DBEN14_Msk             (0x1ul << GPIO_DBEN_DBEN14_Pos)                   /*!< GPIO_T::DBEN: DBEN14 Mask                 */

#define GPIO_DBEN_DBEN15_Pos             (15)                                              /*!< GPIO_T::DBEN: DBEN15 Position             */
#define GPIO_DBEN_DBEN15_Msk             (0x1ul << GPIO_DBEN_DBEN15_Pos)                   /*!< GPIO_T::DBEN: DBEN15 Mask                 */

#define GPIO_INTTYPE_TYPE0_Pos           (0)                                               /*!< GPIO_T::INTTYPE: TYPE0 Position           */
#define GPIO_INTTYPE_TYPE0_Msk           (0x1ul << GPIO_INTTYPE_TYPE0_Pos)                 /*!< GPIO_T::INTTYPE: TYPE0 Mask               */

#define GPIO_INTTYPE_TYPE1_Pos           (1)                                               /*!< GPIO_T::INTTYPE: TYPE1 Position           */
#define GPIO_INTTYPE_TYPE1_Msk           (0x1ul << GPIO_INTTYPE_TYPE1_Pos)                 /*!< GPIO_T::INTTYPE: TYPE1 Mask               */

#define GPIO_INTTYPE_TYPE2_Pos           (2)                                               /*!< GPIO_T::INTTYPE: TYPE2 Position           */
#define GPIO_INTTYPE_TYPE2_Msk           (0x1ul << GPIO_INTTYPE_TYPE2_Pos)                 /*!< GPIO_T::INTTYPE: TYPE2 Mask               */

#define GPIO_INTTYPE_TYPE3_Pos           (3)                                               /*!< GPIO_T::INTTYPE: TYPE3 Position           */
#define GPIO_INTTYPE_TYPE3_Msk           (0x1ul << GPIO_INTTYPE_TYPE3_Pos)                 /*!< GPIO_T::INTTYPE: TYPE3 Mask               */

#define GPIO_INTTYPE_TYPE4_Pos           (4)                                               /*!< GPIO_T::INTTYPE: TYPE4 Position           */
#define GPIO_INTTYPE_TYPE4_Msk           (0x1ul << GPIO_INTTYPE_TYPE4_Pos)                 /*!< GPIO_T::INTTYPE: TYPE4 Mask               */

#define GPIO_INTTYPE_TYPE5_Pos           (5)                                               /*!< GPIO_T::INTTYPE: TYPE5 Position           */
#define GPIO_INTTYPE_TYPE5_Msk           (0x1ul << GPIO_INTTYPE_TYPE5_Pos)                 /*!< GPIO_T::INTTYPE: TYPE5 Mask               */

#define GPIO_INTTYPE_TYPE6_Pos           (6)                                               /*!< GPIO_T::INTTYPE: TYPE6 Position           */
#define GPIO_INTTYPE_TYPE6_Msk           (0x1ul << GPIO_INTTYPE_TYPE6_Pos)                 /*!< GPIO_T::INTTYPE: TYPE6 Mask               */

#define GPIO_INTTYPE_TYPE7_Pos           (7)                                               /*!< GPIO_T::INTTYPE: TYPE7 Position           */
#define GPIO_INTTYPE_TYPE7_Msk           (0x1ul << GPIO_INTTYPE_TYPE7_Pos)                 /*!< GPIO_T::INTTYPE: TYPE7 Mask               */

#define GPIO_INTTYPE_TYPE8_Pos           (8)                                               /*!< GPIO_T::INTTYPE: TYPE8 Position           */
#define GPIO_INTTYPE_TYPE8_Msk           (0x1ul << GPIO_INTTYPE_TYPE8_Pos)                 /*!< GPIO_T::INTTYPE: TYPE8 Mask               */

#define GPIO_INTTYPE_TYPE9_Pos           (9)                                               /*!< GPIO_T::INTTYPE: TYPE9 Position           */
#define GPIO_INTTYPE_TYPE9_Msk           (0x1ul << GPIO_INTTYPE_TYPE9_Pos)                 /*!< GPIO_T::INTTYPE: TYPE9 Mask               */

#define GPIO_INTTYPE_TYPE10_Pos          (10)                                              /*!< GPIO_T::INTTYPE: TYPE10 Position          */
#define GPIO_INTTYPE_TYPE10_Msk          (0x1ul << GPIO_INTTYPE_TYPE10_Pos)                /*!< GPIO_T::INTTYPE: TYPE10 Mask              */

#define GPIO_INTTYPE_TYPE11_Pos          (11)                                              /*!< GPIO_T::INTTYPE: TYPE11 Position          */
#define GPIO_INTTYPE_TYPE11_Msk          (0x1ul << GPIO_INTTYPE_TYPE11_Pos)                /*!< GPIO_T::INTTYPE: TYPE11 Mask              */

#define GPIO_INTTYPE_TYPE12_Pos          (12)                                              /*!< GPIO_T::INTTYPE: TYPE12 Position          */
#define GPIO_INTTYPE_TYPE12_Msk          (0x1ul << GPIO_INTTYPE_TYPE12_Pos)                /*!< GPIO_T::INTTYPE: TYPE12 Mask              */

#define GPIO_INTTYPE_TYPE13_Pos          (13)                                              /*!< GPIO_T::INTTYPE: TYPE13 Position          */
#define GPIO_INTTYPE_TYPE13_Msk          (0x1ul << GPIO_INTTYPE_TYPE13_Pos)                /*!< GPIO_T::INTTYPE: TYPE13 Mask              */

#define GPIO_INTTYPE_TYPE14_Pos          (14)                                              /*!< GPIO_T::INTTYPE: TYPE14 Position          */
#define GPIO_INTTYPE_TYPE14_Msk          (0x1ul << GPIO_INTTYPE_TYPE14_Pos)                /*!< GPIO_T::INTTYPE: TYPE14 Mask              */

#define GPIO_INTTYPE_TYPE15_Pos          (15)                                              /*!< GPIO_T::INTTYPE: TYPE15 Position          */
#define GPIO_INTTYPE_TYPE15_Msk          (0x1ul << GPIO_INTTYPE_TYPE15_Pos)                /*!< GPIO_T::INTTYPE: TYPE15 Mask              */

#define GPIO_INTEN_FLIEN0_Pos            (0)                                               /*!< GPIO_T::INTEN: FLIEN0 Position            */
#define GPIO_INTEN_FLIEN0_Msk            (0x1ul << GPIO_INTEN_FLIEN0_Pos)                  /*!< GPIO_T::INTEN: FLIEN0 Mask                */

#define GPIO_INTEN_FLIEN1_Pos            (1)                                               /*!< GPIO_T::INTEN: FLIEN1 Position            */
#define GPIO_INTEN_FLIEN1_Msk            (0x1ul << GPIO_INTEN_FLIEN1_Pos)                  /*!< GPIO_T::INTEN: FLIEN1 Mask                */

#define GPIO_INTEN_FLIEN2_Pos            (2)                                               /*!< GPIO_T::INTEN: FLIEN2 Position            */
#define GPIO_INTEN_FLIEN2_Msk            (0x1ul << GPIO_INTEN_FLIEN2_Pos)                  /*!< GPIO_T::INTEN: FLIEN2 Mask                */

#define GPIO_INTEN_FLIEN3_Pos            (3)                                               /*!< GPIO_T::INTEN: FLIEN3 Position            */
#define GPIO_INTEN_FLIEN3_Msk            (0x1ul << GPIO_INTEN_FLIEN3_Pos)                  /*!< GPIO_T::INTEN: FLIEN3 Mask                */

#define GPIO_INTEN_FLIEN4_Pos            (4)                                               /*!< GPIO_T::INTEN: FLIEN4 Position            */
#define GPIO_INTEN_FLIEN4_Msk            (0x1ul << GPIO_INTEN_FLIEN4_Pos)                  /*!< GPIO_T::INTEN: FLIEN4 Mask                */

#define GPIO_INTEN_FLIEN5_Pos            (5)                                               /*!< GPIO_T::INTEN: FLIEN5 Position            */
#define GPIO_INTEN_FLIEN5_Msk            (0x1ul << GPIO_INTEN_FLIEN5_Pos)                  /*!< GPIO_T::INTEN: FLIEN5 Mask                */

#define GPIO_INTEN_FLIEN6_Pos            (6)                                               /*!< GPIO_T::INTEN: FLIEN6 Position            */
#define GPIO_INTEN_FLIEN6_Msk            (0x1ul << GPIO_INTEN_FLIEN6_Pos)                  /*!< GPIO_T::INTEN: FLIEN6 Mask                */

#define GPIO_INTEN_FLIEN7_Pos            (7)                                               /*!< GPIO_T::INTEN: FLIEN7 Position            */
#define GPIO_INTEN_FLIEN7_Msk            (0x1ul << GPIO_INTEN_FLIEN7_Pos)                  /*!< GPIO_T::INTEN: FLIEN7 Mask                */

#define GPIO_INTEN_FLIEN8_Pos            (8)                                               /*!< GPIO_T::INTEN: FLIEN8 Position            */
#define GPIO_INTEN_FLIEN8_Msk            (0x1ul << GPIO_INTEN_FLIEN8_Pos)                  /*!< GPIO_T::INTEN: FLIEN8 Mask                */

#define GPIO_INTEN_FLIEN9_Pos            (9)                                               /*!< GPIO_T::INTEN: FLIEN9 Position            */
#define GPIO_INTEN_FLIEN9_Msk            (0x1ul << GPIO_INTEN_FLIEN9_Pos)                  /*!< GPIO_T::INTEN: FLIEN9 Mask                */

#define GPIO_INTEN_FLIEN10_Pos           (10)                                              /*!< GPIO_T::INTEN: FLIEN10 Position           */
#define GPIO_INTEN_FLIEN10_Msk           (0x1ul << GPIO_INTEN_FLIEN10_Pos)                 /*!< GPIO_T::INTEN: FLIEN10 Mask               */

#define GPIO_INTEN_FLIEN11_Pos           (11)                                              /*!< GPIO_T::INTEN: FLIEN11 Position           */
#define GPIO_INTEN_FLIEN11_Msk           (0x1ul << GPIO_INTEN_FLIEN11_Pos)                 /*!< GPIO_T::INTEN: FLIEN11 Mask               */

#define GPIO_INTEN_FLIEN12_Pos           (12)                                              /*!< GPIO_T::INTEN: FLIEN12 Position           */
#define GPIO_INTEN_FLIEN12_Msk           (0x1ul << GPIO_INTEN_FLIEN12_Pos)                 /*!< GPIO_T::INTEN: FLIEN12 Mask               */

#define GPIO_INTEN_FLIEN13_Pos           (13)                                              /*!< GPIO_T::INTEN: FLIEN13 Position           */
#define GPIO_INTEN_FLIEN13_Msk           (0x1ul << GPIO_INTEN_FLIEN13_Pos)                 /*!< GPIO_T::INTEN: FLIEN13 Mask               */

#define GPIO_INTEN_FLIEN14_Pos           (14)                                              /*!< GPIO_T::INTEN: FLIEN14 Position           */
#define GPIO_INTEN_FLIEN14_Msk           (0x1ul << GPIO_INTEN_FLIEN14_Pos)                 /*!< GPIO_T::INTEN: FLIEN14 Mask               */

#define GPIO_INTEN_FLIEN15_Pos           (15)                                              /*!< GPIO_T::INTEN: FLIEN15 Position           */
#define GPIO_INTEN_FLIEN15_Msk           (0x1ul << GPIO_INTEN_FLIEN15_Pos)                 /*!< GPIO_T::INTEN: FLIEN15 Mask               */

#define GPIO_INTEN_RHIEN0_Pos            (16)                                              /*!< GPIO_T::INTEN: RHIEN0 Position            */
#define GPIO_INTEN_RHIEN0_Msk            (0x1ul << GPIO_INTEN_RHIEN0_Pos)                  /*!< GPIO_T::INTEN: RHIEN0 Mask                */

#define GPIO_INTEN_RHIEN1_Pos            (17)                                              /*!< GPIO_T::INTEN: RHIEN1 Position            */
#define GPIO_INTEN_RHIEN1_Msk            (0x1ul << GPIO_INTEN_RHIEN1_Pos)                  /*!< GPIO_T::INTEN: RHIEN1 Mask                */

#define GPIO_INTEN_RHIEN2_Pos            (18)                                              /*!< GPIO_T::INTEN: RHIEN2 Position            */
#define GPIO_INTEN_RHIEN2_Msk            (0x1ul << GPIO_INTEN_RHIEN2_Pos)                  /*!< GPIO_T::INTEN: RHIEN2 Mask                */

#define GPIO_INTEN_RHIEN3_Pos            (19)                                              /*!< GPIO_T::INTEN: RHIEN3 Position            */
#define GPIO_INTEN_RHIEN3_Msk            (0x1ul << GPIO_INTEN_RHIEN3_Pos)                  /*!< GPIO_T::INTEN: RHIEN3 Mask                */

#define GPIO_INTEN_RHIEN4_Pos            (20)                                              /*!< GPIO_T::INTEN: RHIEN4 Position            */
#define GPIO_INTEN_RHIEN4_Msk            (0x1ul << GPIO_INTEN_RHIEN4_Pos)                  /*!< GPIO_T::INTEN: RHIEN4 Mask                */

#define GPIO_INTEN_RHIEN5_Pos            (21)                                              /*!< GPIO_T::INTEN: RHIEN5 Position            */
#define GPIO_INTEN_RHIEN5_Msk            (0x1ul << GPIO_INTEN_RHIEN5_Pos)                  /*!< GPIO_T::INTEN: RHIEN5 Mask                */

#define GPIO_INTEN_RHIEN6_Pos            (22)                                              /*!< GPIO_T::INTEN: RHIEN6 Position            */
#define GPIO_INTEN_RHIEN6_Msk            (0x1ul << GPIO_INTEN_RHIEN6_Pos)                  /*!< GPIO_T::INTEN: RHIEN6 Mask                */

#define GPIO_INTEN_RHIEN7_Pos            (23)                                              /*!< GPIO_T::INTEN: RHIEN7 Position            */
#define GPIO_INTEN_RHIEN7_Msk            (0x1ul << GPIO_INTEN_RHIEN7_Pos)                  /*!< GPIO_T::INTEN: RHIEN7 Mask                */

#define GPIO_INTEN_RHIEN8_Pos            (24)                                              /*!< GPIO_T::INTEN: RHIEN8 Position            */
#define GPIO_INTEN_RHIEN8_Msk            (0x1ul << GPIO_INTEN_RHIEN8_Pos)                  /*!< GPIO_T::INTEN: RHIEN8 Mask                */

#define GPIO_INTEN_RHIEN9_Pos            (25)                                              /*!< GPIO_T::INTEN: RHIEN9 Position            */
#define GPIO_INTEN_RHIEN9_Msk            (0x1ul << GPIO_INTEN_RHIEN9_Pos)                  /*!< GPIO_T::INTEN: RHIEN9 Mask                */

#define GPIO_INTEN_RHIEN10_Pos           (26)                                              /*!< GPIO_T::INTEN: RHIEN10 Position           */
#define GPIO_INTEN_RHIEN10_Msk           (0x1ul << GPIO_INTEN_RHIEN10_Pos)                 /*!< GPIO_T::INTEN: RHIEN10 Mask               */

#define GPIO_INTEN_RHIEN11_Pos           (27)                                              /*!< GPIO_T::INTEN: RHIEN11 Position           */
#define GPIO_INTEN_RHIEN11_Msk           (0x1ul << GPIO_INTEN_RHIEN11_Pos)                 /*!< GPIO_T::INTEN: RHIEN11 Mask               */

#define GPIO_INTEN_RHIEN12_Pos           (28)                                              /*!< GPIO_T::INTEN: RHIEN12 Position           */
#define GPIO_INTEN_RHIEN12_Msk           (0x1ul << GPIO_INTEN_RHIEN12_Pos)                 /*!< GPIO_T::INTEN: RHIEN12 Mask               */

#define GPIO_INTEN_RHIEN13_Pos           (29)                                              /*!< GPIO_T::INTEN: RHIEN13 Position           */
#define GPIO_INTEN_RHIEN13_Msk           (0x1ul << GPIO_INTEN_RHIEN13_Pos)                 /*!< GPIO_T::INTEN: RHIEN13 Mask               */

#define GPIO_INTEN_RHIEN14_Pos           (30)                                              /*!< GPIO_T::INTEN: RHIEN14 Position           */
#define GPIO_INTEN_RHIEN14_Msk           (0x1ul << GPIO_INTEN_RHIEN14_Pos)                 /*!< GPIO_T::INTEN: RHIEN14 Mask               */

#define GPIO_INTEN_RHIEN15_Pos           (31)                                              /*!< GPIO_T::INTEN: RHIEN15 Position           */
#define GPIO_INTEN_RHIEN15_Msk           (0x1ul << GPIO_INTEN_RHIEN15_Pos)                 /*!< GPIO_T::INTEN: RHIEN15 Mask               */

#define GPIO_INTSRC_INTSRC0_Pos          (0)                                               /*!< GPIO_T::INTSRC: INTSRC0 Position          */
#define GPIO_INTSRC_INTSRC0_Msk          (0x1ul << GPIO_INTSRC_INTSRC0_Pos)                /*!< GPIO_T::INTSRC: INTSRC0 Mask              */

#define GPIO_INTSRC_INTSRC1_Pos          (1)                                               /*!< GPIO_T::INTSRC: INTSRC1 Position          */
#define GPIO_INTSRC_INTSRC1_Msk          (0x1ul << GPIO_INTSRC_INTSRC1_Pos)                /*!< GPIO_T::INTSRC: INTSRC1 Mask              */

#define GPIO_INTSRC_INTSRC2_Pos          (2)                                               /*!< GPIO_T::INTSRC: INTSRC2 Position          */
#define GPIO_INTSRC_INTSRC2_Msk          (0x1ul << GPIO_INTSRC_INTSRC2_Pos)                /*!< GPIO_T::INTSRC: INTSRC2 Mask              */

#define GPIO_INTSRC_INTSRC3_Pos          (3)                                               /*!< GPIO_T::INTSRC: INTSRC3 Position          */
#define GPIO_INTSRC_INTSRC3_Msk          (0x1ul << GPIO_INTSRC_INTSRC3_Pos)                /*!< GPIO_T::INTSRC: INTSRC3 Mask              */

#define GPIO_INTSRC_INTSRC4_Pos          (4)                                               /*!< GPIO_T::INTSRC: INTSRC4 Position          */
#define GPIO_INTSRC_INTSRC4_Msk          (0x1ul << GPIO_INTSRC_INTSRC4_Pos)                /*!< GPIO_T::INTSRC: INTSRC4 Mask              */

#define GPIO_INTSRC_INTSRC5_Pos          (5)                                               /*!< GPIO_T::INTSRC: INTSRC5 Position          */
#define GPIO_INTSRC_INTSRC5_Msk          (0x1ul << GPIO_INTSRC_INTSRC5_Pos)                /*!< GPIO_T::INTSRC: INTSRC5 Mask              */

#define GPIO_INTSRC_INTSRC6_Pos          (6)                                               /*!< GPIO_T::INTSRC: INTSRC6 Position          */
#define GPIO_INTSRC_INTSRC6_Msk          (0x1ul << GPIO_INTSRC_INTSRC6_Pos)                /*!< GPIO_T::INTSRC: INTSRC6 Mask              */

#define GPIO_INTSRC_INTSRC7_Pos          (7)                                               /*!< GPIO_T::INTSRC: INTSRC7 Position          */
#define GPIO_INTSRC_INTSRC7_Msk          (0x1ul << GPIO_INTSRC_INTSRC7_Pos)                /*!< GPIO_T::INTSRC: INTSRC7 Mask              */

#define GPIO_INTSRC_INTSRC8_Pos          (8)                                               /*!< GPIO_T::INTSRC: INTSRC8 Position          */
#define GPIO_INTSRC_INTSRC8_Msk          (0x1ul << GPIO_INTSRC_INTSRC8_Pos)                /*!< GPIO_T::INTSRC: INTSRC8 Mask              */

#define GPIO_INTSRC_INTSRC9_Pos          (9)                                               /*!< GPIO_T::INTSRC: INTSRC9 Position          */
#define GPIO_INTSRC_INTSRC9_Msk          (0x1ul << GPIO_INTSRC_INTSRC9_Pos)                /*!< GPIO_T::INTSRC: INTSRC9 Mask              */

#define GPIO_INTSRC_INTSRC10_Pos         (10)                                              /*!< GPIO_T::INTSRC: INTSRC10 Position         */
#define GPIO_INTSRC_INTSRC10_Msk         (0x1ul << GPIO_INTSRC_INTSRC10_Pos)               /*!< GPIO_T::INTSRC: INTSRC10 Mask             */

#define GPIO_INTSRC_INTSRC11_Pos         (11)                                              /*!< GPIO_T::INTSRC: INTSRC11 Position         */
#define GPIO_INTSRC_INTSRC11_Msk         (0x1ul << GPIO_INTSRC_INTSRC11_Pos)               /*!< GPIO_T::INTSRC: INTSRC11 Mask             */

#define GPIO_INTSRC_INTSRC12_Pos         (12)                                              /*!< GPIO_T::INTSRC: INTSRC12 Position         */
#define GPIO_INTSRC_INTSRC12_Msk         (0x1ul << GPIO_INTSRC_INTSRC12_Pos)               /*!< GPIO_T::INTSRC: INTSRC12 Mask             */

#define GPIO_INTSRC_INTSRC13_Pos         (13)                                              /*!< GPIO_T::INTSRC: INTSRC13 Position         */
#define GPIO_INTSRC_INTSRC13_Msk         (0x1ul << GPIO_INTSRC_INTSRC13_Pos)               /*!< GPIO_T::INTSRC: INTSRC13 Mask             */

#define GPIO_INTSRC_INTSRC14_Pos         (14)                                              /*!< GPIO_T::INTSRC: INTSRC14 Position         */
#define GPIO_INTSRC_INTSRC14_Msk         (0x1ul << GPIO_INTSRC_INTSRC14_Pos)               /*!< GPIO_T::INTSRC: INTSRC14 Mask             */

#define GPIO_INTSRC_INTSRC15_Pos         (15)                                              /*!< GPIO_T::INTSRC: INTSRC15 Position         */
#define GPIO_INTSRC_INTSRC15_Msk         (0x1ul << GPIO_INTSRC_INTSRC15_Pos)               /*!< GPIO_T::INTSRC: INTSRC15 Mask             */

#define GPIO_SMTEN_SMTEN0_Pos            (0)                                               /*!< GPIO_T::SMTEN: SMTEN0 Position            */
#define GPIO_SMTEN_SMTEN0_Msk            (0x1ul << GPIO_SMTEN_SMTEN0_Pos)                  /*!< GPIO_T::SMTEN: SMTEN0 Mask                */

#define GPIO_SMTEN_SMTEN1_Pos            (1)                                               /*!< GPIO_T::SMTEN: SMTEN1 Position            */
#define GPIO_SMTEN_SMTEN1_Msk            (0x1ul << GPIO_SMTEN_SMTEN1_Pos)                  /*!< GPIO_T::SMTEN: SMTEN1 Mask                */

#define GPIO_SMTEN_SMTEN2_Pos            (2)                                               /*!< GPIO_T::SMTEN: SMTEN2 Position            */
#define GPIO_SMTEN_SMTEN2_Msk            (0x1ul << GPIO_SMTEN_SMTEN2_Pos)                  /*!< GPIO_T::SMTEN: SMTEN2 Mask                */

#define GPIO_SMTEN_SMTEN3_Pos            (3)                                               /*!< GPIO_T::SMTEN: SMTEN3 Position            */
#define GPIO_SMTEN_SMTEN3_Msk            (0x1ul << GPIO_SMTEN_SMTEN3_Pos)                  /*!< GPIO_T::SMTEN: SMTEN3 Mask                */

#define GPIO_SMTEN_SMTEN4_Pos            (4)                                               /*!< GPIO_T::SMTEN: SMTEN4 Position            */
#define GPIO_SMTEN_SMTEN4_Msk            (0x1ul << GPIO_SMTEN_SMTEN4_Pos)                  /*!< GPIO_T::SMTEN: SMTEN4 Mask                */

#define GPIO_SMTEN_SMTEN5_Pos            (5)                                               /*!< GPIO_T::SMTEN: SMTEN5 Position            */
#define GPIO_SMTEN_SMTEN5_Msk            (0x1ul << GPIO_SMTEN_SMTEN5_Pos)                  /*!< GPIO_T::SMTEN: SMTEN5 Mask                */

#define GPIO_SMTEN_SMTEN6_Pos            (6)                                               /*!< GPIO_T::SMTEN: SMTEN6 Position            */
#define GPIO_SMTEN_SMTEN6_Msk            (0x1ul << GPIO_SMTEN_SMTEN6_Pos)                  /*!< GPIO_T::SMTEN: SMTEN6 Mask                */

#define GPIO_SMTEN_SMTEN7_Pos            (7)                                               /*!< GPIO_T::SMTEN: SMTEN7 Position            */
#define GPIO_SMTEN_SMTEN7_Msk            (0x1ul << GPIO_SMTEN_SMTEN7_Pos)                  /*!< GPIO_T::SMTEN: SMTEN7 Mask                */

#define GPIO_SMTEN_SMTEN8_Pos            (8)                                               /*!< GPIO_T::SMTEN: SMTEN8 Position            */
#define GPIO_SMTEN_SMTEN8_Msk            (0x1ul << GPIO_SMTEN_SMTEN8_Pos)                  /*!< GPIO_T::SMTEN: SMTEN8 Mask                */

#define GPIO_SMTEN_SMTEN9_Pos            (9)                                               /*!< GPIO_T::SMTEN: SMTEN9 Position            */
#define GPIO_SMTEN_SMTEN9_Msk            (0x1ul << GPIO_SMTEN_SMTEN9_Pos)                  /*!< GPIO_T::SMTEN: SMTEN9 Mask                */

#define GPIO_SMTEN_SMTEN10_Pos           (10)                                              /*!< GPIO_T::SMTEN: SMTEN10 Position           */
#define GPIO_SMTEN_SMTEN10_Msk           (0x1ul << GPIO_SMTEN_SMTEN10_Pos)                 /*!< GPIO_T::SMTEN: SMTEN10 Mask               */

#define GPIO_SMTEN_SMTEN11_Pos           (11)                                              /*!< GPIO_T::SMTEN: SMTEN11 Position           */
#define GPIO_SMTEN_SMTEN11_Msk           (0x1ul << GPIO_SMTEN_SMTEN11_Pos)                 /*!< GPIO_T::SMTEN: SMTEN11 Mask               */

#define GPIO_SMTEN_SMTEN12_Pos           (12)                                              /*!< GPIO_T::SMTEN: SMTEN12 Position           */
#define GPIO_SMTEN_SMTEN12_Msk           (0x1ul << GPIO_SMTEN_SMTEN12_Pos)                 /*!< GPIO_T::SMTEN: SMTEN12 Mask               */

#define GPIO_SMTEN_SMTEN13_Pos           (13)                                              /*!< GPIO_T::SMTEN: SMTEN13 Position           */
#define GPIO_SMTEN_SMTEN13_Msk           (0x1ul << GPIO_SMTEN_SMTEN13_Pos)                 /*!< GPIO_T::SMTEN: SMTEN13 Mask               */

#define GPIO_SMTEN_SMTEN14_Pos           (14)                                              /*!< GPIO_T::SMTEN: SMTEN14 Position           */
#define GPIO_SMTEN_SMTEN14_Msk           (0x1ul << GPIO_SMTEN_SMTEN14_Pos)                 /*!< GPIO_T::SMTEN: SMTEN14 Mask               */

#define GPIO_SMTEN_SMTEN15_Pos           (15)                                              /*!< GPIO_T::SMTEN: SMTEN15 Position           */
#define GPIO_SMTEN_SMTEN15_Msk           (0x1ul << GPIO_SMTEN_SMTEN15_Pos)                 /*!< GPIO_T::SMTEN: SMTEN15 Mask               */

#define GPIO_SLEWCTL_HSREN0_Pos          (0)                                               /*!< GPIO_T::SLEWCTL: HSREN0 Position          */
#define GPIO_SLEWCTL_HSREN0_Msk          (0x1ul << GPIO_SLEWCTL_HSREN0_Pos)                /*!< GPIO_T::SLEWCTL: HSREN0 Mask              */

#define GPIO_SLEWCTL_HSREN1_Pos          (1)                                               /*!< GPIO_T::SLEWCTL: HSREN1 Position          */
#define GPIO_SLEWCTL_HSREN1_Msk          (0x1ul << GPIO_SLEWCTL_HSREN1_Pos)                /*!< GPIO_T::SLEWCTL: HSREN1 Mask              */

#define GPIO_SLEWCTL_HSREN2_Pos          (2)                                               /*!< GPIO_T::SLEWCTL: HSREN2 Position          */
#define GPIO_SLEWCTL_HSREN2_Msk          (0x1ul << GPIO_SLEWCTL_HSREN2_Pos)                /*!< GPIO_T::SLEWCTL: HSREN2 Mask              */

#define GPIO_SLEWCTL_HSREN3_Pos          (3)                                               /*!< GPIO_T::SLEWCTL: HSREN3 Position          */
#define GPIO_SLEWCTL_HSREN3_Msk          (0x1ul << GPIO_SLEWCTL_HSREN3_Pos)                /*!< GPIO_T::SLEWCTL: HSREN3 Mask              */

#define GPIO_SLEWCTL_HSREN4_Pos          (4)                                               /*!< GPIO_T::SLEWCTL: HSREN4 Position          */
#define GPIO_SLEWCTL_HSREN4_Msk          (0x1ul << GPIO_SLEWCTL_HSREN4_Pos)                /*!< GPIO_T::SLEWCTL: HSREN4 Mask              */

#define GPIO_SLEWCTL_HSREN5_Pos          (5)                                               /*!< GPIO_T::SLEWCTL: HSREN5 Position          */
#define GPIO_SLEWCTL_HSREN5_Msk          (0x1ul << GPIO_SLEWCTL_HSREN5_Pos)                /*!< GPIO_T::SLEWCTL: HSREN5 Mask              */

#define GPIO_SLEWCTL_HSREN6_Pos          (6)                                               /*!< GPIO_T::SLEWCTL: HSREN6 Position          */
#define GPIO_SLEWCTL_HSREN6_Msk          (0x1ul << GPIO_SLEWCTL_HSREN6_Pos)                /*!< GPIO_T::SLEWCTL: HSREN6 Mask              */

#define GPIO_SLEWCTL_HSREN7_Pos          (7)                                               /*!< GPIO_T::SLEWCTL: HSREN7 Position          */
#define GPIO_SLEWCTL_HSREN7_Msk          (0x1ul << GPIO_SLEWCTL_HSREN7_Pos)                /*!< GPIO_T::SLEWCTL: HSREN7 Mask              */

#define GPIO_SLEWCTL_HSREN8_Pos          (8)                                               /*!< GPIO_T::SLEWCTL: HSREN8 Position          */
#define GPIO_SLEWCTL_HSREN8_Msk          (0x1ul << GPIO_SLEWCTL_HSREN8_Pos)                /*!< GPIO_T::SLEWCTL: HSREN8 Mask              */

#define GPIO_SLEWCTL_HSREN9_Pos          (9)                                               /*!< GPIO_T::SLEWCTL: HSREN9 Position          */
#define GPIO_SLEWCTL_HSREN9_Msk          (0x1ul << GPIO_SLEWCTL_HSREN9_Pos)                /*!< GPIO_T::SLEWCTL: HSREN9 Mask              */

#define GPIO_SLEWCTL_HSREN10_Pos         (10)                                              /*!< GPIO_T::SLEWCTL: HSREN10 Position         */
#define GPIO_SLEWCTL_HSREN10_Msk         (0x1ul << GPIO_SLEWCTL_HSREN10_Pos)               /*!< GPIO_T::SLEWCTL: HSREN10 Mask             */

#define GPIO_SLEWCTL_HSREN11_Pos         (11)                                              /*!< GPIO_T::SLEWCTL: HSREN11 Position         */
#define GPIO_SLEWCTL_HSREN11_Msk         (0x1ul << GPIO_SLEWCTL_HSREN11_Pos)               /*!< GPIO_T::SLEWCTL: HSREN11 Mask             */

#define GPIO_SLEWCTL_HSREN12_Pos         (12)                                              /*!< GPIO_T::SLEWCTL: HSREN12 Position         */
#define GPIO_SLEWCTL_HSREN12_Msk         (0x1ul << GPIO_SLEWCTL_HSREN12_Pos)               /*!< GPIO_T::SLEWCTL: HSREN12 Mask             */

#define GPIO_SLEWCTL_HSREN13_Pos         (13)                                              /*!< GPIO_T::SLEWCTL: HSREN13 Position         */
#define GPIO_SLEWCTL_HSREN13_Msk         (0x1ul << GPIO_SLEWCTL_HSREN13_Pos)               /*!< GPIO_T::SLEWCTL: HSREN13 Mask             */

#define GPIO_SLEWCTL_HSREN14_Pos         (14)                                              /*!< GPIO_T::SLEWCTL: HSREN14 Position         */
#define GPIO_SLEWCTL_HSREN14_Msk         (0x1ul << GPIO_SLEWCTL_HSREN14_Pos)               /*!< GPIO_T::SLEWCTL: HSREN14 Mask             */

#define GPIO_SLEWCTL_HSREN15_Pos         (15)                                              /*!< GPIO_T::SLEWCTL: HSREN15 Position         */
#define GPIO_SLEWCTL_HSREN15_Msk         (0x1ul << GPIO_SLEWCTL_HSREN15_Pos)               /*!< GPIO_T::SLEWCTL: HSREN15 Mask             */

#define GPIO_DRVCTL_HDRVEN8_Pos          (8)                                               /*!< GPIO_T::DRVCTL: HDRVEN8 Position          */
#define GPIO_DRVCTL_HDRVEN8_Msk          (0x1ul << GPIO_DRVCTL_HDRVEN8_Pos)                /*!< GPIO_T::DRVCTL: HDRVEN8 Mask              */

#define GPIO_DRVCTL_HDRVEN9_Pos          (9)                                               /*!< GPIO_T::DRVCTL: HDRVEN9 Position          */
#define GPIO_DRVCTL_HDRVEN9_Msk          (0x1ul << GPIO_DRVCTL_HDRVEN9_Pos)                /*!< GPIO_T::DRVCTL: HDRVEN9 Mask              */

#define GPIO_DRVCTL_HDRVEN10_Pos         (10)                                              /*!< GPIO_T::DRVCTL: HDRVEN10 Position         */
#define GPIO_DRVCTL_HDRVEN10_Msk         (0x1ul << GPIO_DRVCTL_HDRVEN10_Pos)               /*!< GPIO_T::DRVCTL: HDRVEN10 Mask             */

#define GPIO_DRVCTL_HDRVEN11_Pos         (11)                                              /*!< GPIO_T::DRVCTL: HDRVEN11 Position         */
#define GPIO_DRVCTL_HDRVEN11_Msk         (0x1ul << GPIO_DRVCTL_HDRVEN11_Pos)               /*!< GPIO_T::DRVCTL: HDRVEN11 Mask             */

#define GPIO_DRVCTL_HDRVEN12_Pos         (12)                                              /*!< GPIO_T::DRVCTL: HDRVEN12 Position         */
#define GPIO_DRVCTL_HDRVEN12_Msk         (0x1ul << GPIO_DRVCTL_HDRVEN12_Pos)               /*!< GPIO_T::DRVCTL: HDRVEN12 Mask             */

#define GPIO_DRVCTL_HDRVEN13_Pos         (13)                                              /*!< GPIO_T::DRVCTL: HDRVEN13 Position         */
#define GPIO_DRVCTL_HDRVEN13_Msk         (0x1ul << GPIO_DRVCTL_HDRVEN13_Pos)               /*!< GPIO_T::DRVCTL: HDRVEN13 Mask             */

#define GPIO_DBCTL_DBCLKSEL_Pos          (0)                                               /*!< GPIO_T::DBCTL: DBCLKSEL Position          */
#define GPIO_DBCTL_DBCLKSEL_Msk          (0xFul << GPIO_DBCTL_DBCLKSEL_Pos)                /*!< GPIO_T::DBCTL: DBCLKSEL Mask              */

#define GPIO_DBCTL_DBCLKSRC_Pos          (4)                                               /*!< GPIO_T::DBCTL: DBCLKSRC Position          */
#define GPIO_DBCTL_DBCLKSRC_Msk          (1ul << GPIO_DBCTL_DBCLKSRC_Pos)                  /*!< GPIO_T::DBCTL: DBCLKSRC Mask              */

#define GPIO_DBCTL_ICLKON_Pos            (5)                                               /*!< GPIO_T::DBCTL: ICLKON Position            */
#define GPIO_DBCTL_ICLKON_Msk            (1ul << GPIO_DBCTL_ICLKON_Pos)                    /*!< GPIO_T::DBCTL: ICLKON Mask                */


/**@}*/ /* GPIO_CONST */
/**@}*/ /* end of GPIO register group */


/*---------------------- Inter-IC Bus Controller -------------------------*/
/**
    @addtogroup I2C Inter-IC Bus Controller(I2C)
    Memory Mapped Structure for I2C Controller
@{ */


typedef struct
{




/**
 * @var I2C_T::CTL
 * Offset: 0x00  I2C Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[2]     |AA        |Assert Acknowledge Control
 * |        |          |When AA =1 prior to address or data is received, 
 * |        |          |an acknowledged (low level to SDA) will be returned during the acknowledge clock pulse on the SCL line when 
 * |        |          |1. A slave is acknowledging the address sent from master. 
 * |        |          |2. The receiver devices are acknowledging the data sent by transmitter.
 * |        |          |When AA=0 prior to address or data received, 
 * |        |          |a Not acknowledged (high level to SDA) will be returned during the acknowledge clock pulse on the SCL line.
 * |[3]     |SI        |I2C Interrupt Flag
 * |        |          |When a new I2C state is present in the I2C_STATUS register, the SI flag is set by hardware.
 * |        |          |If bit INTEN (I2C_CTL [7]) is set, the I2C interrupt is requested.
 * |        |          |SI must be cleared by software.
 * |        |          |Clear SI by writing 1 to this bit.
 * |        |          |For ACKMEN is set in slave read mode, the SI flag is set in 8th clock period for user to confirm the acknowledge bit and 9th clock period for user to read the data in the data buffer.
 * |[4]     |STO       |I2C STOP Control
 * |        |          |In Master mode, setting STO to transmit a STOP condition to bus then I2C controller will check the bus condition if a STOP condition is detected.
 * |        |          |This bit will be cleared by hardware automatically.
 * |[5]     |STA       |I2C START Control
 * |        |          |Setting STA to logic 1 to enter Master mode, the I2C hardware sends a START or repeat START condition to bus when the bus is free.
 * |[6]     |I2CEN     |I2C Controller Enable Bit
 * |        |          |Set to enable I2C serial function controller.
 * |        |          |When I2CEN=1 the I2C serial function enable.
 * |        |          |The multi-function pin function must set to SDA, and SCL of I2C function first.
 * |        |          |0 = Disabled.
 * |        |          |1 = Enabled.
 * |[7]     |INTEN     |Enable Interrupt
 * |        |          |0 = I2C interrupt Disabled.
 * |        |          |1 = I2C interrupt Enabled.
 * @var I2C_T::ADDR0
 * Offset: 0x04  I2C Slave Address Register0
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |GC        |General Call Function
 * |        |          |0 = General Call Function Disabled.
 * |        |          |1 = General Call Function Enabled.
 * |[7:1]   |ADDR      |I2C Address
 * |        |          |The content of this register is irrelevant when I2C is in Master mode.
 * |        |          |In the slave mode, the seven most significant bits must be loaded with the chip's own address.
 * |        |          |The I2C hardware will react if either of the address is matched.
 * @var I2C_T::DAT
 * Offset: 0x08  I2C Data Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[7:0]   |DAT       |I2C Data
 * |        |          |Bit [7:0] is located with the 8-bit transferred/received data of I2C serial port.
 * @var I2C_T::STATUS
 * Offset: 0x0C  I2C Status Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[7:0]   |STATUS    |I2C Status
 * |        |          |The three least significant bits are always 0.
 * |        |          |The five most significant bits contain the status code.
 * |        |          |There are 28 possible status codes.
 * |        |          |When the content of I2C_STATUS is F8H, no serial interrupt is requested.
 * |        |          |Others I2C_STATUS values correspond to defined I2C states.
 * |        |          |When each of these states is entered, a status interrupt is requested (SI = 1).
 * |        |          |A valid status code is present in I2C_STATUS one cycle after SI is set by hardware and is still present one cycle after SI has been reset by software.
 * |        |          |In addition, states 00H stands for a Bus Error.
 * |        |          |A Bus Error occurs when a START or STOP condition is present at an illegal position in the formation frame.
 * |        |          |Example of illegal position are during the serial transfer of an address byte, a data byte or an acknowledge bit.
 * |        |          |Note:
 * |        |          |1.
 * |        |          |If the BUSEN and ACKMEN are enabled in slave received mode, there is SI interrupt in the 8th clock.
 * |        |          |The user can read the I2C_STATUS = 0xf0 for the function condition has done.
 * |        |          |2.
 * |        |          |If the BUSEN and PECEN are enabled, the status of PECERR, I2C_BUSSTS[3], is used to substitute for I2C_STATUS to check the ACK status in the last frame when the byte count done interrupt has active and the PEC frame has been transformed.
 * @var I2C_T::CLKDIV
 * Offset: 0x10  I2C Clock Divided Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[7:0]   |DIVIDER   |I2C Clock Divided
 * |        |          |Indicates the I2C clock rate: Data Baud Rate of I2C = (system clock) / (4x (I2C_CLKDIV+1)).
 * |        |          |Note: The minimum value of I2C_CLKDIV is 4.
 * @var I2C_T::TOCTL
 * Offset: 0x14  I2C Time-out Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |TOIF      |Time-Out Flag
 * |        |          |This bit is set by hardware when I2C time-out happened and it can interrupt CPU if I2C interrupt enable bit (INTEN) is set to 1.
 * |        |          |Note: Software can write 1 to clear this bit.
 * |[1]     |TOCDIV4   |Time-Out Counter Input Clock Divided By 4
 * |        |          |When Enabled, The time-out period is extend 4 times.
 * |        |          |0 = Disabled.
 * |        |          |1 = Enabled.
 * |[2]     |TOCEN     |Time-Out Counter Enable Bit
 * |        |          |When Enabled, the 14-bit time-out counter will start counting when SI is clear.
 * |        |          |Setting flag SI to '1' will reset counter and re-start up counting after SI is cleared.
 * |        |          |0 = Disabled.
 * |        |          |1 = Enabled.
 * @var I2C_T::ADDR1
 * Offset: 0x18  I2C Slave Address Register1
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |GC        |General Call Function
 * |        |          |0 = General Call Function Disabled.
 * |        |          |1 = General Call Function Enabled.
 * |[7:1]   |ADDR      |I2C Address
 * |        |          |The content of this register is irrelevant when I2C is in Master mode.
 * |        |          |In the slave mode, the seven most significant bits must be loaded with the chip's own address.
 * |        |          |The I2C hardware will react if either of the address is matched.
 * @var I2C_T::ADDR2
 * Offset: 0x1C  I2C Slave Address Register2
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |GC        |General Call Function
 * |        |          |0 = General Call Function Disabled.
 * |        |          |1 = General Call Function Enabled.
 * |[7:1]   |ADDR      |I2C Address
 * |        |          |The content of this register is irrelevant when I2C is in Master mode.
 * |        |          |In the slave mode, the seven most significant bits must be loaded with the chip's own address.
 * |        |          |The I2C hardware will react if either of the address is matched.
 * @var I2C_T::ADDR3
 * Offset: 0x20  I2C Slave Address Register3
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |GC        |General Call Function
 * |        |          |0 = General Call Function Disabled.
 * |        |          |1 = General Call Function Enabled.
 * |[7:1]   |ADDR      |I2C Address
 * |        |          |The content of this register is irrelevant when I2C is in Master mode.
 * |        |          |In the slave mode, the seven most significant bits must be loaded with the chip's own address.
 * |        |          |The I2C hardware will react if either of the address is matched.
 * @var I2C_T::ADDRMSK0
 * Offset: 0x24  I2C Slave Address Mask Register0
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[7:1]   |ADDRMSK   |I2C Address Mask
 * |        |          |0 = Mask Disabled (the received corresponding register bit should be exact the same as address register.).
 * |        |          |1 = Mask Enabled (the received corresponding address bit is don't care.).
 * |        |          |I2C bus controllers support multiple address recognition with four address mask register.
 * |        |          |When the bit in the address mask register is set to one, it means the received corresponding address bit is don't-care.
 * |        |          |If the bit is set to zero, that means the received corresponding register bit should be exact the same as address register.
 * @var I2C_T::ADDRMSK1
 * Offset: 0x28  I2C Slave Address Mask Register1
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[7:1]   |ADDRMSK   |I2C Address Mask
 * |        |          |0 = Mask Disabled (the received corresponding register bit should be exact the same as address register.).
 * |        |          |1 = Mask Enabled (the received corresponding address bit is don't care.).
 * |        |          |I2C bus controllers support multiple address recognition with four address mask register.
 * |        |          |When the bit in the address mask register is set to one, it means the received corresponding address bit is don't-care.
 * |        |          |If the bit is set to zero, that means the received corresponding register bit should be exact the same as address register.
 * @var I2C_T::ADDRMSK2
 * Offset: 0x2C  I2C Slave Address Mask Register2
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[7:1]   |ADDRMSK   |I2C Address Mask
 * |        |          |0 = Mask Disabled (the received corresponding register bit should be exact the same as address register.).
 * |        |          |1 = Mask Enabled (the received corresponding address bit is don't care.).
 * |        |          |I2C bus controllers support multiple address recognition with four address mask register.
 * |        |          |When the bit in the address mask register is set to one, it means the received corresponding address bit is don't-care.
 * |        |          |If the bit is set to zero, that means the received corresponding register bit should be exact the same as address register.
 * @var I2C_T::ADDRMSK3
 * Offset: 0x30  I2C Slave Address Mask Register3
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[7:1]   |ADDRMSK   |I2C Address Mask
 * |        |          |0 = Mask Disabled (the received corresponding register bit should be exact the same as address register.).
 * |        |          |1 = Mask Enabled (the received corresponding address bit is don't care.).
 * |        |          |I2C bus controllers support multiple address recognition with four address mask register.
 * |        |          |When the bit in the address mask register is set to one, it means the received corresponding address bit is don't-care.
 * |        |          |If the bit is set to zero, that means the received corresponding register bit should be exact the same as address register.
 * @var I2C_T::WKCTL
 * Offset: 0x3C  I2C Wake-up Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |WKEN      |I2C Wake-Up Enable Bit
 * |        |          |0 = I2C wake-up function Disabled.
 * |        |          |1= I2C wake-up function Enabled.
 * @var I2C_T::WKSTS
 * Offset: 0x40  I2C Wake-up Status Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |WKIF      |I2C Wake-Up Flag
 * |        |          |When chip is woken up from Power-down mode by I2C, this bit is set to 1.
 * |        |          |Software can write 1 to clear this bit.
 * @var I2C_T::BUSCTL
 * Offset: 0x44  I2C Bus Management Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |ACKMEN    |Acknowledge Control By Manual
 * |        |          |In order to allow ACK control in slave reception including the command and data, slave byte control mode must be enabled by setting the ACKMEN bit.
 * |        |          |0 = Slave byte control Disabled.
 * |        |          |1 = Slave byte control Enabled.
 * |        |          |The 9th bit can response the ACK or NACK according the received data by user.
 * |        |          |When the byte is received, stretching the SCLK signal low between the 8th and 9th SCLK pulse.
 * |        |          |Note: If the BMDEN =1 and this bit is enabled, the information of I2C_STATUS will be fixed as 0xF0 in slave receive condition.
 * |[1]     |PECEN     |Packet Error Checking Calculation Enable Bit
 * |        |          |0 = Packet Error Checking Calculation Disabled.
 * |        |          |1 = Packet Error Checking Calculation Enabled.
 * |[2]     |BMDEN     |Bus Management Device Default Address Enable Bit
 * |        |          |0 = Device default address Disable.
 * |        |          |When the address 0'b1100001x coming and the both of BMDEN and ACKMEN are enabled, the device responses NACKed.
 * |        |          |1 = Device default address Enabled.
 * |        |          |When the address 0'b1100001x coming and the both of BMDEN and ACKMEN are enabled, the device responses ACKed.
 * |[3]     |BMHEN     |Bus Management Host Enable Bit
 * |        |          |0 = Host function Disabled.
 * |        |          |1 = Host function Enabled and the SUSCON will be used as CONTROL function.
 * |[4]     |ALERTEN   |Bus Management Alert Enable Bit
 * |        |          |Device Mode (BMHEN =0).
 * |        |          |0 = Release the BM_ALERT pin high and Alert Response Header disabled: 0001100x followed by NACK if both of BMDEN and ACKMEN are enabled.
 * |        |          |1 = Drive BM_ALERT pin low and Alert Response Address Header enables: 0001100x followed by ACK if both of BMDEN and ACKMEN are enabled.
 * |        |          |Host Mode (BMHEN =1).
 * |        |          |0 = BM_ALERT pin not supported.
 * |        |          |1 = BM_ALERT pin supported.
 * |[5]     |SCTLOSTS  |Suspend/Control Data Output Status
 * |        |          |0 = The output of SUSCON pin is low.
 * |        |          |1 = The output of SUSCON pin is high.
 * |[6]     |SCTLOEN   |Suspend Or Control Pin Output Enable Bit
 * |        |          |0 = The SUSCON pin in input.
 * |        |          |1 = The output enable is active on the SUSCON pin.
 * |[7]     |BUSEN     |BUS Enable Bit
 * |        |          |0 = The system management function is Disabled.
 * |        |          |1 = The system management function is Enable.
 * |        |          |Note: When the bit is enabled, the internal 14-bit counter is used to calculate the time out event of clock low condition.
 * |[8]     |PECTXEN   |Packet Error Checking Byte Transmission/Reception
 * |        |          |This bit is set by software, and cleared by hardware when the PEC is transferred, or when a STOP condition or an Address Matched is received
 * |        |          |0 = No PEC transfer.
 * |        |          |1 = PEC transmission/reception is requested.
 * |        |          |Note: 1.This bit has no effect in slave mode when ACKMEN =0.
 * |[9]     |TIDLE     |Timer Check In Idle State
 * |        |          |The BUSTOUT is used to calculate the time-out of clock low in bus active and the idle period in bus Idle.
 * |        |          |This bit is used to define which condition is enabled.
 * |        |          |0 = The BUSTOUT is used to calculate the clock low period in bus active.
 * |        |          |1 = The BUSTOUT is used to calculate the IDLE period in bus Idle.
 * |        |          |Note: The BUSY (I2C_BUSSTS[0]) indicate the current bus state.
 * |[10]    |PECCLR    |PEC Clear At Repeat Start
 * |        |          |The calculation of PEC starts when PECEN is set to 1 and it is clear when the STA or STO bit is detected.
 * |        |          |This PECCLR bit is used to enable the condition of REPEAT START can clear the PEC calculation.
 * |        |          |0 = The PEC calculation is cleared by "Repeat Start" function is Disabled.
 * |        |          |1 = The PEC calculation is cleared by "Repeat Start" function is Enabled.
 * |[11]    |ACKM9SI   |Acknowledge Manual Enable Extra SI Interrupt
 * |        |          |0 = There is no SI interrupt in the 9th clock cycle when the BUSEN =1 and ACKMEN =1.
 * |        |          |1 = There is SI interrupt in the 9th clock cycle when the BUSEN =1 and ACKMEN =1.
 * @var I2C_T::BUSTCTL
 * Offset: 0x48  I2C Bus Management Timer Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |BUSTOEN   |Bus Time Out Enable Bit
 * |        |          |0 = Indicates the bus clock low time-out detection is Disabled.
 * |        |          |1 = Indicates the bus clock low time-out detection is Enabled 
 * |        |          |bus clock is low for more than Time-out (in BIDLE=0) or high more than Time-out(in BIDLE =1),
 * |[1]     |CLKTOEN   |Cumulative Clock Low Time Out Enable Bit
 * |        |          |0 = Indicates the cumulative clock low time-out detection is Disabled.
 * |        |          |1 = Indicates the cumulative clock low time-out detection is Enabled.
 * |        |          |For Master, it calculates the period from START to ACK
 * |        |          |For Slave, it calculates the period from START to STOP
 * |[2]     |BUSTOIEN  |Time-Out Interrupt Enable Bit
 * |        |          |BUSY =1.
 * |        |          |0 = Indicates the SCLK low time-out interrupt is Disabled.
 * |        |          |1 = Indicates the SCLK low time-out interrupt is Enabled.
 * |        |          |BUSY =0.
 * |        |          |0 = Indicates the bus IDLE time-out interrupt is Disabled.
 * |        |          |1 = Indicates the bus IDLE time-out interrupt is Enabled.
 * |[3]     |CLKTOIEN  |Extended Clock Time Out Interrupt Enable Bit
 * |        |          |0 = Indicates the time extended interrupt is Disabled.
 * |        |          |1 = Indicates the time extended interrupt is Enabled.
 * |[4]     |TORSTEN   |Time Out Reset Enable Bit
 * |        |          |0 = Indicates the I2C state machine reset is Disable.
 * |        |          |1 = Indicates the I2C state machine reset is Enable. (The clock and data bus will be released to high)
 * |[5]     |PECIEN    |Packet Error Checking Byte Count Done Interrupt Enable Bit
 * |        |          |0 = Indicates the byte count done interrupt is Disabled.
 * |        |          |1 = Indicates the byte count done interrupt is Enabled.
 * |        |          |Note: This bit is used in PECEN =1.
 * @var I2C_T::BUSSTS
 * Offset: 0x4C  I2C Bus Management Status Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |BUSY      |Bus Busy
 * |        |          |Indicates that a communication is in progress on the bus.
 * |        |          |It is set by hardware when a START condition is detected.
 * |        |          |It is cleared by hardware when a STOP condition is detected.
 * |        |          |0 = The bus is IDLE (both SCLK and SDA High).
 * |        |          |1 = The bus is busy.
 * |[1]     |BCDONE    |Byte Count Transmission/Receive Done
 * |        |          |0 = Indicates the transmission/ receive is not finished when the PECEN is set.
 * |        |          |1 = Indicates the transmission/ receive is finished when the PECEN is set.
 * |        |          |Note: Software can write 1 to clear this bit.
 * |[2]     |PECERR    |PEC Error In Reception
 * |        |          |0 = Indicates the PEC value equal the received PEC data packet.
 * |        |          |1 = Indicates the PEC value doesn't match the receive PEC data packet.
 * |        |          |Note: Software can write 1 to clear this bit.
 * |[3]     |ALERT     |SMBus Alert Status
 * |        |          |Device Mode (BMHEN =0).
 * |        |          |0 = Indicates SMALERT pin state is low.
 * |        |          |1 = Indicates SMALERT pin state is high
 * |        |          |Host Mode (BMHEN =1).
 * |        |          |0 = No SMBALERT event.
 * |        |          |1 = Indicates there is SMBALERT event (falling edge) is detected in SMALERT pin when the BMHEN = 1 (SMBus host configuration) and the ALERTEN = 1.
 * |        |          |Note: 1.
 * |        |          |The SMALERT pin is an open-drain pin, the pull-high resistor is must in the system.
 * |        |          |2.
 * |        |          |Software can write 1 to clear this bit.
 * |[4]     |SCTLDIN   |Bus Suspend Or Control Signal Input Status
 * |        |          |0 = The input status of SUSCON pin is 0.
 * |        |          |1 = The input status of SUSCON pin is 1.
 * |[5]     |BUSTO     |Bus Time-out Status
 * |        |          |0 = Indicates that there is no any time-out or external clock time-out.
 * |        |          |1 = Indicates that a time-out or external clock time-out occurred.
 * |        |          |In bus busy, the bit indicates the total clock low time-out event occurred otherwise, it indicates the bus idle time-out event occurred.
 * |        |          |Note: Software can write 1 to clear this bit.
 * |[6]     |CLKTO     |Clock Low Cumulate Time-out Status
 * |        |          |0 = Indicates that the cumulative clock low is no any time-out.
 * |        |          |1 = Indicates that the cumulative clock low time-out occurred.
 * |        |          |Note: Software can write 1 to clear this bit.
 * @var I2C_T::PKTSIZE
 * Offset: 0x50  I2C Packet Error Checking Byte Number Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[7:0]   |PLDSIZE   |Transfer Byte Number
 * |        |          |The transmission or receive byte number in one transaction when the PECEN is set.
 * |        |          |The maximum transaction or receive byte is 255 Bytes.
 * @var I2C_T::PKTCRC
 * Offset: 0x54  I2C Packet Error Checking Byte Value Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[7:0]   |PECCRC    |Packet Error Checking Byte Value
 * |        |          |This byte indicates the packet error checking content after transmission or receive byte count by using the C(x) = X8 + X2 + X + 1.
 * |        |          |I t is read only.
 * @var I2C_T::BUSTOUT
 * Offset: 0x58  I2C Bus Management Timer Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[7:0]   |BUSTO     |Bus Management Time-out Value
 * |        |          |Indicate the bus time-out value in bus is IDLE or SCLK low.
 * |        |          |Note: If the user wants to revise the value of BUSTOUT, the TORSTEN (I2C_BUSTCTL[4]) bit shall be set to 1 and clear to 0 first in the BUSEN(I2C_BUSCTL[7]) is set.
 * @var I2C_T::CLKTOUT
 * Offset: 0x5C  I2C Bus Management Clock Low Timer Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[7:0]   |CLKTO     |Bus Clock Low Timer
 * |        |          |The field is used to configure the cumulative clock extension time-out.
 * |        |          |Note: If the user wants to revise the value of CLKLTOUT, the TORSTEN bit shall be set to 1 and d clear to 0 first in the BUSEN is set.
    */

    __IO uint32_t CTL;           /* Offset: 0x00  I2C Control Register                                               */
    __IO uint32_t ADDR0;         /* Offset: 0x04  I2C Slave Address Register0                                        */
    __IO uint32_t DAT;           /* Offset: 0x08  I2C Data Register                                                  */
    __I  uint32_t STATUS;        /* Offset: 0x0C  I2C Status Register                                                */
    __IO uint32_t CLKDIV;        /* Offset: 0x10  I2C Clock Divided Register                                         */
    __IO uint32_t TOCTL;         /* Offset: 0x14  I2C Time-out Control Register                                      */
    __IO uint32_t ADDR1;         /* Offset: 0x18  I2C Slave Address Register1                                        */
    __IO uint32_t ADDR2;         /* Offset: 0x1C  I2C Slave Address Register2                                        */
    __IO uint32_t ADDR3;         /* Offset: 0x20  I2C Slave Address Register3                                        */
    __IO uint32_t ADDRMSK0;      /* Offset: 0x24  I2C Slave Address Mask Register0                                   */
    __IO uint32_t ADDRMSK1;      /* Offset: 0x28  I2C Slave Address Mask Register1                                   */
    __IO uint32_t ADDRMSK2;      /* Offset: 0x2C  I2C Slave Address Mask Register2                                   */
    __IO uint32_t ADDRMSK3;      /* Offset: 0x30  I2C Slave Address Mask Register3                                   */
    __I  uint32_t RESERVE0[2];  
    __IO uint32_t WKCTL;         /* Offset: 0x3C  I2C Wake-up Control Register                                       */
    __IO uint32_t WKSTS;         /* Offset: 0x40  I2C Wake-up Status Register                                        */
    __IO uint32_t BUSCTL;        /* Offset: 0x44  I2C Bus Management Control Register                                */
    __IO uint32_t BUSTCTL;       /* Offset: 0x48  I2C Bus Management Timer Control Register                          */
    __IO uint32_t BUSSTS;        /* Offset: 0x4C  I2C Bus Management Status Register                                 */
    __IO uint32_t PKTSIZE;       /* Offset: 0x50  I2C Packet Error Checking Byte Number Register                     */
    __I  uint32_t PKTCRC;        /* Offset: 0x54  I2C Packet Error Checking Byte Value Register                      */
    __IO uint32_t BUSTOUT;       /* Offset: 0x58  I2C Bus Management Timer Register                                  */
    __IO uint32_t CLKTOUT;       /* Offset: 0x5C  I2C Bus Management Clock Low Timer Register                        */

} I2C_T;



/**
    @addtogroup I2C_CONST I2C Bit Field Definition
    Constant Definitions for I2C Controller
@{ */

#define I2C_CTL_AA_Pos                   (2)                                               /*!< I2C_T::CTL: AA Position                   */
#define I2C_CTL_AA_Msk                   (0x1ul << I2C_CTL_AA_Pos)                         /*!< I2C_T::CTL: AA Mask                       */

#define I2C_CTL_SI_Pos                   (3)                                               /*!< I2C_T::CTL: SI Position                   */
#define I2C_CTL_SI_Msk                   (0x1ul << I2C_CTL_SI_Pos)                         /*!< I2C_T::CTL: SI Mask                       */

#define I2C_CTL_STO_Pos                  (4)                                               /*!< I2C_T::CTL: STO Position                  */
#define I2C_CTL_STO_Msk                  (0x1ul << I2C_CTL_STO_Pos)                        /*!< I2C_T::CTL: STO Mask                      */

#define I2C_CTL_STA_Pos                  (5)                                               /*!< I2C_T::CTL: STA Position                  */
#define I2C_CTL_STA_Msk                  (0x1ul << I2C_CTL_STA_Pos)                        /*!< I2C_T::CTL: STA Mask                      */

#define I2C_CTL_I2CEN_Pos                (6)                                               /*!< I2C_T::CTL: I2CEN Position                */
#define I2C_CTL_I2CEN_Msk                (0x1ul << I2C_CTL_I2CEN_Pos)                      /*!< I2C_T::CTL: I2CEN Mask                    */

#define I2C_CTL_INTEN_Pos                (7)                                               /*!< I2C_T::CTL: INTEN Position                */
#define I2C_CTL_INTEN_Msk                (0x1ul << I2C_CTL_INTEN_Pos)                      /*!< I2C_T::CTL: INTEN Mask                    */

#define I2C_ADDR0_GC_Pos                 (0)                                               /*!< I2C_T::ADDR0: GC Position                 */
#define I2C_ADDR0_GC_Msk                 (0x1ul << I2C_ADDR0_GC_Pos)                       /*!< I2C_T::ADDR0: GC Mask                     */

#define I2C_ADDR0_ADDR_Pos               (1)                                               /*!< I2C_T::ADDR0: ADDR Position               */
#define I2C_ADDR0_ADDR_Msk               (0x7ful << I2C_ADDR0_ADDR_Pos)                    /*!< I2C_T::ADDR0: ADDR Mask                   */

#define I2C_DAT_DAT_Pos                  (0)                                               /*!< I2C_T::DAT: DAT Position                  */
#define I2C_DAT_DAT_Msk                  (0xfful << I2C_DAT_DAT_Pos)                       /*!< I2C_T::DAT: DAT Mask                      */

#define I2C_STATUS_STATUS_Pos            (0)                                               /*!< I2C_T::STATUS: STATUS Position            */
#define I2C_STATUS_STATUS_Msk            (0xfful << I2C_STATUS_STATUS_Pos)                 /*!< I2C_T::STATUS: STATUS Mask                */

#define I2C_CLKDIV_DIVIDER_Pos           (0)                                               /*!< I2C_T::CLKDIV: DIVIDER Position           */
#define I2C_CLKDIV_DIVIDER_Msk           (0xfful << I2C_CLKDIV_DIVIDER_Pos)                /*!< I2C_T::CLKDIV: DIVIDER Mask               */

#define I2C_TOCTL_TOIF_Pos               (0)                                               /*!< I2C_T::TOCTL: TOIF Position               */
#define I2C_TOCTL_TOIF_Msk               (0x1ul << I2C_TOCTL_TOIF_Pos)                     /*!< I2C_T::TOCTL: TOIF Mask                   */

#define I2C_TOCTL_TOCDIV4_Pos            (1)                                               /*!< I2C_T::TOCTL: TOCDIV4 Position            */
#define I2C_TOCTL_TOCDIV4_Msk            (0x1ul << I2C_TOCTL_TOCDIV4_Pos)                  /*!< I2C_T::TOCTL: TOCDIV4 Mask                */

#define I2C_TOCTL_TOCEN_Pos              (2)                                               /*!< I2C_T::TOCTL: TOCEN Position              */
#define I2C_TOCTL_TOCEN_Msk              (0x1ul << I2C_TOCTL_TOCEN_Pos)                    /*!< I2C_T::TOCTL: TOCEN Mask                  */

#define I2C_ADDR1_GC_Pos                 (0)                                               /*!< I2C_T::ADDR1: GC Position                 */
#define I2C_ADDR1_GC_Msk                 (0x1ul << I2C_ADDR1_GC_Pos)                       /*!< I2C_T::ADDR1: GC Mask                     */

#define I2C_ADDR1_ADDR_Pos               (1)                                               /*!< I2C_T::ADDR1: ADDR Position               */
#define I2C_ADDR1_ADDR_Msk               (0x7ful << I2C_ADDR1_ADDR_Pos)                    /*!< I2C_T::ADDR1: ADDR Mask                   */

#define I2C_ADDR2_GC_Pos                 (0)                                               /*!< I2C_T::ADDR2: GC Position                 */
#define I2C_ADDR2_GC_Msk                 (0x1ul << I2C_ADDR2_GC_Pos)                       /*!< I2C_T::ADDR2: GC Mask                     */

#define I2C_ADDR2_ADDR_Pos               (1)                                               /*!< I2C_T::ADDR2: ADDR Position               */
#define I2C_ADDR2_ADDR_Msk               (0x7ful << I2C_ADDR2_ADDR_Pos)                    /*!< I2C_T::ADDR2: ADDR Mask                   */

#define I2C_ADDR3_GC_Pos                 (0)                                               /*!< I2C_T::ADDR3: GC Position                 */
#define I2C_ADDR3_GC_Msk                 (0x1ul << I2C_ADDR3_GC_Pos)                       /*!< I2C_T::ADDR3: GC Mask                     */

#define I2C_ADDR3_ADDR_Pos               (1)                                               /*!< I2C_T::ADDR3: ADDR Position               */
#define I2C_ADDR3_ADDR_Msk               (0x7ful << I2C_ADDR3_ADDR_Pos)                    /*!< I2C_T::ADDR3: ADDR Mask                   */

#define I2C_ADDRMSK0_ADDRMSK_Pos         (1)                                               /*!< I2C_T::ADDRMSK0: ADDRMSK Position         */
#define I2C_ADDRMSK0_ADDRMSK_Msk         (0x7ful << I2C_ADDRMSK0_ADDRMSK_Pos)              /*!< I2C_T::ADDRMSK0: ADDRMSK Mask             */

#define I2C_ADDRMSK1_ADDRMSK_Pos         (1)                                               /*!< I2C_T::ADDRMSK1: ADDRMSK Position         */
#define I2C_ADDRMSK1_ADDRMSK_Msk         (0x7ful << I2C_ADDRMSK1_ADDRMSK_Pos)              /*!< I2C_T::ADDRMSK1: ADDRMSK Mask             */

#define I2C_ADDRMSK2_ADDRMSK_Pos         (1)                                               /*!< I2C_T::ADDRMSK2: ADDRMSK Position         */
#define I2C_ADDRMSK2_ADDRMSK_Msk         (0x7ful << I2C_ADDRMSK2_ADDRMSK_Pos)              /*!< I2C_T::ADDRMSK2: ADDRMSK Mask             */

#define I2C_ADDRMSK3_ADDRMSK_Pos         (1)                                               /*!< I2C_T::ADDRMSK3: ADDRMSK Position         */
#define I2C_ADDRMSK3_ADDRMSK_Msk         (0x7ful << I2C_ADDRMSK3_ADDRMSK_Pos)              /*!< I2C_T::ADDRMSK3: ADDRMSK Mask             */

#define I2C_WKCTL_WKEN_Pos               (0)                                               /*!< I2C_T::WKCTL: WKEN Position               */
#define I2C_WKCTL_WKEN_Msk               (0x1ul << I2C_WKCTL_WKEN_Pos)                     /*!< I2C_T::WKCTL: WKEN Mask                   */

#define I2C_WKSTS_WKIF_Pos               (0)                                               /*!< I2C_T::WKSTS: WKIF Position               */
#define I2C_WKSTS_WKIF_Msk               (0x1ul << I2C_WKSTS_WKIF_Pos)                     /*!< I2C_T::WKSTS: WKIF Mask                   */

#define I2C_BUSCTL_ACKMEN_Pos            (0)                                               /*!< I2C_T::BUSCTL: ACKMEN Position            */
#define I2C_BUSCTL_ACKMEN_Msk            (0x1ul << I2C_BUSCTL_ACKMEN_Pos)                  /*!< I2C_T::BUSCTL: ACKMEN Mask                */

#define I2C_BUSCTL_PECEN_Pos             (1)                                               /*!< I2C_T::BUSCTL: PECEN Position             */
#define I2C_BUSCTL_PECEN_Msk             (0x1ul << I2C_BUSCTL_PECEN_Pos)                   /*!< I2C_T::BUSCTL: PECEN Mask                 */

#define I2C_BUSCTL_BMDEN_Pos             (2)                                               /*!< I2C_T::BUSCTL: BMDEN Position             */
#define I2C_BUSCTL_BMDEN_Msk             (0x1ul << I2C_BUSCTL_BMDEN_Pos)                   /*!< I2C_T::BUSCTL: BMDEN Mask                 */

#define I2C_BUSCTL_BMHEN_Pos             (3)                                               /*!< I2C_T::BUSCTL: BMHEN Position             */
#define I2C_BUSCTL_BMHEN_Msk             (0x1ul << I2C_BUSCTL_BMHEN_Pos)                   /*!< I2C_T::BUSCTL: BMHEN Mask                 */

#define I2C_BUSCTL_ALERTEN_Pos           (4)                                               /*!< I2C_T::BUSCTL: ALERTEN Position           */
#define I2C_BUSCTL_ALERTEN_Msk           (0x1ul << I2C_BUSCTL_ALERTEN_Pos)                 /*!< I2C_T::BUSCTL: ALERTEN Mask               */

#define I2C_BUSCTL_SCTLOSTS_Pos          (5)                                               /*!< I2C_T::BUSCTL: SCTLOSTS Position          */
#define I2C_BUSCTL_SCTLOSTS_Msk          (0x1ul << I2C_BUSCTL_SCTLOSTS_Pos)                /*!< I2C_T::BUSCTL: SCTLOSTS Mask              */

#define I2C_BUSCTL_SCTLOEN_Pos           (6)                                               /*!< I2C_T::BUSCTL: SCTLOEN Position           */
#define I2C_BUSCTL_SCTLOEN_Msk           (0x1ul << I2C_BUSCTL_SCTLOEN_Pos)                 /*!< I2C_T::BUSCTL: SCTLOEN Mask               */

#define I2C_BUSCTL_BUSEN_Pos             (7)                                               /*!< I2C_T::BUSCTL: BUSEN Position             */
#define I2C_BUSCTL_BUSEN_Msk             (0x1ul << I2C_BUSCTL_BUSEN_Pos)                   /*!< I2C_T::BUSCTL: BUSEN Mask                 */

#define I2C_BUSCTL_PECTXEN_Pos           (8)                                               /*!< I2C_T::BUSCTL: PECTXEN Position           */
#define I2C_BUSCTL_PECTXEN_Msk           (0x1ul << I2C_BUSCTL_PECTXEN_Pos)                 /*!< I2C_T::BUSCTL: PECTXEN Mask               */

#define I2C_BUSCTL_TIDLE_Pos             (9)                                               /*!< I2C_T::BUSCTL: TIDLE Position             */
#define I2C_BUSCTL_TIDLE_Msk             (0x1ul << I2C_BUSCTL_TIDLE_Pos)                   /*!< I2C_T::BUSCTL: TIDLE Mask                 */

#define I2C_BUSCTL_PECCLR_Pos            (10)                                              /*!< I2C_T::BUSCTL: PECCLR Position            */
#define I2C_BUSCTL_PECCLR_Msk            (0x1ul << I2C_BUSCTL_PECCLR_Pos)                  /*!< I2C_T::BUSCTL: PECCLR Mask                */

#define I2C_BUSCTL_ACKM9SI_Pos           (11)                                              /*!< I2C_T::BUSCTL: ACKM9SI Position           */
#define I2C_BUSCTL_ACKM9SI_Msk           (0x1ul << I2C_BUSCTL_ACKM9SI_Pos)                 /*!< I2C_T::BUSCTL: ACKM9SI Mask               */

#define I2C_BUSTCTL_BUSTOEN_Pos          (0)                                               /*!< I2C_T::BUSTCTL: BUSTOEN Position          */
#define I2C_BUSTCTL_BUSTOEN_Msk          (0x1ul << I2C_BUSTCTL_BUSTOEN_Pos)                /*!< I2C_T::BUSTCTL: BUSTOEN Mask              */

#define I2C_BUSTCTL_CLKTOEN_Pos          (1)                                               /*!< I2C_T::BUSTCTL: CLKTOEN Position          */
#define I2C_BUSTCTL_CLKTOEN_Msk          (0x1ul << I2C_BUSTCTL_CLKTOEN_Pos)                /*!< I2C_T::BUSTCTL: CLKTOEN Mask              */

#define I2C_BUSTCTL_BUSTOIEN_Pos         (2)                                               /*!< I2C_T::BUSTCTL: BUSTOIEN Position         */
#define I2C_BUSTCTL_BUSTOIEN_Msk         (0x1ul << I2C_BUSTCTL_BUSTOIEN_Pos)               /*!< I2C_T::BUSTCTL: BUSTOIEN Mask             */

#define I2C_BUSTCTL_CLKTOIEN_Pos         (3)                                               /*!< I2C_T::BUSTCTL: CLKTOIEN Position         */
#define I2C_BUSTCTL_CLKTOIEN_Msk         (0x1ul << I2C_BUSTCTL_CLKTOIEN_Pos)               /*!< I2C_T::BUSTCTL: CLKTOIEN Mask             */

#define I2C_BUSTCTL_TORSTEN_Pos          (4)                                               /*!< I2C_T::BUSTCTL: TORSTEN Position          */
#define I2C_BUSTCTL_TORSTEN_Msk          (0x1ul << I2C_BUSTCTL_TORSTEN_Pos)                /*!< I2C_T::BUSTCTL: TORSTEN Mask              */

#define I2C_BUSTCTL_PECIEN_Pos           (5)                                               /*!< I2C_T::BUSTCTL: PECIEN Position           */
#define I2C_BUSTCTL_PECIEN_Msk           (0x1ul << I2C_BUSTCTL_PECIEN_Pos)                 /*!< I2C_T::BUSTCTL: PECIEN Mask               */

#define I2C_BUSSTS_BUSY_Pos              (0)                                               /*!< I2C_T::BUSSTS: BUSY Position              */
#define I2C_BUSSTS_BUSY_Msk              (0x1ul << I2C_BUSSTS_BUSY_Pos)                    /*!< I2C_T::BUSSTS: BUSY Mask                  */

#define I2C_BUSSTS_BCDONE_Pos            (1)                                               /*!< I2C_T::BUSSTS: BCDONE Position            */
#define I2C_BUSSTS_BCDONE_Msk            (0x1ul << I2C_BUSSTS_BCDONE_Pos)                  /*!< I2C_T::BUSSTS: BCDONE Mask                */

#define I2C_BUSSTS_PECERR_Pos            (2)                                               /*!< I2C_T::BUSSTS: PECERR Position            */
#define I2C_BUSSTS_PECERR_Msk            (0x1ul << I2C_BUSSTS_PECERR_Pos)                  /*!< I2C_T::BUSSTS: PECERR Mask                */

#define I2C_BUSSTS_ALERT_Pos             (3)                                               /*!< I2C_T::BUSSTS: ALERT Position             */
#define I2C_BUSSTS_ALERT_Msk             (0x1ul << I2C_BUSSTS_ALERT_Pos)                   /*!< I2C_T::BUSSTS: ALERT Mask                 */

#define I2C_BUSSTS_SCTLDIN_Pos           (4)                                               /*!< I2C_T::BUSSTS: SCTLDIN Position           */
#define I2C_BUSSTS_SCTLDIN_Msk           (0x1ul << I2C_BUSSTS_SCTLDIN_Pos)                 /*!< I2C_T::BUSSTS: SCTLDIN Mask               */

#define I2C_BUSSTS_BUSTO_Pos             (5)                                               /*!< I2C_T::BUSSTS: BUSTO Position             */
#define I2C_BUSSTS_BUSTO_Msk             (0x1ul << I2C_BUSSTS_BUSTO_Pos)                   /*!< I2C_T::BUSSTS: BUSTO Mask                 */

#define I2C_BUSSTS_CLKTO_Pos             (6)                                               /*!< I2C_T::BUSSTS: CLKTO Position             */
#define I2C_BUSSTS_CLKTO_Msk             (0x1ul << I2C_BUSSTS_CLKTO_Pos)                   /*!< I2C_T::BUSSTS: CLKTO Mask                 */

#define I2C_PKTSIZE_PLDSIZE_Pos          (0)                                               /*!< I2C_T::PKTSIZE: PLDSIZE Position          */
#define I2C_PKTSIZE_PLDSIZE_Msk          (0xfful << I2C_PKTSIZE_PLDSIZE_Pos)               /*!< I2C_T::PKTSIZE: PLDSIZE Mask              */

#define I2C_PKTCRC_PECCRC_Pos            (0)                                               /*!< I2C_T::PKTCRC: PECCRC Position            */
#define I2C_PKTCRC_PECCRC_Msk            (0xfful << I2C_PKTCRC_PECCRC_Pos)                 /*!< I2C_T::PKTCRC: PECCRC Mask                */

#define I2C_BUSTOUT_BUSTO_Pos            (0)                                               /*!< I2C_T::BUSTOUT: BUSTO Position            */
#define I2C_BUSTOUT_BUSTO_Msk            (0xfful << I2C_BUSTOUT_BUSTO_Pos)                 /*!< I2C_T::BUSTOUT: BUSTO Mask                */

#define I2C_CLKTOUT_CLKTO_Pos            (0)                                               /*!< I2C_T::CLKTOUT: CLKTO Position            */
#define I2C_CLKTOUT_CLKTO_Msk            (0xfful << I2C_CLKTOUT_CLKTO_Pos)                 /*!< I2C_T::CLKTOUT: CLKTO Mask                */


/**@}*/ /* I2C_CONST */
/**@}*/ /* end of I2C register group */

/*---------------------- USB On-The-Go Controller -------------------------*/
/**
    @addtogroup OTG USB On-The-Go Controller(OTG)
    Memory Mapped Structure for OTG Controller
@{ */


typedef struct
{


/**
 * @var OTG_T::CTL
 * Offset: 0x00  OTG Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |VBUSDROP  |Drop VBUS Control
 * |        |          |If user application running on this OTG A-device wants to conserve power, set this bit to drop VBUS.
 * |        |          |BUSREQ (OTG_CTL[1]) will be also cleared no matter A-device or B-device.
 * |        |          |0 = Not drop the VBUS.
 * |        |          |1 = Drop the VBUS.
 * |[1]     |BUSREQ    |OTG Bus Request
 * |        |          |If OTG A-device wants to do data transfers via USB bus, setting this bit will drive VBUS high to detect USB device connection.
 * |        |          |If user won't use the bus any more, clearing this bit will drop VBUS to save power.
 * |        |          |This bit will be cleared when A-device goes to A_wait_vfall state. A_wait_vfall state is defined in OTG specification.
 * |        |          |This bit will be also cleared if VBUSDROP (OTG_CTL[0]) bit is set or IDSTS (OTG_STATUS[1]) changed.
 * |        |          |If user of an OTG-B Device wants to request VBUS, setting this bit will run SRP protocol.
 * |        |          |This bit will be cleared if SRP failure (OTG A-device does not provide VBUS after B-device issues ARP in specified interval, defined in OTG specification).
 * |        |          |This bit will be also cleared if VBUSDROP (OTG_CTL[0]) bit is set IDSTS (OTG_STATUS[1]) changed.
 * |        |          |0 = Not launch VBUS in OTG A-device or not request SRP in OTG B-device.
 * |        |          |1 = Launch VBUS in OTG A-device or request SRP in OTG B-device.
 * |[2]     |HNPREQEN  |OTG HNP Request Enable Bit
 * |        |          |When USB frame as A-device, set this bit when A-device allows to process Host Negotiation Protocol.
 * |        |          |This bit will be cleared when OTG state changes from a_suspend to a_peripheral or goes back to a_idle state.
 * |        |          |When USB frame is as B-device, set this bit after the OTG A-device successfully sends a SetFeature (b_hnp_enable) command to the OTG B-device to start role change.
 * |        |          |This bit will be cleared when OTG state changes from b_peripheral to b_wait_acon or goes back to b_idle state.
 * |        |          |0 = HNP request Disabled.
 * |        |          |1 = HNP request Enabled (A-device can change role from Host to Peripheral or B-device can change role from Peripheral to Host).
 * |        |          |Note: Refer to OTG specification to get a_suspend, a_peripheral, a_idle and b_idle state.
 * |[4]     |OTGEN     |OTG Function Enable Bit
 * |        |          |User needs to set this bit to enable OTG function while USB frame configured as OTG device.
 * |        |          |When USB frame not configured as OTG device, this bit is must be low.
 * |        |          |0 = OTG function Disabled.
 * |        |          |1 = OTG function Enabled.
 * |[5]     |WKEN      |OTG ID Pin Wake-Up Enable Bit
 * |        |          |0 = OTG ID pin status change wake-up function Disabled.
 * |        |          |1 = OTG ID pin status change wake-up function Enabled.
 * @var OTG_T::PHYCTL
 * Offset: 0x04  OTG PHY Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |OTGPHYEN  |OTG PHY Enable
 * |        |          |When USB frame is configured as OTG-device, user needs to set this bit before using OTG function.
 * |        |          |If device is not configured as OTG-device, this bit is "don't care".
 * |        |          |0 = OTG PHY Disabled.
 * |        |          |1 = OTG PHY Enabled.
 * |[1]     |IDDETEN   |ID Detection Enable Bit
 * |        |          |0 = Detect ID pin status Disabled.
 * |        |          |1 = Detect ID pin status Enabled.
 * |[4]     |VBENPOL   |Off-Chip USB VBUS Power Switch Enable Polarity
 * |        |          |The OTG controller will enable off-chip USB VBUS power switch to provide VBUS power when need.
 * |        |          |A USB_VBUS_EN pin is used to control the off-chip USB VBUS power switch.
 * |        |          |The polarity of enabling off-chip USB VBUS power switch (high active or low active) depends on the selected component.
 * |        |          |Set this bit as following according to the polarity of off-chip USB VBUS power switch.
 * |        |          |0 = The off-chip USB VBUS power switch enable is active high.
 * |        |          |1 = The off-chip USB VBUS power switch enable is active low.
 * |[5]     |VBSTSPOL  |Off-Chip USB VBUS Power Switch Status Polarity
 * |        |          |The polarity of off-chip USB VBUS power switch valid signal depends on the selected component.
 * |        |          |A USB_VBUS_ST pin is used to monitor the valid signal of the off-chip USB VBUS power switch.
 * |        |          |Set this bit as following according to the polarity of off-chip USB VBUS power switch.
 * |        |          |0 = The polarity of off-chip USB VBUS power switch valid status is high.
 * |        |          |1 = The polarity of off-chip USB VBUS power switch valid status is low.
 * @var OTG_T::INTEN
 * Offset: 0x08  OTG Interrupt Enable Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |ROLECHGIEN|Role (Host Or Peripheral) Changed Interrupt Enable Bit
 * |        |          |0 = Interrupt Disabled.
 * |        |          |1 = Interrupt Enabled.
 * |[1]     |VBEIEN    |VBUS Error Interrupt Enable Bit
 * |        |          |0 = Interrupt Disabled.
 * |        |          |1 = Interrupt Enabled.
 * |        |          |Note: VBUS error means going to a_vbus_err state. Please refer to A-device state diagram in OTG spec.
 * |[2]     |SRPFIEN   |SRP Fail Interrupt Enable Bit
 * |        |          |0 = Interrupt Disabled.
 * |        |          |1 = Interrupt Enabled.
 * |[3]     |HNPFIEN   |HNP Fail Interrupt Enable Bit
 * |        |          |0 = Interrupt Disabled.
 * |        |          |1 = Interrupt Enabled.
 * |[4]     |GOIDLEIEN |OTG Device Goes to IDLE State Interrupt Enable Bit
 * |        |          |0 = Interrupt Disabled.
 * |        |          |1 = Interrupt Enabled.
 * |        |          |Note: Going to idle state means going to a_idle or b_idle state.
 * |        |          |Please refer to A-device state diagram and B-device state diagram in OTG spec.
 * |[5]     |IDCHGIEN  |IDSTS Changed Interrupt Enable Bit
 * |        |          |If this bit is set to 1 and IDSTS (OTG_STATUS[1]) status is changed from high to low or from low to high, a interrupt will be asserted.
 * |        |          |0 = Interrupt Disabled.
 * |        |          |1 = Interrupt Enabled.
 * |[6]     |PDEVIEN   |Act As Peripheral Interrupt Enable Bit
 * |        |          |If this bit is set to 1 and the device is changed as a peripheral, a interrupt will be asserted.
 * |        |          |0 = This device as a peripheral interrupt Disabled.
 * |        |          |1 = This device as a peripheral interrupt Enabled.
 * |[7]     |HOSTIEN   |Act As Host Interrupt Enable Bit
 * |        |          |If this bit is set to 1 and the device is changed as a host, a interrupt will be asserted.
 * |        |          |0 = This device as a host interrupt Disabled.
 * |        |          |1 = This device as a host interrupt Enabled.
 * |[8]     |BVLDCHGIEN|B-Device Session Valid Status Changed Interrupt Enable Bit
 * |        |          |If this bit is set to 1 and BVLD (OTG_STATUS[3]) status is changed from high to low or from low to high, a interrupt will be asserted.
 * |        |          |0 = Interrupt Disabled.
 * |        |          |1 = Interrupt Enabled.
 * |[9]     |AVLDCHGIEN|A-Device Session Valid Status Changed Interrupt Enable Bit
 * |        |          |If this bit is set to 1 and AVLD (OTG_STATUS[4]) status is changed from high to low or from low to high, a interrupt will be asserted.
 * |        |          |0 = Interrupt Disabled.
 * |        |          |1 = Interrupt Enabled.
 * |[10]    |VBCHGIEN  |VBUSVLD Status Changed
 * |        |          |Interrupt Enable Bit
 * |        |          |If this bit is set to 1 and VBUSVLD (OTG_STATUS[5]) status is changed from high to low or from low to high, a interrupt will be asserted.
 * |        |          |0 = Interrupt Disabled.
 * |        |          |1 = Interrupt Enabled.
 * |[11]    |SECHGIEN  |SESSEND Status Changed Interrupt Enable Bit
 * |        |          |If this bit is set to 1 and SESSEND (OTG_STATUS[2]) status is changed from high to low or from low to high, a interrupt will be asserted.
 * |        |          |0 = Interrupt Disabled.
 * |        |          |1 = Interrupt Enabled.
 * |[13]    |SRPDETIEN |SRP Detected Interrupt Enable Bit
 * |        |          |0 = Interrupt Disabled.
 * |        |          |1 = Interrupt Enabled.
 * @var OTG_T::INTSTS
 * Offset: 0x0C  OTG Interrupt Status Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |ROLECHGIF |OTG Role Change Interrupt Status
 * |        |          |This flag is set when the role of an OTG device changed from a host to a peripheral, or changed from a peripheral to a host while USB_ID pin status does not change.
 * |        |          |0 = OTG device role not changed.
 * |        |          |1 = OTG device role changed.
 * |        |          |Note: Write 1 to clear this flag.
 * |[1]     |VBEIF     |VBUS Error Interrupt Status
 * |        |          |This bit will be set when voltage on VBUS cannot reach a minimum valid threshold 4.4V within a maximum time of 100ms after OTG A-device starting to drive VBUS high.
 * |        |          |0 = OTG A-device drives VBUS over threshold voltage before this interval expires.
 * |        |          |1 = OTG A-device cannot drive VBUS over threshold voltage before this interval expires.
 * |        |          |Note: Write 1 to clear this flag and recover from the VBUS error state.
 * |[2]     |SRPFIF    |SRP Fail Interrupt Status
 * |        |          |After initiating SRP, an OTG B-device will wait for the OTG A-device to drive VBUS high at least TB_SRP_FAIL minimum, defined in OTG specification.
 * |        |          |This flag is set when the OTG B-device does not get VBUS high after this interval.
 * |        |          |0 = OTG B-device gets VBUS high before this interval.
 * |        |          |1 = OTG B-device does not get VBUS high before this interval.
 * |        |          |Note: Write 1 to clear this flag.
 * |[3]     |HNPFIF    |HNP Fail Interrupt Status
 * |        |          |When A-device has granted B-device to be host and USB bus is in SE0 (both USB_D+ and USB_D- low) state, this bit will be set when A-device does not connect after specified interval expires.
 * |        |          |0 = A-device connects to B-device before specified interval expires.
 * |        |          |1 = A-device does not connect to B-device before specified interval expires.
 * |        |          |Note: Write 1 to clear this flag.
 * |[4]     |GOIDLEIF  |OTG Device Goes to IDLE Interrupt Status
 * |        |          |Flag is set if the OTG device transfers from non-idle state to idle state.
 * |        |          |The OTG device will be neither a host nor a peripheral.
 * |        |          |0 = OTG device does not go back to idle state (a_idle or b_idle).
 * |        |          |1 = OTG device goes back to idle state (a_idle or b_idle).
 * |        |          |Note 1: Going to idle state means going to a_idle or b_idle state. Please refer to OTG specification for the details of a_idle state and b_idle state.
 * |        |          |Note 2: Write 1 to clear this flag.
 * |[5]     |IDCHGIF   |ID State Change Interrupt Status
 * |        |          |0 = IDSTS (OTG_STATUS[1]) not toggled.
 * |        |          |1 = IDSTS (OTG_STATUS[1]) from high to low or from low to high.
 * |        |          |Note: Write 1 to clear this flag.
 * |[6]     |PDEVIF    |Act As Peripheral Interrupt Status
 * |        |          |0 = This device does not act as a peripheral.
 * |        |          |1 = This device acts as a peripheral.
 * |        |          |Note: Write 1 to clear this flag.
 * |[7]     |HOSTIF    |Act As Host Interrupt Status
 * |        |          |0 = This device does not act as a host.
 * |        |          |1 = This device acts as a host.
 * |        |          |Note: Write 1 to clear this flag.
 * |[8]     |BVLDCHGIF |B-Device Session Valid State Change Interrupt Status
 * |        |          |0 = BVLD (OTG_STATUS[3]) is not toggled.
 * |        |          |1 = BVLD (OTG_STATUS[3]) from high to low or low to high.
 * |        |          |Note: Write 1 to clear this status.
 * |[9]     |AVLDCHGIF |A-Device Session Valid State Change Interrupt Status
 * |        |          |0 = AVLD (OTG_STATUS[4]) not toggled.
 * |        |          |1 = AVLD (OTG_STATUS[4]) from high to low or low to high.
 * |        |          |Note: Write 1 to clear this status.
 * |[10]    |VBCHGIF   |VBUSVLD State Change Interrupt Status
 * |        |          |0 = VBUSVLD (OTG_STATUS[5]) not toggled.
 * |        |          |1 = VBUSVLD (OTG_STATUS[5]) from high to low or from low to high.
 * |        |          |Note: Write 1 to clear this status.
 * |[11]    |SECHGIF   |SESSEND State Change Interrupt Status
 * |        |          |0 = SESSEND (OTG_STATUS[2]) not toggled.
 * |        |          |1 = SESSEND (OTG_STATUS[2]) from high to low or from low to high.
 * |        |          |Note: Write 1 to clear this flag.
 * |[13]    |SRPDETIF  |SRP Detected Interrupt Status
 * |        |          |0 = SRP not detected.
 * |        |          |1 = SRP detected.
 * |        |          |Note: Write 1 to clear this status.
 * @var OTG_T::STATUS
 * Offset: 0x10  OTG Status Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |OVERCUR   |Over Current Condition
 * |        |          |The voltage on VBUS cannot reach a minimum VBUS valid threshold, 4.4V minimum, within a maximum time of 100ms after OTG A-device drives VBUS high.
 * |        |          |0 = OTG A-device drives VBUS successfully.
 * |        |          |1 = OTG A-device cannot drives VBUS high in this interval.
 * |[1]     |IDSTS     |USB_ID Pin State Of Mini-B/Micro-Plug
 * |        |          |0 = Mini-A/Micro-A plug is attached.
 * |        |          |1 = Mini-B/Micro-B plug is attached.
 * |[2]     |SESSEND   |Session End Status
 * |        |          |When VBUS voltage is lower than 0.4V, this bit will be set to 1.
 * |        |          |Session end means no meaningful power on VBUS.
 * |        |          |0 = Session is not end.
 * |        |          |1 = Session is end.
 * |[3]     |BVLD      |B-Device Session Valid Status
 * |        |          |0 = B-device session is not valid.
 * |        |          |1 = B-device session is valid.
 * |[4]     |AVLD      |A-Device Session Valid Status
 * |        |          |0 = A-device session is not valid.
 * |        |          |1 = A-device session is valid.
 * |[5]     |VBUSVLD   |VBUS Valid Status
 * |        |          |When VBUS is larger than 4.7V, this bit will be set to 1.
 * |        |          |0 = VBUS is not valid.
 * |        |          |1 = VBUS is valid.
 */

    __IO uint32_t CTL;           /* Offset: 0x00  OTG Control Register                                               */
    __IO uint32_t PHYCTL;        /* Offset: 0x04  OTG PHY Control Register                                           */
    __IO uint32_t INTEN;         /* Offset: 0x08  OTG Interrupt Enable Register                                      */
    __IO uint32_t INTSTS;        /* Offset: 0x0C  OTG Interrupt Status Register                                      */
    __I  uint32_t STATUS;        /* Offset: 0x10  OTG Status Register                                                */

} OTG_T;



/**
    @addtogroup OTG_CONST OTG Bit Field Definition
    Constant Definitions for OTG Controller
@{ */

#define OTG_CTL_VBUSDROP_Pos             (0)                                               /*!< OTG_T::CTL: VBUSDROP Position             */
#define OTG_CTL_VBUSDROP_Msk             (0x1ul << OTG_CTL_VBUSDROP_Pos)                   /*!< OTG_T::CTL: VBUSDROP Mask                 */

#define OTG_CTL_BUSREQ_Pos               (1)                                               /*!< OTG_T::CTL: BUSREQ Position               */
#define OTG_CTL_BUSREQ_Msk               (0x1ul << OTG_CTL_BUSREQ_Pos)                     /*!< OTG_T::CTL: BUSREQ Mask                   */

#define OTG_CTL_HNPREQEN_Pos             (2)                                               /*!< OTG_T::CTL: HNPREQEN Position             */
#define OTG_CTL_HNPREQEN_Msk             (0x1ul << OTG_CTL_HNPREQEN_Pos)                   /*!< OTG_T::CTL: HNPREQEN Mask                 */

#define OTG_CTL_OTGEN_Pos                (4)                                               /*!< OTG_T::CTL: OTGEN Position                */
#define OTG_CTL_OTGEN_Msk                (0x1ul << OTG_CTL_OTGEN_Pos)                      /*!< OTG_T::CTL: OTGEN Mask                    */

#define OTG_CTL_WKEN_Pos                 (5)                                               /*!< OTG_T::CTL: WKEN Position                 */
#define OTG_CTL_WKEN_Msk                 (0x1ul << OTG_CTL_WKEN_Pos)                       /*!< OTG_T::CTL: WKEN Mask                     */

#define OTG_PHYCTL_OTGPHYEN_Pos          (0)                                               /*!< OTG_T::PHYCTL: OTGPHYEN Position          */
#define OTG_PHYCTL_OTGPHYEN_Msk          (0x1ul << OTG_PHYCTL_OTGPHYEN_Pos)                /*!< OTG_T::PHYCTL: OTGPHYEN Mask              */

#define OTG_PHYCTL_IDDETEN_Pos           (1)                                               /*!< OTG_T::PHYCTL: IDDETEN Position           */
#define OTG_PHYCTL_IDDETEN_Msk           (0x1ul << OTG_PHYCTL_IDDETEN_Pos)                 /*!< OTG_T::PHYCTL: IDDETEN Mask               */

#define OTG_PHYCTL_VBENPOL_Pos           (4)                                               /*!< OTG_T::PHYCTL: VBENPOL Position           */
#define OTG_PHYCTL_VBENPOL_Msk           (0x1ul << OTG_PHYCTL_VBENPOL_Pos)                 /*!< OTG_T::PHYCTL: VBENPOL Mask               */

#define OTG_PHYCTL_VBSTSPOL_Pos          (5)                                               /*!< OTG_T::PHYCTL: VBSTSPOL Position          */
#define OTG_PHYCTL_VBSTSPOL_Msk          (0x1ul << OTG_PHYCTL_VBSTSPOL_Pos)                /*!< OTG_T::PHYCTL: VBSTSPOL Mask              */

#define OTG_INTEN_ROLECHGIEN_Pos         (0)                                               /*!< OTG_T::INTEN: ROLECHGIEN Position         */
#define OTG_INTEN_ROLECHGIEN_Msk         (0x1ul << OTG_INTEN_ROLECHGIEN_Pos)               /*!< OTG_T::INTEN: ROLECHGIEN Mask             */

#define OTG_INTEN_VBEIEN_Pos             (1)                                               /*!< OTG_T::INTEN: VBEIEN Position             */
#define OTG_INTEN_VBEIEN_Msk             (0x1ul << OTG_INTEN_VBEIEN_Pos)                   /*!< OTG_T::INTEN: VBEIEN Mask                 */

#define OTG_INTEN_SRPFIEN_Pos            (2)                                               /*!< OTG_T::INTEN: SRPFIEN Position            */
#define OTG_INTEN_SRPFIEN_Msk            (0x1ul << OTG_INTEN_SRPFIEN_Pos)                  /*!< OTG_T::INTEN: SRPFIEN Mask                */

#define OTG_INTEN_HNPFIEN_Pos            (3)                                               /*!< OTG_T::INTEN: HNPFIEN Position            */
#define OTG_INTEN_HNPFIEN_Msk            (0x1ul << OTG_INTEN_HNPFIEN_Pos)                  /*!< OTG_T::INTEN: HNPFIEN Mask                */

#define OTG_INTEN_GOIDLEIEN_Pos          (4)                                               /*!< OTG_T::INTEN: GOIDLEIEN Position          */
#define OTG_INTEN_GOIDLEIEN_Msk          (0x1ul << OTG_INTEN_GOIDLEIEN_Pos)                /*!< OTG_T::INTEN: GOIDLEIEN Mask              */

#define OTG_INTEN_IDCHGIEN_Pos           (5)                                               /*!< OTG_T::INTEN: IDCHGIEN Position           */
#define OTG_INTEN_IDCHGIEN_Msk           (0x1ul << OTG_INTEN_IDCHGIEN_Pos)                 /*!< OTG_T::INTEN: IDCHGIEN Mask               */

#define OTG_INTEN_PDEVIEN_Pos            (6)                                               /*!< OTG_T::INTEN: PDEVIEN Position            */
#define OTG_INTEN_PDEVIEN_Msk            (0x1ul << OTG_INTEN_PDEVIEN_Pos)                  /*!< OTG_T::INTEN: PDEVIEN Mask                */

#define OTG_INTEN_HOSTIEN_Pos            (7)                                               /*!< OTG_T::INTEN: HOSTIEN Position            */
#define OTG_INTEN_HOSTIEN_Msk            (0x1ul << OTG_INTEN_HOSTIEN_Pos)                  /*!< OTG_T::INTEN: HOSTIEN Mask                */

#define OTG_INTEN_BVLDCHGIEN_Pos         (8)                                               /*!< OTG_T::INTEN: BVLDCHGIEN Position         */
#define OTG_INTEN_BVLDCHGIEN_Msk         (0x1ul << OTG_INTEN_BVLDCHGIEN_Pos)               /*!< OTG_T::INTEN: BVLDCHGIEN Mask             */

#define OTG_INTEN_AVLDCHGIEN_Pos         (9)                                               /*!< OTG_T::INTEN: AVLDCHGIEN Position         */
#define OTG_INTEN_AVLDCHGIEN_Msk         (0x1ul << OTG_INTEN_AVLDCHGIEN_Pos)               /*!< OTG_T::INTEN: AVLDCHGIEN Mask             */

#define OTG_INTEN_VBCHGIEN_Pos           (10)                                              /*!< OTG_T::INTEN: VBCHGIEN Position           */
#define OTG_INTEN_VBCHGIEN_Msk           (0x1ul << OTG_INTEN_VBCHGIEN_Pos)                 /*!< OTG_T::INTEN: VBCHGIEN Mask               */

#define OTG_INTEN_SECHGIEN_Pos           (11)                                              /*!< OTG_T::INTEN: SECHGIEN Position           */
#define OTG_INTEN_SECHGIEN_Msk           (0x1ul << OTG_INTEN_SECHGIEN_Pos)                 /*!< OTG_T::INTEN: SECHGIEN Mask               */

#define OTG_INTEN_SRPDETIEN_Pos          (13)                                              /*!< OTG_T::INTEN: SRPDETIEN Position          */
#define OTG_INTEN_SRPDETIEN_Msk          (0x1ul << OTG_INTEN_SRPDETIEN_Pos)                /*!< OTG_T::INTEN: SRPDETIEN Mask              */

#define OTG_INTSTS_ROLECHGIF_Pos         (0)                                               /*!< OTG_T::INTSTS: ROLECHGIF Position         */
#define OTG_INTSTS_ROLECHGIF_Msk         (0x1ul << OTG_INTSTS_ROLECHGIF_Pos)               /*!< OTG_T::INTSTS: ROLECHGIF Mask             */

#define OTG_INTSTS_VBEIF_Pos             (1)                                               /*!< OTG_T::INTSTS: VBEIF Position             */
#define OTG_INTSTS_VBEIF_Msk             (0x1ul << OTG_INTSTS_VBEIF_Pos)                   /*!< OTG_T::INTSTS: VBEIF Mask                 */

#define OTG_INTSTS_SRPFIF_Pos            (2)                                               /*!< OTG_T::INTSTS: SRPFIF Position            */
#define OTG_INTSTS_SRPFIF_Msk            (0x1ul << OTG_INTSTS_SRPFIF_Pos)                  /*!< OTG_T::INTSTS: SRPFIF Mask                */

#define OTG_INTSTS_HNPFIF_Pos            (3)                                               /*!< OTG_T::INTSTS: HNPFIF Position            */
#define OTG_INTSTS_HNPFIF_Msk            (0x1ul << OTG_INTSTS_HNPFIF_Pos)                  /*!< OTG_T::INTSTS: HNPFIF Mask                */

#define OTG_INTSTS_GOIDLEIF_Pos          (4)                                               /*!< OTG_T::INTSTS: GOIDLEIF Position          */
#define OTG_INTSTS_GOIDLEIF_Msk          (0x1ul << OTG_INTSTS_GOIDLEIF_Pos)                /*!< OTG_T::INTSTS: GOIDLEIF Mask              */

#define OTG_INTSTS_IDCHGIF_Pos           (5)                                               /*!< OTG_T::INTSTS: IDCHGIF Position           */
#define OTG_INTSTS_IDCHGIF_Msk           (0x1ul << OTG_INTSTS_IDCHGIF_Pos)                 /*!< OTG_T::INTSTS: IDCHGIF Mask               */

#define OTG_INTSTS_PDEVIF_Pos            (6)                                               /*!< OTG_T::INTSTS: PDEVIF Position            */
#define OTG_INTSTS_PDEVIF_Msk            (0x1ul << OTG_INTSTS_PDEVIF_Pos)                  /*!< OTG_T::INTSTS: PDEVIF Mask                */

#define OTG_INTSTS_HOSTIF_Pos            (7)                                               /*!< OTG_T::INTSTS: HOSTIF Position            */
#define OTG_INTSTS_HOSTIF_Msk            (0x1ul << OTG_INTSTS_HOSTIF_Pos)                  /*!< OTG_T::INTSTS: HOSTIF Mask                */

#define OTG_INTSTS_BVLDCHGIF_Pos         (8)                                               /*!< OTG_T::INTSTS: BVLDCHGIF Position         */
#define OTG_INTSTS_BVLDCHGIF_Msk         (0x1ul << OTG_INTSTS_BVLDCHGIF_Pos)               /*!< OTG_T::INTSTS: BVLDCHGIF Mask             */

#define OTG_INTSTS_AVLDCHGIF_Pos         (9)                                               /*!< OTG_T::INTSTS: AVLDCHGIF Position         */
#define OTG_INTSTS_AVLDCHGIF_Msk         (0x1ul << OTG_INTSTS_AVLDCHGIF_Pos)               /*!< OTG_T::INTSTS: AVLDCHGIF Mask             */

#define OTG_INTSTS_VBCHGIF_Pos           (10)                                              /*!< OTG_T::INTSTS: VBCHGIF Position           */
#define OTG_INTSTS_VBCHGIF_Msk           (0x1ul << OTG_INTSTS_VBCHGIF_Pos)                 /*!< OTG_T::INTSTS: VBCHGIF Mask               */

#define OTG_INTSTS_SECHGIF_Pos           (11)                                              /*!< OTG_T::INTSTS: SECHGIF Position           */
#define OTG_INTSTS_SECHGIF_Msk           (0x1ul << OTG_INTSTS_SECHGIF_Pos)                 /*!< OTG_T::INTSTS: SECHGIF Mask               */

#define OTG_INTSTS_SRPDETIF_Pos          (13)                                              /*!< OTG_T::INTSTS: SRPDETIF Position          */
#define OTG_INTSTS_SRPDETIF_Msk          (0x1ul << OTG_INTSTS_SRPDETIF_Pos)                /*!< OTG_T::INTSTS: SRPDETIF Mask              */

#define OTG_STATUS_OVERCUR_Pos           (0)                                               /*!< OTG_T::STATUS: OVERCUR Position           */
#define OTG_STATUS_OVERCUR_Msk           (0x1ul << OTG_STATUS_OVERCUR_Pos)                 /*!< OTG_T::STATUS: OVERCUR Mask               */

#define OTG_STATUS_IDSTS_Pos             (1)                                               /*!< OTG_T::STATUS: IDSTS Position             */
#define OTG_STATUS_IDSTS_Msk             (0x1ul << OTG_STATUS_IDSTS_Pos)                   /*!< OTG_T::STATUS: IDSTS Mask                 */

#define OTG_STATUS_SESSEND_Pos           (2)                                               /*!< OTG_T::STATUS: SESSEND Position           */
#define OTG_STATUS_SESSEND_Msk           (0x1ul << OTG_STATUS_SESSEND_Pos)                 /*!< OTG_T::STATUS: SESSEND Mask               */

#define OTG_STATUS_BVLD_Pos              (3)                                               /*!< OTG_T::STATUS: BVLD Position              */
#define OTG_STATUS_BVLD_Msk              (0x1ul << OTG_STATUS_BVLD_Pos)                    /*!< OTG_T::STATUS: BVLD Mask                  */

#define OTG_STATUS_AVLD_Pos              (4)                                               /*!< OTG_T::STATUS: AVLD Position              */
#define OTG_STATUS_AVLD_Msk              (0x1ul << OTG_STATUS_AVLD_Pos)                    /*!< OTG_T::STATUS: AVLD Mask                  */

#define OTG_STATUS_VBUSVLD_Pos           (5)                                               /*!< OTG_T::STATUS: VBUSVLD Position           */
#define OTG_STATUS_VBUSVLD_Msk           (0x1ul << OTG_STATUS_VBUSVLD_Pos)                 /*!< OTG_T::STATUS: VBUSVLD Mask               */

/**@}*/ /* OTG_CONST */
/**@}*/ /* end of OTG register group */


/*---------------------- Peripheral Direct Memory Access Controller -------------------------*/
/**
    @addtogroup PDMA Peripheral Direct Memory Access Controller(PDMA)
    Memory Mapped Structure for PDMA Controller
@{ */


typedef struct
{


/**
 * @var DSCT_T::CTL
 * Offset: 0x00/0x10/0x20/0x30/0x40/0x50/0x60/0x70/0x80/0x90/0xA0/0xB0  Descriptor Table Control Register of PDMA Channel 0~11
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[1:0]   |OPMODE    |PDMA Operation Mode Selection
 * |        |          |0 = Idle state: Channel is stopped or this table is complete, when PDMA finish channel table task, OPMODE will be cleared to idle state automatically.
 * |        |          |1 = Basic mode: The descriptor table only has one task.
 * |        |          |When this task is finished, the PDMA_INTSTS[x] will be asserted.
 * |        |          |2 = Scatter-Gather mode: When operating in this mode, user must give the next descriptor table address in PDMA_DSCT_NEXT register; PDMA controller will ignore this task, then load the next task to execute.
 * |        |          |3 = Reserved.
 * |        |          |Note: Before filling transfer task in the Descriptor Table, user must check if the descriptor table is complete.
 * |[2]     |TXTYPE    |Transfer Type
 * |        |          |0 = Burst transfer type.
 * |        |          |1 = Single transfer type.
 * |[6:4]   |BURSIZE   |Burst Size
 * |        |          |This field is used for peripheral to determine the burst size or used for determine the re-arbitration size.
 * |        |          |000 = 128 Transfers.
 * |        |          |001 = 64 Transfers.
 * |        |          |010 = 32 Transfers.
 * |        |          |011 = 16 Transfers.
 * |        |          |100 = 8 Transfers.
 * |        |          |101 = 4 Transfers.
 * |        |          |110 = 2 Transfers.
 * |        |          |111 = 1 Transfers.
 * |        |          |Note: This field is only useful in burst transfer type.
 * |[7]     |TBINTDIS  |Table Interrupt Disable
 * |        |          |This field can be used to decide whether to enable table interrupt or not.
 * |        |          |If the TBINTDIS bit is enabled when PDMA controller finishes transfer task, it will not generates interrupt.
 * |        |          |0 = Table interrupt Enabled.
 * |        |          |1 = Table interrupt Disabled.
 * |        |          |Note: If this bit set to '1', the TEMPTYF will not be set.
 * |[9:8]   |SAINC     |Source Address Increment
 * |        |          |This field is used to set the source address increment size.
 * |        |          |11 = No increment (fixed address).
 * |        |          |Others = Increment and size is depended on TXWIDTH selection.
 * |[11:10] |DAINC     |Destination Address Increment
 * |        |          |This field is used to set the destination address increment size.
 * |        |          |11 = No increment (fixed address).
 * |        |          |Others = Increment and size is depended on TXWIDTH selection.
 * |[13:12] |TXWIDTH   |Transfer Width Selection
 * |        |          |This field is used for transfer width.
 * |        |          |00 = One byte (8 bit) is transferred for every operation.
 * |        |          |01= One half-word (16 bit) is transferred for every operation.
 * |        |          |10 = One word (32-bit) is transferred for every operation.
 * |        |          |11 = Reserved.
 * |        |          |Note: The PDMA transfer source address (PDMA_DSCT_SA) and PDMA transfer destination address (PDMA_DSCT_DA) should be alignment under the TXWIDTH selection
 * |[29:16] |TXCNT     |Transfer Count
 * |        |          |The TXCNT represents the required number of PDMA transfer, the real transfer count is (TXCNT + 1); The maximum transfer count is 16384 , every transfer may be byte, half-word or word that is dependent on TXWIDTH field.
 * |        |          |Note: When PDMA finish each transfer data, this field will be decrease immediately.
 * @var DSCT_T::SA
 * Offset: 0x04/0x14/0x24/0x34/0x44/0x54/0x64/0x74/0x84/0x94/0xA4/0xB4  Source Address Register of PDMA Channel 0~11
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[31:0]  |SA        |PDMA Transfer Source Address Register
 * |        |          |This field indicates a 32-bit source address of PDMA controller.
 * @var DSCT_T::DA
 * Offset: 0x08/0x18/0x28/0x38/0x48/0x58/0x68/0x78/0x88/0x98/0xA8/0xB8  Destination Address Register of PDMA Channel 0~11
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[31:0]  |DA        |PDMA Transfer Destination Address Register
 * |        |          |This field indicates a 32-bit destination address of PDMA controller.
 * @var DSCT_T::NEXT
 * Offset: 0x0C/0x1C/0x2C/0x3C/0x4C/0x5C/0x6C/0x7C/0x8C/0x9C/0xAC/0xBC  First Scatter-Gather Descriptor Table Offset Address of PDMA Channel 0~11
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:2]  |NEXT      |PDMA Next Descriptor Table Offset Address Register
 * |        |          |This field indicates the offset of next descriptor table address in system memory.
 * |        |          |The system memory based address is 0x2000_0000 (PDMA_SCATBA), if the next descriptor table is 0x2000_0100, then this field must fill in 0x0100.
 * |        |          |Note1: The next descriptor table address must be word boundary.
 * |        |          |Note2: Before filled transfer task in the descriptor table, user must check if the descriptor table is complete.
 */

    __IO uint32_t CTL;           /* Offset: 0x00/0x10/0x20/0x30/0x40/0x50/0x60/0x70/0x80/0x90/0xA0/0xB0  Descriptor Table Control Register of PDMA Channel 0~11 */
    __IO uint32_t SA;            /* Offset: 0x04/0x14/0x24/0x34/0x44/0x54/0x64/0x74/0x84/0x94/0xA4/0xB4  Source Address Register of PDMA Channel 0~11 */
    __IO uint32_t DA;            /* Offset: 0x08/0x18/0x28/0x38/0x48/0x58/0x68/0x78/0x88/0x98/0xA8/0xB8  Destination Address Register of PDMA Channel 0~11 */
    __IO uint32_t NEXT;          /* Offset: 0x0C/0x1C/0x2C/0x3C/0x4C/0x5C/0x6C/0x7C/0x8C/0x9C/0xAC/0xBC  First Scatter-Gather Descriptor Table Offset Address of PDMA Channel 0~11 */

} DSCT_T;




typedef struct
{


/**
 * @var PDMA_T::DSCT
 * Offset: 0x0000 ~ 0x00BC  DMA Embedded Description Table 0~11
 * ---------------------------------------------------------------------------------------------------
 * @var PDMA_T::CURSCAT
 * Offset: 0xC0 ~ 0xEC Current Scatter-Gather Descriptor Table Address of PDMA Channel 0~11
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[31:0]  |CURADDR   |PDMA Current Description Address Register (Read Only)
 * |        |          |This field indicates a 32-bit current external description address of PDMA controller.
 * |        |          |Note: This field is read only and only used for Scatter-Gather mode to indicate the current external description address.
 * @var PDMA_T::CHCTL
 * Offset: 0x400  PDMA Channel Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[11:0]  |CHENn     |PDMA Channel Enable Bit
 * |        |          |Set this bit to 1 to enable PDMAn operation.
 * |        |          |If each channel is not set as enabled, each channel cannot be active.
 * |        |          |0 = PDMA channel [n] Disabled.
 * |        |          |1 = PDMA channel [n] Enabled.
 * |        |          |Note1: If software stops each PDMA transfer by setting PDMA_STOP register, this bit will be cleared automatically after finishing current transfer.
 * |        |          |Note2: Software reset (writing 0xFFFF_FFFF to PDMA_STOP register) will also clear this bit.
 * @var PDMA_T::STOP
 * Offset: 0x404  PDMA Transfer Stop Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[11:0]  |STOPn     |PDMA Transfer Stop Control Register (Write Only)
 * |        |          |User can stop the PDMA transfer by STOPn bit field or by software reset (writing '0xFFFF_FFFF' to PDMA_STOP register).
 * |        |          |By bit field:
 * |        |          |0 = No effect.
 * |        |          |1 = Stop PDMA transfer[n].
 * |        |          |When software set PDMA_STOP bit, the operation will finish the on-going transfer channel and then clear the channel enable bit (PDMA_CHCTL [CHEN]) and request active flag.
 * |        |          |By write 0xFFFF_FFFF to PDMA_STOP:
 * |        |          |Setting all PDMA_STOP bit to "1" will generate software reset to reset internal state machine (the DSCT will not be reset).
 * |        |          |When software reset, the operation will be stopped imminently that include the on-going transfer and the channel enable bit (PDMA_CHCTL [CHEN]) and request active flag will be cleared to '0'.
 * |        |          |Note: User can poll channel enable bit to know if the on-going transfer is finished.
 * @var PDMA_T::SWREQ
 * Offset: 0x408  PDMA Software Request Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[11:0]  |SWREQn    |PDMA Software Request Register (Write Only)
 * |        |          |Set this bit to 1 to generate a software request to PDMA [n].
 * |        |          |0 = No effect.
 * |        |          |1 = Generate a software request.
 * |        |          |Note1: User can read PDMA_TRGSTS register to know which channel is on active.
 * |        |          |Active flag may be triggered by software request or peripheral request.
 * |        |          |Note2: If user does not enable each PDMA channel, the software request will be ignored.
 * @var PDMA_T::TRGSTS
 * Offset: 0x40C  PDMA Channel Request Status Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[11:0]  |REQSTSn   |PDMA Channel Request Status (Read Only)
 * |        |          |This flag indicates whether channel[n] have a request or not, no matter request from software or peripheral.
 * |        |          |When PDMA controller finishes channel transfer, this bit will be cleared automatically.
 * |        |          |0 = PDMA Channel n has no request.
 * |        |          |1 = PDMA Channel n has a request.
 * |        |          |Note1: If software stops each PDMA transfer by setting PDMA_STOP register, this bit will be cleared automatically after finishing current transfer.
 * |        |          |Note2: Software reset (writing 0xFFFF_FFFF to PDMA_STOP register) will also clear this bit.
 * @var PDMA_T::PRISET
 * Offset: 0x410  PDMA Fixed Priority Setting Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[11:0]  |FPRISETn  |PDMA Fixed Priority Setting Register
 * |        |          |Set this bit to 1 to enable fixed priority level.
 * |        |          |Write Operation:
 * |        |          |0 = No effect.
 * |        |          |1 = Set PDMA channel [n] to fixed priority channel.
 * |        |          |Read Operation:
 * |        |          |0 = Corresponding PDMA channel is round-robin priority.
 * |        |          |1 = Corresponding PDMA channel is fixed priority.
 * |        |          |Note: This field only set to fixed priority, clear fixed priority use PDMA_PRICLR register.
 * @var PDMA_T::PRICLR
 * Offset: 0x414  PDMA Fixed Priority Clear Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[11:0]  |FPRICLRn  |PDMA Fixed Priority Clear Register (Write Only)
 * |        |          |Set this bit to 1 to clear fixed priority level.
 * |        |          |0 = No effect.
 * |        |          |1 = Clear PDMA channel [n] fixed priority setting.
 * |        |          |Note: User can read PDMA_PRISET register to know the channel priority.
 * @var PDMA_T::INTEN
 * Offset: 0x418  PDMA Interrupt Enable Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[11:0]  |INTENn    |PDMA Interrupt Enable Register
 * |        |          |This field is used for enabling PDMA channel[n] interrupt.
 * |        |          |0 = PDMA channel n interrupt Disabled.
 * |        |          |1 = PDMA channel n interrupt Enabled.
 * |[31:12] |Reserved  |should be keep 0.
 * @var PDMA_T::INTSTS
 * Offset: 0x41C  PDMA Interrupt Status Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |ABTIF     |PDMA Read/Write Target Abort Interrupt Flag (Read-Only)
 * |        |          |This bit indicates that PDMA has target abort error; Software can read PDMA_ABTSTS register to find which channel has target abort error.
 * |        |          |0 = No AHB bus ERROR response received.
 * |        |          |1 = AHB bus ERROR response received.
 * |[1]     |TDIF      |Transfer Done Interrupt Flag (Read Only)
 * |        |          |This bit indicates that PDMA controller has finished transmission; User can read PDMA_TDSTS register to indicate which channel finished transfer.
 * |        |          |0 = Not finished yet.
 * |        |          |1 = PDMA channel has finished transmission.
 * |[2]     |TEIF      |Table Empty Interrupt Flag (Read Only)
 * |        |          |This bit indicates that PDMA controller has finished each table transmission and the operation is Stop mode.
 * |        |          |User can read TEIF register to indicate which channel finished transfer.
 * |        |          |0 = PDMA channel transfer is not finished.
 * |        |          |1 = PDMA channel transfer is finished and the operation is in idle state.
 * |[8:15]  |REQTOFn   |Request Time-out Flag For Each Channel [N](M45xD/M45xC Only)
 * |        |          |This flag indicates that PDMA controller has waited peripheral request for a period defined by PDMA_TOCn, user can write 1 to clear these bits.
 * |        |          |0 = No request time-out.
 * |        |          |1 = Peripheral request time-out.
 * @var PDMA_T::ABTSTS
 * Offset: 0x420  PDMA Channel Read/Write Target Abort Flag Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[11:0]  |ABTIFn    |PDMA Read/Write Target Abort Interrupt Status Flag
 * |        |          |This bit indicates which PDMA controller has target abort error; User can write 1 to clear these bits.
 * |        |          |0 = No AHB bus ERROR response received when channel n transfer.
 * |        |          |1 = AHB bus ERROR response received when channel n transfer.
 * @var PDMA_T::TDSTS
 * Offset: 0x424  PDMA Channel Transfer Done Flag Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[11:0]  |TDIFn     |Transfer Done Flag Register
 * |        |          |This bit indicates whether PDMA controller channel transfer has been finished or not, user can write 1 to clear these bits.
 * |        |          |0 = PDMA channel transfer has not finished.
 * |        |          |1 = PDMA channel has finished transmission.
 * @var PDMA_T::SCATSTS
 * Offset: 0x428  PDMA Scatter-Gather Table Empty Status Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[11:0]  |TEMPTYFn  |Scatter-Gather Table Empty Flag Register
 * |        |          |This bit indicates which PDMA channel n Scatter Gather table is empty when SWREQn set to high or channel has finished transmission and the operation mode is Stop mode.
 * |        |          |User can write 1 to clear these bits.
 * |        |          |0 = PDMA channel scatter-gather table is not empty.
 * |        |          |1 = PDMA channel scatter-gather table is empty and PDMA SWREQ has be set.
 * @var PDMA_T::TACTSTS
 * Offset: 0x42C  PDMA Transfer Active Flag Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[11:0]  |TXACTFn   |Transfer On Active Flag Register (Read Only)
 * |        |          |This bit indicates which PDMA channel is in active.
 * |        |          |0 = PDMA channel is not finished.
 * |        |          |1 = PDMA channel is active.
 * @var PDMA_T::TOUTEN
 * Offset: 0x434  PDMA Time-out Enable register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[7:0]   |TOUTENn   |PDMA Time-Out Enable Bits
 * |        |          |0 = PDMA Channel n time-out function Disable.
 * |        |          |1 = PDMA Channel n time-out function Enable.
 * @var PDMA_T::TOUTIEN
 * Offset: 0x438  PDMA Time-out Interrupt Enable register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[7:0]   |TOUTIENn  |PDMA Time-Out Interrupt Enable Bits
 * |        |          |0 = PDMA Channel n time-out interrupt Disable.
 * |        |          |1 = PDMA Channel n time-out interrupt Enable.
 * @var PDMA_T::SCATBA
 * Offset: 0x43C  PDMA Scatter-Gather Descriptor Table Base Address Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[31:16] |SCATBA    |PDMA Scatter-Gather Descriptor Table Address Register
 * |        |          |In Scatter-Gather mode, this is the base address for calculating the next link - list address.
 * |        |          |The next link address equation is.
 * |        |          |Next Link Address = PDMA_SCATBA + PDMA_DSCT_NEXT.
 * |        |          |Note: Only useful in Scatter-Gather mode.
 * @var PDMA_T::TOC0_1
 * Offset: 0x440  PDMA Time-out Counter Ch1 and Ch0 Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[31:16] |TOC1      |Time-Out Counter For Channel 1
 * |        |          |This controls the period of time-out function for channel 1. The calculation unit is based on 10 kHz clock.
 * |[15:0]  |TOC0      |Time-Out Counter For Channel 0
 * |        |          |This controls the period of time-out function for channel 0. The calculation unit is based on 10 kHz clock.
 * @var PDMA_T::TOC2_3
 * Offset: 0x444  PDMA Time-out Counter Ch3 and Ch2 Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[31:16] |TOC3      |Time-Out Counter For Channel 3
 * |        |          |This controls the period of time-out function for channel 3. The calculation unit is based on 10 kHz clock.
 * |[15:0]  |TOC2      |Time-Out Counter For Channel 2
 * |        |          |This controls the period of time-out function for channel 2. The calculation unit is based on 10 kHz clock.
 * @var PDMA_T::TOC4_5
 * Offset: 0x448  PDMA Time-out Counter Ch5 and Ch4 Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[31:16] |TOC5      |Time-Out Counter For Channel 5
 * |        |          |This controls the period of time-out function for channel 5. The calculation unit is based on 10 kHz clock.
 * |[15:0]  |TOC4      |Time-Out Counter For Channel 4
 * |        |          |This controls the period of time-out function for channel 4. The calculation unit is based on 10 kHz clock.
 * @var PDMA_T::TOC6_7
 * Offset: 0x44C  PDMA Time-out Counter Ch7 and Ch6 Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[31:16] |TOC7      |Time-Out Counter For Channel 7
 * |        |          |This controls the period of time-out function for channel 7. The calculation unit is based on 10 kHz clock.
 * |[15:0]  |TOC6      |Time-Out Counter For Channel 6
 * |        |          |This controls the period of time-out function for channel 6. The calculation unit is based on 10 kHz clock.
 * @var PDMA_T::REQSEL0_3
 * Offset: 0x480  PDMA Request Source Select Register 0
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[4:0]   |REQSRC0   |Channel 0 Request Source Selection
 * |        |          |This filed defines which peripheral is connected to PDMA channel 0.
 * |        |          |User can configure the peripheral by setting REQSRC0.
 * |        |          |1 = Channel connects to SPI0_TX.
 * |        |          |2 = Channel connects to SPI1_TX.
 * |        |          |3 = Channel connects to SPI2_TX.
 * |        |          |4 = Channel connects to UART0_TX.
 * |        |          |5 = Channel connects to UART1_TX.
 * |        |          |6 = Channel connects to UART2_TX.
 * |        |          |7 = Channel connects to UART3_TX.
 * |        |          |8 = Channel connects to DAC_TX.
 * |        |          |9 = Channel connects to ADC_RX.
 * |        |          |11 = Channel connects to PWM0_P1_RX.
 * |        |          |12 = Channel connects to PWM0_P2_RX.
 * |        |          |13 = Channel connects to PWM0_P3_RX.
 * |        |          |14 = Channel connects to PWM1_P1_RX.
 * |        |          |15 = Channel connects to PWM1_P2_RX.
 * |        |          |16 = Channel connects to PWM1_P3_RX.
 * |        |          |17 = Channel connects to SPI0_RX.
 * |        |          |18 = Channel connects to SPI1_RX.
 * |        |          |19 = Channel connects to SPI2_RX.
 * |        |          |20 = Channel connects to UART0_RX.
 * |        |          |21 = Channel connects to UART1_RX.
 * |        |          |22 = Channel connects to UART2_RX.
 * |        |          |23 = Channel connects to UART3_RX.
 * |        |          |31 = Disable PDMA.
 * |        |          |Others = Reserved.
 * |        |          |Note 1: A peripheral can't assign to two channels at the same time.
 * |        |          |Note 2: This field is useless when transfer between memory and memory.
 * |[12:8]  |REQSRC1   |Channel 1 Request Source Selection
 * |        |          |This filed defines which peripheral is connected to PDMA channel 1.
 * |        |          |User can configure the peripheral setting by REQSRC1.
 * |        |          |Note: The channel configuration is the same as REQSRC0 field.
 * |        |          |Please refer to the explanation of REQSRC0.
 * |[20:16] |REQSRC2   |Channel 2 Request Source Selection
 * |        |          |This filed defines which peripheral is connected to PDMA channel 2.
 * |        |          |User can configure the peripheral setting by REQSRC2.
 * |        |          |Note: The channel configuration is the same as REQSRC0 field.
 * |        |          |Please refer to the explanation of REQSRC0.
 * |[28:24] |REQSRC3   |Channel 3 Request Source Selection
 * |        |          |This filed defines which peripheral is connected to PDMA channel 3.
 * |        |          |User can configure the peripheral setting by REQSRC3.
 * |        |          |Note: The channel configuration is the same as REQSRC0 field.
 * |        |          |Please refer to the explanation of REQSRC0.
 * @var PDMA_T::REQSEL4_7
 * Offset: 0x484  PDMA Request Source Select Register 1
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[4:0]   |REQSRC4   |Channel 4 Request Source Selection
 * |        |          |This filed defines which peripheral is connected to PDMA channel 4.
 * |        |          |User can configure the peripheral setting by REQSRC4.
 * |        |          |Note: The channel configuration is the same as REQSRC0 field.
 * |        |          |Please refer to the explanation of REQSRC0.
 * |[12:8]  |REQSRC5   |Channel 5 Request Source Selection
 * |        |          |This filed defines which peripheral is connected to PDMA channel 5.
 * |        |          |User can configure the peripheral setting by REQSRC5.
 * |        |          |Note: The channel configuration is the same as REQSRC0 field.
 * |        |          |Please refer to the explanation of REQSRC0.
 * |[20:16] |REQSRC6   |Channel 6 Request Source Selection
 * |        |          |This filed defines which peripheral is connected to PDMA channel 6.
 * |        |          |User can configure the peripheral setting by REQSRC6.
 * |        |          |Note: The channel configuration is the same as REQSRC0 field.
 * |        |          |Please refer to the explanation of REQSRC0.
 * |[28:24] |REQSRC7   |Channel 7 Request Source Selection
 * |        |          |This filed defines which peripheral is connected to PDMA channel 7.
 * |        |          |User can configure the peripheral setting by REQSRC7.
 * |        |          |Note: The channel configuration is the same as REQSRC0 field.
 * |        |          |Please refer to the explanation of REQSRC0.
 * @var PDMA_T::REQSEL8_11
 * Offset: 0x488  PDMA Request Source Select Register 2
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[4:0]   |REQSRC8   |Channel 8 Request Source Selection
 * |        |          |This filed defines which peripheral is connected to PDMA channel 8.
 * |        |          |User can configure the peripheral setting by REQSRC8.
 * |        |          |Note: The channel configuration is the same as REQSRC0 field.
 * |        |          |Please refer to the explanation of REQSRC0.
 * |[12:8]  |REQSRC9   |Channel 9 Request Source Selection
 * |        |          |This filed defines which peripheral is connected to PDMA channel 9.
 * |        |          |User can configure the peripheral setting by REQSRC9.
 * |        |          |Note: The channel configuration is the same as REQSRC0 field.
 * |        |          |Please refer to the explanation of REQSRC0.
 * |[20:16] |REQSRC10  |Channel 10 Request Source Selection
 * |        |          |This filed defines which peripheral is connected to PDMA channel 10.
 * |        |          |User can configure the peripheral setting by REQSRC10.
 * |        |          |Note: The channel configuration is the same as REQSRC0 field.
 * |        |          |Please refer to the explanation of REQSRC0.
 * |[28:24] |REQSRC11  |Channel 11 Request Source Selection
 * |        |          |This filed defines which peripheral is connected to PDMA channel 11.
 * |        |          |User can configure the peripheral setting by REQSRC11.
 * |        |          |Note: The channel configuration is the same as REQSRC0 field.
 * |        |          |Please refer to the explanation of REQSRC0.
 */
    
    DSCT_T        DSCT[12];      /* Offset: 0x0000 ~ 0x00BC  DMA Embedded Description Table 0~11                     */             
    __I  uint32_t CURSCAT[12];                                                                                                      
    __I  uint32_t RESERVE0[196]; /* Offset: 0xC0 ~ 0xEC Current Scatter-Gather Descriptor Table Address of PDMA Channel 0~11 */     
    __IO uint32_t CHCTL;         /* Offset: 0x400  PDMA Channel Control Register                                     */             
    __O  uint32_t STOP;          /* Offset: 0x404  PDMA Transfer Stop Control Register                               */             
    __O  uint32_t SWREQ;         /* Offset: 0x408  PDMA Software Request Register                                    */             
    __I  uint32_t TRGSTS;        /* Offset: 0x40C  PDMA Channel Request Status Register                              */             
    __IO uint32_t PRISET;        /* Offset: 0x410  PDMA Fixed Priority Setting Register                              */             
    __O  uint32_t PRICLR;        /* Offset: 0x414  PDMA Fixed Priority Clear Register                                */             
    __IO uint32_t INTEN;         /* Offset: 0x418  PDMA Interrupt Enable Register                                    */             
    __IO uint32_t INTSTS;        /* Offset: 0x41C  PDMA Interrupt Status Register                                    */             
    __IO uint32_t ABTSTS;        /* Offset: 0x420  PDMA Channel Read/Write Target Abort Flag Register                */             
    __IO uint32_t TDSTS;         /* Offset: 0x424  PDMA Channel Transfer Done Flag Register                          */             
    __IO uint32_t SCATSTS;       /* Offset: 0x428  PDMA Scatter-Gather Table Empty Status Register                   */             
    __I  uint32_t TACTSTS;                                                                                                          
    __I  uint32_t RESERVE1[1];   /* Offset: 0x42C  PDMA Transfer Active Flag Register                                */             
    __IO uint32_t TOUTEN;        /* Offset: 0x434  PDMA Time-out Enable register                                     */             
    __IO uint32_t TOUTIEN;       /* Offset: 0x438  PDMA Time-out Interrupt Enable register                           */             
    __IO uint32_t SCATBA;        /* Offset: 0x43C  PDMA Scatter-Gather Descriptor Table Base Address Register        */             
    __IO uint32_t TOC0_1;        /* Offset: 0x440  PDMA Time-out Counter Ch1 and Ch0 Register                        */             
    __IO uint32_t TOC2_3;        /* Offset: 0x444  PDMA Time-out Counter Ch3 and Ch2 Register                        */             
    __IO uint32_t TOC4_5;        /* Offset: 0x448  PDMA Time-out Counter Ch5 and Ch4 Register                        */             
    __IO uint32_t TOC6_7;                                                                                                           
    __I  uint32_t RESERVE2[12];  /* Offset: 0x44C  PDMA Time-out Counter Ch7 and Ch6 Register                        */             
    __IO uint32_t REQSEL0_3;     /* Offset: 0x480  PDMA Request Source Select Register 0                             */             
    __IO uint32_t REQSEL4_7;     /* Offset: 0x484  PDMA Request Source Select Register 1                             */             
    __IO uint32_t REQSEL8_11;    /* Offset: 0x484  PDMA Request Source Select Register 2                             */

} PDMA_T;



/**
    @addtogroup PDMA_CONST PDMA Bit Field Definition
    Constant Definitions for PDMA Controller
@{ */

#define PDMA_DSCT_CTL_OPMODE_Pos         (0)                                               /*!< DSCT_T::CTL: OPMODE Position              */
#define PDMA_DSCT_CTL_OPMODE_Msk         (0x3ul << PDMA_DSCT_CTL_OPMODE_Pos)               /*!< DSCT_T::CTL: OPMODE Mask                  */

#define PDMA_DSCT_CTL_TXTYPE_Pos         (2)                                               /*!< DSCT_T::CTL: TXTYPE Position              */
#define PDMA_DSCT_CTL_TXTYPE_Msk         (1ul << PDMA_DSCT_CTL_TXTYPE_Pos)                 /*!< DSCT_T::CTL: TXTYPE Mask                  */

#define PDMA_DSCT_CTL_BURSIZE_Pos        (4)                                               /*!< DSCT_T::CTL: BURSIZE Position             */
#define PDMA_DSCT_CTL_BURSIZE_Msk        (0x7ul << PDMA_DSCT_CTL_BURSIZE_Pos)              /*!< DSCT_T::CTL: BURSIZE Mask                 */

#define PDMA_DSCT_CTL_TBINTDIS_Pos       (7)                                               /*!< DSCT_T::CTL: TBINTDIS Position            */
#define PDMA_DSCT_CTL_TBINTDIS_Msk       (1ul << PDMA_DSCT_CTL_TBINTDIS_Pos)               /*!< DSCT_T::CTL: TBINTDIS Mask                */

#define PDMA_DSCT_CTL_SAINC_Pos          (8)                                               /*!< DSCT_T::CTL: SAINC Position               */
#define PDMA_DSCT_CTL_SAINC_Msk          (0x3ul << PDMA_DSCT_CTL_SAINC_Pos)                /*!< DSCT_T::CTL: SAINC Mask                   */

#define PDMA_DSCT_CTL_DAINC_Pos          (10)                                              /*!< DSCT_T::CTL: DAINC Position               */
#define PDMA_DSCT_CTL_DAINC_Msk          (0x3ul << PDMA_DSCT_CTL_DAINC_Pos)                /*!< DSCT_T::CTL: DAINC Mask                   */

#define PDMA_DSCT_CTL_TXWIDTH_Pos        (12)                                              /*!< DSCT_T::CTL: TXWIDTH Position             */
#define PDMA_DSCT_CTL_TXWIDTH_Msk        (0x3ul << PDMA_DSCT_CTL_TXWIDTH_Pos)              /*!< DSCT_T::CTL: TXWIDTH Mask                 */

#define PDMA_DSCT_CTL_TXCNT_Pos          (16)                                              /*!< DSCT_T::CTL: TXCNT Position               */
#define PDMA_DSCT_CTL_TXCNT_Msk          (0x3FFFul << PDMA_DSCT_CTL_TXCNT_Pos)             /*!< DSCT_T::CTL: TXCNT Mask                   */

#define PDMA_DSCT_SA_SA_Pos              (0)                                               /*!< DSCT_T::SA: SA Position                   */
#define PDMA_DSCT_SA_SA_Msk              (0xFFFFFFFFul << PDMA_DSCT_SA_SA_Pos)             /*!< DSCT_T::SA: SA Mask                       */

#define PDMA_DSCT_DA_DA_Pos              (0)                                               /*!< DSCT_T::DA: DA Position                   */
#define PDMA_DSCT_DA_DA_Msk              (0xFFFFFFFFul << PDMA_DSCT_DA_DA_Pos)             /*!< DSCT_T::DA: DA Mask                       */

#define PDMA_DSCT_NEXT_NEXT_Pos          (0)                                               /*!< DSCT_T::NEXT: NEXT Position               */
#define PDMA_DSCT_NEXT_NEXT_Msk          (0xFFFFul << PDMA_DSCT_NEXT_NEXT_Pos)             /*!< DSCT_T::NEXT: NEXT Mask                   */

#define PDMA_CURSCAT_CURADDR_Pos         (0)                                               /*!< PDMA_T::CURSCAT: CURADDR Position         */
#define PDMA_CURSCAT_CURADDR_Msk         (0xfffffffful << PDMA_CURSCAT_CURADDR_Pos)        /*!< PDMA_T::CURSCAT: CURADDR Mask             */

#define PDMA_CHCTL_CHENn_Pos             (0)                                               /*!< PDMA_T::CHCTL: CHENn Position             */
#define PDMA_CHCTL_CHENn_Msk             (0xffful << PDMA_CHCTL_CHENn_Pos)                 /*!< PDMA_T::CHCTL: CHENn Mask                 */

#define PDMA_STOP_STOPn_Pos              (0)                                               /*!< PDMA_T::STOP: STOPn Position              */
#define PDMA_STOP_STOPn_Msk              (0xffful << PDMA_STOP_STOPn_Pos)                  /*!< PDMA_T::STOP: STOPn Mask                  */

#define PDMA_SWREQ_SWREQn_Pos            (0)                                               /*!< PDMA_T::SWREQ: SWREQn Position            */
#define PDMA_SWREQ_SWREQn_Msk            (0xffful << PDMA_SWREQ_SWREQn_Pos)                /*!< PDMA_T::SWREQ: SWREQn Mask                */

#define PDMA_TRGSTS_REQSTSn_Pos          (0)                                               /*!< PDMA_T::TRGSTS: REQSTSn Position          */
#define PDMA_TRGSTS_REQSTSn_Msk          (0xffful << PDMA_TRGSTS_REQSTSn_Pos)              /*!< PDMA_T::TRGSTS: REQSTSn Mask              */

#define PDMA_PRISET_FPRISETn_Pos         (0)                                               /*!< PDMA_T::PRISET: FPRISETn Position         */
#define PDMA_PRISET_FPRISETn_Msk         (0xffful << PDMA_PRISET_FPRISETn_Pos)             /*!< PDMA_T::PRISET: FPRISETn Mask             */

#define PDMA_PRICLR_FPRICLRn_Pos         (0)                                               /*!< PDMA_T::PRICLR: FPRICLRn Position         */
#define PDMA_PRICLR_FPRICLRn_Msk         (0xffful << PDMA_PRICLR_FPRICLRn_Pos)             /*!< PDMA_T::PRICLR: FPRICLRn Mask             */

#define PDMA_INTEN_INTENn_Pos            (0)                                               /*!< PDMA_T::INTEN: INTENn Position            */
#define PDMA_INTEN_INTENn_Msk            (0xffful << PDMA_INTEN_INTENn_Pos)                /*!< PDMA_T::INTEN: INTENn Mask                */

#define PDMA_INTSTS_ABTIF_Pos            (0)                                               /*!< PDMA_T::INTSTS: ABTIF Position            */
#define PDMA_INTSTS_ABTIF_Msk            (0x1ul << PDMA_INTSTS_ABTIF_Pos)                  /*!< PDMA_T::INTSTS: ABTIF Mask                */

#define PDMA_INTSTS_TDIF_Pos             (1)                                               /*!< PDMA_T::INTSTS: TDIF Position             */
#define PDMA_INTSTS_TDIF_Msk             (0x1ul << PDMA_INTSTS_TDIF_Pos)                   /*!< PDMA_T::INTSTS: TDIF Mask                 */

#define PDMA_INTSTS_TEIF_Pos             (2)                                               /*!< PDMA_T::INTSTS: TEIF Position             */
#define PDMA_INTSTS_TEIF_Msk             (0x1ul << PDMA_INTSTS_TEIF_Pos)                   /*!< PDMA_T::INTSTS: TEIF Mask                 */

#define PDMA_INTSTS_REQTOFn_Pos          (8)                                               /*!< PDMA_T::INTSTS: REQTOFn Position          */
#define PDMA_INTSTS_REQTOFn_Msk          (0xfful << PDMA_INTSTS_REQTOFn_Pos)               /*!< PDMA_T::INTSTS: REQTOFn Mask              */

#define PDMA_ABTSTS_ABTIFn_Pos           (0)                                               /*!< PDMA_T::ABTSTS: ABTIFn Position           */
#define PDMA_ABTSTS_ABTIFn_Msk           (0xffful << PDMA_ABTSTS_ABTIFn_Pos)               /*!< PDMA_T::ABTSTS: ABTIFn Mask               */

#define PDMA_TDSTS_TDIFn_Pos             (0)                                               /*!< PDMA_T::TDSTS: TDIFn Position             */
#define PDMA_TDSTS_TDIFn_Msk             (0xffful << PDMA_TDSTS_TDIFn_Pos)                 /*!< PDMA_T::TDSTS: TDIFn Mask                 */

#define PDMA_SCATSTS_TEMPTYFn_Pos        (0)                                               /*!< PDMA_T::SCATSTS: TEMPTYFn Position        */
#define PDMA_SCATSTS_TEMPTYFn_Msk        (0xffful << PDMA_SCATSTS_TEMPTYFn_Pos)            /*!< PDMA_T::SCATSTS: TEMPTYFn Mask            */

#define PDMA_TACTSTS_TXACTFn_Pos         (0)                                               /*!< PDMA_T::TACTSTS: TXACTFn Position         */
#define PDMA_TACTSTS_TXACTFn_Msk         (0xffful << PDMA_TACTSTS_TXACTFn_Pos)             /*!< PDMA_T::TACTSTS: TXACTFn Mask             */

#define PDMA_TOUTEN_TOUTENn_Pos          (0)                                               /*!< PDMA_T::TOUTEN: TOUTENn Position          */
#define PDMA_TOUTEN_TOUTENn_Msk          (0xfful << PDMA_TOUTEN_TOUTENn_Pos)               /*!< PDMA_T::TOUTEN: TOUTENn Mask              */

#define PDMA_TOUTIEN_TOUTIENn_Pos        (0)                                               /*!< PDMA_T::TOUTIEN: TOUTIENn Position        */
#define PDMA_TOUTIEN_TOUTIENn_Msk        (0xfful << PDMA_TOUTIEN_TOUTIENn_Pos)             /*!< PDMA_T::TOUTIEN: TOUTIENn Mask            */

#define PDMA_SCATBA_SCATBA_Pos           (16)                                              /*!< PDMA_T::SCATBA: SCATBA Position           */
#define PDMA_SCATBA_SCATBA_Msk           (0xfffful << PDMA_SCATBA_SCATBA_Pos)              /*!< PDMA_T::SCATBA: SCATBA Mask               */

#define PDMA_TOC0_1_TOC0_Pos             (0)                                               /*!< PDMA_T::TOC0_1: TOC0 Position             */
#define PDMA_TOC0_1_TOC0_Msk             (0xfffful << PDMA_TOC0_1_TOC0_Pos)                /*!< PDMA_T::TOC0_1: TOC0 Mask                 */

#define PDMA_TOC0_1_TOC1_Pos             (16)                                              /*!< PDMA_T::TOC0_1: TOC1 Position             */
#define PDMA_TOC0_1_TOC1_Msk             (0xfffful << PDMA_TOC0_1_TOC1_Pos)                /*!< PDMA_T::TOC0_1: TOC1 Mask                 */

#define PDMA_TOC2_3_TOC2_Pos             (0)                                               /*!< PDMA_T::TOC2_3: TOC2 Position             */
#define PDMA_TOC2_3_TOC2_Msk             (0xfffful << PDMA_TOC2_3_TOC2_Pos)                /*!< PDMA_T::TOC2_3: TOC2 Mask                 */

#define PDMA_TOC2_3_TOC3_Pos             (16)                                              /*!< PDMA_T::TOC2_3: TOC3 Position             */
#define PDMA_TOC2_3_TOC3_Msk             (0xfffful << PDMA_TOC2_3_TOC3_Pos)                /*!< PDMA_T::TOC2_3: TOC3 Mask                 */

#define PDMA_TOC4_5_TOC4_Pos             (0)                                               /*!< PDMA_T::TOC4_5: TOC4 Position             */
#define PDMA_TOC4_5_TOC4_Msk             (0xfffful << PDMA_TOC4_5_TOC4_Pos)                /*!< PDMA_T::TOC4_5: TOC4 Mask                 */

#define PDMA_TOC4_5_TOC5_Pos             (16)                                              /*!< PDMA_T::TOC4_5: TOC5 Position             */
#define PDMA_TOC4_5_TOC5_Msk             (0xfffful << PDMA_TOC4_5_TOC5_Pos)                /*!< PDMA_T::TOC4_5: TOC5 Mask                 */

#define PDMA_TOC6_7_TOC6_Pos             (0)                                               /*!< PDMA_T::TOC6_7: TOC6 Position             */
#define PDMA_TOC6_7_TOC6_Msk             (0xfffful << PDMA_TOC6_7_TOC6_Pos)                /*!< PDMA_T::TOC6_7: TOC6 Mask                 */

#define PDMA_TOC6_7_TOC7_Pos             (16)                                              /*!< PDMA_T::TOC6_7: TOC7 Position             */
#define PDMA_TOC6_7_TOC7_Msk             (0xfffful << PDMA_TOC6_7_TOC7_Pos)                /*!< PDMA_T::TOC6_7: TOC7 Mask                 */

#define PDMA_REQSEL0_3_REQSRC0_Pos       (0)                                               /*!< PDMA_T::REQSEL0_3: REQSRC0 Position       */
#define PDMA_REQSEL0_3_REQSRC0_Msk       (0x1ful << PDMA_REQSEL0_3_REQSRC0_Pos)            /*!< PDMA_T::REQSEL0_3: REQSRC0 Mask           */

#define PDMA_REQSEL0_3_REQSRC1_Pos       (8)                                               /*!< PDMA_T::REQSEL0_3: REQSRC1 Position       */
#define PDMA_REQSEL0_3_REQSRC1_Msk       (0x1ful << PDMA_REQSEL0_3_REQSRC1_Pos)            /*!< PDMA_T::REQSEL0_3: REQSRC1 Mask           */

#define PDMA_REQSEL0_3_REQSRC2_Pos       (16)                                              /*!< PDMA_T::REQSEL0_3: REQSRC2 Position       */
#define PDMA_REQSEL0_3_REQSRC2_Msk       (0x1ful << PDMA_REQSEL0_3_REQSRC2_Pos)            /*!< PDMA_T::REQSEL0_3: REQSRC2 Mask           */

#define PDMA_REQSEL0_3_REQSRC3_Pos       (24)                                              /*!< PDMA_T::REQSEL0_3: REQSRC3 Position       */
#define PDMA_REQSEL0_3_REQSRC3_Msk       (0x1ful << PDMA_REQSEL0_3_REQSRC3_Pos)            /*!< PDMA_T::REQSEL0_3: REQSRC3 Mask           */

#define PDMA_REQSEL4_7_REQSRC4_Pos       (0)                                               /*!< PDMA_T::REQSEL4_7: REQSRC4 Position       */
#define PDMA_REQSEL4_7_REQSRC4_Msk       (0x1ful << PDMA_REQSEL4_7_REQSRC4_Pos)            /*!< PDMA_T::REQSEL4_7: REQSRC4 Mask           */

#define PDMA_REQSEL4_7_REQSRC5_Pos       (8)                                               /*!< PDMA_T::REQSEL4_7: REQSRC5 Position       */
#define PDMA_REQSEL4_7_REQSRC5_Msk       (0x1ful << PDMA_REQSEL4_7_REQSRC5_Pos)            /*!< PDMA_T::REQSEL4_7: REQSRC5 Mask           */

#define PDMA_REQSEL4_7_REQSRC6_Pos       (16)                                              /*!< PDMA_T::REQSEL4_7: REQSRC6 Position       */
#define PDMA_REQSEL4_7_REQSRC6_Msk       (0x1ful << PDMA_REQSEL4_7_REQSRC6_Pos)            /*!< PDMA_T::REQSEL4_7: REQSRC6 Mask           */

#define PDMA_REQSEL4_7_REQSRC7_Pos       (24)                                              /*!< PDMA_T::REQSEL4_7: REQSRC7 Position       */
#define PDMA_REQSEL4_7_REQSRC7_Msk       (0x1ful << PDMA_REQSEL4_7_REQSRC7_Pos)            /*!< PDMA_T::REQSEL4_7: REQSRC7 Mask           */

#define PDMA_REQSEL8_11_REQSRC8_Pos      (0)                                               /*!< PDMA_T::REQSEL8_11: REQSRC8 Position      */
#define PDMA_REQSEL8_11_REQSRC8_Msk      (0x1ful << PDMA_REQSEL8_11_REQSRC8_Pos)           /*!< PDMA_T::REQSEL8_11: REQSRC8 Mask          */

#define PDMA_REQSEL8_11_REQSRC9_Pos      (8)                                               /*!< PDMA_T::REQSEL8_11: REQSRC9 Position      */
#define PDMA_REQSEL8_11_REQSRC9_Msk      (0x1ful << PDMA_REQSEL8_11_REQSRC9_Pos)           /*!< PDMA_T::REQSEL8_11: REQSRC9 Mask          */

#define PDMA_REQSEL8_11_REQSRC10_Pos     (16)                                              /*!< PDMA_T::REQSEL8_11: REQSRC10 Position     */
#define PDMA_REQSEL8_11_REQSRC10_Msk     (0x1ful << PDMA_REQSEL8_11_REQSRC10_Pos)          /*!< PDMA_T::REQSEL8_11: REQSRC10 Mask         */

#define PDMA_REQSEL8_11_REQSRC11_Pos     (24)                                              /*!< PDMA_T::REQSEL8_11: REQSRC11 Position     */
#define PDMA_REQSEL8_11_REQSRC11_Msk     (0x1ful << PDMA_REQSEL8_11_REQSRC11_Pos)          /*!< PDMA_T::REQSEL8_11: REQSRC11 Mask         */

/**@}*/ /* PDMA_CONST */
/**@}*/ /* end of PDMA register group */


/*---------------------- Pulse Width Modulation Controller -------------------------*/
/**
    @addtogroup PWM Pulse Width Modulation Controller(PWM)
    Memory Mapped Structure for PWM Controller
@{ */


typedef struct
{


/**
 * @var PWM_T::CTL0
 * Offset: 0x00  PWM Control Register 0
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[5:0]   |CTRLDn    |Center Re-Load
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |        |          |In up-down counter type, PERIOD will load to PBUF at the end point of each period.
 * |        |          |CMPDAT will load to CMPBUF at the center point of a period.
 * |[13:8]  |WINLDENn  |Window Load Enable
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |        |          |0 = PERIOD will load to PBUF at the end point of each period.
 * |        |          |CMPDAT will load to CMPBUF at the end point or center point of each period by setting CTRLD bit.
 * |        |          |1 = PERIOD will load to PBUF at the end point of each period.
 * |        |          |CMPDAT will load to CMPBUF at the end point of each period when valid reload window is set.
 * |        |          |The valid reload window is set by software write 1 to PWM_LOAD register and cleared by hardware after load success.
 * |[21:16] |IMMLDENn  |Immediately Load Enable
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |        |          |0 = PERIOD will load to PBUF at the end point of each period.
 * |        |          |CMPDAT will load to CMPBUF at the end point or center point of each period by setting CTRLD bit.
 * |        |          |1 = PERIOD/CMPDAT will load to PBUF and CMPBUF immediately when software update PERIOD/CMPDAT.
 * |        |          |Note: If IMMLDENn is enabled, WINLDENn and CTRLDn will be invalid.
 * |[24]    |GROUPEN   |Group Function Enable
 * |        |          |0 = The output waveform of each PWM channel are independent.
 * |        |          |1 = Unify the PWM_CH2 and PWM_CH4 to output the same waveform as PWM_CH0 and unify the PWM_CH3 and PWM_CH5 to output the same waveform as PWM_CH1.
 * |[30]    |DBGHALT   |ICE Debug Mode Counter Halt (Write Protect)
 * |        |          |If counter halt is enabled, PWM all counters will keep current value until exit ICE debug mode.
 * |        |          |0 = ICE debug mode counter halt disable.
 * |        |          |1 = ICE debug mode counter halt enable.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[31]    |DBGTRIOFF |ICE Debug Mode Acknowledge Disable (Write Protect)
 * |        |          |0 = ICE debug mode acknowledgement effects PWM output.
 * |        |          |PWM pin will be forced as tri-state while ICE debug mode acknowledged.
 * |        |          |1 = ICE debug mode acknowledgement disabled.
 * |        |          |PWM pin will keep output no matter ICE debug mode acknowledged or not.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * @var PWM_T::CTL1
 * Offset: 0x04  PWM Control Register 1
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[11:0]  |CNTTYPEn  |PWM Counter Behavior Type
 * |        |          |Each bit n controls corresponding PWM channel n.
 * |        |          |00 = Up counter type (supports in capture mode).
 * |        |          |01 = Down count type (supports in capture mode).
 * |        |          |10 = Up-down counter type.
 * |        |          |11 = Reserved.
 * |[21:16] |CNTMODEn  |PWM Counter Mode
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |        |          |0 = Auto-reload mode.
 * |        |          |1 = One-shot mode.
 * |[26:24] |OUTMODEn  |PWM Output Mode
 * |        |          |Each bit n controls the
 * |        |          |output mode of
 * |        |          |corresponding PWM channel n.
 * |        |          |0 = PWM independent mode.
 * |        |          |1 = PWM complementary mode.
 * |        |          |Note: When operating in group function, these bits must all set to the same mode.
 * @var PWM_T::SYNC
 * Offset: 0x08  PWM Synchronization Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[2:0]   |PHSENn    |SYNC Phase Enable
 * |        |          |Each bit n controls corresponding PWM channel n.
 * |        |          |0 = PWM counter disable to load PHS value.
 * |        |          |1 = PWM counter enable to load PHS value.
 * |[13:8]  |SINSRCn   |PWM_SYNC_IN Source Selection
 * |        |          |Each bit n controls corresponding PWM channel n.
 * |        |          |00 = Synchronize source from SYNC_IN or SWSYNC.
 * |        |          |01 = Counter equal to 0.
 * |        |          |10 = Counter equal to PWM_CMPDATm, m denotes 1, 3, 5.
 * |        |          |11 = SYNC_OUT will not be generated.
 * |[16]    |SNFLTEN   |PWM_SYNC_IN Noise Filter Enable
 * |        |          |0 = Noise filter of input pin PWM_SYNC_IN is Disabled.
 * |        |          |1 = Noise filter of input pin PWM_SYNC_IN is Enabled.
 * |[19:17] |SFLTCSEL  |SYNC Edge Detector Filter Clock Selection
 * |        |          |000 = Filter clock = HCLK.
 * |        |          |001 = Filter clock = HCLK/2.
 * |        |          |010 = Filter clock = HCLK/4.
 * |        |          |011 = Filter clock = HCLK/8.
 * |        |          |100 = Filter clock = HCLK/16.
 * |        |          |101 = Filter clock = HCLK/32.
 * |        |          |110 = Filter clock = HCLK/64.
 * |        |          |111 = Filter clock = HCLK/128.
 * |[22:20] |SFLTCNT   |SYNC Edge Detector Filter Count
 * |        |          |The register bits control the counter number of edge detector.
 * |[23]    |SINPINV   |SYNC Input Pin Inverse
 * |        |          |0 = The state of pin SYNC is passed to the negative edge detector.
 * |        |          |1 = The inverted state of pin SYNC is passed to the negative edge detector.
 * |[26:24] |PHSDIRn   |PWM Phase Direction Control
 * |        |          |Each bit n controls corresponding PWM channel n.
 * |        |          |0 = Control PWM counter count decrement after synchronizing.
 * |        |          |1 = Control PWM counter count increment after synchronizing.
 * @var PWM_T::SWSYNC
 * Offset: 0x0C  PWM Software Control Synchronization Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[2:0]   |SWSYNCn   |Software SYNC Function
 * |        |          |Each bit n controls corresponding PWM channel n.
 * |        |          |When SINSRCn (PWM_SYNC[13:8]) is selected to 0, SYNC_OUT source is come from SYNC_IN or this bit.
 * @var PWM_T::CLKSRC
 * Offset: 0x10  PWM Clock Source Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[2:0]   |ECLKSRC0  |PWM_CH01 External Clock Source Select
 * |        |          |000 = PWMx_CLK, x denotes 0 or 1.
 * |        |          |001 = TIMER0 overflow.
 * |        |          |010 = TIMER1 overflow.
 * |        |          |011 = TIMER2 overflow.
 * |        |          |100 = TIMER3 overflow.
 * |        |          |Others = Reserved.
 * |[10:8]  |ECLKSRC2  |PWM_CH23 External Clock Source Select
 * |        |          |000 = PWMx_CLK, x denotes 0 or 1.
 * |        |          |001 = TIMER0 overflow.
 * |        |          |010 = TIMER1 overflow.
 * |        |          |011 = TIMER2 overflow.
 * |        |          |100 = TIMER3 overflow.
 * |        |          |Others = Reserved.
 * |[18:16] |ECLKSRC4  |PWM_CH45 External Clock Source Select
 * |        |          |000 = PWMx_CLK, x denotes 0 or 1.
 * |        |          |001 = TIMER0 overflow.
 * |        |          |010 = TIMER1 overflow.
 * |        |          |011 = TIMER2 overflow.
 * |        |          |100 = TIMER3 overflow.
 * |        |          |Others = Reserved.
 * @var PWM_T::CLKPSC0_1
 * Offset: 0x14  PWM Clock Pre-scale Register 0
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[11:0]  |CLKPSC    |PWM Counter Clock Pre-Scale
 * |        |          |The clock of PWM counter is decided by clock prescaler.
 * |        |          |Each PWM pair share one PWM counter clock prescaler.
 * |        |          |The clock of PWM counter is divided by (CLKPSC+ 1).
 * @var PWM_T::CLKPSC2_3
 * Offset: 0x18  PWM Clock Pre-scale Register 2
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[11:0]  |CLKPSC    |PWM Counter Clock Pre-Scale
 * |        |          |The clock of PWM counter is decided by clock prescaler.
 * |        |          |Each PWM pair share one PWM counter clock prescaler.
 * |        |          |The clock of PWM counter is divided by (CLKPSC+ 1).
 * @var PWM_T::CLKPSC4_5
 * Offset: 0x1C  PWM Clock Pre-scale Register 4
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[11:0]  |CLKPSC    |PWM Counter Clock Pre-Scale
 * |        |          |The clock of PWM counter is decided by clock prescaler.
 * |        |          |Each PWM pair share one PWM counter clock prescaler.
 * |        |          |The clock of PWM counter is divided by (CLKPSC+ 1).
 * @var PWM_T::CNTEN
 * Offset: 0x20  PWM Counter Enable Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[5:0]   |CNTENn    |PWM Counter Enable
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |        |          |0 = PWM Counter and clock prescaler Stop Running.
 * |        |          |1 = PWM Counter and clock prescaler Start Running.
 * @var PWM_T::CNTCLR
 * Offset: 0x24  PWM Clear Counter Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[5:0]   |CNTCLRn   |Clear PWM Counter Control Bit
 * |        |          |It is automatically cleared by hardware. Each bit n controls the corresponding PWM channel n.
 * |        |          |0 = No effect.
 * |        |          |1 = Clear 16-bit PWM counter to 0000H.
 * @var PWM_T::LOAD
 * Offset: 0x28  PWM Load Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[5:0]   |LOADn     |Re-Load PWM Comparator Register (CMPDAT) Control Bit
 * |        |          |This bit is software write, hardware clear when current PWM period end.
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |        |          |Write Operation:
 * |        |          |0 = No effect.
 * |        |          |1 = Set load window of window loading mode.
 * |        |          |Read Operation:
 * |        |          |0 = No load window is set.
 * |        |          |1 = Load window is set.
 * |        |          |Note: This bit only use in window loading mode, WINLDENn(PWM_CTL0[13:8]) = 1.
 * @var PWM_T::PERIOD
 * Offset: 0x30~0x44  PWM Period Register 0~5
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |PERIOD    |PWM Period Register
 * |        |          |Up-Count mode: In this mode, PWM counter counts from 0 to PERIOD, and restarts from 0.
 * |        |          |Down-Count mode: In this mode, PWM counter counts from PERIOD to 0, and restarts from PERIOD.
 * |        |          |PWM period time = (PERIOD+1) * PWM_CLK period.
 * |        |          |Up-Down-Count mode: In this mode, PWM counter counts from 0 to PERIOD, then decrements to 0 and repeats again.
 * |        |          |PWM period time = 2 * PERIOD * PWM_CLK period.
 * @var PWM_T::CMPDAT
 * Offset: 0x50~0x64  PWM Comparator Register 0~5
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |CMP       |PWM Comparator Register
 * |        |          |CMP use to compare with CNTR to generate PWM waveform, interrupt and trigger EADC/DAC.
 * |        |          |In independent mode, CMPDAT0~5 denote as 6 independent PWM_CH0~5 compared point.
 * |        |          |In complementary mode, CMPDAT0, 2, 4 denote as first compared point, and CMPDAT1, 3, 5 denote as second compared point for the corresponding 3 complementary pairs PWM_CH0 and PWM_CH1, PWM_CH2 and PWM_CH3, PWM_CH4 and PWM_CH5.
 * @var PWM_T::DTCTL0_1
 * Offset: 0x70  PWM Dead-Time Control Register 0
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[11:0]  |DTCNT     |Dead-Time Counter (Write Protect)
 * |        |          |The dead-time can be calculated from the following formula:
 * |        |          |Dead-time = (DTCNT[11:0]+1) * PWM_CLK period.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[16]    |DTEN      |Enable Dead-Time Insertion For PWM Pair (PWM_CH0, PWM_CH1) (PWM_CH2, PWM_CH3) (PWM_CH4, PWM_CH5) (Write Protect)
 * |        |          |Dead-time insertion is only active when this pair of complementary PWM is enabled.
 * |        |          |If dead- time insertion is inactive, the outputs of pin pair are complementary without any delay.
 * |        |          |0 = Dead-time insertion Disabled on the pin pair.
 * |        |          |1 = Dead-time insertion Enabled on the pin pair.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[24]    |DTCKSEL   |Dead-Time Clock Select (Write Protect) (M45xD/M45xC Only)
 * |        |          |0 = Dead-time clock source from PWM_CLK.
 * |        |          |1 = Dead-time clock source from prescaler output.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * @var PWM_T::DTCTL2_3
 * Offset: 0x74  PWM Dead-Time Control Register 2
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[11:0]  |DTCNT     |Dead-Time Counter (Write Protect)
 * |        |          |The dead-time can be calculated from the following formula:
 * |        |          |Dead-time = (DTCNT[11:0]+1) * PWM_CLK period.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[16]    |DTEN      |Enable Dead-Time Insertion For PWM Pair (PWM_CH0, PWM_CH1) (PWM_CH2, PWM_CH3) (PWM_CH4, PWM_CH5) (Write Protect)
 * |        |          |Dead-time insertion is only active when this pair of complementary PWM is enabled.
 * |        |          |If dead- time insertion is inactive, the outputs of pin pair are complementary without any delay.
 * |        |          |0 = Dead-time insertion Disabled on the pin pair.
 * |        |          |1 = Dead-time insertion Enabled on the pin pair.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[24]    |DTCKSEL   |Dead-Time Clock Select (Write Protect) (M45xD/M45xC Only)
 * |        |          |0 = Dead-time clock source from PWM_CLK.
 * |        |          |1 = Dead-time clock source from prescaler output.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * @var PWM_T::DTCTL4_5
 * Offset: 0x78  PWM Dead-Time Control Register 4
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[11:0]  |DTCNT     |Dead-Time Counter (Write Protect)
 * |        |          |The dead-time can be calculated from the following formula:
 * |        |          |Dead-time = (DTCNT[11:0]+1) * PWM_CLK period.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[16]    |DTEN      |Enable Dead-Time Insertion For PWM Pair (PWM_CH0, PWM_CH1) (PWM_CH2, PWM_CH3) (PWM_CH4, PWM_CH5) (Write Protect)
 * |        |          |Dead-time insertion is only active when this pair of complementary PWM is enabled.
 * |        |          |If dead- time insertion is inactive, the outputs of pin pair are complementary without any delay.
 * |        |          |0 = Dead-time insertion Disabled on the pin pair.
 * |        |          |1 = Dead-time insertion Enabled on the pin pair.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[24]    |DTCKSEL   |Dead-Time Clock Select (Write Protect) (M45xD/M45xC Only)
 * |        |          |0 = Dead-time clock source from PWM_CLK.
 * |        |          |1 = Dead-time clock source from prescaler output.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * @var PWM_T::PHS0_1
 * Offset: 0x80  PWM Counter Phase Register 0
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |PHS       |PWM Synchronous Start Phase Bits
 * |        |          |PHS determines the PWM synchronous start phase value. These bits only use in synchronous function.
 * @var PWM_T::PHS2_3
 * Offset: 0x84  PWM Counter Phase Register 2
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |PHS       |PWM Synchronous Start Phase Bits
 * |        |          |PHS determines the PWM synchronous start phase value. These bits only use in synchronous function.
 * @var PWM_T::PHS4_5
 * Offset: 0x88  PWM Counter Phase Register 4
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |PHS       |PWM Synchronous Start Phase Bits
 * |        |          |PHS determines the PWM synchronous start phase value. These bits only use in synchronous function.
 * @var PWM_T::CNT
 * Offset: 0x90~0xA4  PWM Counter Register 0~5
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |CNT       |PWM Data Register (Read Only)
 * |        |          |User can monitor CNTR to know the current value in 16-bit period counter.
 * |[16]    |DIRF      |PWM Direction Indicator Flag (Read Only)
 * |        |          |0 = Counter is Down count.
 * |        |          |1 = Counter is UP count.
 * @var PWM_T::WGCTL0
 * Offset: 0xB0  PWM Generation Register 0
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[11:0]  |ZPCTLn    |PWM Zero Point Control
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |        |          |00 = Do nothing.
 * |        |          |01 = PWM zero point output Low.
 * |        |          |10 = PWM zero point output High.
 * |        |          |11 = PWM zero point output Toggle.
 * |        |          |PWM can control output level when PWM counter count to zero.
 * |[27:16] |PRDPCTLn  |PWM Period (Center) Point Control
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |        |          |00 = Do nothing.
 * |        |          |01 = PWM period (center) point output Low.
 * |        |          |10 = PWM period (center) point output High.
 * |        |          |11 = PWM period (center) point output Toggle.
 * |        |          |PWM can control output level when PWM counter count to (PERIODn+1).
 * |        |          |Note: This bit is center point control when PWM counter operating in up-down counter type.
 * @var PWM_T::WGCTL1
 * Offset: 0xB4  PWM Generation Register 1
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[11:0]  |CMPUCTLn  |PWM Compare Up Point Control
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |        |          |00 = Do nothing.
 * |        |          |01 = PWM compare up point output Low.
 * |        |          |10 = PWM compare up point output High.
 * |        |          |11 = PWM compare up point output Toggle.
 * |        |          |PWM can control output level when PWM counter up count to CMPDAT.
 * |        |          |Note: In complementary mode, CMPUCTL1, 3, 5 use as another CMPUCTL for channel 0, 2, 4.
 * |[27:16] |CMPDCTLn  |PWM Compare Down Point Control
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |        |          |00 = Do nothing.
 * |        |          |01 = PWM compare down point output Low.
 * |        |          |10 = PWM compare down point output High.
 * |        |          |11 = PWM compare down point output Toggle.
 * |        |          |PWM can control output level when PWM counter down count to CMPDAT.
 * |        |          |Note: In complementary mode, CMPDCTL1, 3, 5 use as another CMPDCTL for channel 0, 2, 4.
 * @var PWM_T::MSKEN
 * Offset: 0xB8  PWM Mask Enable Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[5:0]   |MSKENn    |PWM Mask Enable
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |        |          |The PWM output signal will be masked when this bit is enabled.
 * |        |          |The corresponding PWM channel n will output MSKDATn (PWM_MSK[5:0]) data.
 * |        |          |0 = PWM output signal is non-masked.
 * |        |          |1 = PWM output signal is masked and output MSKDATn data.
 * @var PWM_T::MSK
 * Offset: 0xBC  PWM Mask Data Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[5:0]   |MSKDATn   |PWM Mask Data Bit
 * |        |          |This data bit control the state of PWMn output pin, if corresponding mask function is enabled.
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |        |          |0 = Output logic low to PWMn.
 * |        |          |1 = Output logic high to PWMn.
 * @var PWM_T::BNF
 * Offset: 0xC0  PWM Brake Noise Filter Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |BRK0NFEN  |PWM Brake 0 Noise Filter Enable
 * |        |          |0 = Noise filter of PWM Brake 0 Disabled.
 * |        |          |1 = Noise filter of PWM Brake 0 Enabled.
 * |[3:1]   |BRK0NFSEL |Brake 0 Edge Detector Filter Clock Selection
 * |        |          |000 = Filter clock = HCLK.
 * |        |          |001 = Filter clock = HCLK/2.
 * |        |          |010 = Filter clock = HCLK/4.
 * |        |          |011 = Filter clock = HCLK/8.
 * |        |          |100 = Filter clock = HCLK/16.
 * |        |          |101 = Filter clock = HCLK/32.
 * |        |          |110 = Filter clock = HCLK/64.
 * |        |          |111 = Filter clock = HCLK/128.
 * |[6:4]   |BRK0FCNT  |Brake 0 Edge Detector Filter Count
 * |        |          |The register bits control the Brake0 filter counter to count from 0 to BRK1FCNT.
 * |[7]     |BRK0PINV  |Brake 0 Pin Inverse
 * |        |          |0 = The state of pin PWMx_BRAKE0 is passed to the negative edge detector.
 * |        |          |1 = The inverted state of pin PWMx_BRAKE10 is passed to the negative edge detector.
 * |[8]     |BRK1NFEN  |PWM Brake 1 Noise Filter Enable
 * |        |          |0 = Noise filter of PWM Brake 1 Disabled.
 * |        |          |1 = Noise filter of PWM Brake 1 Enabled.
 * |[11:9]  |BRK1NFSEL |Brake 1 Edge Detector Filter Clock Selection
 * |        |          |000 = Filter clock = HCLK.
 * |        |          |001 = Filter clock = HCLK/2.
 * |        |          |010 = Filter clock = HCLK/4.
 * |        |          |011 = Filter clock = HCLK/8.
 * |        |          |100 = Filter clock = HCLK/16.
 * |        |          |101 = Filter clock = HCLK/32.
 * |        |          |110 = Filter clock = HCLK/64.
 * |        |          |111 = Filter clock = HCLK/128.
 * |[14:12] |BRK1FCNT  |Brake 1 Edge Detector Filter Count
 * |        |          |The register bits control the Brake1 filter counter to count from 0 to BRK1FCNT.
 * |[15]    |BRK1PINV  |Brake 1 Pin Inverse
 * |        |          |0 = The state of pin PWMx_BRAKE1 is passed to the negative edge detector.
 * |        |          |1 = The inverted state of pin PWMx_BRAKE1 is passed to the negative edge detector.
 * |[16]    |BK0SRC    |Brake 0 Pin Source Select (M45xD/M45xC Only)
 * |        |          |For PWM0 setting:
 * |        |          |0 = Brake 0 pin source come from PWM0_BRAKE0.
 * |        |          |1 = Brake 0 pin source come from PWM1_BRAKE0.
 * |        |          |For PWM1 setting:
 * |        |          |0 = Brake 0 pin source come from PWM1_BRAKE0.
 * |        |          |1 = Brake 0 pin source come from PWM0_BRAKE0.
 * |[24]    |BK1SRC    |Brake 1 Pin Source Select (M45xD/M45xC Only)
 * |        |          |For PWM0 setting:
 * |        |          |0 = Brake 1 pin source come from PWM0_BRAKE1.
 * |        |          |1 = Brake 1 pin source come from PWM1_BRAKE1.
 * |        |          |For PWM1 setting:
 * |        |          |0 = Brake 1 pin source come from PWM1_BRAKE1.
 * |        |          |1 = Brake 1 pin source come from PWM0_BRAKE1.
 * @var PWM_T::FAILBRK
 * Offset: 0xC4  PWM System Fail Brake Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |CSSBRKEN  |Clock Security System Detection Trigger PWM Brake Function 0 Enable
 * |        |          |0 = Brake Function triggered by CSS detection Disabled.
 * |        |          |1 = Brake Function triggered by CSS detection Enabled.
 * |[1]     |BODBRKEN  |Brown-Out Detection Trigger PWM Brake Function 0 Enable
 * |        |          |0 = Brake Function triggered by BOD Disabled.
 * |        |          |1 = Brake Function triggered by BOD Enabled.
 * |[2]     |RAMBRKEN  |SRAM Parity Error Detection Trigger PWM Brake Function 0 Enable
 * |        |          |0 = Brake Function triggered by SRAM parity error detection Disabled.
 * |        |          |1 = Brake Function triggered by SRAM parity error detection Enabled.
 * |[3]     |CORBRKEN  |Core Lockup Detection Trigger PWM Brake Function 0 Enable
 * |        |          |0 = Brake Function triggered by Core lockup detection Disabled.
 * |        |          |1 = Brake Function triggered by Core lockup detection Enabled.
 * @var PWM_T::BRKCTL0_1
 * Offset: 0xC8  PWM Brake Edge Detect Control Register 0
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |CPO0EBEN  |Enable ACMP0_O Digital Output As Edge-Detect Brake Source (Write Protect)
 * |        |          |0 = ACMP0_O as edge-detect brake source Disabled.
 * |        |          |1 = ACMP0_O as edge-detect brake source Enabled.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[1]     |CPO1EBEN  |Enable ACMP1_O Digital Output As Edge-Detect Brake Source (Write Protect)
 * |        |          |0 = ACMP1_O as edge-detect brake source Disabled.
 * |        |          |1 = ACMP1_O as edge-detect brake source Enabled.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[4]     |BRKP0EEN  |Enable PWMx_BRAKE0 Pin As Edge-Detect Brake Source (Write Protect)
 * |        |          |0 = BKP0 pin as edge-detect brake source Disabled.
 * |        |          |1 = BKP0 pin as edge-detect brake source Enabled.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[5]     |BRKP1EEN  |Enable PWMx_BRAKE1 Pin As Edge-Detect Brake Source (Write Protect)
 * |        |          |0 = BKP1 pin as edge-detect brake source Disabled.
 * |        |          |1 = BKP1 pin as edge-detect brake source Enabled.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[7]     |SYSEBEN   |Enable System Fail As Edge-Detect Brake Source (Write Protect)
 * |        |          |0 = System Fail condition as edge-detect brake source Disabled.
 * |        |          |1 = System Fail condition as edge-detect brake source Enabled.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[8]     |CPO0LBEN  |Enable ACMP0_O Digital Output As Level-Detect Brake Source (Write Protect)
 * |        |          |0 = ACMP0_O as level-detect brake source Disabled.
 * |        |          |1 = ACMP0_O as level-detect brake source Enabled.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[9]     |CPO1LBEN  |Enable ACMP1_O Digital Output As Level-Detect Brake Source (Write Protect)
 * |        |          |0 = ACMP1_O as level-detect brake source Disabled.
 * |        |          |1 = ACMP1_O as level-detect brake source Enabled.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[12]    |BRKP0LEN  |Enable BKP0 Pin As Level-Detect Brake Source (Write Protect)
 * |        |          |0 = PWMx_BRAKE0 pin as level-detect brake source Disabled.
 * |        |          |1 = PWMx_BRAKE0 pin as level-detect brake source Enabled.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[13]    |BRKP1LEN  |Enable BKP1 Pin As Level-Detect Brake Source (Write Protect)
 * |        |          |0 = PWMx_BRAKE1 pin as level-detect brake source Disabled.
 * |        |          |1 = PWMx_BRAKE1 pin as level-detect brake source Enabled.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[15]    |SYSLBEN   |Enable System Fail As Level-Detect Brake Source (Write Protect)
 * |        |          |0 = System Fail condition as level-detect brake source Disabled.
 * |        |          |1 = System Fail condition as level-detect brake source Enabled.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[17:16] |BRKAEVEN  |PWM Brake Action Select For Even Channel (Write Protect)
 * |        |          |00 = PWM even channel level-detect brake function not affect channel output.
 * |        |          |01 = PWM even channel output tri-state when level-detect brake happened.
 * |        |          |10 = PWM even channel output low level when level-detect brake happened.
 * |        |          |11 = PWM even channel output high level when level-detect brake happened.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[19:18] |BRKAODD   |PWM Brake Action Select For Odd Channel (Write Protect)
 * |        |          |00 = PWM odd channel level-detect brake function not affect channel output.
 * |        |          |01 = PWM odd channel output tri-state when level-detect brake happened.
 * |        |          |10 = PWM odd channel output low level when level-detect brake happened.
 * |        |          |11 = PWM odd channel output high level when level-detect brake happened.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * @var PWM_T::BRKCTL2_3
 * Offset: 0xCC  PWM Brake Edge Detect Control Register 2
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |CPO0EBEN  |Enable ACMP0_O Digital Output As Edge-Detect Brake Source (Write Protect)
 * |        |          |0 = ACMP0_O as edge-detect brake source Disabled.
 * |        |          |1 = ACMP0_O as edge-detect brake source Enabled.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[1]     |CPO1EBEN  |Enable ACMP1_O Digital Output As Edge-Detect Brake Source (Write Protect)
 * |        |          |0 = ACMP1_O as edge-detect brake source Disabled.
 * |        |          |1 = ACMP1_O as edge-detect brake source Enabled.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[4]     |BRKP0EEN  |Enable PWMx_BRAKE0 Pin As Edge-Detect Brake Source (Write Protect)
 * |        |          |0 = BKP0 pin as edge-detect brake source Disabled.
 * |        |          |1 = BKP0 pin as edge-detect brake source Enabled.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[5]     |BRKP1EEN  |Enable PWMx_BRAKE1 Pin As Edge-Detect Brake Source (Write Protect)
 * |        |          |0 = BKP1 pin as edge-detect brake source Disabled.
 * |        |          |1 = BKP1 pin as edge-detect brake source Enabled.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[7]     |SYSEBEN   |Enable System Fail As Edge-Detect Brake Source (Write Protect)
 * |        |          |0 = System Fail condition as edge-detect brake source Disabled.
 * |        |          |1 = System Fail condition as edge-detect brake source Enabled.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[8]     |CPO0LBEN  |Enable ACMP0_O Digital Output As Level-Detect Brake Source (Write Protect)
 * |        |          |0 = ACMP0_O as level-detect brake source Disabled.
 * |        |          |1 = ACMP0_O as level-detect brake source Enabled.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[9]     |CPO1LBEN  |Enable ACMP1_O Digital Output As Level-Detect Brake Source (Write Protect)
 * |        |          |0 = ACMP1_O as level-detect brake source Disabled.
 * |        |          |1 = ACMP1_O as level-detect brake source Enabled.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[12]    |BRKP0LEN  |Enable BKP0 Pin As Level-Detect Brake Source (Write Protect)
 * |        |          |0 = PWMx_BRAKE0 pin as level-detect brake source Disabled.
 * |        |          |1 = PWMx_BRAKE0 pin as level-detect brake source Enabled.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[13]    |BRKP1LEN  |Enable BKP1 Pin As Level-Detect Brake Source (Write Protect)
 * |        |          |0 = PWMx_BRAKE1 pin as level-detect brake source Disabled.
 * |        |          |1 = PWMx_BRAKE1 pin as level-detect brake source Enabled.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[15]    |SYSLBEN   |Enable System Fail As Level-Detect Brake Source (Write Protect)
 * |        |          |0 = System Fail condition as level-detect brake source Disabled.
 * |        |          |1 = System Fail condition as level-detect brake source Enabled.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[17:16] |BRKAEVEN  |PWM Brake Action Select For Even Channel (Write Protect)
 * |        |          |00 = PWM even channel level-detect brake function not affect channel output.
 * |        |          |01 = PWM even channel output tri-state when level-detect brake happened.
 * |        |          |10 = PWM even channel output low level when level-detect brake happened.
 * |        |          |11 = PWM even channel output high level when level-detect brake happened.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[19:18] |BRKAODD   |PWM Brake Action Select For Odd Channel (Write Protect)
 * |        |          |00 = PWM odd channel level-detect brake function not affect channel output.
 * |        |          |01 = PWM odd channel output tri-state when level-detect brake happened.
 * |        |          |10 = PWM odd channel output low level when level-detect brake happened.
 * |        |          |11 = PWM odd channel output high level when level-detect brake happened.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * @var PWM_T::BRKCTL4_5
 * Offset: 0xD0  PWM Brake Edge Detect Control Register 4
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |CPO0EBEN  |Enable ACMP0_O Digital Output As Edge-Detect Brake Source (Write Protect)
 * |        |          |0 = ACMP0_O as edge-detect brake source Disabled.
 * |        |          |1 = ACMP0_O as edge-detect brake source Enabled.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[1]     |CPO1EBEN  |Enable ACMP1_O Digital Output As Edge-Detect Brake Source (Write Protect)
 * |        |          |0 = ACMP1_O as edge-detect brake source Disabled.
 * |        |          |1 = ACMP1_O as edge-detect brake source Enabled.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[4]     |BRKP0EEN  |Enable PWMx_BRAKE0 Pin As Edge-Detect Brake Source (Write Protect)
 * |        |          |0 = BKP0 pin as edge-detect brake source Disabled.
 * |        |          |1 = BKP0 pin as edge-detect brake source Enabled.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[5]     |BRKP1EEN  |Enable PWMx_BRAKE1 Pin As Edge-Detect Brake Source (Write Protect)
 * |        |          |0 = BKP1 pin as edge-detect brake source Disabled.
 * |        |          |1 = BKP1 pin as edge-detect brake source Enabled.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[7]     |SYSEBEN   |Enable System Fail As Edge-Detect Brake Source (Write Protect)
 * |        |          |0 = System Fail condition as edge-detect brake source Disabled.
 * |        |          |1 = System Fail condition as edge-detect brake source Enabled.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[8]     |CPO0LBEN  |Enable ACMP0_O Digital Output As Level-Detect Brake Source (Write Protect)
 * |        |          |0 = ACMP0_O as level-detect brake source Disabled.
 * |        |          |1 = ACMP0_O as level-detect brake source Enabled.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[9]     |CPO1LBEN  |Enable ACMP1_O Digital Output As Level-Detect Brake Source (Write Protect)
 * |        |          |0 = ACMP1_O as level-detect brake source Disabled.
 * |        |          |1 = ACMP1_O as level-detect brake source Enabled.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[12]    |BRKP0LEN  |Enable BKP0 Pin As Level-Detect Brake Source (Write Protect)
 * |        |          |0 = PWMx_BRAKE0 pin as level-detect brake source Disabled.
 * |        |          |1 = PWMx_BRAKE0 pin as level-detect brake source Enabled.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[13]    |BRKP1LEN  |Enable BKP1 Pin As Level-Detect Brake Source (Write Protect)
 * |        |          |0 = PWMx_BRAKE1 pin as level-detect brake source Disabled.
 * |        |          |1 = PWMx_BRAKE1 pin as level-detect brake source Enabled.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[15]    |SYSLBEN   |Enable System Fail As Level-Detect Brake Source (Write Protect)
 * |        |          |0 = System Fail condition as level-detect brake source Disabled.
 * |        |          |1 = System Fail condition as level-detect brake source Enabled.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[17:16] |BRKAEVEN  |PWM Brake Action Select For Even Channel (Write Protect)
 * |        |          |00 = PWM even channel level-detect brake function not affect channel output.
 * |        |          |01 = PWM even channel output tri-state when level-detect brake happened.
 * |        |          |10 = PWM even channel output low level when level-detect brake happened.
 * |        |          |11 = PWM even channel output high level when level-detect brake happened.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[19:18] |BRKAODD   |PWM Brake Action Select For Odd Channel (Write Protect)
 * |        |          |00 = PWM odd channel level-detect brake function not affect channel output.
 * |        |          |01 = PWM odd channel output tri-state when level-detect brake happened.
 * |        |          |10 = PWM odd channel output low level when level-detect brake happened.
 * |        |          |11 = PWM odd channel output high level when level-detect brake happened.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * @var PWM_T::POLCTL
 * Offset: 0xD4  PWM Pin Polar Inverse Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[5:0]   |PINVn     |PWM PIN Polar Inverse Control
 * |        |          |The register controls polarity state of PWM output.
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |        |          |0 = PWM output polar inverse Disabled.
 * |        |          |1 = PWM output polar inverse Enabled.
 * @var PWM_T::POEN
 * Offset: 0xD8  PWM Output Enable Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[5:0]   |POENn     |PWM Pin Output Enable
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |        |          |0 = PWM pin at tri-state.
 * |        |          |1 = PWM pin in output mode.
 * @var PWM_T::SWBRK
 * Offset: 0xDC  PWM Software Brake Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[2:0]   |BRKETRGn  |PWM Edge Brake Software Trigger (Write Only) (Write Protect) (M45xD/M45xC Only)
 * |        |          |Each bit n controls the corresponding PWM pair n.
 * |        |          |Write 1 to this bit will trigger edge brake, and set BRKEIFn to 1 in PWM_INTSTS1 register.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[10:8]  |BRKLTRGn  |PWM Level Brake Software Trigger (Write Only) (Write Protect)
 * |        |          |Each bit n controls the corresponding PWM pair n.
 * |        |          |Write 1 to this bit will trigger level brake, and set BRKLIFn to 1 in PWM_INTSTS1 register.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * @var PWM_T::INTEN0
 * Offset: 0xE0  PWM Interrupt Enable Register 0
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[5:0]   |ZIENn     |PWM Zero Point Interrupt Enable
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |        |          |0 = Zero point interrupt Disabled.
 * |        |          |1 = Zero point interrupt Enabled.
 * |        |          |Note: Odd channels will read always 0 at complementary mode.
 * |[7]     |IFAIEN0_1 |PWM_CH0/1 Interrupt Flag Accumulator Interrupt Enable
 * |        |          |0 = Interrupt Flag accumulator interrupt Disabled.
 * |        |          |1 = Interrupt Flag accumulator interrupt Enabled.
 * |[13:8]  |PIENn     |PWM Period Point Interrupt Enable
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |        |          |0 = Period point interrupt Disabled.
 * |        |          |1 = Period point interrupt Enabled.
 * |        |          |Note1: When up-down counter type period point means center point.
 * |        |          |Note2: Odd channels will read always 0 at complementary mode.
 * |[15]    |IFAIEN2_3 |PWM_CH2/3 Interrupt Flag Accumulator Interrupt Enable
 * |        |          |0 = Interrupt Flag accumulator interrupt Disabled.
 * |        |          |1 = Interrupt Flag accumulator interrupt Enabled.
 * |[21:16] |CMPUIENn  |PWM Compare Up Count Interrupt Enable
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |        |          |0 = Compare up count interrupt Disabled.
 * |        |          |1 = Compare up count interrupt Enabled.
 * |        |          |Note: In complementary mode, CMPUIEN1, 3, 5 use as another CMPUIEN for channel 0, 2, 4.
 * |[23]    |IFAIEN4_5 |PWM_CH4/5 Interrupt Flag Accumulator Interrupt Enable
 * |        |          |0 = Interrupt Flag accumulator interrupt Disabled.
 * |        |          |1 = Interrupt Flag accumulator interrupt Enabled.
 * |[29:24] |CMPDIENn  |PWM Compare Down Count Interrupt Enable
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |        |          |0 = Compare down count interrupt Disabled.
 * |        |          |1 = Compare down count interrupt Enabled.
 * |        |          |Note: In complementary mode, CMPDIEN1, 3, 5 use as another CMPDIEN for channel 0, 2, 4.
 * @var PWM_T::INTEN1
 * Offset: 0xE4  PWM Interrupt Enable Register 1
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |BRKEIEN0_1|PWM Edge-Detect Brake Interrupt Enable For Channel0/1 (Write Protect)
 * |        |          |0 = Edge-detect Brake interrupt for channel0/1 Disabled.
 * |        |          |1 = Edge-detect Brake interrupt for channel0/1 Enabled.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[1]     |BRKEIEN2_3|PWM Edge-Detect Brake Interrupt Enable For Channel2/3 (Write Protect)
 * |        |          |0 = Edge-detect Brake interrupt for channel2/3 Disabled.
 * |        |          |1 = Edge-detect Brake interrupt for channel2/3 Enabled.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[2]     |BRKEIEN4_5|PWM Edge-Detect Brake Interrupt Enable For Channel4/5 (Write Protect)
 * |        |          |0 = Edge-detect Brake interrupt for channel4/5 Disabled.
 * |        |          |1 = Edge-detect Brake interrupt for channel4/5 Enabled.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[8]     |BRKLIEN0_1|PWM Level-Detect Brake Interrupt Enable For Channel0/1 (Write Protect)
 * |        |          |0 = Level-detect Brake interrupt for channel0/1 Disabled.
 * |        |          |1 = Level-detect Brake interrupt for channel0/1 Enabled.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[9]     |BRKLIEN2_3|PWM Level-Detect Brake Interrupt Enable For Channel2/3 (Write Protect)
 * |        |          |0 = Level-detect Brake interrupt for channel2/3 Disabled.
 * |        |          |1 = Level-detect Brake interrupt for channel2/3 Enabled.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[10]    |BRKLIEN4_5|PWM Level-Detect Brake Interrupt Enable For Channel4/5 (Write Protect)
 * |        |          |0 = Level-detect Brake interrupt for channel4/5 Disabled.
 * |        |          |1 = Level-detect Brake interrupt for channel4/5 Enabled.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * @var PWM_T::INTSTS0
 * Offset: 0xE8  PWM Interrupt Flag Register 0
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[5:0]   |ZIFn      |PWM Zero Point Interrupt Flag
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |        |          |This bit is set by hardware when PWM counter reaches zero, software can write 1 to clear this bit to zero.
 * |[7]     |IFAIF0_1  |PWM_CH0/1 Interrupt Flag Accumulator Interrupt Flag
 * |        |          |Flag is set by hardware when condition match IFSEL0_1 in PWM_IFA register, software can clear this bit by writing 1 to it.
 * |[13:8]  |PIFn      |PWM Period Point Interrupt Flag
 * |        |          |This bit is set by hardware when PWM counter reaches PWM_PERIODn, software can write 1 to clear this bit to zero.
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |[15]    |IFAIF2_3  |PWM_CH2/3 Interrupt Flag Accumulator Interrupt Flag
 * |        |          |Flag is set by hardware when condition match IFSEL2_3 in PWM_IFA register, software can clear this bit by writing 1 to it.
 * |[21:16] |CMPUIFn   |PWM Compare Up Count Interrupt Flag
 * |        |          |Flag is set by hardware when PWM counter up count and reaches PWM_CMPDATn, software can clear this bit by writing 1 to it.
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |        |          |Note1: If CMPDAT equal to PERIOD, this flag is not working in up counter type selection.
 * |        |          |Note2: In complementary mode, CMPUIF1, 3, 5 use as another CMPUIF for channel 0, 2, 4.
 * |[23]    |IFAIF4_5  |PWM_CH4/5 Interrupt Flag Accumulator Interrupt Flag
 * |        |          |Flag is set by hardware when condition match IFSEL4_5 in PWM_IFA register, software can clear this bit by writing 1 to it.
 * |[29:24] |CMPDIFn   |PWM Compare Down Count Interrupt Flag
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |        |          |Flag is set by hardware when PWM counter down count and reaches PWM_CMPDATn, software can clear this bit by writing 1 to it.
 * |        |          |Note1: If CMPDAT equal to PERIOD, this flag is not working in down counter type selection.
 * |        |          |Note2: In complementary mode, CMPDIF1, 3, 5 use as another CMPDIF for channel 0, 2, 4.
 * @var PWM_T::INTSTS1
 * Offset: 0xEC  PWM Interrupt Flag Register 1
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |BRKEIF0   |PWM Channel0 Edge-Detect Brake Interrupt Flag (Write Protect)
 * |        |          |0 = PWM channel0 edge-detect brake event do not happened.
 * |        |          |1 = When PWM channel0 edge-detect brake event happened, this bit is set to 1, writing 1 to clear.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[1]     |BRKEIF1   |PWM Channel1 Edge-Detect Brake Interrupt Flag (Write Protect)
 * |        |          |0 = PWM channel1 edge-detect brake event do not happened.
 * |        |          |1 = When PWM channel1 edge-detect brake event happened, this bit is set to 1, writing 1 to clear.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[2]     |BRKEIF2   |PWM Channel2 Edge-Detect Brake Interrupt Flag (Write Protect)
 * |        |          |0 = PWM channel2 edge-detect brake event do not happened.
 * |        |          |1 = When PWM channel2 edge-detect brake event happened, this bit is set to 1, writing 1 to clear.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[3]     |BRKEIF3   |PWM Channel3 Edge-Detect Brake Interrupt Flag (Write Protect)
 * |        |          |0 = PWM channel3 edge-detect brake event do not happened.
 * |        |          |1 = When PWM channel3 edge-detect brake event happened, this bit is set to 1, writing 1 to clear.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[4]     |BRKEIF4   |PWM Channel4 Edge-Detect Brake Interrupt Flag (Write Protect)
 * |        |          |0 = PWM channel4 edge-detect brake event do not happened.
 * |        |          |1 = When PWM channel4 edge-detect brake event happened, this bit is set to 1, writing 1 to clear.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[5]     |BRKEIF5   |PWM Channel5 Edge-Detect Brake Interrupt Flag (Write Protect)
 * |        |          |0 = PWM channel5 edge-detect brake event do not happened.
 * |        |          |1 = When PWM channel5 edge-detect brake event happened, this bit is set to 1, writing 1 to clear.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[8]     |BRKLIF0   |PWM Channel0 Level-Detect Brake Interrupt Flag (Write Protect)
 * |        |          |0 = PWM channel0 level-detect brake event do not happened.
 * |        |          |1 = When PWM channel0 level-detect brake event happened, this bit is set to 1, writing 1 to clear.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[9]     |BRKLIF1   |PWM Channel1 Level-Detect Brake Interrupt Flag (Write Protect)
 * |        |          |0 = PWM channel1 level-detect brake event do not happened.
 * |        |          |1 = When PWM channel1 level-detect brake event happened, this bit is set to 1, writing 1 to clear.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[10]    |BRKLIF2   |PWM Channel2 Level-Detect Brake Interrupt Flag (Write Protect)
 * |        |          |0 = PWM channel2 level-detect brake event do not happened.
 * |        |          |1 = When PWM channel2 level-detect brake event happened, this bit is set to 1, writing 1 to clear.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[11]    |BRKLIF3   |PWM Channel3 Level-Detect Brake Interrupt Flag (Write Protect)
 * |        |          |0 = PWM channel3 level-detect brake event do not happened.
 * |        |          |1 = When PWM channel3 level-detect brake event happened, this bit is set to 1, writing 1 to clear.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[12]    |BRKLIF4   |PWM Channel4 Level-Detect Brake Interrupt Flag (Write Protect)
 * |        |          |0 = PWM channel4 level-detect brake event do not happened.
 * |        |          |1 = When PWM channel4 level-detect brake event happened, this bit is set to 1, writing 1 to clear.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[13]    |BRKLIF5   |PWM Channel5 Level-Detect Brake Interrupt Flag (Write Protect)
 * |        |          |0 = PWM channel5 level-detect brake event do not happened.
 * |        |          |1 = When PWM channel5 level-detect brake event happened, this bit is set to 1, writing 1 to clear.
 * |        |          |Note: This register is write protected. Refer to SYS_REGLCTL register.
 * |[16]    |BRKESTS0  |PWM Channel0 Edge-Detect Brake Status
 * |        |          |0 = PWM channel0 edge-detect brake state is released.
 * |        |          |1 = When PWM channel0 edge-detect brake detects a falling edge of any enabled brake source; this flag will be set to indicate the PWM channel0 at brake state, writing 1 to clear.
 * |[17]    |BRKESTS1  |PWM Channel1 Edge-Detect Brake Status
 * |        |          |0 = PWM channel1 edge-detect brake state is released.
 * |        |          |1 = When PWM channel1 edge-detect brake detects a falling edge of any enabled brake source; this flag will be set to indicate the PWM channel1 at brake state, writing 1 to clear.
 * |[18]    |BRKESTS2  |PWM Channel2 Edge-Detect Brake Status
 * |        |          |0 = PWM channel2 edge-detect brake state is released.
 * |        |          |1 = When PWM channel2 edge-detect brake detects a falling edge of any enabled brake source; this flag will be set to indicate the PWM channel2 at brake state, writing 1 to clear.
 * |[19]    |BRKESTS3  |PWM Channel3 Edge-Detect Brake Status
 * |        |          |0 = PWM channel3 edge-detect brake state is released.
 * |        |          |1 = When PWM channel3 edge-detect brake detects a falling edge of any enabled brake source; this flag will be set to indicate the PWM channel3 at brake state, writing 1 to clear.
 * |[20]    |BRKESTS4  |PWM Channel4 Edge-Detect Brake Status
 * |        |          |0 = PWM channel4 edge-detect brake state is released.
 * |        |          |1 = When PWM channel4 edge-detect brake detects a falling edge of any enabled brake source; this flag will be set to indicate the PWM channel4 at brake state, writing 1 to clear.
 * |[21]    |BRKESTS5  |PWM Channel5 Edge-Detect Brake Status
 * |        |          |0 = PWM channel5 edge-detect brake state is released.
 * |        |          |1 = When PWM channel5 edge-detect brake detects a falling edge of any enabled brake source; this flag will be set to indicate the PWM channel5 at brake state, writing 1 to clear.
 * |[24]    |BRKLSTS0  |PWM Channel0 Level-Detect Brake Status (Read Only)
 * |        |          |0 = PWM channel0 level-detect brake state is released.
 * |        |          |1 = When PWM channel0 level-detect brake detects a falling edge of any enabled brake source; this flag will be set to indicate the PWM channel0 at brake state.
 * |        |          |Note: This bit is read only and auto cleared by hardware.
 * |        |          |When enabled brake source return to high level, PWM will release brake state until current PWM period finished.
 * |        |          |The PWM waveform will start output from next full PWM period.
 * |[25]    |BRKLSTS1  |PWM Channel1 Level-Detect Brake Status (Read Only)
 * |        |          |0 = PWM channel1 level-detect brake state is released.
 * |        |          |1 = When PWM channel1 level-detect brake detects a falling edge of any enabled brake source; this flag will be set to indicate the PWM channel1 at brake state.
 * |        |          |Note: This bit is read only and auto cleared by hardware.
 * |        |          |When enabled brake source return to high level, PWM will release brake state until current PWM period finished.
 * |        |          |The PWM waveform will start output from next full PWM period.
 * |[26]    |BRKLSTS2  |PWM Channel2 Level-Detect Brake Status (Read Only)
 * |        |          |0 = PWM channel2 level-detect brake state is released.
 * |        |          |1 = When PWM channel2 level-detect brake detects a falling edge of any enabled brake source; this flag will be set to indicate the PWM channel2 at brake state.
 * |        |          |Note: This bit is read only and auto cleared by hardware.
 * |        |          |When enabled brake source return to high level, PWM will release brake state until current PWM period finished.
 * |        |          |The PWM waveform will start output from next full PWM period.
 * |[27]    |BRKLSTS3  |PWM Channel3 Level-Detect Brake Status (Read Only)
 * |        |          |0 = PWM channel3 level-detect brake state is released.
 * |        |          |1 = When PWM channel3 level-detect brake detects a falling edge of any enabled brake source; this flag will be set to indicate the PWM channel3 at brake state.
 * |        |          |Note: This bit is read only and auto cleared by hardware.
 * |        |          |When enabled brake source return to high level, PWM will release brake state until current PWM period finished.
 * |        |          |The PWM waveform will start output from next full PWM period.
 * |[28]    |BRKLSTS4  |PWM Channel4 Level-Detect Brake Status (Read Only)
 * |        |          |0 = PWM channel4 level-detect brake state is released.
 * |        |          |1 = When PWM channel4 level-detect brake detects a falling edge of any enabled brake source; this flag will be set to indicate the PWM channel4 at brake state.
 * |        |          |Note: This bit is read only and auto cleared by hardware.
 * |        |          |When enabled brake source return to high level, PWM will release brake state until current PWM period finished.
 * |        |          |The PWM waveform will start output from next full PWM period.
 * |[29]    |BRKLSTS5  |PWM Channel5 Level-Detect Brake Status (Read Only)
 * |        |          |0 = PWM channel5 level-detect brake state is released.
 * |        |          |1 = When PWM channel5 level-detect brake detects a falling edge of any enabled brake source; this flag will be set to indicate the PWM channel5 at brake state.
 * |        |          |Note: This bit is read only and auto cleared by hardware.
 * |        |          |When enabled brake source return to high level, PWM will release brake state until current PWM period finished.
 * |        |          |The PWM waveform will start output from next full PWM period.
 * @var PWM_T::IFA
 * Offset: 0xF0  PWM Interrupt Flag Accumulator Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[3:0]   |IFCNT0_1  |PWM_CH0 And PWM_CH1 Interrupt Flag Counter
 * |        |          |The register sets the count number which defines how many times of PWM_CH0 and PWM_CH1 period occurs to set bit IFAIF0_1 to request the PWM period interrupt.
 * |        |          |PWM flag will be set in every IFCNT0_1 [3:0] times of PWM period.
 * |[6:4]   |IFSEL0_1  |PWM_CH0 And PWM_CH1 Interrupt Flag Accumulator Source Select
 * |        |          |000 = CNT equal to Zero in channel 0.
 * |        |          |001 = CNT equal to PERIOD in channel 0.
 * |        |          |010 = CNT equal to CMPU in channel 0.
 * |        |          |011 = CNT equal to CMPD in channel 0.
 * |        |          |100 = CNT equal to Zero in channel 1.
 * |        |          |101 = CNT equal to PERIOD in channel 1.
 * |        |          |110 = CNT equal to CMPU in channel 1.
 * |        |          |111 = CNT equal to CMPD in channel 1.
 * |[7]     |IFAEN0_1  |PWM_CH0 And PWM_CH1 Interrupt Flag Accumulator Enable
 * |        |          |0 = PWM_CH0 and PWM_CH1 interrupt flag accumulator disable.
 * |        |          |1 = PWM_CH0 and PWM_CH1 interrupt flag accumulator enable.
 * |[11:8]  |IFCNT2_3  |PWM_CH2 And PWM_CH3 Interrupt Flag Counter
 * |        |          |The register sets the count number which defines how many times of PWM_CH2 and PWM_CH3 period occurs to set bit IFAIF2_3 to request the PWM period interrupt.
 * |        |          |PWM flag will be set in every IFCNT2_3[3:0] times of PWM period.
 * |[14:12] |IFSEL2_3  |PWM_CH2 And PWM_CH3 Interrupt Flag Accumulator Source Select
 * |        |          |000 = CNT equal to Zero in channel 2.
 * |        |          |001 = CNT equal to PERIOD in channel 2.
 * |        |          |010 = CNT equal to CMPU in channel 2.
 * |        |          |011 = CNT equal to CMPD in channel 2.
 * |        |          |100 = CNT equal to Zero in channel 3.
 * |        |          |101 = CNT equal to PERIOD in channel 3.
 * |        |          |110 = CNT equal to CMPU in channel 3.
 * |        |          |111 = CNT equal to CMPD in channel 3.
 * |[15]    |IFAEN2_3  |PWM_CH2 And PWM_CH3 Interrupt Flag Accumulator Enable
 * |        |          |0 = PWM_CH2 and PWM_CH3 interrupt flag accumulator disable.
 * |        |          |1 = PWM_CH2 and PWM_CH3 interrupt flag accumulator enable.
 * |[19:16] |IFCNT4_5  |PWM_CH4 And PWM_CH5 Interrupt Flag Counter
 * |        |          |The register sets the count number which defines how many times of PWM_CH4 and PWM_CH5 period occurs to set bit IFAIF4_5 to request the PWM period interrupt.
 * |        |          |PWM flag will be set in every IFCNT4_5[3:0] times of PWM period.
 * |[22:20] |IFSEL4_5  |PWM_CH4 And PWM_CH5 Interrupt Flag Accumulator Source Select
 * |        |          |000 = CNT equal to Zero in channel 4.
 * |        |          |001 = CNT equal to PERIOD in channel 4.
 * |        |          |010 = CNT equal to CMPU in channel 4.
 * |        |          |011 = CNT equal to CMPD in channel 4.
 * |        |          |100 = CNT equal to Zero in channel 5.
 * |        |          |101 = CNT equal to PERIOD in channel 5.
 * |        |          |110 = CNT equal to CMPU in channel 5.
 * |        |          |111 = CNT equal to CMPD in channel 5.
 * |[23]    |IFAEN4_5  |PWM_CH4 And PWM_CH5 Interrupt Flag Accumulator Enable
 * |        |          |0 = PWM_CH4 and PWM_CH5 interrupt flag accumulator disable.
 * |        |          |1 = PWM_CH4 and PWM_CH5 interrupt flag accumulator enable.
 * @var PWM_T::DACTRGEN
 * Offset: 0xF4  PWM Trigger DAC Enable Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[5:0]   |ZTEn      |PWM Zero Point Trigger DAC Enable
 * |        |          |0 = PWM period point trigger DAC function Disabled.
 * |        |          |1 = PWM period point trigger DAC function Enabled.
 * |        |          |PWM can trigger EADC/DAC/DMA to start action when PWM counter down count to zero if this bit is set to 1.
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |[13:8]  |PTEn      |PWM Period Point Trigger DAC Enable
 * |        |          |0 = PWM period point trigger DAC function Disabled.
 * |        |          |1 = PWM period point trigger DAC function Enabled.
 * |        |          |PWM can trigger DAC to start action when PWM counter up count to (PERIODn+1) if this bit is set to 1.
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |[21:16] |CUTRGEn   |PWM Compare Up Count Point Trigger DAC Enable
 * |        |          |0 = PWM Compare Up point trigger DAC function Disabled.
 * |        |          |1 = PWM Compare Up point trigger DAC function Enabled.
 * |        |          |PWM can trigger DAC to start action when PWM counter up count to CMPDAT if this bit is set to 1.
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |        |          |Note1: This bit should keep at 0 when PWM counter operating in down counter type.
 * |        |          |Note2: In complementary mode, CUTRGE1, 3, 5 use as another CUTRGE for channel 0, 2, 4.
 * |[29:24] |CDTRGEn   |PWM Compare Down Count Point Trigger DAC Enable
 * |        |          |0 = PWM Compare Down count point trigger DAC function Disabled.
 * |        |          |1 = PWM Compare Down count point trigger DAC function Enabled.
 * |        |          |PWM can trigger DAC to start action when PWM counter down count to CMPDAT if this bit is set to 1.
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |        |          |Note1: This bit should keep at 0 when PWM counter operating in up counter type.
 * |        |          |Note2: In complementary mode, CDTRGE1, 3, 5 use as another CDTRGE for channel 0, 2, 4.
 * @var PWM_T::EADCTS0
 * Offset: 0xF8  PWM Trigger EADC Source Select Register 0
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[3:0]   |TRGSEL0   |PWM_CH0 Trigger EADC Source Select
 * |        |          |0000 = PWM_CH0 zero point.
 * |        |          |0001 = PWM_CH0 period point.
 * |        |          |0010 = PWM_CH0 zero or period point.
 * |        |          |0011 = PWM_CH0 up-count CMPDAT point.
 * |        |          |0100 = PWM_CH0 down-count CMPDAT point.
 * |        |          |0101 = PWM_CH1 zero point.
 * |        |          |0110 = PWM_CH1 period point.
 * |        |          |0111 = PWM_CH1 zero or period point.
 * |        |          |1000 = PWM_CH1 up-count CMPDAT point.
 * |        |          |1001 = PWM_CH1 down-count CMPDAT point.
 * |        |          |1010 = PWM_CH0 up-count free CMPDAT point.
 * |        |          |1011 = PWM_CH0 down-count free CMPDAT point.
 * |        |          |1100 = PWM_CH2 up-count free CMPDAT point.
 * |        |          |1101 = PWM_CH2 down-count free CMPDAT point.
 * |        |          |1110 = PWM_CH4 up-count free CMPDAT point.
 * |        |          |1111 = PWM_CH4 down-count free CMPDAT point.
 * |[7]     |TRGEN0    |PWM_CH0 Trigger EADC enable bit
 * |[11:8]  |TRGSEL1   |PWM_CH1 Trigger EADC Source Select
 * |        |          |0000 = PWM_CH0 zero point.
 * |        |          |0001 = PWM_CH0 period point.
 * |        |          |0010 = PWM_CH0 zero or period point.
 * |        |          |0011 = PWM_CH0 up-count CMPDAT point.
 * |        |          |0100 = PWM_CH0 down-count CMPDAT point.
 * |        |          |0101 = PWM_CH1 zero point.
 * |        |          |0110 = PWM_CH1 period point.
 * |        |          |0111 = PWM_CH1 zero or period point.
 * |        |          |1000 = PWM_CH1 up-count CMPDAT point.
 * |        |          |1001 = PWM_CH1 down-count CMPDAT point.
 * |        |          |1010 = PWM_CH0 up-count free CMPDAT point.
 * |        |          |1011 = PWM_CH0 down-count free CMPDAT point.
 * |        |          |1100 = PWM_CH2 up-count free CMPDAT point.
 * |        |          |1101 = PWM_CH2 down-count free CMPDAT point.
 * |        |          |1110 = PWM_CH4 up-count free CMPDAT point.
 * |        |          |1111 = PWM_CH4 down-count free CMPDAT point.
 * |[15]    |TRGEN1    |PWM_CH1 Trigger EADC enable bit
 * |[19:16] |TRGSEL2   |PWM_CH2 Trigger EADC Source Select
 * |        |          |0000 = PWM_CH2 zero point.
 * |        |          |0001 = PWM_CH2 period point.
 * |        |          |0010 = PWM_CH2 zero or period point.
 * |        |          |0011 = PWM_CH2 up-count CMPDAT point.
 * |        |          |0100 = PWM_CH2 down-count CMPDAT point.
 * |        |          |0101 = PWM_CH3 zero point.
 * |        |          |0110 = PWM_CH3 period point.
 * |        |          |0111 = PWM_CH3 zero or period point.
 * |        |          |1000 = PWM_CH3 up-count CMPDAT point.
 * |        |          |1001 = PWM_CH3 down-count CMPDAT point.
 * |        |          |1010 = PWM_CH0 up-count free CMPDAT point.
 * |        |          |1011 = PWM_CH0 down-count free CMPDAT point.
 * |        |          |1100 = PWM_CH2 up-count free CMPDAT point.
 * |        |          |1101 = PWM_CH2 down-count free CMPDAT point.
 * |        |          |1110 = PWM_CH4 up-count free CMPDAT point.
 * |        |          |1111 = PWM_CH4 down-count free CMPDAT point.
 * |[23]    |TRGEN2    |PWM_CH2 Trigger EADC enable bit
 * |[27:24] |TRGSEL3   |PWM_CH3 Trigger EADC Source Select
 * |        |          |0000 = PWM_CH2 zero point.
 * |        |          |0001 = PWM_CH2 period point.
 * |        |          |0010 = PWM_CH2 zero or period point.
 * |        |          |0011 = PWM_CH2 up-count CMPDAT point.
 * |        |          |0100 = PWM_CH2 down-count CMPDAT point.
 * |        |          |0101 = PWM_CH3 zero point.
 * |        |          |0110 = PWM_CH3 period point.
 * |        |          |0111 = PWM_CH3 zero or period point.
 * |        |          |1000 = PWM_CH3 up-count CMPDAT point.
 * |        |          |1001 = PWM_CH3 down-count CMPDAT point.
 * |        |          |1010 = PWM_CH0 up-count free CMPDAT point.
 * |        |          |1011 = PWM_CH0 down-count free CMPDAT point.
 * |        |          |1100 = PWM_CH2 up-count free CMPDAT point.
 * |        |          |1101 = PWM_CH2 down-count free CMPDAT point.
 * |        |          |1110 = PWM_CH4 up-count free CMPDAT point.
 * |        |          |1111 = PWM_CH4 down-count free CMPDAT point.
 * |[31]    |TRGEN3    |PWM_CH3 Trigger EADC enable bit
 * @var PWM_T::EADCTS1
 * Offset: 0xFC  PWM Trigger EADC Source Select Register 1
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[3:0]   |TRGSEL4   |PWM_CH4 Trigger EADC Source Select
 * |        |          |0000 = PWM_CH4 zero point.
 * |        |          |0001 = PWM_CH4 period point.
 * |        |          |0010 = PWM_CH4 zero or period point.
 * |        |          |0011 = PWM_CH4 up-count CMPDAT point.
 * |        |          |0100 = PWM_CH4 down-count CMPDAT point.
 * |        |          |0101 = PWM_CH5 zero point.
 * |        |          |0110 = PWM_CH5 period point.
 * |        |          |0111 = PWM_CH5 zero or period point.
 * |        |          |1000 = PWM_CH5 up-count CMPDAT point.
 * |        |          |1001 = PWM_CH5 down-count CMPDAT point.
 * |        |          |1010 = PWM_CH0 up-count free CMPDAT point.
 * |        |          |1011 = PWM_CH0 down-count free CMPDAT point.
 * |        |          |1100 = PWM_CH2 up-count free CMPDAT point.
 * |        |          |1101 = PWM_CH2 down-count free CMPDAT point.
 * |        |          |1110 = PWM_CH4 up-count free CMPDAT point.
 * |        |          |1111 = PWM_CH4 down-count free CMPDAT point.
 * |[7]     |TRGEN4    |PWM_CH4 Trigger EADC enable bit
 * |[11:8]  |TRGSEL5   |PWM_CH5 Trigger EADC Source Select
 * |        |          |0000 = PWM_CH4 zero point.
 * |        |          |0001 = PWM_CH4 period point.
 * |        |          |0010 = PWM_CH4 zero or period point.
 * |        |          |0011 = PWM_CH4 up-count CMPDAT point.
 * |        |          |0100 = PWM_CH4 down-count CMPDAT point.
 * |        |          |0101 = PWM_CH5 zero point.
 * |        |          |0110 = PWM_CH5 period point.
 * |        |          |0111 = PWM_CH5 zero or period point.
 * |        |          |1000 = PWM_CH5 up-count CMPDAT point.
 * |        |          |1001 = PWM_CH5 down-count CMPDAT point.
 * |        |          |1010 = PWM_CH0 up-count free CMPDAT point.
 * |        |          |1011 = PWM_CH0 down-count free CMPDAT point.
 * |        |          |1100 = PWM_CH2 up-count free CMPDAT point.
 * |        |          |1101 = PWM_CH2 down-count free CMPDAT point.
 * |        |          |1110 = PWM_CH4 up-count free CMPDAT point.
 * |        |          |1111 = PWM_CH4 down-count free CMPDAT point.
 * |[15]    |TRGEN5    |PWM_CH5 Trigger EADC enable bit
 * @var PWM_T::FTCMPDAT0_1
 * Offset: 0x100  PWM Free Trigger Compare Register 0
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |FTCMP     |PWM Free Trigger Compare Register
 * |        |          |FTCMP use to compare with even CNTR to trigger EADC.
 * |        |          |FTCMPDAT0, 2, 4 corresponding complementary pairs PWM_CH0and PWM_CH1, PWM_CH2 and PWM_CH3, PWM_CH4 and PWM_CH5.
 * @var PWM_T::FTCMPDAT2_3
 * Offset: 0x104  PWM Free Trigger Compare Register 2
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |FTCMP     |PWM Free Trigger Compare Register
 * |        |          |FTCMP use to compare with even CNTR to trigger EADC.
 * |        |          |FTCMPDAT0, 2, 4 corresponding complementary pairs PWM_CH0and PWM_CH1, PWM_CH2 and PWM_CH3, PWM_CH4 and PWM_CH5.
 * @var PWM_T::FTCMPDAT4_5
 * Offset: 0x108  PWM Free Trigger Compare Register 4
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |FTCMP     |PWM Free Trigger Compare Register
 * |        |          |FTCMP use to compare with even CNTR to trigger EADC.
 * |        |          |FTCMPDAT0, 2, 4 corresponding complementary pairs PWM_CH0and PWM_CH1, PWM_CH2 and PWM_CH3, PWM_CH4 and PWM_CH5.
 * @var PWM_T::SSCTL
 * Offset: 0x110  PWM Synchronous Start Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[5:0]   |SSENn     |PWM Synchronous Start Function Enable
 * |        |          |When synchronous start function is enabled, the PWM counter enable register (PWM_CNTEN) can be enabled by writing PWM synchronous start trigger bit (CNTSEN).
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |        |          |0 = PWM synchronous start function Disabled.
 * |        |          |1 = PWM synchronous start function Enabled.
 * @var PWM_T::SSTRG
 * Offset: 0x114  PWM Synchronous Start Trigger Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |CNTSEN    |PWM Counter Synchronous Start Enable (Write Only)
 * |        |          |PMW counter synchronous enable function is used to make selected PWM channels (include PWM0_CHx and PWM1_CHx) start counting at the same time.
 * |        |          |Writing this bit to 1 will also set the counter enable bit (CNTENn, n denotes channel 0 to 5) if correlated PWM channel counter synchronous start function is enabled.
 * |        |          |Note: This bit only present in PWM0_BA.
 * @var PWM_T::STATUS
 * Offset: 0x120  PWM Status Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[5:0]   |CNTMAXFn  |Time-Base Counter Equal To 0xFFFF Latched Flag
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |        |          |0 = indicates the time-base counter never reached its maximum value 0xFFFF.
 * |        |          |1 = indicates the time-base counter reached its maximum value, software can write 1 to clear this bit.
 * |[10:8]  |SYNCINFn  |Input Synchronization Latched Flag
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |        |          |0 = Indicates no SYNC_IN event has occurred.
 * |        |          |1 = Indicates an SYNC_IN event has occurred, software can write 1 to clear this bit.
 * |[21:16] |ADCTRGFn  |EADC Start Of Conversion Flag
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |        |          |0 = Indicates no EADC start of conversion trigger event has occurred.
 * |        |          |1 = Indicates an EADC start of conversion trigger event has occurred, software can write 1 to clear this bit.
 * |[24]    |DACTRGF   |DAC Start Of Conversion Flag
 * |        |          |0 = Indicates no DAC start of conversion trigger event has occurred.
 * |        |          |1 = Indicates an DAC start of conversion trigger event has occurred, software can write 1 to clear this bit
 * @var PWM_T::CAPINEN
 * Offset: 0x200  PWM Capture Input Enable Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[5:0]   |CAPINENn  |Capture Input Enable
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |        |          |0 = PWM Channel capture input path Disabled.
 * |        |          |The input of PWM channel capture function is always regarded as 0.
 * |        |          |1 = PWM Channel capture input path Enabled.
 * |        |          |The input of PWM channel capture function comes from correlative multifunction pin.
 * @var PWM_T::CAPCTL
 * Offset: 0x204  PWM Capture Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[5:0]   |CAPENn    |Capture Function Enable
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |        |          |0 = Capture function Disabled. RCAPDAT/FCAPDAT register will not be updated.
 * |        |          |1 = Capture function Enabled.
 * |        |          |Capture latched the PWM counter value when detected rising or falling edge of input signal and saved to RCAPDAT (Rising latch) and FCAPDAT (Falling latch).
 * |[13:8]  |CAPINVn   |Capture Inverter Enable
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |        |          |0 = Capture source inverter Disabled.
 * |        |          |1 = Capture source inverter Enabled. Reverse the input signal from GPIO.
 * |[21:16] |RCRLDENn  |Rising Capture Reload Enable
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |        |          |0 = Rising capture reload counter Disabled.
 * |        |          |1 = Rising capture reload counter Enabled.
 * |[29:24] |FCRLDENn  |Falling Capture Reload Enable
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |        |          |0 = Falling capture reload counter Disabled.
 * |        |          |1 = Falling capture reload counter Enabled.
 * @var PWM_T::CAPSTS
 * Offset: 0x208  PWM Capture Status Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[5:0]   |CRLIFOVn  |Capture Rising Latch Interrupt Flag Overrun Status (Read Only)
 * |        |          |This flag indicates if rising latch happened when the corresponding CRLIF is 1.
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |        |          |Note: This bit will be cleared automatically when user clear corresponding CRLIF.
 * |[13:8]  |CFLIFOVn  |Capture Falling Latch Interrupt Flag Overrun Status (Read Only)
 * |        |          |This flag indicates if falling latch happened when the corresponding CFLIF is 1.
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |        |          |Note: This bit will be cleared automatically when user clear corresponding CFLIF.
 * @var PWM_T::RCAPDAT0
 * Offset: 0x20C  PWM Rising Capture Data Register 0
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |RCAPDAT   |PWM Rising Capture Data Register (Read Only)
 * |        |          |When rising capture condition happened, the PWM counter value will be saved in this register.
 * @var PWM_T::FCAPDAT0
 * Offset: 0x210  PWM Falling Capture Data Register 0
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |FCAPDAT   |PWM Falling Capture Data Register (Read Only)
 * |        |          |When falling capture condition happened, the PWM counter value will be saved in this register.
 * @var PWM_T::RCAPDAT1
 * Offset: 0x214  PWM Rising Capture Data Register 1
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |RCAPDAT   |PWM Rising Capture Data Register (Read Only)
 * |        |          |When rising capture condition happened, the PWM counter value will be saved in this register.
 * @var PWM_T::FCAPDAT1
 * Offset: 0x218  PWM Falling Capture Data Register 1
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |FCAPDAT   |PWM Falling Capture Data Register (Read Only)
 * |        |          |When falling capture condition happened, the PWM counter value will be saved in this register.
 * @var PWM_T::RCAPDAT2
 * Offset: 0x21C  PWM Rising Capture Data Register 2
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |RCAPDAT   |PWM Rising Capture Data Register (Read Only)
 * |        |          |When rising capture condition happened, the PWM counter value will be saved in this register.
 * @var PWM_T::FCAPDAT2
 * Offset: 0x220  PWM Falling Capture Data Register 2
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |FCAPDAT   |PWM Falling Capture Data Register (Read Only)
 * |        |          |When falling capture condition happened, the PWM counter value will be saved in this register.
 * @var PWM_T::RCAPDAT3
 * Offset: 0x224  PWM Rising Capture Data Register 3
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |RCAPDAT   |PWM Rising Capture Data Register (Read Only)
 * |        |          |When rising capture condition happened, the PWM counter value will be saved in this register.
 * @var PWM_T::FCAPDAT3
 * Offset: 0x228  PWM Falling Capture Data Register 3
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |FCAPDAT   |PWM Falling Capture Data Register (Read Only)
 * |        |          |When falling capture condition happened, the PWM counter value will be saved in this register.
 * @var PWM_T::RCAPDAT4
 * Offset: 0x22C  PWM Rising Capture Data Register 4
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |RCAPDAT   |PWM Rising Capture Data Register (Read Only)
 * |        |          |When rising capture condition happened, the PWM counter value will be saved in this register.
 * @var PWM_T::FCAPDAT4
 * Offset: 0x230  PWM Falling Capture Data Register 4
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |FCAPDAT   |PWM Falling Capture Data Register (Read Only)
 * |        |          |When falling capture condition happened, the PWM counter value will be saved in this register.
 * @var PWM_T::RCAPDAT5
 * Offset: 0x234  PWM Rising Capture Data Register 5
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |RCAPDAT   |PWM Rising Capture Data Register (Read Only)
 * |        |          |When rising capture condition happened, the PWM counter value will be saved in this register.
 * @var PWM_T::FCAPDAT5
 * Offset: 0x238  PWM Falling Capture Data Register 5
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |FCAPDAT   |PWM Falling Capture Data Register (Read Only)
 * |        |          |When falling capture condition happened, the PWM counter value will be saved in this register.
 * @var PWM_T::PDMACTL
 * Offset: 0x23C  PWM PDMA Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |CHEN0_1   |Channel 0/1 PDMA Enable
 * |        |          |0 = Channel 0/1 PDMA function Disabled.
 * |        |          |1 = Channel 0/1 PDMA function Enabled for the channel 0/1 captured data and transfer to memory.
 * |[2:1]   |CAPMOD0_1 |Select PWM_RCAPDAT0/1 Or PWM_FCAPDAT0/1 To Do PDMA Transfer
 * |        |          |00 = Reserved.
 * |        |          |01 = PWM_RCAPDAT0/1.
 * |        |          |10 = PWM_FCAPDAT0/1.
 * |        |          |11 = Both PWM_RCAPDAT0/1 and PWM_FCAPDAT0/1.
 * |[3]     |CAPORD0_1 |Capture Channel 0/1 Rising/Falling Order
 * |        |          |Set this bit to determine whether the PWM_RCAPDAT0/1 or PWM_FCAPDAT0/1 is the first captured data transferred to memory through PDMA when CAPMOD0_1 = 11.
 * |        |          |0 = PWM_FCAPDAT0/1 is the first captured data to memory.
 * |        |          |1 = PWM_RCAPDAT0/1 is the first captured data to memory.
 * |[4]     |CHSEL0_1  |Select Channel 0/1 To Do PDMA Transfer
 * |        |          |0 = Channel0.
 * |        |          |1 = Channel1.
 * |[8]     |CHEN2_3   |Channel 2/3 PDMA Enable
 * |        |          |0 = Channel 2/3 PDMA function Disabled.
 * |        |          |1 = Channel 2/3 PDMA function Enabled for the channel 2/3 captured data and transfer to memory.
 * |[10:9]  |CAPMOD2_3 |Select PWM_RCAPDAT2/3 Or PWM_FCAODAT2/3 To Do PDMA Transfer
 * |        |          |00 = Reserved.
 * |        |          |01 = PWM_RCAPDAT2/3.
 * |        |          |10 = PWM_FCAPDAT2/3.
 * |        |          |11 = Both PWM_RCAPDAT2/3 and PWM_FCAPDAT2/3.
 * |[11]    |CAPORD2_3 |Capture Channel 2/3 Rising/Falling Order
 * |        |          |Set this bit to determine whether the PWM_RCAPDAT2/3 or PWM_FCAPDAT2/3 is the first captured data transferred to memory through PDMA when CAPMOD2_3 = 11.
 * |        |          |0 = PWM_FCAPDAT2/3 is the first captured data to memory.
 * |        |          |1 = PWM_RCAPDAT2/3 is the first captured data to memory.
 * |[12]    |CHSEL2_3  |Select Channel 2/3 To Do PDMA Transfer
 * |        |          |0 = Channel2.
 * |        |          |1 = Channel3.
 * |[16]    |CHEN4_5   |Channel 4/5 PDMA Enable
 * |        |          |0 = Channel 4/5 PDMA function Disabled.
 * |        |          |1 = Channel 4/5 PDMA function Enabled for the channel 4/5 captured data and transfer to memory.
 * |[18:17] |CAPMOD4_5 |Select PWM_RCAPDAT4/5 Or PWM_FCAPDAT4/5 To Do PDMA Transfer
 * |        |          |00 = Reserved.
 * |        |          |01 = PWM_RCAPDAT4/5.
 * |        |          |10 = PWM_FCAPDAT4/5.
 * |        |          |11 = Both PWM_RCAPDAT4/5 and PWM_FCAPDAT4/5.
 * |[19]    |CAPORD4_5 |Capture Channel 4/5 Rising/Falling Order
 * |        |          |Set this bit to determine whether the PWM_RCAPDAT4/5 or PWM_FCAPDAT4/5 is the first captured data transferred to memory through PDMA when CAPMOD4_5 = 11.
 * |        |          |0 = PWM_FCAPDAT4/5 is the first captured data to memory.
 * |        |          |1 = PWM_RCAPDAT4/5 is the first captured data to memory.
 * |[20]    |CHSEL4_5  |Select Channel 4/5 To Do PDMA Transfer
 * |        |          |0 = Channel4.
 * |        |          |1 = Channel5.
 * @var PWM_T::PDMACAP0_1
 * Offset: 0x240  PWM Capture Channel 01 PDMA Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |CAPBUF    |PWM Capture PDMA Register
 * |        |          |(Read Only)
 * |        |          |This register is use as a buffer to transfer PWM capture rising or falling data to memory by PDMA.
 * @var PWM_T::PDMACAP2_3
 * Offset: 0x244  PWM Capture Channel 23 PDMA Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |CAPBUF    |PWM Capture PDMA Register
 * |        |          |(Read Only)
 * |        |          |This register is use as a buffer to transfer PWM capture rising or falling data to memory by PDMA.
 * @var PWM_T::PDMACAP4_5
 * Offset: 0x248  PWM Capture Channel 45 PDMA Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |CAPBUF    |PWM Capture PDMA Register
 * |        |          |(Read Only)
 * |        |          |This register is use as a buffer to transfer PWM capture rising or falling data to memory by PDMA.
 * @var PWM_T::CAPIEN
 * Offset: 0x250  PWM Capture Interrupt Enable Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[5:0]   |CAPRIENn  |PWM Capture Rising Latch Interrupt Enable
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |        |          |0 = Capture rising edge latch interrupt Disabled.
 * |        |          |1 = Capture rising edge latch interrupt Enabled.
 * |        |          |Note: When Capture with PDMA operating, CINTENR corresponding channel CAPRIEN must be disabled.
 * |[13:8]  |CAPFIENn  |PWM Capture Falling Latch Interrupt Enable
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |        |          |0 = Capture falling edge latch interrupt Disabled.
 * |        |          |1 = Capture falling edge latch interrupt Enabled.
 * |        |          |Note: When Capture with PDMA operating, CINTENR corresponding channel CAPFIEN must be disabled.
 * @var PWM_T::CAPIF
 * Offset: 0x254  PWM Capture Interrupt Flag Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[5:0]   |CRLIFn    |PWM Capture Rising Latch Interrupt Flag
 * |        |          |This bit is writing 1 to clear. Each bit n controls the corresponding PWM channel n.
 * |        |          |0 = No capture rising latch condition happened.
 * |        |          |1 = Capture rising latch condition happened, this flag will be set to high.
 * |        |          |Note: When Capture with PDMA operating, CIFR corresponding channel CRLIF will cleared by hardware after PDMA transfer data.
 * |[13:8]  |CFLIFn    |PWM Capture Falling Latch Interrupt Flag
 * |        |          |This bit is writing 1 to clear. Each bit n controls the corresponding PWM channel n.
 * |        |          |0 = No capture falling latch condition happened.
 * |        |          |1 = Capture falling latch condition happened, this flag will be set to high.
 * |        |          |Note: When Capture with PDMA operating, CIFR corresponding channel CFLIF will cleared by hardware after PDMA transfer data.
 * @var PWM_T::PBUF
 * Offset: 0x304~0x318  PWM PERIOD0~5 Buffer
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |PBUF      |PWM Period Register Buffer
 * |        |          |(Read Only)
 * |        |          |Used as PERIOD active register.
 * @var PWM_T::CMPBUF
 * Offset: 0x31C~0x330  PWM CMPDAT0~5 Buffer
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |CMPBUF    |PWM Comparator Register Buffer
 * |        |          |(Read Only)
 * |        |          |Used as CMP active register.
 * @var PWM_T::FTCBUF0_1
 * Offset: 0x340  PWM FTCMPDAT0_1 Buffer
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |FTCMPBUF  |PWM FTCMPDAT Buffer (Read Only)
 * |        |          |Used as FTCMPDAT active register.
 * @var PWM_T::FTCBUF2_3
 * Offset: 0x344  PWM FTCMPDAT2_3 Buffer
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |FTCMPBUF  |PWM FTCMPDAT Buffer (Read Only)
 * |        |          |Used as FTCMPDAT active register.
 * @var PWM_T::FTCBUF4_5
 * Offset: 0x348  PWM FTCMPDAT4_5 Buffer
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |FTCMPBUF  |PWM FTCMPDAT Buffer (Read Only)
 * |        |          |Used as FTCMPDAT active register.
 * @var PWM_T::FTCI
 * Offset: 0x34C  PWM FTCMPDAT Indicator Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[2:0]   |FTCMUn    |PWM FTCMPDAT Up Indicator
 * |        |          |Indicator will be set to high when FTCMPDATn equal to PERIODn and DIRF=1, software can write 1 to clear this bit.
 * |        |          |Each bit n controls the corresponding PWM channel n.
 * |[10:8]  |FTCMDn    |PWM FTCMPDAT Down Indicator
 * |        |          |Indicator will be set to high when FTCMPDATn equal to PERIODn and DIRF=0, software can write 1 to clear this bit.
 * |        |          |Each bit n controls the corresponding PWM channel n.
 */

    __IO uint32_t CTL0;          /* Offset: 0x00  PWM Control Register 0                                             */
    __IO uint32_t CTL1;          /* Offset: 0x04  PWM Control Register 1                                             */
    __IO uint32_t SYNC;          /* Offset: 0x08  PWM Synchronization Register                                       */
    __IO uint32_t SWSYNC;        /* Offset: 0x0C  PWM Software Control Synchronization Register                      */
    __IO uint32_t CLKSRC;        /* Offset: 0x10  PWM Clock Source Register                                          */
    __IO uint32_t CLKPSC0_1;     /* Offset: 0x14  PWM Clock Pre-scale Register 0                                     */
    __IO uint32_t CLKPSC2_3;     /* Offset: 0x18  PWM Clock Pre-scale Register 2                                     */
    __IO uint32_t CLKPSC4_5;     /* Offset: 0x1C  PWM Clock Pre-scale Register 4                                     */
    __IO uint32_t CNTEN;         /* Offset: 0x20  PWM Counter Enable Register                                        */
    __IO uint32_t CNTCLR;        /* Offset: 0x24  PWM Clear Counter Register                                         */
    __IO uint32_t LOAD;          /* Offset: 0x28  PWM Load Register                                                  */
    __I  uint32_t RESERVE0[1];  
    __IO uint32_t PERIOD[6];     /* Offset: 0x30~0x44  PWM Period Register 0~5                                       */
    __I  uint32_t RESERVE1[2];  
    __IO uint32_t CMPDAT[6];     /* Offset: 0x50~0x64  PWM Comparator Register 0~5                                   */
    __I  uint32_t RESERVE2[2];  
    __IO uint32_t DTCTL0_1;      /* Offset: 0x70  PWM Dead-Time Control Register 0                                   */
    __IO uint32_t DTCTL2_3;      /* Offset: 0x74  PWM Dead-Time Control Register 2                                   */
    __IO uint32_t DTCTL4_5;      /* Offset: 0x78  PWM Dead-Time Control Register 4                                   */
    __I  uint32_t RESERVE3[1];  
    __IO uint32_t PHS0_1;        /* Offset: 0x80  PWM Counter Phase Register 0                                       */
    __IO uint32_t PHS2_3;        /* Offset: 0x84  PWM Counter Phase Register 2                                       */
    __IO uint32_t PHS4_5;        /* Offset: 0x88  PWM Counter Phase Register 4                                       */
    __I  uint32_t RESERVE4[1];  
    __I  uint32_t CNT[6];        /* Offset: 0x90~0xA4  PWM Counter Register 0~5                                      */
    __I  uint32_t RESERVE5[2];  
    __IO uint32_t WGCTL0;        /* Offset: 0xB0  PWM Generation Register 0                                          */
    __IO uint32_t WGCTL1;        /* Offset: 0xB4  PWM Generation Register 1                                          */
    __IO uint32_t MSKEN;         /* Offset: 0xB8  PWM Mask Enable Register                                           */
    __IO uint32_t MSK;           /* Offset: 0xBC  PWM Mask Data Register                                             */
    __IO uint32_t BNF;           /* Offset: 0xC0  PWM Brake Noise Filter Register                                    */
    __IO uint32_t FAILBRK;       /* Offset: 0xC4  PWM System Fail Brake Control Register                             */
    __IO uint32_t BRKCTL0_1;     /* Offset: 0xC8  PWM Brake Edge Detect Control Register 0                           */
    __IO uint32_t BRKCTL2_3;     /* Offset: 0xCC  PWM Brake Edge Detect Control Register 2                           */
    __IO uint32_t BRKCTL4_5;     /* Offset: 0xD0  PWM Brake Edge Detect Control Register 4                           */
    __IO uint32_t POLCTL;        /* Offset: 0xD4  PWM Pin Polar Inverse Register                                     */
    __IO uint32_t POEN;          /* Offset: 0xD8  PWM Output Enable Register                                         */
    __O  uint32_t SWBRK;         /* Offset: 0xDC  PWM Software Brake Control Register                                */
    __IO uint32_t INTEN0;        /* Offset: 0xE0  PWM Interrupt Enable Register 0                                    */
    __IO uint32_t INTEN1;        /* Offset: 0xE4  PWM Interrupt Enable Register 1                                    */
    __IO uint32_t INTSTS0;       /* Offset: 0xE8  PWM Interrupt Flag Register 0                                      */
    __IO uint32_t INTSTS1;       /* Offset: 0xEC  PWM Interrupt Flag Register 1                                      */
    __IO uint32_t IFA;           /* Offset: 0xF0  PWM Interrupt Flag Accumulator Register                            */
    __IO uint32_t DACTRGEN;      /* Offset: 0xF4  PWM Trigger DAC Enable Register                                    */
    __IO uint32_t EADCTS0;       /* Offset: 0xF8  PWM Trigger EADC Source Select Register 0                          */
    __IO uint32_t EADCTS1;       /* Offset: 0xFC  PWM Trigger EADC Source Select Register 1                          */
    __IO uint32_t FTCMPDAT0_1;   /* Offset: 0x100  PWM Free Trigger Compare Register 0                               */
    __IO uint32_t FTCMPDAT2_3;   /* Offset: 0x104  PWM Free Trigger Compare Register 2                               */
    __IO uint32_t FTCMPDAT4_5;   /* Offset: 0x108  PWM Free Trigger Compare Register 4                               */
    __I  uint32_t RESERVE6[1];  
    __IO uint32_t SSCTL;         /* Offset: 0x110  PWM Synchronous Start Control Register                            */
    __O  uint32_t SSTRG;         /* Offset: 0x114  PWM Synchronous Start Trigger Register                            */
    __I  uint32_t RESERVE7[2];  
    __IO uint32_t STATUS;        /* Offset: 0x120  PWM Status Register                                               */
    __I  uint32_t RESERVE8[55]; 
    __IO uint32_t CAPINEN;       /* Offset: 0x200  PWM Capture Input Enable Register                                 */
    __IO uint32_t CAPCTL;        /* Offset: 0x204  PWM Capture Control Register                                      */
    __I  uint32_t CAPSTS;        /* Offset: 0x208  PWM Capture Status Register                                       */
    __I  uint32_t RCAPDAT0;      /* Offset: 0x20C  PWM Rising Capture Data Register 0                                */
    __I  uint32_t FCAPDAT0;      /* Offset: 0x210  PWM Falling Capture Data Register 0                               */
    __I  uint32_t RCAPDAT1;      /* Offset: 0x214  PWM Rising Capture Data Register 1                                */
    __I  uint32_t FCAPDAT1;      /* Offset: 0x218  PWM Falling Capture Data Register 1                               */
    __I  uint32_t RCAPDAT2;      /* Offset: 0x21C  PWM Rising Capture Data Register 2                                */
    __I  uint32_t FCAPDAT2;      /* Offset: 0x220  PWM Falling Capture Data Register 2                               */
    __I  uint32_t RCAPDAT3;      /* Offset: 0x224  PWM Rising Capture Data Register 3                                */
    __I  uint32_t FCAPDAT3;      /* Offset: 0x228  PWM Falling Capture Data Register 3                               */
    __I  uint32_t RCAPDAT4;      /* Offset: 0x22C  PWM Rising Capture Data Register 4                                */
    __I  uint32_t FCAPDAT4;      /* Offset: 0x230  PWM Falling Capture Data Register 4                               */
    __I  uint32_t RCAPDAT5;      /* Offset: 0x234  PWM Rising Capture Data Register 5                                */
    __I  uint32_t FCAPDAT5;      /* Offset: 0x238  PWM Falling Capture Data Register 5                               */
    __IO uint32_t PDMACTL;       /* Offset: 0x23C  PWM PDMA Control Register                                         */
    __I  uint32_t PDMACAP0_1;    /* Offset: 0x240  PWM Capture Channel 01 PDMA Register                              */
    __I  uint32_t PDMACAP2_3;    /* Offset: 0x244  PWM Capture Channel 23 PDMA Register                              */
    __I  uint32_t PDMACAP4_5;    /* Offset: 0x248  PWM Capture Channel 45 PDMA Register                              */
    __I  uint32_t RESERVE9[1];  
    __IO uint32_t CAPIEN;        /* Offset: 0x250  PWM Capture Interrupt Enable Register                             */
    __IO uint32_t CAPIF;         /* Offset: 0x254  PWM Capture Interrupt Flag Register                               */
    __I  uint32_t RESERVE10[43];
    __I  uint32_t PBUF[6];       /* Offset: 0x304~0x318  PWM PERIOD0~5 Buffer                                        */
    __I  uint32_t CMPBUF[6];     /* Offset: 0x31C~0x330  PWM CMPDAT0~5 Buffer                                        */
    __I  uint32_t RESERVE11[3]; 
    __I  uint32_t FTCBUF0_1;     /* Offset: 0x340  PWM FTCMPDAT0_1 Buffer                                            */
    __I  uint32_t FTCBUF2_3;     /* Offset: 0x344  PWM FTCMPDAT2_3 Buffer                                            */
    __I  uint32_t FTCBUF4_5;     /* Offset: 0x348  PWM FTCMPDAT4_5 Buffer                                            */
    __IO uint32_t FTCI;          /* Offset: 0x34C  PWM FTCMPDAT Indicator Register                                   */

} PWM_T;



/**
    @addtogroup PWM_CONST PWM Bit Field Definition
    Constant Definitions for PWM Controller
@{ */

#define PWM_CTL0_CTRLDn_Pos              (0)                                               /*!< PWM_T::CTL0: CTRLDn Position              */
#define PWM_CTL0_CTRLDn_Msk              (0x3ful << PWM_CTL0_CTRLDn_Pos)                   /*!< PWM_T::CTL0: CTRLDn Mask                  */

#define PWM_CTL0_CTRLD0_Pos              (0)                                               /*!< PWM_T::CTL0: CTRLD0 Position              */
#define PWM_CTL0_CTRLD0_Msk              (0x1ul << PWM_CTL0_CTRLD0_Pos)                    /*!< PWM_T::CTL0: CTRLD0 Mask                  */

#define PWM_CTL0_CTRLD1_Pos              (1)                                               /*!< PWM_T::CTL0: CTRLD1 Position              */
#define PWM_CTL0_CTRLD1_Msk              (0x1ul << PWM_CTL0_CTRLD1_Pos)                    /*!< PWM_T::CTL0: CTRLD1 Mask                  */

#define PWM_CTL0_CTRLD2_Pos              (2)                                               /*!< PWM_T::CTL0: CTRLD2 Position              */
#define PWM_CTL0_CTRLD2_Msk              (0x1ul << PWM_CTL0_CTRLD2_Pos)                    /*!< PWM_T::CTL0: CTRLD2 Mask                  */

#define PWM_CTL0_CTRLD3_Pos              (3)                                               /*!< PWM_T::CTL0: CTRLD3 Position              */
#define PWM_CTL0_CTRLD3_Msk              (0x1ul << PWM_CTL0_CTRLD3_Pos)                    /*!< PWM_T::CTL0: CTRLD3 Mask                  */

#define PWM_CTL0_CTRLD4_Pos              (4)                                               /*!< PWM_T::CTL0: CTRLD4 Position              */
#define PWM_CTL0_CTRLD4_Msk              (0x1ul << PWM_CTL0_CTRLD4_Pos)                    /*!< PWM_T::CTL0: CTRLD4 Mask                  */

#define PWM_CTL0_CTRLD5_Pos              (5)                                               /*!< PWM_T::CTL0: CTRLD5 Position              */
#define PWM_CTL0_CTRLD5_Msk              (0x1ul << PWM_CTL0_CTRLD5_Pos)                    /*!< PWM_T::CTL0: CTRLD5 Mask                  */

#define PWM_CTL0_WINLDENn_Pos            (8)                                               /*!< PWM_T::CTL0: WINLDENn Position            */
#define PWM_CTL0_WINLDENn_Msk            (0x3ful << PWM_CTL0_WINLDENn_Pos)                 /*!< PWM_T::CTL0: WINLDENn Mask                */

#define PWM_CTL0_WINLDEN0_Pos            (8)                                               /*!< PWM_T::CTL0: WINLDEN0 Position            */
#define PWM_CTL0_WINLDEN0_Msk            (0x1ul << PWM_CTL0_WINLDEN0_Pos)                  /*!< PWM_T::CTL0: WINLDEN0 Mask                */

#define PWM_CTL0_WINLDEN1_Pos            (9)                                               /*!< PWM_T::CTL0: WINLDEN1 Position            */
#define PWM_CTL0_WINLDEN1_Msk            (0x1ul << PWM_CTL0_WINLDEN1_Pos)                  /*!< PWM_T::CTL0: WINLDEN1 Mask                */

#define PWM_CTL0_WINLDEN2_Pos            (10)                                              /*!< PWM_T::CTL0: WINLDEN2 Position            */
#define PWM_CTL0_WINLDEN2_Msk            (0x1ul << PWM_CTL0_WINLDEN2_Pos)                  /*!< PWM_T::CTL0: WINLDEN2 Mask                */

#define PWM_CTL0_WINLDEN3_Pos            (11)                                              /*!< PWM_T::CTL0: WINLDEN3 Position            */
#define PWM_CTL0_WINLDEN3_Msk            (0x1ul << PWM_CTL0_WINLDEN3_Pos)                  /*!< PWM_T::CTL0: WINLDEN3 Mask                */

#define PWM_CTL0_WINLDEN4_Pos            (12)                                              /*!< PWM_T::CTL0: WINLDEN4 Position            */
#define PWM_CTL0_WINLDEN4_Msk            (0x1ul << PWM_CTL0_WINLDEN4_Pos)                  /*!< PWM_T::CTL0: WINLDEN4 Mask                */

#define PWM_CTL0_WINLDEN5_Pos            (13)                                              /*!< PWM_T::CTL0: WINLDEN5 Position            */
#define PWM_CTL0_WINLDEN5_Msk            (0x1ul << PWM_CTL0_WINLDEN5_Pos)                  /*!< PWM_T::CTL0: WINLDEN5 Mask                */

#define PWM_CTL0_IMMLDENn_Pos            (16)                                              /*!< PWM_T::CTL0: IMMLDENn Position            */
#define PWM_CTL0_IMMLDENn_Msk            (0x3ful << PWM_CTL0_IMMLDENn_Pos)                 /*!< PWM_T::CTL0: IMMLDENn Mask                */

#define PWM_CTL0_IMMLDEN0_Pos            (16)                                              /*!< PWM_T::CTL0: IMMLDEN0 Position            */
#define PWM_CTL0_IMMLDEN0_Msk            (0x1ul << PWM_CTL0_IMMLDEN0_Pos)                  /*!< PWM_T::CTL0: IMMLDEN0 Mask                */

#define PWM_CTL0_IMMLDEN1_Pos            (17)                                              /*!< PWM_T::CTL0: IMMLDEN1 Position            */
#define PWM_CTL0_IMMLDEN1_Msk            (0x1ul << PWM_CTL0_IMMLDEN1_Pos)                  /*!< PWM_T::CTL0: IMMLDEN1 Mask                */

#define PWM_CTL0_IMMLDEN2_Pos            (18)                                              /*!< PWM_T::CTL0: IMMLDEN2 Position            */
#define PWM_CTL0_IMMLDEN2_Msk            (0x1ul << PWM_CTL0_IMMLDEN2_Pos)                  /*!< PWM_T::CTL0: IMMLDEN2 Mask                */

#define PWM_CTL0_IMMLDEN3_Pos            (19)                                              /*!< PWM_T::CTL0: IMMLDEN3 Position            */
#define PWM_CTL0_IMMLDEN3_Msk            (0x1ul << PWM_CTL0_IMMLDEN3_Pos)                  /*!< PWM_T::CTL0: IMMLDEN3 Mask                */

#define PWM_CTL0_IMMLDEN4_Pos            (20)                                              /*!< PWM_T::CTL0: IMMLDEN4 Position            */
#define PWM_CTL0_IMMLDEN4_Msk            (0x1ul << PWM_CTL0_IMMLDEN4_Pos)                  /*!< PWM_T::CTL0: IMMLDEN4 Mask                */

#define PWM_CTL0_IMMLDEN5_Pos            (21)                                              /*!< PWM_T::CTL0: IMMLDEN5 Position            */
#define PWM_CTL0_IMMLDEN5_Msk            (0x1ul << PWM_CTL0_IMMLDEN5_Pos)                  /*!< PWM_T::CTL0: IMMLDEN5 Mask                */

#define PWM_CTL0_GROUPEN_Pos             (24)                                              /*!< PWM_T::CTL0: GROUPEN Position             */
#define PWM_CTL0_GROUPEN_Msk             (0x1ul << PWM_CTL0_GROUPEN_Pos)                   /*!< PWM_T::CTL0: GROUPEN Mask                 */

#define PWM_CTL0_DBGHALT_Pos             (30)                                              /*!< PWM_T::CTL0: DBGHALT Position             */
#define PWM_CTL0_DBGHALT_Msk             (0x1ul << PWM_CTL0_DBGHALT_Pos)                   /*!< PWM_T::CTL0: DBGHALT Mask                 */

#define PWM_CTL0_DBGTRIOFF_Pos           (31)                                              /*!< PWM_T::CTL0: DBGTRIOFF Position           */
#define PWM_CTL0_DBGTRIOFF_Msk           (0x1ul << PWM_CTL0_DBGTRIOFF_Pos)                 /*!< PWM_T::CTL0: DBGTRIOFF Mask               */

#define PWM_CTL1_CNTTYPEn_Pos            (0)                                               /*!< PWM_T::CTL1: CNTTYPEn Position            */
#define PWM_CTL1_CNTTYPEn_Msk            (0xffful << PWM_CTL1_CNTTYPEn_Pos)                /*!< PWM_T::CTL1: CNTTYPEn Mask                */

#define PWM_CTL1_CNTTYPE0_Pos            (0)                                               /*!< PWM_T::CTL1: CNTTYPE0 Position            */
#define PWM_CTL1_CNTTYPE0_Msk            (0x3ul << PWM_CTL1_CNTTYPE0_Pos)                  /*!< PWM_T::CTL1: CNTTYPE0 Mask                */

#define PWM_CTL1_CNTTYPE1_Pos            (2)                                               /*!< PWM_T::CTL1: CNTTYPE1 Position            */
#define PWM_CTL1_CNTTYPE1_Msk            (0x3ul << PWM_CTL1_CNTTYPE1_Pos)                  /*!< PWM_T::CTL1: CNTTYPE1 Mask                */

#define PWM_CTL1_CNTTYPE2_Pos            (4)                                               /*!< PWM_T::CTL1: CNTTYPE2 Position            */
#define PWM_CTL1_CNTTYPE2_Msk            (0x3ul << PWM_CTL1_CNTTYPE2_Pos)                  /*!< PWM_T::CTL1: CNTTYPE2 Mask                */

#define PWM_CTL1_CNTTYPE3_Pos            (6)                                               /*!< PWM_T::CTL1: CNTTYPE3 Position            */
#define PWM_CTL1_CNTTYPE3_Msk            (0x3ul << PWM_CTL1_CNTTYPE3_Pos)                  /*!< PWM_T::CTL1: CNTTYPE3 Mask                */

#define PWM_CTL1_CNTTYPE4_Pos            (8)                                               /*!< PWM_T::CTL1: CNTTYPE4 Position            */
#define PWM_CTL1_CNTTYPE4_Msk            (0x3ul << PWM_CTL1_CNTTYPE4_Pos)                  /*!< PWM_T::CTL1: CNTTYPE4 Mask                */

#define PWM_CTL1_CNTTYPE5_Pos            (10)                                              /*!< PWM_T::CTL1: CNTTYPE5 Position            */
#define PWM_CTL1_CNTTYPE5_Msk            (0x3ul << PWM_CTL1_CNTTYPE5_Pos)                  /*!< PWM_T::CTL1: CNTTYPE5 Mask                */

#define PWM_CTL1_CNTMODEn_Pos            (16)                                              /*!< PWM_T::CTL1: CNTMODEn Position            */
#define PWM_CTL1_CNTMODEn_Msk            (0x3ful << PWM_CTL1_CNTMODEn_Pos)                 /*!< PWM_T::CTL1: CNTMODEn Mask                */

#define PWM_CTL1_CNTMODE0_Pos            (16)                                              /*!< PWM_T::CTL1: CNTMODE0 Position            */
#define PWM_CTL1_CNTMODE0_Msk            (0x1ul << PWM_CTL1_CNTMODE0_Pos)                  /*!< PWM_T::CTL1: CNTMODE0 Mask                */

#define PWM_CTL1_CNTMODE1_Pos            (17)                                              /*!< PWM_T::CTL1: CNTMODE1 Position            */
#define PWM_CTL1_CNTMODE1_Msk            (0x1ul << PWM_CTL1_CNTMODE1_Pos)                  /*!< PWM_T::CTL1: CNTMODE1 Mask                */

#define PWM_CTL1_CNTMODE2_Pos            (18)                                              /*!< PWM_T::CTL1: CNTMODE2 Position            */
#define PWM_CTL1_CNTMODE2_Msk            (0x1ul << PWM_CTL1_CNTMODE2_Pos)                  /*!< PWM_T::CTL1: CNTMODE2 Mask                */

#define PWM_CTL1_CNTMODE3_Pos            (19)                                              /*!< PWM_T::CTL1: CNTMODE3 Position            */
#define PWM_CTL1_CNTMODE3_Msk            (0x1ul << PWM_CTL1_CNTMODE3_Pos)                  /*!< PWM_T::CTL1: CNTMODE3 Mask                */

#define PWM_CTL1_CNTMODE4_Pos            (20)                                              /*!< PWM_T::CTL1: CNTMODE4 Position            */
#define PWM_CTL1_CNTMODE4_Msk            (0x1ul << PWM_CTL1_CNTMODE4_Pos)                  /*!< PWM_T::CTL1: CNTMODE4 Mask                */

#define PWM_CTL1_CNTMODE5_Pos            (21)                                              /*!< PWM_T::CTL1: CNTMODE5 Position            */
#define PWM_CTL1_CNTMODE5_Msk            (0x1ul << PWM_CTL1_CNTMODE5_Pos)                  /*!< PWM_T::CTL1: CNTMODE5 Mask                */

#define PWM_CTL1_OUTMODEn_Pos            (24)                                              /*!< PWM_T::CTL1: OUTMODEn Position            */
#define PWM_CTL1_OUTMODEn_Msk            (0x7ul << PWM_CTL1_OUTMODEn_Pos)                  /*!< PWM_T::CTL1: OUTMODEn Mask                */

#define PWM_CTL1_OUTMODE0_Pos            (24)                                              /*!< PWM_T::CTL1: OUTMODE0 Position            */
#define PWM_CTL1_OUTMODE0_Msk            (0x1ul << PWM_CTL1_OUTMODE0_Pos)                  /*!< PWM_T::CTL1: OUTMODE0 Mask                */

#define PWM_CTL1_OUTMODE2_Pos            (25)                                              /*!< PWM_T::CTL1: OUTMODE2 Position            */
#define PWM_CTL1_OUTMODE2_Msk            (0x1ul << PWM_CTL1_OUTMODE2_Pos)                  /*!< PWM_T::CTL1: OUTMODE2 Mask                */

#define PWM_CTL1_OUTMODE4_Pos            (26)                                              /*!< PWM_T::CTL1: OUTMODE4 Position            */
#define PWM_CTL1_OUTMODE4_Msk            (0x1ul << PWM_CTL1_OUTMODE4_Pos)                  /*!< PWM_T::CTL1: OUTMODE4 Mask                */

#define PWM_SYNC_PHSENn_Pos              (0)                                               /*!< PWM_T::SYNC: PHSENn Position              */
#define PWM_SYNC_PHSENn_Msk              (0x7ul << PWM_SYNC_PHSENn_Pos)                    /*!< PWM_T::SYNC: PHSENn Mask                  */

#define PWM_SYNC_PHSEN0_Pos              (0)                                               /*!< PWM_T::SYNC: PHSEN0 Position              */
#define PWM_SYNC_PHSEN0_Msk              (0x1ul << PWM_SYNC_PHSEN0_Pos)                    /*!< PWM_T::SYNC: PHSEN0 Mask                  */

#define PWM_SYNC_PHSEN2_Pos              (1)                                               /*!< PWM_T::SYNC: PHSEN2 Position              */
#define PWM_SYNC_PHSEN2_Msk              (0x1ul << PWM_SYNC_PHSEN2_Pos)                    /*!< PWM_T::SYNC: PHSEN2 Mask                  */

#define PWM_SYNC_PHSEN4_Pos              (2)                                               /*!< PWM_T::SYNC: PHSEN4 Position              */
#define PWM_SYNC_PHSEN4_Msk              (0x1ul << PWM_SYNC_PHSEN4_Pos)                    /*!< PWM_T::SYNC: PHSEN4 Mask                  */

#define PWM_SYNC_SINSRCn_Pos             (8)                                               /*!< PWM_T::SYNC: SINSRCn Position             */
#define PWM_SYNC_SINSRCn_Msk             (0x3ful << PWM_SYNC_SINSRCn_Pos)                  /*!< PWM_T::SYNC: SINSRCn Mask                 */

#define PWM_SYNC_SINSRC0_Pos             (8)                                               /*!< PWM_T::SYNC: SINSRC0 Position             */
#define PWM_SYNC_SINSRC0_Msk             (0x3ul << PWM_SYNC_SINSRC0_Pos)                   /*!< PWM_T::SYNC: SINSRC0 Mask                 */

#define PWM_SYNC_SINSRC2_Pos             (10)                                              /*!< PWM_T::SYNC: SINSRC2 Position             */
#define PWM_SYNC_SINSRC2_Msk             (0x3ul << PWM_SYNC_SINSRC2_Pos)                   /*!< PWM_T::SYNC: SINSRC2 Mask                 */

#define PWM_SYNC_SINSRC4_Pos             (12)                                              /*!< PWM_T::SYNC: SINSRC4 Position             */
#define PWM_SYNC_SINSRC4_Msk             (0x3ul << PWM_SYNC_SINSRC4_Pos)                   /*!< PWM_T::SYNC: SINSRC4 Mask                 */

#define PWM_SYNC_SNFLTEN_Pos             (16)                                              /*!< PWM_T::SYNC: SNFLTEN Position             */
#define PWM_SYNC_SNFLTEN_Msk             (0x1ul << PWM_SYNC_SNFLTEN_Pos)                   /*!< PWM_T::SYNC: SNFLTEN Mask                 */

#define PWM_SYNC_SFLTCSEL_Pos            (17)                                              /*!< PWM_T::SYNC: SFLTCSEL Position            */
#define PWM_SYNC_SFLTCSEL_Msk            (0x7ul << PWM_SYNC_SFLTCSEL_Pos)                  /*!< PWM_T::SYNC: SFLTCSEL Mask                */

#define PWM_SYNC_SFLTCNT_Pos             (20)                                              /*!< PWM_T::SYNC: SFLTCNT Position             */
#define PWM_SYNC_SFLTCNT_Msk             (0x7ul << PWM_SYNC_SFLTCNT_Pos)                   /*!< PWM_T::SYNC: SFLTCNT Mask                 */

#define PWM_SYNC_SINPINV_Pos             (23)                                              /*!< PWM_T::SYNC: SINPINV Position             */
#define PWM_SYNC_SINPINV_Msk             (0x1ul << PWM_SYNC_SINPINV_Pos)                   /*!< PWM_T::SYNC: SINPINV Mask                 */

#define PWM_SYNC_PHSDIRn_Pos             (24)                                              /*!< PWM_T::SYNC: PHSDIRn Position             */
#define PWM_SYNC_PHSDIRn_Msk             (0x7ul << PWM_SYNC_PHSDIRn_Pos)                   /*!< PWM_T::SYNC: PHSDIRn Mask                 */

#define PWM_SYNC_PHSDIR0_Pos             (24)                                              /*!< PWM_T::SYNC: PHSDIR0 Position             */
#define PWM_SYNC_PHSDIR0_Msk             (0x1ul << PWM_SYNC_PHSDIR0_Pos)                   /*!< PWM_T::SYNC: PHSDIR0 Mask                 */

#define PWM_SYNC_PHSDIR2_Pos             (25)                                              /*!< PWM_T::SYNC: PHSDIR2 Position             */
#define PWM_SYNC_PHSDIR2_Msk             (0x1ul << PWM_SYNC_PHSDIR2_Pos)                   /*!< PWM_T::SYNC: PHSDIR2 Mask                 */

#define PWM_SYNC_PHSDIR4_Pos             (26)                                              /*!< PWM_T::SYNC: PHSDIR4 Position             */
#define PWM_SYNC_PHSDIR4_Msk             (0x1ul << PWM_SYNC_PHSDIR4_Pos)                   /*!< PWM_T::SYNC: PHSDIR4 Mask                 */

#define PWM_SWSYNC_SWSYNCn_Pos           (0)                                               /*!< PWM_T::SWSYNC: SWSYNCn Position           */
#define PWM_SWSYNC_SWSYNCn_Msk           (0x7ul << PWM_SWSYNC_SWSYNCn_Pos)                 /*!< PWM_T::SWSYNC: SWSYNCn Mask               */

#define PWM_SWSYNC_SWSYNC0_Pos           (0)                                               /*!< PWM_T::SWSYNC: SWSYNC0 Position           */
#define PWM_SWSYNC_SWSYNC0_Msk           (0x1ul << PWM_SWSYNC_SWSYNC0_Pos)                 /*!< PWM_T::SWSYNC: SWSYNC0 Mask               */

#define PWM_SWSYNC_SWSYNC2_Pos           (1)                                               /*!< PWM_T::SWSYNC: SWSYNC2 Position           */
#define PWM_SWSYNC_SWSYNC2_Msk           (0x1ul << PWM_SWSYNC_SWSYNC2_Pos)                 /*!< PWM_T::SWSYNC: SWSYNC2 Mask               */

#define PWM_SWSYNC_SWSYNC4_Pos           (2)                                               /*!< PWM_T::SWSYNC: SWSYNC4 Position           */
#define PWM_SWSYNC_SWSYNC4_Msk           (0x1ul << PWM_SWSYNC_SWSYNC4_Pos)                 /*!< PWM_T::SWSYNC: SWSYNC4 Mask               */

#define PWM_CLKSRC_ECLKSRC0_Pos          (0)                                               /*!< PWM_T::CLKSRC: ECLKSRC0 Position          */
#define PWM_CLKSRC_ECLKSRC0_Msk          (0x7ul << PWM_CLKSRC_ECLKSRC0_Pos)                /*!< PWM_T::CLKSRC: ECLKSRC0 Mask              */

#define PWM_CLKSRC_ECLKSRC2_Pos          (8)                                               /*!< PWM_T::CLKSRC: ECLKSRC2 Position          */
#define PWM_CLKSRC_ECLKSRC2_Msk          (0x7ul << PWM_CLKSRC_ECLKSRC2_Pos)                /*!< PWM_T::CLKSRC: ECLKSRC2 Mask              */

#define PWM_CLKSRC_ECLKSRC4_Pos          (16)                                              /*!< PWM_T::CLKSRC: ECLKSRC4 Position          */
#define PWM_CLKSRC_ECLKSRC4_Msk          (0x7ul << PWM_CLKSRC_ECLKSRC4_Pos)                /*!< PWM_T::CLKSRC: ECLKSRC4 Mask              */

#define PWM_CLKPSC0_1_CLKPSC_Pos         (0)                                               /*!< PWM_T::CLKPSC0_1: CLKPSC Position         */
#define PWM_CLKPSC0_1_CLKPSC_Msk         (0xffful << PWM_CLKPSC0_1_CLKPSC_Pos)             /*!< PWM_T::CLKPSC0_1: CLKPSC Mask             */

#define PWM_CLKPSC2_3_CLKPSC_Pos         (0)                                               /*!< PWM_T::CLKPSC2_3: CLKPSC Position         */
#define PWM_CLKPSC2_3_CLKPSC_Msk         (0xffful << PWM_CLKPSC2_3_CLKPSC_Pos)             /*!< PWM_T::CLKPSC2_3: CLKPSC Mask             */

#define PWM_CLKPSC4_5_CLKPSC_Pos         (0)                                               /*!< PWM_T::CLKPSC4_5: CLKPSC Position         */
#define PWM_CLKPSC4_5_CLKPSC_Msk         (0xffful << PWM_CLKPSC4_5_CLKPSC_Pos)             /*!< PWM_T::CLKPSC4_5: CLKPSC Mask             */

#define PWM_CNTEN_CNTENn_Pos             (0)                                               /*!< PWM_T::CNTEN: CNTENn Position             */
#define PWM_CNTEN_CNTENn_Msk             (0x3ful << PWM_CNTEN_CNTENn_Pos)                  /*!< PWM_T::CNTEN: CNTENn Mask                 */

#define PWM_CNTEN_CNTEN0_Pos             (0)                                               /*!< PWM_T::CNTEN: CNTEN0 Position             */
#define PWM_CNTEN_CNTEN0_Msk             (0x1ul << PWM_CNTEN_CNTEN0_Pos)                   /*!< PWM_T::CNTEN: CNTEN0 Mask                 */

#define PWM_CNTEN_CNTEN1_Pos             (1)                                               /*!< PWM_T::CNTEN: CNTEN1 Position             */
#define PWM_CNTEN_CNTEN1_Msk             (0x1ul << PWM_CNTEN_CNTEN1_Pos)                   /*!< PWM_T::CNTEN: CNTEN1 Mask                 */

#define PWM_CNTEN_CNTEN2_Pos             (2)                                               /*!< PWM_T::CNTEN: CNTEN2 Position             */
#define PWM_CNTEN_CNTEN2_Msk             (0x1ul << PWM_CNTEN_CNTEN2_Pos)                   /*!< PWM_T::CNTEN: CNTEN2 Mask                 */

#define PWM_CNTEN_CNTEN3_Pos             (3)                                               /*!< PWM_T::CNTEN: CNTEN3 Position             */
#define PWM_CNTEN_CNTEN3_Msk             (0x1ul << PWM_CNTEN_CNTEN3_Pos)                   /*!< PWM_T::CNTEN: CNTEN3 Mask                 */

#define PWM_CNTEN_CNTEN4_Pos             (4)                                               /*!< PWM_T::CNTEN: CNTEN4 Position             */
#define PWM_CNTEN_CNTEN4_Msk             (0x1ul << PWM_CNTEN_CNTEN4_Pos)                   /*!< PWM_T::CNTEN: CNTEN4 Mask                 */

#define PWM_CNTEN_CNTEN5_Pos             (5)                                               /*!< PWM_T::CNTEN: CNTEN5 Position             */
#define PWM_CNTEN_CNTEN5_Msk             (0x1ul << PWM_CNTEN_CNTEN5_Pos)                   /*!< PWM_T::CNTEN: CNTEN5 Mask                 */

#define PWM_CNTCLR_CNTCLRn_Pos           (0)                                               /*!< PWM_T::CNTCLR: CNTCLRn Position           */
#define PWM_CNTCLR_CNTCLRn_Msk           (0x3ful << PWM_CNTCLR_CNTCLRn_Pos)                /*!< PWM_T::CNTCLR: CNTCLRn Mask               */

#define PWM_CNTCLR_CNTCLR0_Pos           (0)                                               /*!< PWM_T::CNTCLR: CNTCLR0 Position           */
#define PWM_CNTCLR_CNTCLR0_Msk           (0x1ul << PWM_CNTCLR_CNTCLR0_Pos)                 /*!< PWM_T::CNTCLR: CNTCLR0 Mask               */

#define PWM_CNTCLR_CNTCLR1_Pos           (1)                                               /*!< PWM_T::CNTCLR: CNTCLR1 Position           */
#define PWM_CNTCLR_CNTCLR1_Msk           (0x1ul << PWM_CNTCLR_CNTCLR1_Pos)                 /*!< PWM_T::CNTCLR: CNTCLR1 Mask               */

#define PWM_CNTCLR_CNTCLR2_Pos           (2)                                               /*!< PWM_T::CNTCLR: CNTCLR2 Position           */
#define PWM_CNTCLR_CNTCLR2_Msk           (0x1ul << PWM_CNTCLR_CNTCLR2_Pos)                 /*!< PWM_T::CNTCLR: CNTCLR2 Mask               */

#define PWM_CNTCLR_CNTCLR3_Pos           (3)                                               /*!< PWM_T::CNTCLR: CNTCLR3 Position           */
#define PWM_CNTCLR_CNTCLR3_Msk           (0x1ul << PWM_CNTCLR_CNTCLR3_Pos)                 /*!< PWM_T::CNTCLR: CNTCLR3 Mask               */

#define PWM_CNTCLR_CNTCLR4_Pos           (4)                                               /*!< PWM_T::CNTCLR: CNTCLR4 Position           */
#define PWM_CNTCLR_CNTCLR4_Msk           (0x1ul << PWM_CNTCLR_CNTCLR4_Pos)                 /*!< PWM_T::CNTCLR: CNTCLR4 Mask               */

#define PWM_CNTCLR_CNTCLR5_Pos           (5)                                               /*!< PWM_T::CNTCLR: CNTCLR5 Position           */
#define PWM_CNTCLR_CNTCLR5_Msk           (0x1ul << PWM_CNTCLR_CNTCLR5_Pos)                 /*!< PWM_T::CNTCLR: CNTCLR5 Mask               */

#define PWM_LOAD_LOADn_Pos               (0)                                               /*!< PWM_T::LOAD: LOADn Position               */
#define PWM_LOAD_LOADn_Msk               (0x3ful << PWM_LOAD_LOADn_Pos)                    /*!< PWM_T::LOAD: LOADn Mask                   */

#define PWM_LOAD_LOAD0_Pos               (0)                                               /*!< PWM_T::LOAD: LOAD0 Position               */
#define PWM_LOAD_LOAD0_Msk               (0x1ul << PWM_LOAD_LOAD0_Pos)                     /*!< PWM_T::LOAD: LOAD0 Mask                   */

#define PWM_LOAD_LOAD1_Pos               (1)                                               /*!< PWM_T::LOAD: LOAD1 Position               */
#define PWM_LOAD_LOAD1_Msk               (0x1ul << PWM_LOAD_LOAD1_Pos)                     /*!< PWM_T::LOAD: LOAD1 Mask                   */

#define PWM_LOAD_LOAD2_Pos               (2)                                               /*!< PWM_T::LOAD: LOAD2 Position               */
#define PWM_LOAD_LOAD2_Msk               (0x1ul << PWM_LOAD_LOAD2_Pos)                     /*!< PWM_T::LOAD: LOAD2 Mask                   */

#define PWM_LOAD_LOAD3_Pos               (3)                                               /*!< PWM_T::LOAD: LOAD3 Position               */
#define PWM_LOAD_LOAD3_Msk               (0x1ul << PWM_LOAD_LOAD3_Pos)                     /*!< PWM_T::LOAD: LOAD3 Mask                   */

#define PWM_LOAD_LOAD4_Pos               (4)                                               /*!< PWM_T::LOAD: LOAD4 Position               */
#define PWM_LOAD_LOAD4_Msk               (0x1ul << PWM_LOAD_LOAD4_Pos)                     /*!< PWM_T::LOAD: LOAD4 Mask                   */

#define PWM_LOAD_LOAD5_Pos               (5)                                               /*!< PWM_T::LOAD: LOAD5 Position               */
#define PWM_LOAD_LOAD5_Msk               (0x1ul << PWM_LOAD_LOAD5_Pos)                     /*!< PWM_T::LOAD: LOAD5 Mask                   */

#define PWM_PERIOD_PERIOD_Pos            (0)                                               /*!< PWM_T::PERIOD: PERIOD Position            */
#define PWM_PERIOD_PERIOD_Msk            (0xfffful << PWM_PERIOD_PERIOD_Pos)               /*!< PWM_T::PERIOD: PERIOD Mask                */

#define PWM_CMPDAT_CMP_Pos               (0)                                               /*!< PWM_T::CMPDAT: CMP Position               */
#define PWM_CMPDAT_CMP_Msk               (0xfffful << PWM_CMPDAT_CMP_Pos)                  /*!< PWM_T::CMPDAT: CMP Mask                   */

#define PWM_DTCTL0_1_DTCNT_Pos           (0)                                               /*!< PWM_T::DTCTL0_1: DTCNT Position           */
#define PWM_DTCTL0_1_DTCNT_Msk           (0xffful << PWM_DTCTL0_1_DTCNT_Pos)               /*!< PWM_T::DTCTL0_1: DTCNT Mask               */

#define PWM_DTCTL0_1_DTEN_Pos            (16)                                              /*!< PWM_T::DTCTL0_1: DTEN Position            */
#define PWM_DTCTL0_1_DTEN_Msk            (0x1ul << PWM_DTCTL0_1_DTEN_Pos)                  /*!< PWM_T::DTCTL0_1: DTEN Mask                */

#define PWM_DTCTL0_1_DTCKSEL_Pos         (24)                                              /*!< PWM_T::DTCTL0_1: DTCKSEL Position         */
#define PWM_DTCTL0_1_DTCKSEL_Msk         (0x1ul << PWM_DTCTL0_1_DTCKSEL_Pos)               /*!< PWM_T::DTCTL0_1: DTCKSEL Mask             */

#define PWM_DTCTL2_3_DTCNT_Pos           (0)                                               /*!< PWM_T::DTCTL2_3: DTCNT Position           */
#define PWM_DTCTL2_3_DTCNT_Msk           (0xffful << PWM_DTCTL2_3_DTCNT_Pos)               /*!< PWM_T::DTCTL2_3: DTCNT Mask               */

#define PWM_DTCTL2_3_DTEN_Pos            (16)                                              /*!< PWM_T::DTCTL2_3: DTEN Position            */
#define PWM_DTCTL2_3_DTEN_Msk            (0x1ul << PWM_DTCTL2_3_DTEN_Pos)                  /*!< PWM_T::DTCTL2_3: DTEN Mask                */

#define PWM_DTCTL2_3_DTCKSEL_Pos         (24)                                              /*!< PWM_T::DTCTL2_3: DTCKSEL Position         */
#define PWM_DTCTL2_3_DTCKSEL_Msk         (0x1ul << PWM_DTCTL2_3_DTCKSEL_Pos)               /*!< PWM_T::DTCTL2_3: DTCKSEL Mask             */

#define PWM_DTCTL4_5_DTCNT_Pos           (0)                                               /*!< PWM_T::DTCTL4_5: DTCNT Position           */
#define PWM_DTCTL4_5_DTCNT_Msk           (0xffful << PWM_DTCTL4_5_DTCNT_Pos)               /*!< PWM_T::DTCTL4_5: DTCNT Mask               */

#define PWM_DTCTL4_5_DTEN_Pos            (16)                                              /*!< PWM_T::DTCTL4_5: DTEN Position            */
#define PWM_DTCTL4_5_DTEN_Msk            (0x1ul << PWM_DTCTL4_5_DTEN_Pos)                  /*!< PWM_T::DTCTL4_5: DTEN Mask                */

#define PWM_DTCTL4_5_DTCKSEL_Pos         (24)                                              /*!< PWM_T::DTCTL4_5: DTCKSEL Position         */
#define PWM_DTCTL4_5_DTCKSEL_Msk         (0x1ul << PWM_DTCTL4_5_DTCKSEL_Pos)               /*!< PWM_T::DTCTL4_5: DTCKSEL Mask             */

#define PWM_PHS0_1_PHS_Pos               (0)                                               /*!< PWM_T::PHS0_1: PHS Position               */
#define PWM_PHS0_1_PHS_Msk               (0xfffful << PWM_PHS0_1_PHS_Pos)                  /*!< PWM_T::PHS0_1: PHS Mask                   */

#define PWM_PHS2_3_PHS_Pos               (0)                                               /*!< PWM_T::PHS2_3: PHS Position               */
#define PWM_PHS2_3_PHS_Msk               (0xfffful << PWM_PHS2_3_PHS_Pos)                  /*!< PWM_T::PHS2_3: PHS Mask                   */

#define PWM_PHS4_5_PHS_Pos               (0)                                               /*!< PWM_T::PHS4_5: PHS Position               */
#define PWM_PHS4_5_PHS_Msk               (0xfffful << PWM_PHS4_5_PHS_Pos)                  /*!< PWM_T::PHS4_5: PHS Mask                   */

#define PWM_CNT_CNT_Pos                  (0)                                               /*!< PWM_T::CNT: CNT Position                  */
#define PWM_CNT_CNT_Msk                  (0xfffful << PWM_CNT_CNT_Pos)                     /*!< PWM_T::CNT: CNT Mask                      */

#define PWM_CNT_DIRF_Pos                 (16)                                              /*!< PWM_T::CNT: DIRF Position                 */
#define PWM_CNT_DIRF_Msk                 (0x1ul << PWM_CNT_DIRF_Pos)                       /*!< PWM_T::CNT: DIRF Mask                     */

#define PWM_WGCTL0_ZPCTLn_Pos            (0)                                               /*!< PWM_T::WGCTL0: ZPCTLn Position            */
#define PWM_WGCTL0_ZPCTLn_Msk            (0xffful << PWM_WGCTL0_ZPCTLn_Pos)                /*!< PWM_T::WGCTL0: ZPCTLn Mask                */

#define PWM_WGCTL0_ZPCTL0_Pos            (0)                                               /*!< PWM_T::WGCTL0: ZPCTL0 Position            */
#define PWM_WGCTL0_ZPCTL0_Msk            (0x3ul << PWM_WGCTL0_ZPCTL0_Pos)                  /*!< PWM_T::WGCTL0: ZPCTL0 Mask                */

#define PWM_WGCTL0_ZPCTL1_Pos            (2)                                               /*!< PWM_T::WGCTL0: ZPCTL1 Position            */
#define PWM_WGCTL0_ZPCTL1_Msk            (0x3ul << PWM_WGCTL0_ZPCTL1_Pos)                  /*!< PWM_T::WGCTL0: ZPCTL1 Mask                */

#define PWM_WGCTL0_ZPCTL2_Pos            (4)                                               /*!< PWM_T::WGCTL0: ZPCTL2 Position            */
#define PWM_WGCTL0_ZPCTL2_Msk            (0x3ul << PWM_WGCTL0_ZPCTL2_Pos)                  /*!< PWM_T::WGCTL0: ZPCTL2 Mask                */

#define PWM_WGCTL0_ZPCTL3_Pos            (6)                                               /*!< PWM_T::WGCTL0: ZPCTL3 Position            */
#define PWM_WGCTL0_ZPCTL3_Msk            (0x3ul << PWM_WGCTL0_ZPCTL3_Pos)                  /*!< PWM_T::WGCTL0: ZPCTL3 Mask                */

#define PWM_WGCTL0_ZPCTL4_Pos            (8)                                               /*!< PWM_T::WGCTL0: ZPCTL4 Position            */
#define PWM_WGCTL0_ZPCTL4_Msk            (0x3ul << PWM_WGCTL0_ZPCTL4_Pos)                  /*!< PWM_T::WGCTL0: ZPCTL4 Mask                */

#define PWM_WGCTL0_ZPCTL5_Pos            (10)                                              /*!< PWM_T::WGCTL0: ZPCTL5 Position            */
#define PWM_WGCTL0_ZPCTL5_Msk            (0x3ul << PWM_WGCTL0_ZPCTL5_Pos)                  /*!< PWM_T::WGCTL0: ZPCTL5 Mask                */

#define PWM_WGCTL0_PRDPCTLn_Pos          (16)                                              /*!< PWM_T::WGCTL0: PRDPCTLn Position          */
#define PWM_WGCTL0_PRDPCTLn_Msk          (0xffful << PWM_WGCTL0_PRDPCTLn_Pos)              /*!< PWM_T::WGCTL0: PRDPCTLn Mask              */

#define PWM_WGCTL0_PRDPCTL0_Pos          (16)                                              /*!< PWM_T::WGCTL0: PRDPCTL0 Position          */
#define PWM_WGCTL0_PRDPCTL0_Msk          (0x3ul << PWM_WGCTL0_PRDPCTL0_Pos)                /*!< PWM_T::WGCTL0: PRDPCTL0 Mask              */

#define PWM_WGCTL0_PRDPCTL1_Pos          (18)                                              /*!< PWM_T::WGCTL0: PRDPCTL1 Position          */
#define PWM_WGCTL0_PRDPCTL1_Msk          (0x3ul << PWM_WGCTL0_PRDPCTL1_Pos)                /*!< PWM_T::WGCTL0: PRDPCTL1 Mask              */

#define PWM_WGCTL0_PRDPCTL2_Pos          (20)                                              /*!< PWM_T::WGCTL0: PRDPCTL2 Position          */
#define PWM_WGCTL0_PRDPCTL2_Msk          (0x3ul << PWM_WGCTL0_PRDPCTL2_Pos)                /*!< PWM_T::WGCTL0: PRDPCTL2 Mask              */

#define PWM_WGCTL0_PRDPCTL3_Pos          (22)                                              /*!< PWM_T::WGCTL0: PRDPCTL3 Position          */
#define PWM_WGCTL0_PRDPCTL3_Msk          (0x3ul << PWM_WGCTL0_PRDPCTL3_Pos)                /*!< PWM_T::WGCTL0: PRDPCTL3 Mask              */

#define PWM_WGCTL0_PRDPCTL4_Pos          (24)                                              /*!< PWM_T::WGCTL0: PRDPCTL4 Position          */
#define PWM_WGCTL0_PRDPCTL4_Msk          (0x3ul << PWM_WGCTL0_PRDPCTL4_Pos)                /*!< PWM_T::WGCTL0: PRDPCTL4 Mask              */

#define PWM_WGCTL0_PRDPCTL5_Pos          (26)                                              /*!< PWM_T::WGCTL0: PRDPCTL5 Position          */
#define PWM_WGCTL0_PRDPCTL5_Msk          (0x3ul << PWM_WGCTL0_PRDPCTL5_Pos)                /*!< PWM_T::WGCTL0: PRDPCTL5 Mask              */

#define PWM_WGCTL1_CMPUCTLn_Pos          (0)                                               /*!< PWM_T::WGCTL1: CMPUCTLn Position          */
#define PWM_WGCTL1_CMPUCTLn_Msk          (0xffful << PWM_WGCTL1_CMPUCTLn_Pos)              /*!< PWM_T::WGCTL1: CMPUCTLn Mask              */

#define PWM_WGCTL1_CMPUCTL0_Pos          (0)                                               /*!< PWM_T::WGCTL1: CMPUCTL0 Position          */
#define PWM_WGCTL1_CMPUCTL0_Msk          (0x3ul << PWM_WGCTL1_CMPUCTL0_Pos)                /*!< PWM_T::WGCTL1: CMPUCTL0 Mask              */

#define PWM_WGCTL1_CMPUCTL1_Pos          (2)                                               /*!< PWM_T::WGCTL1: CMPUCTL1 Position          */
#define PWM_WGCTL1_CMPUCTL1_Msk          (0x3ul << PWM_WGCTL1_CMPUCTL1_Pos)                /*!< PWM_T::WGCTL1: CMPUCTL1 Mask              */

#define PWM_WGCTL1_CMPUCTL2_Pos          (4)                                               /*!< PWM_T::WGCTL1: CMPUCTL2 Position          */
#define PWM_WGCTL1_CMPUCTL2_Msk          (0x3ul << PWM_WGCTL1_CMPUCTL2_Pos)                /*!< PWM_T::WGCTL1: CMPUCTL2 Mask              */

#define PWM_WGCTL1_CMPUCTL3_Pos          (6)                                               /*!< PWM_T::WGCTL1: CMPUCTL3 Position          */
#define PWM_WGCTL1_CMPUCTL3_Msk          (0x3ul << PWM_WGCTL1_CMPUCTL3_Pos)                /*!< PWM_T::WGCTL1: CMPUCTL3 Mask              */

#define PWM_WGCTL1_CMPUCTL4_Pos          (8)                                               /*!< PWM_T::WGCTL1: CMPUCTL4 Position          */
#define PWM_WGCTL1_CMPUCTL4_Msk          (0x3ul << PWM_WGCTL1_CMPUCTL4_Pos)                /*!< PWM_T::WGCTL1: CMPUCTL4 Mask              */

#define PWM_WGCTL1_CMPUCTL5_Pos          (10)                                              /*!< PWM_T::WGCTL1: CMPUCTL5 Position          */
#define PWM_WGCTL1_CMPUCTL5_Msk          (0x3ul << PWM_WGCTL1_CMPUCTL5_Pos)                /*!< PWM_T::WGCTL1: CMPUCTL5 Mask              */

#define PWM_WGCTL1_CMPDCTLn_Pos          (16)                                              /*!< PWM_T::WGCTL1: CMPDCTLn Position          */
#define PWM_WGCTL1_CMPDCTLn_Msk          (0xffful << PWM_WGCTL1_CMPDCTLn_Pos)              /*!< PWM_T::WGCTL1: CMPDCTLn Mask              */

#define PWM_WGCTL1_CMPDCTL0_Pos          (16)                                              /*!< PWM_T::WGCTL1: CMPDCTL0 Position          */
#define PWM_WGCTL1_CMPDCTL0_Msk          (0x3ul << PWM_WGCTL1_CMPDCTL0_Pos)                /*!< PWM_T::WGCTL1: CMPDCTL0 Mask              */

#define PWM_WGCTL1_CMPDCTL1_Pos          (18)                                              /*!< PWM_T::WGCTL1: CMPDCTL1 Position          */
#define PWM_WGCTL1_CMPDCTL1_Msk          (0x3ul << PWM_WGCTL1_CMPDCTL1_Pos)                /*!< PWM_T::WGCTL1: CMPDCTL1 Mask              */

#define PWM_WGCTL1_CMPDCTL2_Pos          (20)                                              /*!< PWM_T::WGCTL1: CMPDCTL2 Position          */
#define PWM_WGCTL1_CMPDCTL2_Msk          (0x3ul << PWM_WGCTL1_CMPDCTL2_Pos)                /*!< PWM_T::WGCTL1: CMPDCTL2 Mask              */

#define PWM_WGCTL1_CMPDCTL3_Pos          (22)                                              /*!< PWM_T::WGCTL1: CMPDCTL3 Position          */
#define PWM_WGCTL1_CMPDCTL3_Msk          (0x3ul << PWM_WGCTL1_CMPDCTL3_Pos)                /*!< PWM_T::WGCTL1: CMPDCTL3 Mask              */

#define PWM_WGCTL1_CMPDCTL4_Pos          (24)                                              /*!< PWM_T::WGCTL1: CMPDCTL4 Position          */
#define PWM_WGCTL1_CMPDCTL4_Msk          (0x3ul << PWM_WGCTL1_CMPDCTL4_Pos)                /*!< PWM_T::WGCTL1: CMPDCTL4 Mask              */

#define PWM_WGCTL1_CMPDCTL5_Pos          (26)                                              /*!< PWM_T::WGCTL1: CMPDCTL5 Position          */
#define PWM_WGCTL1_CMPDCTL5_Msk          (0x3ul << PWM_WGCTL1_CMPDCTL5_Pos)                /*!< PWM_T::WGCTL1: CMPDCTL5 Mask              */

#define PWM_MSKEN_MSKENn_Pos             (0)                                               /*!< PWM_T::MSKEN: MSKENn Position             */
#define PWM_MSKEN_MSKENn_Msk             (0x3ful << PWM_MSKEN_MSKENn_Pos)                  /*!< PWM_T::MSKEN: MSKENn Mask                 */

#define PWM_MSKEN_MSKEN0_Pos             (0)                                               /*!< PWM_T::MSKEN: MSKEN0 Position             */
#define PWM_MSKEN_MSKEN0_Msk             (0x1ul << PWM_MSKEN_MSKEN0_Pos)                   /*!< PWM_T::MSKEN: MSKEN0 Mask                 */

#define PWM_MSKEN_MSKEN1_Pos             (1)                                               /*!< PWM_T::MSKEN: MSKEN1 Position             */
#define PWM_MSKEN_MSKEN1_Msk             (0x1ul << PWM_MSKEN_MSKEN1_Pos)                   /*!< PWM_T::MSKEN: MSKEN1 Mask                 */

#define PWM_MSKEN_MSKEN2_Pos             (2)                                               /*!< PWM_T::MSKEN: MSKEN2 Position             */
#define PWM_MSKEN_MSKEN2_Msk             (0x1ul << PWM_MSKEN_MSKEN2_Pos)                   /*!< PWM_T::MSKEN: MSKEN2 Mask                 */

#define PWM_MSKEN_MSKEN3_Pos             (3)                                               /*!< PWM_T::MSKEN: MSKEN3 Position             */
#define PWM_MSKEN_MSKEN3_Msk             (0x1ul << PWM_MSKEN_MSKEN3_Pos)                   /*!< PWM_T::MSKEN: MSKEN3 Mask                 */

#define PWM_MSKEN_MSKEN4_Pos             (4)                                               /*!< PWM_T::MSKEN: MSKEN4 Position             */
#define PWM_MSKEN_MSKEN4_Msk             (0x1ul << PWM_MSKEN_MSKEN4_Pos)                   /*!< PWM_T::MSKEN: MSKEN4 Mask                 */

#define PWM_MSKEN_MSKEN5_Pos             (5)                                               /*!< PWM_T::MSKEN: MSKEN5 Position             */
#define PWM_MSKEN_MSKEN5_Msk             (0x1ul << PWM_MSKEN_MSKEN5_Pos)                   /*!< PWM_T::MSKEN: MSKEN5 Mask                 */

#define PWM_MSK_MSKDATn_Pos              (0)                                               /*!< PWM_T::MSK: MSKDATn Position              */
#define PWM_MSK_MSKDATn_Msk              (0x3ful << PWM_MSK_MSKDATn_Pos)                   /*!< PWM_T::MSK: MSKDATn Mask                  */

#define PWM_MSK_MSKDAT0_Pos              (0)                                               /*!< PWM_T::MSK: MSKDAT0 Position              */
#define PWM_MSK_MSKDAT0_Msk              (0x1ul << PWM_MSK_MSKDAT0_Pos)                    /*!< PWM_T::MSK: MSKDAT0 Mask                  */

#define PWM_MSK_MSKDAT1_Pos              (1)                                               /*!< PWM_T::MSK: MSKDAT1 Position              */
#define PWM_MSK_MSKDAT1_Msk              (0x1ul << PWM_MSK_MSKDAT1_Pos)                    /*!< PWM_T::MSK: MSKDAT1 Mask                  */

#define PWM_MSK_MSKDAT2_Pos              (2)                                               /*!< PWM_T::MSK: MSKDAT2 Position              */
#define PWM_MSK_MSKDAT2_Msk              (0x1ul << PWM_MSK_MSKDAT2_Pos)                    /*!< PWM_T::MSK: MSKDAT2 Mask                  */

#define PWM_MSK_MSKDAT3_Pos              (3)                                               /*!< PWM_T::MSK: MSKDAT3 Position              */
#define PWM_MSK_MSKDAT3_Msk              (0x1ul << PWM_MSK_MSKDAT3_Pos)                    /*!< PWM_T::MSK: MSKDAT3 Mask                  */

#define PWM_MSK_MSKDAT4_Pos              (4)                                               /*!< PWM_T::MSK: MSKDAT4 Position              */
#define PWM_MSK_MSKDAT4_Msk              (0x1ul << PWM_MSK_MSKDAT4_Pos)                    /*!< PWM_T::MSK: MSKDAT4 Mask                  */

#define PWM_MSK_MSKDAT5_Pos              (5)                                               /*!< PWM_T::MSK: MSKDAT5 Position              */
#define PWM_MSK_MSKDAT5_Msk              (0x1ul << PWM_MSK_MSKDAT5_Pos)                    /*!< PWM_T::MSK: MSKDAT5 Mask                  */

#define PWM_BNF_BRK0NFEN_Pos             (0)                                               /*!< PWM_T::BNF: BRK0NFEN Position             */
#define PWM_BNF_BRK0NFEN_Msk             (0x1ul << PWM_BNF_BRK0NFEN_Pos)                   /*!< PWM_T::BNF: BRK0NFEN Mask                 */

#define PWM_BNF_BRK0NFSEL_Pos            (1)                                               /*!< PWM_T::BNF: BRK0NFSEL Position            */
#define PWM_BNF_BRK0NFSEL_Msk            (0x7ul << PWM_BNF_BRK0NFSEL_Pos)                  /*!< PWM_T::BNF: BRK0NFSEL Mask                */

#define PWM_BNF_BRK0FCNT_Pos             (4)                                               /*!< PWM_T::BNF: BRK0FCNT Position             */
#define PWM_BNF_BRK0FCNT_Msk             (0x7ul << PWM_BNF_BRK0FCNT_Pos)                   /*!< PWM_T::BNF: BRK0FCNT Mask                 */

#define PWM_BNF_BRK0PINV_Pos             (7)                                               /*!< PWM_T::BNF: BRK0PINV Position             */
#define PWM_BNF_BRK0PINV_Msk             (0x1ul << PWM_BNF_BRK0PINV_Pos)                   /*!< PWM_T::BNF: BRK0PINV Mask                 */

#define PWM_BNF_BRK1NFEN_Pos             (8)                                               /*!< PWM_T::BNF: BRK1NFEN Position             */
#define PWM_BNF_BRK1NFEN_Msk             (0x1ul << PWM_BNF_BRK1NFEN_Pos)                   /*!< PWM_T::BNF: BRK1NFEN Mask                 */

#define PWM_BNF_BRK1NFSEL_Pos            (9)                                               /*!< PWM_T::BNF: BRK1NFSEL Position            */
#define PWM_BNF_BRK1NFSEL_Msk            (0x7ul << PWM_BNF_BRK1NFSEL_Pos)                  /*!< PWM_T::BNF: BRK1NFSEL Mask                */

#define PWM_BNF_BRK1FCNT_Pos             (12)                                              /*!< PWM_T::BNF: BRK1FCNT Position             */
#define PWM_BNF_BRK1FCNT_Msk             (0x7ul << PWM_BNF_BRK1FCNT_Pos)                   /*!< PWM_T::BNF: BRK1FCNT Mask                 */

#define PWM_BNF_BRK1PINV_Pos             (15)                                              /*!< PWM_T::BNF: BRK1PINV Position             */
#define PWM_BNF_BRK1PINV_Msk             (0x1ul << PWM_BNF_BRK1PINV_Pos)                   /*!< PWM_T::BNF: BRK1PINV Mask                 */

#define PWM_BNF_BK0SRC_Pos               (16)                                              /*!< PWM_T::BNF: BK0SRC Position               */
#define PWM_BNF_BK0SRC_Msk               (0x1ul << PWM_BNF_BK0SRC_Pos)                     /*!< PWM_T::BNF: BK0SRC Mask                   */

#define PWM_BNF_BK1SRC_Pos               (24)                                              /*!< PWM_T::BNF: BK1SRC Position               */
#define PWM_BNF_BK1SRC_Msk               (0x1ul << PWM_BNF_BK1SRC_Pos)                     /*!< PWM_T::BNF: BK1SRC Mask                   */

#define PWM_FAILBRK_CSSBRKEN_Pos         (0)                                               /*!< PWM_T::FAILBRK: CSSBRKEN Position         */
#define PWM_FAILBRK_CSSBRKEN_Msk         (0x1ul << PWM_FAILBRK_CSSBRKEN_Pos)               /*!< PWM_T::FAILBRK: CSSBRKEN Mask             */

#define PWM_FAILBRK_BODBRKEN_Pos         (1)                                               /*!< PWM_T::FAILBRK: BODBRKEN Position         */
#define PWM_FAILBRK_BODBRKEN_Msk         (0x1ul << PWM_FAILBRK_BODBRKEN_Pos)               /*!< PWM_T::FAILBRK: BODBRKEN Mask             */

#define PWM_FAILBRK_RAMBRKEN_Pos         (2)                                               /*!< PWM_T::FAILBRK: RAMBRKEN Position         */
#define PWM_FAILBRK_RAMBRKEN_Msk         (0x1ul << PWM_FAILBRK_RAMBRKEN_Pos)               /*!< PWM_T::FAILBRK: RAMBRKEN Mask             */

#define PWM_FAILBRK_CORBRKEN_Pos         (3)                                               /*!< PWM_T::FAILBRK: CORBRKEN Position         */
#define PWM_FAILBRK_CORBRKEN_Msk         (0x1ul << PWM_FAILBRK_CORBRKEN_Pos)               /*!< PWM_T::FAILBRK: CORBRKEN Mask             */

#define PWM_BRKCTL0_1_CPO0EBEN_Pos       (0)                                               /*!< PWM_T::BRKCTL0_1: CPO0EBEN Position       */
#define PWM_BRKCTL0_1_CPO0EBEN_Msk       (0x1ul << PWM_BRKCTL0_1_CPO0EBEN_Pos)             /*!< PWM_T::BRKCTL0_1: CPO0EBEN Mask           */

#define PWM_BRKCTL0_1_CPO1EBEN_Pos       (1)                                               /*!< PWM_T::BRKCTL0_1: CPO1EBEN Position       */
#define PWM_BRKCTL0_1_CPO1EBEN_Msk       (0x1ul << PWM_BRKCTL0_1_CPO1EBEN_Pos)             /*!< PWM_T::BRKCTL0_1: CPO1EBEN Mask           */

#define PWM_BRKCTL0_1_BRKP0EEN_Pos       (4)                                               /*!< PWM_T::BRKCTL0_1: BRKP0EEN Position       */
#define PWM_BRKCTL0_1_BRKP0EEN_Msk       (0x1ul << PWM_BRKCTL0_1_BRKP0EEN_Pos)             /*!< PWM_T::BRKCTL0_1: BRKP0EEN Mask           */

#define PWM_BRKCTL0_1_BRKP1EEN_Pos       (5)                                               /*!< PWM_T::BRKCTL0_1: BRKP1EEN Position       */
#define PWM_BRKCTL0_1_BRKP1EEN_Msk       (0x1ul << PWM_BRKCTL0_1_BRKP1EEN_Pos)             /*!< PWM_T::BRKCTL0_1: BRKP1EEN Mask           */

#define PWM_BRKCTL0_1_SYSEBEN_Pos        (7)                                               /*!< PWM_T::BRKCTL0_1: SYSEBEN Position        */
#define PWM_BRKCTL0_1_SYSEBEN_Msk        (0x1ul << PWM_BRKCTL0_1_SYSEBEN_Pos)              /*!< PWM_T::BRKCTL0_1: SYSEBEN Mask            */

#define PWM_BRKCTL0_1_CPO0LBEN_Pos       (8)                                               /*!< PWM_T::BRKCTL0_1: CPO0LBEN Position       */
#define PWM_BRKCTL0_1_CPO0LBEN_Msk       (0x1ul << PWM_BRKCTL0_1_CPO0LBEN_Pos)             /*!< PWM_T::BRKCTL0_1: CPO0LBEN Mask           */

#define PWM_BRKCTL0_1_CPO1LBEN_Pos       (9)                                               /*!< PWM_T::BRKCTL0_1: CPO1LBEN Position       */
#define PWM_BRKCTL0_1_CPO1LBEN_Msk       (0x1ul << PWM_BRKCTL0_1_CPO1LBEN_Pos)             /*!< PWM_T::BRKCTL0_1: CPO1LBEN Mask           */

#define PWM_BRKCTL0_1_BRKP0LEN_Pos       (12)                                              /*!< PWM_T::BRKCTL0_1: BRKP0LEN Position       */
#define PWM_BRKCTL0_1_BRKP0LEN_Msk       (0x1ul << PWM_BRKCTL0_1_BRKP0LEN_Pos)             /*!< PWM_T::BRKCTL0_1: BRKP0LEN Mask           */

#define PWM_BRKCTL0_1_BRKP1LEN_Pos       (13)                                              /*!< PWM_T::BRKCTL0_1: BRKP1LEN Position       */
#define PWM_BRKCTL0_1_BRKP1LEN_Msk       (0x1ul << PWM_BRKCTL0_1_BRKP1LEN_Pos)             /*!< PWM_T::BRKCTL0_1: BRKP1LEN Mask           */

#define PWM_BRKCTL0_1_SYSLBEN_Pos        (15)                                              /*!< PWM_T::BRKCTL0_1: SYSLBEN Position        */
#define PWM_BRKCTL0_1_SYSLBEN_Msk        (0x1ul << PWM_BRKCTL0_1_SYSLBEN_Pos)              /*!< PWM_T::BRKCTL0_1: SYSLBEN Mask            */

#define PWM_BRKCTL0_1_BRKAEVEN_Pos       (16)                                              /*!< PWM_T::BRKCTL0_1: BRKAEVEN Position       */
#define PWM_BRKCTL0_1_BRKAEVEN_Msk       (0x3ul << PWM_BRKCTL0_1_BRKAEVEN_Pos)             /*!< PWM_T::BRKCTL0_1: BRKAEVEN Mask           */

#define PWM_BRKCTL0_1_BRKAODD_Pos        (18)                                              /*!< PWM_T::BRKCTL0_1: BRKAODD Position        */
#define PWM_BRKCTL0_1_BRKAODD_Msk        (0x3ul << PWM_BRKCTL0_1_BRKAODD_Pos)              /*!< PWM_T::BRKCTL0_1: BRKAODD Mask            */

#define PWM_BRKCTL2_3_CPO0EBEN_Pos       (0)                                               /*!< PWM_T::BRKCTL2_3: CPO0EBEN Position       */
#define PWM_BRKCTL2_3_CPO0EBEN_Msk       (0x1ul << PWM_BRKCTL2_3_CPO0EBEN_Pos)             /*!< PWM_T::BRKCTL2_3: CPO0EBEN Mask           */

#define PWM_BRKCTL2_3_CPO1EBEN_Pos       (1)                                               /*!< PWM_T::BRKCTL2_3: CPO1EBEN Position       */
#define PWM_BRKCTL2_3_CPO1EBEN_Msk       (0x1ul << PWM_BRKCTL2_3_CPO1EBEN_Pos)             /*!< PWM_T::BRKCTL2_3: CPO1EBEN Mask           */

#define PWM_BRKCTL2_3_BRKP0EEN_Pos       (4)                                               /*!< PWM_T::BRKCTL2_3: BRKP0EEN Position       */
#define PWM_BRKCTL2_3_BRKP0EEN_Msk       (0x1ul << PWM_BRKCTL2_3_BRKP0EEN_Pos)             /*!< PWM_T::BRKCTL2_3: BRKP0EEN Mask           */

#define PWM_BRKCTL2_3_BRKP1EEN_Pos       (5)                                               /*!< PWM_T::BRKCTL2_3: BRKP1EEN Position       */
#define PWM_BRKCTL2_3_BRKP1EEN_Msk       (0x1ul << PWM_BRKCTL2_3_BRKP1EEN_Pos)             /*!< PWM_T::BRKCTL2_3: BRKP1EEN Mask           */

#define PWM_BRKCTL2_3_SYSEBEN_Pos        (7)                                               /*!< PWM_T::BRKCTL2_3: SYSEBEN Position        */
#define PWM_BRKCTL2_3_SYSEBEN_Msk        (0x1ul << PWM_BRKCTL2_3_SYSEBEN_Pos)              /*!< PWM_T::BRKCTL2_3: SYSEBEN Mask            */

#define PWM_BRKCTL2_3_CPO0LBEN_Pos       (8)                                               /*!< PWM_T::BRKCTL2_3: CPO0LBEN Position       */
#define PWM_BRKCTL2_3_CPO0LBEN_Msk       (0x1ul << PWM_BRKCTL2_3_CPO0LBEN_Pos)             /*!< PWM_T::BRKCTL2_3: CPO0LBEN Mask           */

#define PWM_BRKCTL2_3_CPO1LBEN_Pos       (9)                                               /*!< PWM_T::BRKCTL2_3: CPO1LBEN Position       */
#define PWM_BRKCTL2_3_CPO1LBEN_Msk       (0x1ul << PWM_BRKCTL2_3_CPO1LBEN_Pos)             /*!< PWM_T::BRKCTL2_3: CPO1LBEN Mask           */

#define PWM_BRKCTL2_3_BRKP0LEN_Pos       (12)                                              /*!< PWM_T::BRKCTL2_3: BRKP0LEN Position       */
#define PWM_BRKCTL2_3_BRKP0LEN_Msk       (0x1ul << PWM_BRKCTL2_3_BRKP0LEN_Pos)             /*!< PWM_T::BRKCTL2_3: BRKP0LEN Mask           */

#define PWM_BRKCTL2_3_BRKP1LEN_Pos       (13)                                              /*!< PWM_T::BRKCTL2_3: BRKP1LEN Position       */
#define PWM_BRKCTL2_3_BRKP1LEN_Msk       (0x1ul << PWM_BRKCTL2_3_BRKP1LEN_Pos)             /*!< PWM_T::BRKCTL2_3: BRKP1LEN Mask           */

#define PWM_BRKCTL2_3_SYSLBEN_Pos        (15)                                              /*!< PWM_T::BRKCTL2_3: SYSLBEN Position        */
#define PWM_BRKCTL2_3_SYSLBEN_Msk        (0x1ul << PWM_BRKCTL2_3_SYSLBEN_Pos)              /*!< PWM_T::BRKCTL2_3: SYSLBEN Mask            */

#define PWM_BRKCTL2_3_BRKAEVEN_Pos       (16)                                              /*!< PWM_T::BRKCTL2_3: BRKAEVEN Position       */
#define PWM_BRKCTL2_3_BRKAEVEN_Msk       (0x3ul << PWM_BRKCTL2_3_BRKAEVEN_Pos)             /*!< PWM_T::BRKCTL2_3: BRKAEVEN Mask           */

#define PWM_BRKCTL2_3_BRKAODD_Pos        (18)                                              /*!< PWM_T::BRKCTL2_3: BRKAODD Position        */
#define PWM_BRKCTL2_3_BRKAODD_Msk        (0x3ul << PWM_BRKCTL2_3_BRKAODD_Pos)              /*!< PWM_T::BRKCTL2_3: BRKAODD Mask            */

#define PWM_BRKCTL4_5_CPO0EBEN_Pos       (0)                                               /*!< PWM_T::BRKCTL4_5: CPO0EBEN Position       */
#define PWM_BRKCTL4_5_CPO0EBEN_Msk       (0x1ul << PWM_BRKCTL4_5_CPO0EBEN_Pos)             /*!< PWM_T::BRKCTL4_5: CPO0EBEN Mask           */

#define PWM_BRKCTL4_5_CPO1EBEN_Pos       (1)                                               /*!< PWM_T::BRKCTL4_5: CPO1EBEN Position       */
#define PWM_BRKCTL4_5_CPO1EBEN_Msk       (0x1ul << PWM_BRKCTL4_5_CPO1EBEN_Pos)             /*!< PWM_T::BRKCTL4_5: CPO1EBEN Mask           */

#define PWM_BRKCTL4_5_BRKP0EEN_Pos       (4)                                               /*!< PWM_T::BRKCTL4_5: BRKP0EEN Position       */
#define PWM_BRKCTL4_5_BRKP0EEN_Msk       (0x1ul << PWM_BRKCTL4_5_BRKP0EEN_Pos)             /*!< PWM_T::BRKCTL4_5: BRKP0EEN Mask           */

#define PWM_BRKCTL4_5_BRKP1EEN_Pos       (5)                                               /*!< PWM_T::BRKCTL4_5: BRKP1EEN Position       */
#define PWM_BRKCTL4_5_BRKP1EEN_Msk       (0x1ul << PWM_BRKCTL4_5_BRKP1EEN_Pos)             /*!< PWM_T::BRKCTL4_5: BRKP1EEN Mask           */

#define PWM_BRKCTL4_5_SYSEBEN_Pos        (7)                                               /*!< PWM_T::BRKCTL4_5: SYSEBEN Position        */
#define PWM_BRKCTL4_5_SYSEBEN_Msk        (0x1ul << PWM_BRKCTL4_5_SYSEBEN_Pos)              /*!< PWM_T::BRKCTL4_5: SYSEBEN Mask            */

#define PWM_BRKCTL4_5_CPO0LBEN_Pos       (8)                                               /*!< PWM_T::BRKCTL4_5: CPO0LBEN Position       */
#define PWM_BRKCTL4_5_CPO0LBEN_Msk       (0x1ul << PWM_BRKCTL4_5_CPO0LBEN_Pos)             /*!< PWM_T::BRKCTL4_5: CPO0LBEN Mask           */

#define PWM_BRKCTL4_5_CPO1LBEN_Pos       (9)                                               /*!< PWM_T::BRKCTL4_5: CPO1LBEN Position       */
#define PWM_BRKCTL4_5_CPO1LBEN_Msk       (0x1ul << PWM_BRKCTL4_5_CPO1LBEN_Pos)             /*!< PWM_T::BRKCTL4_5: CPO1LBEN Mask           */

#define PWM_BRKCTL4_5_BRKP0LEN_Pos       (12)                                              /*!< PWM_T::BRKCTL4_5: BRKP0LEN Position       */
#define PWM_BRKCTL4_5_BRKP0LEN_Msk       (0x1ul << PWM_BRKCTL4_5_BRKP0LEN_Pos)             /*!< PWM_T::BRKCTL4_5: BRKP0LEN Mask           */

#define PWM_BRKCTL4_5_BRKP1LEN_Pos       (13)                                              /*!< PWM_T::BRKCTL4_5: BRKP1LEN Position       */
#define PWM_BRKCTL4_5_BRKP1LEN_Msk       (0x1ul << PWM_BRKCTL4_5_BRKP1LEN_Pos)             /*!< PWM_T::BRKCTL4_5: BRKP1LEN Mask           */

#define PWM_BRKCTL4_5_SYSLBEN_Pos        (15)                                              /*!< PWM_T::BRKCTL4_5: SYSLBEN Position        */
#define PWM_BRKCTL4_5_SYSLBEN_Msk        (0x1ul << PWM_BRKCTL4_5_SYSLBEN_Pos)              /*!< PWM_T::BRKCTL4_5: SYSLBEN Mask            */

#define PWM_BRKCTL4_5_BRKAEVEN_Pos       (16)                                              /*!< PWM_T::BRKCTL4_5: BRKAEVEN Position       */
#define PWM_BRKCTL4_5_BRKAEVEN_Msk       (0x3ul << PWM_BRKCTL4_5_BRKAEVEN_Pos)             /*!< PWM_T::BRKCTL4_5: BRKAEVEN Mask           */

#define PWM_BRKCTL4_5_BRKAODD_Pos        (18)                                              /*!< PWM_T::BRKCTL4_5: BRKAODD Position        */
#define PWM_BRKCTL4_5_BRKAODD_Msk        (0x3ul << PWM_BRKCTL4_5_BRKAODD_Pos)              /*!< PWM_T::BRKCTL4_5: BRKAODD Mask            */

#define PWM_POLCTL_PINVn_Pos             (0)                                               /*!< PWM_T::POLCTL: PINVn Position             */
#define PWM_POLCTL_PINVn_Msk             (0x3ful << PWM_POLCTL_PINVn_Pos)                  /*!< PWM_T::POLCTL: PINVn Mask                 */

#define PWM_POLCTL_PINV0_Pos             (0)                                               /*!< PWM_T::POLCTL: PINV0 Position             */
#define PWM_POLCTL_PINV0_Msk             (0x1ul << PWM_POLCTL_PINV0_Pos)                   /*!< PWM_T::POLCTL: PINV0 Mask                 */

#define PWM_POLCTL_PINV1_Pos             (1)                                               /*!< PWM_T::POLCTL: PINV1 Position             */
#define PWM_POLCTL_PINV1_Msk             (0x1ul << PWM_POLCTL_PINV1_Pos)                   /*!< PWM_T::POLCTL: PINV1 Mask                 */

#define PWM_POLCTL_PINV2_Pos             (2)                                               /*!< PWM_T::POLCTL: PINV2 Position             */
#define PWM_POLCTL_PINV2_Msk             (0x1ul << PWM_POLCTL_PINV2_Pos)                   /*!< PWM_T::POLCTL: PINV2 Mask                 */

#define PWM_POLCTL_PINV3_Pos             (3)                                               /*!< PWM_T::POLCTL: PINV3 Position             */
#define PWM_POLCTL_PINV3_Msk             (0x1ul << PWM_POLCTL_PINV3_Pos)                   /*!< PWM_T::POLCTL: PINV3 Mask                 */

#define PWM_POLCTL_PINV4_Pos             (4)                                               /*!< PWM_T::POLCTL: PINV4 Position             */
#define PWM_POLCTL_PINV4_Msk             (0x1ul << PWM_POLCTL_PINV4_Pos)                   /*!< PWM_T::POLCTL: PINV4 Mask                 */

#define PWM_POLCTL_PINV5_Pos             (5)                                               /*!< PWM_T::POLCTL: PINV5 Position             */
#define PWM_POLCTL_PINV5_Msk             (0x1ul << PWM_POLCTL_PINV5_Pos)                   /*!< PWM_T::POLCTL: PINV5 Mask                 */

#define PWM_POEN_POENn_Pos               (0)                                               /*!< PWM_T::POEN: POENn Position               */
#define PWM_POEN_POENn_Msk               (0x3ful << PWM_POEN_POENn_Pos)                    /*!< PWM_T::POEN: POENn Mask                   */

#define PWM_POEN_POEN0_Pos               (0)                                               /*!< PWM_T::POEN: POEN0 Position               */
#define PWM_POEN_POEN0_Msk               (0x1ul << PWM_POEN_POEN0_Pos)                     /*!< PWM_T::POEN: POEN0 Mask                   */

#define PWM_POEN_POEN1_Pos               (1)                                               /*!< PWM_T::POEN: POEN1 Position               */
#define PWM_POEN_POEN1_Msk               (0x1ul << PWM_POEN_POEN1_Pos)                     /*!< PWM_T::POEN: POEN1 Mask                   */

#define PWM_POEN_POEN2_Pos               (2)                                               /*!< PWM_T::POEN: POEN2 Position               */
#define PWM_POEN_POEN2_Msk               (0x1ul << PWM_POEN_POEN2_Pos)                     /*!< PWM_T::POEN: POEN2 Mask                   */

#define PWM_POEN_POEN3_Pos               (3)                                               /*!< PWM_T::POEN: POEN3 Position               */
#define PWM_POEN_POEN3_Msk               (0x1ul << PWM_POEN_POEN3_Pos)                     /*!< PWM_T::POEN: POEN3 Mask                   */

#define PWM_POEN_POEN4_Pos               (4)                                               /*!< PWM_T::POEN: POEN4 Position               */
#define PWM_POEN_POEN4_Msk               (0x1ul << PWM_POEN_POEN4_Pos)                     /*!< PWM_T::POEN: POEN4 Mask                   */

#define PWM_POEN_POEN5_Pos               (5)                                               /*!< PWM_T::POEN: POEN5 Position               */
#define PWM_POEN_POEN5_Msk               (0x1ul << PWM_POEN_POEN5_Pos)                     /*!< PWM_T::POEN: POEN5 Mask                   */

#define PWM_SWBRK_BRKETRGn_Pos           (0)                                               /*!< PWM_T::SWBRK: BRKETRGn Position           */
#define PWM_SWBRK_BRKETRGn_Msk           (0x7ul << PWM_SWBRK_BRKETRGn_Pos)                 /*!< PWM_T::SWBRK: BRKETRGn Mask               */

#define PWM_SWBRK_BRKETRG0_Pos           (0)                                               /*!< PWM_T::SWBRK: BRKETRG0 Position           */
#define PWM_SWBRK_BRKETRG0_Msk           (0x1ul << PWM_SWBRK_BRKETRG0_Pos)                 /*!< PWM_T::SWBRK: BRKETRG0 Mask               */

#define PWM_SWBRK_BRKETRG2_Pos           (1)                                               /*!< PWM_T::SWBRK: BRKETRG2 Position           */
#define PWM_SWBRK_BRKETRG2_Msk           (0x1ul << PWM_SWBRK_BRKETRG2_Pos)                 /*!< PWM_T::SWBRK: BRKETRG2 Mask               */

#define PWM_SWBRK_BRKETRG4_Pos           (2)                                               /*!< PWM_T::SWBRK: BRKETRG4 Position           */
#define PWM_SWBRK_BRKETRG4_Msk           (0x1ul << PWM_SWBRK_BRKETRG4_Pos)                 /*!< PWM_T::SWBRK: BRKETRG4 Mask               */

#define PWM_SWBRK_BRKLTRGn_Pos           (8)                                               /*!< PWM_T::SWBRK: BRKLTRGn Position           */
#define PWM_SWBRK_BRKLTRGn_Msk           (0x7ul << PWM_SWBRK_BRKLTRGn_Pos)                 /*!< PWM_T::SWBRK: BRKLTRGn Mask               */

#define PWM_SWBRK_BRKLTRG0_Pos           (8)                                               /*!< PWM_T::SWBRK: BRKLTRG0 Position           */
#define PWM_SWBRK_BRKLTRG0_Msk           (0x1ul << PWM_SWBRK_BRKLTRG0_Pos)                 /*!< PWM_T::SWBRK: BRKLTRG0 Mask               */

#define PWM_SWBRK_BRKLTRG2_Pos           (9)                                               /*!< PWM_T::SWBRK: BRKLTRG2 Position           */
#define PWM_SWBRK_BRKLTRG2_Msk           (0x1ul << PWM_SWBRK_BRKLTRG2_Pos)                 /*!< PWM_T::SWBRK: BRKLTRG2 Mask               */

#define PWM_SWBRK_BRKLTRG4_Pos           (10)                                              /*!< PWM_T::SWBRK: BRKLTRG4 Position           */
#define PWM_SWBRK_BRKLTRG4_Msk           (0x1ul << PWM_SWBRK_BRKLTRG4_Pos)                 /*!< PWM_T::SWBRK: BRKLTRG4 Mask               */

#define PWM_INTEN0_ZIENn_Pos             (0)                                               /*!< PWM_T::INTEN0: ZIENn Position             */
#define PWM_INTEN0_ZIENn_Msk             (0x3ful << PWM_INTEN0_ZIENn_Pos)                  /*!< PWM_T::INTEN0: ZIENn Mask                 */

#define PWM_INTEN0_ZIEN0_Pos             (0)                                               /*!< PWM_T::INTEN0: ZIEN0 Position             */
#define PWM_INTEN0_ZIEN0_Msk             (0x1ul << PWM_INTEN0_ZIEN0_Pos)                   /*!< PWM_T::INTEN0: ZIEN0 Mask                 */

#define PWM_INTEN0_ZIEN1_Pos             (1)                                               /*!< PWM_T::INTEN0: ZIEN1 Position             */
#define PWM_INTEN0_ZIEN1_Msk             (0x1ul << PWM_INTEN0_ZIEN1_Pos)                   /*!< PWM_T::INTEN0: ZIEN1 Mask                 */

#define PWM_INTEN0_ZIEN2_Pos             (2)                                               /*!< PWM_T::INTEN0: ZIEN2 Position             */
#define PWM_INTEN0_ZIEN2_Msk             (0x1ul << PWM_INTEN0_ZIEN2_Pos)                   /*!< PWM_T::INTEN0: ZIEN2 Mask                 */

#define PWM_INTEN0_ZIEN3_Pos             (3)                                               /*!< PWM_T::INTEN0: ZIEN3 Position             */
#define PWM_INTEN0_ZIEN3_Msk             (0x1ul << PWM_INTEN0_ZIEN3_Pos)                   /*!< PWM_T::INTEN0: ZIEN3 Mask                 */

#define PWM_INTEN0_ZIEN4_Pos             (4)                                               /*!< PWM_T::INTEN0: ZIEN4 Position             */
#define PWM_INTEN0_ZIEN4_Msk             (0x1ul << PWM_INTEN0_ZIEN4_Pos)                   /*!< PWM_T::INTEN0: ZIEN4 Mask                 */

#define PWM_INTEN0_ZIEN5_Pos             (5)                                               /*!< PWM_T::INTEN0: ZIEN5 Position             */
#define PWM_INTEN0_ZIEN5_Msk             (0x1ul << PWM_INTEN0_ZIEN5_Pos)                   /*!< PWM_T::INTEN0: ZIEN5 Mask                 */

#define PWM_INTEN0_IFAIEN0_1_Pos         (7)                                               /*!< PWM_T::INTEN0: IFAIEN0_1 Position         */
#define PWM_INTEN0_IFAIEN0_1_Msk         (0x1ul << PWM_INTEN0_IFAIEN0_1_Pos)               /*!< PWM_T::INTEN0: IFAIEN0_1 Mask             */

#define PWM_INTEN0_PIENn_Pos             (8)                                               /*!< PWM_T::INTEN0: PIENn Position             */
#define PWM_INTEN0_PIENn_Msk             (0x3ful << PWM_INTEN0_PIENn_Pos)                  /*!< PWM_T::INTEN0: PIENn Mask                 */

#define PWM_INTEN0_PIEN0_Pos             (8)                                               /*!< PWM_T::INTEN0: PIEN0 Position             */
#define PWM_INTEN0_PIEN0_Msk             (0x1ul << PWM_INTEN0_PIEN0_Pos)                   /*!< PWM_T::INTEN0: PIEN0 Mask                 */

#define PWM_INTEN0_PIEN1_Pos             (9)                                               /*!< PWM_T::INTEN0: PIEN1 Position             */
#define PWM_INTEN0_PIEN1_Msk             (0x1ul << PWM_INTEN0_PIEN1_Pos)                   /*!< PWM_T::INTEN0: PIEN1 Mask                 */

#define PWM_INTEN0_PIEN2_Pos             (10)                                              /*!< PWM_T::INTEN0: PIEN2 Position             */
#define PWM_INTEN0_PIEN2_Msk             (0x1ul << PWM_INTEN0_PIEN2_Pos)                   /*!< PWM_T::INTEN0: PIEN2 Mask                 */

#define PWM_INTEN0_PIEN3_Pos             (11)                                              /*!< PWM_T::INTEN0: PIEN3 Position             */
#define PWM_INTEN0_PIEN3_Msk             (0x1ul << PWM_INTEN0_PIEN3_Pos)                   /*!< PWM_T::INTEN0: PIEN3 Mask                 */

#define PWM_INTEN0_PIEN4_Pos             (12)                                              /*!< PWM_T::INTEN0: PIEN4 Position             */
#define PWM_INTEN0_PIEN4_Msk             (0x1ul << PWM_INTEN0_PIEN4_Pos)                   /*!< PWM_T::INTEN0: PIEN4 Mask                 */

#define PWM_INTEN0_PIEN5_Pos             (13)                                              /*!< PWM_T::INTEN0: PIEN5 Position             */
#define PWM_INTEN0_PIEN5_Msk             (0x1ul << PWM_INTEN0_PIEN5_Pos)                   /*!< PWM_T::INTEN0: PIEN5 Mask                 */

#define PWM_INTEN0_IFAIEN2_3_Pos         (15)                                              /*!< PWM_T::INTEN0: IFAIEN2_3 Position         */
#define PWM_INTEN0_IFAIEN2_3_Msk         (0x1ul << PWM_INTEN0_IFAIEN2_3_Pos)               /*!< PWM_T::INTEN0: IFAIEN2_3 Mask             */

#define PWM_INTEN0_CMPUIENn_Pos          (16)                                              /*!< PWM_T::INTEN0: CMPUIENn Position          */
#define PWM_INTEN0_CMPUIENn_Msk          (0x3ful << PWM_INTEN0_CMPUIENn_Pos)               /*!< PWM_T::INTEN0: CMPUIENn Mask              */

#define PWM_INTEN0_CMPUIEN0_Pos          (16)                                              /*!< PWM_T::INTEN0: CMPUIEN0 Position          */
#define PWM_INTEN0_CMPUIEN0_Msk          (0x1ul << PWM_INTEN0_CMPUIEN0_Pos)                /*!< PWM_T::INTEN0: CMPUIEN0 Mask              */

#define PWM_INTEN0_CMPUIEN1_Pos          (17)                                              /*!< PWM_T::INTEN0: CMPUIEN1 Position          */
#define PWM_INTEN0_CMPUIEN1_Msk          (0x1ul << PWM_INTEN0_CMPUIEN1_Pos)                /*!< PWM_T::INTEN0: CMPUIEN1 Mask              */

#define PWM_INTEN0_CMPUIEN2_Pos          (18)                                              /*!< PWM_T::INTEN0: CMPUIEN2 Position          */
#define PWM_INTEN0_CMPUIEN2_Msk          (0x1ul << PWM_INTEN0_CMPUIEN2_Pos)                /*!< PWM_T::INTEN0: CMPUIEN2 Mask              */

#define PWM_INTEN0_CMPUIEN3_Pos          (19)                                              /*!< PWM_T::INTEN0: CMPUIEN3 Position          */
#define PWM_INTEN0_CMPUIEN3_Msk          (0x1ul << PWM_INTEN0_CMPUIEN3_Pos)                /*!< PWM_T::INTEN0: CMPUIEN3 Mask              */

#define PWM_INTEN0_CMPUIEN4_Pos          (20)                                              /*!< PWM_T::INTEN0: CMPUIEN4 Position          */
#define PWM_INTEN0_CMPUIEN4_Msk          (0x1ul << PWM_INTEN0_CMPUIEN4_Pos)                /*!< PWM_T::INTEN0: CMPUIEN4 Mask              */

#define PWM_INTEN0_CMPUIEN5_Pos          (21)                                              /*!< PWM_T::INTEN0: CMPUIEN5 Position          */
#define PWM_INTEN0_CMPUIEN5_Msk          (0x1ul << PWM_INTEN0_CMPUIEN5_Pos)                /*!< PWM_T::INTEN0: CMPUIEN5 Mask              */

#define PWM_INTEN0_IFAIEN4_5_Pos         (23)                                              /*!< PWM_T::INTEN0: IFAIEN4_5 Position         */
#define PWM_INTEN0_IFAIEN4_5_Msk         (0x1ul << PWM_INTEN0_IFAIEN4_5_Pos)               /*!< PWM_T::INTEN0: IFAIEN4_5 Mask             */

#define PWM_INTEN0_CMPDIENn_Pos          (24)                                              /*!< PWM_T::INTEN0: CMPDIENn Position          */
#define PWM_INTEN0_CMPDIENn_Msk          (0x3ful << PWM_INTEN0_CMPDIENn_Pos)               /*!< PWM_T::INTEN0: CMPDIENn Mask              */

#define PWM_INTEN0_CMPDIEN0_Pos          (24)                                              /*!< PWM_T::INTEN0: CMPDIEN0 Position          */
#define PWM_INTEN0_CMPDIEN0_Msk          (0x1ul << PWM_INTEN0_CMPDIEN0_Pos)                /*!< PWM_T::INTEN0: CMPDIEN0 Mask              */

#define PWM_INTEN0_CMPDIEN1_Pos          (25)                                              /*!< PWM_T::INTEN0: CMPDIEN1 Position          */
#define PWM_INTEN0_CMPDIEN1_Msk          (0x1ul << PWM_INTEN0_CMPDIEN1_Pos)                /*!< PWM_T::INTEN0: CMPDIEN1 Mask              */

#define PWM_INTEN0_CMPDIEN2_Pos          (26)                                              /*!< PWM_T::INTEN0: CMPDIEN2 Position          */
#define PWM_INTEN0_CMPDIEN2_Msk          (0x1ul << PWM_INTEN0_CMPDIEN2_Pos)                /*!< PWM_T::INTEN0: CMPDIEN2 Mask              */

#define PWM_INTEN0_CMPDIEN3_Pos          (27)                                              /*!< PWM_T::INTEN0: CMPDIEN3 Position          */
#define PWM_INTEN0_CMPDIEN3_Msk          (0x1ul << PWM_INTEN0_CMPDIEN3_Pos)                /*!< PWM_T::INTEN0: CMPDIEN3 Mask              */

#define PWM_INTEN0_CMPDIEN4_Pos          (28)                                              /*!< PWM_T::INTEN0: CMPDIEN4 Position          */
#define PWM_INTEN0_CMPDIEN4_Msk          (0x1ul << PWM_INTEN0_CMPDIEN4_Pos)                /*!< PWM_T::INTEN0: CMPDIEN4 Mask              */

#define PWM_INTEN0_CMPDIEN5_Pos          (29)                                              /*!< PWM_T::INTEN0: CMPDIEN5 Position          */
#define PWM_INTEN0_CMPDIEN5_Msk          (0x1ul << PWM_INTEN0_CMPDIEN5_Pos)                /*!< PWM_T::INTEN0: CMPDIEN5 Mask              */

#define PWM_INTEN1_BRKEIEN0_1_Pos        (0)                                               /*!< PWM_T::INTEN1: BRKEIEN0_1 Position        */
#define PWM_INTEN1_BRKEIEN0_1_Msk        (0x1ul << PWM_INTEN1_BRKEIEN0_1_Pos)              /*!< PWM_T::INTEN1: BRKEIEN0_1 Mask            */

#define PWM_INTEN1_BRKEIEN2_3_Pos        (1)                                               /*!< PWM_T::INTEN1: BRKEIEN2_3 Position        */
#define PWM_INTEN1_BRKEIEN2_3_Msk        (0x1ul << PWM_INTEN1_BRKEIEN2_3_Pos)              /*!< PWM_T::INTEN1: BRKEIEN2_3 Mask            */

#define PWM_INTEN1_BRKEIEN4_5_Pos        (2)                                               /*!< PWM_T::INTEN1: BRKEIEN4_5 Position        */
#define PWM_INTEN1_BRKEIEN4_5_Msk        (0x1ul << PWM_INTEN1_BRKEIEN4_5_Pos)              /*!< PWM_T::INTEN1: BRKEIEN4_5 Mask            */

#define PWM_INTEN1_BRKLIEN0_1_Pos        (8)                                               /*!< PWM_T::INTEN1: BRKLIEN0_1 Position        */
#define PWM_INTEN1_BRKLIEN0_1_Msk        (0x1ul << PWM_INTEN1_BRKLIEN0_1_Pos)              /*!< PWM_T::INTEN1: BRKLIEN0_1 Mask            */

#define PWM_INTEN1_BRKLIEN2_3_Pos        (9)                                               /*!< PWM_T::INTEN1: BRKLIEN2_3 Position        */
#define PWM_INTEN1_BRKLIEN2_3_Msk        (0x1ul << PWM_INTEN1_BRKLIEN2_3_Pos)              /*!< PWM_T::INTEN1: BRKLIEN2_3 Mask            */

#define PWM_INTEN1_BRKLIEN4_5_Pos        (10)                                              /*!< PWM_T::INTEN1: BRKLIEN4_5 Position        */
#define PWM_INTEN1_BRKLIEN4_5_Msk        (0x1ul << PWM_INTEN1_BRKLIEN4_5_Pos)              /*!< PWM_T::INTEN1: BRKLIEN4_5 Mask            */

#define PWM_INTSTS0_ZIFn_Pos             (0)                                               /*!< PWM_T::INTSTS0: ZIFn Position             */
#define PWM_INTSTS0_ZIFn_Msk             (0x3ful << PWM_INTSTS0_ZIFn_Pos)                  /*!< PWM_T::INTSTS0: ZIFn Mask                 */

#define PWM_INTSTS0_ZIF0_Pos             (0)                                               /*!< PWM_T::INTSTS0: ZIF0 Position             */
#define PWM_INTSTS0_ZIF0_Msk             (0x1ul << PWM_INTSTS0_ZIF0_Pos)                   /*!< PWM_T::INTSTS0: ZIF0 Mask                 */

#define PWM_INTSTS0_ZIF1_Pos             (1)                                               /*!< PWM_T::INTSTS0: ZIF1 Position             */
#define PWM_INTSTS0_ZIF1_Msk             (0x1ul << PWM_INTSTS0_ZIF1_Pos)                   /*!< PWM_T::INTSTS0: ZIF1 Mask                 */

#define PWM_INTSTS0_ZIF2_Pos             (2)                                               /*!< PWM_T::INTSTS0: ZIF2 Position             */
#define PWM_INTSTS0_ZIF2_Msk             (0x1ul << PWM_INTSTS0_ZIF2_Pos)                   /*!< PWM_T::INTSTS0: ZIF2 Mask                 */

#define PWM_INTSTS0_ZIF3_Pos             (3)                                               /*!< PWM_T::INTSTS0: ZIF3 Position             */
#define PWM_INTSTS0_ZIF3_Msk             (0x1ul << PWM_INTSTS0_ZIF3_Pos)                   /*!< PWM_T::INTSTS0: ZIF3 Mask                 */

#define PWM_INTSTS0_ZIF4_Pos             (4)                                               /*!< PWM_T::INTSTS0: ZIF4 Position             */
#define PWM_INTSTS0_ZIF4_Msk             (0x1ul << PWM_INTSTS0_ZIF4_Pos)                   /*!< PWM_T::INTSTS0: ZIF4 Mask                 */

#define PWM_INTSTS0_ZIF5_Pos             (5)                                               /*!< PWM_T::INTSTS0: ZIF5 Position             */
#define PWM_INTSTS0_ZIF5_Msk             (0x1ul << PWM_INTSTS0_ZIF5_Pos)                   /*!< PWM_T::INTSTS0: ZIF5 Mask                 */

#define PWM_INTSTS0_IFAIF0_1_Pos         (7)                                               /*!< PWM_T::INTSTS0: IFAIF0_1 Position         */
#define PWM_INTSTS0_IFAIF0_1_Msk         (0x1ul << PWM_INTSTS0_IFAIF0_1_Pos)               /*!< PWM_T::INTSTS0: IFAIF0_1 Mask             */

#define PWM_INTSTS0_PIFn_Pos             (8)                                               /*!< PWM_T::INTSTS0: PIFn Position             */
#define PWM_INTSTS0_PIFn_Msk             (0x3ful << PWM_INTSTS0_PIFn_Pos)                  /*!< PWM_T::INTSTS0: PIFn Mask                 */

#define PWM_INTSTS0_PIF0_Pos             (8)                                               /*!< PWM_T::INTSTS0: PIF0 Position             */
#define PWM_INTSTS0_PIF0_Msk             (0x1ul << PWM_INTSTS0_PIF0_Pos)                   /*!< PWM_T::INTSTS0: PIF0 Mask                 */

#define PWM_INTSTS0_PIF1_Pos             (9)                                               /*!< PWM_T::INTSTS0: PIF1 Position             */
#define PWM_INTSTS0_PIF1_Msk             (0x1ul << PWM_INTSTS0_PIF1_Pos)                   /*!< PWM_T::INTSTS0: PIF1 Mask                 */

#define PWM_INTSTS0_PIF2_Pos             (10)                                              /*!< PWM_T::INTSTS0: PIF2 Position             */
#define PWM_INTSTS0_PIF2_Msk             (0x1ul << PWM_INTSTS0_PIF2_Pos)                   /*!< PWM_T::INTSTS0: PIF2 Mask                 */

#define PWM_INTSTS0_PIF3_Pos             (11)                                              /*!< PWM_T::INTSTS0: PIF3 Position             */
#define PWM_INTSTS0_PIF3_Msk             (0x1ul << PWM_INTSTS0_PIF3_Pos)                   /*!< PWM_T::INTSTS0: PIF3 Mask                 */

#define PWM_INTSTS0_PIF4_Pos             (12)                                              /*!< PWM_T::INTSTS0: PIF4 Position             */
#define PWM_INTSTS0_PIF4_Msk             (0x1ul << PWM_INTSTS0_PIF4_Pos)                   /*!< PWM_T::INTSTS0: PIF4 Mask                 */

#define PWM_INTSTS0_PIF5_Pos             (13)                                              /*!< PWM_T::INTSTS0: PIF5 Position             */
#define PWM_INTSTS0_PIF5_Msk             (0x1ul << PWM_INTSTS0_PIF5_Pos)                   /*!< PWM_T::INTSTS0: PIF5 Mask                 */

#define PWM_INTSTS0_IFAIF2_3_Pos         (15)                                              /*!< PWM_T::INTSTS0: IFAIF2_3 Position         */
#define PWM_INTSTS0_IFAIF2_3_Msk         (0x1ul << PWM_INTSTS0_IFAIF2_3_Pos)               /*!< PWM_T::INTSTS0: IFAIF2_3 Mask             */

#define PWM_INTSTS0_CMPUIFn_Pos          (16)                                              /*!< PWM_T::INTSTS0: CMPUIFn Position          */
#define PWM_INTSTS0_CMPUIFn_Msk          (0x3ful << PWM_INTSTS0_CMPUIFn_Pos)               /*!< PWM_T::INTSTS0: CMPUIFn Mask              */

#define PWM_INTSTS0_CMPUIF0_Pos          (16)                                              /*!< PWM_T::INTSTS0: CMPUIF0 Position          */
#define PWM_INTSTS0_CMPUIF0_Msk          (0x1ul << PWM_INTSTS0_CMPUIF0_Pos)                /*!< PWM_T::INTSTS0: CMPUIF0 Mask              */

#define PWM_INTSTS0_CMPUIF1_Pos          (17)                                              /*!< PWM_T::INTSTS0: CMPUIF1 Position          */
#define PWM_INTSTS0_CMPUIF1_Msk          (0x1ul << PWM_INTSTS0_CMPUIF1_Pos)                /*!< PWM_T::INTSTS0: CMPUIF1 Mask              */

#define PWM_INTSTS0_CMPUIF2_Pos          (18)                                              /*!< PWM_T::INTSTS0: CMPUIF2 Position          */
#define PWM_INTSTS0_CMPUIF2_Msk          (0x1ul << PWM_INTSTS0_CMPUIF2_Pos)                /*!< PWM_T::INTSTS0: CMPUIF2 Mask              */

#define PWM_INTSTS0_CMPUIF3_Pos          (19)                                              /*!< PWM_T::INTSTS0: CMPUIF3 Position          */
#define PWM_INTSTS0_CMPUIF3_Msk          (0x1ul << PWM_INTSTS0_CMPUIF3_Pos)                /*!< PWM_T::INTSTS0: CMPUIF3 Mask              */

#define PWM_INTSTS0_CMPUIF4_Pos          (20)                                              /*!< PWM_T::INTSTS0: CMPUIF4 Position          */
#define PWM_INTSTS0_CMPUIF4_Msk          (0x1ul << PWM_INTSTS0_CMPUIF4_Pos)                /*!< PWM_T::INTSTS0: CMPUIF4 Mask              */

#define PWM_INTSTS0_CMPUIF5_Pos          (21)                                              /*!< PWM_T::INTSTS0: CMPUIF5 Position          */
#define PWM_INTSTS0_CMPUIF5_Msk          (0x1ul << PWM_INTSTS0_CMPUIF5_Pos)                /*!< PWM_T::INTSTS0: CMPUIF5 Mask              */

#define PWM_INTSTS0_IFAIF4_5_Pos         (23)                                              /*!< PWM_T::INTSTS0: IFAIF4_5 Position         */
#define PWM_INTSTS0_IFAIF4_5_Msk         (0x1ul << PWM_INTSTS0_IFAIF4_5_Pos)               /*!< PWM_T::INTSTS0: IFAIF4_5 Mask             */

#define PWM_INTSTS0_CMPDIFn_Pos          (24)                                              /*!< PWM_T::INTSTS0: CMPDIFn Position          */
#define PWM_INTSTS0_CMPDIFn_Msk          (0x3ful << PWM_INTSTS0_CMPDIFn_Pos)               /*!< PWM_T::INTSTS0: CMPDIFn Mask              */

#define PWM_INTSTS0_CMPDIF0_Pos          (24)                                              /*!< PWM_T::INTSTS0: CMPDIF0 Position          */
#define PWM_INTSTS0_CMPDIF0_Msk          (0x1ul << PWM_INTSTS0_CMPDIF0_Pos)                /*!< PWM_T::INTSTS0: CMPDIF0 Mask              */

#define PWM_INTSTS0_CMPDIF1_Pos          (25)                                              /*!< PWM_T::INTSTS0: CMPDIF1 Position          */
#define PWM_INTSTS0_CMPDIF1_Msk          (0x1ul << PWM_INTSTS0_CMPDIF1_Pos)                /*!< PWM_T::INTSTS0: CMPDIF1 Mask              */

#define PWM_INTSTS0_CMPDIF2_Pos          (26)                                              /*!< PWM_T::INTSTS0: CMPDIF2 Position          */
#define PWM_INTSTS0_CMPDIF2_Msk          (0x1ul << PWM_INTSTS0_CMPDIF2_Pos)                /*!< PWM_T::INTSTS0: CMPDIF2 Mask              */

#define PWM_INTSTS0_CMPDIF3_Pos          (27)                                              /*!< PWM_T::INTSTS0: CMPDIF3 Position          */
#define PWM_INTSTS0_CMPDIF3_Msk          (0x1ul << PWM_INTSTS0_CMPDIF3_Pos)                /*!< PWM_T::INTSTS0: CMPDIF3 Mask              */

#define PWM_INTSTS0_CMPDIF4_Pos          (28)                                              /*!< PWM_T::INTSTS0: CMPDIF4 Position          */
#define PWM_INTSTS0_CMPDIF4_Msk          (0x1ul << PWM_INTSTS0_CMPDIF4_Pos)                /*!< PWM_T::INTSTS0: CMPDIF4 Mask              */

#define PWM_INTSTS0_CMPDIF5_Pos          (29)                                              /*!< PWM_T::INTSTS0: CMPDIF5 Position          */
#define PWM_INTSTS0_CMPDIF5_Msk          (0x1ul << PWM_INTSTS0_CMPDIF5_Pos)                /*!< PWM_T::INTSTS0: CMPDIF5 Mask              */

#define PWM_INTSTS1_BRKEIFn_Pos          (0)                                               /*!< PWM_T::INTSTS1: BRKEIFn Position          */
#define PWM_INTSTS1_BRKEIFn_Msk          (0x3ful << PWM_INTSTS1_BRKEIFn_Pos)               /*!< PWM_T::INTSTS1: BRKEIFn Mask              */

#define PWM_INTSTS1_BRKEIF0_Pos          (0)                                               /*!< PWM_T::INTSTS1: BRKEIF0 Position          */
#define PWM_INTSTS1_BRKEIF0_Msk          (0x1ul << PWM_INTSTS1_BRKEIF0_Pos)                /*!< PWM_T::INTSTS1: BRKEIF0 Mask              */

#define PWM_INTSTS1_BRKEIF1_Pos          (1)                                               /*!< PWM_T::INTSTS1: BRKEIF1 Position          */
#define PWM_INTSTS1_BRKEIF1_Msk          (0x1ul << PWM_INTSTS1_BRKEIF1_Pos)                /*!< PWM_T::INTSTS1: BRKEIF1 Mask              */

#define PWM_INTSTS1_BRKEIF2_Pos          (2)                                               /*!< PWM_T::INTSTS1: BRKEIF2 Position          */
#define PWM_INTSTS1_BRKEIF2_Msk          (0x1ul << PWM_INTSTS1_BRKEIF2_Pos)                /*!< PWM_T::INTSTS1: BRKEIF2 Mask              */

#define PWM_INTSTS1_BRKEIF3_Pos          (3)                                               /*!< PWM_T::INTSTS1: BRKEIF3 Position          */
#define PWM_INTSTS1_BRKEIF3_Msk          (0x1ul << PWM_INTSTS1_BRKEIF3_Pos)                /*!< PWM_T::INTSTS1: BRKEIF3 Mask              */

#define PWM_INTSTS1_BRKEIF4_Pos          (4)                                               /*!< PWM_T::INTSTS1: BRKEIF4 Position          */
#define PWM_INTSTS1_BRKEIF4_Msk          (0x1ul << PWM_INTSTS1_BRKEIF4_Pos)                /*!< PWM_T::INTSTS1: BRKEIF4 Mask              */

#define PWM_INTSTS1_BRKEIF5_Pos          (5)                                               /*!< PWM_T::INTSTS1: BRKEIF5 Position          */
#define PWM_INTSTS1_BRKEIF5_Msk          (0x1ul << PWM_INTSTS1_BRKEIF5_Pos)                /*!< PWM_T::INTSTS1: BRKEIF5 Mask              */

#define PWM_INTSTS1_BRKLIFn_Pos          (8)                                               /*!< PWM_T::INTSTS1: BRKLIFn Position          */
#define PWM_INTSTS1_BRKLIFn_Msk          (0x3ful << PWM_INTSTS1_BRKLIFn_Pos)               /*!< PWM_T::INTSTS1: BRKLIFn Mask              */

#define PWM_INTSTS1_BRKLIF0_Pos          (8)                                               /*!< PWM_T::INTSTS1: BRKLIF0 Position          */
#define PWM_INTSTS1_BRKLIF0_Msk          (0x1ul << PWM_INTSTS1_BRKLIF0_Pos)                /*!< PWM_T::INTSTS1: BRKLIF0 Mask              */

#define PWM_INTSTS1_BRKLIF1_Pos          (9)                                               /*!< PWM_T::INTSTS1: BRKLIF1 Position          */
#define PWM_INTSTS1_BRKLIF1_Msk          (0x1ul << PWM_INTSTS1_BRKLIF1_Pos)                /*!< PWM_T::INTSTS1: BRKLIF1 Mask              */

#define PWM_INTSTS1_BRKLIF2_Pos          (10)                                              /*!< PWM_T::INTSTS1: BRKLIF2 Position          */
#define PWM_INTSTS1_BRKLIF2_Msk          (0x1ul << PWM_INTSTS1_BRKLIF2_Pos)                /*!< PWM_T::INTSTS1: BRKLIF2 Mask              */

#define PWM_INTSTS1_BRKLIF3_Pos          (11)                                              /*!< PWM_T::INTSTS1: BRKLIF3 Position          */
#define PWM_INTSTS1_BRKLIF3_Msk          (0x1ul << PWM_INTSTS1_BRKLIF3_Pos)                /*!< PWM_T::INTSTS1: BRKLIF3 Mask              */

#define PWM_INTSTS1_BRKLIF4_Pos          (12)                                              /*!< PWM_T::INTSTS1: BRKLIF4 Position          */
#define PWM_INTSTS1_BRKLIF4_Msk          (0x1ul << PWM_INTSTS1_BRKLIF4_Pos)                /*!< PWM_T::INTSTS1: BRKLIF4 Mask              */

#define PWM_INTSTS1_BRKLIF5_Pos          (13)                                              /*!< PWM_T::INTSTS1: BRKLIF5 Position          */
#define PWM_INTSTS1_BRKLIF5_Msk          (0x1ul << PWM_INTSTS1_BRKLIF5_Pos)                /*!< PWM_T::INTSTS1: BRKLIF5 Mask              */

#define PWM_INTSTS1_BRKESTS0_Pos         (16)                                              /*!< PWM_T::INTSTS1: BRKESTS0 Position         */
#define PWM_INTSTS1_BRKESTS0_Msk         (0x1ul << PWM_INTSTS1_BRKESTS0_Pos)               /*!< PWM_T::INTSTS1: BRKESTS0 Mask             */

#define PWM_INTSTS1_BRKESTS1_Pos         (17)                                              /*!< PWM_T::INTSTS1: BRKESTS1 Position         */
#define PWM_INTSTS1_BRKESTS1_Msk         (0x1ul << PWM_INTSTS1_BRKESTS1_Pos)               /*!< PWM_T::INTSTS1: BRKESTS1 Mask             */

#define PWM_INTSTS1_BRKESTS2_Pos         (18)                                              /*!< PWM_T::INTSTS1: BRKESTS2 Position         */
#define PWM_INTSTS1_BRKESTS2_Msk         (0x1ul << PWM_INTSTS1_BRKESTS2_Pos)               /*!< PWM_T::INTSTS1: BRKESTS2 Mask             */

#define PWM_INTSTS1_BRKESTS3_Pos         (19)                                              /*!< PWM_T::INTSTS1: BRKESTS3 Position         */
#define PWM_INTSTS1_BRKESTS3_Msk         (0x1ul << PWM_INTSTS1_BRKESTS3_Pos)               /*!< PWM_T::INTSTS1: BRKESTS3 Mask             */

#define PWM_INTSTS1_BRKESTS4_Pos         (20)                                              /*!< PWM_T::INTSTS1: BRKESTS4 Position         */
#define PWM_INTSTS1_BRKESTS4_Msk         (0x1ul << PWM_INTSTS1_BRKESTS4_Pos)               /*!< PWM_T::INTSTS1: BRKESTS4 Mask             */

#define PWM_INTSTS1_BRKESTS5_Pos         (21)                                              /*!< PWM_T::INTSTS1: BRKESTS5 Position         */
#define PWM_INTSTS1_BRKESTS5_Msk         (0x1ul << PWM_INTSTS1_BRKESTS5_Pos)               /*!< PWM_T::INTSTS1: BRKESTS5 Mask             */

#define PWM_INTSTS1_BRKLSTS0_Pos         (24)                                              /*!< PWM_T::INTSTS1: BRKLSTS0 Position         */
#define PWM_INTSTS1_BRKLSTS0_Msk         (0x1ul << PWM_INTSTS1_BRKLSTS0_Pos)               /*!< PWM_T::INTSTS1: BRKLSTS0 Mask             */

#define PWM_INTSTS1_BRKLSTS1_Pos         (25)                                              /*!< PWM_T::INTSTS1: BRKLSTS1 Position         */
#define PWM_INTSTS1_BRKLSTS1_Msk         (0x1ul << PWM_INTSTS1_BRKLSTS1_Pos)               /*!< PWM_T::INTSTS1: BRKLSTS1 Mask             */

#define PWM_INTSTS1_BRKLSTS2_Pos         (26)                                              /*!< PWM_T::INTSTS1: BRKLSTS2 Position         */
#define PWM_INTSTS1_BRKLSTS2_Msk         (0x1ul << PWM_INTSTS1_BRKLSTS2_Pos)               /*!< PWM_T::INTSTS1: BRKLSTS2 Mask             */

#define PWM_INTSTS1_BRKLSTS3_Pos         (27)                                              /*!< PWM_T::INTSTS1: BRKLSTS3 Position         */
#define PWM_INTSTS1_BRKLSTS3_Msk         (0x1ul << PWM_INTSTS1_BRKLSTS3_Pos)               /*!< PWM_T::INTSTS1: BRKLSTS3 Mask             */

#define PWM_INTSTS1_BRKLSTS4_Pos         (28)                                              /*!< PWM_T::INTSTS1: BRKLSTS4 Position         */
#define PWM_INTSTS1_BRKLSTS4_Msk         (0x1ul << PWM_INTSTS1_BRKLSTS4_Pos)               /*!< PWM_T::INTSTS1: BRKLSTS4 Mask             */

#define PWM_INTSTS1_BRKLSTS5_Pos         (29)                                              /*!< PWM_T::INTSTS1: BRKLSTS5 Position         */
#define PWM_INTSTS1_BRKLSTS5_Msk         (0x1ul << PWM_INTSTS1_BRKLSTS5_Pos)               /*!< PWM_T::INTSTS1: BRKLSTS5 Mask             */

#define PWM_IFA_IFCNT0_1_Pos             (0)                                               /*!< PWM_T::IFA: IFCNT0_1 Position             */
#define PWM_IFA_IFCNT0_1_Msk             (0xful << PWM_IFA_IFCNT0_1_Pos)                   /*!< PWM_T::IFA: IFCNT0_1 Mask                 */

#define PWM_IFA_IFSEL0_1_Pos             (4)                                               /*!< PWM_T::IFA: IFSEL0_1 Position             */
#define PWM_IFA_IFSEL0_1_Msk             (0x7ul << PWM_IFA_IFSEL0_1_Pos)                   /*!< PWM_T::IFA: IFSEL0_1 Mask                 */

#define PWM_IFA_IFAEN0_1_Pos             (7)                                               /*!< PWM_T::IFA: IFAEN0_1 Position             */
#define PWM_IFA_IFAEN0_1_Msk             (0x1ul << PWM_IFA_IFAEN0_1_Pos)                   /*!< PWM_T::IFA: IFAEN0_1 Mask                 */

#define PWM_IFA_IFCNT2_3_Pos             (8)                                               /*!< PWM_T::IFA: IFCNT2_3 Position             */
#define PWM_IFA_IFCNT2_3_Msk             (0xful << PWM_IFA_IFCNT2_3_Pos)                   /*!< PWM_T::IFA: IFCNT2_3 Mask                 */

#define PWM_IFA_IFSEL2_3_Pos             (12)                                              /*!< PWM_T::IFA: IFSEL2_3 Position             */
#define PWM_IFA_IFSEL2_3_Msk             (0x7ul << PWM_IFA_IFSEL2_3_Pos)                   /*!< PWM_T::IFA: IFSEL2_3 Mask                 */

#define PWM_IFA_IFAEN2_3_Pos             (15)                                              /*!< PWM_T::IFA: IFAEN2_3 Position             */
#define PWM_IFA_IFAEN2_3_Msk             (0x1ul << PWM_IFA_IFAEN2_3_Pos)                   /*!< PWM_T::IFA: IFAEN2_3 Mask                 */

#define PWM_IFA_IFCNT4_5_Pos             (16)                                              /*!< PWM_T::IFA: IFCNT4_5 Position             */
#define PWM_IFA_IFCNT4_5_Msk             (0xful << PWM_IFA_IFCNT4_5_Pos)                   /*!< PWM_T::IFA: IFCNT4_5 Mask                 */

#define PWM_IFA_IFSEL4_5_Pos             (20)                                              /*!< PWM_T::IFA: IFSEL4_5 Position             */
#define PWM_IFA_IFSEL4_5_Msk             (0x7ul << PWM_IFA_IFSEL4_5_Pos)                   /*!< PWM_T::IFA: IFSEL4_5 Mask                 */

#define PWM_IFA_IFAEN4_5_Pos             (23)                                              /*!< PWM_T::IFA: IFAEN4_5 Position             */
#define PWM_IFA_IFAEN4_5_Msk             (0x1ul << PWM_IFA_IFAEN4_5_Pos)                   /*!< PWM_T::IFA: IFAEN4_5 Mask                 */

#define PWM_DACTRGEN_ZTEn_Pos            (0)                                               /*!< PWM_T::DACTRGEN: ZTEn Position            */
#define PWM_DACTRGEN_ZTEn_Msk            (0x3ful << PWM_DACTRGEN_ZTEn_Pos)                 /*!< PWM_T::DACTRGEN: ZTEn Mask                */

#define PWM_DACTRGEN_ZTE0_Pos            (0)                                               /*!< PWM_T::DACTRGEN: ZTE0 Position            */
#define PWM_DACTRGEN_ZTE0_Msk            (0x1ul << PWM_DACTRGEN_ZTE0_Pos)                  /*!< PWM_T::DACTRGEN: ZTE0 Mask                */

#define PWM_DACTRGEN_ZTE1_Pos            (1)                                               /*!< PWM_T::DACTRGEN: ZTE1 Position            */
#define PWM_DACTRGEN_ZTE1_Msk            (0x1ul << PWM_DACTRGEN_ZTE1_Pos)                  /*!< PWM_T::DACTRGEN: ZTE1 Mask                */

#define PWM_DACTRGEN_ZTE2_Pos            (2)                                               /*!< PWM_T::DACTRGEN: ZTE2 Position            */
#define PWM_DACTRGEN_ZTE2_Msk            (0x1ul << PWM_DACTRGEN_ZTE2_Pos)                  /*!< PWM_T::DACTRGEN: ZTE2 Mask                */

#define PWM_DACTRGEN_ZTE3_Pos            (3)                                               /*!< PWM_T::DACTRGEN: ZTE3 Position            */
#define PWM_DACTRGEN_ZTE3_Msk            (0x1ul << PWM_DACTRGEN_ZTE3_Pos)                  /*!< PWM_T::DACTRGEN: ZTE3 Mask                */

#define PWM_DACTRGEN_ZTE4_Pos            (4)                                               /*!< PWM_T::DACTRGEN: ZTE4 Position            */
#define PWM_DACTRGEN_ZTE4_Msk            (0x1ul << PWM_DACTRGEN_ZTE4_Pos)                  /*!< PWM_T::DACTRGEN: ZTE4 Mask                */

#define PWM_DACTRGEN_ZTE5_Pos            (5)                                               /*!< PWM_T::DACTRGEN: ZTE5 Position            */
#define PWM_DACTRGEN_ZTE5_Msk            (0x1ul << PWM_DACTRGEN_ZTE5_Pos)                  /*!< PWM_T::DACTRGEN: ZTE5 Mask                */

#define PWM_DACTRGEN_PTEn_Pos            (8)                                               /*!< PWM_T::DACTRGEN: PTEn Position            */
#define PWM_DACTRGEN_PTEn_Msk            (0x3ful << PWM_DACTRGEN_PTEn_Pos)                 /*!< PWM_T::DACTRGEN: PTEn Mask                */

#define PWM_DACTRGEN_PTE0_Pos            (8)                                               /*!< PWM_T::DACTRGEN: PTE0 Position            */
#define PWM_DACTRGEN_PTE0_Msk            (0x1ul << PWM_DACTRGEN_PTE0_Pos)                  /*!< PWM_T::DACTRGEN: PTE0 Mask                */

#define PWM_DACTRGEN_PTE1_Pos            (9)                                               /*!< PWM_T::DACTRGEN: PTE1 Position            */
#define PWM_DACTRGEN_PTE1_Msk            (0x1ul << PWM_DACTRGEN_PTE1_Pos)                  /*!< PWM_T::DACTRGEN: PTE1 Mask                */

#define PWM_DACTRGEN_PTE2_Pos            (10)                                              /*!< PWM_T::DACTRGEN: PTE2 Position            */
#define PWM_DACTRGEN_PTE2_Msk            (0x1ul << PWM_DACTRGEN_PTE2_Pos)                  /*!< PWM_T::DACTRGEN: PTE2 Mask                */

#define PWM_DACTRGEN_PTE3_Pos            (11)                                              /*!< PWM_T::DACTRGEN: PTE3 Position            */
#define PWM_DACTRGEN_PTE3_Msk            (0x1ul << PWM_DACTRGEN_PTE3_Pos)                  /*!< PWM_T::DACTRGEN: PTE3 Mask                */

#define PWM_DACTRGEN_PTE4_Pos            (12)                                              /*!< PWM_T::DACTRGEN: PTE4 Position            */
#define PWM_DACTRGEN_PTE4_Msk            (0x1ul << PWM_DACTRGEN_PTE4_Pos)                  /*!< PWM_T::DACTRGEN: PTE4 Mask                */

#define PWM_DACTRGEN_PTE5_Pos            (13)                                              /*!< PWM_T::DACTRGEN: PTE5 Position            */
#define PWM_DACTRGEN_PTE5_Msk            (0x1ul << PWM_DACTRGEN_PTE5_Pos)                  /*!< PWM_T::DACTRGEN: PTE5 Mask                */

#define PWM_DACTRGEN_CUTRGEn_Pos         (16)                                              /*!< PWM_T::DACTRGEN: CUTRGEn Position         */
#define PWM_DACTRGEN_CUTRGEn_Msk         (0x3ful << PWM_DACTRGEN_CUTRGEn_Pos)              /*!< PWM_T::DACTRGEN: CUTRGEn Mask             */

#define PWM_DACTRGEN_CUTRGE0_Pos         (16)                                              /*!< PWM_T::DACTRGEN: CUTRGE0 Position         */
#define PWM_DACTRGEN_CUTRGE0_Msk         (0x1ul << PWM_DACTRGEN_CUTRGE0_Pos)               /*!< PWM_T::DACTRGEN: CUTRGE0 Mask             */

#define PWM_DACTRGEN_CUTRGE1_Pos         (17)                                              /*!< PWM_T::DACTRGEN: CUTRGE1 Position         */
#define PWM_DACTRGEN_CUTRGE1_Msk         (0x1ul << PWM_DACTRGEN_CUTRGE1_Pos)               /*!< PWM_T::DACTRGEN: CUTRGE1 Mask             */

#define PWM_DACTRGEN_CUTRGE2_Pos         (18)                                              /*!< PWM_T::DACTRGEN: CUTRGE2 Position         */
#define PWM_DACTRGEN_CUTRGE2_Msk         (0x1ul << PWM_DACTRGEN_CUTRGE2_Pos)               /*!< PWM_T::DACTRGEN: CUTRGE2 Mask             */

#define PWM_DACTRGEN_CUTRGE3_Pos         (19)                                              /*!< PWM_T::DACTRGEN: CUTRGE3 Position         */
#define PWM_DACTRGEN_CUTRGE3_Msk         (0x1ul << PWM_DACTRGEN_CUTRGE3_Pos)               /*!< PWM_T::DACTRGEN: CUTRGE3 Mask             */

#define PWM_DACTRGEN_CUTRGE4_Pos         (20)                                              /*!< PWM_T::DACTRGEN: CUTRGE4 Position         */
#define PWM_DACTRGEN_CUTRGE4_Msk         (0x1ul << PWM_DACTRGEN_CUTRGE4_Pos)               /*!< PWM_T::DACTRGEN: CUTRGE4 Mask             */

#define PWM_DACTRGEN_CUTRGE5_Pos         (21)                                              /*!< PWM_T::DACTRGEN: CUTRGE5 Position         */
#define PWM_DACTRGEN_CUTRGE5_Msk         (0x1ul << PWM_DACTRGEN_CUTRGE5_Pos)               /*!< PWM_T::DACTRGEN: CUTRGE5 Mask             */

#define PWM_DACTRGEN_CDTRGEn_Pos         (24)                                              /*!< PWM_T::DACTRGEN: CDTRGEn Position         */
#define PWM_DACTRGEN_CDTRGEn_Msk         (0x3ful << PWM_DACTRGEN_CDTRGEn_Pos)              /*!< PWM_T::DACTRGEN: CDTRGEn Mask             */

#define PWM_DACTRGEN_CDTRGE0_Pos         (24)                                              /*!< PWM_T::DACTRGEN: CDTRGE0 Position         */
#define PWM_DACTRGEN_CDTRGE0_Msk         (0x1ul << PWM_DACTRGEN_CDTRGE0_Pos)               /*!< PWM_T::DACTRGEN: CDTRGE0 Mask             */

#define PWM_DACTRGEN_CDTRGE1_Pos         (25)                                              /*!< PWM_T::DACTRGEN: CDTRGE1 Position         */
#define PWM_DACTRGEN_CDTRGE1_Msk         (0x1ul << PWM_DACTRGEN_CDTRGE1_Pos)               /*!< PWM_T::DACTRGEN: CDTRGE1 Mask             */

#define PWM_DACTRGEN_CDTRGE2_Pos         (26)                                              /*!< PWM_T::DACTRGEN: CDTRGE2 Position         */
#define PWM_DACTRGEN_CDTRGE2_Msk         (0x1ul << PWM_DACTRGEN_CDTRGE2_Pos)               /*!< PWM_T::DACTRGEN: CDTRGE2 Mask             */

#define PWM_DACTRGEN_CDTRGE3_Pos         (27)                                              /*!< PWM_T::DACTRGEN: CDTRGE3 Position         */
#define PWM_DACTRGEN_CDTRGE3_Msk         (0x1ul << PWM_DACTRGEN_CDTRGE3_Pos)               /*!< PWM_T::DACTRGEN: CDTRGE3 Mask             */

#define PWM_DACTRGEN_CDTRGE4_Pos         (28)                                              /*!< PWM_T::DACTRGEN: CDTRGE4 Position         */
#define PWM_DACTRGEN_CDTRGE4_Msk         (0x1ul << PWM_DACTRGEN_CDTRGE4_Pos)               /*!< PWM_T::DACTRGEN: CDTRGE4 Mask             */

#define PWM_DACTRGEN_CDTRGE5_Pos         (29)                                              /*!< PWM_T::DACTRGEN: CDTRGE5 Position         */
#define PWM_DACTRGEN_CDTRGE5_Msk         (0x1ul << PWM_DACTRGEN_CDTRGE5_Pos)               /*!< PWM_T::DACTRGEN: CDTRGE5 Mask             */

#define PWM_EADCTS0_TRGSEL0_Pos          (0)                                               /*!< PWM_T::EADCTS0: TRGSEL0 Position          */
#define PWM_EADCTS0_TRGSEL0_Msk          (0xful << PWM_EADCTS0_TRGSEL0_Pos)                /*!< PWM_T::EADCTS0: TRGSEL0 Mask              */

#define PWM_EADCTS0_TRGEN0_Pos           (7)                                               /*!< PWM_T::EADCTS0: TRGEN0 Position           */
#define PWM_EADCTS0_TRGEN0_Msk           (0x1ul << PWM_EADCTS0_TRGEN0_Pos)                 /*!< PWM_T::EADCTS0: TRGEN0 Mask               */

#define PWM_EADCTS0_TRGSEL1_Pos          (8)                                               /*!< PWM_T::EADCTS0: TRGSEL1 Position          */
#define PWM_EADCTS0_TRGSEL1_Msk          (0xful << PWM_EADCTS0_TRGSEL1_Pos)                /*!< PWM_T::EADCTS0: TRGSEL1 Mask              */

#define PWM_EADCTS0_TRGEN1_Pos           (15)                                              /*!< PWM_T::EADCTS0: TRGEN1 Position           */
#define PWM_EADCTS0_TRGEN1_Msk           (0x1ul << PWM_EADCTS0_TRGEN1_Pos)                 /*!< PWM_T::EADCTS0: TRGEN1 Mask               */

#define PWM_EADCTS0_TRGSEL2_Pos          (16)                                              /*!< PWM_T::EADCTS0: TRGSEL2 Position          */
#define PWM_EADCTS0_TRGSEL2_Msk          (0xful << PWM_EADCTS0_TRGSEL2_Pos)                /*!< PWM_T::EADCTS0: TRGSEL2 Mask              */

#define PWM_EADCTS0_TRGEN2_Pos           (23)                                              /*!< PWM_T::EADCTS0: TRGEN2 Position           */
#define PWM_EADCTS0_TRGEN2_Msk           (0x1ul << PWM_EADCTS0_TRGEN2_Pos)                 /*!< PWM_T::EADCTS0: TRGEN2 Mask               */

#define PWM_EADCTS0_TRGSEL3_Pos          (24)                                              /*!< PWM_T::EADCTS0: TRGSEL3 Position          */
#define PWM_EADCTS0_TRGSEL3_Msk          (0xful << PWM_EADCTS0_TRGSEL3_Pos)                /*!< PWM_T::EADCTS0: TRGSEL3 Mask              */

#define PWM_EADCTS0_TRGEN3_Pos           (31)                                              /*!< PWM_T::EADCTS0: TRGEN3 Position           */
#define PWM_EADCTS0_TRGEN3_Msk           (0x1ul << PWM_EADCTS0_TRGEN3_Pos)                 /*!< PWM_T::EADCTS0: TRGEN3 Mask               */

#define PWM_EADCTS1_TRGSEL4_Pos          (0)                                               /*!< PWM_T::EADCTS1: TRGSEL4 Position          */
#define PWM_EADCTS1_TRGSEL4_Msk          (0xful << PWM_EADCTS1_TRGSEL4_Pos)                /*!< PWM_T::EADCTS1: TRGSEL4 Mask              */

#define PWM_EADCTS1_TRGEN4_Pos           (7)                                               /*!< PWM_T::EADCTS1: TRGEN4 Position           */
#define PWM_EADCTS1_TRGEN4_Msk           (0x1ul << PWM_EADCTS1_TRGEN4_Pos)                 /*!< PWM_T::EADCTS1: TRGEN4 Mask               */

#define PWM_EADCTS1_TRGSEL5_Pos          (8)                                               /*!< PWM_T::EADCTS1: TRGSEL5 Position          */
#define PWM_EADCTS1_TRGSEL5_Msk          (0xful << PWM_EADCTS1_TRGSEL5_Pos)                /*!< PWM_T::EADCTS1: TRGSEL5 Mask              */

#define PWM_EADCTS1_TRGEN5_Pos           (15)                                              /*!< PWM_T::EADCTS1: TRGEN5 Position           */
#define PWM_EADCTS1_TRGEN5_Msk           (0x1ul << PWM_EADCTS1_TRGEN5_Pos)                 /*!< PWM_T::EADCTS1: TRGEN5 Mask               */

#define PWM_FTCMPDAT0_1_FTCMP_Pos        (0)                                               /*!< PWM_T::FTCMPDAT0_1: FTCMP Position        */
#define PWM_FTCMPDAT0_1_FTCMP_Msk        (0xfffful << PWM_FTCMPDAT0_1_FTCMP_Pos)           /*!< PWM_T::FTCMPDAT0_1: FTCMP Mask            */

#define PWM_FTCMPDAT2_3_FTCMP_Pos        (0)                                               /*!< PWM_T::FTCMPDAT2_3: FTCMP Position        */
#define PWM_FTCMPDAT2_3_FTCMP_Msk        (0xfffful << PWM_FTCMPDAT2_3_FTCMP_Pos)           /*!< PWM_T::FTCMPDAT2_3: FTCMP Mask            */

#define PWM_FTCMPDAT4_5_FTCMP_Pos        (0)                                               /*!< PWM_T::FTCMPDAT4_5: FTCMP Position        */
#define PWM_FTCMPDAT4_5_FTCMP_Msk        (0xfffful << PWM_FTCMPDAT4_5_FTCMP_Pos)           /*!< PWM_T::FTCMPDAT4_5: FTCMP Mask            */

#define PWM_SSCTL_SSENn_Pos              (0)                                               /*!< PWM_T::SSCTL: SSENn Position              */
#define PWM_SSCTL_SSENn_Msk              (0x3ful << PWM_SSCTL_SSENn_Pos)                   /*!< PWM_T::SSCTL: SSENn Mask                  */

#define PWM_SSCTL_SSEN0_Pos              (0)                                               /*!< PWM_T::SSCTL: SSEN0 Position              */
#define PWM_SSCTL_SSEN0_Msk              (0x1ul << PWM_SSCTL_SSEN0_Pos)                    /*!< PWM_T::SSCTL: SSEN0 Mask                  */

#define PWM_SSCTL_SSEN1_Pos              (1)                                               /*!< PWM_T::SSCTL: SSEN1 Position              */
#define PWM_SSCTL_SSEN1_Msk              (0x1ul << PWM_SSCTL_SSEN1_Pos)                    /*!< PWM_T::SSCTL: SSEN1 Mask                  */

#define PWM_SSCTL_SSEN2_Pos              (2)                                               /*!< PWM_T::SSCTL: SSEN2 Position              */
#define PWM_SSCTL_SSEN2_Msk              (0x1ul << PWM_SSCTL_SSEN2_Pos)                    /*!< PWM_T::SSCTL: SSEN2 Mask                  */

#define PWM_SSCTL_SSEN3_Pos              (3)                                               /*!< PWM_T::SSCTL: SSEN3 Position              */
#define PWM_SSCTL_SSEN3_Msk              (0x1ul << PWM_SSCTL_SSEN3_Pos)                    /*!< PWM_T::SSCTL: SSEN3 Mask                  */

#define PWM_SSCTL_SSEN4_Pos              (4)                                               /*!< PWM_T::SSCTL: SSEN4 Position              */
#define PWM_SSCTL_SSEN4_Msk              (0x1ul << PWM_SSCTL_SSEN4_Pos)                    /*!< PWM_T::SSCTL: SSEN4 Mask                  */

#define PWM_SSCTL_SSEN5_Pos              (5)                                               /*!< PWM_T::SSCTL: SSEN5 Position              */
#define PWM_SSCTL_SSEN5_Msk              (0x1ul << PWM_SSCTL_SSEN5_Pos)                    /*!< PWM_T::SSCTL: SSEN5 Mask                  */

#define PWM_SSTRG_CNTSEN_Pos             (0)                                               /*!< PWM_T::SSTRG: CNTSEN Position             */
#define PWM_SSTRG_CNTSEN_Msk             (0x1ul << PWM_SSTRG_CNTSEN_Pos)                   /*!< PWM_T::SSTRG: CNTSEN Mask                 */

#define PWM_STATUS_CNTMAXFn_Pos          (0)                                               /*!< PWM_T::STATUS: CNTMAXFn Position          */
#define PWM_STATUS_CNTMAXFn_Msk          (0x3ful << PWM_STATUS_CNTMAXFn_Pos)               /*!< PWM_T::STATUS: CNTMAXFn Mask              */

#define PWM_STATUS_CNTMAXF0_Pos          (0)                                               /*!< PWM_T::STATUS: CNTMAXF0 Position          */
#define PWM_STATUS_CNTMAXF0_Msk          (0x1ul << PWM_STATUS_CNTMAXF0_Pos)                /*!< PWM_T::STATUS: CNTMAXF0 Mask              */

#define PWM_STATUS_CNTMAXF1_Pos          (1)                                               /*!< PWM_T::STATUS: CNTMAXF1 Position          */
#define PWM_STATUS_CNTMAXF1_Msk          (0x1ul << PWM_STATUS_CNTMAXF1_Pos)                /*!< PWM_T::STATUS: CNTMAXF1 Mask              */

#define PWM_STATUS_CNTMAXF2_Pos          (2)                                               /*!< PWM_T::STATUS: CNTMAXF2 Position          */
#define PWM_STATUS_CNTMAXF2_Msk          (0x1ul << PWM_STATUS_CNTMAXF2_Pos)                /*!< PWM_T::STATUS: CNTMAXF2 Mask              */

#define PWM_STATUS_CNTMAXF3_Pos          (3)                                               /*!< PWM_T::STATUS: CNTMAXF3 Position          */
#define PWM_STATUS_CNTMAXF3_Msk          (0x1ul << PWM_STATUS_CNTMAXF3_Pos)                /*!< PWM_T::STATUS: CNTMAXF3 Mask              */

#define PWM_STATUS_CNTMAXF4_Pos          (4)                                               /*!< PWM_T::STATUS: CNTMAXF4 Position          */
#define PWM_STATUS_CNTMAXF4_Msk          (0x1ul << PWM_STATUS_CNTMAXF4_Pos)                /*!< PWM_T::STATUS: CNTMAXF4 Mask              */

#define PWM_STATUS_CNTMAXF5_Pos          (5)                                               /*!< PWM_T::STATUS: CNTMAXF5 Position          */
#define PWM_STATUS_CNTMAXF5_Msk          (0x1ul << PWM_STATUS_CNTMAXF5_Pos)                /*!< PWM_T::STATUS: CNTMAXF5 Mask              */

#define PWM_STATUS_SYNCINFn_Pos          (8)                                               /*!< PWM_T::STATUS: SYNCINFn Position          */
#define PWM_STATUS_SYNCINFn_Msk          (0x7ul << PWM_STATUS_SYNCINFn_Pos)                /*!< PWM_T::STATUS: SYNCINFn Mask              */

#define PWM_STATUS_SYNCINF0_Pos          (8)                                               /*!< PWM_T::STATUS: SYNCINF0 Position          */
#define PWM_STATUS_SYNCINF0_Msk          (0x1ul << PWM_STATUS_SYNCINF0_Pos)                /*!< PWM_T::STATUS: SYNCINF0 Mask              */

#define PWM_STATUS_SYNCINF2_Pos          (9)                                               /*!< PWM_T::STATUS: SYNCINF2 Position          */
#define PWM_STATUS_SYNCINF2_Msk          (0x1ul << PWM_STATUS_SYNCINF2_Pos)                /*!< PWM_T::STATUS: SYNCINF2 Mask              */

#define PWM_STATUS_SYNCINF4_Pos          (10)                                              /*!< PWM_T::STATUS: SYNCINF4 Position          */
#define PWM_STATUS_SYNCINF4_Msk          (0x1ul << PWM_STATUS_SYNCINF4_Pos)                /*!< PWM_T::STATUS: SYNCINF4 Mask              */

#define PWM_STATUS_ADCTRGFn_Pos          (16)                                              /*!< PWM_T::STATUS: ADCTRGFn Position          */
#define PWM_STATUS_ADCTRGFn_Msk          (0x3ful << PWM_STATUS_ADCTRGFn_Pos)               /*!< PWM_T::STATUS: ADCTRGFn Mask              */

#define PWM_STATUS_ADCTRGF0_Pos          (16)                                              /*!< PWM_T::STATUS: ADCTRGF0 Position          */
#define PWM_STATUS_ADCTRGF0_Msk          (0x1ul << PWM_STATUS_ADCTRGF0_Pos)                /*!< PWM_T::STATUS: ADCTRGF0 Mask              */

#define PWM_STATUS_ADCTRGF1_Pos          (17)                                              /*!< PWM_T::STATUS: ADCTRGF1 Position          */
#define PWM_STATUS_ADCTRGF1_Msk          (0x1ul << PWM_STATUS_ADCTRGF1_Pos)                /*!< PWM_T::STATUS: ADCTRGF1 Mask              */

#define PWM_STATUS_ADCTRGF2_Pos          (18)                                              /*!< PWM_T::STATUS: ADCTRGF2 Position          */
#define PWM_STATUS_ADCTRGF2_Msk          (0x1ul << PWM_STATUS_ADCTRGF2_Pos)                /*!< PWM_T::STATUS: ADCTRGF2 Mask              */

#define PWM_STATUS_ADCTRGF3_Pos          (19)                                              /*!< PWM_T::STATUS: ADCTRGF3 Position          */
#define PWM_STATUS_ADCTRGF3_Msk          (0x1ul << PWM_STATUS_ADCTRGF3_Pos)                /*!< PWM_T::STATUS: ADCTRGF3 Mask              */

#define PWM_STATUS_ADCTRGF4_Pos          (20)                                              /*!< PWM_T::STATUS: ADCTRGF4 Position          */
#define PWM_STATUS_ADCTRGF4_Msk          (0x1ul << PWM_STATUS_ADCTRGF4_Pos)                /*!< PWM_T::STATUS: ADCTRGF4 Mask              */

#define PWM_STATUS_ADCTRGF5_Pos          (21)                                              /*!< PWM_T::STATUS: ADCTRGF5 Position          */
#define PWM_STATUS_ADCTRGF5_Msk          (0x1ul << PWM_STATUS_ADCTRGF5_Pos)                /*!< PWM_T::STATUS: ADCTRGF5 Mask              */

#define PWM_STATUS_DACTRGF_Pos           (24)                                              /*!< PWM_T::STATUS: DACTRGF Position           */
#define PWM_STATUS_DACTRGF_Msk           (0x1ul << PWM_STATUS_DACTRGF_Pos)                 /*!< PWM_T::STATUS: DACTRGF Mask               */

#define PWM_CAPINEN_CAPINENn_Pos         (0)                                               /*!< PWM_T::CAPINEN: CAPINENn Position         */
#define PWM_CAPINEN_CAPINENn_Msk         (0x3ful << PWM_CAPINEN_CAPINENn_Pos)              /*!< PWM_T::CAPINEN: CAPINENn Mask             */

#define PWM_CAPINEN_CAPINEN0_Pos         (0)                                               /*!< PWM_T::CAPINEN: CAPINEN0 Position         */
#define PWM_CAPINEN_CAPINEN0_Msk         (0x1ul << PWM_CAPINEN_CAPINEN0_Pos)               /*!< PWM_T::CAPINEN: CAPINEN0 Mask             */

#define PWM_CAPINEN_CAPINEN1_Pos         (1)                                               /*!< PWM_T::CAPINEN: CAPINEN1 Position         */
#define PWM_CAPINEN_CAPINEN1_Msk         (0x1ul << PWM_CAPINEN_CAPINEN1_Pos)               /*!< PWM_T::CAPINEN: CAPINEN1 Mask             */

#define PWM_CAPINEN_CAPINEN2_Pos         (2)                                               /*!< PWM_T::CAPINEN: CAPINEN2 Position         */
#define PWM_CAPINEN_CAPINEN2_Msk         (0x1ul << PWM_CAPINEN_CAPINEN2_Pos)               /*!< PWM_T::CAPINEN: CAPINEN2 Mask             */

#define PWM_CAPINEN_CAPINEN3_Pos         (3)                                               /*!< PWM_T::CAPINEN: CAPINEN3 Position         */
#define PWM_CAPINEN_CAPINEN3_Msk         (0x1ul << PWM_CAPINEN_CAPINEN3_Pos)               /*!< PWM_T::CAPINEN: CAPINEN3 Mask             */

#define PWM_CAPINEN_CAPINEN4_Pos         (4)                                               /*!< PWM_T::CAPINEN: CAPINEN4 Position         */
#define PWM_CAPINEN_CAPINEN4_Msk         (0x1ul << PWM_CAPINEN_CAPINEN4_Pos)               /*!< PWM_T::CAPINEN: CAPINEN4 Mask             */

#define PWM_CAPINEN_CAPINEN5_Pos         (5)                                               /*!< PWM_T::CAPINEN: CAPINEN5 Position         */
#define PWM_CAPINEN_CAPINEN5_Msk         (0x1ul << PWM_CAPINEN_CAPINEN5_Pos)               /*!< PWM_T::CAPINEN: CAPINEN5 Mask             */

#define PWM_CAPCTL_CAPENn_Pos            (0)                                               /*!< PWM_T::CAPCTL: CAPENn Position            */
#define PWM_CAPCTL_CAPENn_Msk            (0x3ful << PWM_CAPCTL_CAPENn_Pos)                 /*!< PWM_T::CAPCTL: CAPENn Mask                */

#define PWM_CAPCTL_CAPEN0_Pos            (0)                                               /*!< PWM_T::CAPCTL: CAPEN0 Position            */
#define PWM_CAPCTL_CAPEN0_Msk            (0x1ul << PWM_CAPCTL_CAPEN0_Pos)                  /*!< PWM_T::CAPCTL: CAPEN0 Mask                */

#define PWM_CAPCTL_CAPEN1_Pos            (1)                                               /*!< PWM_T::CAPCTL: CAPEN1 Position            */
#define PWM_CAPCTL_CAPEN1_Msk            (0x1ul << PWM_CAPCTL_CAPEN1_Pos)                  /*!< PWM_T::CAPCTL: CAPEN1 Mask                */

#define PWM_CAPCTL_CAPEN2_Pos            (2)                                               /*!< PWM_T::CAPCTL: CAPEN2 Position            */
#define PWM_CAPCTL_CAPEN2_Msk            (0x1ul << PWM_CAPCTL_CAPEN2_Pos)                  /*!< PWM_T::CAPCTL: CAPEN2 Mask                */

#define PWM_CAPCTL_CAPEN3_Pos            (3)                                               /*!< PWM_T::CAPCTL: CAPEN3 Position            */
#define PWM_CAPCTL_CAPEN3_Msk            (0x1ul << PWM_CAPCTL_CAPEN3_Pos)                  /*!< PWM_T::CAPCTL: CAPEN3 Mask                */

#define PWM_CAPCTL_CAPEN4_Pos            (4)                                               /*!< PWM_T::CAPCTL: CAPEN4 Position            */
#define PWM_CAPCTL_CAPEN4_Msk            (0x1ul << PWM_CAPCTL_CAPEN4_Pos)                  /*!< PWM_T::CAPCTL: CAPEN4 Mask                */

#define PWM_CAPCTL_CAPEN5_Pos            (5)                                               /*!< PWM_T::CAPCTL: CAPEN5 Position            */
#define PWM_CAPCTL_CAPEN5_Msk            (0x1ul << PWM_CAPCTL_CAPEN5_Pos)                  /*!< PWM_T::CAPCTL: CAPEN5 Mask                */

#define PWM_CAPCTL_CAPINVn_Pos           (8)                                               /*!< PWM_T::CAPCTL: CAPINVn Position           */
#define PWM_CAPCTL_CAPINVn_Msk           (0x3ful << PWM_CAPCTL_CAPINVn_Pos)                /*!< PWM_T::CAPCTL: CAPINVn Mask               */

#define PWM_CAPCTL_CAPINV0_Pos           (8)                                               /*!< PWM_T::CAPCTL: CAPINV0 Position           */
#define PWM_CAPCTL_CAPINV0_Msk           (0x1ul << PWM_CAPCTL_CAPINV0_Pos)                 /*!< PWM_T::CAPCTL: CAPINV0 Mask               */

#define PWM_CAPCTL_CAPINV1_Pos           (9)                                               /*!< PWM_T::CAPCTL: CAPINV1 Position           */
#define PWM_CAPCTL_CAPINV1_Msk           (0x1ul << PWM_CAPCTL_CAPINV1_Pos)                 /*!< PWM_T::CAPCTL: CAPINV1 Mask               */

#define PWM_CAPCTL_CAPINV2_Pos           (10)                                              /*!< PWM_T::CAPCTL: CAPINV2 Position           */
#define PWM_CAPCTL_CAPINV2_Msk           (0x1ul << PWM_CAPCTL_CAPINV2_Pos)                 /*!< PWM_T::CAPCTL: CAPINV2 Mask               */

#define PWM_CAPCTL_CAPINV3_Pos           (11)                                              /*!< PWM_T::CAPCTL: CAPINV3 Position           */
#define PWM_CAPCTL_CAPINV3_Msk           (0x1ul << PWM_CAPCTL_CAPINV3_Pos)                 /*!< PWM_T::CAPCTL: CAPINV3 Mask               */

#define PWM_CAPCTL_CAPINV4_Pos           (12)                                              /*!< PWM_T::CAPCTL: CAPINV4 Position           */
#define PWM_CAPCTL_CAPINV4_Msk           (0x1ul << PWM_CAPCTL_CAPINV4_Pos)                 /*!< PWM_T::CAPCTL: CAPINV4 Mask               */

#define PWM_CAPCTL_CAPINV5_Pos           (13)                                              /*!< PWM_T::CAPCTL: CAPINV5 Position           */
#define PWM_CAPCTL_CAPINV5_Msk           (0x1ul << PWM_CAPCTL_CAPINV5_Pos)                 /*!< PWM_T::CAPCTL: CAPINV5 Mask               */

#define PWM_CAPCTL_RCRLDENn_Pos          (16)                                              /*!< PWM_T::CAPCTL: RCRLDENn Position          */
#define PWM_CAPCTL_RCRLDENn_Msk          (0x3ful << PWM_CAPCTL_RCRLDENn_Pos)               /*!< PWM_T::CAPCTL: RCRLDENn Mask              */

#define PWM_CAPCTL_RCRLDEN0_Pos          (16)                                              /*!< PWM_T::CAPCTL: RCRLDEN0 Position          */
#define PWM_CAPCTL_RCRLDEN0_Msk          (0x1ul << PWM_CAPCTL_RCRLDEN0_Pos)                /*!< PWM_T::CAPCTL: RCRLDEN0 Mask              */

#define PWM_CAPCTL_RCRLDEN1_Pos          (17)                                              /*!< PWM_T::CAPCTL: RCRLDEN1 Position          */
#define PWM_CAPCTL_RCRLDEN1_Msk          (0x1ul << PWM_CAPCTL_RCRLDEN1_Pos)                /*!< PWM_T::CAPCTL: RCRLDEN1 Mask              */

#define PWM_CAPCTL_RCRLDEN2_Pos          (18)                                              /*!< PWM_T::CAPCTL: RCRLDEN2 Position          */
#define PWM_CAPCTL_RCRLDEN2_Msk          (0x1ul << PWM_CAPCTL_RCRLDEN2_Pos)                /*!< PWM_T::CAPCTL: RCRLDEN2 Mask              */

#define PWM_CAPCTL_RCRLDEN3_Pos          (19)                                              /*!< PWM_T::CAPCTL: RCRLDEN3 Position          */
#define PWM_CAPCTL_RCRLDEN3_Msk          (0x1ul << PWM_CAPCTL_RCRLDEN3_Pos)                /*!< PWM_T::CAPCTL: RCRLDEN3 Mask              */

#define PWM_CAPCTL_RCRLDEN4_Pos          (20)                                              /*!< PWM_T::CAPCTL: RCRLDEN4 Position          */
#define PWM_CAPCTL_RCRLDEN4_Msk          (0x1ul << PWM_CAPCTL_RCRLDEN4_Pos)                /*!< PWM_T::CAPCTL: RCRLDEN4 Mask              */

#define PWM_CAPCTL_RCRLDEN5_Pos          (21)                                              /*!< PWM_T::CAPCTL: RCRLDEN5 Position          */
#define PWM_CAPCTL_RCRLDEN5_Msk          (0x1ul << PWM_CAPCTL_RCRLDEN5_Pos)                /*!< PWM_T::CAPCTL: RCRLDEN5 Mask              */

#define PWM_CAPCTL_FCRLDENn_Pos          (24)                                              /*!< PWM_T::CAPCTL: FCRLDENn Position          */
#define PWM_CAPCTL_FCRLDENn_Msk          (0x3ful << PWM_CAPCTL_FCRLDENn_Pos)               /*!< PWM_T::CAPCTL: FCRLDENn Mask              */

#define PWM_CAPCTL_FCRLDEN0_Pos          (24)                                              /*!< PWM_T::CAPCTL: FCRLDEN0 Position          */
#define PWM_CAPCTL_FCRLDEN0_Msk          (0x1ul << PWM_CAPCTL_FCRLDEN0_Pos)                /*!< PWM_T::CAPCTL: FCRLDEN0 Mask              */

#define PWM_CAPCTL_FCRLDEN1_Pos          (25)                                              /*!< PWM_T::CAPCTL: FCRLDEN1 Position          */
#define PWM_CAPCTL_FCRLDEN1_Msk          (0x1ul << PWM_CAPCTL_FCRLDEN1_Pos)                /*!< PWM_T::CAPCTL: FCRLDEN1 Mask              */

#define PWM_CAPCTL_FCRLDEN2_Pos          (26)                                              /*!< PWM_T::CAPCTL: FCRLDEN2 Position          */
#define PWM_CAPCTL_FCRLDEN2_Msk          (0x1ul << PWM_CAPCTL_FCRLDEN2_Pos)                /*!< PWM_T::CAPCTL: FCRLDEN2 Mask              */

#define PWM_CAPCTL_FCRLDEN3_Pos          (27)                                              /*!< PWM_T::CAPCTL: FCRLDEN3 Position          */
#define PWM_CAPCTL_FCRLDEN3_Msk          (0x1ul << PWM_CAPCTL_FCRLDEN3_Pos)                /*!< PWM_T::CAPCTL: FCRLDEN3 Mask              */

#define PWM_CAPCTL_FCRLDEN4_Pos          (28)                                              /*!< PWM_T::CAPCTL: FCRLDEN4 Position          */
#define PWM_CAPCTL_FCRLDEN4_Msk          (0x1ul << PWM_CAPCTL_FCRLDEN4_Pos)                /*!< PWM_T::CAPCTL: FCRLDEN4 Mask              */

#define PWM_CAPCTL_FCRLDEN5_Pos          (29)                                              /*!< PWM_T::CAPCTL: FCRLDEN5 Position          */
#define PWM_CAPCTL_FCRLDEN5_Msk          (0x1ul << PWM_CAPCTL_FCRLDEN5_Pos)                /*!< PWM_T::CAPCTL: FCRLDEN5 Mask              */

#define PWM_CAPSTS_CRLIFOVn_Pos          (0)                                               /*!< PWM_T::CAPSTS: CRLIFOVn Position          */
#define PWM_CAPSTS_CRLIFOVn_Msk          (0x3ful << PWM_CAPSTS_CRLIFOVn_Pos)               /*!< PWM_T::CAPSTS: CRLIFOVn Mask              */

#define PWM_CAPSTS_CRLIFOV0_Pos          (0)                                               /*!< PWM_T::CAPSTS: CRLIFOV0 Position          */
#define PWM_CAPSTS_CRLIFOV0_Msk          (0x1ul << PWM_CAPSTS_CRLIFOV0_Pos)                /*!< PWM_T::CAPSTS: CRLIFOV0 Mask              */

#define PWM_CAPSTS_CRLIFOV1_Pos          (1)                                               /*!< PWM_T::CAPSTS: CRLIFOV1 Position          */
#define PWM_CAPSTS_CRLIFOV1_Msk          (0x1ul << PWM_CAPSTS_CRLIFOV1_Pos)                /*!< PWM_T::CAPSTS: CRLIFOV1 Mask              */

#define PWM_CAPSTS_CRLIFOV2_Pos          (2)                                               /*!< PWM_T::CAPSTS: CRLIFOV2 Position          */
#define PWM_CAPSTS_CRLIFOV2_Msk          (0x1ul << PWM_CAPSTS_CRLIFOV2_Pos)                /*!< PWM_T::CAPSTS: CRLIFOV2 Mask              */

#define PWM_CAPSTS_CRLIFOV3_Pos          (3)                                               /*!< PWM_T::CAPSTS: CRLIFOV3 Position          */
#define PWM_CAPSTS_CRLIFOV3_Msk          (0x1ul << PWM_CAPSTS_CRLIFOV3_Pos)                /*!< PWM_T::CAPSTS: CRLIFOV3 Mask              */

#define PWM_CAPSTS_CRLIFOV4_Pos          (4)                                               /*!< PWM_T::CAPSTS: CRLIFOV4 Position          */
#define PWM_CAPSTS_CRLIFOV4_Msk          (0x1ul << PWM_CAPSTS_CRLIFOV4_Pos)                /*!< PWM_T::CAPSTS: CRLIFOV4 Mask              */

#define PWM_CAPSTS_CRLIFOV5_Pos          (5)                                               /*!< PWM_T::CAPSTS: CRLIFOV5 Position          */
#define PWM_CAPSTS_CRLIFOV5_Msk          (0x1ul << PWM_CAPSTS_CRLIFOV5_Pos)                /*!< PWM_T::CAPSTS: CRLIFOV5 Mask              */

#define PWM_CAPSTS_CFLIFOVn_Pos          (8)                                               /*!< PWM_T::CAPSTS: CFLIFOVn Position          */
#define PWM_CAPSTS_CFLIFOVn_Msk          (0x3ful << PWM_CAPSTS_CFLIFOVn_Pos)               /*!< PWM_T::CAPSTS: CFLIFOVn Mask              */

#define PWM_CAPSTS_CFLIFOV0_Pos          (8)                                               /*!< PWM_T::CAPSTS: CFLIFOV0 Position          */
#define PWM_CAPSTS_CFLIFOV0_Msk          (0x1ul << PWM_CAPSTS_CFLIFOV0_Pos)                /*!< PWM_T::CAPSTS: CFLIFOV0 Mask              */

#define PWM_CAPSTS_CFLIFOV1_Pos          (9)                                               /*!< PWM_T::CAPSTS: CFLIFOV1 Position          */
#define PWM_CAPSTS_CFLIFOV1_Msk          (0x1ul << PWM_CAPSTS_CFLIFOV1_Pos)                /*!< PWM_T::CAPSTS: CFLIFOV1 Mask              */

#define PWM_CAPSTS_CFLIFOV2_Pos          (10)                                              /*!< PWM_T::CAPSTS: CFLIFOV2 Position          */
#define PWM_CAPSTS_CFLIFOV2_Msk          (0x1ul << PWM_CAPSTS_CFLIFOV2_Pos)                /*!< PWM_T::CAPSTS: CFLIFOV2 Mask              */

#define PWM_CAPSTS_CFLIFOV3_Pos          (11)                                              /*!< PWM_T::CAPSTS: CFLIFOV3 Position          */
#define PWM_CAPSTS_CFLIFOV3_Msk          (0x1ul << PWM_CAPSTS_CFLIFOV3_Pos)                /*!< PWM_T::CAPSTS: CFLIFOV3 Mask              */

#define PWM_CAPSTS_CFLIFOV4_Pos          (12)                                              /*!< PWM_T::CAPSTS: CFLIFOV4 Position          */
#define PWM_CAPSTS_CFLIFOV4_Msk          (0x1ul << PWM_CAPSTS_CFLIFOV4_Pos)                /*!< PWM_T::CAPSTS: CFLIFOV4 Mask              */

#define PWM_CAPSTS_CFLIFOV5_Pos          (13)                                              /*!< PWM_T::CAPSTS: CFLIFOV5 Position          */
#define PWM_CAPSTS_CFLIFOV5_Msk          (0x1ul << PWM_CAPSTS_CFLIFOV5_Pos)                /*!< PWM_T::CAPSTS: CFLIFOV5 Mask              */

#define PWM_RCAPDAT0_RCAPDAT_Pos         (0)                                               /*!< PWM_T::RCAPDAT0: RCAPDAT Position         */
#define PWM_RCAPDAT0_RCAPDAT_Msk         (0xfffful << PWM_RCAPDAT0_RCAPDAT_Pos)            /*!< PWM_T::RCAPDAT0: RCAPDAT Mask             */

#define PWM_FCAPDAT0_FCAPDAT_Pos         (0)                                               /*!< PWM_T::FCAPDAT0: FCAPDAT Position         */
#define PWM_FCAPDAT0_FCAPDAT_Msk         (0xfffful << PWM_FCAPDAT0_FCAPDAT_Pos)            /*!< PWM_T::FCAPDAT0: FCAPDAT Mask             */

#define PWM_RCAPDAT1_RCAPDAT_Pos         (0)                                               /*!< PWM_T::RCAPDAT1: RCAPDAT Position         */
#define PWM_RCAPDAT1_RCAPDAT_Msk         (0xfffful << PWM_RCAPDAT1_RCAPDAT_Pos)            /*!< PWM_T::RCAPDAT1: RCAPDAT Mask             */

#define PWM_FCAPDAT1_FCAPDAT_Pos         (0)                                               /*!< PWM_T::FCAPDAT1: FCAPDAT Position         */
#define PWM_FCAPDAT1_FCAPDAT_Msk         (0xfffful << PWM_FCAPDAT1_FCAPDAT_Pos)            /*!< PWM_T::FCAPDAT1: FCAPDAT Mask             */

#define PWM_RCAPDAT2_RCAPDAT_Pos         (0)                                               /*!< PWM_T::RCAPDAT2: RCAPDAT Position         */
#define PWM_RCAPDAT2_RCAPDAT_Msk         (0xfffful << PWM_RCAPDAT2_RCAPDAT_Pos)            /*!< PWM_T::RCAPDAT2: RCAPDAT Mask             */

#define PWM_FCAPDAT2_FCAPDAT_Pos         (0)                                               /*!< PWM_T::FCAPDAT2: FCAPDAT Position         */
#define PWM_FCAPDAT2_FCAPDAT_Msk         (0xfffful << PWM_FCAPDAT2_FCAPDAT_Pos)            /*!< PWM_T::FCAPDAT2: FCAPDAT Mask             */

#define PWM_RCAPDAT3_RCAPDAT_Pos         (0)                                               /*!< PWM_T::RCAPDAT3: RCAPDAT Position         */
#define PWM_RCAPDAT3_RCAPDAT_Msk         (0xfffful << PWM_RCAPDAT3_RCAPDAT_Pos)            /*!< PWM_T::RCAPDAT3: RCAPDAT Mask             */

#define PWM_FCAPDAT3_FCAPDAT_Pos         (0)                                               /*!< PWM_T::FCAPDAT3: FCAPDAT Position         */
#define PWM_FCAPDAT3_FCAPDAT_Msk         (0xfffful << PWM_FCAPDAT3_FCAPDAT_Pos)            /*!< PWM_T::FCAPDAT3: FCAPDAT Mask             */

#define PWM_RCAPDAT4_RCAPDAT_Pos         (0)                                               /*!< PWM_T::RCAPDAT4: RCAPDAT Position         */
#define PWM_RCAPDAT4_RCAPDAT_Msk         (0xfffful << PWM_RCAPDAT4_RCAPDAT_Pos)            /*!< PWM_T::RCAPDAT4: RCAPDAT Mask             */

#define PWM_FCAPDAT4_FCAPDAT_Pos         (0)                                               /*!< PWM_T::FCAPDAT4: FCAPDAT Position         */
#define PWM_FCAPDAT4_FCAPDAT_Msk         (0xfffful << PWM_FCAPDAT4_FCAPDAT_Pos)            /*!< PWM_T::FCAPDAT4: FCAPDAT Mask             */

#define PWM_RCAPDAT5_RCAPDAT_Pos         (0)                                               /*!< PWM_T::RCAPDAT5: RCAPDAT Position         */
#define PWM_RCAPDAT5_RCAPDAT_Msk         (0xfffful << PWM_RCAPDAT5_RCAPDAT_Pos)            /*!< PWM_T::RCAPDAT5: RCAPDAT Mask             */

#define PWM_FCAPDAT5_FCAPDAT_Pos         (0)                                               /*!< PWM_T::FCAPDAT5: FCAPDAT Position         */
#define PWM_FCAPDAT5_FCAPDAT_Msk         (0xfffful << PWM_FCAPDAT5_FCAPDAT_Pos)            /*!< PWM_T::FCAPDAT5: FCAPDAT Mask             */

#define PWM_PDMACTL_CHEN0_1_Pos          (0)                                               /*!< PWM_T::PDMACTL: CHEN0_1 Position          */
#define PWM_PDMACTL_CHEN0_1_Msk          (0x1ul << PWM_PDMACTL_CHEN0_1_Pos)                /*!< PWM_T::PDMACTL: CHEN0_1 Mask              */

#define PWM_PDMACTL_CAPMOD0_1_Pos        (1)                                               /*!< PWM_T::PDMACTL: CAPMOD0_1 Position        */
#define PWM_PDMACTL_CAPMOD0_1_Msk        (0x3ul << PWM_PDMACTL_CAPMOD0_1_Pos)              /*!< PWM_T::PDMACTL: CAPMOD0_1 Mask            */

#define PWM_PDMACTL_CAPORD0_1_Pos        (3)                                               /*!< PWM_T::PDMACTL: CAPORD0_1 Position        */
#define PWM_PDMACTL_CAPORD0_1_Msk        (0x1ul << PWM_PDMACTL_CAPORD0_1_Pos)              /*!< PWM_T::PDMACTL: CAPORD0_1 Mask            */

#define PWM_PDMACTL_CHSEL0_1_Pos         (4)                                               /*!< PWM_T::PDMACTL: CHSEL0_1 Position         */
#define PWM_PDMACTL_CHSEL0_1_Msk         (0x1ul << PWM_PDMACTL_CHSEL0_1_Pos)               /*!< PWM_T::PDMACTL: CHSEL0_1 Mask             */

#define PWM_PDMACTL_CHEN2_3_Pos          (8)                                               /*!< PWM_T::PDMACTL: CHEN2_3 Position          */
#define PWM_PDMACTL_CHEN2_3_Msk          (0x1ul << PWM_PDMACTL_CHEN2_3_Pos)                /*!< PWM_T::PDMACTL: CHEN2_3 Mask              */

#define PWM_PDMACTL_CAPMOD2_3_Pos        (9)                                               /*!< PWM_T::PDMACTL: CAPMOD2_3 Position        */
#define PWM_PDMACTL_CAPMOD2_3_Msk        (0x3ul << PWM_PDMACTL_CAPMOD2_3_Pos)              /*!< PWM_T::PDMACTL: CAPMOD2_3 Mask            */

#define PWM_PDMACTL_CAPORD2_3_Pos        (11)                                              /*!< PWM_T::PDMACTL: CAPORD2_3 Position        */
#define PWM_PDMACTL_CAPORD2_3_Msk        (0x1ul << PWM_PDMACTL_CAPORD2_3_Pos)              /*!< PWM_T::PDMACTL: CAPORD2_3 Mask            */

#define PWM_PDMACTL_CHSEL2_3_Pos         (12)                                              /*!< PWM_T::PDMACTL: CHSEL2_3 Position         */
#define PWM_PDMACTL_CHSEL2_3_Msk         (0x1ul << PWM_PDMACTL_CHSEL2_3_Pos)               /*!< PWM_T::PDMACTL: CHSEL2_3 Mask             */

#define PWM_PDMACTL_CHEN4_5_Pos          (16)                                              /*!< PWM_T::PDMACTL: CHEN4_5 Position          */
#define PWM_PDMACTL_CHEN4_5_Msk          (0x1ul << PWM_PDMACTL_CHEN4_5_Pos)                /*!< PWM_T::PDMACTL: CHEN4_5 Mask              */

#define PWM_PDMACTL_CAPMOD4_5_Pos        (17)                                              /*!< PWM_T::PDMACTL: CAPMOD4_5 Position        */
#define PWM_PDMACTL_CAPMOD4_5_Msk        (0x3ul << PWM_PDMACTL_CAPMOD4_5_Pos)              /*!< PWM_T::PDMACTL: CAPMOD4_5 Mask            */

#define PWM_PDMACTL_CAPORD4_5_Pos        (19)                                              /*!< PWM_T::PDMACTL: CAPORD4_5 Position        */
#define PWM_PDMACTL_CAPORD4_5_Msk        (0x1ul << PWM_PDMACTL_CAPORD4_5_Pos)              /*!< PWM_T::PDMACTL: CAPORD4_5 Mask            */

#define PWM_PDMACTL_CHSEL4_5_Pos         (20)                                              /*!< PWM_T::PDMACTL: CHSEL4_5 Position         */
#define PWM_PDMACTL_CHSEL4_5_Msk         (0x1ul << PWM_PDMACTL_CHSEL4_5_Pos)               /*!< PWM_T::PDMACTL: CHSEL4_5 Mask             */

#define PWM_PDMACAP0_1_CAPBUF_Pos        (0)                                               /*!< PWM_T::PDMACAP0_1: CAPBUF Position        */
#define PWM_PDMACAP0_1_CAPBUF_Msk        (0xfffful << PWM_PDMACAP0_1_CAPBUF_Pos)           /*!< PWM_T::PDMACAP0_1: CAPBUF Mask            */

#define PWM_PDMACAP2_3_CAPBUF_Pos        (0)                                               /*!< PWM_T::PDMACAP2_3: CAPBUF Position        */
#define PWM_PDMACAP2_3_CAPBUF_Msk        (0xfffful << PWM_PDMACAP2_3_CAPBUF_Pos)           /*!< PWM_T::PDMACAP2_3: CAPBUF Mask            */

#define PWM_PDMACAP4_5_CAPBUF_Pos        (0)                                               /*!< PWM_T::PDMACAP4_5: CAPBUF Position        */
#define PWM_PDMACAP4_5_CAPBUF_Msk        (0xfffful << PWM_PDMACAP4_5_CAPBUF_Pos)           /*!< PWM_T::PDMACAP4_5: CAPBUF Mask            */

#define PWM_CAPIEN_CAPRIENn_Pos          (0)                                               /*!< PWM_T::CAPIEN: CAPRIENn Position          */
#define PWM_CAPIEN_CAPRIENn_Msk          (0x3ful << PWM_CAPIEN_CAPRIENn_Pos)               /*!< PWM_T::CAPIEN: CAPRIENn Mask              */

#define PWM_CAPIEN_CAPRIEN0_Pos          (0)                                               /*!< PWM_T::CAPIEN: CAPRIEN0 Position          */
#define PWM_CAPIEN_CAPRIEN0_Msk          (0x1ul << PWM_CAPIEN_CAPRIEN0_Pos)                /*!< PWM_T::CAPIEN: CAPRIEN0 Mask              */

#define PWM_CAPIEN_CAPRIEN1_Pos          (1)                                               /*!< PWM_T::CAPIEN: CAPRIEN1 Position          */
#define PWM_CAPIEN_CAPRIEN1_Msk          (0x1ul << PWM_CAPIEN_CAPRIEN1_Pos)                /*!< PWM_T::CAPIEN: CAPRIEN1 Mask              */

#define PWM_CAPIEN_CAPRIEN2_Pos          (2)                                               /*!< PWM_T::CAPIEN: CAPRIEN2 Position          */
#define PWM_CAPIEN_CAPRIEN2_Msk          (0x1ul << PWM_CAPIEN_CAPRIEN2_Pos)                /*!< PWM_T::CAPIEN: CAPRIEN2 Mask              */

#define PWM_CAPIEN_CAPRIEN3_Pos          (3)                                               /*!< PWM_T::CAPIEN: CAPRIEN3 Position          */
#define PWM_CAPIEN_CAPRIEN3_Msk          (0x1ul << PWM_CAPIEN_CAPRIEN3_Pos)                /*!< PWM_T::CAPIEN: CAPRIEN3 Mask              */

#define PWM_CAPIEN_CAPRIEN4_Pos          (4)                                               /*!< PWM_T::CAPIEN: CAPRIEN4 Position          */
#define PWM_CAPIEN_CAPRIEN4_Msk          (0x1ul << PWM_CAPIEN_CAPRIEN4_Pos)                /*!< PWM_T::CAPIEN: CAPRIEN4 Mask              */

#define PWM_CAPIEN_CAPRIEN5_Pos          (5)                                               /*!< PWM_T::CAPIEN: CAPRIEN5 Position          */
#define PWM_CAPIEN_CAPRIEN5_Msk          (0x1ul << PWM_CAPIEN_CAPRIEN5_Pos)                /*!< PWM_T::CAPIEN: CAPRIEN5 Mask              */

#define PWM_CAPIEN_CAPFIENn_Pos          (8)                                               /*!< PWM_T::CAPIEN: CAPFIENn Position          */
#define PWM_CAPIEN_CAPFIENn_Msk          (0x3ful << PWM_CAPIEN_CAPFIENn_Pos)               /*!< PWM_T::CAPIEN: CAPFIENn Mask              */

#define PWM_CAPIEN_CAPFIEN0_Pos          (8)                                               /*!< PWM_T::CAPIEN: CAPFIEN0 Position          */
#define PWM_CAPIEN_CAPFIEN0_Msk          (0x1ul << PWM_CAPIEN_CAPFIEN0_Pos)                /*!< PWM_T::CAPIEN: CAPFIEN0 Mask              */

#define PWM_CAPIEN_CAPFIEN1_Pos          (9)                                               /*!< PWM_T::CAPIEN: CAPFIEN1 Position          */
#define PWM_CAPIEN_CAPFIEN1_Msk          (0x1ul << PWM_CAPIEN_CAPFIEN1_Pos)                /*!< PWM_T::CAPIEN: CAPFIEN1 Mask              */

#define PWM_CAPIEN_CAPFIEN2_Pos          (10)                                              /*!< PWM_T::CAPIEN: CAPFIEN2 Position          */
#define PWM_CAPIEN_CAPFIEN2_Msk          (0x1ul << PWM_CAPIEN_CAPFIEN2_Pos)                /*!< PWM_T::CAPIEN: CAPFIEN2 Mask              */

#define PWM_CAPIEN_CAPFIEN3_Pos          (11)                                              /*!< PWM_T::CAPIEN: CAPFIEN3 Position          */
#define PWM_CAPIEN_CAPFIEN3_Msk          (0x1ul << PWM_CAPIEN_CAPFIEN3_Pos)                /*!< PWM_T::CAPIEN: CAPFIEN3 Mask              */

#define PWM_CAPIEN_CAPFIEN4_Pos          (12)                                              /*!< PWM_T::CAPIEN: CAPFIEN4 Position          */
#define PWM_CAPIEN_CAPFIEN4_Msk          (0x1ul << PWM_CAPIEN_CAPFIEN4_Pos)                /*!< PWM_T::CAPIEN: CAPFIEN4 Mask              */

#define PWM_CAPIEN_CAPFIEN5_Pos          (13)                                              /*!< PWM_T::CAPIEN: CAPFIEN5 Position          */
#define PWM_CAPIEN_CAPFIEN5_Msk          (0x1ul << PWM_CAPIEN_CAPFIEN5_Pos)                /*!< PWM_T::CAPIEN: CAPFIEN5 Mask              */

#define PWM_CAPIF_CRLIFn_Pos             (0)                                               /*!< PWM_T::CAPIF: CRLIFn Position             */
#define PWM_CAPIF_CRLIFn_Msk             (0x3ful << PWM_CAPIF_CRLIFn_Pos)                  /*!< PWM_T::CAPIF: CRLIFn Mask                 */

#define PWM_CAPIF_CRLIF0_Pos             (0)                                               /*!< PWM_T::CAPIF: CRLIF0 Position             */
#define PWM_CAPIF_CRLIF0_Msk             (0x1ul << PWM_CAPIF_CRLIF0_Pos)                   /*!< PWM_T::CAPIF: CRLIF0 Mask                 */

#define PWM_CAPIF_CRLIF1_Pos             (1)                                               /*!< PWM_T::CAPIF: CRLIF1 Position             */
#define PWM_CAPIF_CRLIF1_Msk             (0x1ul << PWM_CAPIF_CRLIF1_Pos)                   /*!< PWM_T::CAPIF: CRLIF1 Mask                 */

#define PWM_CAPIF_CRLIF2_Pos             (2)                                               /*!< PWM_T::CAPIF: CRLIF2 Position             */
#define PWM_CAPIF_CRLIF2_Msk             (0x1ul << PWM_CAPIF_CRLIF2_Pos)                   /*!< PWM_T::CAPIF: CRLIF2 Mask                 */

#define PWM_CAPIF_CRLIF3_Pos             (3)                                               /*!< PWM_T::CAPIF: CRLIF3 Position             */
#define PWM_CAPIF_CRLIF3_Msk             (0x1ul << PWM_CAPIF_CRLIF3_Pos)                   /*!< PWM_T::CAPIF: CRLIF3 Mask                 */

#define PWM_CAPIF_CRLIF4_Pos             (4)                                               /*!< PWM_T::CAPIF: CRLIF4 Position             */
#define PWM_CAPIF_CRLIF4_Msk             (0x1ul << PWM_CAPIF_CRLIF4_Pos)                   /*!< PWM_T::CAPIF: CRLIF4 Mask                 */

#define PWM_CAPIF_CRLIF5_Pos             (5)                                               /*!< PWM_T::CAPIF: CRLIF5 Position             */
#define PWM_CAPIF_CRLIF5_Msk             (0x1ul << PWM_CAPIF_CRLIF5_Pos)                   /*!< PWM_T::CAPIF: CRLIF5 Mask                 */

#define PWM_CAPIF_CFLIFn_Pos             (8)                                               /*!< PWM_T::CAPIF: CFLIFn Position             */
#define PWM_CAPIF_CFLIFn_Msk             (0x3ful << PWM_CAPIF_CFLIFn_Pos)                  /*!< PWM_T::CAPIF: CFLIFn Mask                 */

#define PWM_CAPIF_CFLIF0_Pos             (8)                                               /*!< PWM_T::CAPIF: CFLIF0 Position             */
#define PWM_CAPIF_CFLIF0_Msk             (0x1ul << PWM_CAPIF_CFLIF0_Pos)                   /*!< PWM_T::CAPIF: CFLIF0 Mask                 */

#define PWM_CAPIF_CFLIF1_Pos             (9)                                               /*!< PWM_T::CAPIF: CFLIF1 Position             */
#define PWM_CAPIF_CFLIF1_Msk             (0x1ul << PWM_CAPIF_CFLIF1_Pos)                   /*!< PWM_T::CAPIF: CFLIF1 Mask                 */

#define PWM_CAPIF_CFLIF2_Pos             (10)                                              /*!< PWM_T::CAPIF: CFLIF2 Position             */
#define PWM_CAPIF_CFLIF2_Msk             (0x1ul << PWM_CAPIF_CFLIF2_Pos)                   /*!< PWM_T::CAPIF: CFLIF2 Mask                 */

#define PWM_CAPIF_CFLIF3_Pos             (11)                                              /*!< PWM_T::CAPIF: CFLIF3 Position             */
#define PWM_CAPIF_CFLIF3_Msk             (0x1ul << PWM_CAPIF_CFLIF3_Pos)                   /*!< PWM_T::CAPIF: CFLIF3 Mask                 */

#define PWM_CAPIF_CFLIF4_Pos             (12)                                              /*!< PWM_T::CAPIF: CFLIF4 Position             */
#define PWM_CAPIF_CFLIF4_Msk             (0x1ul << PWM_CAPIF_CFLIF4_Pos)                   /*!< PWM_T::CAPIF: CFLIF4 Mask                 */

#define PWM_CAPIF_CFLIF5_Pos             (13)                                              /*!< PWM_T::CAPIF: CFLIF5 Position             */
#define PWM_CAPIF_CFLIF5_Msk             (0x1ul << PWM_CAPIF_CFLIF5_Pos)                   /*!< PWM_T::CAPIF: CFLIF5 Mask                 */

#define PWM_PBUF_PBUF_Pos                (0)                                               /*!< PWM_T::PBUF: PBUF Position                */
#define PWM_PBUF_PBUF_Msk                (0xfffful << PWM_PBUF_PBUF_Pos)                   /*!< PWM_T::PBUF: PBUF Mask                    */

#define PWM_CMPBUF_CMPBUF_Pos            (0)                                               /*!< PWM_T::CMPBUF: CMPBUF Position            */
#define PWM_CMPBUF_CMPBUF_Msk            (0xfffful << PWM_CMPBUF_CMPBUF_Pos)               /*!< PWM_T::CMPBUF: CMPBUF Mask                */

#define PWM_FTCBUF0_1_FTCMPBUF_Pos       (0)                                               /*!< PWM_T::FTCBUF0_1: FTCMPBUF Position       */
#define PWM_FTCBUF0_1_FTCMPBUF_Msk       (0xfffful << PWM_FTCBUF0_1_FTCMPBUF_Pos)          /*!< PWM_T::FTCBUF0_1: FTCMPBUF Mask           */

#define PWM_FTCBUF2_3_FTCMPBUF_Pos       (0)                                               /*!< PWM_T::FTCBUF2_3: FTCMPBUF Position       */
#define PWM_FTCBUF2_3_FTCMPBUF_Msk       (0xfffful << PWM_FTCBUF2_3_FTCMPBUF_Pos)          /*!< PWM_T::FTCBUF2_3: FTCMPBUF Mask           */

#define PWM_FTCBUF4_5_FTCMPBUF_Pos       (0)                                               /*!< PWM_T::FTCBUF4_5: FTCMPBUF Position       */
#define PWM_FTCBUF4_5_FTCMPBUF_Msk       (0xfffful << PWM_FTCBUF4_5_FTCMPBUF_Pos)          /*!< PWM_T::FTCBUF4_5: FTCMPBUF Mask           */

#define PWM_FTCI_FTCMUn_Pos              (0)                                               /*!< PWM_T::FTCI: FTCMUn Position              */
#define PWM_FTCI_FTCMUn_Msk              (0x7ul << PWM_FTCI_FTCMUn_Pos)                    /*!< PWM_T::FTCI: FTCMUn Mask                  */

#define PWM_FTCI_FTCMU0_Pos              (0)                                               /*!< PWM_T::FTCI: FTCMU0 Position              */
#define PWM_FTCI_FTCMU0_Msk              (0x1ul << PWM_FTCI_FTCMU0_Pos)                    /*!< PWM_T::FTCI: FTCMU0 Mask                  */

#define PWM_FTCI_FTCMU2_Pos              (1)                                               /*!< PWM_T::FTCI: FTCMU2 Position              */
#define PWM_FTCI_FTCMU2_Msk              (0x1ul << PWM_FTCI_FTCMU2_Pos)                    /*!< PWM_T::FTCI: FTCMU2 Mask                  */

#define PWM_FTCI_FTCMU4_Pos              (2)                                               /*!< PWM_T::FTCI: FTCMU4 Position              */
#define PWM_FTCI_FTCMU4_Msk              (0x1ul << PWM_FTCI_FTCMU4_Pos)                    /*!< PWM_T::FTCI: FTCMU4 Mask                  */

#define PWM_FTCI_FTCMDn_Pos              (8)                                               /*!< PWM_T::FTCI: FTCMDn Position              */
#define PWM_FTCI_FTCMDn_Msk              (0x7ul << PWM_FTCI_FTCMDn_Pos)                    /*!< PWM_T::FTCI: FTCMDn Mask                  */

#define PWM_FTCI_FTCMD0_Pos              (8)                                               /*!< PWM_T::FTCI: FTCMD0 Position              */
#define PWM_FTCI_FTCMD0_Msk              (0x1ul << PWM_FTCI_FTCMD0_Pos)                    /*!< PWM_T::FTCI: FTCMD0 Mask                  */

#define PWM_FTCI_FTCMD2_Pos              (9)                                               /*!< PWM_T::FTCI: FTCMD2 Position              */
#define PWM_FTCI_FTCMD2_Msk              (0x1ul << PWM_FTCI_FTCMD2_Pos)                    /*!< PWM_T::FTCI: FTCMD2 Mask                  */

#define PWM_FTCI_FTCMD4_Pos              (10)                                              /*!< PWM_T::FTCI: FTCMD4 Position              */
#define PWM_FTCI_FTCMD4_Msk              (0x1ul << PWM_FTCI_FTCMD4_Pos)                    /*!< PWM_T::FTCI: FTCMD4 Mask                  */

/**@}*/ /* PWM_CONST */
/**@}*/ /* end of PWM register group */


/*---------------------- Real Time Clock Controller -------------------------*/
/**
    @addtogroup RTC Real Time Clock Controller(RTC)
    Memory Mapped Structure for RTC Controller
@{ */


typedef struct
{




/**
 * @var RTC_T::INIT
 * Offset: 0x00  RTC Initiation Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |INIT[0]/ACTIVE|RTC Active Status (Read Only)
 * |        |          |0 = RTC is at reset state.
 * |        |          |1 = RTC is at normal active state.
 * |[31:1]  |INIT[31:1]|RTC Initiation
 * |        |          |When RTC block is powered on, RTC is at reset state.
 * |        |          |User has to write a number (0x a5eb1357) to INIT to make RTC leaving reset state.
 * |        |          |Once the INIT is written as 0xa5eb1357, the RTC will be in un-reset state permanently.
 * |        |          |The INIT is a write-only field and read value will be always 0.
 * @var RTC_T::RWEN
 * Offset: 0x04  RTC Access Enable Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |RWEN      |RTC Register Access Enable Password (Write Only)
 * |        |          |Writing 0xA965 to this register will enable RTC access and keep 1024 RTC clock.
 * |[16]    |RWENF     |RTC Register Access Enable Flag (Read Only)
 * |        |          |0 = RTC register read/write Disabled.
 * |        |          |1 = RTC register read/write Enabled.
 * |        |          |This bit will be set after RTC_RWEN[15:0] register is load a 0xA965, and be cleared automatically after 1024 RTC clock.
 * @var RTC_T::FREQADJ
 * Offset: 0x08  RTC Frequency Compensation Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[5:0]   |FRACTION  |Fraction Part
 * |        |          |Formula = (fraction part of detected value) x 60.
 * |        |          |Note: Digit in RTC_FREQADJ must be expressed as hexadecimal number.
 * |[11:8]  |INTEGER   |Integer Part
 * @var RTC_T::TIME
 * Offset: 0x0C  Time Loading Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[3:0]   |SEC       |1-Sec Time Digit (0~9)
 * |[6:4]   |TENSEC    |10-Sec Time Digit (0~5)
 * |[11:8]  |MIN       |1-Min Time Digit (0~9)
 * |[14:12] |TENMIN    |10-Min Time Digit (0~5)
 * |[19:16] |HR        |1-Hour Time Digit (0~9)
 * |[21:20] |TENHR     |10-Hour Time Digit (0~2)
 * @var RTC_T::CAL
 * Offset: 0x10  RTC Calendar Loading Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[3:0]   |DAY       |1-Day Calendar Digit (0~9)
 * |[5:4]   |TENDAY    |10-Day Calendar Digit (0~3)
 * |[11:8]  |MON       |1-Month Calendar Digit (0~9)
 * |[12]    |TENMON    |10-Month Calendar Digit (0~1)
 * |[19:16] |YEAR      |1-Year Calendar Digit (0~9)
 * |[23:20] |TENYEAR   |10-Year Calendar Digit (0~9)
 * @var RTC_T::CLKFMT
 * Offset: 0x14  Time Scale Selection Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |24HEN     |24-Hour / 12-Hour Time Scale Selection
 * |        |          |Indicates that RTC_TIME and RTC_TALM are in 24-hour time scale or 12-hour time scale
 * |        |          |0 = 12-hour time scale with AM and PM indication selected.
 * |        |          |1 = 24-hour time scale selected.
 * @var RTC_T::WEEKDAY
 * Offset: 0x18  Day of the Week Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[2:0]   |WEEKDAY   |Day Of The Week Register
 * |        |          |000 = Sunday.
 * |        |          |001 = Monday.
 * |        |          |010 = Tuesday.
 * |        |          |011 = Wednesday.
 * |        |          |100 = Thursday.
 * |        |          |101 = Friday.
 * |        |          |110 = Saturday.
 * |        |          |111 = Reserved.
 * @var RTC_T::TALM
 * Offset: 0x1C  Time Alarm Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[3:0]   |SEC       |1-Sec Time Digit of Alarm Setting (0~9)
 * |[6:4]   |TENSEC    |10-Sec Time Digit of Alarm Setting (0~5)
 * |[11:8]  |MIN       |1-Min Time Digit of Alarm Setting (0~9)
 * |[14:12] |TENMIN    |10-Min Time Digit of Alarm Setting (0~5)
 * |[19:16] |HR        |1-Hour Time Digit of Alarm Setting (0~9)
 * |[21:20] |TENHR     |10-Hour Time Digit of Alarm Setting (0~2)
 * @var RTC_T::CALM
 * Offset: 0x20  Calendar Alarm Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[3:0]   |DAY       |1-Day Calendar Digit of Alarm Setting (0~9)
 * |[5:4]   |TENDAY    |10-Day Calendar Digit of Alarm Setting (0~3)
 * |[11:8]  |MON       |1-Month Calendar Digit of Alarm Setting (0~9)
 * |[12]    |TENMON    |10-Month Calendar Digit of Alarm Setting (0~1)
 * |[19:16] |YEAR      |1-Year Calendar Digit of Alarm Setting (0~9)
 * |[23:20] |TENYEAR   |10-Year Calendar Digit of Alarm Setting (0~9)
 * @var RTC_T::LEAPYEAR
 * Offset: 0x24  RTC Leap Year Indicator Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |LEAPYEAR  |Leap Year Indication Register (Read Only)
 * |        |          |0 = This year is not a leap year.
 * |        |          |1 = This year is leap year.
 * @var RTC_T::INTEN
 * Offset: 0x28  RTC Interrupt Enable Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |ALMIEN    |Alarm Interrupt Enable Bit
 * |        |          |0 = RTC Alarm interrupt Disabled.
 * |        |          |1 = RTC Alarm interrupt Enabled.
 * |[1]     |TICKIEN   |Time Tick Interrupt Enable Bit
 * |        |          |0 = RTC Time Tick interrupt Disabled.
 * |        |          |1 = RTC Time Tick interrupt Enabled.
 * |[2]     |SNPDIEN   |Snoop Detection Interrupt Enable Bit
 * |        |          |0 = Snoop detected interrupt Disabled.
 * |        |          |1 = Snoop detected interrupt Enabled.
 * @var RTC_T::INTSTS
 * Offset: 0x2C  RTC Interrupt Indicator Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |ALMIF     |RTC Alarm Interrupt Flag
 * |        |          |When RTC time counters RTC_TIME and RTC_CAL match the alarm setting time registers RTC_TALM and RTC_CALM, this bit will be set to 1 and an interrupt will be generated if RTC Alarm Interrupt enabled ALMIEN (RTC_INTEN[0]) is set to 1.
 * |        |          |Chip will be waken up if RTC Alarm Interrupt is enabled when chip is at Power-down mode.
 * |        |          |0 = Alarm condition is not matched.
 * |        |          |1 = Alarm condition is matched.
 * |        |          |Note: Write 1 to clear this bit.
 * |[1]     |TICKIF    |RTC Time Tick Interrupt Flag
 * |        |          |When RTC time tick happened, this bit will be set to 1 and an interrupt will be generated if RTC Tick Interrupt enabled TICKIEN (RTC_INTEN[1]) is set to 1.
 * |        |          |Chip will also be waken up if RTC Tick Interrupt is enabled and this bit is set to 1 when chip is running at Power-down mode.
 * |        |          |0 = Tick condition does not occur.
 * |        |          |1 = Tick condition occur.
 * |        |          |Note: Write 1 to clear to clear this bit.
 * |[2]     |SNPDIF    |Snoop Detect Interrupt Flag
 * |        |          |When tamper pin transition event is detected, this bit is set to 1 and an interrupt is generated if Snoop Detection Interrupt enabled SNPDIEN (RTC_INTEN[2]) is set to1.
 * |        |          |Chip will be waken up from Power-down mode if spare register snooper detect interrupt is enabled.
 * |        |          |0 = No snoop event is detected.
 * |        |          |1 = Snoop event is detected.
 * |        |          |Note: Write 1 to clear this bit.
 * @var RTC_T::TICK
 * Offset: 0x30  RTC Time Tick Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[2:0]   |TICK      |Time Tick Register
 * |        |          |These bits are used to select RTC time tick period for Periodic Time Tick Interrupt request.
 * |        |          |000 = Time tick is 1 second.
 * |        |          |001 = Time tick is 1/2 second.
 * |        |          |010 = Time tick is 1/4 second.
 * |        |          |011 = Time tick is 1/8 second.
 * |        |          |100 = Time tick is 1/16 second.
 * |        |          |101 = Time tick is 1/32 second.
 * |        |          |110 = Time tick is 1/64 second.
 * |        |          |111 = Time tick is 1/28 second.
 * |        |          |Note: This register can be read back after the RTC register access enable bit RWENF (RTC_RWEN[16]) is active.
 * @var RTC_T::TAMSK
 * Offset: 0x34  Time Alarm Mask Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |MSEC      |Mask 1-Sec Time Digit of Alarm Setting (0~9)
 * |[1]     |MTENSEC   |Mask 10-Sec Time Digit of Alarm Setting (0~5)
 * |[2]     |MMIN      |Mask 1-Min Time Digit of Alarm Setting (0~9)
 * |[3]     |MTENMIN   |Mask 10-Min Time Digit of Alarm Setting (0~5)
 * |[4]     |MHR       |Mask 1-Hour Time Digit of Alarm Setting (0~9)
 * |[5]     |MTENHR    |Mask 10-Hour Time Digit of Alarm Setting (0~2)
 * @var RTC_T::CAMSK
 * Offset: 0x38  Calendar Alarm Mask Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |MDAY      |Mask 1-Day Calendar Digit of Alarm Setting (0~9)
 * |[1]     |MTENDAY   |Mask 10-Day Calendar Digit of Alarm Setting (0~3)
 * |[2]     |MMON      |Mask 1-Month Calendar Digit of Alarm Setting (0~9)
 * |[3]     |MTENMON   |Mask 10-Month Calendar Digit of Alarm Setting (0~1)
 * |[4]     |MYEAR     |Mask 1-Year Calendar Digit of Alarm Setting (0~9)
 * |[5]     |MTENYEAR  |Mask 10-Year Calendar Digit of Alarm Setting (0~9)
 * @var RTC_T::SPRCTL
 * Offset: 0x3C  RTC Spare Functional Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |SNPDEN    |Snoop Detection Enable Bit
 * |        |          |0 = TAMPER pin detection is Disabled.
 * |        |          |1 = TAMPER pin detection is Enabled.
 * |[1]     |SNPTYPE0  |Snoop Detection Level
 * |        |          |This bit controls TAMPER detect event is high level/rising edge or low level/falling edge.
 * |        |          |0 = Low level/Falling edge detection.
 * |        |          |1 = High level/Rising edge detection.
 * |[2]     |SPRRWEN   |Spare Register Enable Bit
 * |        |          |0 = Spare register is Disabled.
 * |        |          |1 = Spare register is Enabled.
 * |        |          |Note: When spare register is disabled, RTC_SPR0 ~ RTC_SPR19 cannot be accessed.
 * |[3]     |SNPTYPE1  |Snoop Detection Mode
 * |        |          |This bit controls TAMPER pin is edge or level detection
 * |        |          |0 = Level detection.
 * |        |          |1 = Edge detection.
 * |[5]     |SPRCSTS   |SPR Clear Flag
 * |        |          |This bit indicates if the RTC_SPR0 ~RTC_SPR19 content is cleared when specify snoop event is detected.
 * |        |          |0 = Spare register content is not cleared.
 * |        |          |1 = Spare register content is cleared.
 * |        |          |Writes 1 to clear this bit.
 * |[7]     |SPRRWRDY  |SPR Register Ready
 * |        |          |This bit indicates if the registers RTC_SPRCTL, RTC_SPR0 ~ RTC_SPR19 are ready to be accessed.
 * |        |          |After user writing registers RTC_SPRCTL, RTC_SPR0 ~ RTC_SPR19, read this bit to check if these registers are updated done is necessary.
 * |        |          |0 = RTC_SPRCTL, RTC_SPR0 ~ RTC_SPR19 updating is in progress.
 * |        |          |1 = RTC_SPRCTL, RTC_SPR0 ~ RTC_SPR19 are updated done and ready to be accessed.
 * |        |          |Note: This bit is read only and any write to it won't take any effect.
 * @var RTC_T::SPR
 * Offset: 0x40 ~ 0x8C  RTC Spare Register 0 ~ 19
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[31:0]  |SPARE     |Spare Register
 * |        |          |This field is used to store back-up information defined by user.
 * |        |          |This field will be cleared by hardware automatically once a snooper pin event is detected.
 * |        |          |Before storing back-up information in to RTC_SPRx register, user should write 0xA965 to RTC_RWEN[15:0] to make sure register read/write enable bit REWNF (RTC_RWEN[16]) is enabled.
 * @var RTC_T::LXTCTL
 * Offset: 0x100  RTC 32.768 kHz Oscillator Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |LXTEN     |Backup Domain 32K Oscillator Enable Bit
 * |        |          |0 = Oscillator is Disabled.
 * |        |          |1 = Oscillator is Enabled.
 * |        |          |This bit controls 32 kHz oscillator on/off.
 * |        |          |User can set either LXTEN in RTC domain or system manager control register CLK_PWRCTL[1] (LXTEN) to enable 32 kHz oscillator.
 * |        |          |If this bit is set 1, X32 kHz oscillator keep running after system power is turned off, if this bit is clear to 0, oscillator is turned off when system power is turned off.
 * |[3:1]   |GAIN      |Oscillator Gain Option
 * |        |          |User can select oscillator gain according to crystal external loading and operating temperature range.
 * |        |          |The larger gain value corresponding to stronger driving capability and higher power consumption.
 * |        |          |000 = L0 mode.
 * |        |          |001 = L1 mode.
 * |        |          |010 = L2 mode.
 * |        |          |011 = L3 mode.
 * |        |          |100 = L4 mode.
 * |        |          |101 = L5 mode.
 * |        |          |110 = L6 mode.
 * |        |          |111 = L7 mode (Default).
 * @var RTC_T::LXTOCTL
 * Offset: 0x104  X32KO Pin Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[1:0]   |OPMODE    |GPF0 Operation Mode
 * |        |          |00 = X32KO (PF.0) is input only mode, without pull-up resistor.
 * |        |          |01 = X32KO (PF.0) is output push pull mode.
 * |        |          |10 = X32KO (PF.0) is open drain mode.
 * |        |          |11 = X32KO (PF.0) is input only mode with internal pull up.
 * |[2]     |DOUT      |IO Output Data
 * |        |          |0 = X32KO (PF.0) output low.
 * |        |          |1 = X32KO (PF.0) output high.
 * |[3]     |CTLSEL    |IO Pin State Backup Selection
 * |        |          |When low speed 32 kHz oscillator is disabled, X32KO (PF.0) pin can be used as GPIO function.
 * |        |          |User can program CTLSEL bit to decide X32KO (PF.0) I/O function is controlled by system power domain GPIO module or VBAT power domain RTC_LXTOCTL control register.
 * |        |          |0 = X32KO (PF.0) pin I/O function is controlled by GPIO module.
 * |        |          |It becomes floating when system power is turned off.
 * |        |          |1 = X32KO (PF.0) pin I/O function is controlled by VBAT power domain, X32KO (PF.0) pin function and I/O status are controlled by OPMODE[1:0] and DOUT after CTLSEL it set to 1.
 * |        |          |I/O pin keeps the previous state after system power is turned off.
 * @var RTC_T::LXTICTL
 * Offset: 0x108  X32KI Pin Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[1:0]   |OPMODE    |IO Operation Mode
 * |        |          |00 = X32KI (PF.1) is input only mode, without pull-up resistor.
 * |        |          |01 = X32KI (PF.1) is output push pull mode.
 * |        |          |10 = X32KI (PF.1) is open drain mode.
 * |        |          |11 = X32KI (PF.1) is input only mode with internal pull up.
 * |[2]     |DOUT      |IO Output Data
 * |        |          |0 = X32KI (PF.1) output low.
 * |        |          |1 = X32KI (PF.1) output high.
 * |[3]     |CTLSEL    |IO Pin State Backup Selection
 * |        |          |When low speed 32 kHz oscillator is disabled, X32KI (PF.1) pin can be used as GPIO function.
 * |        |          |User can program CTLSEL bit to decide X32KI (PF.1) I/O function is controlled by system power domain GPIO module or VBAT power domain RTC_LXTICTL control register.
 * |        |          |0 = X32KI (PF.1) pin I/O function is controlled by GPIO module.
 * |        |          |It becomes floating state when system power is turned off.
 * |        |          |1 = X32KI (PF.1) pin I/O function is controlled by VBAT power domain, X32KI (PF.1) pin function and I/O status are controlled by OPMODE[1:0] and DOUT after CTLSEL it set to 1.
 * |        |          |I/O pin keeps the previous state after system power is turned off.
 * @var RTC_T::TAMPCTL
 * Offset: 0x10C  TAMPER Pin Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[1:0]   |OPMODE    |IO Operation Mode
 * |        |          |00 = TAMPER (PF.2) is input only mode, without pull-up resistor.
 * |        |          |01 = TAMPER (PF.2) is output push pull mode.
 * |        |          |10 = TAMPER (PF.2) is open drain mode.
 * |        |          |11 = TAMPER (PF.2) is input only mode with internal pull up.
 * |[2]     |DOUT      |IO Output Data
 * |        |          |0 = TAMPER (PF.2) output low.
 * |        |          |1 = TAMPER (PF.2) output high.
 * |[3]     |CTLSEL    |IO Pin State Backup Selection
 * |        |          |When tamper function is disabled, TAMPER pin can be used as GPIO function.
 * |        |          |User can program CTLSEL bit to decide PF.2 I/O function is controlled by system power domain GPIO module or VBAT power domain RTC_TAMPCTL control register.
 * |        |          |0 =TAMPER (PF.2) I/O function is controlled by GPIO module.
 * |        |          |It becomes floating state when system power is turned off.
 * |        |          |1 =TAMPER (PF.2) I/O function is controlled by VBAT power domain.
 * |        |          |PF.2 function and I/O status are controlled by OPMODE[1:0] and DOUT after CTLSEL it set to 1.
 * |        |          |I/O pin state keeps previous state after system power is turned off.
 */

    __IO uint32_t INIT;          /* Offset: 0x00  RTC Initiation Register                                            */
    __O  uint32_t RWEN;          /* Offset: 0x04  RTC Access Enable Register                                         */
    __IO uint32_t FREQADJ;       /* Offset: 0x08  RTC Frequency Compensation Register                                */
    __IO uint32_t TIME;          /* Offset: 0x0C  Time Loading Register                                              */
    __IO uint32_t CAL;           /* Offset: 0x10  RTC Calendar Loading Register                                      */
    __IO uint32_t CLKFMT;        /* Offset: 0x14  Time Scale Selection Register                                      */
    __IO uint32_t WEEKDAY;       /* Offset: 0x18  Day of the Week Register                                           */
    __IO uint32_t TALM;          /* Offset: 0x1C  Time Alarm Register                                                */
    __IO uint32_t CALM;          /* Offset: 0x20  Calendar Alarm Register                                            */
    __I  uint32_t LEAPYEAR;      /* Offset: 0x24  RTC Leap Year Indicator Register                                   */
    __IO uint32_t INTEN;         /* Offset: 0x28  RTC Interrupt Enable Register                                      */
    __IO uint32_t INTSTS;        /* Offset: 0x2C  RTC Interrupt Indicator Register                                   */
    __IO uint32_t TICK;          /* Offset: 0x30  RTC Time Tick Register                                             */
    __IO uint32_t TAMSK;         /* Offset: 0x34  Time Alarm Mask Register                                           */
    __IO uint32_t CAMSK;         /* Offset: 0x38  Calendar Alarm Mask Register                                       */
    __IO uint32_t SPRCTL;        /* Offset: 0x3C  RTC Spare Functional Control Register                              */
    __IO uint32_t SPR[20];       /* Offset: 0x40 ~ 0x8C  RTC Spare Register 0 ~ 19                                   */
    __I  uint32_t RESERVE0[28]; 
    __IO uint32_t LXTCTL;        /* Offset: 0x100  RTC 32.768 kHz Oscillator Control Register                        */
    __IO uint32_t LXTOCTL;       /* Offset: 0x104  X32KO Pin Control Register                                        */
    __IO uint32_t LXTICTL;       /* Offset: 0x108  X32KI Pin Control Register                                        */
    __IO uint32_t TAMPCTL;       /* Offset: 0x10C  TAMPER Pin Control Register                                       */

} RTC_T;



/**
    @addtogroup RTC_CONST RTC Bit Field Definition
    Constant Definitions for RTC Controller
@{ */

#define RTC_INIT_ACTIVE_Pos              (0)                                               /*!< RTC_T::INIT: ACTIVE Position              */
#define RTC_INIT_ACTIVE_Msk              (0x1ul << RTC_INIT_ACTIVE_Pos)                    /*!< RTC_T::INIT: ACTIVE Mask                  */

#define RTC_INIT_INIT_Pos                (0)                                               /*!< RTC_T::INIT: INIT Position                */
#define RTC_INIT_INIT_Msk                (0xfffffffful << RTC_INIT_INIT_Pos)               /*!< RTC_T::INIT: INIT Mask                    */

#define RTC_RWEN_RWEN_Pos                (0)                                               /*!< RTC_T::RWEN: RWEN Position                */
#define RTC_RWEN_RWEN_Msk                (0xfffful << RTC_RWEN_RWEN_Pos)                   /*!< RTC_T::RWEN: RWEN Mask                    */

#define RTC_RWEN_RWENF_Pos               (16)                                              /*!< RTC_T::RWEN: RWENF Position               */
#define RTC_RWEN_RWENF_Msk               (0x1ul << RTC_RWEN_RWENF_Pos)                     /*!< RTC_T::RWEN: RWENF Mask                   */

#define RTC_FREQADJ_FRACTION_Pos         (0)                                               /*!< RTC_T::FREQADJ: FRACTION Position         */
#define RTC_FREQADJ_FRACTION_Msk         (0x3ful << RTC_FREQADJ_FRACTION_Pos)              /*!< RTC_T::FREQADJ: FRACTION Mask             */

#define RTC_FREQADJ_INTEGER_Pos          (8)                                               /*!< RTC_T::FREQADJ: INTEGER Position          */
#define RTC_FREQADJ_INTEGER_Msk          (0xful << RTC_FREQADJ_INTEGER_Pos)                /*!< RTC_T::FREQADJ: INTEGER Mask              */

#define RTC_TIME_SEC_Pos                 (0)                                               /*!< RTC_T::TIME: SEC Position                 */
#define RTC_TIME_SEC_Msk                 (0xful << RTC_TIME_SEC_Pos)                       /*!< RTC_T::TIME: SEC Mask                     */

#define RTC_TIME_TENSEC_Pos              (4)                                               /*!< RTC_T::TIME: TENSEC Position              */
#define RTC_TIME_TENSEC_Msk              (0x7ul << RTC_TIME_TENSEC_Pos)                    /*!< RTC_T::TIME: TENSEC Mask                  */

#define RTC_TIME_MIN_Pos                 (8)                                               /*!< RTC_T::TIME: MIN Position                 */
#define RTC_TIME_MIN_Msk                 (0xful << RTC_TIME_MIN_Pos)                       /*!< RTC_T::TIME: MIN Mask                     */

#define RTC_TIME_TENMIN_Pos              (12)                                              /*!< RTC_T::TIME: TENMIN Position              */
#define RTC_TIME_TENMIN_Msk              (0x7ul << RTC_TIME_TENMIN_Pos)                    /*!< RTC_T::TIME: TENMIN Mask                  */

#define RTC_TIME_HR_Pos                  (16)                                              /*!< RTC_T::TIME: HR Position                  */
#define RTC_TIME_HR_Msk                  (0xful << RTC_TIME_HR_Pos)                        /*!< RTC_T::TIME: HR Mask                      */

#define RTC_TIME_TENHR_Pos               (20)                                              /*!< RTC_T::TIME: TENHR Position               */
#define RTC_TIME_TENHR_Msk               (0x3ul << RTC_TIME_TENHR_Pos)                     /*!< RTC_T::TIME: TENHR Mask                   */

#define RTC_CAL_DAY_Pos                  (0)                                               /*!< RTC_T::CAL: DAY Position                  */
#define RTC_CAL_DAY_Msk                  (0xful << RTC_CAL_DAY_Pos)                        /*!< RTC_T::CAL: DAY Mask                      */

#define RTC_CAL_TENDAY_Pos               (4)                                               /*!< RTC_T::CAL: TENDAY Position               */
#define RTC_CAL_TENDAY_Msk               (0x3ul << RTC_CAL_TENDAY_Pos)                     /*!< RTC_T::CAL: TENDAY Mask                   */

#define RTC_CAL_MON_Pos                  (8)                                               /*!< RTC_T::CAL: MON Position                  */
#define RTC_CAL_MON_Msk                  (0xful << RTC_CAL_MON_Pos)                        /*!< RTC_T::CAL: MON Mask                      */

#define RTC_CAL_TENMON_Pos               (12)                                              /*!< RTC_T::CAL: TENMON Position               */
#define RTC_CAL_TENMON_Msk               (0x1ul << RTC_CAL_TENMON_Pos)                     /*!< RTC_T::CAL: TENMON Mask                   */

#define RTC_CAL_YEAR_Pos                 (16)                                              /*!< RTC_T::CAL: YEAR Position                 */
#define RTC_CAL_YEAR_Msk                 (0xful << RTC_CAL_YEAR_Pos)                       /*!< RTC_T::CAL: YEAR Mask                     */

#define RTC_CAL_TENYEAR_Pos              (20)                                              /*!< RTC_T::CAL: TENYEAR Position              */
#define RTC_CAL_TENYEAR_Msk              (0xful << RTC_CAL_TENYEAR_Pos)                    /*!< RTC_T::CAL: TENYEAR Mask                  */

#define RTC_CLKFMT_24HEN_Pos             (0)                                               /*!< RTC_T::CLKFMT: 24HEN Position             */
#define RTC_CLKFMT_24HEN_Msk             (0x1ul << RTC_CLKFMT_24HEN_Pos)                   /*!< RTC_T::CLKFMT: 24HEN Mask                 */

#define RTC_WEEKDAY_WEEKDAY_Pos          (0)                                               /*!< RTC_T::WEEKDAY: WEEKDAY Position          */
#define RTC_WEEKDAY_WEEKDAY_Msk          (0x7ul << RTC_WEEKDAY_WEEKDAY_Pos)                /*!< RTC_T::WEEKDAY: WEEKDAY Mask              */

#define RTC_TALM_SEC_Pos                 (0)                                               /*!< RTC_T::TALM: SEC Position                 */
#define RTC_TALM_SEC_Msk                 (0xful << RTC_TALM_SEC_Pos)                       /*!< RTC_T::TALM: SEC Mask                     */

#define RTC_TALM_TENSEC_Pos              (4)                                               /*!< RTC_T::TALM: TENSEC Position              */
#define RTC_TALM_TENSEC_Msk              (0x7ul << RTC_TALM_TENSEC_Pos)                    /*!< RTC_T::TALM: TENSEC Mask                  */

#define RTC_TALM_MIN_Pos                 (8)                                               /*!< RTC_T::TALM: MIN Position                 */
#define RTC_TALM_MIN_Msk                 (0xful << RTC_TALM_MIN_Pos)                       /*!< RTC_T::TALM: MIN Mask                     */

#define RTC_TALM_TENMIN_Pos              (12)                                              /*!< RTC_T::TALM: TENMIN Position              */
#define RTC_TALM_TENMIN_Msk              (0x7ul << RTC_TALM_TENMIN_Pos)                    /*!< RTC_T::TALM: TENMIN Mask                  */

#define RTC_TALM_HR_Pos                  (16)                                              /*!< RTC_T::TALM: HR Position                  */
#define RTC_TALM_HR_Msk                  (0xful << RTC_TALM_HR_Pos)                        /*!< RTC_T::TALM: HR Mask                      */

#define RTC_TALM_TENHR_Pos               (20)                                              /*!< RTC_T::TALM: TENHR Position               */
#define RTC_TALM_TENHR_Msk               (0x3ul << RTC_TALM_TENHR_Pos)                     /*!< RTC_T::TALM: TENHR Mask                   */

#define RTC_CALM_DAY_Pos                 (0)                                               /*!< RTC_T::CALM: DAY Position                 */
#define RTC_CALM_DAY_Msk                 (0xful << RTC_CALM_DAY_Pos)                       /*!< RTC_T::CALM: DAY Mask                     */

#define RTC_CALM_TENDAY_Pos              (4)                                               /*!< RTC_T::CALM: TENDAY Position              */
#define RTC_CALM_TENDAY_Msk              (0x3ul << RTC_CALM_TENDAY_Pos)                    /*!< RTC_T::CALM: TENDAY Mask                  */

#define RTC_CALM_MON_Pos                 (8)                                               /*!< RTC_T::CALM: MON Position                 */
#define RTC_CALM_MON_Msk                 (0xful << RTC_CALM_MON_Pos)                       /*!< RTC_T::CALM: MON Mask                     */

#define RTC_CALM_TENMON_Pos              (12)                                              /*!< RTC_T::CALM: TENMON Position              */
#define RTC_CALM_TENMON_Msk              (0x1ul << RTC_CALM_TENMON_Pos)                    /*!< RTC_T::CALM: TENMON Mask                  */

#define RTC_CALM_YEAR_Pos                (16)                                              /*!< RTC_T::CALM: YEAR Position                */
#define RTC_CALM_YEAR_Msk                (0xful << RTC_CALM_YEAR_Pos)                      /*!< RTC_T::CALM: YEAR Mask                    */

#define RTC_CALM_TENYEAR_Pos             (20)                                              /*!< RTC_T::CALM: TENYEAR Position             */
#define RTC_CALM_TENYEAR_Msk             (0xful << RTC_CALM_TENYEAR_Pos)                   /*!< RTC_T::CALM: TENYEAR Mask                 */

#define RTC_LEAPYEAR_LEAPYEAR_Pos        (0)                                               /*!< RTC_T::LEAPYEAR: LEAPYEAR Position        */
#define RTC_LEAPYEAR_LEAPYEAR_Msk        (0x1ul << RTC_LEAPYEAR_LEAPYEAR_Pos)              /*!< RTC_T::LEAPYEAR: LEAPYEAR Mask            */

#define RTC_INTEN_ALMIEN_Pos             (0)                                               /*!< RTC_T::INTEN: ALMIEN Position             */
#define RTC_INTEN_ALMIEN_Msk             (0x1ul << RTC_INTEN_ALMIEN_Pos)                   /*!< RTC_T::INTEN: ALMIEN Mask                 */

#define RTC_INTEN_TICKIEN_Pos            (1)                                               /*!< RTC_T::INTEN: TICKIEN Position            */
#define RTC_INTEN_TICKIEN_Msk            (0x1ul << RTC_INTEN_TICKIEN_Pos)                  /*!< RTC_T::INTEN: TICKIEN Mask                */

#define RTC_INTEN_SNPDIEN_Pos            (2)                                               /*!< RTC_T::INTEN: SNPDIEN Position            */
#define RTC_INTEN_SNPDIEN_Msk            (0x1ul << RTC_INTEN_SNPDIEN_Pos)                  /*!< RTC_T::INTEN: SNPDIEN Mask                */

#define RTC_INTSTS_ALMIF_Pos             (0)                                               /*!< RTC_T::INTSTS: ALMIF Position             */
#define RTC_INTSTS_ALMIF_Msk             (0x1ul << RTC_INTSTS_ALMIF_Pos)                   /*!< RTC_T::INTSTS: ALMIF Mask                 */

#define RTC_INTSTS_TICKIF_Pos            (1)                                               /*!< RTC_T::INTSTS: TICKIF Position            */
#define RTC_INTSTS_TICKIF_Msk            (0x1ul << RTC_INTSTS_TICKIF_Pos)                  /*!< RTC_T::INTSTS: TICKIF Mask                */

#define RTC_INTSTS_SNPDIF_Pos            (2)                                               /*!< RTC_T::INTSTS: SNPDIF Position            */
#define RTC_INTSTS_SNPDIF_Msk            (0x1ul << RTC_INTSTS_SNPDIF_Pos)                  /*!< RTC_T::INTSTS: SNPDIF Mask                */

#define RTC_TICK_TICK_Pos                (0)                                               /*!< RTC_T::TICK: TICK Position                */
#define RTC_TICK_TICK_Msk                (0x7ul << RTC_TICK_TICK_Pos)                      /*!< RTC_T::TICK: TICK Mask                    */

#define RTC_TAMSK_MSEC_Pos               (0)                                               /*!< RTC_T::TAMSK: MSEC Position               */
#define RTC_TAMSK_MSEC_Msk               (0x1ul << RTC_TAMSK_MSEC_Pos)                     /*!< RTC_T::TAMSK: MSEC Mask                   */

#define RTC_TAMSK_MTENSEC_Pos            (1)                                               /*!< RTC_T::TAMSK: MTENSEC Position            */
#define RTC_TAMSK_MTENSEC_Msk            (0x1ul << RTC_TAMSK_MTENSEC_Pos)                  /*!< RTC_T::TAMSK: MTENSEC Mask                */

#define RTC_TAMSK_MMIN_Pos               (2)                                               /*!< RTC_T::TAMSK: MMIN Position               */
#define RTC_TAMSK_MMIN_Msk               (0x1ul << RTC_TAMSK_MMIN_Pos)                     /*!< RTC_T::TAMSK: MMIN Mask                   */

#define RTC_TAMSK_MTENMIN_Pos            (3)                                               /*!< RTC_T::TAMSK: MTENMIN Position            */
#define RTC_TAMSK_MTENMIN_Msk            (0x1ul << RTC_TAMSK_MTENMIN_Pos)                  /*!< RTC_T::TAMSK: MTENMIN Mask                */

#define RTC_TAMSK_MHR_Pos                (4)                                               /*!< RTC_T::TAMSK: MHR Position                */
#define RTC_TAMSK_MHR_Msk                (0x1ul << RTC_TAMSK_MHR_Pos)                      /*!< RTC_T::TAMSK: MHR Mask                    */

#define RTC_TAMSK_MTENHR_Pos             (5)                                               /*!< RTC_T::TAMSK: MTENHR Position             */
#define RTC_TAMSK_MTENHR_Msk             (0x1ul << RTC_TAMSK_MTENHR_Pos)                   /*!< RTC_T::TAMSK: MTENHR Mask                 */

#define RTC_CAMSK_MDAY_Pos               (0)                                               /*!< RTC_T::CAMSK: MDAY Position               */
#define RTC_CAMSK_MDAY_Msk               (0x1ul << RTC_CAMSK_MDAY_Pos)                     /*!< RTC_T::CAMSK: MDAY Mask                   */

#define RTC_CAMSK_MTENDAY_Pos            (1)                                               /*!< RTC_T::CAMSK: MTENDAY Position            */
#define RTC_CAMSK_MTENDAY_Msk            (0x1ul << RTC_CAMSK_MTENDAY_Pos)                  /*!< RTC_T::CAMSK: MTENDAY Mask                */

#define RTC_CAMSK_MMON_Pos               (2)                                               /*!< RTC_T::CAMSK: MMON Position               */
#define RTC_CAMSK_MMON_Msk               (0x1ul << RTC_CAMSK_MMON_Pos)                     /*!< RTC_T::CAMSK: MMON Mask                   */

#define RTC_CAMSK_MTENMON_Pos            (3)                                               /*!< RTC_T::CAMSK: MTENMON Position            */
#define RTC_CAMSK_MTENMON_Msk            (0x1ul << RTC_CAMSK_MTENMON_Pos)                  /*!< RTC_T::CAMSK: MTENMON Mask                */

#define RTC_CAMSK_MYEAR_Pos              (4)                                               /*!< RTC_T::CAMSK: MYEAR Position              */
#define RTC_CAMSK_MYEAR_Msk              (0x1ul << RTC_CAMSK_MYEAR_Pos)                    /*!< RTC_T::CAMSK: MYEAR Mask                  */

#define RTC_CAMSK_MTENYEAR_Pos           (5)                                               /*!< RTC_T::CAMSK: MTENYEAR Position           */
#define RTC_CAMSK_MTENYEAR_Msk           (0x1ul << RTC_CAMSK_MTENYEAR_Pos)                 /*!< RTC_T::CAMSK: MTENYEAR Mask               */

#define RTC_SPRCTL_SNPDEN_Pos            (0)                                               /*!< RTC_T::SPRCTL: SNPDEN Position            */
#define RTC_SPRCTL_SNPDEN_Msk            (0x1ul << RTC_SPRCTL_SNPDEN_Pos)                  /*!< RTC_T::SPRCTL: SNPDEN Mask                */

#define RTC_SPRCTL_SNPTYPE0_Pos          (1)                                               /*!< RTC_T::SPRCTL: SNPTYPE0 Position          */
#define RTC_SPRCTL_SNPTYPE0_Msk          (0x1ul << RTC_SPRCTL_SNPTYPE0_Pos)                /*!< RTC_T::SPRCTL: SNPTYPE0 Mask              */

#define RTC_SPRCTL_SPRRWEN_Pos           (2)                                               /*!< RTC_T::SPRCTL: SPRRWEN Position           */
#define RTC_SPRCTL_SPRRWEN_Msk           (0x1ul << RTC_SPRCTL_SPRRWEN_Pos)                 /*!< RTC_T::SPRCTL: SPRRWEN Mask               */

#define RTC_SPRCTL_SNPTYPE1_Pos          (3)                                               /*!< RTC_T::SPRCTL: SNPTYPE1 Position          */
#define RTC_SPRCTL_SNPTYPE1_Msk          (0x1ul << RTC_SPRCTL_SNPTYPE1_Pos)                /*!< RTC_T::SPRCTL: SNPTYPE1 Mask              */

#define RTC_SPRCTL_SPRCSTS_Pos           (5)                                               /*!< RTC_T::SPRCTL: SPRCSTS Position           */
#define RTC_SPRCTL_SPRCSTS_Msk           (0x1ul << RTC_SPRCTL_SPRCSTS_Pos)                 /*!< RTC_T::SPRCTL: SPRCSTS Mask               */

#define RTC_SPRCTL_SPRRWRDY_Pos          (7)                                               /*!< RTC_T::SPRCTL: SPRRWRDY Position          */
#define RTC_SPRCTL_SPRRWRDY_Msk          (0x1ul << RTC_SPRCTL_SPRRWRDY_Pos)                /*!< RTC_T::SPRCTL: SPRRWRDY Mask              */

#define RTC_SPR_SPARE_Pos                (0)                                               /*!< RTC_T::SPR: SPARE Position                */
#define RTC_SPR_SPARE_Msk                (0xfffffffful << RTC_SPR_SPARE_Pos)               /*!< RTC_T::SPR: SPARE Mask                    */

#define RTC_LXTCTL_LXTEN_Pos             (0)                                               /*!< RTC_T::LXTCTL: LXTEN Position             */
#define RTC_LXTCTL_LXTEN_Msk             (0x1ul << RTC_LXTCTL_LXTEN_Pos)                   /*!< RTC_T::LXTCTL: LXTEN Mask                 */

#define RTC_LXTCTL_GAIN_Pos              (1)                                               /*!< RTC_T::LXTCTL: GAIN Position              */
#define RTC_LXTCTL_GAIN_Msk              (0x7ul << RTC_LXTCTL_GAIN_Pos)                    /*!< RTC_T::LXTCTL: GAIN Mask                  */

#define RTC_LXTOCTL_OPMODE_Pos           (0)                                               /*!< RTC_T::LXTOCTL: OPMODE Position           */
#define RTC_LXTOCTL_OPMODE_Msk           (0x3ul << RTC_LXTOCTL_OPMODE_Pos)                 /*!< RTC_T::LXTOCTL: OPMODE Mask               */

#define RTC_LXTOCTL_DOUT_Pos             (2)                                               /*!< RTC_T::LXTOCTL: DOUT Position             */
#define RTC_LXTOCTL_DOUT_Msk             (0x1ul << RTC_LXTOCTL_DOUT_Pos)                   /*!< RTC_T::LXTOCTL: DOUT Mask                 */

#define RTC_LXTOCTL_CTLSEL_Pos           (3)                                               /*!< RTC_T::LXTOCTL: CTLSEL Position           */
#define RTC_LXTOCTL_CTLSEL_Msk           (0x1ul << RTC_LXTOCTL_CTLSEL_Pos)                 /*!< RTC_T::LXTOCTL: CTLSEL Mask               */

#define RTC_LXTICTL_OPMODE_Pos           (0)                                               /*!< RTC_T::LXTICTL: OPMODE Position           */
#define RTC_LXTICTL_OPMODE_Msk           (0x3ul << RTC_LXTICTL_OPMODE_Pos)                 /*!< RTC_T::LXTICTL: OPMODE Mask               */

#define RTC_LXTICTL_DOUT_Pos             (2)                                               /*!< RTC_T::LXTICTL: DOUT Position             */
#define RTC_LXTICTL_DOUT_Msk             (0x1ul << RTC_LXTICTL_DOUT_Pos)                   /*!< RTC_T::LXTICTL: DOUT Mask                 */

#define RTC_LXTICTL_CTLSEL_Pos           (3)                                               /*!< RTC_T::LXTICTL: CTLSEL Position           */
#define RTC_LXTICTL_CTLSEL_Msk           (0x1ul << RTC_LXTICTL_CTLSEL_Pos)                 /*!< RTC_T::LXTICTL: CTLSEL Mask               */

#define RTC_TAMPCTL_OPMODE_Pos           (0)                                               /*!< RTC_T::TAMPCTL: OPMODE Position           */
#define RTC_TAMPCTL_OPMODE_Msk           (0x3ul << RTC_TAMPCTL_OPMODE_Pos)                 /*!< RTC_T::TAMPCTL: OPMODE Mask               */

#define RTC_TAMPCTL_DOUT_Pos             (2)                                               /*!< RTC_T::TAMPCTL: DOUT Position             */
#define RTC_TAMPCTL_DOUT_Msk             (0x1ul << RTC_TAMPCTL_DOUT_Pos)                   /*!< RTC_T::TAMPCTL: DOUT Mask                 */

#define RTC_TAMPCTL_CTLSEL_Pos           (3)                                               /*!< RTC_T::TAMPCTL: CTLSEL Position           */
#define RTC_TAMPCTL_CTLSEL_Msk           (0x1ul << RTC_TAMPCTL_CTLSEL_Pos)                 /*!< RTC_T::TAMPCTL: CTLSEL Mask               */

/**@}*/ /* RTC_CONST */
/**@}*/ /* end of RTC register group */


/*---------------------- Smart Card Host Interface Controller -------------------------*/
/**
    @addtogroup SC Smart Card Host Interface Controller(SC)
    Memory Mapped Structure for SC Controller
@{ */


typedef struct
{


/**
 * @var SC_T::DAT
 * Offset: 0x00  SC Receiving/Transmit Holding Buffer Register.
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[7:0]   |DAT       |Receiving/ Transmit Holding Buffer
 * |        |          |Write Operation:
 * |        |          |By writing data to DAT, the SC will send out an 8-bit data.
 * |        |          |Note: If SCEN(SC_CTL[0]) is not enabled, DAT cannot be programmed.
 * |        |          |Read Operation:
 * |        |          |By reading DAT, the SC will return an 8-bit received data.
 * @var SC_T::CTL
 * Offset: 0x04  SC Control Register.
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |SCEN      |SC Engine Enable Bit
 * |        |          |Set this bit to 1 to enable SC operation.
 * |        |          |If this bit is cleared, SC will force all transition to IDLE state.
 * |[1]     |RXOFF     |RX Transition Disable Control
 * |        |          |0 = The receiver Enabled.
 * |        |          |1 = The receiver Disabled.
 * |        |          |Note:
 * |        |          |If AUTOCEN (SC_CTL[3])is enabled, these fields must be ignored.
 * |[2]     |TXOFF     |TX Transition Disable Control
 * |        |          |0 = The transceiver Enabled.
 * |        |          |1 = The transceiver Disabled.
 * |[3]     |AUTOCEN   |Auto Convention Enable Bit
 * |        |          |0 = Auto-convention Disabled.
 * |        |          |1 = Auto-convention Enabled.
 * |        |          |When hardware receives TS in answer to reset state and the TS is direct convention, CONSEL(SC_CTL[5:4]) will be set to 00 automatically, otherwise if the TS is inverse convention, and CONSEL (SC_CTL[5:4]) will be set to 11.
 * |        |          |If software enables auto convention function, the setting step must be done before Answer to Reset state and the first data must be 0x3B or 0x3F.
 * |        |          |After hardware received first data and stored it at buffer, 
 * |        |          |hardware will decided the convention and change the CONSEL (SC_CTL[5:4]) bits automatically.
 * |        |          |If the first data is not 0x3B or 0x3F, hardware will generate an interrupt if ACERRIEN (SC_INTEN[10]) = 1 to CPU.
 * |[5:4]   |CONSEL    |Convention Selection
 * |        |          |00 = Direct convention.
 * |        |          |01 = Reserved.
 * |        |          |10 = Reserved.
 * |        |          |11 = Inverse convention.
 * |        |          |Note:
 * |        |          |If AUTOCEN(SC_CTL[3]) enabled, this fields are ignored.
 * |[7:6]   |RXTRGLV   |Rx Buffer Trigger Level
 * |        |          |When the number of bytes in the receiving buffer equals the RXTRGLV, the RDAIF will be set (if SC_INTEN [RDAIEN] is enabled, an interrupt will be generated).
 * |        |          |00 = INTR_RDA Trigger Level with 01 Bytes.
 * |        |          |01 = INTR_RDA Trigger Level with 02 Bytes.
 * |        |          |10 = INTR_RDA Trigger Level with 03 Bytes.
 * |        |          |11 = Reserved.
 * |[12:8]  |BGT       |Block Guard Time (BGT)
 * |        |          |Block guard time means the minimum bit length between the leading edges of two consecutive characters between different transfer directions.
 * |        |          |This field indicates the counter for the bit length of block guard time.
 * |        |          |According to ISO7816-3, in T = 0 mode, software must fill 15 (real block guard time = 16.5) to this field; in T = 1 mode, software must fill 21 (real block guard time = 22.5) to it.
 * |        |          |Note:
 * |        |          |The real block guard time is BGT + 1.
 * |[14:13] |TMRSEL    |Timer Selection
 * |        |          |00 = All internal timer function Disabled.
 * |        |          |01 = Internal 24 bit timer Enabled.
 * |        |          |Software can configure it by setting SC_TMRCTL0 [23:0].
 * |        |          |SC_TMRCTL1 and SC_TMRCTL2 will be ignored in this mode.
 * |        |          |10 = internal 24 bit timer and 8 bit internal timer Enabled.
 * |        |          |Software can configure the 24 bit timer by setting SC_TMRCTL0 [23:0] and configure the 8 bit timer by setting SC_TMRCTL1[7:0].
 * |        |          |SC_TMRCTL2 will be ignored in this mode.
 * |        |          |11 = Internal 24 bit timer and two 8 bit timers Enabled.
 * |        |          |Software can configure them by setting SC_TMRCTL0 [23:0], SC_TMRCTL1 [7:0] and SC_TMRCTL2 [7:0].
 * |[15]    |NSB       |Stop Bit Length
 * |        |          |This field indicates the length of stop bit.
 * |        |          |0 = The stop bit length is 2 ETU.
 * |        |          |1= The stop bit length is 1 ETU.
 * |        |          |Note:
 * |        |          |The default stop bit length is 2. SMC and UART adopts NSB to program the stop bit length
 * |[18:16] |RXRTY     |RX Error Retry Count Number
 * |        |          |This field indicates the maximum number of receiver retries that are allowed when parity error has occurred
 * |        |          |Note1: The real retry number is RXRTY + 1, so 8 is the maximum retry number.
 * |        |          |Note2: This field cannot be changed when RXRTYEN enabled.
 * |        |          |The change flow is to disable RXRTYEN first and then fill in new retry value.
 * |[19]    |RXRTYEN   |RX Error Retry Enable Bit
 * |        |          |This bit enables receiver retry function when parity error has occurred.
 * |        |          |0 = RX error retry function Disabled.
 * |        |          |1 = RX error retry function Enabled.
 * |        |          |Note:
 * |        |          |Software must fill in the RXRTY value before enabling this bit.
 * |[22:20] |TXRTY     |TX Error Retry Count Number
 * |        |          |This field indicates the maximum number of transmitter retries that are allowed when parity error has occurred.
 * |        |          |Note1: The real retry number is TXRTY + 1, so 8 is the maximum retry number.
 * |        |          |Note2: This field cannot be changed when TXRTYEN enabled.
 * |        |          |The change flow is to disable TXRTYEN first and then fill in new retry value.
 * |[23]    |TXRTYEN   |TX Error Retry Enable Bit
 * |        |          |This bit enables transmitter retry function when parity error has occurred.
 * |        |          |0 = TX error retry function Disabled.
 * |        |          |1 = TX error retry function Enabled.
 * |[25:24] |CDDBSEL   |Card Detect De-Bounce Selection
 * |        |          |This field indicates the card detect de-bounce selection.
 * |        |          |00 = De-bounce sample card insert once per 384 (128 * 3) peripheral clocks and de-bounce sample card removal once per 128 peripheral clocks.
 * |        |          |01 = De-bounce sample card insert once per 192 (64 * 3) peripheral clocks and de-bounce sample card removal once per 64 peripheral clocks.
 * |        |          |10 = De-bounce sample card insert once per 96 (32 * 3) peripheral clocks and de-bounce sample card removal once per 32 peripheral clocks.
 * |        |          |11 = De-bounce sample card insert once per 48 (16 * 3) peripheral clocks and de-bounce sample card removal once per 16 peripheral clocks.
 * |[26]    |CDLV      |Card Detect Level
 * |        |          |0 = When hardware detects the card detect pin (SC_CD) from high to low, it indicates a card is detected.
 * |        |          |1 = When hardware detects the card detect pin from low to high, it indicates a card is detected.
 * |        |          |Note: Software must select card detect level before Smart Card engine enabled.
 * |[30]    |SYNC      |SYNC Flag Indicator
 * |        |          |Due to synchronization, software should check this bit before writing a new value to RXRTY and TXRTY.
 * |        |          |0 = Synchronizing is completion, user can write new data to RXRTY and TXRTY.
 * |        |          |1 = Last value is synchronizing.
 * |        |          |Note: This bit is read only.
 * |[31]    |ICEDEBUG  |ICE Debug Mode Acknowledge Disable Control
 * |        |          |0 = ICE debug mode acknowledgement affects SC counting.
 * |        |          |SC internal counter will be held while CPU is held by ICE.
 * |        |          |1 = ICE debug mode acknowledgement Disabled.
 * |        |          |SC internal counter will keep going no matter CPU is held by ICE or not.
 * @var SC_T::ALTCTL
 * Offset: 0x08  SC Alternate Control Register.
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |TXRST     |TX Software Reset
 * |        |          |When TXRST is set, all the bytes in the transmit buffer and TX internal state machine will be cleared.
 * |        |          |0 = No effect.
 * |        |          |1 = Reset the TX internal state machine and pointers.
 * |        |          |Note:
 * |        |          |This bit will be auto cleared after reset is complete.
 * |[1]     |RXRST     |Rx Software Reset
 * |        |          |When RXRST is set, all the bytes in the receiver buffer and Rx internal state machine will be cleared.
 * |        |          |0 = No effect.
 * |        |          |1 = Reset the Rx internal state machine and pointers.
 * |        |          |Note:
 * |        |          |This bit will be auto cleared after reset is complete.
 * |[2]     |DACTEN    |Deactivation Sequence Generator Enable Bit
 * |        |          |This bit enables SC controller to initiate the card by deactivation sequence
 * |        |          |0 = No effect.
 * |        |          |1 = Deactivation sequence generator Enabled.
 * |        |          |Note1:
 * |        |          |When the deactivation sequence completed, this bit will be cleared automatically and the INITIF(SC_INTSTS[8]) will be set to 1.
 * |        |          |Note2:
 * |        |          |This field will be cleared by TXRST (SC_ALTCTL[0]) and RXRST(SC_ALTCTL[1]).
 * |        |          |So don't fill this bit, TXRST, and RXRST at the same time.
 * |        |          |Note3:
 * |        |          |If SCEN (SC_CTL[0]) is not enabled, this filed cannot be programmed.
 * |[3]     |ACTEN     |Activation Sequence Generator Enable Bit
 * |        |          |This bit enables SC controller to initiate the card by activation sequence
 * |        |          |0 = No effect.
 * |        |          |1 = Activation sequence generator Enabled.
 * |        |          |Note1:
 * |        |          |When the activation sequence completed, this bit will be cleared automatically and the INITIF(SC_INTSTS[8]) will be set to 1.
 * |        |          |Note2:
 * |        |          |This field will be cleared by TXRST(SC_ALTCTL[0]) and RXRST(SC_ALTCTL[1]), so don't fill this bit, TXRST(SC_ALTCTL[0]), and RXRST(SC_ALTCTL[1]) at the same time.
 * |        |          |Note3:
 * |        |          |If SCEN(SC_CTL[0]) is not enabled, this filed cannot be programmed.
 * |[4]     |WARSTEN   |Warm Reset Sequence Generator Enable Bit
 * |        |          |This bit enables SC controller to initiate the card by warm reset sequence
 * |        |          |0 = No effect.
 * |        |          |1 = Warm reset sequence generator Enabled.
 * |        |          |Note1:
 * |        |          |When the warm reset sequence completed, this bit will be cleared automatically and the INITIF(SC_INTSTS[8]) will be set to 1.
 * |        |          |Note2:
 * |        |          |This field will be cleared by TXRST(SC_ALTCTL[0]) and RXRST(SC_ALTCTL[1]), so don't fill this bit, TXRST, and RXRST at the same time.
 * |        |          |Note3:
 * |        |          |If SCEN(SC_CTL[0]) is not enabled, this filed cannot be programmed.
 * |[5]     |CNTEN0    |Internal Timer0 Start Enable Bit
 * |        |          |This bit enables Timer 0 to start counting.
 * |        |          |Software can fill 0 to stop it and set 1 to reload and count.
 * |        |          |0 = Stops counting.
 * |        |          |1 = Start counting.
 * |        |          |Note1:
 * |        |          |This field is used for internal 24 bit timer when TMRSEL (SC_CTL[14:13]) = 01.
 * |        |          |Note2:
 * |        |          |If the operation mode is not in auto-reload mode (SC_TMRCTL0[26] = 0), this bit will be auto-cleared by hardware.
 * |        |          |Note3:
 * |        |          |This field will be cleared by TXRST(SC_ALTCTL[0]) and RXRST(SC_ALTCTL[1]).
 * |        |          |So don't fill this bit, TXRST and RXRST at the same time.
 * |        |          |Note4: If SCEN(SC_CTL[0]) is not enabled, this filed cannot be programmed.
 * |[6]     |CNTEN1    |Internal Timer1 Start Enable Bit
 * |        |          |This bit enables Timer 1 to start counting.
 * |        |          |Software can fill 0 to stop it and set 1 to reload and count.
 * |        |          |0 = Stops counting.
 * |        |          |1 = Start counting.
 * |        |          |Note1:
 * |        |          |This field is used for internal 8 bit timer when TMRSEL(SC_CTL[14:13]) = 10 or TMRSEL(SC_CTL[14:13]) = 11.
 * |        |          |Don't filled CNTEN1 when TMRSEL(SC_CTL[14:13]) = 00 or TMRSEL(SC_CTL[14:13]) = 01.
 * |        |          |Note2:
 * |        |          |If the operation mode is not in auto-reload mode (SC_TMRCTL1[26] = 0), this bit will be auto-cleared by hardware.
 * |        |          |Note3:
 * |        |          |This field will be cleared by TXRST(SC_ALTCTL[0]) and RXRST(SC_ALTCTL[1]), so don't fill this bit, TXRST(SC_ALTCTL[0]), and RXRST(SC_ALTCTL[1]) at the same time.
 * |        |          |Note4:
 * |        |          |If SCEN(SC_CTL[0]) is not enabled, this filed cannot be programmed.
 * |[7]     |CNTEN2    |Internal Timer2 Start Enable Bit
 * |        |          |This bit enables Timer 2 to start counting.
 * |        |          |Software can fill 0 to stop it and set 1 to reload and count.
 * |        |          |0 = Stops counting.
 * |        |          |1 = Start counting.
 * |        |          |Note1:
 * |        |          |This field is used for internal 8 bit timer when TMRSEL(SC_CTL[14:13]) = 11.
 * |        |          |Don't filled CNTEN2 when TMRSEL(SC_CTL[14:13]) = 00 or TMRSEL(SC_CTL[14:13]) = 01 or TMRSEL(SC_CTL[14:13]) = 10.
 * |        |          |Note2:
 * |        |          |If the operation mode is not in auto-reload mode (SC_TMRCTL2[26] = 0), this bit will be auto-cleared by hardware.
 * |        |          |Note3:
 * |        |          |This field will be cleared by TXRST(SC_ALTCTL[0]) and RXRST(SC_ALTCTL[1]).
 * |        |          |So don't fill this bit, TXRST(SC_ALTCTL[0]), and RXRST(SC_ALTCTL[1]) at the same time.
 * |        |          |Note4:
 * |        |          |If SCEN(SC_CTL[0]) is not enabled, this filed cannot be programmed.
 * |[9:8]   |INITSEL   |Initial Timing Selection
 * |        |          |This fields indicates the timing of hardware initial state (activation or warm-reset or deactivation).
 * |        |          |Unit: SC clock
 * |        |          |Activation: refer to SC Activation Sequence in Figure 6.17-4
 * |        |          |Warm-reset: refer to Warm-Reset Sequence in Figure 6.17-5
 * |        |          |Deactivation: refer to Deactivation Sequence in Figure 6.17-6
 * |[12]    |RXBGTEN   |Receiver Block Guard Time Function Enable Bit
 * |        |          |0 = Receiver block guard time function Disabled.
 * |        |          |1 = Receiver block guard time function Enabled.
 * |[13]    |ACTSTS0   |Internal Timer0 Active State (Read Only)
 * |        |          |This bit indicates the timer counter status of timer0.
 * |        |          |0 = Timer0 is not active.
 * |        |          |1 = Timer0 is active.
 * |[14]    |ACTSTS1   |Internal Timer1 Active State (Read Only)
 * |        |          |This bit indicates the timer counter status of timer1.
 * |        |          |0 = Timer1 is not active.
 * |        |          |1 = Timer1 is active.
 * |[15]    |ACTSTS2   |Internal Timer2 Active State (Read Only)
 * |        |          |This bit indicates the timer counter status of timer2.
 * |        |          |0 = Timer2 is not active.
 * |        |          |1 = Timer2 is active.
 * @var SC_T::EGT
 * Offset: 0x0C  SC Extend Guard Time Register.
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[7:0]   |EGT       |Extended Guard Time
 * |        |          |This field indicates the extended guard timer value.
 * |        |          |Note:
 * |        |          |The counter is ETU base and the real extended guard time is EGT.
 * @var SC_T::RXTOUT
 * Offset: 0x10  SC Receive buffer Time-out Register.
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[8:0]   |RFTM      |SC Receiver FIFO Time-out (ETU Base)
 * |        |          |The time-out counter resets and starts counting whenever the RX buffer received a new data word.
 * |        |          |Once the counter decrease to 1 and no new data is received or CPU does not read data by reading SC_DAT buffer, a receiver time-out interrupt INT_RTMR will be generated(if RXTOIF(SC_INTEN[9]) = 1 ).
 * |        |          |Note1: The counter unit is ETU based and the interval of time-out is RFTM + 0.5.
 * |        |          |Note2:
 * |        |          |Filling all 0 to this field indicates to disable this function.
 * @var SC_T::ETUCTL
 * Offset: 0x14  SC ETU Control Register.
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[11:0]  |ETURDIV   |ETU Rate Divider
 * |        |          |The field indicates the clock rate divider.
 * |        |          |The real ETU is ETURDIV + 1.
 * |        |          |Note:
 * |        |          |Software can configure this field, but this field must be greater than 0x004.
 * |[15]    |CMPEN     |Compensation Mode Enable Bit
 * |        |          |This bit enables clock compensation function.
 * |        |          |When this bit enabled, hardware will alternate between n clock cycles and n-1 clock cycles, where n is the value to be written into the ETURDIV .
 * |        |          |0 = Compensation function Disabled.
 * |        |          |1 = Compensation function Enabled.
 * @var SC_T::INTEN
 * Offset: 0x18  SC Interrupt Enable Control Register.
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |RDAIEN    |Receive Data Reach Interrupt Enable Bit
 * |        |          |This field is used for received data reaching trigger level RXTRGLV (SC_CTL[7:6]) interrupt enable.
 * |        |          |0 = Receive data reach trigger level interrupt Disabled.
 * |        |          |1 = Receive data reach trigger level interrupt Enabled.
 * |[1]     |TBEIEN    |Transmit Buffer Empty Interrupt Enable Bit
 * |        |          |This field is used for transmit buffer empty interrupt enable.
 * |        |          |0 = Transmit buffer empty interrupt Disabled.
 * |        |          |1 = Transmit buffer empty interrupt Enabled.
 * |[2]     |TERRIEN   |Transfer Error Interrupt Enable Bit
 * |        |          |This field is used for transfer error interrupt enable.
 * |        |          |The transfer error states is at SC_STATUS register which includes receiver break error BEF(SC_STATUS[6]), frame error FEF(SC_STATUS[5]), parity error PEF(SC_STATUS[4]), receiver buffer overflow error RXOV(SC_STATUS[0]), transmit buffer overflow error TXOV(SC_STATUS[8]), receiver retry over limit error RXOVERR(SC_STATUS[22]) and transmitter retry over limit error TXOVERR (SC_STATUS[30]).
 * |        |          |0 = Transfer error interrupt Disabled.
 * |        |          |1 = Transfer error interrupt Enabled.
 * |[3]     |TMR0IEN   |Timer0 Interrupt Enable Bit
 * |        |          |This field is used to enable TMR0 interrupt enable.
 * |        |          |0 = Timer0 interrupt Disabled.
 * |        |          |1 = Timer0 interrupt Enabled.
 * |[4]     |TMR1IEN   |Timer1 Interrupt Enable Bit
 * |        |          |This field is used to enable the TMR1 interrupt.
 * |        |          |0 = Timer1 interrupt Disabled.
 * |        |          |1 = Timer1 interrupt Enabled.
 * |[5]     |TMR2IEN   |Timer2 Interrupt Enable Bit
 * |        |          |This field is used for TMR2 interrupt enable.
 * |        |          |0 = Timer2 interrupt Disabled.
 * |        |          |1 = Timer2 interrupt Enabled.
 * |[6]     |BGTIEN    |Block Guard Time Interrupt Enable Bit
 * |        |          |This field is used for block guard time interrupt enable.
 * |        |          |0 = Block guard time Disabled.
 * |        |          |1 = Block guard time Enabled.
 * |[7]     |CDIEN     |Card Detect Interrupt Enable Bit
 * |        |          |This field is used for card detect interrupt enable. The card detect status is CINSERT(SC_STATUS[12])
 * |        |          |0 = Card detect interrupt Disabled.
 * |        |          |1 = Card detect interrupt Enabled.
 * |[8]     |INITIEN   |Initial End Interrupt Enable Bit
 * |        |          |This field is used for activation (ACTEN(SC_ALTCTL[3] = 1)), deactivation ((DACTEN SC_ALTCTL[2]) = 1) and warm reset (WARSTEN (SC_ALTCTL [4])) sequence interrupt enable.
 * |        |          |0 = Initial end interrupt Disabled.
 * |        |          |1 = Initial end interrupt Enabled.
 * |[9]     |RXTOIF    |Receiver Buffer Time-Out Interrupt Enable Bit
 * |        |          |This field is used for receiver buffer time-out interrupt enable.
 * |        |          |0 = Receiver buffer time-out interrupt Disabled.
 * |        |          |1 = Receiver buffer time-out interrupt Enabled.
 * |[10]    |ACERRIEN  |Auto Convention Error Interrupt Enable Bit
 * |        |          |This field is used for auto-convention error interrupt enable.
 * |        |          |0 = Auto-convention error interrupt Disabled.
 * |        |          |1 = Auto-convention error interrupt Enabled.
 * @var SC_T::INTSTS
 * Offset: 0x1C  SC Interrupt Status Register.
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |RDAIF     |Receive Data Reach Interrupt Status Flag (Read Only)
 * |        |          |This field is used for received data reaching trigger level RXTRGLV (SC_CTL[7:6]) interrupt status flag.
 * |        |          |Note: This field is the status flag of received data reaching RXTRGLV (SC_CTL[7:6]).
 * |        |          |If software reads data from SC_DAT and receiver buffer data byte number is less than RXTRGLV (SC_CTL[7:6]), this bit will be cleared automatically.
 * |[1]     |TBEIF     |Transmit Buffer Empty Interrupt Status Flag (Read Only)
 * |        |          |This field is used for transmit buffer empty interrupt status flag.
 * |        |          |Note: This field is the status flag of transmit buffer empty state.
 * |        |          |If software wants to clear this bit, software must write data to DAT(SC_DAT[7:0]) buffer and then this bit will be cleared automatically.
 * |[2]     |TERRIF    |Transfer Error Interrupt Status Flag (Read Only)
 * |        |          |This field is used for transfer error interrupt status flag.
 * |        |          |The transfer error states is at SC_STATUS register which includes receiver break error BEF(SC_STATUS[6]), frame error FEF(SC_STATUS[5]), parity error PEF(SC_STATUS[4]) and receiver buffer overflow error RXOV(SC_STATUS[0]), transmit buffer overflow error TXOV(SC_STATUS[8]), receiver retry over limit error RXOVERR(SC_STATUS[22]) and transmitter retry over limit error TXOVERR(SC_STATUS[30]).
 * |        |          |Note: This field is the status flag of
 * |        |          |BEF(SC_STATUS[6]), FEF(SC_STATUS[5]), PEF(SC_STATUS[4]), RXOV(SC_STATUS[0]), TXOV(SC_STATUS[8]), RXOVERR(SC_STATUS[22]) or TXOVERR(SC_STATUS[30]).
 * |        |          |So, if software wants to clear this bit, software must write 1 to each field.
 * |[3]     |TMR0IF    |Timer0 Interrupt Status Flag (Read Only)
 * |        |          |This field is used for TMR0 interrupt status flag.
 * |        |          |Note: This bit is read only, but it can be cleared by writing 1 to it.
 * |[4]     |TMR1IF    |Timer1 Interrupt Status Flag (Read Only)
 * |        |          |This field is used for TMR1 interrupt status flag.
 * |        |          |Note: This bit is read only, but it can be cleared by writing 1 to it.
 * |[5]     |TMR2IF    |Timer2 Interrupt Status Flag (Read Only)
 * |        |          |This field is used for TMR2 interrupt status flag.
 * |        |          |Note: This bit is read only, but it can be cleared by writing 1 to it.
 * |[6]     |BGTIF     |Block   Guard Time Interrupt Status Flag (Read Only)
 * |        |          |This field   is used for block guard time interrupt status flag.
 * |        |          |Note1: This bit is valid when RXBGTEN   (SC_ALTCTL[12]) is enabled.
 * |        |          |Note2: This bit is read only, but it can be cleared by   writing "1" to it.
 * |[7]     |CDIF      |Card Detect Interrupt Status Flag (Read Only)
 * |        |          |This field is used for card detect interrupt status flag.
 * |        |          |The card detect status is CINSERT (SC_STATUS[12]) and CREMOVE(SC_STATUS[11]).
 * |        |          |Note:
 * |        |          |This field is the status flag of CINSERT(SC_STATUS[12]) or CREMOVE(SC_STATUS[11])].
 * |        |          |So if software wants to clear this bit, software must write 1 to this field.
 * |[8]     |INITIF    |Initial End Interrupt Status Flag (Read Only)
 * |        |          |This field is used for activation (ACTEN(SC_ALTCTL[3])), deactivation (DACTEN (SC_ALTCTL[2])) and warm reset (WARSTEN (SC_ALTCTL[4])) sequence interrupt status flag.
 * |        |          |Note: This bit is read only, but it can be cleared by writing 1 to it.
 * |[9]     |RBTOIF    |Receiver Buffer Time-Out Interrupt Status Flag (Read Only)
 * |        |          |This field is used for receiver buffer time-out interrupt status flag.
 * |        |          |Note: This field is the status flag of receiver buffer time-out state.
 * |        |          |If software wants to clear this bit, software must read all receiver buffer remaining data by reading SC_DAT buffer,.
 * |[10]    |ACERRIF   |Auto Convention Error Interrupt Status Flag (Read Only)
 * |        |          |This field indicates auto convention sequence error.
 * |        |          |If the received TS at ATR state is neither 0x3B nor 0x3F, this bit will be set.
 * |        |          |Note: This bit is read only, but it can be cleared by writing 1 to it.
 * @var SC_T::STATUS
 * Offset: 0x20  SC Status Register.
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |RXOV      |RX Overflow Error Status Flag (Read Only)
 * |        |          |This bit is set when RX buffer overflow.
 * |        |          |If the number of received bytes is greater than Rx Buffer size (4 bytes), this bit will be set.
 * |        |          |Note: This bit is read only, but it can be cleared by writing 1 to it.
 * |[1]     |RXEMPTY   |Receiver Buffer Empty Status Flag(Read Only)
 * |        |          |This bit indicates RX buffer empty or not.
 * |        |          |When the last byte of Rx buffer has been read by CPU, hardware sets this bit high.
 * |        |          |It will be cleared when SC receives any new data.
 * |[2]     |RXFULL    |Receiver Buffer Full Status Flag (Read Only)
 * |        |          |This bit indicates RX buffer full or not.
 * |        |          |This bit is set when RX pointer is equal to 4, otherwise it is cleared by hardware.
 * |[4]     |PEF       |Receiver Parity Error Status Flag (Read Only)
 * |        |          |This bit is set to logic 1 whenever the received character does not have a valid
 * |        |          |"parity bit".
 * |        |          |Note1:
 * |        |          |This bit is read only, but it can be cleared by writing 1 to it.
 * |        |          |Note2:
 * |        |          |If CPU sets receiver retries function by setting RXRTYEN(SC_CTL[19]) , hardware will not set this flag.
 * |[5]     |FEF       |Receiver Frame Error Status Flag (Read Only)
 * |        |          |This bit is set to logic 1 whenever the received character does not have a valid "stop bit" (that is, the stop bit following the last data bit or parity bit is detected as logic 0).
 * |        |          |Note1:
 * |        |          |This bit is read only, but it can be cleared by writing 1 to it.
 * |        |          |Note2:
 * |        |          |If CPU sets receiver retries function by setting RXRTYEN(SC_CTL[19]) , hardware will not set this flag.
 * |[6]     |BEF       |Receiver Break Error Status Flag (Read Only)
 * |        |          |This bit is set to logic 1 whenever the received data input (RX) held in the "spacing state" (logic 0) is longer than a full word transmission time (that is, the total time of "start bit" + data bits + parity + stop bits).
 * |        |          |.
 * |        |          |Note1:
 * |        |          |This bit is read only, but it can be cleared by writing 1 to it.
 * |        |          |Note2:
 * |        |          |If CPU sets receiver retries function by setting RXRTYEN(SC_CTL[19]) , hardware will not set this flag.
 * |[8]     |TXOV      |TX Overflow Error Interrupt Status Flag (Read Only)
 * |        |          |If TX buffer is full, an additional write to DAT(SC_DAT[7:0]) will cause this bit be set to "1" by hardware.
 * |        |          |Note: This bit is read only, but it can be cleared by writing 1 to it.
 * |[9]     |TXEMPTY   |Transmit Buffer Empty Status Flag (Read Only)
 * |        |          |This bit indicates TX buffer empty or not.
 * |        |          |When the last byte of TX buffer has been transferred to Transmitter Shift Register, hardware sets this bit high.
 * |        |          |It will be cleared when writing data into DAT(SC_DAT[7:0]) (TX buffer not empty).
 * |[10]    |TXFULL    |Transmit Buffer Full Status Flag (Read Only)
 * |        |          |This bit indicates TX buffer full or not.This bit is set when TX pointer is equal to 4, otherwise is cleared by hardware.
 * |[11]    |CREMOVE   |Card Detect Removal Status Of SC_CD Pin (Read Only)
 * |        |          |This bit is set whenever card has been removal.
 * |        |          |0 = No effect.
 * |        |          |1 = Card removed.
 * |        |          |Note1: This bit is read only, but it can be cleared by writing "1" to it.
 * |        |          |Note2: Card detect engine will start after SCEN (SC_CTL[0])set.
 * |[12]    |CINSERT   |Card Detect Insert Status Of SC_CD Pin (Read Only)
 * |        |          |This bit is set whenever card has been inserted.
 * |        |          |0 = No effect.
 * |        |          |1 = Card insert.
 * |        |          |Note1: This bit is read only, but it can be cleared by writing "1" to it.
 * |        |          |Note2: The
 * |        |          |card detect engine will start after SCEN (SC_CTL[0]) set.
 * |[13]    |CDPINSTS  |Card Detect Status Of SC_CD Pin Status (Read Only)
 * |        |          |This bit is the pin status flag of SC_CD
 * |        |          |0 = The SC_CD pin state at low.
 * |        |          |1 = The SC_CD pin state at high.
 * |[17:16] |RXPOINT   |Receiver Buffer Pointer Status Flag (Read Only)
 * |        |          |This field indicates the RX buffer pointer status flag.
 * |        |          |When SC receives one byte from external device, RXPOINT(SC_STATUS[17:16]) increases one.
 * |        |          |When one byte of RX buffer is read by CPU, RXPOINT(SC_STATUS[17:16]) decreases one.
 * |[21]    |RXRERR    |Receiver Retry Error (Read Only)
 * |        |          |This bit is set by hardware when RX has any error and retries transfer.
 * |        |          |Note1: This bit is read only, but it can be cleared by writing 1 to it.
 * |        |          |Note2 This bit is a flag and cannot generate any interrupt to CPU.
 * |        |          |Note3: If CPU enables receiver retry function by setting RXRTYEN (SC_CTL[19]) , the PEF(SC_STATUS[4]) flag will be ignored (hardware will not set PEF(SC_STATUS[4])).
 * |[22]    |RXOVERR   |Receiver Over Retry Error (Read Only)
 * |        |          |This bit is set by hardware when RX transfer error retry over retry number limit.
 * |        |          |Note1: This bit is read only, but it can be cleared by writing 1 to it.
 * |        |          |Note2: If CPU enables receiver retries function by setting RXRTYEN (SC_CTL[19]), the PEF(SC_STATUS[4]) flag will be ignored (hardware will not set PEF(SC_STATUS[4])).
 * |[23]    |RXACT     |Receiver In Active Status Flag (Read Only)
 * |        |          |This bit is set by hardware when RX transfer is in active.
 * |        |          |This bit is cleared automatically when RX transfer is finished.
 * |[25:24] |TXPOINT   |Transmit Buffer Pointer Status Flag (Read Only)
 * |        |          |This field indicates the TX buffer pointer status flag.
 * |        |          |When CPU writes data into SC_DAT, TXPOINT increases one.
 * |        |          |When one byte of TX Buffer is transferred to transmitter shift register, TXPOINT decreases one.
 * |[29]    |TXRERR    |Transmitter Retry Error (Read Only)
 * |        |          |This bit is set by hardware when transmitter re-transmits.
 * |        |          |Note1: This bit is read only, but it can be cleared by writing 1 to it.
 * |        |          |Note2 This bit is a flag and cannot generate any interrupt to CPU.
 * |[30]    |TXOVERR   |Transmitter Over Retry Error (Read Only)
 * |        |          |This bit is set by hardware when transmitter re-transmits over retry number limitation.
 * |        |          |Note: This bit is read only, but it can be cleared by writing 1 to it.
 * |[31]    |TXACT     |Transmit In Active Status Flag (Read Only)
 * |        |          |0 = This bit is cleared automatically when TX transfer is finished or the last byte transmission has completed.
 * |        |          |1 = This bit is set by hardware when TX transfer is in active and the STOP bit of the last byte has been transmitted.
 * @var SC_T::PINCTL
 * Offset: 0x24  SC Pin Control State Register.
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |PWREN     |SC_PWREN Pin Signal
 * |        |          |Software can set PWREN (SC_PINCTL[0]) and PWRINV (SC_PINCTL[11])to decide SC_PWR pin is in high or low level.
 * |        |          |Write this field to drive SC_PWR pin
 * |        |          |Refer PWRINV (SC_PINCTL[11]) description for programming SC_PWR pin voltage level.
 * |        |          |Read this field to get SC_PWR pin status.
 * |        |          |0 = SC_PWR pin status is low.
 * |        |          |1 = SC_PWR pin status is high.
 * |        |          |Note: When operating at activation, warm reset or deactivation mode, this bit will be changed automatically.
 * |        |          |So don't fill this field when operating in these modes.
 * |[1]     |SCRST     |SC_RST Pin Signal
 * |        |          |This bit is the pin status of SC_RST but user can drive SC_RST pin to high or low by setting this bit.
 * |        |          |Write this field to drive SC_RST pin.
 * |        |          |0 = Drive SC_RST pin to low.
 * |        |          |1 = Drive SC_RST pin to high.
 * |        |          |Read this field to get SC_RST pin status.
 * |        |          |0 = SC_RST pin status is low.
 * |        |          |1 = SC_RST pin status is high.
 * |        |          |Note: When operating at activation, warm reset or deactivation mode, this bit will be changed automatically.
 * |        |          |So don't fill this field when operating in these modes.
 * |[5]     |CSTOPLV   |SC Clock Stop Level
 * |        |          |This field indicates the clock polarity control in clock stop mode.
 * |        |          |0 = SC_CLK stopped in low level.
 * |        |          |1 = SC_CLK stopped in high level.
 * |[6]     |CLKKEEP   |SC Clock Enable Bit
 * |        |          |0 = SC clock generation Disabled.
 * |        |          |1 = SC clock always keeps free running.
 * |        |          |Note: When operating in activation, warm reset or deactivation mode, this bit will be changed automatically.
 * |        |          |So don't fill this field when operating in these modes.
 * |[9]     |SCDOUT    |SC Data Output Pin
 * |        |          |This bit is the pin status of SCDATOUT but user can drive SCDATOUT pin to high or low by setting this bit.
 * |        |          |0 = Drive SCDATOUT pin to low.
 * |        |          |1 = Drive SCDATOUT pin to high.
 * |        |          |Note: When SC is at activation, warm reset or deactivation mode, this bit will be changed automatically.
 * |        |          |So don't fill this field when SC is in these modes.
 * |[11]    |PWRINV    |SC_POW Pin Inverse
 * |        |          |This bit is used for inverse the SC_POW pin.
 * |        |          |There are four kinds of combination for SC_POW pin setting by PWRINV(SC_PINCTL[11]) and PWREN(SC_PINCTL[0]).
 * |        |          |PWRINV (SC_PINCTL[11]) is bit 1 and PWREN(SC_PINCTL[0]) is bit 0 for SC_POW_Pin as high or low voltage selection.
 * |        |          |00 = SC_POW_ Pin is 0.
 * |        |          |01 = SC_POW _Pin is 1.
 * |        |          |10 = SC_POW _Pin is 1.
 * |        |          |11 = SC_POW_ Pin is 0.
 * |        |          |Note: Software must select PWRINV (SC_PINCTL[11]) before Smart Card is enabled by SCEN (SC_CTL[0]).
 * |[12]    |SCDOSTS   |SC Data Pin Output Status
 * |        |          |This bit is the pin status of SCDATOUT
 * |        |          |0 = SCDATOUT pin to low.
 * |        |          |1 = SCDATOUT pin to high.
 * |        |          |Note: When SC is operated at activation, warm reset or deactivation mode, this bit will be changed automatically.
 * |        |          |This bit is not allowed to program when SC is operated at these modes.
 * |[16]    |DATSTS    |This bit   is the pin status of SC_DAT
 * |        |          |0 = The   SC_DAT pin is low.
 * |        |          |1 = The   SC_DAT pin is high.
 * |[17]    |PWRSTS    |SC_PWR   Pin Signal
 * |        |          |This bit   is the pin status of SC_PWR
 * |        |          |0 = SC_PWR   pin to low.
 * |        |          |1 = SC_PWR   pin to high.
 * |        |          |Note: When SC is operated at activation, warm reset or deactivation mode, this bit will be changed automatically.
 * |        |          |This bit is not allowed to program when SC is operated at these modes.
 * |[18]    |RSTSTS    |SCRST Pin Signals
 * |        |          |This bit is the pin status of SC_RST
 * |        |          |0 = SC_RST pin is low.
 * |        |          |1 = SC_RST pin is high.
 * |        |          |Note: When SC is operated at activation, warm reset or deactivation mode, this bit will be changed automatically.
 * |        |          |This bit is not allowed to program when SC is operated at these modes.
 * |[30]    |SYNC      |SYNC Flag Indicator
 * |        |          |Due to synchronization, software should check this bit when writing a new value to SC_PINCTL register.
 * |        |          |0 = Synchronizing is completion, user can write new data to SC_PINCTL register.
 * |        |          |1 = Last value is synchronizing.
 * |        |          |Note: This bit is read only.
 * |[31]    |LOOPBK    |Loop Back Test
 * |        |          |0 = loop back test Disabled.
 * |        |          |1 = Enabling loop back test and the internal SCDATOUT will connect to internal SC_DATA_I.
 * @var SC_T::TMRCTL0
 * Offset: 0x28  SC Internal Timer Control Register 0.
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[23:0]  |CNT       |Timer 0 Counter Value (ETU Base)
 * |        |          |This field indicates the internal timer operation values.
 * |[27:24] |OPMODE    |Timer 0 Operation Mode Selection
 * |        |          |This field indicates the internal 24-bit timer operation selection.
 * |        |          |Refer to 6.17.5.4 for programming Timer0
 * @var SC_T::TMRCTL1
 * Offset: 0x2C  SC Internal Timer Control Register 1.
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[7:0]   |CNT       |Timer 1 Counter Value (ETU Base)
 * |        |          |This field indicates the internal timer operation values.
 * |[27:24] |OPMODE    |Timer 1 Operation Mode Selection
 * |        |          |This field indicates the internal 8-bit timer operation selection.
 * |        |          |Refer to 6.17.5.4 for programming Timer1
 * @var SC_T::TMRCTL2
 * Offset: 0x30  SC Internal Timer Control Register 2.
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[7:0]   |CNT       |Timer 2 Counter Value (ETU Base)
 * |        |          |This field indicates the internal timer operation values.
 * |[27:24] |OPMODE    |Timer 2 Operation Mode Selection
 * |        |          |This field indicates the internal 8-bit timer operation selection
 * |        |          |Refer to 6.17.5.4 for programming Timer2
 * @var SC_T::UARTCTL
 * Offset: 0x34  SC UART Mode Control Register.
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |UARTEN    |UART Mode Enable Bit
 * |        |          |0 = Smart Card mode.
 * |        |          |1 = UART mode.
 * |        |          |Note1: When operating in UART mode, user must set CONSEL (SC_CTL[5:4]) = 00 and AUTOCEN(SC_CTL[3]) = 0.
 * |        |          |Note2: When operating in Smart Card mode, user must set UARTEN(SC_UARTCTL [0]) = 00.
 * |        |          |Note3: When UART is enabled, hardware will generate a reset to reset FIFO and internal state machine.
 * |[5:4]   |WLS10     |Word Length Selection
 * |        |          |00 = Word length is 8 bits.
 * |        |          |01 = Word length is 7 bits.
 * |        |          |10 = Word length is 6 bits.
 * |        |          |11 = Word length is 5 bits.
 * |        |          |Note: In smart card mode, this WLS must be '00'
 * |[6]     |PBOFF     |Parity Bit Disable Control
 * |        |          |0 = Parity bit is generated or checked between the "last data word bit" and "stop bit" of the serial data.
 * |        |          |1 = Parity bit is not generated (transmitting data) or checked (receiving data) during transfer.
 * |        |          |Note: In smart card mode, this field must be '0' (default setting is with parity bit)
 * |[7]     |OPE       |Odd Parity Enable Bit
 * |        |          |0 = Even number of logic 1's are transmitted or check the data word and parity bits in receiving mode.
 * |        |          |1 = Odd number of logic 1's are transmitted or check the data word and parity bits in receiving mode.
 * |        |          |Note: This bit has effect only when PBOFF bit is '0'.
 * @var SC_T::TMRDAT0
 * Offset: 0x38  SC Timer Current Data Register A.
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[23:0]  |CNT0      |Timer0 Current Data Value (Read Only)
 * |        |          |This field indicates the current count values of timer0.
 * @var SC_T::TMRDAT1_2
 * Offset: 0x3C  SC Timer Current Data Register B.
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[7:0]   |CNT1      |Timer1 Current Data Value (Read Only)
 * |        |          |This field indicates the current count values of timer1.
 * |[15:8]  |CNT2      |Timer2 Current Data Value (Read Only)
 * |        |          |This field indicates the current count values of timer2.
 */

    __IO uint32_t DAT;           /* Offset: 0x00  SC Receiving/Transmit Holding Buffer Register.                     */
    __IO uint32_t CTL;           /* Offset: 0x04  SC Control Register.                                               */
    __IO uint32_t ALTCTL;        /* Offset: 0x08  SC Alternate Control Register.                                     */
    __IO uint32_t EGT;           /* Offset: 0x0C  SC Extend Guard Time Register.                                     */
    __IO uint32_t RXTOUT;        /* Offset: 0x10  SC Receive buffer Time-out Register.                               */
    __IO uint32_t ETUCTL;        /* Offset: 0x14  SC ETU Control Register.                                           */
    __IO uint32_t INTEN;         /* Offset: 0x18  SC Interrupt Enable Control Register.                              */
    __IO uint32_t INTSTS;        /* Offset: 0x1C  SC Interrupt Status Register.                                      */
    __IO uint32_t STATUS;        /* Offset: 0x20  SC Status Register.                                                */
    __IO uint32_t PINCTL;        /* Offset: 0x24  SC Pin Control State Register.                                     */
    __IO uint32_t TMRCTL0;       /* Offset: 0x28  SC Internal Timer Control Register 0.                              */
    __IO uint32_t TMRCTL1;       /* Offset: 0x2C  SC Internal Timer Control Register 1.                              */
    __IO uint32_t TMRCTL2;       /* Offset: 0x30  SC Internal Timer Control Register 2.                              */
    __IO uint32_t UARTCTL;       /* Offset: 0x34  SC UART Mode Control Register.                                     */
    __I  uint32_t TMRDAT0;       /* Offset: 0x38  SC Timer Current Data Register A.                                  */
    __I  uint32_t TMRDAT1_2;     /* Offset: 0x3C  SC Timer Current Data Register B.                                  */

} SC_T;



/**
    @addtogroup SC_CONST SC Bit Field Definition
    Constant Definitions for SC Controller
@{ */

#define SC_DAT_DAT_Pos                   (0)                                        /*!< SC_T::DAT: DAT Position   */
#define SC_DAT_DAT_Msk                   (0xfful << SC_DAT_DAT_Pos)                 /*!< SC_T::DAT: DAT Mask       */

#define SC_CTL_SCEN_Pos                  (0)                                        /*!< SC_T::CTL: SCEN Position  */
#define SC_CTL_SCEN_Msk                  (0x1ul << SC_CTL_SCEN_Pos)                 /*!< SC_T::CTL: SCEN Mask      */

#define SC_CTL_RXOFF_Pos                 (1)                                        /*!< SC_T::CTL: RXOFF Position */
#define SC_CTL_RXOFF_Msk                 (0x1ul << SC_CTL_RXOFF_Pos)                /*!< SC_T::CTL: RXOFF Mask     */

#define SC_CTL_TXOFF_Pos                 (2)                                        /*!< SC_T::CTL: TXOFF Position */
#define SC_CTL_TXOFF_Msk                 (0x1ul << SC_CTL_TXOFF_Pos)                /*!< SC_T::CTL: TXOFF Mask     */

#define SC_CTL_AUTOCEN_Pos               (3)                                        /*!< SC_T::CTL: AUTOCEN Position   */
#define SC_CTL_AUTOCEN_Msk               (0x1ul << SC_CTL_AUTOCEN_Pos)              /*!< SC_T::CTL: AUTOCEN Mask       */

#define SC_CTL_CONSEL_Pos                (4)                                        /*!< SC_T::CTL: CONSEL Position    */
#define SC_CTL_CONSEL_Msk                (0x3ul << SC_CTL_CONSEL_Pos)               /*!< SC_T::CTL: CONSEL Mask        */

#define SC_CTL_RXTRGLV_Pos               (6)                                        /*!< SC_T::CTL: RXTRGLV Position   */
#define SC_CTL_RXTRGLV_Msk               (0x3ul << SC_CTL_RXTRGLV_Pos)              /*!< SC_T::CTL: RXTRGLV Mask       */

#define SC_CTL_BGT_Pos                   (8)                                        /*!< SC_T::CTL: BGT Position   */
#define SC_CTL_BGT_Msk                   (0x1ful << SC_CTL_BGT_Pos)                 /*!< SC_T::CTL: BGT Mask       */

#define SC_CTL_TMRSEL_Pos                (13)                                       /*!< SC_T::CTL: TMRSEL Position    */
#define SC_CTL_TMRSEL_Msk                (0x3ul << SC_CTL_TMRSEL_Pos)               /*!< SC_T::CTL: TMRSEL Mask        */

#define SC_CTL_NSB_Pos                   (15)                                       /*!< SC_T::CTL: NSB Position   */
#define SC_CTL_NSB_Msk                   (0x1ul << SC_CTL_NSB_Pos)                  /*!< SC_T::CTL: NSB Mask       */

#define SC_CTL_RXRTY_Pos                 (16)                                       /*!< SC_T::CTL: RXRTY Position */
#define SC_CTL_RXRTY_Msk                 (0x7ul << SC_CTL_RXRTY_Pos)                /*!< SC_T::CTL: RXRTY Mask     */

#define SC_CTL_RXRTYEN_Pos               (19)                                       /*!< SC_T::CTL: RXRTYEN Position   */
#define SC_CTL_RXRTYEN_Msk               (0x1ul << SC_CTL_RXRTYEN_Pos)              /*!< SC_T::CTL: RXRTYEN Mask       */

#define SC_CTL_TXRTY_Pos                 (20)                                       /*!< SC_T::CTL: TXRTY Position */
#define SC_CTL_TXRTY_Msk                 (0x7ul << SC_CTL_TXRTY_Pos)                /*!< SC_T::CTL: TXRTY Mask     */

#define SC_CTL_TXRTYEN_Pos               (23)                                       /*!< SC_T::CTL: TXRTYEN Position   */
#define SC_CTL_TXRTYEN_Msk               (0x1ul << SC_CTL_TXRTYEN_Pos)              /*!< SC_T::CTL: TXRTYEN Mask       */

#define SC_CTL_CDDBSEL_Pos               (24)                                       /*!< SC_T::CTL: CDDBSEL Position   */
#define SC_CTL_CDDBSEL_Msk               (0x3ul << SC_CTL_CDDBSEL_Pos)              /*!< SC_T::CTL: CDDBSEL Mask       */

#define SC_CTL_CDLV_Pos                  (26)                                       /*!< SC_T::CTL: CDLV Position  */
#define SC_CTL_CDLV_Msk                  (0x1ul << SC_CTL_CDLV_Pos)                 /*!< SC_T::CTL: CDLV Mask      */

#define SC_CTL_SYNC_Pos                  (30)                                       /*!< SC_T::CTL: SYNC Position  */
#define SC_CTL_SYNC_Msk                  (0x1ul << SC_CTL_SYNC_Pos)                 /*!< SC_T::CTL: SYNC Mask      */

#define SC_CTL_ICEDEBUG_Pos              (31)                                       /*!< SC_T::CTL: ICEDEBUG Position  */
#define SC_CTL_ICEDEBUG_Msk              (0x1ul << SC_CTL_ICEDEBUG_Pos)             /*!< SC_T::CTL: ICEDEBUG Mask      */

#define SC_ALTCTL_TXRST_Pos              (0)                                        /*!< SC_T::ALTCTL: TXRST Position  */
#define SC_ALTCTL_TXRST_Msk              (0x1ul << SC_ALTCTL_TXRST_Pos)             /*!< SC_T::ALTCTL: TXRST Mask      */

#define SC_ALTCTL_RXRST_Pos              (1)                                        /*!< SC_T::ALTCTL: RXRST Position  */
#define SC_ALTCTL_RXRST_Msk              (0x1ul << SC_ALTCTL_RXRST_Pos)             /*!< SC_T::ALTCTL: RXRST Mask      */

#define SC_ALTCTL_DACTEN_Pos             (2)                                        /*!< SC_T::ALTCTL: DACTEN Position */
#define SC_ALTCTL_DACTEN_Msk             (0x1ul << SC_ALTCTL_DACTEN_Pos)            /*!< SC_T::ALTCTL: DACTEN Mask     */

#define SC_ALTCTL_ACTEN_Pos              (3)                                        /*!< SC_T::ALTCTL: ACTEN Position  */
#define SC_ALTCTL_ACTEN_Msk              (0x1ul << SC_ALTCTL_ACTEN_Pos)             /*!< SC_T::ALTCTL: ACTEN Mask      */

#define SC_ALTCTL_WARSTEN_Pos            (4)                                        /*!< SC_T::ALTCTL: WARSTEN Position    */
#define SC_ALTCTL_WARSTEN_Msk            (0x1ul << SC_ALTCTL_WARSTEN_Pos)           /*!< SC_T::ALTCTL: WARSTEN Mask        */

#define SC_ALTCTL_CNTEN0_Pos             (5)                                        /*!< SC_T::ALTCTL: CNTEN0 Position */
#define SC_ALTCTL_CNTEN0_Msk             (0x1ul << SC_ALTCTL_CNTEN0_Pos)            /*!< SC_T::ALTCTL: CNTEN0 Mask     */

#define SC_ALTCTL_CNTEN1_Pos             (6)                                        /*!< SC_T::ALTCTL: CNTEN1 Position */
#define SC_ALTCTL_CNTEN1_Msk             (0x1ul << SC_ALTCTL_CNTEN1_Pos)            /*!< SC_T::ALTCTL: CNTEN1 Mask     */

#define SC_ALTCTL_CNTEN2_Pos             (7)                                        /*!< SC_T::ALTCTL: CNTEN2 Position */
#define SC_ALTCTL_CNTEN2_Msk             (0x1ul << SC_ALTCTL_CNTEN2_Pos)            /*!< SC_T::ALTCTL: CNTEN2 Mask     */

#define SC_ALTCTL_INITSEL_Pos            (8)                                        /*!< SC_T::ALTCTL: INITSEL Position    */
#define SC_ALTCTL_INITSEL_Msk            (0x3ul << SC_ALTCTL_INITSEL_Pos)           /*!< SC_T::ALTCTL: INITSEL Mask        */

#define SC_ALTCTL_ADACEN_Pos             (11)                                       /*!< SC_T::ALTCTL: ADACEN Position    */
#define SC_ALTCTL_ADACEN_Msk             (0x1ul << SC_ALTCTL_ADACEN_Pos)            /*!< SC_T::ALTCTL: ADACEN Mask        */

#define SC_ALTCTL_RXBGTEN_Pos            (12)                                       /*!< SC_T::ALTCTL: RXBGTEN Position    */
#define SC_ALTCTL_RXBGTEN_Msk            (0x1ul << SC_ALTCTL_RXBGTEN_Pos)           /*!< SC_T::ALTCTL: RXBGTEN Mask        */

#define SC_ALTCTL_ACTSTS0_Pos            (13)                                       /*!< SC_T::ALTCTL: ACTSTS0 Position    */
#define SC_ALTCTL_ACTSTS0_Msk            (0x1ul << SC_ALTCTL_ACTSTS0_Pos)           /*!< SC_T::ALTCTL: ACTSTS0 Mask        */

#define SC_ALTCTL_ACTSTS1_Pos            (14)                                       /*!< SC_T::ALTCTL: ACTSTS1 Position    */
#define SC_ALTCTL_ACTSTS1_Msk            (0x1ul << SC_ALTCTL_ACTSTS1_Pos)           /*!< SC_T::ALTCTL: ACTSTS1 Mask        */

#define SC_ALTCTL_ACTSTS2_Pos            (15)                                       /*!< SC_T::ALTCTL: ACTSTS2 Position    */
#define SC_ALTCTL_ACTSTS2_Msk            (0x1ul << SC_ALTCTL_ACTSTS2_Pos)           /*!< SC_T::ALTCTL: ACTSTS2 Mask        */

#define SC_ALTCTL_OUTSEL_Pos             (16)                                       /*!< SC_T::ALTCTL: OUTSEL Position */
#define SC_ALTCTL_OUTSEL_Msk             (0x1ul << SC_ALTCTL_OUTSEL_Pos)            /*!< SC_T::ALTCTL: OUTSEL Mask     */

#define SC_EGT_EGT_Pos                   (0)                                        /*!< SC_T::EGT: EGT Position   */
#define SC_EGT_EGT_Msk                   (0xfful << SC_EGT_EGT_Pos)                 /*!< SC_T::EGT: EGT Mask       */

#define SC_RXTOUT_RFTM_Pos               (0)                                        /*!< SC_T::RXTOUT: RFTM Position   */
#define SC_RXTOUT_RFTM_Msk               (0x1fful << SC_RXTOUT_RFTM_Pos)            /*!< SC_T::RXTOUT: RFTM Mask       */

#define SC_ETUCTL_ETURDIV_Pos            (0)                                        /*!< SC_T::ETUCTL: ETURDIV_ Position   */
#define SC_ETUCTL_ETURDIV_Msk            (0xffful << SC_ETUCTL_ETURDIV_Pos)         /*!< SC_T::ETUCTL: ETURDIV_ Mask       */

#define SC_ETUCTL_CMPEN_Pos              (15)                                       /*!< SC_T::ETUCTL: CMPEN_ Position */
#define SC_ETUCTL_CMPEN_Msk              (0x1ul << SC_ETUCTL_CMPEN_Pos)             /*!< SC_T::ETUCTL: CMPEN_ Mask     */

#define SC_INTEN_RDAIEN_Pos              (0)                                        /*!< SC_T::INTEN: RDAIEN Position  */
#define SC_INTEN_RDAIEN_Msk              (0x1ul << SC_INTEN_RDAIEN_Pos)             /*!< SC_T::INTEN: RDAIEN Mask      */

#define SC_INTEN_TBEIEN_Pos              (1)                                        /*!< SC_T::INTEN: TBEIEN Position  */
#define SC_INTEN_TBEIEN_Msk              (0x1ul << SC_INTEN_TBEIEN_Pos)             /*!< SC_T::INTEN: TBEIEN Mask      */

#define SC_INTEN_TERRIEN_Pos             (2)                                        /*!< SC_T::INTEN: TERRIEN Position */
#define SC_INTEN_TERRIEN_Msk             (0x1ul << SC_INTEN_TERRIEN_Pos)            /*!< SC_T::INTEN: TERRIEN Mask     */

#define SC_INTEN_TMR0IEN_Pos             (3)                                        /*!< SC_T::INTEN: TMR0IEN_Position */
#define SC_INTEN_TMR0IEN_Msk             (0x1ul << SC_INTEN_TMR0IEN_Pos)            /*!< SC_T::INTEN: TMR0IEN Mask     */

#define SC_INTEN_TMR1IEN_Pos             (4)                                        /*!< SC_T::INTEN: TMR1IEN Position */
#define SC_INTEN_TMR1IEN_Msk             (0x1ul << SC_INTEN_TMR1IEN_Pos)            /*!< SC_T::INTEN: TMR1IEN Mask     */

#define SC_INTEN_TMR2IEN_Pos             (5)                                        /*!< SC_T::INTEN: TMR2IEN Position */
#define SC_INTEN_TMR2IEN_Msk             (0x1ul << SC_INTEN_TMR2IEN_Pos)            /*!< SC_T::INTEN: TMR2IEN Mask     */

#define SC_INTEN_BGTIEN_Pos              (6)                                        /*!< SC_T::INTEN: BGTIEN Position  */
#define SC_INTEN_BGTIEN_Msk              (0x1ul << SC_INTEN_BGTIEN_Pos)             /*!< SC_T::INTEN: BGTIEN Mask      */

#define SC_INTEN_CDIEN_Pos               (7)                                        /*!< SC_T::INTEN: CDIEN Position   */
#define SC_INTEN_CDIEN_Msk               (0x1ul << SC_INTEN_CDIEN_Pos)              /*!< SC_T::INTEN: CDIEN Mask       */

#define SC_INTEN_INITIEN_Pos             (8)                                        /*!< SC_T::INTEN: INITIEN Position */
#define SC_INTEN_INITIEN_Msk             (0x1ul << SC_INTEN_INITIEN_Pos)            /*!< SC_T::INTEN: INITIEN Mask     */

#define SC_INTEN_RXTOIF_Pos              (9)                                        /*!< SC_T::INTEN: RXTOIF Position  */
#define SC_INTEN_RXTOIF_Msk              (0x1ul << SC_INTEN_RXTOIF_Pos)             /*!< SC_T::INTEN: RXTOIF Mask      */

#define SC_INTEN_ACERRIEN_Pos            (10)                                       /*!< SC_T::INTEN: ACERRIEN Position    */
#define SC_INTEN_ACERRIEN_Msk            (0x1ul << SC_INTEN_ACERRIEN_Pos)           /*!< SC_T::INTEN: ACERRIEN Mask        */

#define SC_INTSTS_RDAIF_Pos              (0)                                        /*!< SC_T::INTSTS: RDAIF Position  */
#define SC_INTSTS_RDAIF_Msk              (0x1ul << SC_INTSTS_RDAIF_Pos)             /*!< SC_T::INTSTS: RDAIF Mask      */

#define SC_INTSTS_TBEIF_Pos              (1)                                        /*!< SC_T::INTSTS: TBEIF Position  */
#define SC_INTSTS_TBEIF_Msk              (0x1ul << SC_INTSTS_TBEIF_Pos)             /*!< SC_T::INTSTS: TBEIF Mask      */

#define SC_INTSTS_TERRIF_Pos             (2)                                        /*!< SC_T::INTSTS: TERRIF Position */
#define SC_INTSTS_TERRIF_Msk             (0x1ul << SC_INTSTS_TERRIF_Pos)            /*!< SC_T::INTSTS: TERRIF Mask     */

#define SC_INTSTS_TMR0IF_Pos             (3)                                        /*!< SC_T::INTSTS: TMR0IF Position */
#define SC_INTSTS_TMR0IF_Msk             (0x1ul << SC_INTSTS_TMR0IF_Pos)            /*!< SC_T::INTSTS: TMR0IF Mask     */

#define SC_INTSTS_TMR1IF_Pos             (4)                                        /*!< SC_T::INTSTS: TMR1IF Position */
#define SC_INTSTS_TMR1IF_Msk             (0x1ul << SC_INTSTS_TMR1IF_Pos)            /*!< SC_T::INTSTS: TMR1IF Mask     */

#define SC_INTSTS_TMR2IF_Pos             (5)                                        /*!< SC_T::INTSTS: TMR2IF Position */
#define SC_INTSTS_TMR2IF_Msk             (0x1ul << SC_INTSTS_TMR2IF_Pos)            /*!< SC_T::INTSTS: TMR2IF Mask     */

#define SC_INTSTS_BGTIF_Pos              (6)                                        /*!< SC_T::INTSTS: BGTIF Position  */
#define SC_INTSTS_BGTIF_Msk              (0x1ul << SC_INTSTS_BGTIF_Pos)             /*!< SC_T::INTSTS: BGTIF Mask      */

#define SC_INTSTS_CDIF_Pos               (7)                                        /*!< SC_T::INTSTS: CDIF Position   */
#define SC_INTSTS_CDIF_Msk               (0x1ul << SC_INTSTS_CDIF_Pos)              /*!< SC_T::INTSTS: CDIF Mask       */

#define SC_INTSTS_INITIF_Pos             (8)                                        /*!< SC_T::INTSTS: INITIF Position */
#define SC_INTSTS_INITIF_Msk             (0x1ul << SC_INTSTS_INITIF_Pos)            /*!< SC_T::INTSTS: INITIF Mask     */

#define SC_INTSTS_RBTOIF_Pos             (9)                                        /*!< SC_T::INTSTS: RBTOIF Position */
#define SC_INTSTS_RBTOIF_Msk             (0x1ul << SC_INTSTS_RBTOIF_Pos)            /*!< SC_T::INTSTS: RBTOIF Mask     */

#define SC_INTSTS_ACERRIF_Pos            (10)                                       /*!< SC_T::INTSTS: ACERRIF Position    */
#define SC_INTSTS_ACERRIF_Msk            (0x1ul << SC_INTSTS_ACERRIF_Pos)           /*!< SC_T::INTSTS: ACERRIF Mask        */

#define SC_STATUS_RXOV_Pos               (0)                                        /*!< SC_T::STATUS: RXO Position    */
#define SC_STATUS_RXOV_Msk               (0x1ul << SC_STATUS_RXOV_Pos)              /*!< SC_T::STATUS: RXO Mask        */

#define SC_STATUS_RXEMPTY_Pos            (1)                                        /*!< SC_T::STATUS: RXEMPTY Position    */
#define SC_STATUS_RXEMPTY_Msk            (0x1ul << SC_STATUS_RXEMPTY_Pos)           /*!< SC_T::STATUS: RXEMPTY Mask        */

#define SC_STATUS_RXFULL_Pos             (2)                                        /*!< SC_T::STATUS: RXFULL Position */
#define SC_STATUS_RXFULL_Msk             (0x1ul << SC_STATUS_RXFULL_Pos)            /*!< SC_T::STATUS: RXFULL Mask     */

#define SC_STATUS_PEF_Pos                (4)                                        /*!< SC_T::STATUS: PEF Position    */
#define SC_STATUS_PEF_Msk                (0x1ul << SC_STATUS_PEF_Pos)               /*!< SC_T::STATUS: PEF Mask        */

#define SC_STATUS_FEF_Pos                (5)                                        /*!< SC_T::STATUS: FEF Position    */
#define SC_STATUS_FEF_Msk                (0x1ul << SC_STATUS_FEF_Pos)               /*!< SC_T::STATUS: FEF Mask        */

#define SC_STATUS_BEF_Pos                (6)                                        /*!< SC_T::STATUS: BEF Position    */
#define SC_STATUS_BEF_Msk                (0x1ul << SC_STATUS_BEF_Pos)               /*!< SC_T::STATUS: BEF Mask        */

#define SC_STATUS_TXOV_Pos               (8)                                        /*!< SC_T::STATUS: TXOV Position   */
#define SC_STATUS_TXOV_Msk               (0x1ul << SC_STATUS_TXOV_Pos)              /*!< SC_T::STATUS: TXOV Mask       */

#define SC_STATUS_TXEMPTY_Pos            (9)                                        /*!< SC_T::STATUS: TXEMPTY Position    */
#define SC_STATUS_TXEMPTY_Msk            (0x1ul << SC_STATUS_TXEMPTY_Pos)           /*!< SC_T::STATUS: TXEMPTY Mask        */

#define SC_STATUS_TXFULL_Pos             (10)                                       /*!< SC_T::STATUS: TXFULL Position */
#define SC_STATUS_TXFULL_Msk             (0x1ul << SC_STATUS_TXFULL_Pos)            /*!< SC_T::STATUS: TXFULL Mask     */

#define SC_STATUS_CREMOVE_Pos            (11)                                       /*!< SC_T::STATUS: CREMOVE Position    */
#define SC_STATUS_CREMOVE_Msk            (0x1ul << SC_STATUS_CREMOVE_Pos)           /*!< SC_T::STATUS: CREMOVE Mask        */

#define SC_STATUS_CINSERT_Pos            (12)                                       /*!< SC_T::STATUS: CINSERT Position    */
#define SC_STATUS_CINSERT_Msk            (0x1ul << SC_STATUS_CINSERT_Pos)           /*!< SC_T::STATUS: CINSERT Mask        */

#define SC_STATUS_CDPINSTS_Pos           (13)                                       /*!< SC_T::STATUS: CDPINSTS Position   */
#define SC_STATUS_CDPINSTS_Msk           (0x1ul << SC_STATUS_CDPINSTS_Pos)          /*!< SC_T::STATUS: CDPINSTS Mask       */

#define SC_STATUS_RXPOINT_Pos            (16)                                       /*!< SC_T::STATUS: RXPOINT Position    */
#define SC_STATUS_RXPOINT_Msk            (0x3ul << SC_STATUS_RXPOINT_Pos)           /*!< SC_T::STATUS: RXPOINT Mask        */

#define SC_STATUS_RXRERR_Pos             (21)                                       /*!< SC_T::STATUS: RXRERR Position     */
#define SC_STATUS_RXRERR_Msk             (0x1ul << SC_STATUS_RXRERR_Pos)            /*!< SC_T::STATUS: RXRERR Mask         */

#define SC_STATUS_RXOVERR_Pos            (22)                                       /*!< SC_T::STATUS: RXOVERR Position    */
#define SC_STATUS_RXOVERR_Msk            (0x1ul << SC_STATUS_RXOVERR_Pos)           /*!< SC_T::STATUS: RXOVERR Mask        */

#define SC_STATUS_RXACT_Pos              (23)                                       /*!< SC_T::STATUS: RXACT Position      */
#define SC_STATUS_RXACT_Msk              (0x1ul << SC_STATUS_RXACT_Pos)             /*!< SC_T::STATUS: RXACT Msk           */

#define SC_STATUS_TXPOINT_Pos            (24)                                       /*!< SC_T::STATUS: TXPOINT Position    */
#define SC_STATUS_TXPOINT_Msk            (0x3ul << SC_STATUS_TXPOINT_Pos)           /*!< SC_T::STATUS: TXPOINT Msk         */

#define SC_STATUS_TXRERR_Pos             (29)                                       /*!< SC_T::STATUS: TXRERR Position     */
#define SC_STATUS_TXRERR_Msk             (0x1ul << SC_STATUS_TXRERR_Pos)            /*!< SC_T::STATUS: TXRERR Msk          */

#define SC_STATUS_TXOVERR_Pos            (30)                                       /*!< SC_T::STATUS: TXOVERR_ Position   */
#define SC_STATUS_TXOVERR_Msk            (0x1ul << SC_STATUS_TXOVERR_Pos)           /*!< SC_T::STATUS: TXOVERR_ Msk        */

#define SC_STATUS_TXACT_Pos              (31)                                       /*!< SC_T::STATUS: TXACT Position      */
#define SC_STATUS_TXACT_Msk              (0x1ul << SC_STATUS_TXACT_Pos)             /*!< SC_T::STATUS: TXACT Msk           */

#define SC_PINCTL_PWREN_Pos              (0)                                        /*!< SC_T::PINCTL: PWREN Position  */
#define SC_PINCTL_PWREN_Msk              (0x1ul << SC_PINCTL_PWREN_Pos)             /*!< SC_T::PINCTL: PWREN Msk       */

#define SC_PINCTL_SCRST_Pos              (1)                                        /*!< SC_T::PINCTL: SCRST Position  */
#define SC_PINCTL_SCRST_Msk              (0x1ul << SC_PINCTL_SCRST_Pos)             /*!< SC_T::PINCTL: SCRST Msk       */

#define SC_PINCTL_CSTOPLV_Pos            (5)                                        /*!< SC_T::PINCTL: CSTOPLV Position    */
#define SC_PINCTL_CSTOPLV_Msk            (0x1ul << SC_PINCTL_CSTOPLV_Pos)           /*!< SC_T::PINCTL: CSTOPLV Msk         */

#define SC_PINCTL_CLKKEEP_Pos            (6)                                        /*!< SC_T::PINCTL: CLKKEEP Position    */
#define SC_PINCTL_CLKKEEP_Msk            (0x1ul << SC_PINCTL_CLKKEEP_Pos)           /*!< SC_T::PINCTL: CLKKEEP Msk         */

#define SC_PINCTL_SCDOUT_Pos             (9)                                        /*!< SC_T::PINCTL: SCDOUT Position */
#define SC_PINCTL_SCDOUT_Msk             (0x1ul << SC_PINCTL_SCDOUT_Pos)            /*!< SC_T::PINCTL: SCDOUT Msk      */

#define SC_PINCTL_PWRINV_Pos             (11)                                       /*!< SC_T::PINCTL: PWRINV Position */
#define SC_PINCTL_PWRINV_Msk             (0x1ul << SC_PINCTL_PWRINV_Pos)            /*!< SC_T::PINCTL: PWRINV Msk      */

#define SC_PINCTL_SCDOSTS_Pos            (12)                                       /*!< SC_T::PINCTL: SCDOSTS Position    */
#define SC_PINCTL_SCDOSTS_Msk            (0x1ul << SC_PINCTL_SCDOSTS_Pos)           /*!< SC_T::PINCTL: SCDOSTS Msk         */

#define SC_PINCTL_DATSTS_Pos             (16)                                       /*!< SC_T::PINCTL: DATSTS Position */
#define SC_PINCTL_DATSTS_Msk             (0x1ul << SC_PINCTL_DATSTS_Pos)            /*!< SC_T::PINCTL: DATSTS Msk      */

#define SC_PINCTL_PWRSTS_Pos             (17)                                       /*!< SC_T::PINCTL: PWRSTS Position */
#define SC_PINCTL_PWRSTS_Msk             (0x1ul << SC_PINCTL_PWRSTS_Pos)            /*!< SC_T::PINCTL: PWRSTS Msk      */

#define SC_PINCTL_RSTSTS_Pos             (18)                                       /*!< SC_T::PINCTL: RSTSTS Position */
#define SC_PINCTL_RSTSTS_Msk             (0x1ul << SC_PINCTL_RSTSTS_Pos)            /*!< SC_T::PINCTL: RSTSTS Msk      */

#define SC_PINCTL_SYNC_Pos               (30)                                       /*!< SC_T::PINCTL: SYNC Position   */
#define SC_PINCTL_SYNC_Msk               (0x1ul << SC_PINCTL_SYNC_Pos)              /*!< SC_T::PINCTL: SYNC Msk        */

#define SC_PINCTL_LOOPBK_Pos             (31)                                       /*!< SC_T::PINCTL: LOOPBK Position */
#define SC_PINCTL_LOOPBK_Msk             (0x1ul << SC_PINCTL_LOOPBK_Pos)            /*!< SC_T::PINCTL: LOOPBK Msk      */

#define SC_TMRCTL0_CNT_Pos               (0)                                        /*!< SC_T::TMRCTL0: CNT Position   */
#define SC_TMRCTL0_CNT_Msk               (0xfffffful << SC_TMRCTL0_CNT_Pos)         /*!< SC_T::TMRCTL0: CNT Msk        */

#define SC_TMRCTL0_OPMODE_Pos            (24)                                       /*!< SC_T::TMRCTL0: OPMODE Position    */
#define SC_TMRCTL0_OPMODE_Msk            (0xful << SC_TMRCTL0_OPMODE_Pos)           /*!< SC_T::TMRCTL0: OPMODE Msk         */

#define SC_TMRCTL1_CNT_Pos               (0)                                        /*!< SC_T::TMRCTL1: CNT Position   */
#define SC_TMRCTL1_CNT_Msk               (0xfful << SC_TMRCTL1_CNT_Pos)             /*!< SC_T::TMRCTL1: CNT Msk        */

#define SC_TMRCTL1_OPMODE_Pos            (24)                                       /*!< SC_T::TMRCTL1: OPMODE Position    */
#define SC_TMRCTL1_OPMODE_Msk            (0xful << SC_TMRCTL1_OPMODE_Pos)           /*!< SC_T::TMRCTL1: OPMODE Msk         */

#define SC_TMRCTL2_CNT_Pos               (0)                                        /*!< SC_T::TMRCTL2: CNT Position   */
#define SC_TMRCTL2_CNT_Msk               (0xfful << SC_TMRCTL2_CNT_Pos)             /*!< SC_T::TMRCTL2: CNT Msk        */

#define SC_TMRCTL2_OPMODE_Pos            (24)                                       /*!< SC_T::TMRCTL2: OPMODE Position    */
#define SC_TMRCTL2_OPMODE_Msk            (0xful << SC_TMRCTL2_OPMODE_Pos)           /*!< SC_T::TMRCTL2: OPMODE Msk         */

#define SC_UARTCTL_UARTEN_Pos            (0)                                        /*!< SC_T::UARTCTL: UARTEN Position    */
#define SC_UARTCTL_UARTEN_Msk            (0x1ul << SC_UARTCTL_UARTEN_Pos)           /*!< SC_T::UARTCTL: UARTEN Msk         */

#define SC_UARTCTL_WLS_Pos               (4)                                        /*!< SC_T::UARTCTL: WLS Position   */
#define SC_UARTCTL_WLS_Msk               (0x3ul << SC_UARTCTL_WLS10_Pos)            /*!< SC_T::UARTCTL: WLS Msk        */

#define SC_UARTCTL_PBOFF_Pos             (6)                                        /*!< SC_T::UARTCTL: PBOFF Position */
#define SC_UARTCTL_PBOFF_Msk             (0x1ul << SC_UARTCTL_PBOFF_Pos)            /*!< SC_T::UARTCTL: PBOFF Msk      */

#define SC_UARTCTL_OPE_Pos               (7)                                        /*!< SC_T::UARTCTL: OPE Position   */
#define SC_UARTCTL_OPE_Msk               (0x1ul << SC_UARTCTL_OPE_Pos)              /*!< SC_T::UARTCTL: OPE Msk        */

#define SC_TMRDAT0_CNT0_Pos              (0)                                        /*!< SC_T::TMRDAT0: CNT0 Position  */
#define SC_TMRDAT0_CNT0_Msk              (0xfffffful << SC_TMRDAT0_CNT0_Pos)        /*!< SC_T::TMRDAT0: CNT0 Msk       */

#define SC_TMRDAT1_2_CNT1_Pos            (0)                                        /*!< SC_T::TMRDAT1_2: CNT1 Position    */
#define SC_TMRDAT1_2_CNT1_Msk            (0xfful << SC_TMRDAT1_2_CNT1_Pos)          /*!< SC_T::TMRDAT1_2: CNT1 Msk         */

#define SC_TMRDAT1_2_CNT2_Pos            (8)                                        /*!< SC_T::TMRDAT1_2: CNT2 Position    */
#define SC_TMRDAT1_2_CNT2_Msk            (0xfful << SC_TMRDAT1_2_CNT2_Pos)          /*!< SC_T::TMRDAT1_2: CNT2 Msk         */

/**@}*/ /* SC_CONST */
/**@}*/ /* end of SC register group */


/*---------------------- Serial Peripheral Interface Controller -------------------------*/
/**
    @addtogroup SPI Serial Peripheral Interface Controller(SPI)
    Memory Mapped Structure for SPI Controller
@{ */


typedef struct
{


/**
 * @var SPI_T::CTL
 * Offset: 0x00  Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |SPIEN     |SPI Transfer Control Enable Bit
 * |        |          |In Master mode, the transfer will start when there is data in the FIFO buffer after this is set to 1.
 * |        |          |In Slave mode, this device is ready to receive data when this bit is set to 1.
 * |        |          |0 = Transfer control Disabled.
 * |        |          |1 = Transfer control Enabled.
 * |        |          |Note: Before changing the configurations of SPI_CTL, SPI_CLKDIV, SPI_SSCTL and SPI_FIFOCTL registers, user shall clear the SPIEN (SPI_CTL[0]) and confirm the SPIENSTS (SPI_STATUS[15]) is 0.
 * |[1]     |RXNEG     |Receive On Negative Edge
 * |        |          |0 = Received data input signal is latched on the rising edge of SPI bus clock.
 * |        |          |1 = Received data input signal is latched on the falling edge of SPI bus clock.
 * |[2]     |TXNEG     |Transmit On Negative Edge
 * |        |          |0 = Transmitted data output signal is changed on the rising edge of SPI bus clock.
 * |        |          |1 = Transmitted data output signal is changed on the falling edge of SP bus clock.
 * |[3]     |CLKPOL    |Clock Polarity
 * |        |          |0 = SPI bus clock is idle low.
 * |        |          |1 = SPI bus clock is idle high.
 * |[7:4]   |SUSPITV   |Suspend Interval (Master Only)
 * |        |          |The four bits provide configurable suspend interval between two successive transmit/receive transaction in a transfer.
 * |        |          |The definition of the suspend interval is the interval between the last clock edge of the preceding transaction word and the first clock edge of the following transaction word.
 * |        |          |The default value is 0x3.
 * |        |          |The period of the suspend interval is obtained according to the following equation.
 * |        |          |(SUSPITV[3:0] + 0.5) * period of SPICLK clock cycle
 * |        |          |Example:
 * |        |          |SUSPITV = 0x0 ... 0.5 SPICLK clock cycle.
 * |        |          |SUSPITV = 0x1 ... 1.5 SPICLK clock cycle.
 * |        |          |...
 * |        |          |SUSPITV = 0xE ... 14.5 SPICLK clock cycle.
 * |        |          |SUSPITV = 0xF ... 15.5 SPICLK clock cycle.
 * |[12:8]  |DWIDTH    |Data Width
 * |        |          |This field specifies how many bits can be transmitted / received in one transaction.
 * |        |          |The minimum bit length is 8 bits and can up to 32 bits.
 * |        |          |DWIDTH = 0x08 ... 8 bits.
 * |        |          |DWIDTH = 0x09 ... 9 bits.
 * |        |          |...
 * |        |          |DWIDTH = 0x1F ... 31 bits.
 * |        |          |DWIDTH = 0x00 ... 32 bits.
 * |[13]    |LSB       |Send LSB First
 * |        |          |0 = The MSB, which bit of transmit/receive register depends on the setting of DWIDTH, is transmitted/received first.
 * |        |          |1 = The LSB, bit 0 of the SPI TX register, is sent first to the SPI data output pin, and the first bit received from the SPI data input pin will be put in the LSB position of the RX register (bit 0 of SPI_RX).
 * |[16]    |TWOBIT    |2-Bit Transfer Mode Enable Bit (Only Supported in SPI0)
 * |        |          |0 = 2-Bit Transfer mode Disabled.
 * |        |          |1 = 2-Bit Transfer mode Enabled.
 * |        |          |Note: When 2-Bit Transfer mode is enabled, the first serial transmitted bit data is from the first FIFO buffer data, and the 2nd
 * |        |          |serial transmitted bit data is from the second FIFO buffer data.
 * |        |          |As the same as transmitted function, the first received bit data is stored into the first FIFO buffer and the 2nd received bit data is stored into the second FIFO buffer at the same time.
 * |[17]    |UNITIEN   |Unit Transfer Interrupt Enable Bit
 * |        |          |0 = SPI unit transfer interrupt Disabled.
 * |        |          |1 = SPI unit transfer interrupt Enabled.
 * |[18]    |SLAVE     |Slave Mode Control
 * |        |          |0 = Master mode.
 * |        |          |1 = Slave mode.
 * |[19]    |REORDER   |Byte Reorder Function Enable Bit
 * |        |          |0 = Byte Reorder function Disabled.
 * |        |          |1 = Byte Reorder function Enabled. A byte suspend interval will be inserted among each byte.
 * |        |          |The period of the byte suspend interval depends on the setting of SUSPITV.
 * |        |          |Note:
 * |        |          |1. Byte Reorder function is only available if DWIDTH is defined as 16, 24, and 32 bits.
 * |        |          |2. Byte Reorder function is not supported when the Quad or Dual I/O mode is enabled.
 * |[20]    |QDIODIR   |Quad Or Dual I/O Mode Direction Control (Only Supported in SPI0)
 * |        |          |0 = Quad or Dual Input mode.
 * |        |          |1 = Quad or Dual Output mode.
 * |[21]    |DUALIOEN  |Dual I/O Mode Enable Bit (Only Supported in SPI0)
 * |        |          |0 = Dual I/O mode Disabled.
 * |        |          |1 = Dual I/O mode Enabled.
 * |[22]    |QUADIOEN  |Quad I/O Mode Enable Bit (Only Supported in SPI0)
 * |        |          |0 = Quad I/O mode Disabled.
 * |        |          |1 = Quad I/O mode Enabled.
 * @var SPI_T::CLKDIV
 * Offset: 0x04  Clock Divider Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[7:0]   |DIVIDER   |Clock Divider
 * |        |          |The value in this field is the frequency divider for generating the peripheral clock, fspi_eclk, and the SPI bus clock of SPI master.
 * |        |          |The frequency is obtained according to the following equation.
 * |        |          | fspi_eclk = fspi_clock_src / (DIVIDER + 1)
 * |        |          |where fspi_clock_src is the peripheral clock source, which is defined in the clock control register CLK_CLKSEL2.
 * @var SPI_T::SSCTL
 * Offset: 0x08  Slave Select Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |SS        |Slave Selection Control (Master Only)
 * |        |          |If AUTOSS bit is cleared to 0,
 * |        |          |0 = set the SPIn_SS line to inactive state.
 * |        |          |1 = set the SPIn_SS line to active state
 * |        |          |If the AUTOSS bit is set to 1,
 * |        |          |0 = Keep the SPIn_SS line at inactive state.
 * |        |          |1 = SPIn_SS line will be automatically driven to active state for the duration of data transfer, and will be driven to inactive state for the rest of the time.
 * |        |          |The active state of SPIn_SS is specified in SSACTPOL (SPI_SSCTL[2]).
 * |[2]     |SSACTPOL  |Slave Selection Active Polarity
 * |        |          |This bit defines the active polarity of slave selection signal (SPIn_SS).
 * |        |          |0 = The slave selection signal SPIn_SS is active low.
 * |        |          |1 = The slave selection signal SPIn_SS is active high.
 * |[3]     |AUTOSS    |Automatic Slave Selection Function Enable Bit (Master Only)
 * |        |          |0 = Automatic slave selection function Disabled.
 * |        |          |Slave selection signal will be asserted/de-asserted according to SS (SPI_SSCTL[0]).
 * |        |          |1 = Automatic slave selection function Enabled.
 * |[4]     |SLV3WIRE  |Slave 3-Wire Mode Enable Bit
 * |        |          |Slave 3-wire mode is only available in SPI0.
 * |        |          |In Slave 3-wire mode, the SPI controller can work with 3-wire interface including SPI0_CLK, SPI0_MISO, and SPI0_MOSI.
 * |        |          |0 = 4-wire bi-direction interface.
 * |        |          |1 = 3-wire bi-direction interface.
 * |[5]     |SLVTOIEN  |Slave Mode Time-Out Interrupt Enable Bit (Only Supported in SPI0)
 * |        |          |0 = Slave mode time-out interrupt Disabled.
 * |        |          |1 = Slave mode time-out interrupt Enabled.
 * |[6]     |SLVTORST  |Slave Mode Time-Out Reset Control (Only Supported in SPI0)
 * |        |          |0 = When Slave mode time-out event occurs, the TX and RX control circuit will not be reset.
 * |        |          |1 = When Slave mode time-out event occurs, the TX and RX control circuit will be reset by hardware.
 * |[8]     |SLVBEIEN  |Slave Mode Bit Count Error Interrupt Enable Bit
 * |        |          |0 = Slave mode bit count error interrupt Disabled.
 * |        |          |1 = Slave mode bit count error interrupt Enabled.
 * |[9]     |SLVURIEN  |Slave Mode TX Under Run Interrupt Enable Bit
 * |        |          |0 = Slave mode TX under run interrupt Disabled.
 * |        |          |1 = Slave mode TX under run interrupt Enabled.
 * |[12]    |SSACTIEN  |Slave Select Active Interrupt Enable Bit
 * |        |          |0 = Slave select active interrupt Disabled.
 * |        |          |1 = Slave select active interrupt Enabled.
 * |[13]    |SSINAIEN  |Slave Select Inactive Interrupt Enable Bit
 * |        |          |0 = Slave select inactive interrupt Disabled.
 * |        |          |1 = Slave select inactive interrupt Enabled.
 * |[31:16] |SLVTOCNT  |Slave Mode Time-Out Period (Only Supported in SPI0)
 * |        |          |In Slave mode, these bits indicate the time-out period when there is bus clock input during slave select active.
 * |        |          |The clock source of the time-out counter is Slave peripheral clock.
 * |        |          |If the value is 0, it indicates the slave mode time-out function is disabled.
 * @var SPI_T::PDMACTL
 * Offset: 0x0C  SPI PDMA Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |TXPDMAEN  |Transmit PDMA Enable Bit
 * |        |          |0 = Transmit PDMA function Disabled.
 * |        |          |1 = Transmit PDMA function Enabled.
 * |        |          |Note: In SPI master mode with full duplex transfer, if both TX and RX PDMA functions are enabled, RX PDMA function cannot be enabled prior to TX PDMA function.
 * |        |          |User can enable TX PDMA function firstly or enable both functions simultaneously.
 * |[1]     |RXPDMAEN  |Receive PDMA Enable Bit
 * |        |          |0 = Receiver PDMA function Disabled.
 * |        |          |1 = Receiver PDMA function Enabled.
 * |[2]     |PDMARST   |PDMA Reset
 * |        |          |0 = No effect.
 * |        |          |1 = Reset the PDMA control logic of the SPI controller. This bit will be automatically cleared to 0.
 * @var SPI_T::FIFOCTL
 * Offset: 0x10  SPI FIFO Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |RXRST     |Receive Reset
 * |        |          |0 = No effect.
 * |        |          |1 = Reset receive FIFO pointer and receive circuit. The RXFULL bit will be cleared to 0 and the RXEMPTY bit will be set to 1.
 * |        |          |This bit will be cleared to 0 by hardware about 3 system clock cycles + 3 peripheral clock cycles after it is set to 1.
 * |        |          |User can read TXRXRST (SPI_STATUS[23]) to check if reset is accomplished or not.
 * |        |          |Note: If there is slave receive time-out event, the RXRST will be set 1 when the SLVTORST (SPI_SSCTL[6]) is enabled.
 * |[1]     |TXRST     |Transmit Reset
 * |        |          |0 = No effect.
 * |        |          |1 = Reset transmit FIFO pointer and transmit circuit. The TXFULL bit will be cleared to 0 and the TXEMPTY bit will be set to 1.
 * |        |          |This bit will be cleared to 0 by hardware about 3 system clock cycles + 3 peripheral clock cycles after it is set to 1.
 * |        |          |User can read TXRXRST (SPI_STATUS[23]) to check if reset is accomplished or not.
 * |        |          |Note: If there is slave receive time-out event, the TXRST will be set to 1 when the SLVTORST (SPI_SSCTL[6]) is enabled.
 * |[2]     |RXTHIEN   |Receive FIFO Threshold Interrupt Enable Bit
 * |        |          |0 = RX FIFO threshold interrupt Disabled.
 * |        |          |1 = RX FIFO threshold interrupt Enabled.
 * |[3]     |TXTHIEN   |Transmit FIFO Threshold Interrupt Enable Bit
 * |        |          |0 = TX FIFO threshold interrupt Disabled.
 * |        |          |1 = TX FIFO threshold interrupt Enabled.
 * |[4]     |RXTOIEN   |Slave Receive Time-Out Interrupt Enable Bit
 * |        |          |0 = Receive time-out interrupt Disabled.
 * |        |          |1 = Receive time-out interrupt Enabled.
 * |[5]     |RXOVIEN   |Receive FIFO Overrun Interrupt Enable Bit
 * |        |          |0 = Receive FIFO overrun interrupt Disabled.
 * |        |          |1 = Receive FIFO overrun interrupt Enabled.
 * |[6]     |TXUFPOL   |TX Underflow Data Polarity
 * |        |          |0 = The SPI data out is keep 0 if there is TX underflow event in Slave mode.
 * |        |          |1 = The SPI data out is keep 1 if there is TX underflow event in Slave mode.
 * |        |          |Note: The TX underflow event occurs if there is not any data in TX FIFO when the slave selection signal is active.
 * |[7]     |TXUFIEN   |TX Underflow Interrupt Enable Bit
 * |        |          |In Slave mode, when TX underflow event occurs, this interrupt flag will be set to 1.
 * |        |          |0 = Slave TX underflow interrupt Disabled.
 * |        |          |1 = Slave TX underflow interrupt Enabled.
 * |[8]     |RXFBCLR   |Receive FIFO Buffer Clear
 * |        |          |0 = No effect.
 * |        |          |1 = Clear receive FIFO pointer. The RXFULL bit will be cleared to 0 and the RXEMPTY bit will be set to 1.
 * |        |          |This bit will be cleared to 0 by hardware about 1 system clock after it is set to 1.
 * |        |          |Note: The RX shift register will not be cleared.
 * |[9]     |TXFBCLR   |Transmit FIFO Buffer Clear
 * |        |          |0 = No effect.
 * |        |          |1 = Clear transmit FIFO pointer. The TXFULL bit will be cleared to 0 and the TXEMPTY bit will be set to 1.
 * |        |          |This bit will be cleared to 0 by hardware about 1 system clock after it is set to 1.
 * |        |          |Note: The TX shift register will not be cleared.
 * |[26:24] |RXTH      |Receive FIFO Threshold
 * |        |          |If the valid data count of the receive FIFO buffer is larger than the RXTH setting, the RXTHIF bit will be set to 1, else the RXTHIF bit will be cleared to 0.
 * |        |          |In SPI0, RXTH is a 3-bit wide configuration; in SPI1 and SPI2, 2-bit wide only (SPI_FIFOCTL[25:24]).
 * |[30:28] |TXTH      |Transmit FIFO Threshold
 * |        |          |If the valid data count of the transmit FIFO buffer is less than or equal to the TXTH setting, the TXTHIF bit will be set to 1, else the TXTHIF bit will be cleared to 0.
 * |        |          |In SPI0, TXTH is a 3-bit wide configuration; in SPI1 and SPI2, 2-bit wide only (SPI_FIFOCTL[29:28]).
 * @var SPI_T::STATUS
 * Offset: 0x14  SPI Status Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |BUSY      |Busy Status (Read Only)
 * |        |          |0 = SPI controller is in idle state.
 * |        |          |1 = SPI controller is in busy state.
 * |        |          |The following listing are the bus busy conditions:
 * |        |          |a. SPI_CTL[0] = 1 and the TXEMPTY = 0.
 * |        |          |b. For SPI Master mode, the TXEMPTY = 1 but the current transaction is not finished yet.
 * |        |          |c. For SPI Slave mode, the SPI_CTL[0] = 1 and there is serial clock input into the SPI core logic when slave select is active.
 * |        |          |d. For SPI Slave mode, the SPI_CTL[0] = 1 and the transmit buffer or transmit shift register is not empty even if the slave select is inactive.
 * |[1]     |UNITIF    |Unit Transfer Interrupt Flag
 * |        |          |0 = No transaction has been finished since this bit was cleared to 0.
 * |        |          |1 = SPI controller has finished one unit transfer.
 * |        |          |Note: This bit will be cleared by writing 1 to it.
 * |[2]     |SSACTIF   |Slave Select Active Interrupt Flag
 * |        |          |0 = Slave select active interrupt was cleared or not occurred.
 * |        |          |1 = Slave select active interrupt event occurred.
 * |        |          |Note: Only available in Slave mode. This bit will be cleared by writing 1 to it.
 * |[3]     |SSINAIF   |Slave Select Inactive Interrupt Flag
 * |        |          |0 = Slave select inactive interrupt was cleared or not occurred.
 * |        |          |1 = Slave select inactive interrupt event occurred.
 * |        |          |Note: Only available in Slave mode. This bit will be cleared by writing 1 to it.
 * |[4]     |SSLINE    |Slave Select Line Bus Status (Read Only)
 * |        |          |0 = The slave select line status is 0.
 * |        |          |1 = The slave select line status is 1.
 * |        |          |Note: This bit is only available in Slave mode.
 * |        |          |If SSACTPOL (SPI_SSCTL[2]) is set 0, and the SSLINE is 1, the SPI slave select is in inactive status.
 * |[5]     |SLVTOIF   |Slave Time-Out Interrupt Flag (Only Supported in SPI0)
 * |        |          |When the Slave Select is active and the value of SLVTOCNT is not 0, as the bus clock is detected, the slave time-out counter in SPI controller logic will be started.
 * |        |          |When the value of time-out counter is greater than or equal to the value of SLVTOCNT (SPI_SSCTL[31:16]) before one transaction is done, the slave time-out interrupt event will be asserted.
 * |        |          |0 = Slave time-out is not active.
 * |        |          |1 = Slave time-out is active.
 * |        |          |Note: This bit will be cleared by writing 1 to it.
 * |[6]     |SLVBEIF   |Slave Mode Bit Count Error Interrupt Flag
 * |        |          |In Slave mode, when the slave select line goes to inactive state, if bit counter is mismatch with DWIDTH, this interrupt flag will be set to 1.
 * |        |          |0 = No Slave mode bit count error event.
 * |        |          |1 = Slave mode bit count error event occurs.
 * |        |          |Note: If the slave select active but there is no any bus clock input, the SLVBCEIF also active when the slave select goes to inactive state.
 * |        |          |This bit will be cleared by writing 1 to it.
 * |[7]     |SLVURIF   |Slave Mode TX Under Run Interrupt Flag
 * |        |          |In Slave mode, if TX underflow event occurs and the slave select line goes to inactive state, this interrupt flag will be set to 1.
 * |        |          |0 = No Slave TX under run event.
 * |        |          |1 = Slave TX under run occurs.
 * |        |          |Note: This bit will be cleared by writing 1 to it.
 * |[8]     |RXEMPTY   |Receive FIFO Buffer Empty Indicator (Read Only)
 * |        |          |0 = Receive FIFO buffer is not empty.
 * |        |          |1 = Receive FIFO buffer is empty.
 * |[9]     |RXFULL    |Receive FIFO Buffer Full Indicator (Read Only)
 * |        |          |0 = Receive FIFO buffer is not full.
 * |        |          |1 = Receive FIFO buffer is full.
 * |[10]    |RXTHIF    |Receive FIFO Threshold Interrupt Flag (Read Only)
 * |        |          |0 = The valid data count within the RX FIFO buffer is smaller than or equal to the setting value of RXTH.
 * |        |          |1 = The valid data count within the receive FIFO buffer is larger than the setting value of RXTH.
 * |[11]    |RXOVIF    |Receive FIFO Overrun Interrupt Flag
 * |        |          |When the receive FIFO buffer is full, the follow-up data will be dropped and this bit will be set to 1.
 * |        |          |0 = No FIFO is over run.
 * |        |          |1 = Receive FIFO over run.
 * |        |          |Note: This bit will be cleared by writing 1 to it.
 * |[12]    |RXTOIF    |Receive Time-Out Interrupt Flag
 * |        |          |0 = No receive FIFO time-out event.
 * |        |          |1 = Receive FIFO buffer is not empty and no read operation on receive FIFO buffer over 64 SPI clock period in Master mode or over 576 peripheral clock period in Slave mode.
 * |        |          |When the received FIFO buffer is read by software, the time-out status will be cleared automatically.
 * |        |          |Note: This bit will be cleared by writing 1 to it.
 * |[15]    |SPIENSTS  |SPI Enable Status (Read Only)
 * |        |          |0 = The SPI controller is disabled.
 * |        |          |1 = The SPI controller is enabled.
 * |        |          |Note: The SPI peripheral clock is asynchronous with the system clock.
 * |        |          |In order to make sure the SPI control logic is disabled, this bit indicates the real status of SPI controller.
 * |[16]    |TXEMPTY   |Transmit FIFO Buffer Empty Indicator (Read Only)
 * |        |          |0 = Transmit FIFO buffer is not empty.
 * |        |          |1 = Transmit FIFO buffer is empty.
 * |[17]    |TXFULL    |Transmit FIFO Buffer Full Indicator (Read Only)
 * |        |          |0 = Transmit FIFO buffer is not full.
 * |        |          |1 = Transmit FIFO buffer is full.
 * |[18]    |TXTHIF    |Transmit FIFO Threshold Interrupt Flag (Read Only)
 * |        |          |0 = The valid data count within the transmit FIFO buffer is larger than the setting value of TXTH.
 * |        |          |1 = The valid data count within the transmit FIFO buffer is less than or equal to the setting value of TXTH.
 * |[19]    |TXUFIF    |TX Underflow Interrupt Flag
 * |        |          |When the TX underflow event occurs, this bit will be set to 1, the state of data output pin depends on the setting of TXUFPOL.
 * |        |          |0 = No effect.
 * |        |          |1 = No data in Transmit FIFO and TX shift register when the slave selection signal is active.
 * |        |          |Note 1: This bit will be cleared by writing 1 to it.
 * |        |          |Note 2: If reset slave's transmission circuit when slave selection signal is active, this flag will be set to 1 after 2 peripheral clock cycles + 3 system clock cycles since the reset operation is done.
 * |[23]    |TXRXRST   |TX or RX Reset Status (Read Only)
 * |        |          |0 = The reset function of TXRST or RXRST is done.
 * |        |          |1 = Doing the reset function of TXRST or RXRST.
 * |        |          |Note: Both the reset operations of TXRST and RXRST need 3 system clock cycles + 2 peripheral clock cycles.
 * |        |          |User can check the status of this bit to monitor the reset function is doing or done.
 * |[27:24] |RXCNT     |Receive FIFO Data Count (Read Only)
 * |        |          |This bit field indicates the valid data count of receive FIFO buffer.
 * |[31:28] |TXCNT     |Transmit FIFO Data Count (Read Only)
 * |        |          |This bit field indicates the valid data count of transmit FIFO buffer.
 * @var SPI_T::TX
 * Offset: 0x20  Data Transmit Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[31:0]  |TX        |Data Transmit Register
 * |        |          |The data transmit registers pass through the transmitted data into the 8-/4-level transmit FIFO buffer.
 * |        |          |The number of valid bits depends on the setting of DWIDTH (SPI_CTL[12:8]).
 * |        |          |For example, if DWIDTH is set to 0x08, the bits TX[7:0] will be transmitted.
 * |        |          |If DWIDTH is set to 0x00, the SPI controller will perform a 32-bit transfer.
 * |        |          |Note: In Master mode, SPI controller will start to transfer after 5 peripheral clock cycles after user writes to this register.
 * @var SPI_T::RX
 * Offset: 0x30  Data Receive Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[31:0]  |RX        |Data Receive Register
 * |        |          |There are 8-/4-level FIFO buffers in this controller.
 * |        |          |The data receive register holds the data received from SPI data input pin.
 * |        |          |If the RXEMPTY (SPI_STATUS[8]) is not set to 1, the receive FIFO buffers can be accessed through software by reading this register.
 * |        |          |This is a read only register.
 * @var SPI_T::I2SCTL
 * Offset: 0x60  I2S Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |I2SEN     |I2S Controller Enable Bit
 * |        |          |0 = Disabled.
 * |        |          |1 = Enabled.
 * |        |          |Note: If enable this bit, I2Sn_BCLK will start to output in master mode.
 * |[1]     |TXEN      |Transmit Enable Bit
 * |        |          |0 = Data transmit Disabled.
 * |        |          |1 = Data transmit Enabled.
 * |[2]     |RXEN      |Receive Enable Bit
 * |        |          |0 = Data receiving Disabled.
 * |        |          |1 = Data receiving Enabled.
 * |[3]     |MUTE      |Transmit Mute Enable Bit
 * |        |          |0 = Transmit data is shifted from buffer.
 * |        |          |1= Transmit channel zero.
 * |[5:4]   |WDWIDTH   |Word Width
 * |        |          |00 = data is 8-bit.
 * |        |          |01 = data is 16-bit.
 * |        |          |10 = data is 24-bit.
 * |        |          |11 = data is 32-bit.
 * |[6]     |MONO      |Monaural Data
 * |        |          |0 = Data is stereo format.
 * |        |          |1 = Data is monaural format.
 * |[7]     |ORDER     |Stereo Data Order In FIFO
 * |        |          |0 = Left channel data at high byte.
 * |        |          |1 = Left channel data at low byte.
 * |[8]     |SLAVE     |Slave Mode
 * |        |          |I2S can operate as master or slave.
 * |        |          |For Master mode, I2Sn_BCLK and I2Sn_LRCLK pins are output mode and send bit clock from NuMicro M451 series to Audio CODEC chip.
 * |        |          |In Slave mode, I2Sn_BCLK and I2Sn_LRCLK pins are input mode and I2Sn_BCLK and I2Sn_LRCLK signals are received from outer Audio CODEC chip.
 * |        |          |0 = Master mode.
 * |        |          |1 = Slave mode.
 * |[15]    |MCLKEN    |Master Clock Enable Bit
 * |        |          |If MCLKEN is set to 1, I2S controller will generate master clock on I2Sn_MCLK pin for external audio devices.
 * |        |          |0 = Master clock Disabled.
 * |        |          |1 = Master clock Enabled.
 * |[16]    |RZCEN     |Right Channel Zero Cross Detection Enable Bit
 * |        |          |If this bit is set to 1, when right channel data sign bit change or next shift data bits are all 0 then RZCIF flag in SPI_I2SSTS register is set to 1.
 * |        |          |This function is only available in transmit operation.
 * |        |          |0 = Right channel zero cross detection Disabled.
 * |        |          |1 = Right channel zero cross detection Enabled.
 * |[17]    |LZCEN     |Left Channel Zero Cross Detection Enable Bit
 * |        |          |If this bit is set to 1, when left channel data sign bit changes or next shift data bits are all 0 then LZCIF flag in SPI_I2SSTS register is set to 1.
 * |        |          |This function is only available in transmit operation.
 * |        |          |0 = Left channel zero cross detection Disabled.
 * |        |          |1 = Left channel zero cross detection Enabled.
 * |[23]    |RXLCH     |Receive Left Channel Enable Bit
 * |        |          |When monaural format is selected (MONO = 1), I2S controller will receive right channel data if RXLCH is set to 0, and receive left channel data if RXLCH is set to 1.
 * |        |          |0 = Receive right channel data in Mono mode.
 * |        |          |1 = Receive left channel data in Mono mode.
 * |[24]    |RZCIEN    |Right Channel Zero-Cross Interrupt Enable Bit
 * |        |          |Interrupt occurs if this bit is set to 1 and right channel zero-cross event occurs.
 * |        |          |0 = Interrupt Disabled.
 * |        |          |1 = Interrupt Enabled.
 * |[25]    |LZCIEN    |Left Channel Zero-Cross Interrupt Enable Bit
 * |        |          |Interrupt occurs if this bit is set to 1 and left channel zero-cross event occurs.
 * |        |          |0 = Interrupt Disabled.
 * |        |          |1 = Interrupt Enabled.
 * |[29:28] |FORMAT    |Data Format Selection
 * |        |          |00 = I2S data format.
 * |        |          |01 = MSB justified data format.
 * |        |          |10 = PCM mode A.
 * |        |          |11 = PCM mode B.
 * @var SPI_T::I2SCLK
 * Offset: 0x64  I2S Clock Divider Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[5:0]   |MCLKDIV   |Master Clock Divider
 * |        |          |If MCLKEN is set to 1, I2S controller will generate master clock for external audio devices.
 * |        |          |The master clock rate, F_MCLK, is determined by the following expressions.
 * |        |          |If MCLKDIV >= 1, F_MCLK = F_I2SCLK/(2x(MCLKDIV)).
 * |        |          |If MCLKDIV = 0, F_MCLK = F_I2SCLK.
 * |        |          |F_I2SCLK is the frequency of I2S peripheral clock.
 * |        |          |In general, the master clock rate is 256 times sampling clock rate.
 * |[16:8]  |BCLKDIV   |Bit Clock Divider
 * |        |          |The I2S controller will generate bit clock in Master mode.
 * |        |          |The bit clock rate, F_BCLK, is determined by the following expression.
 * |        |          |F_BCLK = F_I2SCLK /(2x(BCLKDIV + 1)) , where F_I2SCLK is the frequency of I2S peripheral clock.
 * @var SPI_T::I2SSTS
 * Offset: 0x68  I2S Status Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[4]     |RIGHT     |Right Channel (Read Only)
 * |        |          |This bit indicates the current transmit data is belong to which channel.
 * |        |          |0 = Left channel.
 * |        |          |1 = Right channel.
 * |[8]     |RXEMPTY   |Receive FIFO Buffer Empty Indicator (Read Only)
 * |        |          |0 = Receive FIFO buffer is not empty.
 * |        |          |1 = Receive FIFO buffer is empty.
 * |[9]     |RXFULL    |Receive FIFO Buffer Full Indicator (Read Only)
 * |        |          |0 = Receive FIFO buffer is not full.
 * |        |          |1 = Receive FIFO buffer is full.
 * |[10]    |RXTHIF    |Receive FIFO Threshold Interrupt Flag (Read Only)
 * |        |          |0 = The valid data count within the Rx FIFO buffer is smaller than or equal to the setting value of RXTH.
 * |        |          |1 = The valid data count within the receive FIFO buffer is larger than the setting value of RXTH.
 * |        |          |Note: If RXTHIEN = 1 and RXTHIF = 1, the SPI/I2S controller will generate a SPI interrupt request.
 * |[11]    |RXOVIF    |Receive FIFO Overrun Interrupt Flag
 * |        |          |When the receive FIFO buffer is full, the follow-up data will be dropped and this bit will be set to 1.
 * |        |          |Note: This bit will be cleared by writing 1 to it.
 * |[12]    |RXTOIF    |Receive Time-Out Interrupt Flag
 * |        |          |0 = No receive FIFO time-out event.
 * |        |          |1 = Receive FIFO buffer is not empty and no read operation on receive FIFO buffer over 64 SPI clock period in Master mode or over 576 peripheral clock period in Slave mode.
 * |        |          |When the received FIFO buffer is read by software, the time-out status will be cleared automatically.
 * |        |          |Note: This bit will be cleared by writing 1 to it.
 * |[15]    |I2SENSTS  |I2S Enable Status (Read Only)
 * |        |          |0 = The SPI/I2S control logic is disabled.
 * |        |          |1 = The SPI/I2S control logic is enabled.
 * |        |          |Note: The SPI peripheral clock is asynchronous with the system clock.
 * |        |          |In order to make sure the SPI/I2S controller logic is disabled, this bit indicates the real status of SPI/I2S controller logic for user.
 * |[16]    |TXEMPTY   |Transmit FIFO Buffer Empty Indicator (Read Only)
 * |        |          |0 = Transmit FIFO buffer is not empty.
 * |        |          |1 = Transmit FIFO buffer is empty.
 * |[17]    |TXFULL    |Transmit FIFO Buffer Full Indicator (Read Only)
 * |        |          |0 = Transmit FIFO buffer is not full.
 * |        |          |1 = Transmit FIFO buffer is full.
 * |[18]    |TXTHIF    |Transmit FIFO Threshold Interrupt Flag (Read Only)
 * |        |          |0 = The valid data count within the transmit FIFO buffer is larger than the setting value of TXTH.
 * |        |          |1 = The valid data count within the transmit FIFO buffer is less than or equal to the setting value of TXTH.
 * |        |          |Note: If TXTHIEN = 1 and TXTHIF = 1, the SPI controller will generate a SPI interrupt request.
 * |[19]    |TXUFIF    |Transmit FIFO Underflow Interrupt Flag
 * |        |          |When the transmit FIFO buffer is empty and there is no datum written into the FIFO buffer, if there is more bus clock input,
 * |        |          | the output data depends on the setting of TXUFPOL and this bit will be set to 1.
 * |        |          |Note: This bit will be cleared by writing 1 to it.
 * |[20]    |RZCIF     |Right Channel Zero Cross Interrupt Flag
 * |        |          |0 = No zero cross event occurred on right channel.
 * |        |          |1 = Zero cross event occurred on right channel.
 * |[21]    |LZCIF     |Left Channel Zero Cross Interrupt Flag
 * |        |          |0 = No zero cross event occurred on left channel.
 * |        |          |1 = Zero cross event occurred on left channel.
 * |[23]    |TXRXRST   |TX or RX Reset Status (Read Only)
 * |        |          |0 = The reset function of TXRST or RXRST is done.
 * |        |          |1 = Doing the reset function of TXRST or RXRST.
 * |        |          |Note: Both the reset operations of TXRST and RXRST need 3 system clock cycles + 3 peripheral clock cycles.
 * |        |          |User can check the status of this bit to monitor the reset function is doing or done.
 * |[26:24] |RXCNT     |Receive FIFO Data Count (Read Only)
 * |        |          |This bit field indicates the valid data count of receive FIFO buffer.
 * |[30:28] |TXCNT     |Transmit FIFO Data Count (Read Only)
 * |        |          |This bit field indicates the valid data count of transmit FIFO buffer.
 */

    __IO uint32_t CTL;           /* Offset: 0x00  Control Register                                                   */
    __IO uint32_t CLKDIV;        /* Offset: 0x04  Clock Divider Register                                             */
    __IO uint32_t SSCTL;         /* Offset: 0x08  Slave Select Control Register                                      */
    __IO uint32_t PDMACTL;       /* Offset: 0x0C  SPI PDMA Control Register                                          */
    __IO uint32_t FIFOCTL;       /* Offset: 0x10  SPI FIFO Control Register                                          */
    __IO uint32_t STATUS;        /* Offset: 0x14  SPI Status Register                                                */
    __I  uint32_t RESERVE0[2];  
    __O  uint32_t TX;            /* Offset: 0x20  Data Transmit Register                                             */
    __I  uint32_t RESERVE1[3];  
    __I  uint32_t RX;            /* Offset: 0x30  Data Receive Register                                              */
    __I  uint32_t RESERVE2[11]; 
    __IO uint32_t I2SCTL;        /* Offset: 0x60  I2S Control Register                                               */
    __IO uint32_t I2SCLK;        /* Offset: 0x64  I2S Clock Divider Control Register                                 */
    __IO uint32_t I2SSTS;        /* Offset: 0x68  I2S Status Register                                                */

} SPI_T;



/**
    @addtogroup SPI_CONST SPI Bit Field Definition
    Constant Definitions for SPI Controller
@{ */

#define SPI_CTL_SPIEN_Pos                (0)                                               /*!< SPI_T::CTL: SPIEN Position                */
#define SPI_CTL_SPIEN_Msk                (0x1ul << SPI_CTL_SPIEN_Pos)                      /*!< SPI_T::CTL: SPIEN Mask                    */

#define SPI_CTL_RXNEG_Pos                (1)                                               /*!< SPI_T::CTL: RXNEG Position                */
#define SPI_CTL_RXNEG_Msk                (0x1ul << SPI_CTL_RXNEG_Pos)                      /*!< SPI_T::CTL: RXNEG Mask                    */

#define SPI_CTL_TXNEG_Pos                (2)                                               /*!< SPI_T::CTL: TXNEG Position                */
#define SPI_CTL_TXNEG_Msk                (0x1ul << SPI_CTL_TXNEG_Pos)                      /*!< SPI_T::CTL: TXNEG Mask                    */

#define SPI_CTL_CLKPOL_Pos               (3)                                               /*!< SPI_T::CTL: CLKPOL Position               */
#define SPI_CTL_CLKPOL_Msk               (0x1ul << SPI_CTL_CLKPOL_Pos)                     /*!< SPI_T::CTL: CLKPOL Mask                   */

#define SPI_CTL_SUSPITV_Pos              (4)                                               /*!< SPI_T::CTL: SUSPITV Position              */
#define SPI_CTL_SUSPITV_Msk              (0xful << SPI_CTL_SUSPITV_Pos)                    /*!< SPI_T::CTL: SUSPITV Mask                  */

#define SPI_CTL_DWIDTH_Pos               (8)                                               /*!< SPI_T::CTL: DWIDTH Position               */
#define SPI_CTL_DWIDTH_Msk               (0x1ful << SPI_CTL_DWIDTH_Pos)                    /*!< SPI_T::CTL: DWIDTH Mask                   */

#define SPI_CTL_LSB_Pos                  (13)                                              /*!< SPI_T::CTL: LSB Position                  */
#define SPI_CTL_LSB_Msk                  (0x1ul << SPI_CTL_LSB_Pos)                        /*!< SPI_T::CTL: LSB Mask                      */

#define SPI_CTL_TWOBIT_Pos               (16)                                              /*!< SPI_T::CTL: TWOBIT Position               */
#define SPI_CTL_TWOBIT_Msk               (0x1ul << SPI_CTL_TWOBIT_Pos)                     /*!< SPI_T::CTL: TWOBIT Mask                   */

#define SPI_CTL_UNITIEN_Pos              (17)                                              /*!< SPI_T::CTL: UNITIEN Position              */
#define SPI_CTL_UNITIEN_Msk              (0x1ul << SPI_CTL_UNITIEN_Pos)                    /*!< SPI_T::CTL: UNITIEN Mask                  */

#define SPI_CTL_SLAVE_Pos                (18)                                              /*!< SPI_T::CTL: SLAVE Position                */
#define SPI_CTL_SLAVE_Msk                (0x1ul << SPI_CTL_SLAVE_Pos)                      /*!< SPI_T::CTL: SLAVE Mask                    */

#define SPI_CTL_REORDER_Pos              (19)                                              /*!< SPI_T::CTL: REORDER Position              */
#define SPI_CTL_REORDER_Msk              (0x1ul << SPI_CTL_REORDER_Pos)                    /*!< SPI_T::CTL: REORDER Mask                  */

#define SPI_CTL_QDIODIR_Pos              (20)                                              /*!< SPI_T::CTL: QDIODIR Position              */
#define SPI_CTL_QDIODIR_Msk              (0x1ul << SPI_CTL_QDIODIR_Pos)                    /*!< SPI_T::CTL: QDIODIR Mask                  */

#define SPI_CTL_DUALIOEN_Pos             (21)                                              /*!< SPI_T::CTL: DUALIOEN Position             */
#define SPI_CTL_DUALIOEN_Msk             (0x1ul << SPI_CTL_DUALIOEN_Pos)                   /*!< SPI_T::CTL: DUALIOEN Mask                 */

#define SPI_CTL_QUADIOEN_Pos             (22)                                              /*!< SPI_T::CTL: QUADIOEN Position             */
#define SPI_CTL_QUADIOEN_Msk             (0x1ul << SPI_CTL_QUADIOEN_Pos)                   /*!< SPI_T::CTL: QUADIOEN Mask                 */

#define SPI_CLKDIV_DIVIDER_Pos           (0)                                               /*!< SPI_T::CLKDIV: DIVIDER Position           */
#define SPI_CLKDIV_DIVIDER_Msk           (0xfful << SPI_CLKDIV_DIVIDER_Pos)                /*!< SPI_T::CLKDIV: DIVIDER Mask               */

#define SPI_SSCTL_SS_Pos                 (0)                                               /*!< SPI_T::SSCTL: SS Position                 */
#define SPI_SSCTL_SS_Msk                 (0x1ul << SPI_SSCTL_SS_Pos)                       /*!< SPI_T::SSCTL: SS Mask                     */

#define SPI_SSCTL_SSACTPOL_Pos           (2)                                               /*!< SPI_T::SSCTL: SSACTPOL Position           */
#define SPI_SSCTL_SSACTPOL_Msk           (0x1ul << SPI_SSCTL_SSACTPOL_Pos)                 /*!< SPI_T::SSCTL: SSACTPOL Mask               */

#define SPI_SSCTL_AUTOSS_Pos             (3)                                               /*!< SPI_T::SSCTL: AUTOSS Position             */
#define SPI_SSCTL_AUTOSS_Msk             (0x1ul << SPI_SSCTL_AUTOSS_Pos)                   /*!< SPI_T::SSCTL: AUTOSS Mask                 */

#define SPI_SSCTL_SLV3WIRE_Pos           (4)                                               /*!< SPI_T::SSCTL: SLV3WIRE Position           */
#define SPI_SSCTL_SLV3WIRE_Msk           (0x1ul << SPI_SSCTL_SLV3WIRE_Pos)                 /*!< SPI_T::SSCTL: SLV3WIRE Mask               */

#define SPI_SSCTL_SLVTOIEN_Pos           (5)                                               /*!< SPI_T::SSCTL: SLVTOIEN Position           */
#define SPI_SSCTL_SLVTOIEN_Msk           (0x1ul << SPI_SSCTL_SLVTOIEN_Pos)                 /*!< SPI_T::SSCTL: SLVTOIEN Mask               */

#define SPI_SSCTL_SLVTORST_Pos           (6)                                               /*!< SPI_T::SSCTL: SLVTORST Position           */
#define SPI_SSCTL_SLVTORST_Msk           (0x1ul << SPI_SSCTL_SLVTORST_Pos)                 /*!< SPI_T::SSCTL: SLVTORST Mask               */

#define SPI_SSCTL_SLVBEIEN_Pos           (8)                                               /*!< SPI_T::SSCTL: SLVBEIEN Position           */
#define SPI_SSCTL_SLVBEIEN_Msk           (0x1ul << SPI_SSCTL_SLVBEIEN_Pos)                 /*!< SPI_T::SSCTL: SLVBEIEN Mask               */

#define SPI_SSCTL_SLVURIEN_Pos           (9)                                               /*!< SPI_T::SSCTL: SLVURIEN Position           */
#define SPI_SSCTL_SLVURIEN_Msk           (0x1ul << SPI_SSCTL_SLVURIEN_Pos)                 /*!< SPI_T::SSCTL: SLVURIEN Mask               */

#define SPI_SSCTL_SSACTIEN_Pos           (12)                                              /*!< SPI_T::SSCTL: SSACTIEN Position           */
#define SPI_SSCTL_SSACTIEN_Msk           (0x1ul << SPI_SSCTL_SSACTIEN_Pos)                 /*!< SPI_T::SSCTL: SSACTIEN Mask               */

#define SPI_SSCTL_SSINAIEN_Pos           (13)                                              /*!< SPI_T::SSCTL: SSINAIEN Position           */
#define SPI_SSCTL_SSINAIEN_Msk           (0x1ul << SPI_SSCTL_SSINAIEN_Pos)                 /*!< SPI_T::SSCTL: SSINAIEN Mask               */

#define SPI_SSCTL_SLVTOCNT_Pos           (16)                                              /*!< SPI_T::SSCTL: SLVTOCNT Position           */
#define SPI_SSCTL_SLVTOCNT_Msk           (0xfffful << SPI_SSCTL_SLVTOCNT_Pos)              /*!< SPI_T::SSCTL: SLVTOCNT Mask               */

#define SPI_PDMACTL_TXPDMAEN_Pos         (0)                                               /*!< SPI_T::PDMACTL: TXPDMAEN Position         */
#define SPI_PDMACTL_TXPDMAEN_Msk         (0x1ul << SPI_PDMACTL_TXPDMAEN_Pos)               /*!< SPI_T::PDMACTL: TXPDMAEN Mask             */

#define SPI_PDMACTL_RXPDMAEN_Pos         (1)                                               /*!< SPI_T::PDMACTL: RXPDMAEN Position         */
#define SPI_PDMACTL_RXPDMAEN_Msk         (0x1ul << SPI_PDMACTL_RXPDMAEN_Pos)               /*!< SPI_T::PDMACTL: RXPDMAEN Mask             */

#define SPI_PDMACTL_PDMARST_Pos          (2)                                               /*!< SPI_T::PDMACTL: PDMARST Position          */
#define SPI_PDMACTL_PDMARST_Msk          (0x1ul << SPI_PDMACTL_PDMARST_Pos)                /*!< SPI_T::PDMACTL: PDMARST Mask              */

#define SPI_FIFOCTL_RXRST_Pos            (0)                                               /*!< SPI_T::FIFOCTL: RXRST Position            */
#define SPI_FIFOCTL_RXRST_Msk            (0x1ul << SPI_FIFOCTL_RXRST_Pos)                  /*!< SPI_T::FIFOCTL: RXRST Mask                */

#define SPI_FIFOCTL_TXRST_Pos            (1)                                               /*!< SPI_T::FIFOCTL: TXRST Position            */
#define SPI_FIFOCTL_TXRST_Msk            (0x1ul << SPI_FIFOCTL_TXRST_Pos)                  /*!< SPI_T::FIFOCTL: TXRST Mask                */

#define SPI_FIFOCTL_RXTHIEN_Pos          (2)                                               /*!< SPI_T::FIFOCTL: RXTHIEN Position          */
#define SPI_FIFOCTL_RXTHIEN_Msk          (0x1ul << SPI_FIFOCTL_RXTHIEN_Pos)                /*!< SPI_T::FIFOCTL: RXTHIEN Mask              */

#define SPI_FIFOCTL_TXTHIEN_Pos          (3)                                               /*!< SPI_T::FIFOCTL: TXTHIEN Position          */
#define SPI_FIFOCTL_TXTHIEN_Msk          (0x1ul << SPI_FIFOCTL_TXTHIEN_Pos)                /*!< SPI_T::FIFOCTL: TXTHIEN Mask              */

#define SPI_FIFOCTL_RXTOIEN_Pos          (4)                                               /*!< SPI_T::FIFOCTL: RXTOIEN Position          */
#define SPI_FIFOCTL_RXTOIEN_Msk          (0x1ul << SPI_FIFOCTL_RXTOIEN_Pos)                /*!< SPI_T::FIFOCTL: RXTOIEN Mask              */

#define SPI_FIFOCTL_RXOVIEN_Pos          (5)                                               /*!< SPI_T::FIFOCTL: RXOVIEN Position          */
#define SPI_FIFOCTL_RXOVIEN_Msk          (0x1ul << SPI_FIFOCTL_RXOVIEN_Pos)                /*!< SPI_T::FIFOCTL: RXOVIEN Mask              */

#define SPI_FIFOCTL_TXUFPOL_Pos          (6)                                               /*!< SPI_T::FIFOCTL: TXUFPOL Position          */
#define SPI_FIFOCTL_TXUFPOL_Msk          (0x1ul << SPI_FIFOCTL_TXUFPOL_Pos)                /*!< SPI_T::FIFOCTL: TXUFPOL Mask              */

#define SPI_FIFOCTL_TXUFIEN_Pos          (7)                                               /*!< SPI_T::FIFOCTL: TXUFIEN Position          */
#define SPI_FIFOCTL_TXUFIEN_Msk          (0x1ul << SPI_FIFOCTL_TXUFIEN_Pos)                /*!< SPI_T::FIFOCTL: TXUFIEN Mask              */

#define SPI_FIFOCTL_RXFBCLR_Pos          (8)                                               /*!< SPI_T::FIFOCTL: RXFBCLR Position          */
#define SPI_FIFOCTL_RXFBCLR_Msk          (0x1ul << SPI_FIFOCTL_RXFBCLR_Pos)                /*!< SPI_T::FIFOCTL: RXFBCLR Mask              */

#define SPI_FIFOCTL_TXFBCLR_Pos          (9)                                               /*!< SPI_T::FIFOCTL: TXFBCLR Position          */
#define SPI_FIFOCTL_TXFBCLR_Msk          (0x1ul << SPI_FIFOCTL_TXFBCLR_Pos)                /*!< SPI_T::FIFOCTL: TXFBCLR Mask              */

#define SPI_FIFOCTL_RXTH_Pos             (24)                                              /*!< SPI_T::FIFOCTL: RXTH Position             */
#define SPI_FIFOCTL_RXTH_Msk             (0x7ul << SPI_FIFOCTL_RXTH_Pos)                   /*!< SPI_T::FIFOCTL: RXTH Mask                 */

#define SPI_FIFOCTL_TXTH_Pos             (28)                                              /*!< SPI_T::FIFOCTL: TXTH Position             */
#define SPI_FIFOCTL_TXTH_Msk             (0x7ul << SPI_FIFOCTL_TXTH_Pos)                   /*!< SPI_T::FIFOCTL: TXTH Mask                 */

#define SPI_STATUS_BUSY_Pos              (0)                                               /*!< SPI_T::STATUS: BUSY Position              */
#define SPI_STATUS_BUSY_Msk              (0x1ul << SPI_STATUS_BUSY_Pos)                    /*!< SPI_T::STATUS: BUSY Mask                  */

#define SPI_STATUS_UNITIF_Pos            (1)                                               /*!< SPI_T::STATUS: UNITIF Position            */
#define SPI_STATUS_UNITIF_Msk            (0x1ul << SPI_STATUS_UNITIF_Pos)                  /*!< SPI_T::STATUS: UNITIF Mask                */

#define SPI_STATUS_SSACTIF_Pos           (2)                                               /*!< SPI_T::STATUS: SSACTIF Position           */
#define SPI_STATUS_SSACTIF_Msk           (0x1ul << SPI_STATUS_SSACTIF_Pos)                 /*!< SPI_T::STATUS: SSACTIF Mask               */

#define SPI_STATUS_SSINAIF_Pos           (3)                                               /*!< SPI_T::STATUS: SSINAIF Position           */
#define SPI_STATUS_SSINAIF_Msk           (0x1ul << SPI_STATUS_SSINAIF_Pos)                 /*!< SPI_T::STATUS: SSINAIF Mask               */

#define SPI_STATUS_SSLINE_Pos            (4)                                               /*!< SPI_T::STATUS: SSLINE Position            */
#define SPI_STATUS_SSLINE_Msk            (0x1ul << SPI_STATUS_SSLINE_Pos)                  /*!< SPI_T::STATUS: SSLINE Mask                */

#define SPI_STATUS_SLVTOIF_Pos           (5)                                               /*!< SPI_T::STATUS: SLVTOIF Position           */
#define SPI_STATUS_SLVTOIF_Msk           (0x1ul << SPI_STATUS_SLVTOIF_Pos)                 /*!< SPI_T::STATUS: SLVTOIF Mask               */

#define SPI_STATUS_SLVBEIF_Pos           (6)                                               /*!< SPI_T::STATUS: SLVBEIF Position           */
#define SPI_STATUS_SLVBEIF_Msk           (0x1ul << SPI_STATUS_SLVBEIF_Pos)                 /*!< SPI_T::STATUS: SLVBEIF Mask               */

#define SPI_STATUS_SLVURIF_Pos           (7)                                               /*!< SPI_T::STATUS: SLVURIF Position           */
#define SPI_STATUS_SLVURIF_Msk           (0x1ul << SPI_STATUS_SLVURIF_Pos)                 /*!< SPI_T::STATUS: SLVURIF Mask               */

#define SPI_STATUS_RXEMPTY_Pos           (8)                                               /*!< SPI_T::STATUS: RXEMPTY Position           */
#define SPI_STATUS_RXEMPTY_Msk           (0x1ul << SPI_STATUS_RXEMPTY_Pos)                 /*!< SPI_T::STATUS: RXEMPTY Mask               */

#define SPI_STATUS_RXFULL_Pos            (9)                                               /*!< SPI_T::STATUS: RXFULL Position            */
#define SPI_STATUS_RXFULL_Msk            (0x1ul << SPI_STATUS_RXFULL_Pos)                  /*!< SPI_T::STATUS: RXFULL Mask                */

#define SPI_STATUS_RXTHIF_Pos            (10)                                              /*!< SPI_T::STATUS: RXTHIF Position            */
#define SPI_STATUS_RXTHIF_Msk            (0x1ul << SPI_STATUS_RXTHIF_Pos)                  /*!< SPI_T::STATUS: RXTHIF Mask                */

#define SPI_STATUS_RXOVIF_Pos            (11)                                              /*!< SPI_T::STATUS: RXOVIF Position            */
#define SPI_STATUS_RXOVIF_Msk            (0x1ul << SPI_STATUS_RXOVIF_Pos)                  /*!< SPI_T::STATUS: RXOVIF Mask                */

#define SPI_STATUS_RXTOIF_Pos            (12)                                              /*!< SPI_T::STATUS: RXTOIF Position            */
#define SPI_STATUS_RXTOIF_Msk            (0x1ul << SPI_STATUS_RXTOIF_Pos)                  /*!< SPI_T::STATUS: RXTOIF Mask                */

#define SPI_STATUS_SPIENSTS_Pos          (15)                                              /*!< SPI_T::STATUS: SPIENSTS Position          */
#define SPI_STATUS_SPIENSTS_Msk          (0x1ul << SPI_STATUS_SPIENSTS_Pos)                /*!< SPI_T::STATUS: SPIENSTS Mask              */

#define SPI_STATUS_TXEMPTY_Pos           (16)                                              /*!< SPI_T::STATUS: TXEMPTY Position           */
#define SPI_STATUS_TXEMPTY_Msk           (0x1ul << SPI_STATUS_TXEMPTY_Pos)                 /*!< SPI_T::STATUS: TXEMPTY Mask               */

#define SPI_STATUS_TXFULL_Pos            (17)                                              /*!< SPI_T::STATUS: TXFULL Position            */
#define SPI_STATUS_TXFULL_Msk            (0x1ul << SPI_STATUS_TXFULL_Pos)                  /*!< SPI_T::STATUS: TXFULL Mask                */

#define SPI_STATUS_TXTHIF_Pos            (18)                                              /*!< SPI_T::STATUS: TXTHIF Position            */
#define SPI_STATUS_TXTHIF_Msk            (0x1ul << SPI_STATUS_TXTHIF_Pos)                  /*!< SPI_T::STATUS: TXTHIF Mask                */

#define SPI_STATUS_TXUFIF_Pos            (19)                                              /*!< SPI_T::STATUS: TXUFIF Position            */
#define SPI_STATUS_TXUFIF_Msk            (0x1ul << SPI_STATUS_TXUFIF_Pos)                  /*!< SPI_T::STATUS: TXUFIF Mask                */

#define SPI_STATUS_TXRXRST_Pos           (23)                                              /*!< SPI_T::STATUS: TXRXRST Position           */
#define SPI_STATUS_TXRXRST_Msk           (0x1ul << SPI_STATUS_TXRXRST_Pos)                 /*!< SPI_T::STATUS: TXRXRST Mask               */

#define SPI_STATUS_RXCNT_Pos             (24)                                              /*!< SPI_T::STATUS: RXCNT Position             */
#define SPI_STATUS_RXCNT_Msk             (0xful << SPI_STATUS_RXCNT_Pos)                   /*!< SPI_T::STATUS: RXCNT Mask                 */

#define SPI_STATUS_TXCNT_Pos             (28)                                              /*!< SPI_T::STATUS: TXCNT Position             */
#define SPI_STATUS_TXCNT_Msk             (0xful << SPI_STATUS_TXCNT_Pos)                   /*!< SPI_T::STATUS: TXCNT Mask                 */

#define SPI_TX_TX_Pos                    (0)                                               /*!< SPI_T::TX: TX Position                    */
#define SPI_TX_TX_Msk                    (0xfffffffful << SPI_TX_TX_Pos)                   /*!< SPI_T::TX: TX Mask                        */

#define SPI_RX_RX_Pos                    (0)                                               /*!< SPI_T::RX: RX Position                    */
#define SPI_RX_RX_Msk                    (0xfffffffful << SPI_RX_RX_Pos)                   /*!< SPI_T::RX: RX Mask                        */

#define SPI_I2SCTL_I2SEN_Pos             (0)                                               /*!< SPI_T::I2SCTL: I2SEN Position             */
#define SPI_I2SCTL_I2SEN_Msk             (0x1ul << SPI_I2SCTL_I2SEN_Pos)                   /*!< SPI_T::I2SCTL: I2SEN Mask                 */

#define SPI_I2SCTL_TXEN_Pos              (1)                                               /*!< SPI_T::I2SCTL: TXEN Position              */
#define SPI_I2SCTL_TXEN_Msk              (0x1ul << SPI_I2SCTL_TXEN_Pos)                    /*!< SPI_T::I2SCTL: TXEN Mask                  */

#define SPI_I2SCTL_RXEN_Pos              (2)                                               /*!< SPI_T::I2SCTL: RXEN Position              */
#define SPI_I2SCTL_RXEN_Msk              (0x1ul << SPI_I2SCTL_RXEN_Pos)                    /*!< SPI_T::I2SCTL: RXEN Mask                  */

#define SPI_I2SCTL_MUTE_Pos              (3)                                               /*!< SPI_T::I2SCTL: MUTE Position              */
#define SPI_I2SCTL_MUTE_Msk              (0x1ul << SPI_I2SCTL_MUTE_Pos)                    /*!< SPI_T::I2SCTL: MUTE Mask                  */

#define SPI_I2SCTL_WDWIDTH_Pos           (4)                                               /*!< SPI_T::I2SCTL: WDWIDTH Position           */
#define SPI_I2SCTL_WDWIDTH_Msk           (0x3ul << SPI_I2SCTL_WDWIDTH_Pos)                 /*!< SPI_T::I2SCTL: WDWIDTH Mask               */

#define SPI_I2SCTL_MONO_Pos              (6)                                               /*!< SPI_T::I2SCTL: MONO Position              */
#define SPI_I2SCTL_MONO_Msk              (0x1ul << SPI_I2SCTL_MONO_Pos)                    /*!< SPI_T::I2SCTL: MONO Mask                  */

#define SPI_I2SCTL_ORDER_Pos             (7)                                               /*!< SPI_T::I2SCTL: ORDER Position             */
#define SPI_I2SCTL_ORDER_Msk             (0x1ul << SPI_I2SCTL_ORDER_Pos)                   /*!< SPI_T::I2SCTL: ORDER Mask                 */

#define SPI_I2SCTL_SLAVE_Pos             (8)                                               /*!< SPI_T::I2SCTL: SLAVE Position             */
#define SPI_I2SCTL_SLAVE_Msk             (0x1ul << SPI_I2SCTL_SLAVE_Pos)                   /*!< SPI_T::I2SCTL: SLAVE Mask                 */

#define SPI_I2SCTL_MCLKEN_Pos            (15)                                              /*!< SPI_T::I2SCTL: MCLKEN Position            */
#define SPI_I2SCTL_MCLKEN_Msk            (0x1ul << SPI_I2SCTL_MCLKEN_Pos)                  /*!< SPI_T::I2SCTL: MCLKEN Mask                */

#define SPI_I2SCTL_RZCEN_Pos             (16)                                              /*!< SPI_T::I2SCTL: RZCEN Position             */
#define SPI_I2SCTL_RZCEN_Msk             (0x1ul << SPI_I2SCTL_RZCEN_Pos)                   /*!< SPI_T::I2SCTL: RZCEN Mask                 */

#define SPI_I2SCTL_LZCEN_Pos             (17)                                              /*!< SPI_T::I2SCTL: LZCEN Position             */
#define SPI_I2SCTL_LZCEN_Msk             (0x1ul << SPI_I2SCTL_LZCEN_Pos)                   /*!< SPI_T::I2SCTL: LZCEN Mask                 */

#define SPI_I2SCTL_RXLCH_Pos             (23)                                              /*!< SPI_T::I2SCTL: RXLCH Position             */
#define SPI_I2SCTL_RXLCH_Msk             (0x1ul << SPI_I2SCTL_RXLCH_Pos)                   /*!< SPI_T::I2SCTL: RXLCH Mask                 */

#define SPI_I2SCTL_RZCIEN_Pos            (24)                                              /*!< SPI_T::I2SCTL: RZCIEN Position            */
#define SPI_I2SCTL_RZCIEN_Msk            (0x1ul << SPI_I2SCTL_RZCIEN_Pos)                  /*!< SPI_T::I2SCTL: RZCIEN Mask                */

#define SPI_I2SCTL_LZCIEN_Pos            (25)                                              /*!< SPI_T::I2SCTL: LZCIEN Position            */
#define SPI_I2SCTL_LZCIEN_Msk            (0x1ul << SPI_I2SCTL_LZCIEN_Pos)                  /*!< SPI_T::I2SCTL: LZCIEN Mask                */

#define SPI_I2SCTL_FORMAT_Pos            (28)                                              /*!< SPI_T::I2SCTL: FORMAT Position            */
#define SPI_I2SCTL_FORMAT_Msk            (0x3ul << SPI_I2SCTL_FORMAT_Pos)                  /*!< SPI_T::I2SCTL: FORMAT Mask                */

#define SPI_I2SCLK_MCLKDIV_Pos           (0)                                               /*!< SPI_T::I2SCLK: MCLKDIV Position           */
#define SPI_I2SCLK_MCLKDIV_Msk           (0x3ful << SPI_I2SCLK_MCLKDIV_Pos)                /*!< SPI_T::I2SCLK: MCLKDIV Mask               */

#define SPI_I2SCLK_BCLKDIV_Pos           (8)                                               /*!< SPI_T::I2SCLK: BCLKDIV Position           */
#define SPI_I2SCLK_BCLKDIV_Msk           (0x1fful << SPI_I2SCLK_BCLKDIV_Pos)               /*!< SPI_T::I2SCLK: BCLKDIV Mask               */

#define SPI_I2SSTS_RIGHT_Pos             (4)                                               /*!< SPI_T::I2SSTS: RIGHT Position             */
#define SPI_I2SSTS_RIGHT_Msk             (0x1ul << SPI_I2SSTS_RIGHT_Pos)                   /*!< SPI_T::I2SSTS: RIGHT Mask                 */

#define SPI_I2SSTS_RXEMPTY_Pos           (8)                                               /*!< SPI_T::I2SSTS: RXEMPTY Position           */
#define SPI_I2SSTS_RXEMPTY_Msk           (0x1ul << SPI_I2SSTS_RXEMPTY_Pos)                 /*!< SPI_T::I2SSTS: RXEMPTY Mask               */

#define SPI_I2SSTS_RXFULL_Pos            (9)                                               /*!< SPI_T::I2SSTS: RXFULL Position            */
#define SPI_I2SSTS_RXFULL_Msk            (0x1ul << SPI_I2SSTS_RXFULL_Pos)                  /*!< SPI_T::I2SSTS: RXFULL Mask                */

#define SPI_I2SSTS_RXTHIF_Pos            (10)                                              /*!< SPI_T::I2SSTS: RXTHIF Position            */
#define SPI_I2SSTS_RXTHIF_Msk            (0x1ul << SPI_I2SSTS_RXTHIF_Pos)                  /*!< SPI_T::I2SSTS: RXTHIF Mask                */

#define SPI_I2SSTS_RXOVIF_Pos            (11)                                              /*!< SPI_T::I2SSTS: RXOVIF Position            */
#define SPI_I2SSTS_RXOVIF_Msk            (0x1ul << SPI_I2SSTS_RXOVIF_Pos)                  /*!< SPI_T::I2SSTS: RXOVIF Mask                */

#define SPI_I2SSTS_RXTOIF_Pos            (12)                                              /*!< SPI_T::I2SSTS: RXTOIF Position            */
#define SPI_I2SSTS_RXTOIF_Msk            (0x1ul << SPI_I2SSTS_RXTOIF_Pos)                  /*!< SPI_T::I2SSTS: RXTOIF Mask                */

#define SPI_I2SSTS_I2SENSTS_Pos          (15)                                              /*!< SPI_T::I2SSTS: I2SENSTS Position          */
#define SPI_I2SSTS_I2SENSTS_Msk          (0x1ul << SPI_I2SSTS_I2SENSTS_Pos)                /*!< SPI_T::I2SSTS: I2SENSTS Mask              */

#define SPI_I2SSTS_TXEMPTY_Pos           (16)                                              /*!< SPI_T::I2SSTS: TXEMPTY Position           */
#define SPI_I2SSTS_TXEMPTY_Msk           (0x1ul << SPI_I2SSTS_TXEMPTY_Pos)                 /*!< SPI_T::I2SSTS: TXEMPTY Mask               */

#define SPI_I2SSTS_TXFULL_Pos            (17)                                              /*!< SPI_T::I2SSTS: TXFULL Position            */
#define SPI_I2SSTS_TXFULL_Msk            (0x1ul << SPI_I2SSTS_TXFULL_Pos)                  /*!< SPI_T::I2SSTS: TXFULL Mask                */

#define SPI_I2SSTS_TXTHIF_Pos            (18)                                              /*!< SPI_T::I2SSTS: TXTHIF Position            */
#define SPI_I2SSTS_TXTHIF_Msk            (0x1ul << SPI_I2SSTS_TXTHIF_Pos)                  /*!< SPI_T::I2SSTS: TXTHIF Mask                */

#define SPI_I2SSTS_TXUFIF_Pos            (19)                                              /*!< SPI_T::I2SSTS: TXUFIF Position            */
#define SPI_I2SSTS_TXUFIF_Msk            (0x1ul << SPI_I2SSTS_TXUFIF_Pos)                  /*!< SPI_T::I2SSTS: TXUFIF Mask                */

#define SPI_I2SSTS_RZCIF_Pos             (20)                                              /*!< SPI_T::I2SSTS: RZCIF Position             */
#define SPI_I2SSTS_RZCIF_Msk             (0x1ul << SPI_I2SSTS_RZCIF_Pos)                   /*!< SPI_T::I2SSTS: RZCIF Mask                 */

#define SPI_I2SSTS_LZCIF_Pos             (21)                                              /*!< SPI_T::I2SSTS: LZCIF Position             */
#define SPI_I2SSTS_LZCIF_Msk             (0x1ul << SPI_I2SSTS_LZCIF_Pos)                   /*!< SPI_T::I2SSTS: LZCIF Mask                 */

#define SPI_I2SSTS_TXRXRST_Pos           (23)                                              /*!< SPI_T::I2SSTS: TXRXRST Position           */
#define SPI_I2SSTS_TXRXRST_Msk           (0x1ul << SPI_I2SSTS_TXRXRST_Pos)                 /*!< SPI_T::I2SSTS: TXRXRST Mask               */

#define SPI_I2SSTS_RXCNT_Pos             (24)                                              /*!< SPI_T::I2SSTS: RXCNT Position             */
#define SPI_I2SSTS_RXCNT_Msk             (0x7ul << SPI_I2SSTS_RXCNT_Pos)                   /*!< SPI_T::I2SSTS: RXCNT Mask                 */

#define SPI_I2SSTS_TXCNT_Pos             (28)                                              /*!< SPI_T::I2SSTS: TXCNT Position             */
#define SPI_I2SSTS_TXCNT_Msk             (0x7ul << SPI_I2SSTS_TXCNT_Pos)                   /*!< SPI_T::I2SSTS: TXCNT Mask                 */

/**@}*/ /* SPI_CONST */
/**@}*/ /* end of SPI register group */


/*---------------------- System Manger Controller -------------------------*/
/**
    @addtogroup SYS System Manger Controller(SYS)
    Memory Mapped Structure for SYS Controller
@{ */


typedef struct
{

/**
 * @var SYS_T::PDID
 * Offset: 0x00  Part Device Identification Number Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[31:0]  |PDID      |Part Device Identification Number (Read Only)
 * |        |          |This register reflects device part number code.
 * |        |          |Software can read this register to identify which device is used.
 * @var SYS_T::RSTSTS
 * Offset: 0x04  System Reset Status Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |PORF      |POR Reset Flag
 * |        |          |The POR reset flag is set by the "Reset Signal" from the Power-On Reset (POR) Controller or bit CHIPRST (SYS_IPRST0[0]) to indicate the previous reset source.
 * |        |          |0 = No reset from POR or CHIPRST.
 * |        |          |1 = Power-On Reset (POR) or CHIPRST had issued the reset signal to reset the system.
 * |        |          |Note: Write 1 to clear this bit to 0.
 * |[1]     |PINRF     |nRESET Pin Reset Flag
 * |        |          |The nRESET pin reset flag is set by the "Reset Signal" from the nRESET Pin to indicate the previous reset source.
 * |        |          |0 = No reset from nRESET pin.
 * |        |          |1 = Pin nRESET had issued the reset signal to reset the system.
 * |        |          |Note: Write 1 to clear this bit to 0.
 * |[2]     |WDTRF     |WDT Reset Flag
 * |        |          |The WDT reset flag is set by the "Reset Signal" from the Watchdog Timer or Window Watchdog Timer to indicate the previous reset source.
 * |        |          |0 = No reset from watchdog timer or window watchdog timer.
 * |        |          |1 = The watchdog timer or window watchdog timer had issued the reset signal to reset the system.
 * |        |          |Note1:
 * |        |          |Write 1 to clear this bit to 0.
 * |        |          |Note2: Watchdog Timer register RSTF(WDT_CTL[2]) bit is set if the system has been reset by WDT time-out reset.
 * |        |          |Window Watchdog Timer register WWDTRF(WWDT_STATUS[1]) bit is set if the system has been reset by WWDT time-out reset.
 * |[3]     |LVRF      |LVR Reset Flag
 * |        |          |The LVR reset flag is set by the "Reset Signal" from the Low-Voltage-Reset Controller to indicate the previous reset source.
 * |        |          |0 = No reset from LVR.
 * |        |          |1 = LVR controller had issued the reset signal to reset the system.
 * |        |          |Note: Write 1 to clear this bit to 0.
 * |[4]     |BODRF     |BOD Reset Flag
 * |        |          |The BOD reset flag is set by the "Reset Signal" from the Brown-Out-Detector to indicate the previous reset source.
 * |        |          |0 = No reset from BOD.
 * |        |          |1 = The BOD had issued the reset signal to reset the system.
 * |        |          |Note: Write 1 to clear this bit to 0.
 * |[5]     |SYSRF     |System Reset Flag
 * |        |          |The system reset flag is set by the "Reset Signal" from the Cortex-M4 Core to indicate the previous reset source.
 * |        |          |0 = No reset from Cortex-M4.
 * |        |          |1 = The Cortex-M4 had issued the reset signal to reset the system by writing 1 to the bit SYSRESETREQ(AIRCR[2], Application Interrupt and Reset Control Register, address = 0xE000ED0C) in system control registers of Cortex-M4 core.
 * |        |          |Note: Write 1 to clear this bit to 0.
 * |[7]     |CPURF     |CPU Reset Flag
 * |        |          |The CPU reset flag is set by hardware if software writes CPURST (SYS_IPRST0[1]) 1 to reset Cortex-M4 Core and Flash Memory Controller (FMC).
 * |        |          |0 = No reset from CPU.
 * |        |          |1 = The Cortex-M4 Core and FMC are reset by software setting CPURST to 1.
 * |        |          |Note: Write 1 to clear this bit to 0.
 * |[8]     |CPULKRF   |CPU Lockup Reset Flag
 * |        |          |The CPU reset flag is set by hardware if Cortex-M4 lockup happened.
 * |        |          |0 = No reset from CPU lockup happened.
 * |        |          |1 = The Cortex-M4 lockup happened and chip is reset.
 * |        |          |Note: Write 1 to clear this bit to 0.
 * @var SYS_T::IPRST0
 * Offset: 0x08  Peripheral  Reset Control Register 0
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |CHIPRST   |Chip One-Shot Reset (Write Protect)
 * |        |          |Setting this bit will reset the whole chip, including Processor core and all peripherals, and this bit will automatically return to 0 after the 2 clock cycles.
 * |        |          |The CHIPRST is same as the POR reset, all the chip controllers is reset and the chip setting from flash are also reload.
 * |        |          |About the difference between CHIPRST and SYSRESETREQ, please refer to section 5.2.2
 * |        |          |0 = Chip normal operation.
 * |        |          |1 = Chip one shot reset.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.
 * |[1]     |CPURST    |Processor Core One-Shot Reset (Write Protect)
 * |        |          |Setting this bit will only reset the processor core and Flash Memory Controller(FMC), and this bit will automatically return to 0 after the 2 clock cycles.
 * |        |          |0 = Processor core normal operation.
 * |        |          |1 = Processor core one-shot reset.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.
 * |[2]     |PDMARST   |PDMA Controller Reset (Write Protect)
 * |        |          |Setting this bit to 1 will generate a reset signal to the PDMA.
 * |        |          |User needs to set this bit to 0 to release from reset state.
 * |        |          |0 = PDMA controller normal operation.
 * |        |          |1 = PDMA controller reset.
 * |[3]     |EBIRST    |EBI Controller Reset (Write Protect)
 * |        |          |Set this bit to 1 will generate a reset signal to the EBI.
 * |        |          |User needs to set this bit to 0 to release from the reset state.
 * |        |          |0 = EBI controller normal operation.
 * |        |          |1 = EBI controller reset.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.
 * |[4]     |USBHRST   |USBH Controller Reset (Write Protect)
 * |        |          |Set this bit to 1 will generate a reset signal to the USB host controller.
 * |        |          |User needs to set this bit to 0 to release from the reset state.
 * |        |          |0 = USBH controller normal operation.
 * |        |          |1 = USBH controller reset.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.
 * |[7]     |CRCRST    |CRC Calculation Unit Reset (Write Protect)
 * |        |          |Set this bit to 1 will generate a reset signal to the CRC calculation module.
 * |        |          |User needs to set this bit to 0 to release from the reset state.
 * |        |          |0 = CRC Calculation unit normal operation.
 * |        |          |1 = CRC Calculation unit reset.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.
 * @var SYS_T::IPRST1
 * Offset: 0x0C  Peripheral Reset Control Register 1
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[1]     |GPIORST   |GPIO Controller Reset
 * |        |          |0 = GPIO controller normal operation.
 * |        |          |1 = GPIO controller reset.
 * |[2]     |TMR0RST   |Timer0 Controller Reset
 * |        |          |0 = Timer0 controller normal operation.
 * |        |          |1 = Timer0 controller reset.
 * |[3]     |TMR1RST   |Timer1 Controller Reset
 * |        |          |0 = Timer1 controller normal operation.
 * |        |          |1 = Timer1 controller reset.
 * |[4]     |TMR2RST   |Timer2 Controller Reset
 * |        |          |0 = Timer2 controller normal operation.
 * |        |          |1 = Timer2 controller reset.
 * |[5]     |TMR3RST   |Timer3 Controller Reset
 * |        |          |0 = Timer3 controller normal operation.
 * |        |          |1 = Timer3 controller reset.
 * |[7]     |ACMP01RST |Analog Comparator 0/1 Controller Reset
 * |        |          |0 = Analog Comparator 0/1 controller normal operation.
 * |        |          |1 = Analog Comparator 0/1 controller reset.
 * |[8]     |I2C0RST   |I2C0 Controller Reset
 * |        |          |0 = I2C0 controller normal operation.
 * |        |          |1 = I2C0 controller reset.
 * |[9]     |I2C1RST   |I2C1 Controller Reset
 * |        |          |0 = I2C1 controller normal operation.
 * |        |          |1 = I2C1 controller reset.
 * |[12]    |SPI0RST   |SPI0 Controller Reset
 * |        |          |0 = SPI0 controller normal operation.
 * |        |          |1 = SPI0 controller reset.
 * |[13]    |SPI1RST   |SPI1 Controller Reset
 * |        |          |0 = SPI1 controller normal operation.
 * |        |          |1 = SPI1 controller reset.
 * |[14]    |SPI2RST   |SPI2 Controller Reset
 * |        |          |0 = SPI2 controller normal operation.
 * |        |          |1 = SPI2 controller reset.
 * |[16]    |UART0RST  |UART0 Controller Reset
 * |        |          |0 = UART0 controller normal operation.
 * |        |          |1 = UART0 controller reset.
 * |[17]    |UART1RST  |UART1 Controller Reset
 * |        |          |0 = UART1 controller normal operation.
 * |        |          |1 = UART1 controller reset.
 * |[18]    |UART2RST  |UART2 Controller Reset
 * |        |          |0 = UART2 controller normal operation.
 * |        |          |1 = UART2 controller reset.
 * |[19]    |UART3RST  |UART3 Controller Reset
 * |        |          |0 = UART3 controller normal operation.
 * |        |          |1 = UART3 controller reset.
 * |[24]    |CAN0RST   |CAN0 Controller Reset
 * |        |          |0 = CAN0 controller normal operation.
 * |        |          |1 = CAN0 controller reset.
 * |[26]    |OTGRST    |OTG Controller Reset
 * |        |          |0 = OTG controller normal operation.
 * |        |          |1 = OTG controller reset.
 * |[27]    |USBDRST   |USB Device Controller Reset
 * |        |          |0 = USB device controller normal operation.
 * |        |          |1 = USB device controller reset.
 * |[28]    |EADCRST   |EADC Controller Reset
 * |        |          |0 = EADC controller normal operation.
 * |        |          |1 = EADC controller reset.
 * @var SYS_T::IPRST2
 * Offset: 0x10  Peripheral Reset Control Register 2
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |SC0RST    |SC0 Controller Reset
 * |        |          |0 = SC0 controller normal operation.
 * |        |          |1 = SC0 controller reset.
 * |[12]    |DACRST    |DAC Controller Reset
 * |        |          |0 = DAC controller normal operation.
 * |        |          |1 = DAC controller reset.
 * |[16]    |PWM0RST   |PWM0 Controller Reset
 * |        |          |0 = PWM0 controller normal operation.
 * |        |          |1 = PWM0 controller reset.
 * |[17]    |PWM1RST   |PWM1 Controller Reset
 * |        |          |0 = PWM1 controller normal operation.
 * |        |          |1 = PWM1 controller reset.
 * |[25]    |TKRST     |Touch Key Controller Reset
 * |        |          |0 = Touch Key controller normal operation.
 * |        |          |1 = Touch Key controller reset.
 * @var SYS_T::BODCTL
 * Offset: 0x18  Brown-Out Detector Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |BODEN     |Brown-Out Detector Enable Bit (Write Protect)
 * |        |          |The default value is set by flash controller user configuration register CBODEN (CONFIG0 [23]).
 * |        |          |0 = Brown-out Detector function Disabled.
 * |        |          |1 = Brown-out Detector function Enabled.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.
 * |[2:1]   |BODVL     |Brown-Out Detector Threshold Voltage Selection (Write Protect)
 * |        |          |The default value is set by flash controller user configuration register CBOV (CONFIG0 [22:21]).
 * |        |          |00 = Brown-Out Detector Threshold Voltage is 2.2V
 * |        |          |01 = Brown-Out Detector Threshold Voltage is 2.7V
 * |        |          |10 = Brown-Out Detector Threshold Voltage is 3.7V
 * |        |          |11 = Brown-Out Detector Threshold Voltage is 4.5V
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.
 * |[3]     |BODRSTEN  |Brown-Out Reset Enable Bit (Write Protect)
 * |        |          |The default value is set by flash controller user configuration register CBORST(CONFIG0[20]) bit .
 * |        |          |0 = Brown-out "INTERRUPT" function Enabled.
 * |        |          |1 = Brown-out "RESET" function Enabled.
 * |        |          |Note1:
 * |        |          |While the Brown-out Detector function is enabled (BODEN high) and BOD reset function is enabled (BODRSTEN high), BOD will assert a signal to reset chip when the detected voltage is lower than the threshold (BODOUT high).
 * |        |          |While the BOD function is enabled (BODEN high) and BOD interrupt function is enabled (BODRSTEN low), BOD will assert an interrupt if BODOUT is high.
 * |        |          |BOD interrupt will keep till to the BODEN set to 0.
 * |        |          |BOD interrupt can be blocked by disabling the NVIC BOD interrupt or disabling BOD function (set BODEN low).
 * |        |          |Note2: This bit is write protected. Refer to the SYS_REGLCTL register.
 * |[4]     |BODIF     |Brown-Out Detector Interrupt Flag
 * |        |          |0 = Brown-out Detector does not detect any voltage draft at VDD down through or up through the voltage of BODVL setting.
 * |        |          |1 = When Brown-out Detector detects the VDD is dropped down through the voltage of BODVL setting or the VDD is raised up through the voltage of BODVL setting, this bit is set to 1 and the brown-out interrupt is requested if brown-out interrupt is enabled.
 * |        |          |Note: Write 1 to clear this bit to 0.
 * |[5]     |BODLPM    |Brown-Out Detector Low Power Mode (Write Protect)
 * |        |          |0 = BOD operate in normal mode (default).
 * |        |          |1 = BOD Low Power mode Enabled.
 * |        |          |Note1: The BOD consumes about 100uA in normal mode, the low power mode can reduce the current to about 1/10 but slow the BOD response.
 * |        |          |Note2: This bit is write protected. Refer to the SYS_REGLCTL register.
 * |[6]     |BODOUT    |Brown-Out Detector Output Status
 * |        |          |0 = Brown-out Detector output status is 0.
 * |        |          |It means the detected voltage is higher than BODVL setting or BODEN is 0.
 * |        |          |1 = Brown-out Detector output status is 1.
 * |        |          |It means the detected voltage is lower than BODVL setting.
 * |        |          |If the BODEN is 0, BOD function disabled , this bit always responds 0000.
 * |[7]     |LVREN     |Low Voltage Reset Enable Bit (Write Protect)
 * |        |          |The LVR function resets the chip when the input power voltage is lower than LVR circuit setting.
 * |        |          |LVR function is enabled by default.
 * |        |          |0 = Low Voltage Reset function Disabled.
 * |        |          |1 = Low Voltage Reset function Enabled
 * |        |          |Note1: After enabling the bit, the LVR function will be active with 100us delay for LVR output stable (default).
 * |        |          |Note2: This bit is write protected. Refer to the SYS_REGLCTL register.
 * |[10:8]  |BODDGSEL  |Brown-Out Detector Output De-Glitch Time Select (Write Protect)
 * |        |          |000 = BOD output is sampled by RC10K clock.
 * |        |          |001 = 4 system clock (HCLK).
 * |        |          |010 = 8 system clock (HCLK).
 * |        |          |011 = 16 system clock (HCLK).
 * |        |          |100 = 32 system clock (HCLK).
 * |        |          |101 = 64 system clock (HCLK).
 * |        |          |110 = 128 system clock (HCLK).
 * |        |          |111 = 256 system clock (HCLK).
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.
 * |[14:12] |LVRDGSEL  |LVR Output De-Glitch Time Select (Write Protect)
 * |        |          |000 = Without de-glitch function.
 * |        |          |001 = 4 system clock (HCLK).
 * |        |          |010 = 8 system clock (HCLK).
 * |        |          |011 = 16 system clock (HCLK).
 * |        |          |100 = 32 system clock (HCLK).
 * |        |          |101 = 64 system clock (HCLK).
 * |        |          |110 = 128 system clock (HCLK).
 * |        |          |111 = 256 system clock (HCLK).
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.
 * @var SYS_T::IVSCTL
 * Offset: 0x1C  Internal Voltage Source Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |VTEMPEN   |Temperature Sensor Enable Bit
 * |        |          |This bit is used to enable/disable temperature sensor function.
 * |        |          |0 = Temperature sensor function Disabled (default).
 * |        |          |1 = Temperature sensor function Enabled.
 * |        |          |Note: After this bit is set to 1, the value of temperature sensor output can be obtained from ADC conversion result.
 * |        |          |Please refer to ADC function chapter for details.
 * |[1]     |VBATUGEN  |VBAT Unity Gain Buffer Enable Bit
 * |        |          |This bit is used to enable/disable VBAT unity gain buffer function.
 * |        |          |0 = VBAT unity gain buffer function Disabled (default).
 * |        |          |1 = VBAT unity gain buffer function Enabled.
 * |        |          |Note: After this bit is set to 1, the value of VBAT unity gain buffer output voltage can be obtained from ADC conversion result
 * @var SYS_T::PORCTL
 * Offset: 0x24  Power-On-Reset Controller Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[15:0]  |POROFF    |Power-On-Reset Enable Bit (Write Protect)
 * |        |          |When powered on, the POR circuit generates a reset signal to reset the whole chip function, but noise on the power may cause the POR active again.
 * |        |          |User can disable internal POR circuit to avoid unpredictable noise to cause chip reset by writing 0x5AA5 to this field.
 * |        |          |The POR function will be active again when this field is set to another value or chip is reset by other reset source, including:
 * |        |          |nRESET, Watchdog, LVR reset, BOD reset, ICE reset command and the software-chip reset function
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.
 * @var SYS_T::VREFCTL
 * Offset: 0x28  VREF Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[4:0]   |VREFCTL   |VREF Control Bits (Write Protect)
 * |        |          |00011 = VREF is internal 2.65V.
 * |        |          |00111 = VREF is internal 2.048V.
 * |        |          |01011 = VREF is internal 3.072V.
 * |        |          |01111 = VREF is internal 4.096V.
 * |        |          |Others = Reserved.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.
 * @var SYS_T::USBPHY
 * Offset: 0x2C  USB PHY Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[1:0]   |USBROLE   |USB Role Option (Write Protect)
 * |        |          |These two bits are used to select the role of USB.
 * |        |          |00 = Standard USB Device mode.
 * |        |          |01 = Standard USB Host mode.
 * |        |          |10 = ID dependent mode.
 * |        |          |11 = On-The-Go device mode.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.
 * |[8]     |LDO33EN   |USB LDO33 Enable Bit (Write Protect)
 * |        |          |0 = USB LDO33 Disabled.
 * |        |          |1 = USB LDO33 Enabled.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.
 * @var SYS_T::GPA_MFPL
 * Offset: 0x30  GPIOA Low Byte Multiple Function Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[3:0]   |PA0MFP    |PA.0 Multi-function Pin Selection
 * |[7:4]   |PA1MFP    |PA.1 Multi-function Pin Selection
 * |[11:8]  |PA2MFP    |PA.2 Multi-function Pin Selection
 * |[15:12] |PA3MFP    |PA.3 Multi-function Pin Selection
 * |[19:16] |PA4MFP    |PA.4 Multi-function Pin Selection
 * |[23:20] |PA5MFP    |PA.5 Multi-function Pin Selection
 * |[27:24] |PA6MFP    |PA.6 Multi-function Pin Selection
 * |[31:28] |PA7MFP    |PA.7 Multi-function Pin Selection
 * @var SYS_T::GPA_MFPH
 * Offset: 0x34  GPIOA High Byte Multiple Function Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[3:0]   |PA8MFP    |PA.8 Multi-function Pin Selection
 * |[7:4]   |PA9MFP    |PA.9 Multi-function Pin Selection
 * |[11:8]  |PA10MFP   |PA.10 Multi-function Pin Selection
 * |[15:12] |PA11MFP   |PA.11 Multi-function Pin Selection
 * |[19:16] |PA12MFP   |PA.12 Multi-function Pin Selection
 * |[23:20] |PA13MFP   |PA.13 Multi-function Pin Selection
 * |[27:24] |PA14MFP   |PA.14 Multi-function Pin Selection
 * |[31:28] |PA15MFP   |PA.15 Multi-function Pin Selection
 * @var SYS_T::GPB_MFPL
 * Offset: 0x38  GPIOB Low Byte Multiple Function Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[3:0]   |PB0MFP    |PB.0 Multi-function Pin Selection
 * |[7:4]   |PB1MFP    |PB.1 Multi-function Pin Selection
 * |[11:8]  |PB2MFP    |PB.2 Multi-function Pin Selection
 * |[15:12] |PB3MFP    |PB.3 Multi-function Pin Selection
 * |[19:16] |PB4MFP    |PB.4 Multi-function Pin Selection
 * |[23:20] |PB5MFP    |PB.5 Multi-function Pin Selection
 * |[27:24] |PB6MFP    |PB.6 Multi-function Pin Selection
 * |[31:28] |PB7MFP    |PB.7 Multi-function Pin Selection
 * @var SYS_T::GPB_MFPH
 * Offset: 0x3C  GPIOB High Byte Multiple Function Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[3:0]   |PB8MFP    |PB.8 Multi-function Pin Selection
 * |[7:4]   |PB9MFP    |PB.9 Multi-function Pin Selection
 * |[11:8]  |PB10MFP   |PB.10 Multi-function Pin Selection
 * |[15:12] |PB11MFP   |PB.11 Multi-function Pin Selection
 * |[19:16] |PB12MFP   |PB.12 Multi-function Pin Selection
 * |[23:20] |PB13MFP   |PB.13 Multi-function Pin Selection
 * |[27:24] |PB14MFP   |PB.14 Multi-function Pin Selection
 * |[31:28] |PB15MFP   |PB.15 Multi-function Pin Selection
 * @var SYS_T::GPC_MFPL
 * Offset: 0x40  GPIOC Low Byte Multiple Function Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[3:0]   |PC0MFP    |PC.0 Multi-function Pin Selection
 * |[7:4]   |PC1MFP    |PC.1 Multi-function Pin Selection
 * |[11:8]  |PC2MFP    |PC.2 Multi-function Pin Selection
 * |[15:12] |PC3MFP    |PC.3 Multi-function Pin Selection
 * |[19:16] |PC4MFP    |PC.4 Multi-function Pin Selection
 * |[23:20] |PC5MFP    |PC.5 Multi-function Pin Selection
 * |[27:24] |PC6MFP    |PC.6 Multi-function Pin Selection
 * |[31:28] |PC7MFP    |PC.7 Multi-function Pin Selection
 * @var SYS_T::GPC_MFPH
 * Offset: 0x44  GPIOC High Byte Multiple Function Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[3:0]   |PC8MFP    |PC.8 Multi-function Pin Selection
 * |[7:4]   |PC9MFP    |PC.9 Multi-function Pin Selection
 * |[11:8]  |PC10MFP   |PC.10 Multi-function Pin Selection
 * |[15:12] |PC11MFP   |PC.11 Multi-function Pin Selection
 * |[19:16] |PC12MFP   |PC.12 Multi-function Pin Selection
 * |[23:20] |PC13MFP   |PC.13 Multi-function Pin Selection
 * |[27:24] |PC14MFP   |PC.14 Multi-function Pin Selection
 * |[31:28] |PC15MFP   |PC.15 Multi-function Pin Selection
 * @var SYS_T::GPD_MFPL
 * Offset: 0x48  GPIOD Low Byte Multiple Function Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[3:0]   |PD0MFP    |PD.0 Multi-function Pin Selection
 * |[7:4]   |PD1MFP    |PD.1 Multi-function Pin Selection
 * |[11:8]  |PD2MFP    |PD.2 Multi-function Pin Selection
 * |[15:12] |PD3MFP    |PD.3 Multi-function Pin Selection
 * |[19:16] |PD4MFP    |PD.4 Multi-function Pin Selection
 * |[23:20] |PD5MFP    |PD.5 Multi-function Pin Selection
 * |[27:24] |PD6MFP    |PD.6 Multi-function Pin Selection
 * |[31:28] |PD7MFP    |PD.7 Multi-function Pin Selection
 * @var SYS_T::GPD_MFPH
 * Offset: 0x4C  GPIOD High Byte Multiple Function Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[3:0]   |PD8MFP    |PD.8 Multi-function Pin Selection
 * |[7:4]   |PD9MFP    |PD.9 Multi-function Pin Selection
 * |[11:8]  |PD10MFP   |PD.10 Multi-function Pin Selection
 * |[15:12] |PD11MFP   |PD.11 Multi-function Pin Selection
 * |[19:16] |PD12MFP   |PD.12 Multi-function Pin Selection
 * |[23:20] |PD13MFP   |PD.13 Multi-function Pin Selection
 * |[27:24] |PD14MFP   |PD.14 Multi-function Pin Selection
 * |[31:28] |PD15MFP   |PD.15 Multi-function Pin Selection
 * @var SYS_T::GPE_MFPL
 * Offset: 0x50  GPIOE Low Byte Multiple Function Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[3:0]   |PE0MFP    |PE.0 Multi-function Pin Selection
 * |[7:4]   |PE1MFP    |PE.1 Multi-function Pin Selection
 * |[11:8]  |PE2MFP    |PE.2 Multi-function Pin Selection
 * |[15:12] |PE3MFP    |PE.3 Multi-function Pin Selection
 * |[19:16] |PE4MFP    |PE.4 Multi-function Pin Selection
 * |[23:20] |PE5MFP    |PE.5 Multi-function Pin Selection
 * |[27:24] |PE6MFP    |PE.6 Multi-function Pin Selection
 * |[31:28] |PE7MFP    |PE.7 Multi-function Pin Selection
 * @var SYS_T::GPE_MFPH
 * Offset: 0x54  GPIOE High Byte Multiple Function Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[3:0]   |PE8MFP    |PE.8 Multi-function Pin Selection
 * |[7:4]   |PE9MFP    |PE.9 Multi-function Pin Selection
 * |[11:8]  |PE10MFP   |PE.10 Multi-function Pin Selection
 * |[15:12] |PE11MFP   |PE.11 Multi-function Pin Selection
 * |[19:16] |PE12MFP   |PE.12 Multi-function Pin Selection
 * |[23:20] |PE13MFP   |PE.13 Multi-function Pin Selection
 * |[27:24] |PE14_MFP  |PE.14 Multi-function Pin Selection
 * @var SYS_T::GPF_MFPL
 * Offset: 0x58  GPIOF Low Byte Multiple Function Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[3:0]   |PF0MFP    |PF.0 Multi-function Pin Selection
 * |[7:4]   |PF1MFP    |PF.1 Multi-function Pin Selection
 * |[11:8]  |PF2MFP    |PF.2 Multi-function Pin Selection
 * |[15:12] |PF3MFP    |PF.3 Multi-function Pin Selection
 * |[19:16] |PF4MFP    |PF.4 Multi-function Pin Selection
 * |[23:20] |PF5MFP    |PF.5 Multi-function Pin Selection
 * |[27:24] |PF6MFP    |PF.6 Multi-function Pin Selection
 * |[31:28] |PF7MFP    |PF.7 Multi-function Pin Selection
 * @var SYS_T::SRAM_INTCTL
 * Offset: 0xC0  System SRAM Interrupt Enable Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |PERRIEN   |SRAM Parity Check Error Interrupt Enable Bit
 * |        |          |0 = SRAM parity check error interrupt Disabled.
 * |        |          |1 = SRAM parity check error interrupt Enabled.
 * @var SYS_T::SRAM_STATUS
 * Offset: 0xC4  System SRAM Parity Error Status Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |PERRIF    |SRAM Parity Check Error Flag
 * |        |          |0 = No System SRAM parity error.
 * |        |          |1 = System SRAM parity error occur.
 * @var SYS_T::SRAM_ERRADDR
 * Offset: 0xC8  System SRAM Parity Check Error Address Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[31:0]  |ERRADDR   |System SRAM Parity Error Address
 * |        |          |This register shows system SRAM parity error byte address.
 * @var SYS_T::SRAM_BISTCTL
 * Offset: 0xD0  System SRAM BIST Test Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |SRBIST0   |1st
 * |        |          |SRAM BIST Enable Bit
 * |        |          |This bit enables BIST test for SRAM located in address 0x2000_0000 ~0x2000_3FFF
 * |        |          |0 = system SRAM BIST Disabled.
 * |        |          |1 = system SRAM BIST Enabled.
 * |[1]     |SRBIST1   |2nd
 * |        |          |SRAM BIST Enable Bit
 * |        |          |This bit enables BIST test for SRAM located in address 0x2000_4000 ~0x2000_7FFF
 * |        |          |0 = system SRAM BIST Disabled.
 * |        |          |1 = system SRAM BIST Enabled.
 * |[2]     |CRBIST    |CACHE BIST Enable Bit
 * |        |          |This bit enables BIST test for CACHE RAM
 * |        |          |0 = system CACHE BIST Disabled.
 * |        |          |1 = system CACHE BIST Enabled.
 * |[3]     |CANBIST   |CAN BIST Enable Bit
 * |        |          |This bit enables BIST test for CAN RAM
 * |        |          |0 = system CAN BIST Disabled.
 * |        |          |1 = system CAN BIST Enabled.
 * |[4]     |USBBIST   |USB BIST Enable Bit
 * |        |          |This bit enables BIST test for USB RAM
 * |        |          |0 = system USB BIST Disabled.
 * |        |          |1 = system USB BIST Enabled.
 * @var SYS_T::SRAM_BISTSTS
 * Offset: 0xD4  System SRAM BIST Test Status Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |SRBISTEF0 |1st System SRAM BIST Fail Flag
 * |        |          |0 = 1st system SRAM BIST test pass.
 * |        |          |1 = 1st system SRAM BIST test fail.
 * |[1]     |SRBISTEF1 |2nd System SRAM BIST Fail Flag
 * |        |          |0 = 2nd system SRAM BIST test pass.
 * |        |          |1 = 2nd system SRAM BIST test fail.
 * |[2]     |CRBISTEF  |CACHE SRAM BIST Fail Flag
 * |        |          |0 = System CACHE RAM BIST test pass.
 * |        |          |1 = System CACHE RAM BIST test fail.
 * |[3]     |CANBEF    |CAN SRAM BIST Fail Flag
 * |        |          |0 = CAN SRAM BIST test pass.
 * |        |          |1 = CAN SRAM BIST test fail.
 * |[4]     |USBBEF    |USB SRAM BIST Fail Flag
 * |        |          |0 = USB SRAM BIST test pass.
 * |        |          |1 = USB SRAM BIST test fail.
 * |[16]    |SRBEND0   |1st SRAM BIST Test Finish
 * |        |          |0 = 1st system SRAM BIST active.
 * |        |          |1 = 1st system SRAM BIST finish.
 * |[17]    |SRBEND1   |2nd SRAM BIST Test Finish
 * |        |          |0 = 2nd system SRAM BIST is active.
 * |        |          |1 = 2nd system SRAM BIST finish.
 * |[18]    |CRBEND    |CACHE SRAM BIST Test Finish
 * |        |          |0 = System CACHE RAM BIST is active.
 * |        |          |1 = System CACHE RAM BIST test finish.
 * |[19]    |CANBEND   |CAN SRAM BIST Test Finish
 * |        |          |0 = CAN SRAM BIST is active.
 * |        |          |1 = CAN SRAM BIST test finish.
 * |[20]    |USBBEND   |USB SRAM BIST Test Finish
 * |        |          |0 = USB SRAM BIST is active.
 * |        |          |1 = USB SRAM BIST test finish.
 * @var SYS_T::IRCTCTL
 * Offset: 0xF0  IRC Trim Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[1:0]   |FREQSEL   |Trim Frequency Selection
 * |        |          |This field indicates the target frequency of internal 22.1184 MHz high-speed oscillator auto trim.
 * |        |          |During auto trim operation, if clock error detected with CESTOPEN is set to 1 or trim retry limitation count reached, this field will be cleared to 00 automatically.
 * |        |          |00 = Disable HIRC auto trim function.
 * |        |          |01 = Enable HIRC auto trim function and trim HIRC to 22.1184 MHz.
 * |        |          |10 = Enable HIRC auto trim function and trim HIRC to 24 MHz.
 * |        |          |11 = Reserved.
 * |[5:4]   |LOOPSEL   |Trim Calculation Loop Selection
 * |        |          |This field defines that trim value calculation is based on how many 32.768 kHz clock.
 * |        |          |00 = Trim value calculation is based on average difference in 4 32.768 kHz clock.
 * |        |          |01 = Trim value calculation is based on average difference in 8 32.768 kHz clock.
 * |        |          |10 = Trim value calculation is based on average difference in 16 32.768 kHz clock.
 * |        |          |11 = Trim value calculation is based on average difference in 32 32.768 kHz clock.
 * |        |          |Note: For example, if LOOPSEL is set as 00, auto trim circuit will calculate trim value based on the average frequency difference in 4 32.768 kHz clock.
 * |[7:6]   |RETRYCNT  |Trim Value Update Limitation Count
 * |        |          |This field defines that how many times the auto trim circuit will try to update the HIRC trim value before the frequency of HIRC locked.
 * |        |          |Once the HIRC locked, the internal trim value update counter will be reset.
 * |        |          |If the trim value update counter reached this limitation value and frequency of HIRC still doesn't lock, the auto trim operation will be disabled and FREQSEL will be cleared to 00.
 * |        |          |00 = Trim retry count limitation is 64 loops.
 * |        |          |01 = Trim retry count limitation is 128 loops.
 * |        |          |10 = Trim retry count limitation is 256 loops.
 * |        |          |11 = Trim retry count limitation is 512 loops.
 * |[8]     |CESTOPEN  |Clock Error Stop Enable Bit
 * |        |          |0 = The trim operation is keep going if clock is inaccuracy.
 * |        |          |1 = The trim operation is stopped if clock is inaccuracy.
 * @var SYS_T::IRCTIEN
 * Offset: 0xF4  IRC Trim Interrupt Enable Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[1]     |TFAILIEN  |Trim Failure Interrupt Enable Bit
 * |        |          |This bit controls if an interrupt will be triggered while HIRC trim value update limitation count reached and HIRC frequency still not locked on target frequency set by FREQSEL(SYS_IRCTCTL[1:0]).
 * |        |          |If this bit is high and TFAILIF(SYS_IRCTSTS[1]) is set during auto trim operation, an interrupt will be triggered to notify that HIRC trim value update limitation count was reached.
 * |        |          |0 = Disable TFAILIF(SYS_IRCTSTS[1]) status to trigger an interrupt to CPU.
 * |        |          |1 = Enable TFAILIF(SYS_IRCTSTS[1]) status to trigger an interrupt to CPU.
 * |[2]     |CLKEIEN   |Clock Error Interrupt Enable Bit
 * |        |          |This bit controls if CPU would get an interrupt while clock is inaccuracy during auto trim operation.
 * |        |          |If this bit is set to1, and CLKERRIF(SYS_IRCTSTS[2]) is set during auto trim operation, an interrupt will be triggered to notify the clock frequency is inaccuracy.
 * |        |          |0 = Disable CLKERRIF(SYS_IRCTSTS[2]) status to trigger an interrupt to CPU.
 * |        |          |1 = Enable CLKERRIF(SYS_IRCTSTS[2]) status to trigger an interrupt to CPU.
 * @var SYS_T::IRCTISTS
 * Offset: 0xF8  IRC Trim Interrupt Status Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |FREQLOCK  |HIRC Frequency Lock Status
 * |        |          |This bit indicates the internal 22.1184 MHz high-speed oscillator frequency is locked.
 * |        |          |This is a status bit and doesn't trigger any interrupt.
 * |[1]     |TFAILIF   |Trim Failure Interrupt Status
 * |        |          |This bit indicates that internal 22.1184 MHz high-speed oscillator trim value update limitation count reached and the internal 22.1184 MHz high-speed oscillator clock frequency still doesn't be locked.
 * |        |          |Once this bit is set, the auto trim operation stopped and FREQSEL(SYS_iRCTCTL[1:0]) will be cleared to 00 by hardware automatically.
 * |        |          |If this bit is set and TFAILIEN(SYS_IRCTIEN[1]) is high, an interrupt will be triggered to notify that HIRC trim value update limitation count was reached.
 * |        |          |Write 1 to clear this to 0.
 * |        |          |0 = Trim value update limitation count does not reach.
 * |        |          |1 = Trim value update limitation count reached and internal 22.1184 MHz high-speed oscillator frequency still not locked.
 * |[2]     |CLKERRIF  |Clock Error Interrupt Status
 * |        |          |When the frequency of external 32.768 kHz low-speed crystal or internal 22.1184 MHz high-speed oscillator is shift larger to unreasonable value, this bit will be set and to be an indicate that clock frequency is inaccuracy
 * |        |          |Once this bit is set to 1, the auto trim operation stopped and FREQSEL(SYS_IRCTCL[1:0]) will be cleared to 00 by hardware automatically if CESTOPEN(SYS_IRCTCTL[8]) is set to 1.
 * |        |          |If this bit is set and CLKEIEN(SYS_IRCTIEN[2]) is high, an interrupt will be triggered to notify the clock frequency is inaccuracy.
 * |        |          |Write 1 to clear this to 0.
 * |        |          |0 = Clock frequency is accuracy.
 * |        |          |1 = Clock frequency is inaccuracy.
 * @var SYS_T::REGLCTL
 * Offset: 0x100  Register Lock Control Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[7:0]   |REGLCTL   |Register Lock Control Code
 * |        |          |Write operation:
 * |        |          |Some registers have write-protection function.
 * |        |          |Writing these registers have to disable the protected function by writing the sequence value "59h", "16h", "88h" to this field.
 * |        |          |After this sequence is completed, the REGLCTL bit will be set to 1 and write-protection registers can be normal write.
 * |        |          |Read operation:
 * |        |          |0 = Write-protection Enabled for writing protected registers.
 * |        |          |Any write to the protected register is ignored.
 * |        |          |1 = Write-protection Disabled for writing protected registers.
 * |        |          |The Protected registers are:
 * |        |          |SYS_IPRST0: address 0x4000_0008
 * |        |          |SYS_BODCTL: address 0x4000_0018
 * |        |          |SYS_PORCTL: address 0x4000_0024
 * |        |          |SYS_VREFCTL: address 0x4000_0028
 * |        |          |SYS_USBPHY: address 0x4000_002C
 * |        |          |CLK_PWRCTL: address 0x4000_0200 (bit[6] is not protected for power wake-up interrupt clear)
 * |        |          |SYS_SRAM_BISTCTL: address 0x4000_00D0
 * |        |          |CLK_APBCLK0 [0]: address 0x4000_0208 (bit[0] is watchdog clock enable)
 * |        |          |CLK_CLKSEL0: address 0x4000_0210 (for HCLK and CPU STCLK clock source select)
 * |        |          |CLK_CLKSEL1 [1:0]: address 0x4000_0214 (for watchdog clock source select)
 * |        |          |CLK_CLKSEL1 [31:30]: address 0x4000_0214 (for window watchdog clock source select)
 * |        |          |CLK_CLKDSTS: address 0x4000_0274
 * |        |          |NMIEN: address 0x4000_0300
 * |        |          |FMC_ISPCTL: address 0x4000_C000 (Flash ISP Control register)
 * |        |          |FMC_ISPTRG: address 0x4000_C010 (ISP Trigger Control register)
 * |        |          |FMC_ISPSTS: address 0x4000_C040
 * |        |          |WDT_CTL: address 0x4004_0000
 * |        |          |FMC_FTCTL: address 0x4000_5018
 * |        |          |FMC_ICPCMD: address 0x4000_501C
 * |        |          |CLK_PLLCTL: address 0x40000240
 * |        |          |PWM_CTL0: address 0x4005_8000
 * |        |          |PWM_CTL0: address 0x4005_9000
 * |        |          |PWM_DTCTL0_1: address 0x4005_8070
 * |        |          |PWM_DTCTL0_1: address 0x4005_9070
 * |        |          |PWM_DTCTL2_3: address 0x4005_8074
 * |        |          |PWM_DTCTL2_3: address 0x4005_9074
 * |        |          |PWM_DTCTL4_5: address 0x4005_8078
 * |        |          |PWM_DTCTL4_5: address 0x4005_9078
 * |        |          |PWM_BRKCTL0_1: address 0x4005_80C8
 * |        |          |PWM_BRKCTL0_1: address 0x4005_90C8
 * |        |          |PWM_BRKCTL2_3: address0x4005_80CC
 * |        |          |PWM_BRKCTL2_3: address0x4005_90CC
 * |        |          |PWM_BRKCTL4_5: address0x4005_80D0
 * |        |          |PWM_BRKCTL4_5: address0x4005_90D0
 * |        |          |PWM_INTEN1: address0x4005_80E4
 * |        |          |PWM_INTEN1: address0x4005_90E4
 * |        |          |PWM_INTSTS1: address0x4005_80EC
 * |        |          |PWM_INTSTS1: address0x4005_90EC
 */

    __I  uint32_t PDID;          /* Offset: 0x00  Part Device Identification Number Register                         */
    __IO uint32_t RSTSTS;        /* Offset: 0x04  System Reset Status Register                                       */
    __IO uint32_t IPRST0;        /* Offset: 0x08  Peripheral  Reset Control Register 0                               */
    __IO uint32_t IPRST1;        /* Offset: 0x0C  Peripheral Reset Control Register 1                                */
    __IO uint32_t IPRST2;        /* Offset: 0x10  Peripheral Reset Control Register 2                                */
    __I  uint32_t RESERVE0[1];  
    __IO uint32_t BODCTL;        /* Offset: 0x18  Brown-Out Detector Control Register                                */
    __IO uint32_t IVSCTL;        /* Offset: 0x1C  Internal Voltage Source Control Register                           */
    __I  uint32_t RESERVE1[1];  
    __IO uint32_t PORCTL;        /* Offset: 0x24  Power-On-Reset Controller Register                                 */
    __IO uint32_t VREFCTL;       /* Offset: 0x28  VREF Control Register                                              */
    __IO uint32_t USBPHY;        /* Offset: 0x2C  USB PHY Control Register                                           */
    __IO uint32_t GPA_MFPL;      /* Offset: 0x30  GPIOA Low Byte Multiple Function Control Register                  */
    __IO uint32_t GPA_MFPH;      /* Offset: 0x34  GPIOA High Byte Multiple Function Control Register                 */
    __IO uint32_t GPB_MFPL;      /* Offset: 0x38  GPIOB Low Byte Multiple Function Control Register                  */
    __IO uint32_t GPB_MFPH;      /* Offset: 0x3C  GPIOB High Byte Multiple Function Control Register                 */
    __IO uint32_t GPC_MFPL;      /* Offset: 0x40  GPIOC Low Byte Multiple Function Control Register                  */
    __IO uint32_t GPC_MFPH;      /* Offset: 0x44  GPIOC High Byte Multiple Function Control Register                 */
    __IO uint32_t GPD_MFPL;      /* Offset: 0x48  GPIOD Low Byte Multiple Function Control Register                  */
    __IO uint32_t GPD_MFPH;      /* Offset: 0x4C  GPIOD High Byte Multiple Function Control Register                 */
    __IO uint32_t GPE_MFPL;      /* Offset: 0x50  GPIOE Low Byte Multiple Function Control Register                  */
    __IO uint32_t GPE_MFPH;      /* Offset: 0x54  GPIOE High Byte Multiple Function Control Register                 */
    __IO uint32_t GPF_MFPL;      /* Offset: 0x58  GPIOF Low Byte Multiple Function Control Register                  */
    __I  uint32_t RESERVE2[25]; 
    __IO uint32_t SRAM_INTCTL;   /* Offset: 0xC0  System SRAM Interrupt Enable Control Register                      */
    __I  uint32_t SRAM_STATUS;   /* Offset: 0xC4  System SRAM Parity Error Status Register                           */
    __I  uint32_t SRAM_ERRADDR;  /* Offset: 0xC8  System SRAM Parity Check Error Address Register                    */
    __I  uint32_t RESERVE3[1];  
    __IO uint32_t SRAM_BISTCTL;  /* Offset: 0xD0  System SRAM BIST Test Control Register                             */
    __I  uint32_t SRAM_BISTSTS;  /* Offset: 0xD4  System SRAM BIST Test Status Register                              */
    __I  uint32_t RESERVE4[6];  
    __IO uint32_t IRCTCTL;       /* Offset: 0xF0  IRC Trim Control Register                                          */
    __IO uint32_t IRCTIEN;       /* Offset: 0xF4  IRC Trim Interrupt Enable Register                                 */
    __IO uint32_t IRCTISTS;      /* Offset: 0xF8  IRC Trim Interrupt Status Register                                 */
    __I  uint32_t RESERVE5[1];  
    __IO uint32_t REGLCTL;       /* Offset: 0x100  Register Lock Control Register                                    */

} SYS_T;



/**
    @addtogroup SYS_CONST SYS Bit Field Definition
    Constant Definitions for SYS Controller
@{ */

#define SYS_PDID_PDID_Pos                (0)                                               /*!< SYS_T::PDID: PDID Position                */
#define SYS_PDID_PDID_Msk                (0xfffffffful << SYS_PDID_PDID_Pos)               /*!< SYS_T::PDID: PDID Mask                    */

#define SYS_RSTSTS_PORF_Pos              (0)                                               /*!< SYS_T::RSTSTS: PORF Position              */
#define SYS_RSTSTS_PORF_Msk              (0x1ul << SYS_RSTSTS_PORF_Pos)                    /*!< SYS_T::RSTSTS: PORF Mask                  */

#define SYS_RSTSTS_PINRF_Pos             (1)                                               /*!< SYS_T::RSTSTS: PINRF Position             */
#define SYS_RSTSTS_PINRF_Msk             (0x1ul << SYS_RSTSTS_PINRF_Pos)                   /*!< SYS_T::RSTSTS: PINRF Mask                 */

#define SYS_RSTSTS_WDTRF_Pos             (2)                                               /*!< SYS_T::RSTSTS: WDTRF Position             */
#define SYS_RSTSTS_WDTRF_Msk             (0x1ul << SYS_RSTSTS_WDTRF_Pos)                   /*!< SYS_T::RSTSTS: WDTRF Mask                 */

#define SYS_RSTSTS_LVRF_Pos              (3)                                               /*!< SYS_T::RSTSTS: LVRF Position              */
#define SYS_RSTSTS_LVRF_Msk              (0x1ul << SYS_RSTSTS_LVRF_Pos)                    /*!< SYS_T::RSTSTS: LVRF Mask                  */

#define SYS_RSTSTS_BODRF_Pos             (4)                                               /*!< SYS_T::RSTSTS: BODRF Position             */
#define SYS_RSTSTS_BODRF_Msk             (0x1ul << SYS_RSTSTS_BODRF_Pos)                   /*!< SYS_T::RSTSTS: BODRF Mask                 */

#define SYS_RSTSTS_SYSRF_Pos             (5)                                               /*!< SYS_T::RSTSTS: SYSRF Position             */
#define SYS_RSTSTS_SYSRF_Msk             (0x1ul << SYS_RSTSTS_SYSRF_Pos)                   /*!< SYS_T::RSTSTS: SYSRF Mask                 */

#define SYS_RSTSTS_CPURF_Pos             (7)                                               /*!< SYS_T::RSTSTS: CPURF Position             */
#define SYS_RSTSTS_CPURF_Msk             (0x1ul << SYS_RSTSTS_CPURF_Pos)                   /*!< SYS_T::RSTSTS: CPURF Mask                 */

#define SYS_RSTSTS_CPULKRF_Pos           (8)                                               /*!< SYS_T::RSTSTS: CPULKRF Position           */
#define SYS_RSTSTS_CPULKRF_Msk           (0x1ul << SYS_RSTSTS_CPULKRF_Pos)                 /*!< SYS_T::RSTSTS: CPULKRF Mask               */

#define SYS_IPRST0_CHIPRST_Pos           (0)                                               /*!< SYS_T::IPRST0: CHIPRST Position           */
#define SYS_IPRST0_CHIPRST_Msk           (0x1ul << SYS_IPRST0_CHIPRST_Pos)                 /*!< SYS_T::IPRST0: CHIPRST Mask               */

#define SYS_IPRST0_CPURST_Pos            (1)                                               /*!< SYS_T::IPRST0: CPURST Position            */
#define SYS_IPRST0_CPURST_Msk            (0x1ul << SYS_IPRST0_CPURST_Pos)                  /*!< SYS_T::IPRST0: CPURST Mask                */

#define SYS_IPRST0_PDMARST_Pos           (2)                                               /*!< SYS_T::IPRST0: PDMARST Position           */
#define SYS_IPRST0_PDMARST_Msk           (0x1ul << SYS_IPRST0_PDMARST_Pos)                 /*!< SYS_T::IPRST0: PDMARST Mask               */

#define SYS_IPRST0_EBIRST_Pos            (3)                                               /*!< SYS_T::IPRST0: EBIRST Position            */
#define SYS_IPRST0_EBIRST_Msk            (0x1ul << SYS_IPRST0_EBIRST_Pos)                  /*!< SYS_T::IPRST0: EBIRST Mask                */

#define SYS_IPRST0_USBHRST_Pos           (4)                                               /*!< SYS_T::IPRST0: USBHRST Position           */
#define SYS_IPRST0_USBHRST_Msk           (0x1ul << SYS_IPRST0_USBHRST_Pos)                 /*!< SYS_T::IPRST0: USBHRST Mask               */

#define SYS_IPRST0_CRCRST_Pos            (7)                                               /*!< SYS_T::IPRST0: CRCRST Position            */
#define SYS_IPRST0_CRCRST_Msk            (0x1ul << SYS_IPRST0_CRCRST_Pos)                  /*!< SYS_T::IPRST0: CRCRST Mask                */

#define SYS_IPRST1_GPIORST_Pos           (1)                                               /*!< SYS_T::IPRST1: GPIORST Position           */
#define SYS_IPRST1_GPIORST_Msk           (0x1ul << SYS_IPRST1_GPIORST_Pos)                 /*!< SYS_T::IPRST1: GPIORST Mask               */

#define SYS_IPRST1_TMR0RST_Pos           (2)                                               /*!< SYS_T::IPRST1: TMR0RST Position           */
#define SYS_IPRST1_TMR0RST_Msk           (0x1ul << SYS_IPRST1_TMR0RST_Pos)                 /*!< SYS_T::IPRST1: TMR0RST Mask               */

#define SYS_IPRST1_TMR1RST_Pos           (3)                                               /*!< SYS_T::IPRST1: TMR1RST Position           */
#define SYS_IPRST1_TMR1RST_Msk           (0x1ul << SYS_IPRST1_TMR1RST_Pos)                 /*!< SYS_T::IPRST1: TMR1RST Mask               */

#define SYS_IPRST1_TMR2RST_Pos           (4)                                               /*!< SYS_T::IPRST1: TMR2RST Position           */
#define SYS_IPRST1_TMR2RST_Msk           (0x1ul << SYS_IPRST1_TMR2RST_Pos)                 /*!< SYS_T::IPRST1: TMR2RST Mask               */

#define SYS_IPRST1_TMR3RST_Pos           (5)                                               /*!< SYS_T::IPRST1: TMR3RST Position           */
#define SYS_IPRST1_TMR3RST_Msk           (0x1ul << SYS_IPRST1_TMR3RST_Pos)                 /*!< SYS_T::IPRST1: TMR3RST Mask               */

#define SYS_IPRST1_ACMP01RST_Pos         (7)                                               /*!< SYS_T::IPRST1: ACMP01RST Position         */
#define SYS_IPRST1_ACMP01RST_Msk         (0x1ul << SYS_IPRST1_ACMP01RST_Pos)               /*!< SYS_T::IPRST1: ACMP01RST Mask             */

#define SYS_IPRST1_I2C0RST_Pos           (8)                                               /*!< SYS_T::IPRST1: I2C0RST Position           */
#define SYS_IPRST1_I2C0RST_Msk           (0x1ul << SYS_IPRST1_I2C0RST_Pos)                 /*!< SYS_T::IPRST1: I2C0RST Mask               */

#define SYS_IPRST1_I2C1RST_Pos           (9)                                               /*!< SYS_T::IPRST1: I2C1RST Position           */
#define SYS_IPRST1_I2C1RST_Msk           (0x1ul << SYS_IPRST1_I2C1RST_Pos)                 /*!< SYS_T::IPRST1: I2C1RST Mask               */

#define SYS_IPRST1_SPI0RST_Pos           (12)                                              /*!< SYS_T::IPRST1: SPI0RST Position           */
#define SYS_IPRST1_SPI0RST_Msk           (0x1ul << SYS_IPRST1_SPI0RST_Pos)                 /*!< SYS_T::IPRST1: SPI0RST Mask               */

#define SYS_IPRST1_SPI1RST_Pos           (13)                                              /*!< SYS_T::IPRST1: SPI1RST Position           */
#define SYS_IPRST1_SPI1RST_Msk           (0x1ul << SYS_IPRST1_SPI1RST_Pos)                 /*!< SYS_T::IPRST1: SPI1RST Mask               */

#define SYS_IPRST1_SPI2RST_Pos           (14)                                              /*!< SYS_T::IPRST1: SPI2RST Position           */
#define SYS_IPRST1_SPI2RST_Msk           (0x1ul << SYS_IPRST1_SPI2RST_Pos)                 /*!< SYS_T::IPRST1: SPI2RST Mask               */

#define SYS_IPRST1_UART0RST_Pos          (16)                                              /*!< SYS_T::IPRST1: UART0RST Position          */
#define SYS_IPRST1_UART0RST_Msk          (0x1ul << SYS_IPRST1_UART0RST_Pos)                /*!< SYS_T::IPRST1: UART0RST Mask              */

#define SYS_IPRST1_UART1RST_Pos          (17)                                              /*!< SYS_T::IPRST1: UART1RST Position          */
#define SYS_IPRST1_UART1RST_Msk          (0x1ul << SYS_IPRST1_UART1RST_Pos)                /*!< SYS_T::IPRST1: UART1RST Mask              */

#define SYS_IPRST1_UART2RST_Pos          (18)                                              /*!< SYS_T::IPRST1: UART2RST Position          */
#define SYS_IPRST1_UART2RST_Msk          (0x1ul << SYS_IPRST1_UART2RST_Pos)                /*!< SYS_T::IPRST1: UART2RST Mask              */

#define SYS_IPRST1_UART3RST_Pos          (19)                                              /*!< SYS_T::IPRST1: UART3RST Position          */
#define SYS_IPRST1_UART3RST_Msk          (0x1ul << SYS_IPRST1_UART3RST_Pos)                /*!< SYS_T::IPRST1: UART3RST Mask              */

#define SYS_IPRST1_CAN0RST_Pos           (24)                                              /*!< SYS_T::IPRST1: CAN0RST Position           */
#define SYS_IPRST1_CAN0RST_Msk           (0x1ul << SYS_IPRST1_CAN0RST_Pos)                 /*!< SYS_T::IPRST1: CAN0RST Mask               */

#define SYS_IPRST1_OTGRST_Pos            (26)                                              /*!< SYS_T::IPRST1: OTGRST Position            */
#define SYS_IPRST1_OTGRST_Msk            (0x1ul << SYS_IPRST1_OTGRST_Pos)                  /*!< SYS_T::IPRST1: OTGRST Mask                */

#define SYS_IPRST1_USBDRST_Pos           (27)                                              /*!< SYS_T::IPRST1: USBDRST Position           */
#define SYS_IPRST1_USBDRST_Msk           (0x1ul << SYS_IPRST1_USBDRST_Pos)                 /*!< SYS_T::IPRST1: USBDRST Mask               */

#define SYS_IPRST1_EADCRST_Pos           (28)                                              /*!< SYS_T::IPRST1: EADCRST Position           */
#define SYS_IPRST1_EADCRST_Msk           (0x1ul << SYS_IPRST1_EADCRST_Pos)                 /*!< SYS_T::IPRST1: EADCRST Mask               */

#define SYS_IPRST2_SC0RST_Pos            (0)                                               /*!< SYS_T::IPRST2: SC0RST Position            */
#define SYS_IPRST2_SC0RST_Msk            (0x1ul << SYS_IPRST2_SC0RST_Pos)                  /*!< SYS_T::IPRST2: SC0RST Mask                */

#define SYS_IPRST2_DACRST_Pos            (12)                                              /*!< SYS_T::IPRST2: DACRST Position            */
#define SYS_IPRST2_DACRST_Msk            (0x1ul << SYS_IPRST2_DACRST_Pos)                  /*!< SYS_T::IPRST2: DACRST Mask                */

#define SYS_IPRST2_PWM0RST_Pos           (16)                                              /*!< SYS_T::IPRST2: PWM0RST Position           */
#define SYS_IPRST2_PWM0RST_Msk           (0x1ul << SYS_IPRST2_PWM0RST_Pos)                 /*!< SYS_T::IPRST2: PWM0RST Mask               */

#define SYS_IPRST2_PWM1RST_Pos           (17)                                              /*!< SYS_T::IPRST2: PWM1RST Position           */
#define SYS_IPRST2_PWM1RST_Msk           (0x1ul << SYS_IPRST2_PWM1RST_Pos)                 /*!< SYS_T::IPRST2: PWM1RST Mask               */

#define SYS_IPRST2_TKRST_Pos             (25)                                              /*!< SYS_T::IPRST2: TKRST Position             */
#define SYS_IPRST2_TKRST_Msk             (0x1ul << SYS_IPRST2_TKRST_Pos)                   /*!< SYS_T::IPRST2: TKRST Mask                 */

#define SYS_BODCTL_BODEN_Pos             (0)                                               /*!< SYS_T::BODCTL: BODEN Position             */
#define SYS_BODCTL_BODEN_Msk             (0x1ul << SYS_BODCTL_BODEN_Pos)                   /*!< SYS_T::BODCTL: BODEN Mask                 */

#define SYS_BODCTL_BODVL_Pos             (1)                                               /*!< SYS_T::BODCTL: BODVL Position             */
#define SYS_BODCTL_BODVL_Msk             (0x3ul << SYS_BODCTL_BODVL_Pos)                   /*!< SYS_T::BODCTL: BODVL Mask                 */

#define SYS_BODCTL_BODRSTEN_Pos          (3)                                               /*!< SYS_T::BODCTL: BODRSTEN Position          */
#define SYS_BODCTL_BODRSTEN_Msk          (0x1ul << SYS_BODCTL_BODRSTEN_Pos)                /*!< SYS_T::BODCTL: BODRSTEN Mask              */

#define SYS_BODCTL_BODIF_Pos             (4)                                               /*!< SYS_T::BODCTL: BODIF Position             */
#define SYS_BODCTL_BODIF_Msk             (0x1ul << SYS_BODCTL_BODIF_Pos)                   /*!< SYS_T::BODCTL: BODIF Mask                 */

#define SYS_BODCTL_BODLPM_Pos            (5)                                               /*!< SYS_T::BODCTL: BODLPM Position            */
#define SYS_BODCTL_BODLPM_Msk            (0x1ul << SYS_BODCTL_BODLPM_Pos)                  /*!< SYS_T::BODCTL: BODLPM Mask                */

#define SYS_BODCTL_BODOUT_Pos            (6)                                               /*!< SYS_T::BODCTL: BODOUT Position            */
#define SYS_BODCTL_BODOUT_Msk            (0x1ul << SYS_BODCTL_BODOUT_Pos)                  /*!< SYS_T::BODCTL: BODOUT Mask                */

#define SYS_BODCTL_LVREN_Pos             (7)                                               /*!< SYS_T::BODCTL: LVREN Position             */
#define SYS_BODCTL_LVREN_Msk             (0x1ul << SYS_BODCTL_LVREN_Pos)                   /*!< SYS_T::BODCTL: LVREN Mask                 */

#define SYS_BODCTL_BODDGSEL_Pos          (8)                                               /*!< SYS_T::BODCTL: BODDGSEL Position          */
#define SYS_BODCTL_BODDGSEL_Msk          (0x7ul << SYS_BODCTL_BODDGSEL_Pos)                /*!< SYS_T::BODCTL: BODDGSEL Mask              */

#define SYS_BODCTL_LVRDGSEL_Pos          (12)                                              /*!< SYS_T::BODCTL: LVRDGSEL Position          */
#define SYS_BODCTL_LVRDGSEL_Msk          (0x7ul << SYS_BODCTL_LVRDGSEL_Pos)                /*!< SYS_T::BODCTL: LVRDGSEL Mask              */

#define SYS_IVSCTL_VTEMPEN_Pos           (0)                                               /*!< SYS_T::IVSCTL: VTEMPEN Position           */
#define SYS_IVSCTL_VTEMPEN_Msk           (0x1ul << SYS_IVSCTL_VTEMPEN_Pos)                 /*!< SYS_T::IVSCTL: VTEMPEN Mask               */

#define SYS_IVSCTL_VBATUGEN_Pos          (1)                                               /*!< SYS_T::IVSCTL: VBATUGEN Position          */
#define SYS_IVSCTL_VBATUGEN_Msk          (0x1ul << SYS_IVSCTL_VBATUGEN_Pos)                /*!< SYS_T::IVSCTL: VBATUGEN Mask              */

#define SYS_PORCTL_POROFF_Pos            (0)                                               /*!< SYS_T::PORCTL: POROFF Position            */
#define SYS_PORCTL_POROFF_Msk            (0xfffful << SYS_PORCTL_POROFF_Pos)               /*!< SYS_T::PORCTL: POROFF Mask                */

#define SYS_VREFCTL_VREFCTL_Pos          (0)                                               /*!< SYS_T::VREFCTL: VREFCTL Position          */
#define SYS_VREFCTL_VREFCTL_Msk          (0x1ful << SYS_VREFCTL_VREFCTL_Pos)               /*!< SYS_T::VREFCTL: VREFCTL Mask              */

#define SYS_USBPHY_USBROLE_Pos           (0)                                               /*!< SYS_T::USBPHY: USBROLE Position           */
#define SYS_USBPHY_USBROLE_Msk           (0x3ul << SYS_USBPHY_USBROLE_Pos)                 /*!< SYS_T::USBPHY: USBROLE Mask               */

#define SYS_USBPHY_LDO33EN_Pos           (8)                                               /*!< SYS_T::USBPHY: LDO33EN Position           */
#define SYS_USBPHY_LDO33EN_Msk           (0x1ul << SYS_USBPHY_LDO33EN_Pos)                 /*!< SYS_T::USBPHY: LDO33EN Mask               */

#define SYS_GPA_MFPL_PA0MFP_Pos          (0)                                               /*!< SYS_T::GPA_MFPL: PA0MFP Position          */
#define SYS_GPA_MFPL_PA0MFP_Msk          (0xful << SYS_GPA_MFPL_PA0MFP_Pos)                /*!< SYS_T::GPA_MFPL: PA0MFP Mask              */

#define SYS_GPA_MFPL_PA1MFP_Pos          (4)                                               /*!< SYS_T::GPA_MFPL: PA1MFP Position          */
#define SYS_GPA_MFPL_PA1MFP_Msk          (0xful << SYS_GPA_MFPL_PA1MFP_Pos)                /*!< SYS_T::GPA_MFPL: PA1MFP Mask              */

#define SYS_GPA_MFPL_PA2MFP_Pos          (8)                                               /*!< SYS_T::GPA_MFPL: PA2MFP Position          */
#define SYS_GPA_MFPL_PA2MFP_Msk          (0xful << SYS_GPA_MFPL_PA2MFP_Pos)                /*!< SYS_T::GPA_MFPL: PA2MFP Mask              */

#define SYS_GPA_MFPL_PA3MFP_Pos          (12)                                              /*!< SYS_T::GPA_MFPL: PA3MFP Position          */
#define SYS_GPA_MFPL_PA3MFP_Msk          (0xful << SYS_GPA_MFPL_PA3MFP_Pos)                /*!< SYS_T::GPA_MFPL: PA3MFP Mask              */

#define SYS_GPA_MFPL_PA4MFP_Pos          (16)                                              /*!< SYS_T::GPA_MFPL: PA4MFP Position          */
#define SYS_GPA_MFPL_PA4MFP_Msk          (0xful << SYS_GPA_MFPL_PA4MFP_Pos)                /*!< SYS_T::GPA_MFPL: PA4MFP Mask              */

#define SYS_GPA_MFPL_PA5MFP_Pos          (20)                                              /*!< SYS_T::GPA_MFPL: PA5MFP Position          */
#define SYS_GPA_MFPL_PA5MFP_Msk          (0xful << SYS_GPA_MFPL_PA5MFP_Pos)                /*!< SYS_T::GPA_MFPL: PA5MFP Mask              */

#define SYS_GPA_MFPL_PA6MFP_Pos          (24)                                              /*!< SYS_T::GPA_MFPL: PA6MFP Position          */
#define SYS_GPA_MFPL_PA6MFP_Msk          (0xful << SYS_GPA_MFPL_PA6MFP_Pos)                /*!< SYS_T::GPA_MFPL: PA6MFP Mask              */

#define SYS_GPA_MFPL_PA7MFP_Pos          (28)                                              /*!< SYS_T::GPA_MFPL: PA7MFP Position          */
#define SYS_GPA_MFPL_PA7MFP_Msk          (0xful << SYS_GPA_MFPL_PA7MFP_Pos)                /*!< SYS_T::GPA_MFPL: PA7MFP Mask              */

#define SYS_GPA_MFPH_PA8MFP_Pos          (0)                                               /*!< SYS_T::GPA_MFPH: PA8MFP Position          */
#define SYS_GPA_MFPH_PA8MFP_Msk          (0xful << SYS_GPA_MFPH_PA8MFP_Pos)                /*!< SYS_T::GPA_MFPH: PA8MFP Mask              */

#define SYS_GPA_MFPH_PA9MFP_Pos          (4)                                               /*!< SYS_T::GPA_MFPH: PA9MFP Position          */
#define SYS_GPA_MFPH_PA9MFP_Msk          (0xful << SYS_GPA_MFPH_PA9MFP_Pos)                /*!< SYS_T::GPA_MFPH: PA9MFP Mask              */

#define SYS_GPA_MFPH_PA10MFP_Pos         (8)                                               /*!< SYS_T::GPA_MFPH: PA10MFP Position         */
#define SYS_GPA_MFPH_PA10MFP_Msk         (0xful << SYS_GPA_MFPH_PA10MFP_Pos)               /*!< SYS_T::GPA_MFPH: PA10MFP Mask             */

#define SYS_GPA_MFPH_PA11MFP_Pos         (12)                                              /*!< SYS_T::GPA_MFPH: PA11MFP Position         */
#define SYS_GPA_MFPH_PA11MFP_Msk         (0xful << SYS_GPA_MFPH_PA11MFP_Pos)               /*!< SYS_T::GPA_MFPH: PA11MFP Mask             */

#define SYS_GPA_MFPH_PA12MFP_Pos         (16)                                              /*!< SYS_T::GPA_MFPH: PA12MFP Position         */
#define SYS_GPA_MFPH_PA12MFP_Msk         (0xful << SYS_GPA_MFPH_PA12MFP_Pos)               /*!< SYS_T::GPA_MFPH: PA12MFP Mask             */

#define SYS_GPA_MFPH_PA13MFP_Pos         (20)                                              /*!< SYS_T::GPA_MFPH: PA13MFP Position         */
#define SYS_GPA_MFPH_PA13MFP_Msk         (0xful << SYS_GPA_MFPH_PA13MFP_Pos)               /*!< SYS_T::GPA_MFPH: PA13MFP Mask             */

#define SYS_GPA_MFPH_PA14MFP_Pos         (24)                                              /*!< SYS_T::GPA_MFPH: PA14MFP Position         */
#define SYS_GPA_MFPH_PA14MFP_Msk         (0xful << SYS_GPA_MFPH_PA14MFP_Pos)               /*!< SYS_T::GPA_MFPH: PA14MFP Mask             */

#define SYS_GPA_MFPH_PA15MFP_Pos         (28)                                              /*!< SYS_T::GPA_MFPH: PA15MFP Position         */
#define SYS_GPA_MFPH_PA15MFP_Msk         (0xful << SYS_GPA_MFPH_PA15MFP_Pos)               /*!< SYS_T::GPA_MFPH: PA15MFP Mask             */

#define SYS_GPB_MFPL_PB0MFP_Pos          (0)                                               /*!< SYS_T::GPB_MFPL: PB0MFP Position          */
#define SYS_GPB_MFPL_PB0MFP_Msk          (0xful << SYS_GPB_MFPL_PB0MFP_Pos)                /*!< SYS_T::GPB_MFPL: PB0MFP Mask              */

#define SYS_GPB_MFPL_PB1MFP_Pos          (4)                                               /*!< SYS_T::GPB_MFPL: PB1MFP Position          */
#define SYS_GPB_MFPL_PB1MFP_Msk          (0xful << SYS_GPB_MFPL_PB1MFP_Pos)                /*!< SYS_T::GPB_MFPL: PB1MFP Mask              */

#define SYS_GPB_MFPL_PB2MFP_Pos          (8)                                               /*!< SYS_T::GPB_MFPL: PB2MFP Position          */
#define SYS_GPB_MFPL_PB2MFP_Msk          (0xful << SYS_GPB_MFPL_PB2MFP_Pos)                /*!< SYS_T::GPB_MFPL: PB2MFP Mask              */

#define SYS_GPB_MFPL_PB3MFP_Pos          (12)                                              /*!< SYS_T::GPB_MFPL: PB3MFP Position          */
#define SYS_GPB_MFPL_PB3MFP_Msk          (0xful << SYS_GPB_MFPL_PB3MFP_Pos)                /*!< SYS_T::GPB_MFPL: PB3MFP Mask              */

#define SYS_GPB_MFPL_PB4MFP_Pos          (16)                                              /*!< SYS_T::GPB_MFPL: PB4MFP Position          */
#define SYS_GPB_MFPL_PB4MFP_Msk          (0xful << SYS_GPB_MFPL_PB4MFP_Pos)                /*!< SYS_T::GPB_MFPL: PB4MFP Mask              */

#define SYS_GPB_MFPL_PB5MFP_Pos          (20)                                              /*!< SYS_T::GPB_MFPL: PB5MFP Position          */
#define SYS_GPB_MFPL_PB5MFP_Msk          (0xful << SYS_GPB_MFPL_PB5MFP_Pos)                /*!< SYS_T::GPB_MFPL: PB5MFP Mask              */

#define SYS_GPB_MFPL_PB6MFP_Pos          (24)                                              /*!< SYS_T::GPB_MFPL: PB6MFP Position          */
#define SYS_GPB_MFPL_PB6MFP_Msk          (0xful << SYS_GPB_MFPL_PB6MFP_Pos)                /*!< SYS_T::GPB_MFPL: PB6MFP Mask              */

#define SYS_GPB_MFPL_PB7MFP_Pos          (28)                                              /*!< SYS_T::GPB_MFPL: PB7MFP Position          */
#define SYS_GPB_MFPL_PB7MFP_Msk          (0xful << SYS_GPB_MFPL_PB7MFP_Pos)                /*!< SYS_T::GPB_MFPL: PB7MFP Mask              */

#define SYS_GPB_MFPH_PB8MFP_Pos          (0)                                               /*!< SYS_T::GPB_MFPH: PB8MFP Position          */
#define SYS_GPB_MFPH_PB8MFP_Msk          (0xful << SYS_GPB_MFPH_PB8MFP_Pos)                /*!< SYS_T::GPB_MFPH: PB8MFP Mask              */

#define SYS_GPB_MFPH_PB9MFP_Pos          (4)                                               /*!< SYS_T::GPB_MFPH: PB9MFP Position          */
#define SYS_GPB_MFPH_PB9MFP_Msk          (0xful << SYS_GPB_MFPH_PB9MFP_Pos)                /*!< SYS_T::GPB_MFPH: PB9MFP Mask              */

#define SYS_GPB_MFPH_PB10MFP_Pos         (8)                                               /*!< SYS_T::GPB_MFPH: PB10MFP Position         */
#define SYS_GPB_MFPH_PB10MFP_Msk         (0xful << SYS_GPB_MFPH_PB10MFP_Pos)               /*!< SYS_T::GPB_MFPH: PB10MFP Mask             */

#define SYS_GPB_MFPH_PB11MFP_Pos         (12)                                              /*!< SYS_T::GPB_MFPH: PB11MFP Position         */
#define SYS_GPB_MFPH_PB11MFP_Msk         (0xful << SYS_GPB_MFPH_PB11MFP_Pos)               /*!< SYS_T::GPB_MFPH: PB11MFP Mask             */

#define SYS_GPB_MFPH_PB12MFP_Pos         (16)                                              /*!< SYS_T::GPB_MFPH: PB12MFP Position         */
#define SYS_GPB_MFPH_PB12MFP_Msk         (0xful << SYS_GPB_MFPH_PB12MFP_Pos)               /*!< SYS_T::GPB_MFPH: PB12MFP Mask             */

#define SYS_GPB_MFPH_PB13MFP_Pos         (20)                                              /*!< SYS_T::GPB_MFPH: PB13MFP Position         */
#define SYS_GPB_MFPH_PB13MFP_Msk         (0xful << SYS_GPB_MFPH_PB13MFP_Pos)               /*!< SYS_T::GPB_MFPH: PB13MFP Mask             */

#define SYS_GPB_MFPH_PB14MFP_Pos         (24)                                              /*!< SYS_T::GPB_MFPH: PB14MFP Position         */
#define SYS_GPB_MFPH_PB14MFP_Msk         (0xful << SYS_GPB_MFPH_PB14MFP_Pos)               /*!< SYS_T::GPB_MFPH: PB14MFP Mask             */

#define SYS_GPB_MFPH_PB15MFP_Pos         (28)                                              /*!< SYS_T::GPB_MFPH: PB15MFP Position         */
#define SYS_GPB_MFPH_PB15MFP_Msk         (0xful << SYS_GPB_MFPH_PB15MFP_Pos)               /*!< SYS_T::GPB_MFPH: PB15MFP Mask             */

#define SYS_GPC_MFPL_PC0MFP_Pos          (0)                                               /*!< SYS_T::GPC_MFPL: PC0MFP Position          */
#define SYS_GPC_MFPL_PC0MFP_Msk          (0xful << SYS_GPC_MFPL_PC0MFP_Pos)                /*!< SYS_T::GPC_MFPL: PC0MFP Mask              */

#define SYS_GPC_MFPL_PC1MFP_Pos          (4)                                               /*!< SYS_T::GPC_MFPL: PC1MFP Position          */
#define SYS_GPC_MFPL_PC1MFP_Msk          (0xful << SYS_GPC_MFPL_PC1MFP_Pos)                /*!< SYS_T::GPC_MFPL: PC1MFP Mask              */

#define SYS_GPC_MFPL_PC2MFP_Pos          (8)                                               /*!< SYS_T::GPC_MFPL: PC2MFP Position          */
#define SYS_GPC_MFPL_PC2MFP_Msk          (0xful << SYS_GPC_MFPL_PC2MFP_Pos)                /*!< SYS_T::GPC_MFPL: PC2MFP Mask              */

#define SYS_GPC_MFPL_PC3MFP_Pos          (12)                                              /*!< SYS_T::GPC_MFPL: PC3MFP Position          */
#define SYS_GPC_MFPL_PC3MFP_Msk          (0xful << SYS_GPC_MFPL_PC3MFP_Pos)                /*!< SYS_T::GPC_MFPL: PC3MFP Mask              */

#define SYS_GPC_MFPL_PC4MFP_Pos          (16)                                              /*!< SYS_T::GPC_MFPL: PC4MFP Position          */
#define SYS_GPC_MFPL_PC4MFP_Msk          (0xful << SYS_GPC_MFPL_PC4MFP_Pos)                /*!< SYS_T::GPC_MFPL: PC4MFP Mask              */

#define SYS_GPC_MFPL_PC5MFP_Pos          (20)                                              /*!< SYS_T::GPC_MFPL: PC5MFP Position          */
#define SYS_GPC_MFPL_PC5MFP_Msk          (0xful << SYS_GPC_MFPL_PC5MFP_Pos)                /*!< SYS_T::GPC_MFPL: PC5MFP Mask              */

#define SYS_GPC_MFPL_PC6MFP_Pos          (24)                                              /*!< SYS_T::GPC_MFPL: PC6MFP Position          */
#define SYS_GPC_MFPL_PC6MFP_Msk          (0xful << SYS_GPC_MFPL_PC6MFP_Pos)                /*!< SYS_T::GPC_MFPL: PC6MFP Mask              */

#define SYS_GPC_MFPL_PC7MFP_Pos          (28)                                              /*!< SYS_T::GPC_MFPL: PC7MFP Position          */
#define SYS_GPC_MFPL_PC7MFP_Msk          (0xful << SYS_GPC_MFPL_PC7MFP_Pos)                /*!< SYS_T::GPC_MFPL: PC7MFP Mask              */

#define SYS_GPC_MFPH_PC8MFP_Pos          (0)                                               /*!< SYS_T::GPC_MFPH: PC8MFP Position          */
#define SYS_GPC_MFPH_PC8MFP_Msk          (0xful << SYS_GPC_MFPH_PC8MFP_Pos)                /*!< SYS_T::GPC_MFPH: PC8MFP Mask              */

#define SYS_GPC_MFPH_PC9MFP_Pos          (4)                                               /*!< SYS_T::GPC_MFPH: PC9MFP Position          */
#define SYS_GPC_MFPH_PC9MFP_Msk          (0xful << SYS_GPC_MFPH_PC9MFP_Pos)                /*!< SYS_T::GPC_MFPH: PC9MFP Mask              */

#define SYS_GPC_MFPH_PC10MFP_Pos         (8)                                               /*!< SYS_T::GPC_MFPH: PC10MFP Position         */
#define SYS_GPC_MFPH_PC10MFP_Msk         (0xful << SYS_GPC_MFPH_PC10MFP_Pos)               /*!< SYS_T::GPC_MFPH: PC10MFP Mask             */

#define SYS_GPC_MFPH_PC11MFP_Pos         (12)                                              /*!< SYS_T::GPC_MFPH: PC11MFP Position         */
#define SYS_GPC_MFPH_PC11MFP_Msk         (0xful << SYS_GPC_MFPH_PC11MFP_Pos)               /*!< SYS_T::GPC_MFPH: PC11MFP Mask             */

#define SYS_GPC_MFPH_PC12MFP_Pos         (16)                                              /*!< SYS_T::GPC_MFPH: PC12MFP Position         */
#define SYS_GPC_MFPH_PC12MFP_Msk         (0xful << SYS_GPC_MFPH_PC12MFP_Pos)               /*!< SYS_T::GPC_MFPH: PC12MFP Mask             */

#define SYS_GPC_MFPH_PC13MFP_Pos         (20)                                              /*!< SYS_T::GPC_MFPH: PC13MFP Position         */
#define SYS_GPC_MFPH_PC13MFP_Msk         (0xful << SYS_GPC_MFPH_PC13MFP_Pos)               /*!< SYS_T::GPC_MFPH: PC13MFP Mask             */

#define SYS_GPC_MFPH_PC14MFP_Pos         (24)                                              /*!< SYS_T::GPC_MFPH: PC14MFP Position         */
#define SYS_GPC_MFPH_PC14MFP_Msk         (0xful << SYS_GPC_MFPH_PC14MFP_Pos)               /*!< SYS_T::GPC_MFPH: PC14MFP Mask             */

#define SYS_GPC_MFPH_PC15MFP_Pos         (28)                                              /*!< SYS_T::GPC_MFPH: PC15MFP Position         */
#define SYS_GPC_MFPH_PC15MFP_Msk         (0xful << SYS_GPC_MFPH_PC15MFP_Pos)               /*!< SYS_T::GPC_MFPH: PC15MFP Mask             */

#define SYS_GPD_MFPL_PD0MFP_Pos          (0)                                               /*!< SYS_T::GPD_MFPL: PD0MFP Position          */
#define SYS_GPD_MFPL_PD0MFP_Msk          (0xful << SYS_GPD_MFPL_PD0MFP_Pos)                /*!< SYS_T::GPD_MFPL: PD0MFP Mask              */

#define SYS_GPD_MFPL_PD1MFP_Pos          (4)                                               /*!< SYS_T::GPD_MFPL: PD1MFP Position          */
#define SYS_GPD_MFPL_PD1MFP_Msk          (0xful << SYS_GPD_MFPL_PD1MFP_Pos)                /*!< SYS_T::GPD_MFPL: PD1MFP Mask              */

#define SYS_GPD_MFPL_PD2MFP_Pos          (8)                                               /*!< SYS_T::GPD_MFPL: PD2MFP Position          */
#define SYS_GPD_MFPL_PD2MFP_Msk          (0xful << SYS_GPD_MFPL_PD2MFP_Pos)                /*!< SYS_T::GPD_MFPL: PD2MFP Mask              */

#define SYS_GPD_MFPL_PD3MFP_Pos          (12)                                              /*!< SYS_T::GPD_MFPL: PD3MFP Position          */
#define SYS_GPD_MFPL_PD3MFP_Msk          (0xful << SYS_GPD_MFPL_PD3MFP_Pos)                /*!< SYS_T::GPD_MFPL: PD3MFP Mask              */

#define SYS_GPD_MFPL_PD4MFP_Pos          (16)                                              /*!< SYS_T::GPD_MFPL: PD4MFP Position          */
#define SYS_GPD_MFPL_PD4MFP_Msk          (0xful << SYS_GPD_MFPL_PD4MFP_Pos)                /*!< SYS_T::GPD_MFPL: PD4MFP Mask              */

#define SYS_GPD_MFPL_PD5MFP_Pos          (20)                                              /*!< SYS_T::GPD_MFPL: PD5MFP Position          */
#define SYS_GPD_MFPL_PD5MFP_Msk          (0xful << SYS_GPD_MFPL_PD5MFP_Pos)                /*!< SYS_T::GPD_MFPL: PD5MFP Mask              */

#define SYS_GPD_MFPL_PD6MFP_Pos          (24)                                              /*!< SYS_T::GPD_MFPL: PD6MFP Position          */
#define SYS_GPD_MFPL_PD6MFP_Msk          (0xful << SYS_GPD_MFPL_PD6MFP_Pos)                /*!< SYS_T::GPD_MFPL: PD6MFP Mask              */

#define SYS_GPD_MFPL_PD7MFP_Pos          (28)                                              /*!< SYS_T::GPD_MFPL: PD7MFP Position          */
#define SYS_GPD_MFPL_PD7MFP_Msk          (0xful << SYS_GPD_MFPL_PD7MFP_Pos)                /*!< SYS_T::GPD_MFPL: PD7MFP Mask              */

#define SYS_GPD_MFPH_PD8MFP_Pos          (0)                                               /*!< SYS_T::GPD_MFPH: PD8MFP Position          */
#define SYS_GPD_MFPH_PD8MFP_Msk          (0xful << SYS_GPD_MFPH_PD8MFP_Pos)                /*!< SYS_T::GPD_MFPH: PD8MFP Mask              */

#define SYS_GPD_MFPH_PD9MFP_Pos          (4)                                               /*!< SYS_T::GPD_MFPH: PD9MFP Position          */
#define SYS_GPD_MFPH_PD9MFP_Msk          (0xful << SYS_GPD_MFPH_PD9MFP_Pos)                /*!< SYS_T::GPD_MFPH: PD9MFP Mask              */

#define SYS_GPD_MFPH_PD10MFP_Pos         (8)                                               /*!< SYS_T::GPD_MFPH: PD10MFP Position         */
#define SYS_GPD_MFPH_PD10MFP_Msk         (0xful << SYS_GPD_MFPH_PD10MFP_Pos)              /*!< SYS_T::GPD_MFPH: PD10MFP Mask              */

#define SYS_GPD_MFPH_PD11MFP_Pos         (12)                                              /*!< SYS_T::GPD_MFPH: PD11MFP Position         */
#define SYS_GPD_MFPH_PD11MFP_Msk         (0xful << SYS_GPD_MFPH_PD11MFP_Pos)               /*!< SYS_T::GPD_MFPH: PD11MFP Mask             */

#define SYS_GPD_MFPH_PD12MFP_Pos         (16)                                              /*!< SYS_T::GPD_MFPH: PD12MFP Position         */
#define SYS_GPD_MFPH_PD12MFP_Msk         (0xful << SYS_GPD_MFPH_PD12MFP_Pos)               /*!< SYS_T::GPD_MFPH: PD12MFP Mask             */

#define SYS_GPD_MFPH_PD13MFP_Pos         (20)                                              /*!< SYS_T::GPD_MFPH: PD13MFP Position         */
#define SYS_GPD_MFPH_PD13MFP_Msk         (0xful << SYS_GPD_MFPH_PD13MFP_Pos)               /*!< SYS_T::GPD_MFPH: PD13MFP Mask             */

#define SYS_GPD_MFPH_PD14MFP_Pos         (24)                                              /*!< SYS_T::GPD_MFPH: PD14MFP Position         */
#define SYS_GPD_MFPH_PD14MFP_Msk         (0xful << SYS_GPD_MFPH_PD14MFP_Pos)               /*!< SYS_T::GPD_MFPH: PD14MFP Mask             */

#define SYS_GPD_MFPH_PD15MFP_Pos         (28)                                              /*!< SYS_T::GPD_MFPH: PD15MFP Position         */
#define SYS_GPD_MFPH_PD15MFP_Msk         (0xful << SYS_GPD_MFPH_PD15MFP_Pos)               /*!< SYS_T::GPD_MFPH: PD15MFP Mask             */

#define SYS_GPE_MFPL_PE0MFP_Pos          (0)                                               /*!< SYS_T::GPE_MFPL: PE0MFP Position          */
#define SYS_GPE_MFPL_PE0MFP_Msk          (0xful << SYS_GPE_MFPL_PE0MFP_Pos)                /*!< SYS_T::GPE_MFPL: PE0MFP Mask              */

#define SYS_GPE_MFPL_PE1MFP_Pos          (4)                                               /*!< SYS_T::GPE_MFPL: PE1MFP Position          */
#define SYS_GPE_MFPL_PE1MFP_Msk          (0xful << SYS_GPE_MFPL_PE1MFP_Pos)                /*!< SYS_T::GPE_MFPL: PE1MFP Mask              */

#define SYS_GPE_MFPL_PE2MFP_Pos          (8)                                               /*!< SYS_T::GPE_MFPL: PE2MFP Position          */
#define SYS_GPE_MFPL_PE2MFP_Msk          (0xful << SYS_GPE_MFPL_PE2MFP_Pos)                /*!< SYS_T::GPE_MFPL: PE2MFP Mask              */

#define SYS_GPE_MFPL_PE3MFP_Pos          (12)                                              /*!< SYS_T::GPE_MFPL: PE3MFP Position          */
#define SYS_GPE_MFPL_PE3MFP_Msk          (0xful << SYS_GPE_MFPL_PE3MFP_Pos)                /*!< SYS_T::GPE_MFPL: PE3MFP Mask              */

#define SYS_GPE_MFPL_PE4MFP_Pos          (16)                                              /*!< SYS_T::GPE_MFPL: PE4MFP Position          */
#define SYS_GPE_MFPL_PE4MFP_Msk          (0xful << SYS_GPE_MFPL_PE4MFP_Pos)                /*!< SYS_T::GPE_MFPL: PE4MFP Mask              */

#define SYS_GPE_MFPL_PE5MFP_Pos          (20)                                              /*!< SYS_T::GPE_MFPL: PE5MFP Position          */
#define SYS_GPE_MFPL_PE5MFP_Msk          (0xful << SYS_GPE_MFPL_PE5MFP_Pos)                /*!< SYS_T::GPE_MFPL: PE5MFP Mask              */

#define SYS_GPE_MFPL_PE6MFP_Pos          (24)                                              /*!< SYS_T::GPE_MFPL: PE6MFP Position          */
#define SYS_GPE_MFPL_PE6MFP_Msk          (0xful << SYS_GPE_MFPL_PE6MFP_Pos)                /*!< SYS_T::GPE_MFPL: PE6MFP Mask              */

#define SYS_GPE_MFPL_PE7MFP_Pos          (28)                                              /*!< SYS_T::GPE_MFPL: PE7MFP Position          */
#define SYS_GPE_MFPL_PE7MFP_Msk          (0xful << SYS_GPE_MFPL_PE7MFP_Pos)                /*!< SYS_T::GPE_MFPL: PE7MFP Mask              */

#define SYS_GPE_MFPH_PE8MFP_Pos          (0)                                               /*!< SYS_T::GPE_MFPH: PE8MFP Position          */
#define SYS_GPE_MFPH_PE8MFP_Msk          (0xful << SYS_GPE_MFPH_PE8MFP_Pos)                /*!< SYS_T::GPE_MFPH: PE8MFP Mask              */

#define SYS_GPE_MFPH_PE9MFP_Pos          (4)                                               /*!< SYS_T::GPE_MFPH: PE9MFP Position          */
#define SYS_GPE_MFPH_PE9MFP_Msk          (0xful << SYS_GPE_MFPH_PE9MFP_Pos)                /*!< SYS_T::GPE_MFPH: PE9MFP Mask              */

#define SYS_GPE_MFPH_PE10MFP_Pos         (8)                                               /*!< SYS_T::GPE_MFPH: PE10MFP Position         */
#define SYS_GPE_MFPH_PE10MFP_Msk         (0xful << SYS_GPE_MFPH_PE10MFP_Pos)               /*!< SYS_T::GPE_MFPH: PE10MFP Mask             */

#define SYS_GPE_MFPH_PE11MFP_Pos         (12)                                              /*!< SYS_T::GPE_MFPH: PE11MFP Position         */
#define SYS_GPE_MFPH_PE11MFP_Msk         (0xful << SYS_GPE_MFPH_PE11MFP_Pos)               /*!< SYS_T::GPE_MFPH: PE11MFP Mask             */

#define SYS_GPE_MFPH_PE12MFP_Pos         (16)                                              /*!< SYS_T::GPE_MFPH: PE12MFP Position         */
#define SYS_GPE_MFPH_PE12MFP_Msk         (0xful << SYS_GPE_MFPH_PE12MFP_Pos)               /*!< SYS_T::GPE_MFPH: PE12MFP Mask             */

#define SYS_GPE_MFPH_PE13MFP_Pos         (20)                                              /*!< SYS_T::GPE_MFPH: PE13MFP Position         */
#define SYS_GPE_MFPH_PE13MFP_Msk         (0xful << SYS_GPE_MFPH_PE13MFP_Pos)               /*!< SYS_T::GPE_MFPH: PE13MFP Mask             */

#define SYS_GPE_MFPH_PE14MFP_Pos         (24)                                              /*!< SYS_T::GPE_MFPH: PE14MFP Position         */
#define SYS_GPE_MFPH_PE14MFP_Msk         (0xful << SYS_GPE_MFPH_PE14MFP_Pos)               /*!< SYS_T::GPE_MFPH: PE14MFP Mask             */

#define SYS_GPF_MFPL_PF0MFP_Pos          (0)                                               /*!< SYS_T::GPF_MFPL: PF0MFP Position          */
#define SYS_GPF_MFPL_PF0MFP_Msk          (0xful << SYS_GPF_MFPL_PF0MFP_Pos)                /*!< SYS_T::GPF_MFPL: PF0MFP Mask              */

#define SYS_GPF_MFPL_PF1MFP_Pos          (4)                                               /*!< SYS_T::GPF_MFPL: PF1MFP Position          */
#define SYS_GPF_MFPL_PF1MFP_Msk          (0xful << SYS_GPF_MFPL_PF1MFP_Pos)                /*!< SYS_T::GPF_MFPL: PF1MFP Mask              */

#define SYS_GPF_MFPL_PF2MFP_Pos          (8)                                               /*!< SYS_T::GPF_MFPL: PF2MFP Position          */
#define SYS_GPF_MFPL_PF2MFP_Msk          (0xful << SYS_GPF_MFPL_PF2MFP_Pos)                /*!< SYS_T::GPF_MFPL: PF2MFP Mask              */

#define SYS_GPF_MFPL_PF3MFP_Pos          (12)                                              /*!< SYS_T::GPF_MFPL: PF3MFP Position          */
#define SYS_GPF_MFPL_PF3MFP_Msk          (0xful << SYS_GPF_MFPL_PF3MFP_Pos)                /*!< SYS_T::GPF_MFPL: PF3MFP Mask              */

#define SYS_GPF_MFPL_PF4MFP_Pos          (16)                                              /*!< SYS_T::GPF_MFPL: PF4MFP Position          */
#define SYS_GPF_MFPL_PF4MFP_Msk          (0xful << SYS_GPF_MFPL_PF4MFP_Pos)                /*!< SYS_T::GPF_MFPL: PF4MFP Mask              */

#define SYS_GPF_MFPL_PF5MFP_Pos          (20)                                              /*!< SYS_T::GPF_MFPL: PF5MFP Position          */
#define SYS_GPF_MFPL_PF5MFP_Msk          (0xful << SYS_GPF_MFPL_PF5MFP_Pos)                /*!< SYS_T::GPF_MFPL: PF5MFP Mask              */

#define SYS_GPF_MFPL_PF6MFP_Pos          (24)                                              /*!< SYS_T::GPF_MFPL: PF6MFP Position          */
#define SYS_GPF_MFPL_PF6MFP_Msk          (0xful << SYS_GPF_MFPL_PF6MFP_Pos)                /*!< SYS_T::GPF_MFPL: PF6MFP Mask              */

#define SYS_GPF_MFPL_PF7MFP_Pos          (28)                                              /*!< SYS_T::GPF_MFPL: PF7MFP Position          */
#define SYS_GPF_MFPL_PF7MFP_Msk          (0xful << SYS_GPF_MFPL_PF7MFP_Pos)                /*!< SYS_T::GPF_MFPL: PF7MFP Mask              */

#define SYS_SRAM_INTCTL_PERRIEN_Pos      (0)                                               /*!< SYS_T::SRAM_INTCTL: PERRIEN Position      */
#define SYS_SRAM_INTCTL_PERRIEN_Msk      (0x1ul << SYS_SRAM_INTCTL_PERRIEN_Pos)            /*!< SYS_T::SRAM_INTCTL: PERRIEN Mask          */

#define SYS_SRAM_STATUS_PERRIF_Pos       (0)                                               /*!< SYS_T::SRAM_STATUS: PERRIF Position       */
#define SYS_SRAM_STATUS_PERRIF_Msk       (0x1ul << SYS_SRAM_STATUS_PERRIF_Pos)             /*!< SYS_T::SRAM_STATUS: PERRIF Mask           */

#define SYS_SRAM_ERRADDR_ERRADDR_Pos     (0)                                               /*!< SYS_T::SRAM_ERRADDR: ERRADDR Position     */
#define SYS_SRAM_ERRADDR_ERRADDR_Msk     (0xfffffffful << SYS_SRAM_ERRADDR_ERRADDR_Pos)    /*!< SYS_T::SRAM_ERRADDR: ERRADDR Mask         */

#define SYS_SRAM_BISTCTL_SRBIST0_Pos     (0)                                               /*!< SYS_T::SRAM_BISTCTL: SRBIST0 Position     */
#define SYS_SRAM_BISTCTL_SRBIST0_Msk     (0x1ul << SYS_SRAM_BISTCTL_SRBIST0_Pos)           /*!< SYS_T::SRAM_BISTCTL: SRBIST0 Mask         */

#define SYS_SRAM_BISTCTL_SRBIST1_Pos     (1)                                               /*!< SYS_T::SRAM_BISTCTL: SRBIST1 Position     */
#define SYS_SRAM_BISTCTL_SRBIST1_Msk     (0x1ul << SYS_SRAM_BISTCTL_SRBIST1_Pos)           /*!< SYS_T::SRAM_BISTCTL: SRBIST1 Mask         */

#define SYS_SRAM_BISTCTL_CRBIST_Pos      (2)                                               /*!< SYS_T::SRAM_BISTCTL: CRBIST Position      */
#define SYS_SRAM_BISTCTL_CRBIST_Msk      (0x1ul << SYS_SRAM_BISTCTL_CRBIST_Pos)            /*!< SYS_T::SRAM_BISTCTL: CRBIST Mask          */

#define SYS_SRAM_BISTCTL_CANBIST_Pos     (3)                                               /*!< SYS_T::SRAM_BISTCTL: CANBIST Position     */
#define SYS_SRAM_BISTCTL_CANBIST_Msk     (0x1ul << SYS_SRAM_BISTCTL_CANBIST_Pos)           /*!< SYS_T::SRAM_BISTCTL: CANBIST Mask         */

#define SYS_SRAM_BISTCTL_USBBIST_Pos     (4)                                               /*!< SYS_T::SRAM_BISTCTL: USBBIST Position     */
#define SYS_SRAM_BISTCTL_USBBIST_Msk     (0x1ul << SYS_SRAM_BISTCTL_USBBIST_Pos)           /*!< SYS_T::SRAM_BISTCTL: USBBIST Mask         */

#define SYS_SRAM_BISTSTS_SRBISTEF0_Pos   (0)                                               /*!< SYS_T::SRAM_BISTSTS: SRBISTEF0 Position   */
#define SYS_SRAM_BISTSTS_SRBISTEF0_Msk   (0x1ul << SYS_SRAM_BISTSTS_SRBISTEF0_Pos)         /*!< SYS_T::SRAM_BISTSTS: SRBISTEF0 Mask       */

#define SYS_SRAM_BISTSTS_SRBISTEF1_Pos   (1)                                               /*!< SYS_T::SRAM_BISTSTS: SRBISTEF1 Position   */
#define SYS_SRAM_BISTSTS_SRBISTEF1_Msk   (0x1ul << SYS_SRAM_BISTSTS_SRBISTEF1_Pos)         /*!< SYS_T::SRAM_BISTSTS: SRBISTEF1 Mask       */

#define SYS_SRAM_BISTSTS_CRBISTEF_Pos    (2)                                               /*!< SYS_T::SRAM_BISTSTS: CRBISTEF Position    */
#define SYS_SRAM_BISTSTS_CRBISTEF_Msk    (0x1ul << SYS_SRAM_BISTSTS_CRBISTEF_Pos)          /*!< SYS_T::SRAM_BISTSTS: CRBISTEF Mask        */

#define SYS_SRAM_BISTSTS_CANBEF_Pos      (3)                                               /*!< SYS_T::SRAM_BISTSTS: CANBEF Position      */
#define SYS_SRAM_BISTSTS_CANBEF_Msk      (0x1ul << SYS_SRAM_BISTSTS_CANBEF_Pos)            /*!< SYS_T::SRAM_BISTSTS: CANBEF Mask          */

#define SYS_SRAM_BISTSTS_USBBEF_Pos      (4)                                               /*!< SYS_T::SRAM_BISTSTS: USBBEF Position      */
#define SYS_SRAM_BISTSTS_USBBEF_Msk      (0x1ul << SYS_SRAM_BISTSTS_USBBEF_Pos)            /*!< SYS_T::SRAM_BISTSTS: USBBEF Mask          */

#define SYS_SRAM_BISTSTS_SRBEND0_Pos     (16)                                              /*!< SYS_T::SRAM_BISTSTS: SRBEND0 Position     */
#define SYS_SRAM_BISTSTS_SRBEND0_Msk     (0x1ul << SYS_SRAM_BISTSTS_SRBEND0_Pos)           /*!< SYS_T::SRAM_BISTSTS: SRBEND0 Mask         */

#define SYS_SRAM_BISTSTS_SRBEND1_Pos     (17)                                              /*!< SYS_T::SRAM_BISTSTS: SRBEND1 Position     */
#define SYS_SRAM_BISTSTS_SRBEND1_Msk     (0x1ul << SYS_SRAM_BISTSTS_SRBEND1_Pos)           /*!< SYS_T::SRAM_BISTSTS: SRBEND1 Mask         */

#define SYS_SRAM_BISTSTS_CRBEND_Pos      (18)                                              /*!< SYS_T::SRAM_BISTSTS: CRBEND Position      */
#define SYS_SRAM_BISTSTS_CRBEND_Msk      (0x1ul << SYS_SRAM_BISTSTS_CRBEND_Pos)            /*!< SYS_T::SRAM_BISTSTS: CRBEND Mask          */

#define SYS_SRAM_BISTSTS_CANBEND_Pos     (19)                                              /*!< SYS_T::SRAM_BISTSTS: CANBEND Position     */
#define SYS_SRAM_BISTSTS_CANBEND_Msk     (0x1ul << SYS_SRAM_BISTSTS_CANBEND_Pos)           /*!< SYS_T::SRAM_BISTSTS: CANBEND Mask         */

#define SYS_SRAM_BISTSTS_USBBEND_Pos     (20)                                              /*!< SYS_T::SRAM_BISTSTS: USBBEND Position     */
#define SYS_SRAM_BISTSTS_USBBEND_Msk     (0x1ul << SYS_SRAM_BISTSTS_USBBEND_Pos)           /*!< SYS_T::SRAM_BISTSTS: USBBEND Mask         */

#define SYS_IRCTCTL_FREQSEL_Pos          (0)                                               /*!< SYS_T::IRCTCTL: FREQSEL Position          */
#define SYS_IRCTCTL_FREQSEL_Msk          (0x3ul << SYS_IRCTCTL_FREQSEL_Pos)                /*!< SYS_T::IRCTCTL: FREQSEL Mask              */

#define SYS_IRCTCTL_LOOPSEL_Pos          (4)                                               /*!< SYS_T::IRCTCTL: LOOPSEL Position          */
#define SYS_IRCTCTL_LOOPSEL_Msk          (0x3ul << SYS_IRCTCTL_LOOPSEL_Pos)                /*!< SYS_T::IRCTCTL: LOOPSEL Mask              */

#define SYS_IRCTCTL_RETRYCNT_Pos         (6)                                               /*!< SYS_T::IRCTCTL: RETRYCNT Position         */
#define SYS_IRCTCTL_RETRYCNT_Msk         (0x3ul << SYS_IRCTCTL_RETRYCNT_Pos)               /*!< SYS_T::IRCTCTL: RETRYCNT Mask             */

#define SYS_IRCTCTL_CESTOPEN_Pos         (8)                                               /*!< SYS_T::IRCTCTL: CESTOPEN Position         */
#define SYS_IRCTCTL_CESTOPEN_Msk         (0x1ul << SYS_IRCTCTL_CESTOPEN_Pos)               /*!< SYS_T::IRCTCTL: CESTOPEN Mask             */

#define SYS_IRCTIEN_TFAILIEN_Pos         (1)                                               /*!< SYS_T::IRCTIEN: TFAILIEN Position         */
#define SYS_IRCTIEN_TFAILIEN_Msk         (0x1ul << SYS_IRCTIEN_TFAILIEN_Pos)               /*!< SYS_T::IRCTIEN: TFAILIEN Mask             */

#define SYS_IRCTIEN_CLKEIEN_Pos          (2)                                               /*!< SYS_T::IRCTIEN: CLKEIEN Position          */
#define SYS_IRCTIEN_CLKEIEN_Msk          (0x1ul << SYS_IRCTIEN_CLKEIEN_Pos)                /*!< SYS_T::IRCTIEN: CLKEIEN Mask              */

#define SYS_IRCTISTS_FREQLOCK_Pos        (0)                                               /*!< SYS_T::IRCTISTS: FREQLOCK Position        */
#define SYS_IRCTISTS_FREQLOCK_Msk        (0x1ul << SYS_IRCTISTS_FREQLOCK_Pos)              /*!< SYS_T::IRCTISTS: FREQLOCK Mask            */

#define SYS_IRCTISTS_TFAILIF_Pos         (1)                                               /*!< SYS_T::IRCTISTS: TFAILIF Position         */
#define SYS_IRCTISTS_TFAILIF_Msk         (0x1ul << SYS_IRCTISTS_TFAILIF_Pos)               /*!< SYS_T::IRCTISTS: TFAILIF Mask             */

#define SYS_IRCTISTS_CLKERRIF_Pos        (2)                                               /*!< SYS_T::IRCTISTS: CLKERRIF Position        */
#define SYS_IRCTISTS_CLKERRIF_Msk        (0x1ul << SYS_IRCTISTS_CLKERRIF_Pos)              /*!< SYS_T::IRCTISTS: CLKERRIF Mask            */

#define SYS_REGLCTL_REGLCTL_Pos          (0)                                               /*!< SYS_T::REGLCTL: REGLCTL Position          */
#define SYS_REGLCTL_REGLCTL_Msk          (0xfful << SYS_REGLCTL_REGLCTL_Pos)               /*!< SYS_T::REGLCTL: REGLCTL Mask              */

/**@}*/ /* SYS_CONST */


typedef struct
{

/**
 * @var SYS_INT_T::NMIEN
 * Offset: 0x00  NMI Source Interrupt Enable Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |BODOUT    |BOD NMI Source Enable (Write Protect)
 * |        |          |0 = BOD NMI source Disabled.
 * |        |          |1 = BOD NMI source Enabled.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.    
 * |[1]     |IRC_INT   |IRC TRIM NMI Source Enable (Write Protect)
 * |        |          |0 = IRC TRIM NMI source Disabled.
 * |        |          |1 = IRC TRIM NMI source Enabled.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.   
 * |[2]     |PWRWU_INT |Power-Down Mode Wake-Up NMI Source Enable (Write Protect)
 * |        |          |0 = Power-down mode wake-up NMI source Disabled.
 * |        |          |1 = Power-down mode wake-up NMI source Enabled.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.    
 * |[3]     |SRAM_PERR   |SRAM ParityCheck Error NMI Source Enable (Write Protect)
 * |        |          |0 = SRAM parity check error NMI source Disabled.
 * |        |          |1 = SRAM parity check error NMI source Enabled.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.    
 * |[4]     |CLKFAIL   |Clock Fail Detected NMI Source Enable (Write Protect)
 * |        |          |0 = Clock fail detected interrupt NMI source Disabled.
 * |        |          |1 = Clock fail detected interrupt NMI source Enabled.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.    
 * |[6]     |RTC_INT   |RTC NMI Source Enable (Write Protect)
 * |        |          |0 = RTC NMI source Disabled.
 * |        |          |1 = RTC NMI source Enabled.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.    
 * |[7]     |TAMPER_INT|TAMPER_INT NMI Source Enable (Write Protect)
 * |        |          |0 = Backup register tamper detected interrupt.NMI source Disabled.
 * |        |          |1 = Backup register tamper detected interrupt.NMI source Enabled.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.     
 * |[8]     |EINT0     |External Interrupt From PA.0, PD.2 Or PE.4 Pin NMI Source Enable (Write Protect)
 * |        |          |0 = External interrupt from PA.0, PD.2 or PE.4 pin NMI source Disabled.
 * |        |          |1 = External interrupt from PA.0, PD.2 or PE.4 pin NMI source Enabled.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.        
 * |[9]     |EINT1     |External Interrupt From PB.0, PD.3 Or PE.5 Pin NMI Source Enable (Write Protect)
 * |        |          |0 = External interrupt from PB.0, PD.3 or PE.5 pin NMI source Disabled.
 * |        |          |1 = External interrupt from PB.0, PD.3 or PE.5 pin NMI source Enabled.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.
 * |[10]    |EINT2     |External Interrupt From PC.0 Pin NMI Source Enable (Write Protect)
 * |        |          |0 = External interrupt from PC.0 pin NMI source Disabled.
 * |        |          |1 = External interrupt from PC.0 pin NMI source Enabled.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.       
 * |[11]    |EINT3     |External Interrupt From PD.0 Pin NMI Source Enable (Write Protect)
 * |        |          |0 = External interrupt from PD.0 pin NMI source Disabled.
 * |        |          |1 = External interrupt from PD.0 pin NMI source Enabled.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.     
 * |[12]    |EINT4     |External Interrupt From PE.0 Pin NMI Source Enable (Write Protect)
 * |        |          |0 = External interrupt from PE.0 pin NMI source Disabled.
 * |        |          |1 = External interrupt from PE.0 pin NMI source Enabled.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.      
 * |[13]    |EINT5     |External Interrupt From PF.0 Pin NMI Source Enable (Write Protect)
 * |        |          |0 = External interrupt from PF.0 pin NMI source Disabled.
 * |        |          |1 = External interrupt from PF.0 pin NMI source Enabled.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.     
 * |[14]    |UART0_INT |UART0 NMI Source Enable (Write Protect)
 * |        |          |0 = UART0 NMI source Disabled.
 * |        |          |1 = UART0 NMI source Enabled.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.    
 * |[15]    |UART1_INT |UART1 NMI Source Enable (Write Protect)
 * |        |          |0 = UART1 NMI source Disabled.
 * |        |          |1 = UART1 NMI source Enabled.
 * |        |          |Note: This bit is write protected. Refer to the SYS_REGLCTL register.
 * @var SYS_INT_T::NMISTS
 * Offset: 0x04  NMI source interrupt Status Register
 * ---------------------------------------------------------------------------------------------------
 * |Bits    |Field     |Descriptions
 * | :----: | :----:   | :---- |
 * |[0]     |BODOUT    |BOD Interrupt Flag (Read Only)
 * |        |          |0 = BOD interrupt is deasserted.
 * |        |          |1 = BOD interrupt is asserted. 
 * |[1]     |IRC_INT   |IRC TRIM Interrupt Flag (Read Only)
 * |        |          |0 = HIRC TRIM interrupt is deasserted.
 * |        |          |1 = HIRC TRIM interrupt is asserted. 
 * |[2]     |PWRWU_INT |Power-Down Mode Wake-Up Interrupt Flag (Read Only)
 * |        |          |0 = Power-down mode wake-up interrupt is deasserted.
 * |        |          |1 = Power-down mode wake-up interrupt is asserted. 
 * |[3]     |SRAM_PERR |SRAM ParityCheck Error Interrupt Flag (Read Only)
 * |        |          |0 = SRAM parity check error interrupt is deasserted.
 * |        |          |1 = SRAM parity check error interrupt is asserted. 
 * |[4]     |CLKFAIL   |Clock Fail Detected Interrupt Flag (Read Only)
 * |        |          |0 = Clock fail detected interrupt is deasserted.
 * |        |          |1 = Clock fail detected interrupt is asserted.
 * |[6]     |RTC_INT   |RTC Interrupt Flag (Read Only)
 * |        |          |0 = RTC interrupt is deasserted.
 * |        |          |1 = RTC interrupt is asserted.
 * |[7]     |TAMPER_INT|TAMPER_INT Interrupt Flag (Read Only)
 * |        |          |0 = Backup register tamper detected interrupt is deasserted.
 * |        |          |1 = Backup register tamper detected interrupt is asserted.
 * |[8]     |EINT0     |External Interrupt From PA.0, PD.2 Or PE.4 Pin Interrupt Flag (Read Only)
 * |        |          |0 = External Interrupt from PA.0, PD.2 or PE.4 interrupt is deasserted.
 * |        |          |1 = External Interrupt from PA.0, PD.2 or PE.4 interrupt is asserted. 
 * |[9]     |EINT1     |External Interrupt From PB.0, PD.3 Or PE.5 Pin Interrupt Flag (Read Only)
 * |        |          |0 = External Interrupt from PB.0, PD.3 or PE.5 interrupt is deasserted.
 * |        |          |1 = External Interrupt from PB.0, PD.3 or PE.5 interrupt is asserted. 
 * |[10]    |EINT2     |External Interrupt From PC.0 Pin Interrupt Flag (Read Only)
 * |        |          |0 = External Interrupt from PC.0 interrupt is deasserted.
 * |        |          |1 = External Interrupt from PC.0 interrupt is asserted. 
 * |[11]    |EINT3     |External Interrupt From PD.0 Pin Interrupt Flag (Read Only)
 * |        |          |0 = External Interrupt from PD.0 interrupt is deasserted.
 * |        |          |1 = External Interrupt from PD.0 interrupt is asserted. 
 * |[12]    |EINT4     |External Interrupt From PE.0 Pin Interrupt Flag (Read Only)
 * |        |          |0 = External Interrupt from PE.0 interrupt is deasserted.
 * |        |          |1 = External Interrupt from PE.0 interrupt is asserted. 
 * |[13]    |EINT5     |External Interrupt From PF.0 Pin Interrupt Flag (Read Only)
 * |        |          |0 = External Interrupt from PF.0 interrupt is deasserted.
 * |        |          |1 = External Interrupt from PF.0 interrupt is asserted. 
 * |[14]    |UART0_INT |UART0 Interrupt Flag (Read Only)
 * |        |    