/**
@file main.h
@brief Header file containing functions prototypes, defines and global variables.
@brief Most of the things in this file consist of function for game part and the others are for a few interface.
@brief Final Project 2.0.
@author H. Zafran M. Kamaludin
@date   April 2016
*/

#ifndef MAIN_H
#define MAIN_H

#define PI 3.14159265359
#define PAUSE 1
#define PLAY 0

#include "mbed.h"
#include "N5110.h"
#include "tone.h"

/**
@namespace lcd
@brief connection for Nokia LCD
*/
N5110 lcd(PTE26,PTA0,PTC4,PTD0,PTD2,PTD1,PTC3);

/**
@namespace button
@brief input from joystick button
*/
InterruptIn button(PTB11);

/**
@namespace yPot
@brief get input from joystick movement (x-direction) 
*/
AnalogIn yPot(PTB2);

/**
@namespace xPot
@brief get input from joystick movement (y-direction)
*/
AnalogIn xPot(PTB3);

/**
@namespace buzzer
@brief produce sound for the game
*/
DigitalOut buzzer(PTA2);

/**
@namespace green_LED
@brief use as graphic LED during gameplay.
*/
DigitalOut green(PTC2);


/**
@namespace serial
@brief Serial for debugging purpose
*/
Serial serial(USBTX,USBRX);

/**
@namespace noteTimer
@brief Create timer for music to be played.
*/
Timer noteTimer;

/**
@namespace sleepTimer
@brief Create timer for music to be played.
*/
Timer sleepTimer;


int printFlag;                      /*!< print flag set in ISR */
int pointer_x=20;                   /*!<initiate the pointer on main menu (x-axis)*/
int pointer_y=38;                   /*!<initiate the pointer on main menu (y-axis)*/
int loop=0;                         /*!<to be use by the while loop at every interface view*/
int output=0;                       /*!<output initialize at zero*/
int state=0;                        /*!<state initialize at zero*/
float brightness_adjuster=0.0;      /*!<set the initial brightness at 0.5*/
volatile int g_button_flag=0;       /*!<use for button interrupt purpose*/
int g_crash=0;                      /*!<init crash at 0 (crash not occur)*/
int g_liveleft=3;                   /*!<give start life in total of three*/
float duration=0;                   /*!<use to control the gameplay speed */
int playerSpeed=0;                  /*!<use to control the player car speed*/
int g_level=1;                      /*!<init the level at 1*/
int g_score=0;                      /*!<init the score at 0*/
int carValue[10000];                /*!<provide array of 10000 for traffic car */
int car_x=22;                       /*!<initiate car position_x*/
int car_y=38;                       /*!<initiate car position_y*/
int delay=0;                        /*!<use to provide delay for next upcoming car that enter the screen*/
int lastCar=0;                      /*!<use to check whereis the last trafic car will enter the screen to stop the level*/
int game = PLAY;                    /*!<use for pause the game*/
int n = 32;                         /*!< number of samples*/
float y[32];                        /*!< array to store samples*/
float BPM = 73.0;                   /*!< beats per minute*/

    /** Introduction Page
    *
    *   Function to display introduction page when power is turn on.
    *   
    */
    void intro();
    
    /** FirstView
    *
    *   Function to provide main menu screen of the game.
    *   
    */
    void firstView();
    
    /** FirstViewPointer
    *
    *   Function to control the pointer in main menu screen.
    *   
    */
    void firstViewPointer();
    
    /** Sleep View
    *
    *   Function to generate sleep mode to save energy & power.
    *   Also include lcd off to switch of the lcd.
    *   Improve power effciency for the game system
    *   Expand the battery lifetime.
    *   
    */
    void SleepView();
    
    /** GameView
    *
    *   The main part of the game coding is in here.
    *   Contain all the complex part for the game.
    *   Use array to store the traffic's car before displaying them into the screen.
    *
    */
    void gameView();
    
   /** Initialise game display 
    *
    *   Initialise display with game interface when the user enter the game.
    *   Show the background display of the game screen. 
    *   Also contain countdown timer before the game start. 
    *
    */
    void initialGameInterface();
    
    /** draw Road Vehicle 
    *
    *   Choose randomly which vehicle will be drawn on the screen. 
    *   @param carValue[] - where to draw the car in the screen.
    *
    */
    void drawVehicleType(int carValue[]);
    
    /** Crash
    *
    *   Check if there are crash occur between the player and the traffic car.
    *   Store the pixel of player's car and pixel of trafic's car and check if they overlap each other.
    *   @param carValue[] - consist array of value for position of traffic's car (which column).
    *   @param opponent_y - the position of array's car (which row). 
    *   @param g_score - display the score value of the game.
    *   @param g_level - display current level of the gameplay.
    *   @param k - read the position of player's car (x-direction).
    *   @param l - read the position of player's car (y-direction).
    *   @param delay - create delay for the next car to enter the screen at different time.
    */
    void crash(int carValue[],int opponent_y,int g_score,int g_level,int k,int l,int delay);
    
   /** Game Interface
    *
    *   Display the text use during gameplay. (eg. Score, Level).
    *   @param g_score - display the score value of the game.
    *   @param g_level - display current level of the gameplay.
    *   @param g_liveleft - display how many life left in the gameplay.
    *   
    */
    void game_interface(int g_score,int g_level,int g_liveleft);
    
    /** LifeLeft
    *
    *   Function to draw how many life left in game.
    *   @param g_liveleft - display how many life left in the gameplay.
    *   
    */
    void live(int liveleft);
    
    /** Road Display
    *
    *   Display the text use during gameplay. (eg. Score, Level)
    *   Function to display the road line in the game.
    *   @param moving - use to make the road look as it is moving.
    *   
    */
    void roadline(int moving);
    
    /** Player Movement
    *
    *   Function to control the movement of the player's car.
    *   @param g_level - provide different speed for the player's car at different level.
    *   
    */
    void playermovement(int g_level);
    
    /** Last Traffic Car 
    *
    *   Function to check where is the last car to stop the loop at different level.
    *   @param g_level - check where is the last car at certain level to stop the level loop and proceed to next level.
    *   
    */
    void checkLastCar(int g_level);
    
    /** Level Finish
    *
    *   Function to display a message when a level is completed.
    *   @param g_level - Write a text where a certain level is completed.
    *   
    */
    void finishLevel(int g_level);
    
    /** Option
    *
    *   Function to display the option menu at the beginning.
    *   
    */
    void optionView();
    
    /** Pointer Controller 
    *
    *   Function to control pointer in option menu.
    *   
    */
    void optionPointer();
    
    /** Finish View
    *
    *   Function to display the end screen when the game is finally over.
    *   @param g_score - display the final score at the end of the game. 
    *   
    */
    void finishView(int g_score);
    
    /** Brightness Controller
    *
    *   function to control the lcd brightness.
    *   
    */
    void brightnessController();
    
    /** Brightness View
    *
    *   function to display the brightnees controller screen.
    *   
    */
    void brightnessView();
    
    /** Intruction Page
    *
    *   function to provide game manual for the player.
    *   
    */
    void instructionView();
    
    /** Button Interrupt
    *
    *   Use for interrupt.
    *   It will change the flag to one.
    *   
    */
    void button_isr();
    
    /** Gameplay Music
    *
    *   function to play sound during gameplay.
    *   @param duration - play the note at duration equal to speed of the car.
    *   
    */
    void gameplaysound(float duration);
    
    /** Crash Music
    *
    *   function to provide sound when crash occur.
    *   
    */
    void crashsound();
    
    /** Pause Music
    *
    *   function to provide sound when the gmae is paused.
    *   
    */
    void pausesound();
    
    /** Finish Music
    *
    *   function to provide sound when the game finished.
    *   
    */
    void finishsound();
    
    /** Score Text
    *
    *   function to display score text in screen.
    *   @param m - locate the x-coordinate of the text
    *   @param my - locate the y-coordinate of the text
    *   
    */
    void score(int m,int my);
    
    /** Level Text
    *
    *   function to display level text in screen.
    *   @param x1 - locate the x-coordinate of the text
    *   @param y1 - locate the y-coordinate of the text
    *   
    */
    void level(int x1,int y1);
    
    /** Initiate Game Variable
    *
    *   function to initialize back all game variable used for new game.
    *   
    */
    void initGameVar();
    
    /** Initiate Music Array
    *
    *   function to initialise sample array for music (sound) purpose.
    *   
    */
    void initArray();  
    
    /** Tone
    *
    *   function to play a tone of set frequency for given duration
    *   @param frequency - frequency that the tone is being played.
    *   @param duration - time duration for a note to be played
    *
    */
    void tone(float frequency,float duration);  
    
#endif