/**
Project A--Ultrasonic range Finder
Reverse parking meter 
@file main.cpp
@brief headfile contain the functions prototypys,defines and global variable
@author ZHAO YI HUI 
@date April 2015
*/

#include "mbed.h"
#include "N5110.h"
#include "SRF02.h"
#include "beep.h"
/**
@namespace leds
@brief GPIO led for the red led
@namespace lcd
@brief initilize the lcd display
@namespace button
@brief use the ISR for the button
@namespace serial
@brief serial connect to the computer to set RTC
@namespace buzzer
@breif set the buzzer 
*/

BusOut leds(LED4,LED3,LED2,LED1);//initalize the leds on mbed 
N5110 lcd(p7,p8,p9,p10,p11,p13,p26);//initalize the Nokia N5110 lcd
SRF02 srf02(p28,p27);// initalize the sensor 
Serial serial(USBTX,USBRX);// use the use connection to computer
InterruptIn button(p15);
InterruptIn button2(p17);
Beep buzzer(p21);
DigitalOut led(p24);


void serialISR();//ISR that is called when serial data is received
void setTime();// fucnction to set the UNIX time
int setTimerFlag = 0;// flag for ISR
char rxString[16];//buffer to store received string
// set a flag for the first buttion S2
int buttonFlag = 0;/*print buttonFlag in ISR*/


#define light 1 // define light is 1 
#define dark 0 //define dark is 0

#define centimeter 1//define the cm is 1 
#define inches 0// define inch is 0

int brightness = light; // init the brightness to 1 
int state = centimeter; // inie the state to 1

/** 
@Interrupt Service Routine
*/
void buttonPressed()
{   
    buttonFlag = 1; // set S3 flag  
}
/**
@Interrupt Service Routine
*/
void buttonPressed2()
{  
    state = !state; // change  the state when press the button 
    
}
/**
read ten times results from the sensor in 1 second
calculate the average 
*/
float getAverage()// calculate the average distance
{
    int sum = 0; // sum = 0

    float average; // the type of average is float

    for(int i=0; i<10; i++) {// loop for get 10 distances in 1 sec
        sum += srf02.getDistanceCm();// read the value from the sensor and sum up
        
        wait_ms(100);// wait 100ms 
        
    }

    // serial - print sum

    average = sum/10.0;// the average is the sum divided by 10
    // serial - print average
    return average;

}
/**
RTC is used 
The button S2 is used to change the unit
The button S3 is used to change the brightness
Display the result and time on the LCD
*/
int main()
{
    buzzer.beep(1000,1.0);// a sound for start
    lcd.init();//first need to initialise display
    lcd.printString("Ultrasonic",1,1);
    lcd.printString("Ranger",5,3);
    lcd.printString("Finder",7,5);
    wait(1.5);//wait 1.5 to start to detect the distance
    lcd.clear();// clear the screen and buffer 
    
    //RTC
    serial.attach(&serialISR);// attach serial string
    char t[30];// buffer used to store time string
    button.rise(&buttonPressed);//event generated on rising edge
    button2.rise(&buttonPressed2);// event generated on rising edge
     // set the buzzer make noise at 1000HZ in 1 seconds when turn on the device
    led = 0; //set the red led is off when turn on the deivce
    

    while(1)
     {
        lcd.printString("Distance is :",0,0);// display the sentence on the first line
        // RTC 
        time_t seconds = time(NULL);//get current time
        
        strftime(t, 30 , "%X %D",localtime(&seconds));//format time into a string(time and data)
        
        serial.printf("Time = %s\n" ,t);//print over serial for texting
        lcd.printString(t,0,4);// dispaly the data on the screen
        /*
        float average =getAverage();// get the data from the getAverage function
        char A[14];// buffer of the average 
        length = sprintf(A,"D = %.2f cm",average);
        lcd.printString(A,0,2);// display the date on the screen 
        */
        
        if(setTimerFlag)// if updated time has been sent
        {
            setTimerFlag = 0; // clear flag
            setTime();//update
            
        }
    
        
        // display the distance on the screen

        int distance  = srf02.getDistanceCm();// the distance is a integer and get the data from the getDistanceCm function
        char buffer[14];//create a buffer to store 14 characters
        int length = sprintf(buffer,"D = %d cm",distance);  // scan this buffer and  D = %d cm and calculate the length
        /*
        if(length <= 14)// if statement  set the lenght should less than 14
            lcd.printString(buffer,0,1);  // display the answer on the LCD screen
        */
        char buffer2[14];
        float inch = distance/30.48 ;   // change the distance from to inches
        length = sprintf(buffer2,"D = %.2f ft",inch); // scan the length again
        /*
        if(length <= 14)//if statement  set the lenght should less than 14
            lcd.printString(buffer,0,3);// display the answer on the LCD screen
        */

        wait(1.0);// wait 1 second to do next measurement
        lcd.clear(); // clear the buffer and refesh the lcd to avoide repeat pixel
        if(distance<15)// the srf02 can not measure the distance low than 15
        {
            lcd.printString("ERROR!!!",0,1);// print ERROR on the screen 
            lcd.printString("MINUMUM",0,3);// show the MINUMUN 
            //as well
        }
        if(distance<30 && distance >15)
        { // if the distance less than the 30, the buzzer and red led on work
            //buzzer
            buzzer.beep(4000,0.7);// buzzer make noise at 3000hz in 0.5second
            led = 1;//red led on
        } 
        else if
        (distance > 30 && distance <60)
        { //if the distance between the 30 and 60 cm.

            buzzer.beep(1000,0.5);// the buzzer make  noise at 1000hz in 0.2 second
            led = 0;

        } 
        else if(distance > 60 && distance< 100)
        { // if the distance between 60 and 100 cm
            buzzer.beep(400,0.2);// the buzzer make noise at 500 hz in 0.1 second
            led = 0 ;

        }
      
        // set the buttons     
         
        switch(state)
        {
            case centimeter: // in centimeter cas 
                state = 1;// let the state to 1
                if(length <= 14)// if statement  set the lenght should less than 14
                lcd.printString(buffer,0,2);  // display the answer on the LCD screen           
                break;//out of the funcion
            case inches:// in inches case
                state = 0;// set the state = 0
                if(length <= 14)//if statement  set the lenght should less than 14
                lcd.printString(buffer2,0,2);// display the answer on the LCD screen
                break;//out the funcion
            default:
                break;
        
        }
        if(buttonFlag)
        {       
                buttonFlag =0;// set buttonFlag = 0
                lcd.setBrightness(brightness);//set the brightness 
                switch(brightness)// check the state what the brightness 
                {
                    case light:// if the brightness is 1
                        brightness = 0;// set brightness to 0
                        break;// go out of the loop 
                    case dark:// if the brightness is 0
                        brightness = 1;// set to brightness to 1
                        break;
                    default:
                        break;
                }
        }
        
     }

    

}
/**
converts a string to an integer 
and set the current time
*/
void setTime()
{
    // pring something for debugging
    serial.printf("set_time - %s",rxString);
    //atoi()converts a string to an integer
    int time = atoi(rxString);
    //update the time
    set_time(time);
}
/**
@when the serial interrupt occures, read rx string into buffer
*/
void serialISR()
{   
    //when a serial interrupt occurs, read rx string into buffer
    serial.gets(rxString,16);
    //set flag
    setTimerFlag = 1;
}