/* FluentLogger - fluent-logger-mbed sample
 * Copyright (c) 2014 Yuuichi Akagawa
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "EthernetInterface.h"
#include "FluentLogger.h"

EthernetInterface eth;
FluentLogger logger("192.168.0.1");  // please set your Fluentd server
Serial pc(USBTX, USBRX);

int main() 
{
    uMP mp(64); //Message body
    eth.init(); //Use DHCP
    eth.connect();
    while(1) {
       uint32_t t1 = us_ticker_read();
       logger.log("debug.test", "Hello GR-PEACH"); //message body is simple string
       uint32_t t2 = us_ticker_read();
        wait_ms(5000);
//       Thread::wait(5000);
       uint32_t t3 = us_ticker_read();
       pc.printf("t1:%u t2:%u t3:%u t2-t1:%u t3-t2:%u\r\n", t1, t2, t3, (t2-t1), (t3-t2));
    }
    logger.close();
    eth.disconnect();  
}
