#include "mbed.h"
#include "USBHostGamepad.h"

Serial pc(USBTX, USBRX);
DigitalOut led(LED1);

void onEvent(uint8_t btnX, uint8_t btnY, uint8_t btnABCD, uint8_t btnSpecial) {
    
    pc.printf(" D-Pad : X:%02X Y:%02X\r\n", btnX, btnY);
    pc.printf(" Button: %c%c%c%c %s %s %s\r\n", ((btnABCD & 0x10)? 'A':'-'),
                                       ((btnABCD & 0x20)? 'B':'-'),
                                       ((btnABCD & 0x40)? 'C':'-'),
                                       ((btnABCD & 0x80)? 'D':'-'),
                                       ((btnSpecial & 0x8)? "-----":"TURBO"),
                                       ((btnSpecial & 0x2)? "Select":"------"),
                                       ((btnSpecial & 0x1)? "Start" :"-----"));
}
 
void gamepad_task(void const *) {
 
    USBHostGamepad gamepad;
 
    while(1) {
        // try to connect a USB gamepad
        while(!gamepad.connect())
            Thread::wait(500);
 
        // when connected, attach handler called on gamepad event
        gamepad.attachEvent(onEvent);
 
        // wait until the gamepad is disconnected
        while(gamepad.connected())
            Thread::wait(500);
    }
}
 
int main() {
    Thread gamepadTask(gamepad_task, NULL, osPriorityNormal, 256 * 4);
    while(1) {
        led=!led;
        Thread::wait(500);
    }
}
