/* SNIC-FluentLogger-example - fluent-logger-mbed sample
 *  Copyright (C) 2014 Yuuichi Akagawa
 *  muRata, SWITCH SCIENCE Wi-FI module TypeYD SNIC-UART.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "mbed.h"
#include "SNIC_WifiInterface.h"
#include "FluentLogger.h"

/* Please set your WiFi settings */
#define DEMO_AP_SSID                  "AP_SSID"
#define DEMO_AP_SECURITY_TYPE         e_SEC_WPA2_AES
#define DEMO_AP_SECUTIRY_KEY          "WPA2_PASSPHRASE"
#define DEMO_AP_SECUTIRY_KEY_LEN      15

/** Wi-Fi SNIC UART Interface*/
#if defined(TARGET_LPC1768)
C_SNIC_WifiInterface     mSNICwifi( p9, p10, NC, NC, p30 );
#elif defined(TARGET_KL46Z)
C_SNIC_WifiInterface     mSNICwifi( D1, D0, NC, NC, D3 );
#elif defined(TARGET_RZ_A1H)
C_SNIC_WifiInterface     mSNICwifi( P7_4, P7_5, NC, NC, P7_2 );
#else
#error Your platform is not supported.
#endif

/* fluentd server */
FluentLogger logger("192.168.0.1");

Serial pc(USBTX, USBRX);    /* for DEBUG_PRINT */

int main()
{
    uMP mp(64); //Message body

#ifdef _DEBUG
    pc.baud( 9600 );
#endif
    // Initialize Wi-Fi interface
    int ret = mSNICwifi.init();
    if( ret != 0 ) {
        DEBUG_PRINT( "Could not initialize. Will halt! rc=%d\n\r", ret );
        return -1;
    } else {
        DEBUG_PRINT( "Initialized.\n\r");
    }

    wait(0.5);

    ret = mSNICwifi.disconnect();
    if( ret != 0 ) {
        DEBUG_PRINT( "Disconnect failed rc=%d\r\n", ret);
        return -1;
    } else {
        DEBUG_PRINT( "Disconnected.\n\r");
    }
    
    wait(0.3);

    // Connect AP
    ret = mSNICwifi.connect( DEMO_AP_SSID
                        , strlen(DEMO_AP_SSID)
                        , DEMO_AP_SECURITY_TYPE
                        , DEMO_AP_SECUTIRY_KEY
                        , DEMO_AP_SECUTIRY_KEY_LEN );
    if( ret != 0 ) {
        DEBUG_PRINT( "Connect failed rc=%d\r\n", ret);
        return -1;
    } else {
        DEBUG_PRINT( "Connected.\n\r");
    }

    //DHCP
    mSNICwifi.setIPConfig( true );

    wait(0.5);

    while(1) {
        //send to fluentd
        logger.log("debug.mbed", "Hello Type YD"); //message body is simple string
        wait_ms(3000);
    }
}
