/**************************************************************************//**
* @file          DisplayAppEsp32.h
* @brief         DisplayApp API
******************************************************************************/

#ifndef DISPLAY_APP_ESP32_H
#define DISPLAY_APP_ESP32_H

#include "mbed.h"

/** A class to communicate a DisplayAppEsp32
 *
 */
class DisplayAppEsp32 {
public:
    /** Constructor: Initializes DisplayAppEsp32.
     *
     * @param   tsk_pri        Priority of the thread function. (default: osPriorityNormal).
     * @param   init_pri       Priority of before the USB is connected. (default: osPriorityLow).
     * @param   stack_size     stack size (in bytes) requirements for the thread function. (default: DEFAULT_STACK_SIZE).
     */
    DisplayAppEsp32(osPriority tsk_pri = osPriorityNormal, uint32_t stack_size = DEFAULT_STACK_SIZE);
 
    /** Send JPEG data
     *
     * @param buf data buffer address
     * @param size data size
     * @return send data size
     */
    int SendJpeg(uint8_t * buf, uint32_t size);

private:
    const static size_t BufferSize = 15360;

    bool bufmgr[2];
    uint8_t bufside;
    uint8_t sendbuf[2][BufferSize];

    typedef struct {
        size_t size;
        uint8_t side;
    } esp32Msg_t;

    RawSerial esp32;
    DigitalOut *esp32_en;
    DigitalOut *esp32_io0;
    MemoryPool<esp32Msg_t, 2> esp32Pool;
    Queue<esp32Msg_t, 2> esp32Q;
    Thread esp32Thread;

    void display_app_process();
    void SendHeader(uint32_t size);
    void SendData(uint8_t * buf, uint32_t size);
};
#endif
