#include "DisplayAppEsp32.h"

void DisplayAppEsp32::display_app_process() {
    while(1){
        osEvent evt = esp32Q.get();
        if (evt.status == osEventMessage) {
            esp32Msg_t *m = (esp32Msg_t*)evt.value.p;
            SendHeader(m->size);
            SendData(sendbuf[m->side], m->size);
            esp32Pool.free(m);
            bufmgr[m->side] = false;
        }
    }
}

DisplayAppEsp32::DisplayAppEsp32(osPriority tsk_pri, uint32_t stack_size) : 
  esp32(P3_15, P0_2), esp32Thread(tsk_pri, stack_size) {
    esp32_en = new DigitalOut(P5_3);
    esp32_io0 = new DigitalOut(P3_14);

    bufside = 0;
    bufmgr[0]= false;
    bufmgr[1]= false;

    esp32.set_flow_control(SerialBase::Disabled);
    *esp32_io0 = 1;
    *esp32_en = 0;
    Thread::wait(100);
    *esp32_en = 1;
    Thread::wait(2000);
    esp32.baud(1000000);
    esp32Thread.start(callback(this, &DisplayAppEsp32::display_app_process));
}

void DisplayAppEsp32::SendHeader(uint32_t size) {
    uint8_t headder_data[12] = {0xFF,0xFF,0xAA,0x55,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
 
    headder_data[8]  = (uint8_t)((uint32_t)size >> 0);
    headder_data[9]  = (uint8_t)((uint32_t)size >> 8);
    headder_data[10] = (uint8_t)((uint32_t)size >> 16);
    headder_data[11] = (uint8_t)((uint32_t)size >> 24);
    for (size_t i = 0; i < sizeof(headder_data); i++)
    {
        esp32.putc(headder_data[i]);
    }
}
 
void DisplayAppEsp32::SendData(uint8_t * buf, uint32_t size) {
    while (size > 0)
    {
        esp32.putc(*buf++);
        size--;
    }
}
int DisplayAppEsp32::SendJpeg(uint8_t *buf, uint32_t size) {
    if( bufmgr[bufside] == true || size > BufferSize)
    {
        //size over or buffer full.
        return 0;
    }
    memcpy(sendbuf[bufside], buf, size);
    bufmgr[bufside] = true;

    esp32Msg_t *m = esp32Pool.alloc();
    if( m == NULL ){
        //mpool alloc failed.
        return 0;
    }
    m->size = size;
    m->side = bufside;
    esp32Q.put(m);

    bufside ^= 1;//flip
    return size;
}
