#ifndef CAN_NETWORK_MOTORDRIVER_DEFINITION_H
#define CAN_NETWORK_MOTORDRIVER_DEFINITION_H

/**CAN ID定義**/
enum MCU_CAN_ID{
    ALL_MCU = 0,
    MAIN_MCU,
    MD_0_MCU = 10,
    MD_1_MCU,
    MD_2_MCU,  
    MD_3_MCU,
    MD_4_MCU,
    MD_5_MCU,
    MD_6_MCU,
    MD_7_MCU,
    MD_8_MCU,
    MD_9_MCU,
    MD_10_MCU,
    MD_11_MCU,
    MD_12_MCU,
    MD_13_MCU,
    MD_14_MCU,
    MD_15_MCU,
    MCU_CAN_ID_NUMBER,
};

/**→MD_MCU DataFlame**/
namespace md_can_flame{
    /**byte[0]**/
    enum command_number{
        SEND_KP,
        SEND_KI,
        SEND_KD,
        SEND_ACCELERATION,
        SEND_CONTROL_DUTY,
        SEND_CONTROL_RPM,
        REQUEST_RECEIVE_CURRENT,
        REQUEST_RECEIVE_ERROR,
        REQUEST_RECEIVE_POSITION,
        REQUEST_RECEIVE_ROTATION,
        REQUEST_RECEIVE_RPS,
        REQUEST_RECEIVE_RPM,
        REQUEST_PRINTF_DEBAG,
        REQUEST_PRINTF_FORMAT_CSV,
        REQUEST_RESET_QEI,
        REQUEST_RESET_MCU,
        COMMAND_NUMBER,
    };
}

/**メッセージ送信関数**/
void motordriverTransmitMessage(CAN *can,int id,int command,float data = 0.0f,bool option = false) {
    CANMessage message;
    message.id = id;
    message.data[0] = command; 
    message.data[1] = option;
    memcpy(message.data + 2 , &data,4);
    can->write(message);
}
#endif