#ifndef CAN_NETWORK_DEFINITION_2022_H
#define CAN_NETWORK_DEFINITION_2022_H
/************************************************識別子(CAN_ID)****************************************************/
namespace can_protcol {
    /***********デバイス型(0b000~0b111)***************/
    namespace device_type {
        enum DEVICE_TYPE_NUMBER {
            ALL_MCU                 =0b000,
            POWER_SUPPLY            =0b001,
            CONTROL_MCU             =0b010,
            MOTOR_DRIVER            =0b011,
            PC                      =0b100,
            SOLENOID_MCU            =0b101,
        };
    }
    /***********************************************/
    
    /*********各デバイス型の番号(0b000~0b1111)*********/
    namespace device_number {
        enum DEVICE_NUMBER {
            DEVICE_NUMBER           =0b1111,
        };   
    }
    /***********************************************/
    
    /******各デバイス型のデータタイプ(0b000~0b1111)*****/
    namespace data_type {
        namespace motor_driver {
            enum DATA_TYPE_NUMBER {
                DEBAG_MODE                  =0b0000,
                PARAMETER                   =0b0001,
                CONTROL_INFORMATION         =0b0010,
                STEER_CONTROL_INFORMATION   =0b0011,
                PRINTF_FORMAT               =0b0100,
                DATA_TYPE_NUMBER            =0b1111,
            }; 
        }
        
        namespace solenoid_driver {
            enum DATA_TYPE_NUMBER {
                DEBAG_MODE                  =0b0000,
                STATUS                      =0b0001,
                STATUS_OR                   =0b0010,
                STATUS_AND                  =0b0011,
                OPERATE_INDIVIDUAL_SOLENOID =0b0100,
                DATA_TYPE_NUMBER            =0b1111,
            }; 
        }
        
        namespace sensor_board {
            enum DATA_TYPE_NUMBER {
                DEBAG_MODE                  =0b0000,
                PARAMETER                   =0b0001,
                REQUEST                     =0b0010,
                DATA_TYPE_NUMBER            =0b1111,
            };   
        }
        
        namespace pc {
            enum DATA_TYPE_NUMBER {
                DEBAG_MODE                  =0b0000, 
                ERROR_STATE                 =0b0001,
                ODOMETORY                   =0b0010,
                VELOCITY                    =0b0011,
                ACCELERATION                =0b0100,
                ROBOT_STATE                 =0b0101,
                SENSOR                      =0b0110,
                DATA_TYPE_NUMBER            =0b1111, 
            };   
        }
        
        namespace control_mcu {
            enum DATA_TYPE_NUMBER {
                DEBAG_MODE                  =0b0000, 
                ERROR_STATE                 =0b0001,
                VELOCITY                    =0b0010,
                ODOMETORY_CORRECTION        =0b0011,
                OTHER_LEG_COMMAND           =0b0100,
                OTHER_COMMAND               =0b0101,
                SENSOR                      =0b0110,
                DATA_TYPE_NUMBER            =0b1111, 
            }; 
        }
    }
    /***********************************************/
}

/***********************************識別子(ID)を計算**********************************/
uint16_t calCanId(uint8_t device_type,uint8_t device_number,uint8_t data_type) {
    uint16_t id = 0;
    id = ((device_type << 8)|(device_number << 4)|(data_type));
    return id;
}
/************************************************************************************/

/*************************************IDより各種データを取得***************************/
uint8_t getCanIdData(uint16_t id,uint8_t use_parameter) {
    uint8_t value = 0;
    switch (use_parameter) {
        case 0:     //device_type
            value = ((id >> 8) & 0b111);
            break;
        case 1:     //device_number
            value = ((id >> 4) & 0b1111);
            break;
        case 2:     //data_type
            value = ((id >> 0) & 0b1111);
            break;
        default:
            break;
    }
    return value;   
}
/**************************************************************************************/

/****************************************************************************************************************/



/*
→MD_MCU DataFlame
namespace md_can_flame{
    enum command_number{
        SEND_KP,
        SEND_KI,
        SEND_KD,
        SEND_ACCELERATION,
        SEND_CONTROL_DUTY,
        SEND_CONTROL_RPM,
        REQUEST_RECEIVE_CURRENT,
        REQUEST_RECEIVE_ERROR,
        REQUEST_RECEIVE_POSITION,
        REQUEST_RECEIVE_ROTATION,
        REQUEST_RECEIVE_RPS,
        REQUEST_RECEIVE_RPM,
        REQUEST_PRINTF_DEBAG,
        REQUEST_PRINTF_FORMAT_CSV,
        REQUEST_RESET_QEI,
        REQUEST_RESET_MCU,
        COMMAND_NUMBER,
    };
}
*/
#endif