#include "buzzer.h"

buzzer::buzzer(PinName buzzerPin) : _buzzer(buzzerPin) {
    _buzzer = 0;
    _counter = 0;
    _setCount = 0;
    _timerFlag = 0;
    _loopFlag = 0;
}

void buzzer::output(unsigned int count,float period) {
    if(!(_timerFlag)) {
        _timer.attach(this,&buzzer::timerFunction,period);
        _timerFlag = true;
        _setCount = count;
    }
}

void buzzer::output(bool buzzerStates) {
    _timer.detach();
    _timerFlag = false;
    _buzzer = buzzerStates;
}

void buzzer::output(float period) {
    if(!(_timerFlag)) {
        _timer.attach(this,&buzzer::timerFunction,period);
        _timerFlag = true;
        //_setCount = count;
        _loopFlag = true;
    }
}

void buzzer::stop() {
    _timer.detach();
    _timerFlag = false;
    _buzzer = 0;
    _loopFlag = 0;
    _counter = 0;
}

void buzzer::timerFunction() {
    if(_loopFlag) {
        _buzzer =! _buzzer;
    } else {
        if(_counter < _setCount * 2) {
            _buzzer =! _buzzer;
            _counter++;
        } else {
            _buzzer = 0;
            _counter = 0;
            _timer.detach();
            _timerFlag = false;
        }  
    } 
}