#include "bitCommunication.h"
#include "mbed.h"

/************************************書き込み*****************************************/
/**変数にreturnするバージョン**/
int bitWrite(int data,int bitNumber,bool content) {
    int result;
    if(content) {
        result = data | (0b00000001 << bitNumber);
    } else {
        result = data & (~(0b00000001 << bitNumber));
    }
    return result;
}

/**アドレスを受け取って処理するバージョン**/
void bitWrite(int *dataAdress,int bitNumber,bool content) {
    if(content) {
        *dataAdress = *dataAdress | (0b00000001 << bitNumber);
    } else {
        *dataAdress = *dataAdress & (~(0b00000001 << bitNumber));
    }        
}

/**配列のアドレスを受け取って処理するバージョン**/
void bitWrite(int *dataArray,int arrayNumber,int bitNumber,bool content) {
    if(content) {
        dataArray[arrayNumber] =  dataArray[arrayNumber] | (0b00000001 << bitNumber);
    } else {
        dataArray[arrayNumber] = dataArray[arrayNumber] & (~(0b00000001 << bitNumber));
    }
}

/************************************読み込み******************************************/
/**指定したbitが0or1かをreturn**/
int bitRead(int data,int bitNumber) {
    int result=0;
    result = (data >> bitNumber) & 0b00000001;
    return result;
}