#ifndef SBUS_H
#define SBUS_H

#include "mbed.h"

class Sbus {
    public:
        Sbus(PinName tx,PinName rx);
        
        enum STICK_NUMBER {
            ANALOG_RX,
            ANALOG_RY,
            ANALOG_LX,
            ANALOG_LY,
            ANALOG_NUMBER,  
        };
        
        enum SWITCH_NUMBER {
            SW_A,
            SW_B,
            SW_C,
            SW_D,
            SW_E,
            SW_F,
            SW_G,  
            SW_H,
            VR,
            SWITCH_NUMBER,
        };
        
        enum SWITCH_POSITION {
            LOW,
            NEUTRAL,
            HIGH,
        };
        
        enum SBUS_STATUS {
            SBUS_SIGNAL_OK,
            SBUS_SIGNAL_LOST,
            SBUS_SIGNAL_FAILSAFE,
        };
        
        enum SBUS_CH_NUMBER {   
            CH5 = 4,
            CH6,
            CH7,
            CH8,
            CH9,
            CH10,            
        };
        
        void setup(int ch5,int ch6,int ch7,int ch8,int ch9,int ch10);
        
        float getStickValue(int ch);
        float getVolumeValue();
        int getSwitchValue(int ch);
        
        int getFailSafe();
        
        int getChannelValue(int ch);
    private:
        Serial com;
        Timer  receiveTimer;
        
        bool enableReceive;
        int failsafe;
        int stickMaximumValue;
        int stickNeutralValue;
        int stickMinimumValue;
        int stickResolution;
        float volumeValue;
        int channel[16];
        int receiveData[50];

        int swSelectData[6];

        int switchValue[12];
        float stickValue[ANALOG_NUMBER];
         
        
        void serialReceiveHandler();
        void decordReceiveData();
        void convertReceiveData();
        void resetAllData();
    
};

#endif