#include "fw_config.h"
#if SEL_I2C_3200_TEST == 1

#include "mbed.h"
#if SEL_I2C_SLAVE_MODE == 1

#else 

#endif

DigitalOut pin07  (P0_20);
DigitalOut pin12  (P0_21);
DigitalOut pin21  (P0_11);

#if SEL_I2C_SLAVE_MODE == 1
void i2c_3200 () {
    
    I2CSlave slave(P0_5 , P0_4);
    // indicate enter
    volatile int d = 0;
    for (int i = 0; i < 5; i++) {
        d = d > 0? 0:1;
        pin07 = d;
        pin12 = d;
        pin21 = d;
        wait(1);
    }
    pin07 = 1;
    pin12 = 1;
    pin21 = 1;
    //while (1);
    
    
    slave.address(0x60);
    char buf[2];
    
    while (1) {
        int i = slave.receive();
         switch (i) {
             case I2CSlave::ReadAddressed:
                 buf[1] = 'Z';
                 slave.write(buf, 1); // Includes null char
                 pin07 = 0;
                 pin12 = 1;
                 pin21 = 1;
                 break;
             case I2CSlave::WriteGeneral:
                 slave.read(buf, 10);
                 pin12 = 0;
                 pin07 = 1;
                 pin21 = 1;
                 printf("Read G: \n");
                 break;
             case I2CSlave::WriteAddressed:
                 slave.read(buf, 1);
                 pin21 = 0;
                 pin07 = 1;
                 pin12 = 1;
                 if (buf[0] != 0xaa) {
                     pin07 = 0;
                 }
                 wait(0.3);
                 pin21 = 1;
                 printf("Read A: %x, %x\n", buf[0], buf[1]);
                 break;
         }
         //for(int i = 0; i < 10; i++) buf[i] = 0;    // Clear buffer
    }
}
#else
void i2c_3200_master () {
    volatile int d = 0;
    for (int i = 0; i < 10; i++) {
        d = d > 0? 0:1;
        pin07 = d;
        pin12 = d;
        pin21 = d;
        wait(1);
    }
    pin07 = 1;
    pin12 = 1;
    pin21 = 1;
    I2C master(P0_5 , P0_4);
    char cmd[2];
    int err;
    master.frequency(400000);
    while (1) {
        cmd[0] = 0xAA;
        //cmd[1] = 0x01;
        err = master.write(0x60, cmd, 1);
        if (err)  pin07 = 0;
        wait(0.5);
 
        cmd[0] = 0xAA;
        //cmd[1] = 0x80;
        err = master.write(0x60, cmd, 1);
        if (err) pin12 = 0;
        wait(0.5);
        //slave.read(addr, cmd, 2);
 
        //float tmp = (float((cmd[0]<<8)|cmd[1]) / 256.0);
        //printf("Temp = %.2f\n", tmp);
    }
}    
#endif

#endif